/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.PassKeyListener;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.TimeoutObjectPool;
import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class GlobalAWTKeyEventListener
implements AWTEventListener {
    private volatile ScanCode scancode = new ScanCode();
    private volatile long scancodeMills = 0L;
    private static final int scancodeTimeout = 3000;
    private static GlobalAWTKeyEventListener intance = new GlobalAWTKeyEventListener();
    private ConcurrentLinkedQueue<PassKeyListener> passKeyListeners = new ConcurrentLinkedQueue();

    public void addPassKeyListener(PassKeyListener l) {
        this.passKeyListeners.offer(l);
    }

    public void removePassKeyListener(PassKeyListener l) {
        this.passKeyListeners.remove(l);
    }

    public Collection<PassKeyListener> getPassKeyListeners() {
        return this.passKeyListeners;
    }

    public static GlobalAWTKeyEventListener getInstance() {
        return intance;
    }

    private GlobalAWTKeyEventListener() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getClass() == KeyEvent.class) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.getID() == 400) {
                char keycar = keyEvent.getKeyChar();
                if (keycar == '0' || keycar == '1' || keycar == '2' || keycar == '3' || keycar == '4' || keycar == '5' || keycar == '6' || keycar == '7' || keycar == '8' || keycar == '9') {
                    long c = ServiceUtil.getServiceContext().currentTimeMillis();
                    long v1 = c - this.scancodeMills;
                    if (v1 < 0L || v1 > 3000L || this.scancode.isFull()) {
                        this.scancode.clear();
                        this.scancodeMills = c;
                    }
                    this.scancode.add(keycar);
                    if (this.scancode.length() >= 16 && ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)this.scancode) == null) {
                        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)this.scancode, (Object)this.scancode, (TimeoutObjectPool.TimeoutCallback)this.scancode, 500L, TimeUnit.MILLISECONDS);
                    }
                } else if (keycar == '\n') {
                    String scanCodeValue = this.scancode.pollCode();
                    this.scancodeMills = 0L;
                    if (scanCodeValue != null && scanCodeValue.length() >= 16 && scanCodeValue.length() <= 30) {
                        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this.scancode);
                        for (PassKeyListener l : this.passKeyListeners) {
                            l.onScanCodeFound(scanCodeValue);
                        }
                    }
                    for (PassKeyListener l : this.passKeyListeners) {
                        l.onPressEnter();
                    }
                } else {
                    int len = this.scancode.length();
                    if (len >= 16 || len <= 30) {
                        long c = ServiceUtil.getServiceContext().currentTimeMillis();
                        long v1 = c - this.scancodeMills;
                        if (this.scancodeMills > 0L && v1 > 0L && v1 <= 2500L) {
                            if (ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this.scancode) != null) {
                                try {
                                    this.scancode.onTimeout(this.scancode, this.scancode);
                                }
                                catch (Exception e) {
                                    this.scancode.clear();
                                    this.scancodeMills = 0L;
                                }
                            } else {
                                this.scancode.clear();
                                this.scancodeMills = 0L;
                            }
                        } else {
                            this.scancode.clear();
                            this.scancodeMills = 0L;
                        }
                    } else {
                        this.scancode.clear();
                        this.scancodeMills = 0L;
                    }
                }
            }
            for (PassKeyListener l : this.passKeyListeners) {
                l.onKeyEvent(keyEvent);
            }
        }
    }

    private class ScanCode
    implements TimeoutObjectPool.TimeoutCallback {
        private char[] buf = new char[32];
        private int index = 0;
        private final String emptryStr = "";

        private ScanCode() {
        }

        private synchronized int length() {
            return this.index;
        }

        private synchronized boolean isFull() {
            return this.index >= this.buf.length;
        }

        private synchronized boolean add(char c) {
            if (this.index < this.buf.length) {
                this.buf[this.index++] = c;
                return true;
            }
            return false;
        }

        public synchronized String toString() {
            if (this.index == 0) {
                return "";
            }
            return new String(this.buf, 0, this.index);
        }

        private synchronized void clear() {
            this.index = 0;
        }

        private synchronized String pollCode() {
            int len = this.index;
            String scanCodeValue = null;
            if (len >= 16 && len <= 30) {
                scanCodeValue = this.toString();
            }
            this.index = 0;
            if (scanCodeValue != null && scanCodeValue.length() > 0) {
                return scanCodeValue;
            }
            return null;
        }

        public void onTimeout(Object key, Object value) throws Exception {
            String scanCodeValue;
            if (this.length() >= 16 && (scanCodeValue = this.pollCode()) != null && scanCodeValue.length() > 16 && scanCodeValue.length() <= 30) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GlobalAWTKeyEventListener.this.scancodeMills = 0L;
                        if (scanCodeValue != null && scanCodeValue.length() >= 16 && scanCodeValue.length() <= 30) {
                            for (PassKeyListener l : GlobalAWTKeyEventListener.this.passKeyListeners) {
                                l.onScanCodeFound(scanCodeValue);
                            }
                        }
                        for (PassKeyListener l : GlobalAWTKeyEventListener.this.passKeyListeners) {
                            l.onPressEnter();
                        }
                    }
                });
            }
        }
    }
}

