/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkDutyNumber;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.gui.GlobalAWTKeyEventListener;
import com.wovoe.carpark.gui.GuiListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.login.CarparkLoginFrame;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.CarparkMainServerFrame;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.ServiceContext;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class GuiActivator {
    private CopyOnWriteArraySet<GuiListener> guiListeners = new CopyOnWriteArraySet();
    private static GlobalAWTKeyEventListener globalAWTKeyEventListener;
    private static boolean isSetUi;

    public Collection<GuiListener> getGuiListeners() {
        return this.guiListeners;
    }

    public void addGuiListener(GuiListener l) {
        this.guiListeners.add(l);
    }

    public void removeGuiListener(GuiListener l) {
        this.guiListeners.remove(l);
    }

    public void doStart(ServiceContext serviceContext, WindowListener windowListener, boolean realExitSystem) {
        if (globalAWTKeyEventListener == null) {
            globalAWTKeyEventListener = GlobalAWTKeyEventListener.getInstance();
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.addAWTEventListener(globalAWTKeyEventListener, 8L);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List ropList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"DISTINCT role_no AS role_no"}).addEQ("permission_no", (Object)("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
        HashSet<String> roleList = new HashSet<String>();
        if (ropList != null && !ropList.isEmpty()) {
            for (CarparkRolePermission r : ropList) {
                if (r.getRole_no() == null || r.getRole_no().length() <= 0) continue;
                roleList.add(r.getRole_no());
            }
        }
        roleList.add("1");
        ArrayList<CarparkUser> canLoginUserList = commonDaoService.selectList(new SearchParam().addINList("role_no", roleList).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no,user_code"), CarparkUser.class, null);
        if (canLoginUserList == null) {
            canLoginUserList = new ArrayList<CarparkUser>();
        }
        SearchParam p = new SearchParam().addEQ("login_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id);
        p.setOrerbySql("last_login_time DESC").setWhereString(" AND end_time IS NULL");
        Pagination page = new Pagination();
        page.setGotoPage(1);
        page.setNeedQueryCount(false);
        page.setRecordsCount(1L);
        page.setPageSize(1);
        CarparkDutyNumber dutyNumber = (CarparkDutyNumber)commonDaoService.selectOne(p, CarparkDutyNumber.class, page);
        String defaultUserCode = null;
        if (dutyNumber != null && dutyNumber.getEnd_time() == null && dutyNumber.getLogin_duty_user_code() != null && dutyNumber.getLogin_duty_user_code().length() > 0 && dutyNumber.getStart_time() != null) {
            CarparkUser user = null;
            if (canLoginUserList != null && !canLoginUserList.isEmpty()) {
                for (CarparkUser u : canLoginUserList) {
                    if (!dutyNumber.getLogin_duty_user_code().equals(u.getUser_code())) continue;
                    user = u;
                    break;
                }
            }
            if (user != null) {
                if (dutyNumber.getState() != null && dutyNumber.getState() == 0) {
                    boolean loginSuccess = false;
                    UserSession session = new UserSession(user);
                    session.setDutyNumber(dutyNumber);
                    CarparkRole role = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("role_no", (Object)user.getRole_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkRole.class, null);
                    if (role != null) {
                        List pList;
                        session.setRole(role);
                        if (!"1".equals(user.getRole_no()) && (pList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"permission_no"}).addEQ("role_no", (Object)user.getRole_no()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null)) != null && !pList.isEmpty()) {
                            HashSet<String> permissions = new HashSet<String>();
                            for (CarparkRolePermission p1 : pList) {
                                if (p1.getPermission_no() == null || p1.getPermission_no().length() <= 0) continue;
                                permissions.add(p1.getPermission_no());
                            }
                            session.setPermissions(permissions);
                        }
                        loginSuccess = true;
                    }
                    if (loginSuccess) {
                        ApplicationService appSerivce = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        appSerivce.setUserSession(session);
                        this.startMainUI(null, windowListener, realExitSystem);
                        return;
                    }
                } else {
                    defaultUserCode = user.getUser_code();
                }
            }
        }
        this.startLoginUI(null, windowListener, canLoginUserList, defaultUserCode, realExitSystem);
    }

    protected void startLoginUI(Dimension size, WindowListener windowListener, List<CarparkUser> userList, String selectUserCode, boolean realExitSystem) {
        CarparkLoginFrame.showWindow(size, windowListener, userList, selectUserCode, realExitSystem);
    }

    protected void startMainUI(Dimension size, WindowListener windowListener, boolean realExitSystem) {
        CarparkMainFrame.showWindow(size, windowListener, realExitSystem);
    }

    protected void setUIFont(Font font) {
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("ComboBoxItem.font", font);
        UIManager.put("InternalFrame.titleFont", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("PasswordFiled.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("FilePane.font", font);
        UIManager.put("CellRendererPane.font", font);
        UIManager.put("Component.font", font);
    }

    protected void doSetUI() {
        SwingUtil.setLookAndFeel(System.getProperty("LookAndFeel"));
        int font12Size = (int)Math.round(SwingUtil.getScreenSize().getHeight() * 10.0 / 768.0);
        String fontName = SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME);
        Font font = new Font(fontName, 0, font12Size);
        this.setUIFont(font);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    public void start(ServiceContext serviceContext) throws Exception {
        try {
            int hostUse;
            if (!isSetUi) {
                isSetUi = true;
                try {
                    if (!"false".equals(System.getProperty("startGui", "true"))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiActivator.this.doSetUI();
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ((hostUse = serviceContext.getCarparkLocalConfig().getHost_use().intValue()) == 1 || hostUse == 3) {
                this.doStart(serviceContext, new CloseSlashWindowListener(), true);
            } else if (hostUse == 2) {
                CarparkMainServerFrame.showWindow(null, new CloseSlashWindowListener());
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)ex.getMessage(), ex);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacOptionDialog.showAlertDialog(null, "\u7cfb\u7edf\u5f02\u5e38", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38\uff01\u539f\u56e0:" + ex.getMessage(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceUtil.getServiceContext().exitSystem(null);
                        }
                    }, null);
                }
            });
        }
    }

    public void stop(ServiceContext serviceContext) throws Exception {
        for (GuiListener l : this.guiListeners) {
            try {
                l.onSystemExit();
            }
            catch (Exception ex) {
                GuiLog.getLog().warn((Object)"", (Throwable)ex);
            }
        }
    }

    private static final class CloseSlashWindowListener
    extends WindowAdapter {
        private CloseSlashWindowListener() {
        }
    }
}

