/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.XYPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;

public class ImagePanel
extends XYPanel {
    private static final long serialVersionUID = 6624987874655618101L;
    private Entry entry;

    public ImagePanel() {
    }

    public ImagePanel(ImageIcon bgImg) {
        this(bgImg, BgImgOption.NO_REPEAT);
    }

    public ImagePanel(ImageIcon bgImg, BgImgOption BgImgOption2) {
        this(bgImg, BgImgOption2, 0, 0, 0, 0);
    }

    public ImagePanel(ImageIcon bgImg, BgImgOption bgImgOption, int wx, int wy, int dx, int dy) {
        this.entry = new Entry(bgImg, bgImgOption, wx, wy, dx, dy);
    }

    public ImageIcon getImageIcon() {
        Entry e = this.entry;
        return e == null ? null : e.bgImg;
    }

    public void setImageIcon(ImageIcon icon) {
        if (this.entry == null) {
            this.entry = new Entry(icon, BgImgOption.NO_REPEAT, 0, 0, 0, 0);
        } else {
            this.entry.bgImg = icon;
        }
    }

    public void setBgImgOption(BgImgOption op) {
        if (this.entry == null) {
            this.entry = new Entry(null, op, 0, 0, 0, 0);
        } else {
            this.entry.bgImgOption = op;
        }
    }

    public BgImgOption getBgImgOption() {
        Entry e = this.entry;
        return e == null ? null : e.bgImgOption;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.entry != null && this.entry.bgImg != null) {
            this.entry.cx = this.getWidth();
            this.entry.cy = this.getHeight();
            int pw = this.entry.pdx - this.entry.psx;
            int ph = this.entry.pdy - this.entry.psy;
            if (this.entry.bgImgOption == BgImgOption.NO_REPEAT) {
                if (this.entry.psx <= 0 && this.entry.psy <= 0) {
                    g.drawImage(this.entry.bgImg.getImage(), 0, 0, null);
                } else {
                    g.drawImage(this.entry.bgImg.getImage(), 0, 0, pw, ph, this.entry.psx, this.entry.psy, this.entry.pdx, this.entry.pdy, null);
                }
            } else if (this.entry.bgImgOption == BgImgOption.REPEAT) {
                int i = 0;
                while (i < this.entry.cx) {
                    int j = 0;
                    while (j < this.entry.cy) {
                        if (this.entry.psx <= 0 && this.entry.psy <= 0) {
                            g.drawImage(this.entry.bgImg.getImage(), i, j, null);
                        } else {
                            g.drawImage(this.entry.bgImg.getImage(), i, j, i + pw, j + ph, this.entry.psx, this.entry.psy, this.entry.pdx, this.entry.pdy, null);
                        }
                        j += ph;
                    }
                    i += pw;
                }
            } else if (this.entry.bgImgOption == BgImgOption.REPEAT_X) {
                int wi = 0;
                while (wi < this.entry.cx) {
                    if (this.entry.psx <= 0 && this.entry.psy <= 0) {
                        g.drawImage(this.entry.bgImg.getImage(), wi, 0, null);
                    } else {
                        g.drawImage(this.entry.bgImg.getImage(), wi, 0, wi + pw, this.entry.pdy - this.entry.psy, this.entry.psx, this.entry.psy, this.entry.pdx, this.entry.pdy, null);
                    }
                    wi += this.entry.pdx - this.entry.psx;
                }
            } else if (this.entry.bgImgOption == BgImgOption.REPEAT_Y) {
                int wj = 0;
                while (wj < this.entry.cy) {
                    if (this.entry.psx <= 0 && this.entry.psy <= 0) {
                        g.drawImage(this.entry.bgImg.getImage(), 0, wj, null);
                    } else {
                        g.drawImage(this.entry.bgImg.getImage(), 0, wj, this.entry.pdx - this.entry.psx, wj + ph, this.entry.psx, this.entry.psy, this.entry.pdx, this.entry.pdy, null);
                    }
                    wj += this.entry.pdy - this.entry.psy;
                }
            } else if (this.entry.bgImgOption == BgImgOption.STRETCH) {
                float wid = this.entry.cx;
                float hei = this.entry.cy;
                int iconWid = this.entry.bgImg.getIconWidth();
                int iconHei = this.entry.bgImg.getIconHeight();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.scale(wid / (float)iconWid, hei / (float)iconHei);
                g2d.drawImage(this.entry.bgImg.getImage(), 0, 0, this);
            }
        }
    }

    public static enum BgImgOption {
        REPEAT,
        NO_REPEAT,
        REPEAT_X,
        REPEAT_Y,
        STRETCH;

    }

    private static class Entry {
        private ImageIcon bgImg;
        private BgImgOption bgImgOption;
        private int psx;
        private int psy;
        private int pdx;
        private int pdy;
        private int cx = -1;
        private int cy = -1;

        private Entry(Entry x) {
            if (x != null) {
                this.bgImg = x.bgImg;
                this.bgImgOption = x.bgImgOption;
                this.psx = x.psx;
                this.psy = x.psy;
                this.pdx = x.pdx;
                this.pdy = x.pdy;
                this.cx = x.cx;
                this.cy = x.cy;
            }
        }

        private Entry(ImageIcon bgImg, BgImgOption bgImgOption, int wx, int wy, int dx, int dy) {
            this.bgImg = bgImg;
            this.bgImgOption = bgImgOption;
            if (this.bgImgOption == null) {
                this.bgImgOption = BgImgOption.NO_REPEAT;
            }
            this.psx = wx;
            this.psy = wy;
            this.pdx = dx;
            if (this.pdx == 0 && this.bgImg != null) {
                this.pdx = this.bgImg.getIconWidth();
            }
            this.pdy = dy;
            if (this.pdy == 0 && this.bgImg != null) {
                this.pdy = this.bgImg.getIconHeight();
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bgImg == null ? 0 : this.bgImg.hashCode());
            result = 31 * result + (this.bgImgOption == null ? 0 : this.bgImgOption.hashCode());
            result = 31 * result + this.cx;
            result = 31 * result + this.cy;
            result = 31 * result + this.pdx;
            result = 31 * result + this.pdy;
            result = 31 * result + this.psx;
            result = 31 * result + this.psy;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.bgImg == null ? other.bgImg != null : !this.bgImg.equals(other.bgImg)) {
                return false;
            }
            if (this.bgImgOption != other.bgImgOption) {
                return false;
            }
            if (this.cx != other.cx) {
                return false;
            }
            if (this.cy != other.cy) {
                return false;
            }
            if (this.pdx != other.pdx) {
                return false;
            }
            if (this.pdy != other.pdy) {
                return false;
            }
            if (this.psx != other.psx) {
                return false;
            }
            return this.psy == other.psy;
        }
    }
}

