/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.sun.awt.AWTUtilities;
import com.wovoe.carpark.gui.DialogDisponseListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.skin.DefaultCarparkGuiSkin;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class MacDialog
extends JDialog {
    private static final long serialVersionUID = -3603740086675563225L;
    protected JPanel rootPanel;
    protected SpringLayout rootPanelLayout;
    protected JLabel titleLabel = new JLabel();
    protected MacTitlePannel titlePanel;
    protected JPanel bodyPanel = new JPanel();
    private volatile boolean isMoveDragged = false;
    private volatile Point loc = null;
    private volatile Point tmp = null;
    private volatile AtomicBoolean inited = new AtomicBoolean(false);
    protected JLabel closeLabel;
    private CopyOnWriteArrayList<DialogDisponseListener> disponseListener = new CopyOnWriteArrayList();
    private Icon closeImageRedIcon;
    private Icon closeImageBlackIcon;

    public int getTitileBarHeight() {
        Dimension screenSize = SwingUtil.getScreenSize();
        int titileBarHeight = (int)Math.round(0.04111111111111111 * (double)screenSize.height);
        return titileBarHeight;
    }

    public MacDialog() {
    }

    public MacDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public MacDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public MacDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    public JPanel getBody() {
        return this.bodyPanel;
    }

    public void addDialogDisponseListener(DialogDisponseListener l) {
        this.disponseListener.add(l);
    }

    public void removeDialogDisponseListener(DialogDisponseListener l) {
        this.disponseListener.remove(l);
    }

    public List<DialogDisponseListener> getDialogDisponseListeners() {
        return this.disponseListener;
    }

    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
    }

    protected void setTitle(int titleHeight) {
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setForeground(Color.BLACK);
        int fontSize = this.getTitleFontSize(titleHeight);
        this.titleLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 1, fontSize));
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)this.titleLabel, "Center");
    }

    protected int getTitleFontSize(int titleHeight) {
        return (int)Math.round(0.43243243243243246 * (double)titleHeight);
    }

    public static BufferedImage newImage(String imgName, int rImageHieght) {
        BufferedImage image;
        block5: {
            URL url;
            block4: {
                try {
                    url = DefaultCarparkGuiSkin.getImageUrlFromClassPath(imgName, null);
                    if (url != null) break block4;
                    return null;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            image = ImageIO.read(url);
            if (image != null) break block5;
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int rWidth = width * rImageHieght / height;
        return SwingUtil.resizeImage(image, rWidth, rImageHieght);
    }

    protected void showCloseButton(int titleHeight) {
        JLabel closeLabel = new JLabel();
        int imageHeight = (int)Math.round(0.34285714285714286 * (double)titleHeight);
        BufferedImage closeImageRed = MacDialog.newImage("close_red", imageHeight);
        BufferedImage closeImageBlack = MacDialog.newImage("close_black", imageHeight);
        if (closeImageRed != null && closeImageBlack != null) {
            this.closeImageRedIcon = new ImageIcon(closeImageRed);
            this.closeImageBlackIcon = new ImageIcon(closeImageBlack);
            closeLabel.setIcon(this.closeImageBlackIcon);
            closeLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, imageHeight));
            closeLabel.setText("   ");
        } else {
            int fontSize = (int)Math.round(0.6285714285714286 * (double)titleHeight);
            closeLabel.setText("  \u3128 ");
            closeLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
            closeLabel.setForeground(new Color(237, 120, 118));
        }
        closeLabel.setCursor(new Cursor(12));
        closeLabel.setToolTipText("\u70b9\u51fb\u5173\u95ed\u7a97\u4f53");
        this.titlePanel.add((Component)closeLabel, "East");
        closeLabel.addMouseListener(new MouseAdapter(){
            Color rcl = new Color(237, 120, 118);

            @Override
            public void mouseClicked(MouseEvent e) {
                MacDialog.this.dispose();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (MacDialog.this.closeImageRedIcon != null && MacDialog.this.closeImageBlackIcon != null) {
                    ((JLabel)e.getSource()).setIcon(MacDialog.this.closeImageRedIcon);
                } else {
                    Color cl = ((Component)e.getSource()).getForeground();
                    Color chageC = Color.RED;
                    if (cl == null || !chageC.equals(cl)) {
                        ((Component)e.getSource()).setForeground(chageC);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (MacDialog.this.closeImageRedIcon != null && MacDialog.this.closeImageBlackIcon != null) {
                    ((JLabel)e.getSource()).setIcon(MacDialog.this.closeImageBlackIcon);
                } else {
                    Color cl = ((Component)e.getSource()).getForeground();
                    Color chageC = this.rcl;
                    if (cl == null || !chageC.equals(cl)) {
                        ((Component)e.getSource()).setForeground(chageC);
                    }
                }
            }
        });
    }

    protected void onDispose() {
    }

    @Override
    public void dispose() {
        try {
            this.onDispose();
        }
        finally {
            try {
                for (DialogDisponseListener l : this.disponseListener) {
                    try {
                        l.onDispose(this);
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            finally {
                super.dispose();
            }
        }
    }

    public void setTitleInfo(final String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MacDialog.this.setTitleInfo0(title);
                }
            });
        } else {
            this.setTitleInfo0(title);
        }
    }

    private void setTitleInfo0(String title) {
        String t = this.titleLabel.getText();
        if (t == null) {
            t = "";
        }
        if (title == null) {
            title = "";
        }
        if (!t.equals(title)) {
            this.titleLabel.setText(title);
        }
    }

    public void init(Dimension size, Component c) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.setUndecorated(true);
        this.setResizable(false);
        this.setCursor(new Cursor(0));
        this.setSize(size);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 20.0, 20.0);
        AWTUtilities.setWindowShape((Window)this, (Shape)shape);
        this.rootPanel = new JPanel();
        this.rootPanel.setBackground(new Color(236, 236, 236));
        this.getContentPane().add(this.rootPanel);
        this.getRootPane().setForeground(new Color(236, 236, 236));
        this.rootPanelLayout = new SpringLayout();
        this.rootPanel.setLayout(this.rootPanelLayout);
        SpringLayout.Constraints panelCons = this.rootPanelLayout.getConstraints(this.rootPanel);
        this.titlePanel = new MacTitlePannel();
        this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(193, 192, 193)));
        this.rootPanel.add(this.titlePanel);
        this.addDragable(this.titlePanel);
        SpringLayout.Constraints t1 = this.rootPanelLayout.getConstraints(this.titlePanel);
        int titileBarHeight = this.getTitileBarHeight();
        this.setTitle(titileBarHeight);
        t1.setHeight(Spring.constant(titileBarHeight));
        t1.setX(Spring.constant(0));
        t1.setY(Spring.constant(0));
        panelCons.setConstraint("East", Spring.sum(t1.getConstraint("East"), Spring.constant(0)));
        this.bodyPanel.setBackground(this.rootPanel.getBackground());
        this.rootPanel.add(this.bodyPanel);
        SpringLayout.Constraints t2 = this.rootPanelLayout.getConstraints(this.bodyPanel);
        t2.setHeight(Spring.constant(size.height - titileBarHeight));
        t2.setX(Spring.constant(0));
        t2.setY(Spring.constant(titileBarHeight));
        t2.setWidth(Spring.constant(size.width));
        this.init0(this.bodyPanel, new Dimension(size.width, size.height - titileBarHeight), c);
        Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
        if (logo != null) {
            this.setIconImage(logo);
        }
        if (c != null) {
            this.setLocationRelativeTo(c);
        } else {
            Dimension size0 = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (size0.width - size.width) / 2;
            int y = (size0.height - size.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
        }
    }

    private void addDragable(Component c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean a = MacDialog.this.isMoveDragged;
                MacDialog.this.isMoveDragged = false;
                if (MacDialog.this.getCursor().getType() == 13) {
                    MacDialog.this.setCursor(new Cursor(0));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (MacDialog.this.getCursor() == null || MacDialog.this.getCursor().getType() == 0) {
                    MacDialog.this.tmp = new Point(e.getX(), e.getY());
                    MacDialog.this.isMoveDragged = true;
                    MacDialog.this.setCursor(new Cursor(13));
                }
            }
        });
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MacDialog.this.isMoveDragged) {
                    MacDialog.this.loc = new Point(MacDialog.this.getLocation().x + e.getX() - ((MacDialog)MacDialog.this).tmp.x, MacDialog.this.getLocation().y + e.getY() - ((MacDialog)MacDialog.this).tmp.y);
                    MacDialog.this.setLocation(MacDialog.this.loc);
                }
            }
        });
    }

    protected static class MacTitlePannel
    extends JPanel {
        private static final long serialVersionUID = 2025164943829413628L;
        private static final Color color = new Color(231, 229, 231);
        private static final Color color1 = new Color(209, 207, 209);

        protected MacTitlePannel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g1 = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, color, 0.0f, height, color1);
            g1.setPaint(paint);
            g1.fillRect(0, 0, width, height);
        }
    }
}

