/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.sun.awt.AWTUtilities;
import com.wovoe.carpark.gui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class MacFrame
extends JFrame {
    private static final long serialVersionUID = -565138192095854826L;
    protected JPanel rootPanel;
    protected SpringLayout rootPanelLayout;
    protected JLabel titleLabel;
    protected MacTitlePannel titlePanel;
    protected int titileBarHeight = 37;
    private volatile boolean isMoveDragged = false;
    private volatile Point loc = null;
    private volatile Point tmp = null;
    private volatile AtomicBoolean inited = new AtomicBoolean(false);

    protected void init0(Dimension size, Component c) {
    }

    private void setTitle(Dimension size) {
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setForeground(new Color(80, 80, 80));
        this.titleLabel.setFont(new Font("Serif", 1, 14));
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)this.titleLabel, "Center");
    }

    public void init(Dimension size, Component c) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.setUndecorated(true);
        this.setCursor(new Cursor(0));
        this.setSize(size);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 20.0, 20.0);
        AWTUtilities.setWindowShape((Window)this, (Shape)shape);
        this.rootPanel = new JPanel();
        this.rootPanel.setBackground(new Color(236, 236, 236));
        this.getContentPane().add(this.rootPanel);
        this.getRootPane().setForeground(new Color(236, 236, 236));
        this.rootPanelLayout = new SpringLayout();
        this.rootPanel.setLayout(this.rootPanelLayout);
        SpringLayout.Constraints panelCons = this.rootPanelLayout.getConstraints(this.rootPanel);
        this.titlePanel = new MacTitlePannel();
        this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(193, 192, 193)));
        this.rootPanel.add(this.titlePanel);
        this.addDragable(this.titlePanel);
        SpringLayout.Constraints t1 = this.rootPanelLayout.getConstraints(this.titlePanel);
        this.setTitle(size);
        t1.setHeight(Spring.constant(this.titileBarHeight));
        t1.setX(Spring.constant(0));
        t1.setY(Spring.constant(0));
        panelCons.setConstraint("East", Spring.sum(t1.getConstraint("East"), Spring.constant(0)));
        this.init0(size, c);
        if (c != null) {
            this.setLocationRelativeTo(c);
        } else {
            Dimension size0 = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (size0.width - size.width) / 2;
            int y = (size0.height - size.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
        }
    }

    private void addDragable(Component c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean a = MacFrame.this.isMoveDragged;
                MacFrame.this.isMoveDragged = false;
                if (MacFrame.this.getCursor().getType() == 13) {
                    MacFrame.this.setCursor(new Cursor(0));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (MacFrame.this.getCursor() == null || MacFrame.this.getCursor().getType() == 0) {
                    MacFrame.this.tmp = new Point(e.getX(), e.getY());
                    MacFrame.this.isMoveDragged = true;
                    MacFrame.this.setCursor(new Cursor(13));
                }
            }
        });
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MacFrame.this.isMoveDragged) {
                    MacFrame.this.loc = new Point(MacFrame.this.getLocation().x + e.getX() - ((MacFrame)MacFrame.this).tmp.x, MacFrame.this.getLocation().y + e.getY() - ((MacFrame)MacFrame.this).tmp.y);
                    MacFrame.this.setLocation(MacFrame.this.loc);
                }
            }
        });
    }

    public static void main(String[] args) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtil.setLookAndFeel("Nimbus");
                MacFrame f = new MacFrame();
                f.init(new Dimension(668, 400), null);
                f.setAlwaysOnTop(false);
                f.setResizable(true);
                f.setVisible(true);
            }
        });
    }

    protected static class MacTitlePannel
    extends JPanel {
        private static final long serialVersionUID = 1393805536714092983L;
        private static final Color color = new Color(231, 229, 231);
        private static final Color color1 = new Color(209, 207, 209);

        protected MacTitlePannel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g1 = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, color, 0.0f, height, color1);
            g1.setPaint(paint);
            g1.fillRect(0, 0, width, height);
        }
    }
}

