/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SampleScrollBarUI;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MacOptionDialog
extends MacDialog {
    private static final long serialVersionUID = -364059810689901455L;
    public JButton closeButton;
    public JButton okButton;
    private Runnable closeRun;
    private Runnable okRun;
    private Dimension screenSize = SwingUtil.getScreenSize();
    private JTextArea console = new JTextArea();

    public MacOptionDialog() {
    }

    public MacOptionDialog(Frame owner, String title, boolean modal) {
        super(owner, null, modal);
        if (title != null) {
            this.titleLabel.setText(title);
        }
    }

    public MacOptionDialog(Window owner, String title, boolean modal) {
        super(owner, null, modal);
        if (title != null) {
            this.titleLabel.setText(title);
        }
    }

    public MacOptionDialog(Dialog owner, String title, boolean modal) {
        super(owner, null, modal);
        if (title != null) {
            this.titleLabel.setText(title);
        }
    }

    public JTextArea getContentArea() {
        return this.console;
    }

    @Override
    protected void init0(JPanel body, Dimension bodySize, Component parentComponent) {
        int topx;
        int rightButtonX;
        String okButtonText;
        int closeButtonWidth;
        body.setLayout(new XYLayout());
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MacOptionDialog.this.dispose();
                }
                finally {
                    if (MacOptionDialog.this.closeRun != null) {
                        MacOptionDialog.this.closeRun.run();
                    }
                }
            }
        });
        int butonfontSize = (int)Math.round(0.014473684210526316 * (double)this.screenSize.height);
        Font fontButton = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, butonfontSize);
        String closeButtonText = this.closeButton.getText();
        if (closeButtonText == null || closeButtonText.length() == 0) {
            closeButtonText = "\u5173\u95ed";
        }
        closeButtonText = String.valueOf(closeButtonText) + "\u4f60\u597d\u4f60\u597d\u597d";
        int okButtonWidth = closeButtonWidth = SwingUtil.getStringFontSize((String)closeButtonText, (Font)fontButton).width;
        if (this.okButton != null && (okButtonText = this.okButton.getText()) != null && okButtonText.length() > 0 && (okButtonText = String.valueOf(okButtonText) + "\u4f60\u597d\u4f60\u597d\u597d").length() != closeButtonText.length()) {
            okButtonWidth = SwingUtil.getStringFontSize((String)okButtonText, (Font)fontButton).width;
        }
        int rightButtonHight = (int)Math.round(0.027777777777777776 * (double)this.screenSize.height);
        this.closeButton.setCursor(new Cursor(12));
        this.closeButton.setFont(fontButton);
        this.closeButton.setForeground(new Color(38, 38, 38));
        this.closeButton.setBackground(new Color(239, 239, 239));
        this.closeButton.setRolloverEnabled(false);
        int buttonButtom = (int)Math.round(0.022222222222222223 * (double)this.screenSize.height);
        int buttonRight = (int)Math.round(0.015625 * (double)this.screenSize.width);
        int rightButtonY = bodySize.height - rightButtonHight - buttonButtom;
        if (this.okButton == null) {
            rightButtonX = bodySize.width - closeButtonWidth - buttonRight;
            body.add((Component)this.closeButton, new XYConstraints(rightButtonX, rightButtonY, closeButtonWidth, rightButtonHight));
        } else {
            this.okButton.setCursor(new Cursor(12));
            this.okButton.setFont(fontButton);
            this.okButton.setForeground(new Color(255, 255, 255));
            this.okButton.setBackground(new Color(20, 138, 224));
            this.okButton.setRolloverEnabled(false);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MacOptionDialog.this.dispose();
                    }
                    finally {
                        if (MacOptionDialog.this.okRun != null) {
                            MacOptionDialog.this.okRun.run();
                        }
                    }
                }
            });
            rightButtonX = bodySize.width - okButtonWidth - buttonRight;
            body.add((Component)this.okButton, new XYConstraints(rightButtonX, rightButtonY, okButtonWidth, rightButtonHight));
            int buttongrap = (int)Math.round(0.0078125 * (double)this.screenSize.width);
            body.add((Component)this.closeButton, new XYConstraints(rightButtonX - closeButtonWidth - buttongrap, rightButtonY, closeButtonWidth, rightButtonHight));
        }
        Color cl = body.getBackground();
        if (cl != null) {
            this.console.setBorder(BorderFactory.createEmptyBorder());
            this.console.setBackground(cl);
        }
        this.console.setForeground(Color.decode("#2b425b"));
        int fontSize = (int)Math.round(0.016927083333333332 * (double)this.screenSize.height);
        this.console.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        this.console.setLineWrap(true);
        this.console.setEditable(false);
        this.console.setCursor(new Cursor(0));
        int leftx = topx = (int)Math.round(0.010526315789473684 * (double)this.screenSize.height);
        JScrollPane scrollPane = new JScrollPane(this.console, 20, 31);
        if (cl != null) {
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setBackground(cl);
            scrollPane.setCursor(new Cursor(0));
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            scrollBar.setUI(new SampleScrollBarUI(this.getBackground(), Color.decode("#DBD9DB"), Color.decode("#FAFAFA"), this.screenSize));
        }
        int widthx = bodySize.width - 2 * leftx;
        int heighty = rightButtonY - 2 * topx;
        body.add((Component)scrollPane, new XYConstraints(leftx, topx, widthx, heighty));
        scrollPane.setPreferredSize(new Dimension(widthx, heighty));
    }

    public static MacOptionDialog showAlertDialog(Component parentComponent, String titile, String msg, Runnable colseClick, String closeButonText) {
        return MacOptionDialog.showAlertDialog(parentComponent, titile, msg, colseClick, closeButonText, null);
    }

    private static Dimension getDialogSize(String msg, Dimension screenSize) {
        int minDialogHeight = (int)Math.round(0.24444444444444444 * (double)screenSize.height);
        int minDialogWidth = (int)Math.round(0.28125 * (double)screenSize.width);
        if (msg == null || msg.length() == 0) {
            return new Dimension(minDialogWidth, minDialogHeight);
        }
        int maxContentWidth = (int)Math.round(0.3515625 * (double)screenSize.width);
        int minContentHeight = (int)Math.round(0.12666666666666668 * (double)screenSize.height);
        int minContentWidth = (int)Math.round(0.26796875 * (double)screenSize.width);
        String[] ar = msg.split("\\n");
        int fontSize = (int)Math.round(0.016927083333333332 * (double)screenSize.height);
        Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        int oneLineHeight = SwingUtil.getStringFontSize((String)"\u4f60", (Font)font).height;
        int fontTotalHeight = 0;
        int fontTotalWidth = minContentWidth;
        int i = 0;
        while (i < ar.length) {
            String str = ar[i];
            if (str.length() == 0) {
                fontTotalHeight += oneLineHeight;
            } else {
                Dimension d1 = SwingUtil.getStringFontSize(String.valueOf(str) + " ", font);
                if (d1.width <= maxContentWidth) {
                    fontTotalHeight += d1.height;
                    if (d1.width > fontTotalWidth) {
                        fontTotalWidth = d1.width;
                    }
                } else {
                    if (fontTotalWidth != maxContentWidth) {
                        fontTotalWidth = maxContentWidth;
                    }
                    int linex = d1.width % maxContentWidth == 0 ? d1.width / maxContentWidth : d1.width / maxContentWidth + 1;
                    fontTotalHeight += linex * d1.height;
                }
            }
            ++i;
        }
        if (fontTotalHeight > minContentHeight) {
            int nHeight = (int)Math.round((double)minDialogHeight / (double)minContentHeight * (double)fontTotalHeight);
            if (nHeight > screenSize.height - 200) {
                nHeight = screenSize.height - 200;
            }
            minDialogHeight = nHeight;
        }
        if (fontTotalWidth > minContentWidth) {
            int hWidth;
            minDialogWidth = hWidth = (int)Math.round((double)minDialogWidth / (double)minContentWidth * (double)fontTotalWidth);
        }
        return new Dimension(minDialogWidth, minDialogHeight);
    }

    public static MacOptionDialog showAlertDialog(Component parentComponent, String titile, String msg, Runnable colseClick, String closeButonText, Color bgColor) {
        return MacOptionDialog.showAlertDialog(parentComponent, titile, msg, colseClick, closeButonText, bgColor, true);
    }

    public static MacOptionDialog showAlertDialog(Component parentComponent, String titile, String msg, Runnable colseClick, String closeButonText, Color bgColor, boolean model) {
        Window window = SwingUtil.getWindowForComponent(parentComponent);
        MacOptionDialog dialog = window instanceof Frame ? new MacOptionDialog((Frame)window, titile, model) : (window instanceof Dialog ? new MacOptionDialog((Dialog)window, titile, model) : (window instanceof Window ? new MacOptionDialog(window, titile, model) : new MacOptionDialog()));
        if (closeButonText == null || closeButonText.length() == 0) {
            closeButonText = "\u5173\u95ed";
        }
        dialog.closeRun = colseClick;
        dialog.closeButton = new JButton(closeButonText);
        dialog.closeButton.setBackground(Color.decode("#FAFAFA"));
        dialog.closeButton.setRolloverEnabled(false);
        Dimension screenSize = dialog.screenSize;
        dialog.init(MacOptionDialog.getDialogSize(msg, screenSize), parentComponent);
        if (msg != null) {
            dialog.console.setText(msg);
        }
        if (bgColor != null) {
            dialog.console.setBackground(bgColor);
            dialog.bodyPanel.setBackground(bgColor);
        }
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        return dialog;
    }

    public static MacOptionDialog showConfirmDialog(Component parentComponent, String titile, String msg, Runnable cancelClick, String cancelButonText, Runnable okClick, String okButonText) {
        return MacOptionDialog.showConfirmDialog(parentComponent, titile, msg, cancelClick, cancelButonText, okClick, okButonText, null);
    }

    public static MacOptionDialog showConfirmDialog(Component parentComponent, String titile, String msg, Runnable cancelClick, String cancelButonText, Runnable okClick, String okButonText, Color bgColor) {
        Window window = SwingUtil.getWindowForComponent(parentComponent);
        MacOptionDialog dialog = window instanceof Frame ? new MacOptionDialog((Frame)window, titile, true) : (window instanceof Dialog ? new MacOptionDialog((Dialog)window, titile, true) : (window instanceof Window ? new MacOptionDialog(window, titile, true) : new MacOptionDialog()));
        if (cancelButonText == null || cancelButonText.length() == 0) {
            cancelButonText = "\u53d6\u6d88";
        }
        dialog.closeRun = cancelClick;
        dialog.closeButton = new JButton(cancelButonText);
        dialog.closeButton.setBackground(Color.decode("#FAFAFA"));
        dialog.closeButton.setRolloverEnabled(false);
        if (okButonText == null || okButonText.length() == 0) {
            okButonText = "\u786e\u5b9a";
        }
        dialog.okRun = okClick;
        dialog.okButton = new JButton(okButonText);
        dialog.okButton.setBackground(Color.decode("#38A0F4"));
        dialog.okButton.setForeground(Color.WHITE);
        dialog.okButton.setRolloverEnabled(false);
        Dimension screenSize = dialog.screenSize;
        dialog.init(MacOptionDialog.getDialogSize(msg, screenSize), parentComponent);
        if (msg != null) {
            dialog.console.setText(msg);
        }
        if (bgColor != null) {
            dialog.console.setBackground(bgColor);
            dialog.bodyPanel.setBackground(bgColor);
        }
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        return dialog;
    }
}

