/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.sun.awt.AWTUtilities;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class MessageTipDialog
extends JDialog {
    private static final long serialVersionUID = -8755439957248916446L;
    public static final int PLAIN = 1;
    private static Color planBgColor = new Color(106, 181, 241);
    public static final int INFORMATION = 2;
    private static Color infoBgColor = new Color(27, 199, 220);
    public static final int WARNING = 3;
    private static Color warnBgColor = new Color(213, 166, 96);
    public static final int ERROR = 4;
    private static Color errorBgColor = new Color(237, 120, 118);
    private Dimension screenSize;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private static Icon closeIcon;
    private ScheduledFuture<?> delayHandler;
    private Runnable disposeRunnabe;

    public static MessageTipDialog newInstance(Component parentComponent, String message, int messageType, int width, int maxHeight, Dimension screenSize) {
        Window window = SwingUtil.getWindowForComponent(parentComponent);
        MessageTipDialog dialog = window instanceof Frame ? new MessageTipDialog((Frame)window, "", false) : new MessageTipDialog((Dialog)window, "", false);
        dialog.screenSize = screenSize;
        dialog.setUndecorated(true);
        dialog.setResizable(false);
        dialog.setCursor(new Cursor(0));
        dialog.init(message, messageType, width, maxHeight);
        return dialog;
    }

    public Runnable getDisposeRunnabe() {
        return this.disposeRunnabe;
    }

    public void setDisposeRunnabe(Runnable disposeRunnabe) {
        this.disposeRunnabe = disposeRunnabe;
    }

    public MessageTipDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public MessageTipDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public static Color getBgColor(int messageType) {
        Color c;
        switch (messageType) {
            case 1: {
                c = planBgColor;
                break;
            }
            case 2: {
                c = infoBgColor;
                break;
            }
            case 3: {
                c = warnBgColor;
                break;
            }
            case 4: {
                c = errorBgColor;
                break;
            }
            default: {
                c = planBgColor;
            }
        }
        return c;
    }

    public static Color getFontColor(int messageType) {
        return Color.WHITE;
    }

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            try {
                if (this.delayHandler != null) {
                    this.delayHandler.cancel(true);
                    this.delayHandler = null;
                }
            }
            finally {
                try {
                    super.dispose();
                }
                finally {
                    if (this.disposeRunnabe != null) {
                        this.disposeRunnabe.run();
                        this.disposeRunnabe = null;
                    }
                }
            }
        }
    }

    public boolean isDiposed() {
        return this.disposed.get();
    }

    public void setDelayHandle(ScheduledFuture<?> delayHandler) {
        this.delayHandler = delayHandler;
    }

    private void init(String message, int messageType, int width, int maxHeight) {
        if (this.screenSize == null) {
            this.screenSize = SwingUtil.getScreenSize();
        }
        if (message == null) {
            message = "";
        }
        message = message.replaceAll("\\n", "");
        int roudSize = (int)Math.round(this.screenSize.getHeight() * 18.0 / 768.0);
        int topHeight = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int marglr = (int)Math.round(this.screenSize.getWidth() * 8.0 / 1024.0);
        int fontSize = (int)Math.round(this.screenSize.getHeight() * 13.0 / 768.0);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53", 1, fontSize);
        Dimension fontDimension = SwingUtil.getStringFontSize(message, font);
        int textWidth = width - 2 * marglr;
        if (textWidth <= 0) {
            textWidth = 1;
        }
        int textLines = fontDimension.width % textWidth == 0 ? fontDimension.width / textWidth : fontDimension.width / textWidth + 1;
        int onelineHeight = fontDimension.height;
        int lineHeight = textLines * onelineHeight;
        int widowHeight = 2 * topHeight + lineHeight;
        if (maxHeight < 2 * topHeight + onelineHeight) {
            maxHeight = 2 * topHeight + onelineHeight;
        }
        if (maxHeight > 0 && widowHeight > maxHeight) {
            widowHeight = maxHeight;
        }
        this.setSize(width, widowHeight);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), roudSize, roudSize);
        AWTUtilities.setWindowShape((Window)this, (Shape)shape);
        Color bgColor = MessageTipDialog.getBgColor(messageType);
        Color fontColor = MessageTipDialog.getFontColor(messageType);
        JPanel rootPanel = new JPanel();
        rootPanel.setBackground(bgColor);
        rootPanel.setLayout(new XYLayout());
        this.getContentPane().add(rootPanel);
        JTextArea console = new JTextArea();
        console.setBackground(rootPanel.getBackground());
        console.setText(message);
        console.setFont(font);
        console.setEditable(false);
        console.setCursor(new Cursor(0));
        console.setForeground(fontColor);
        console.setLineWrap(true);
        console.setBorder(BorderFactory.createEmptyBorder());
        rootPanel.add((Component)console, new XYConstraints(marglr, topHeight, textWidth, widowHeight - 2 * topHeight + 6));
        if (closeIcon == null) {
            int coloseIconSize = (int)Math.round(this.screenSize.getHeight() * 14.0 / 768.0);
            closeIcon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("crossWhite"), coloseIconSize, coloseIconSize));
        }
        JLabel closeLabel = new JLabel();
        closeLabel.setCursor(new Cursor(12));
        closeLabel.setIcon(closeIcon);
        rootPanel.add((Component)closeLabel, new XYConstraints(width - closeIcon.getIconWidth() - 8, (topHeight - closeIcon.getIconHeight()) / 2, closeIcon.getIconWidth(), closeIcon.getIconHeight()));
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MessageTipDialog.this.dispose();
            }
        });
    }
}

