/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class PlaceholderTextField
extends JTextField {
    private static final long serialVersionUID = -3728477313143032258L;
    private String text;
    private Color foreground;
    private Color placeholderForeround;
    private String placeholderText;
    private static final Color DEFAULTGRAYCOLOR = Color.decode("#999999");

    public PlaceholderTextField() {
        this(null, null, 0);
    }

    public PlaceholderTextField(String text) {
        this(null, text, 0);
    }

    public PlaceholderTextField(int columns) {
        this(null, null, columns);
    }

    public PlaceholderTextField(String text, int columns) {
        this(null, text, columns);
    }

    public PlaceholderTextField(Document doc, String text0, int columns) {
        super(doc, text0, columns);
        this.setForeground(Color.BLACK);
        this.placeholderForeround = DEFAULTGRAYCOLOR;
        this.text = text0;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PlaceholderTextField.this.setText0(PlaceholderTextField.this.text);
                PlaceholderTextField.this.setForeground0(PlaceholderTextField.this.foreground);
            }

            @Override
            public void focusLost(FocusEvent e) {
                PlaceholderTextField.this.text = PlaceholderTextField.this.getText0();
                if (PlaceholderTextField.this.text == null || PlaceholderTextField.this.text.length() == 0) {
                    PlaceholderTextField.this.setText0(PlaceholderTextField.this.placeholderText);
                    PlaceholderTextField.this.setForeground0(PlaceholderTextField.this.placeholderForeround);
                } else {
                    PlaceholderTextField.this.setText0(PlaceholderTextField.this.text);
                    PlaceholderTextField.this.setForeground0(PlaceholderTextField.this.foreground);
                }
            }
        });
    }

    private String getText0() {
        return super.getText();
    }

    private void setText0(String t) {
        super.setText(t);
    }

    private void setForeground0(Color fg) {
        super.setForeground(fg);
    }

    @Override
    public String getText() {
        String x = this.getText0();
        if (this.placeholderText == null || this.placeholderText.length() == 0) {
            return x;
        }
        if (this.placeholderText.equals(x)) {
            if (this.placeholderForeround.equals(this.getForeground())) {
                return "";
            }
            return x;
        }
        return x;
    }

    @Override
    public void setText(String t) {
        this.text = t;
        super.setText(t);
    }

    @Override
    public void setForeground(Color fg) {
        if (fg == null) {
            fg = Color.BLACK;
        }
        this.foreground = fg;
        super.setForeground(fg);
    }

    public Color getPlaceholderForeround() {
        return this.placeholderForeround;
    }

    public void setPlaceholderForeround(Color placeholderForeround) {
        if (placeholderForeround == null) {
            placeholderForeround = DEFAULTGRAYCOLOR;
        }
        this.placeholderForeround = placeholderForeround;
        if (!(this.isFocusOwner() || this.text != null && this.text.length() != 0)) {
            this.setForeground0(placeholderForeround);
            this.setText0(this.placeholderText);
        }
    }

    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        if (!(this.isFocusOwner() || this.text != null && this.text.length() != 0)) {
            this.setText0(placeholderText);
            this.setForeground0(this.placeholderForeround);
        }
    }
}

