/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class RoundBorder
implements Border {
    private Color color;
    private int roundSize;
    private int borderSize = 1;

    public RoundBorder(Color color, int roundSize) {
        this.color = color;
        this.roundSize = roundSize;
    }

    public RoundBorder(Color color, int roundSize, int borderSize) {
        this(color, roundSize);
        if (borderSize < 1) {
            borderSize = 1;
        }
        this.borderSize = borderSize;
    }

    public RoundBorder() {
        this(Color.BLACK, 6);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color old = g.getColor();
        g.setColor(this.color);
        int i = 0;
        while (i < this.borderSize) {
            g.drawRoundRect(i, i, c.getWidth() - 2 * i, c.getHeight() - 2 * i, this.roundSize - i, this.roundSize - i);
            ++i;
        }
        g.setColor(old);
    }
}

