/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.RoundBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;

public class RoundPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int arcW;
    private int arcH;

    public RoundPanel(int arcW, int arcH) {
        this.arcW = arcW;
        this.arcH = arcH;
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        g.setClip(rect);
        super.paint(g);
    }

    public static RoundPanel createPanel(int roundSize) {
        return new RoundPanel(roundSize, roundSize);
    }

    public static RoundPanel createPanelWithBorder(int roundSize, Color borderColor) {
        RoundPanel p = new RoundPanel(roundSize, roundSize);
        p.setBorder(new RoundBorder(borderColor, roundSize));
        return p;
    }

    public static RoundPanel createPanelWithShadeBorder(final int roundSize, final Color borderColor0, final Color borderColor1, final Color borderColor2) {
        RoundPanel p = new RoundPanel(roundSize, roundSize);
        RoundBorder b = new RoundBorder(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color old = g.getColor();
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (borderColor0 != null) {
                    g.setColor(borderColor0);
                    g.drawRoundRect(2, 2, c.getWidth() - 4, c.getHeight() - 4, roundSize - 2, roundSize - 2);
                }
                if (borderColor1 != null) {
                    g.setColor(borderColor1);
                    g.drawRoundRect(1, 1, c.getWidth() - 2, c.getHeight() - 2, roundSize - 1, roundSize - 1);
                }
                if (borderColor2 != null) {
                    g.setColor(borderColor2);
                    g.drawRoundRect(0, 0, c.getWidth(), c.getHeight(), roundSize, roundSize);
                }
                g.setColor(old);
            }
        };
        p.setBorder(b);
        return p;
    }
}

