/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicScrollBarUI;
import sun.swing.SwingUtilities2;

public class SampleScrollBarUI
extends BasicScrollBarUI {
    private boolean barWidth;
    private Color trackColor0;
    private Color thumbColor0;
    private Color thumbDarkShadowColor0;
    private int scrollBarWidth0;

    public SampleScrollBarUI(Color trackColor, Color thumbColor, Color thumbDarkShadowColor, Dimension size) {
        this.trackColor0 = trackColor;
        this.thumbColor0 = thumbColor;
        this.thumbDarkShadowColor0 = thumbDarkShadowColor;
        this.scrollBarWidth0 = (int)Math.round(16.0 * size.getWidth() / 3840.0);
    }

    public SampleScrollBarUI(Color trackColor, Color thumbColor, Color thumbDarkShadowColor, int scrollBarWidth) {
        this.trackColor0 = trackColor;
        this.thumbColor0 = thumbColor;
        this.thumbDarkShadowColor0 = thumbDarkShadowColor;
        if (scrollBarWidth < 1) {
            scrollBarWidth = 1;
        }
        this.scrollBarWidth0 = scrollBarWidth;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.trackHighlightColor = this.trackColor = this.trackColor0;
        this.thumbHighlightColor = this.thumbColor = this.thumbColor0;
        this.thumbDarkShadowColor = this.thumbDarkShadowColor0;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
        return button;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(null);
        return button;
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(this.thumbDarkShadowColor);
            SwingUtilities2.drawRect(g, 0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(this.thumbHighlightColor);
            SwingUtilities2.drawHLine(g, 1, thumbBounds.width - 3, 1);
            SwingUtilities2.drawVLine(g, 1, 1, thumbBounds.height - 2);
        } else {
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(this.thumbDarkShadowColor);
            SwingUtilities2.drawRect(g, 0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(this.thumbHighlightColor);
            SwingUtilities2.drawHLine(g, 1, thumbBounds.width - 3, 1);
            SwingUtilities2.drawVLine(g, 1, 1, thumbBounds.height - 3);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (!this.barWidth) {
            this.barWidth = true;
            this.scrollBarWidth = this.scrollBarWidth0;
        }
        return super.getPreferredSize(c);
    }
}

