/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

public class VideoCanvas
extends Canvas {
    private static final long serialVersionUID = -3169074233896137599L;
    private String noVideoMessage;
    private int disCont = 0;
    private Image noVideoImageImage;

    public void setNoVideoMessage(String message) {
        if (message != null && message.length() > 0) {
            this.noVideoMessage = message;
            this.disCont = 0;
        } else {
            this.disCont = 3;
        }
    }

    public void setNoVideoImage(Image image) {
        if (image != null) {
            this.noVideoImageImage = image;
            this.disCont = 0;
        } else {
            this.disCont = 3;
        }
    }

    public void resetCount() {
        this.disCont = 1;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.disCont < 2) {
            ++this.disCont;
            if (this.disCont == 1) {
                return;
            }
            String msg = this.noVideoMessage;
            if (msg != null && msg.length() > 0) {
                Graphics2D g2 = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                if (width == 0 || height == 0) {
                    Dimension d = this.getPreferredSize();
                    if (d != null && d.width > 0 && d.height > 0) {
                        width = d.width;
                        height = d.height;
                    } else {
                        Container c = this.getParent();
                        if (c != null) {
                            width = c.getWidth();
                            height = c.getHeight();
                        }
                    }
                }
                Font font = this.getFont();
                int fontSize = 16;
                if (font != null) {
                    fontSize = font.getSize();
                }
                int messageWith = fontSize * msg.length();
                int x = (width - messageWith) / 2;
                int y = (height - fontSize) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y <= 0) {
                    y = 0;
                }
                g2.drawString(msg, x, y);
            } else if (this.noVideoImageImage != null) {
                int width = this.getWidth();
                int height = this.getHeight();
                if (width == 0 || height == 0) {
                    Dimension d = this.getPreferredSize();
                    if (d != null && d.width > 0 && d.height > 0) {
                        width = d.width;
                        height = d.height;
                    } else {
                        Container c = this.getParent();
                        if (c != null) {
                            width = c.getWidth();
                            height = c.getHeight();
                        }
                    }
                }
                g.drawImage(this.noVideoImageImage, 0, 0, null);
            }
        }
    }
}

