/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JPanel;

public class XYPanel
extends JPanel {
    private static final long serialVersionUID = -4078220189041103197L;
    private Collection<XywhChangeListener> xywhChangeListeners;
    protected XYConstraints xyConstraints = new XYConstraints();
    protected XYConstraints oldConstraints;
    private boolean resizable;
    private boolean firstRepaint;

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setFirstRepaint(boolean repaint) {
        this.firstRepaint = repaint;
    }

    public XYPanel() {
        super(new XYLayout(), true);
    }

    public Iterator<XywhChangeListener> getXywhChangeListeners() {
        if (this.xywhChangeListeners == null) {
            return null;
        }
        return this.xywhChangeListeners.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXywhChangeListener(XywhChangeListener l) {
        if (l != null) {
            if (this.xywhChangeListeners == null) {
                XYPanel xYPanel = this;
                synchronized (xYPanel) {
                    if (this.xywhChangeListeners == null) {
                        this.xywhChangeListeners = new ConcurrentLinkedQueue<XywhChangeListener>();
                    }
                }
            }
            this.xywhChangeListeners.add(l);
        }
    }

    public void removeXywhChangeListener(XywhChangeListener l) {
        if (this.xywhChangeListeners != null && l != null) {
            this.xywhChangeListeners.remove(l);
        }
    }

    @Override
    public void paint(Graphics g) {
        if ((this.resizable || this.firstRepaint) && this.xywhChangeListeners != null && !this.xywhChangeListeners.isEmpty()) {
            Iterator<XywhChangeListener> ls = this.getXywhChangeListeners();
            int gwidth = this.getWidth();
            int gheight = this.getHeight();
            if (gwidth > 0 && gheight > 0) {
                this.xyConstraints.set(this.getX(), this.getY(), gwidth, gheight);
                if (this.oldConstraints == null) {
                    this.oldConstraints = new XYConstraints();
                    if (!this.firstRepaint) {
                        this.oldConstraints.set(this.xyConstraints.getX(), this.xyConstraints.getY(), this.xyConstraints.getWidth(), this.xyConstraints.getHeight());
                    }
                }
                if (!this.xyConstraints.equals(this.oldConstraints)) {
                    boolean b = false;
                    if (ls != null) {
                        while (ls.hasNext()) {
                            XywhChangeListener l = ls.next();
                            l.onChange(this, this.xyConstraints, this.oldConstraints);
                            if (b) continue;
                            b = true;
                        }
                    }
                    this.oldConstraints.set(this.xyConstraints.getX(), this.xyConstraints.getY(), this.xyConstraints.getWidth(), this.xyConstraints.getHeight());
                    if (b && !this.resizable && this.firstRepaint) {
                        this.firstRepaint = false;
                        this.revalidate();
                        this.repaint();
                        return;
                    }
                }
            }
            this.firstRepaint = false;
        }
        super.paint(g);
    }

    public static interface XywhChangeListener {
        public void onChange(XYPanel var1, XYConstraints var2, XYConstraints var3);
    }
}

