/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.install;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.install.ProcessMessageUI;
import com.wovoe.carpark.gui.install.WindowsPostgres;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DatabaseSetupDialog
extends MacDialog
implements ActionListener,
ProcessMessageUI {
    private static final long serialVersionUID = 2270784747196424665L;
    private Dimension mainSize;
    private boolean defaultShowSefdb;
    private JLabel dbSetlabel;
    private JComboBox<ComboBoxEntry<Integer>> dbInstallSelect;
    private JLabel dbPortLabel;
    private JTextField dbPortTextField;
    private JLabel dbDatabaseNameLabel;
    private JTextField dbDatabaseNameTextField;
    private JLabel dbUserNameLabel;
    private JTextField dbUserNameTextField;
    private JLabel dbPasswordLabel;
    private JPasswordField dbPasswordField;
    private Properties defaultDbConfig;
    private OperationFutureHandler<Properties> opertaionValueFuture;
    private JLabel infoLabel;
    private JButton cancelButton;
    private JButton okButton;

    public static OperationFuture<DatabaseSetupDialog> createDialog(final Object parentCompent, final boolean showSelfdb, final Properties dbConfig, final boolean modal) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DatabaseSetupDialog dilog;
                    Window rootWidnow = null;
                    Component c = null;
                    if (parentCompent != null && parentCompent instanceof Component) {
                        c = (Component)parentCompent;
                    }
                    if (c == null) {
                        dilog = new DatabaseSetupDialog();
                    } else {
                        Window w = SwingUtil.getWindowForComponent(c);
                        dilog = w instanceof Frame ? new DatabaseSetupDialog((Frame)w, modal) : (w instanceof Dialog ? new DatabaseSetupDialog((Dialog)w, modal) : (w instanceof Window ? new DatabaseSetupDialog(w, modal) : new DatabaseSetupDialog()));
                        rootWidnow = w;
                    }
                    dilog.mainSize = SwingUtil.getScreenSize();
                    dilog.defaultShowSefdb = showSelfdb;
                    dilog.defaultDbConfig = dbConfig == null ? new Properties() : dbConfig;
                    int width = (int)Math.round(dilog.mainSize.getHeight() * 400.0 / 768.0);
                    int hegiht = (int)Math.round(dilog.mainSize.getHeight() * 360.0 / 768.0);
                    Dimension dialogSieze = new Dimension(width, hegiht);
                    dilog.init(dialogSieze, rootWidnow);
                    Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
                    dilog.setIconImage(logo);
                    dilog.setVisible(true);
                    f.setResult((Object)dilog);
                }
                catch (Throwable ex) {
                    f.setException(ex);
                }
            }
        });
        return f;
    }

    public DatabaseSetupDialog() {
    }

    public DatabaseSetupDialog(Frame owner, boolean modal) {
        super(owner, "", modal);
    }

    public DatabaseSetupDialog(Dialog owner, boolean modal) {
        super(owner, "", modal);
    }

    public DatabaseSetupDialog(Window owner, boolean modal) {
        super(owner, "", modal);
    }

    @Override
    public int getTitileBarHeight() {
        return (int)Math.round(this.mainSize.getHeight() * 30.0 / 900.0);
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        int textWidth;
        this.opertaionValueFuture = ServiceUtil.getServiceContext().createOperationFuture();
        this.setTitleInfo("\u6570\u636e\u5e93\u5b89\u88c5\u8bbe\u7f6e\u5411\u5bfc");
        body.setLayout(new XYLayout());
        int font13Size = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        int font12Size = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        String fontName = SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME);
        Font font13 = new Font(fontName, 0, font13Size);
        Font font12 = new Font(fontName, 0, font12Size);
        int marginLeft = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        int marginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int tempX = marginLeft;
        int tempH = (int)Math.round(this.mainSize.getHeight() * 30.0 / 768.0);
        int tempY = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        int fontWidth = SwingUtil.getStringFontSize((String)"\u6570\u636e\u5e93\u8bbe\u7f6e\uff1a", (Font)font13).width + 5;
        this.dbSetlabel = new JLabel("\u6570\u636e\u5e93\u8bbe\u7f6e\uff1a");
        this.dbSetlabel.setFont(font13);
        int tempW = fontWidth;
        body.add((Component)this.dbSetlabel, new XYConstraints(tempX, tempY, tempW, tempH));
        Vector<ComboBoxEntry<Integer>> sl = new Vector<ComboBoxEntry<Integer>>(2);
        sl.add(new ComboBoxEntry<Integer>(1, "\u4f7f\u7528\u7cfb\u7edf\u81ea\u5e26\u6570\u636e\u5e93(\u63a8\u8350)"));
        sl.add(new ComboBoxEntry<Integer>(2, "\u4f7f\u7528\u672c\u673a\u5df2\u7ecf\u5b89\u88c5\u7684\u6570\u636e\u5e93"));
        this.dbInstallSelect = new JComboBox(sl);
        if (this.defaultShowSefdb) {
            this.dbInstallSelect.setSelectedIndex(0);
        } else {
            this.dbInstallSelect.setSelectedIndex(1);
        }
        this.dbInstallSelect.setFont(font13);
        this.dbInstallSelect.setBackground(Color.WHITE);
        this.dbInstallSelect.addActionListener(this);
        tempX += tempW;
        tempW = textWidth = panelSize.width - marginLeft - tempX;
        body.add(this.dbInstallSelect, new XYConstraints(tempX, tempY, tempW, tempH));
        int textHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        tempY = tempY + tempH + marginTop;
        tempX = marginLeft;
        tempW = fontWidth;
        tempH = textHeight;
        this.dbPortLabel = new JLabel("\u6570\u636e\u5e93\u7aef\u53e3\uff1a");
        this.dbPortLabel.setFont(font13);
        body.add((Component)this.dbPortLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        tempX += tempW;
        tempW = textWidth;
        tempH = textHeight;
        this.dbPortTextField = new JTextField();
        this.dbPortTextField.setFont(font13);
        body.add((Component)this.dbPortTextField, new XYConstraints(tempX, tempY, tempW, tempH));
        if (!this.defaultShowSefdb) {
            this.dbPortTextField.setText(this.defaultDbConfig.getProperty("port", ""));
        }
        tempY = tempY + tempH + marginTop;
        tempX = marginLeft;
        tempW = fontWidth;
        tempH = textHeight;
        this.dbDatabaseNameLabel = new JLabel("\u6570\u636e\u5e93\u540d\u79f0\uff1a");
        this.dbDatabaseNameLabel.setFont(font13);
        body.add((Component)this.dbDatabaseNameLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        tempX += tempW;
        tempW = textWidth;
        tempH = textHeight;
        this.dbDatabaseNameTextField = new JTextField();
        this.dbDatabaseNameTextField.setFont(font13);
        body.add((Component)this.dbDatabaseNameTextField, new XYConstraints(tempX, tempY, tempW, tempH));
        if (!this.defaultShowSefdb) {
            this.dbDatabaseNameTextField.setText(this.defaultDbConfig.getProperty("dbname", ""));
        }
        tempY = tempY + tempH + marginTop;
        tempX = marginLeft;
        tempW = fontWidth;
        tempH = textHeight;
        this.dbUserNameLabel = new JLabel("\u6570\u636e\u5e93\u7528\u6237\uff1a");
        this.dbUserNameLabel.setFont(font13);
        body.add((Component)this.dbUserNameLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        tempX += tempW;
        tempW = textWidth;
        tempH = textHeight;
        this.dbUserNameTextField = new JTextField();
        this.dbUserNameTextField.setFont(font13);
        body.add((Component)this.dbUserNameTextField, new XYConstraints(tempX, tempY, tempW, tempH));
        if (!this.defaultShowSefdb) {
            this.dbUserNameTextField.setText(this.defaultDbConfig.getProperty("user", ""));
        }
        tempY = tempY + tempH + marginTop;
        tempX = marginLeft;
        tempW = fontWidth;
        tempH = textHeight;
        this.dbPasswordLabel = new JLabel("\u6570\u636e\u5e93\u5bc6\u7801\uff1a");
        this.dbPasswordLabel.setFont(font13);
        body.add((Component)this.dbPasswordLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        tempX += tempW;
        tempW = textWidth;
        tempH = textHeight;
        this.dbPasswordField = new JPasswordField();
        this.dbPasswordField.setFont(font13);
        body.add((Component)this.dbPasswordField, new XYConstraints(tempX, tempY, tempW, tempH));
        if (!this.defaultShowSefdb) {
            this.dbPasswordField.setText(this.defaultDbConfig.getProperty("pwd", ""));
        }
        this.infoLabel = new JLabel("\u6b63\u5728\u5b89\u88c5\u6570\u636e\u5e93...");
        this.infoLabel.setFont(font12);
        tempY = tempY + tempH + marginTop / 2;
        tempX = marginLeft;
        tempW = panelSize.width - 2 * tempX;
        tempH = textHeight;
        body.add((Component)this.infoLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        this.infoLabel.setForeground(Color.decode("#3F7F7F"));
        tempY = tempY + tempH + marginTop;
        tempW = (int)Math.round(this.mainSize.getHeight() * 80.0 / 768.0);
        tempX = (panelSize.width - 2 * tempW) / 3;
        tempH = (int)Math.round(this.mainSize.getHeight() * 25.0 / 768.0);
        this.cancelButton = new JButton("\u53d6\u6d88");
        this.cancelButton.setFont(font12);
        this.cancelButton.setCursor(new Cursor(12));
        this.cancelButton.setToolTipText("\u5982\u679c\u53d6\u6d88\uff0c\u5c06\u9000\u51fa\u7cfb\u7edf");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setBackground(Color.decode("#FAFAFA"));
        this.cancelButton.setRolloverEnabled(false);
        this.okButton = new JButton("\u786e\u5b9a");
        this.okButton.setFont(font12);
        this.okButton.addActionListener(this);
        this.okButton.setCursor(new Cursor(12));
        this.okButton.setBackground(Color.decode("#38A0F4"));
        this.okButton.setForeground(Color.WHITE);
        this.okButton.setRolloverEnabled(false);
        body.add((Component)this.cancelButton, new XYConstraints(tempX, tempY, tempW, tempH));
        tempX += tempX + tempW;
        body.add((Component)this.okButton, new XYConstraints(tempX, tempY, tempW, tempH));
        this.setText();
    }

    public OperationFutureHandler<Properties> getOpertaionValueFuture() {
        return this.opertaionValueFuture;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.cancelButton == source) {
            MacOptionDialog.showConfirmDialog(this, this.defaultShowSefdb ? "\u653e\u5f03\u5b89\u88c5" : "\u9000\u51fa\u8f6f\u4ef6", this.defaultShowSefdb ? "\u60a8\u786e\u5b9a\u8981\u653e\u5f03\u672c\u6b21\u5b89\u88c5\u5417\uff1f" : "\u4f60\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", null, "\u53d6\u6d88", new Runnable(){

                @Override
                public void run() {
                    try {
                        DatabaseSetupDialog.this.dispose();
                    }
                    finally {
                        DatabaseSetupDialog.this.opertaionValueFuture.setResult(null);
                    }
                }
            }, "\u786e\u5b9a", Color.WHITE);
        } else if (this.dbInstallSelect == source) {
            this.setText();
        } else if (this.okButton == source) {
            if (this.dbInstallSelect.getSelectedIndex() == 0) {
                if (!this.okButton.isEnabled()) {
                    return;
                }
                this.okButton.getParent().setCursor(new Cursor(3));
                this.okButton.setCursor(new Cursor(3));
                this.dbInstallSelect.setEnabled(false);
                this.cancelButton.setEnabled(false);
                this.okButton.setEnabled(false);
                this.infoLabel.setText("\u6b63\u5728\u521d\u59cb\u5316\u5e93...\u8bf7\u4e0d\u8981\u5173\u95ed\u7a0b\u5e8f");
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            Throwable exa = null;
                            Properties dbconfig = null;
                            try {
                                try {
                                    Properties newP = WindowsPostgres.checkOrInstallOrStartDataBase(DatabaseSetupDialog.this);
                                    boolean connected = false;
                                    long t1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                    int waitcount = 10;
                                    int i = 0;
                                    while (i < 10) {
                                        DatabaseSetupDialog.this.setprocessMessage("\u6b63\u5728\u68c0\u6d4b\u6570\u636e\u5e93\u8fde\u63a5...." + (i + 1));
                                        connected = ServiceUtil.getLibStartService().textConnection(newP);
                                        long t2 = ServiceUtil.getServiceContext().currentTimeMillis();
                                        if (connected) break;
                                        if (i < waitcount - 1) {
                                            if (t2 - t1 < 2000L) {
                                                Thread.sleep(2000L - (t2 - t1));
                                            }
                                            t1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                        }
                                        ++i;
                                    }
                                    if (!connected) {
                                        DatabaseSetupDialog.this.setprocessMessage("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93!");
                                        throw new RuntimeException("\u65e0\u8fde\u63a5\u6570\u636e\u5e93");
                                    }
                                    dbconfig = newP;
                                }
                                catch (Throwable ex) {
                                    exa = ex;
                                    ServiceLog.getLog().warn((Object)("\u521d\u59cb\u5316\u6570\u636e\u5e93\u9519\u8bef\uff01" + ex.getMessage()));
                                    Throwable aba = exa;
                                    Properties dbconfig0 = dbconfig;
                                    SwingUtil.invokeLater(new Runnable(aba, dbconfig0){
                                        private final /* synthetic */ Throwable val$aba;
                                        private final /* synthetic */ Properties val$dbconfig0;
                                        {
                                            this.val$aba = throwable;
                                            this.val$dbconfig0 = properties;
                                        }

                                        @Override
                                        public void run() {
                                            if (this.val$aba != null) {
                                                MacOptionDialog.showAlertDialog(DatabaseSetupDialog.this, "\u9519\u8bef", "\u521d\u59cb\u5316\u6570\u636e\u5e93\u5f02\u5e38!" + this.val$aba.getMessage(), null, "\u5173\u95ed", Color.WHITE);
                                            }
                                            DatabaseSetupDialog.this.dbInstallSelect.setEnabled(true);
                                            DatabaseSetupDialog.this.cancelButton.setEnabled(true);
                                            DatabaseSetupDialog.this.okButton.setEnabled(true);
                                            DatabaseSetupDialog.this.okButton.getParent().setCursor(new Cursor(0));
                                            DatabaseSetupDialog.this.okButton.setCursor(new Cursor(12));
                                            if (this.val$dbconfig0 != null) {
                                                try {
                                                    DatabaseSetupDialog.this.dispose();
                                                }
                                                finally {
                                                    DatabaseSetupDialog.this.opertaionValueFuture.setResult((Object)this.val$dbconfig0);
                                                }
                                            }
                                        }
                                    });
                                    break block9;
                                }
                            }
                            catch (Throwable throwable) {
                                Throwable aba = exa;
                                Properties dbconfig0 = dbconfig;
                                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            Throwable aba = exa;
                            Properties dbconfig0 = dbconfig;
                            SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                });
            } else if (this.dbInstallSelect.getSelectedIndex() == 1) {
                Properties p;
                block33: {
                    Properties dbConfig;
                    String port = this.dbPortTextField.getText();
                    if (port == null || (port = port.trim()).length() == 0) {
                        this.infoLabel.setText("\u8bf7\u8f93\u5165\u672c\u673a\u6570\u636e\u5e93\u7aef\u53e3\u53f7!");
                        this.dbPortTextField.requestFocus();
                        return;
                    }
                    try {
                        int p2 = Integer.parseInt(port);
                        if (p2 < 1 || p2 > 65535) {
                            this.infoLabel.setText("\u6570\u636e\u5e93\u7aef\u53e3\u53f7\u5e94\u8be5\u5728[1,65535]\u4e4b\u95f4!");
                            this.dbPortTextField.requestFocus();
                            return;
                        }
                    }
                    catch (Exception ex) {
                        this.infoLabel.setText("\u6570\u636e\u5e93\u7aef\u53e3\u53f7\u5fc5\u987b\u662f\u6570\u5b57");
                        this.dbPortTextField.requestFocus();
                        return;
                    }
                    String dbName = this.dbDatabaseNameTextField.getText();
                    if (dbName == null || (dbName = dbName.trim()).length() == 0) {
                        this.infoLabel.setText("\u8bf7\u8f93\u5165\u672c\u673a\u6570\u636e\u5e93\u540d\u79f0!");
                        this.dbDatabaseNameTextField.requestFocus();
                        return;
                    }
                    String userName = this.dbUserNameTextField.getText();
                    if (userName == null || (userName = userName.trim()).length() == 0) {
                        this.infoLabel.setText("\u8bf7\u8f93\u5165\u672c\u673a\u6570\u636e\u5e93\u7528\u6237\u540d!");
                        this.dbUserNameTextField.requestFocus();
                        return;
                    }
                    char[] pwd0 = this.dbPasswordField.getPassword();
                    if (pwd0 == null) {
                        pwd0 = new char[]{};
                    }
                    String pwd = new String(pwd0).trim();
                    String host = "127.0.0.1";
                    p = WindowsPostgres.createNoEncriptDbconf(host, port, userName, pwd, dbName, "0");
                    if (!ServiceUtil.getLibStartService().textConnection(p)) {
                        this.infoLabel.setText("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
                        return;
                    }
                    try {
                        dbConfig = WindowsPostgres.createDbConf(host, port, userName, pwd, dbName, "0");
                    }
                    catch (Exception ex) {
                        this.infoLabel.setText("\u5185\u90e8\u9519\u8bef\uff01");
                        return;
                    }
                    try {
                        File dbConfFile;
                        Properties dbconf = new Properties();
                        File dbConfDir = new File(PathFinder.findLocalDir(), "conf");
                        if (!dbConfDir.exists() || !dbConfDir.isDirectory()) {
                            dbConfDir.mkdirs();
                        }
                        if ((dbConfFile = new File(dbConfDir, "db.conf")).exists() && dbConfFile.isFile()) {
                            try (FileInputStream in = new FileInputStream(dbConfFile);){
                                dbconf.load(in);
                            }
                        }
                        if (dbconf.equals(dbConfig)) break block33;
                        try (FileOutputStream dbconfigout = new FileOutputStream(dbConfFile);){
                            dbConfig.store(dbconfigout, "");
                        }
                    }
                    catch (Exception ex) {
                        this.infoLabel.setText("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38\uff01");
                        return;
                    }
                }
                try {
                    this.dispose();
                }
                finally {
                    this.opertaionValueFuture.setResult((Object)p);
                }
            }
        }
    }

    private void setText() {
        String msg2;
        String msg1;
        int x = this.dbInstallSelect.getSelectedIndex();
        if (x != 0 && x != 1) {
            return;
        }
        boolean enabled = x == 1;
        this.dbPortLabel.setEnabled(enabled);
        this.dbPortTextField.setEnabled(enabled);
        this.dbDatabaseNameLabel.setEnabled(enabled);
        this.dbDatabaseNameTextField.setEnabled(enabled);
        this.dbUserNameLabel.setEnabled(enabled);
        this.dbUserNameTextField.setEnabled(enabled);
        this.dbPasswordLabel.setEnabled(enabled);
        this.dbPasswordField.setEnabled(enabled);
        if (enabled) {
            this.dbPortTextField.setText("5432");
            this.dbDatabaseNameTextField.setText("postgres");
            this.dbUserNameTextField.setText("postgres");
        } else {
            this.dbPortTextField.setText("");
            this.dbDatabaseNameTextField.setText("");
            this.dbUserNameTextField.setText("");
            this.dbPasswordField.setText("");
        }
        if (this.defaultShowSefdb) {
            msg1 = "\u70b9\u51fb\u4e0b\u65b9\u3010\u786e\u5b9a\u3011\u5b8c\u6210\u6570\u636e\u5e93\u8bbe\u7f6e\u4e0e\u521d\u59cb\u5316";
            msg2 = "\u8bf7\u5b8c\u6210\u4e0a\u8ff0\u914d\u7f6e";
        } else {
            msg1 = "\u7cfb\u7edf\u4e4b\u524d\u4f7f\u7528\u7684\u4e0d\u662f\u81ea\u5e26\u6570\u636e\u5e93\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u4e4b\u524d\u7684\u6570\u636e\u4e22\u5931\uff01";
            msg2 = "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u6216\u6570\u636e\u5e93\u662f\u5426\u6b63\u5e38\u542f\u52a8\uff01";
        }
        this.infoLabel.setText(enabled ? msg2 : msg1);
    }

    @Override
    public void setprocessMessage(final String processMessage) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                DatabaseSetupDialog.this.infoLabel.setText(processMessage);
            }
        });
    }
}

