/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.install;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnector;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkChannelArea;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkStrategy;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.equipment.ProductDrivers;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.install.ProcessMessageUI;
import com.wovoe.carpark.gui.install.WindowsPostgres;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ProductLicense;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.internel.WanNetConnectCheckJob;
import com.wovoe.carpark.service.impl.BasicSettingServiceImpl;
import com.wovoe.carpark.vo.BasicConfigVo;
import com.wovoe.carpark.vo.CarparkClientDeploy;
import com.wovoe.carpark.vo.CarparkInitEntry;
import com.wovoe.carpark.web.action.InstallInitAction;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.db.ExecuteSqlCallback;
import com.wovoe.framework.db.JdbcSqlExecutor;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.Key;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.ibatis.session.SqlSession;

public class DeploySetupDialog
extends MacDialog
implements ActionListener,
ProcessMessageUI {
    private static final long serialVersionUID = -286829001883428365L;
    private Dimension mainSize;
    private OperationFutureHandler<CarparkInitEntry> localConfigFuture;
    private JLabel deployTypelabel;
    private JComboBox<ComboBoxEntry<Integer>> deployTypeSelect;
    private JLabel deployTypeDesLabel;
    private JPanel contentPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel serverPanel;
    private JLabel localIPLabel;
    private JComboBox<String> localIPBox;
    private JLabel localIPDes;
    private JLabel localPortLabel;
    private JTextField localPortText;
    private JLabel localPortDes;
    private JLabel carparkNameLabel;
    private JTextField carparkNameText;
    private JLabel carparkNameDes;
    private JLabel serverNameLabel;
    private JTextField serverNameText;
    private JLabel serverNameDes;
    private JLabel msgLabel;
    private JPanel clientPanel;
    private JLabel netModeHostLabel;
    private JComboBox<ComboBoxEntry<Integer>> netModeSelect;
    private JLabel netModeHostDes;
    private JLabel connectServerHostLabel;
    private JTextField connectServerHostText;
    private JLabel connectServerHostDes;
    private JLabel connectServerPortLabel;
    private JTextField connectServerPortText;
    private JLabel connectServerPortDes;
    private JLabel clientHostLabel;
    private JLabel clientHostText;
    private JLabel defaultEqLabel;
    private JComboBox<ComboBoxEntry<String>> defaultEqelect;
    private JLabel defaultEqDes;
    private Color redColor = Color.decode("#FF0000");
    private Color msgColor = Color.decode("#0A1676");
    private volatile CarparkUdpConnSession successUdpConnSession;
    private volatile long successUdpMills;

    public static OperationFuture<DeploySetupDialog> createDialog(final Object parentCompent, final boolean modal) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DeploySetupDialog dilog;
                    Window rootWidnow = null;
                    Component c = null;
                    if (parentCompent != null && parentCompent instanceof Component) {
                        c = (Component)parentCompent;
                    }
                    if (c == null) {
                        dilog = new DeploySetupDialog();
                    } else {
                        Window w = SwingUtil.getWindowForComponent(c);
                        dilog = w instanceof Frame ? new DeploySetupDialog((Frame)w, modal) : (w instanceof Dialog ? new DeploySetupDialog((Dialog)w, modal) : (w instanceof Window ? new DeploySetupDialog(w, modal) : new DeploySetupDialog()));
                        rootWidnow = w;
                    }
                    dilog.mainSize = SwingUtil.getScreenSize();
                    int width = (int)Math.round(dilog.mainSize.getHeight() * 500.0 / 768.0);
                    int hegiht = (int)Math.round(dilog.mainSize.getHeight() * 400.0 / 768.0);
                    Dimension dialogSieze = new Dimension(width, hegiht);
                    dilog.init(dialogSieze, rootWidnow);
                    Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
                    dilog.setIconImage(logo);
                    dilog.setVisible(true);
                    f.setResult((Object)dilog);
                }
                catch (Throwable ex) {
                    f.setException(ex);
                }
            }
        });
        return f;
    }

    public DeploySetupDialog() {
    }

    public DeploySetupDialog(Frame owner, boolean modal) {
        super(owner, "", modal);
    }

    public DeploySetupDialog(Dialog owner, boolean modal) {
        super(owner, "", modal);
    }

    public DeploySetupDialog(Window owner, boolean modal) {
        super(owner, "", modal);
    }

    @Override
    public int getTitileBarHeight() {
        return (int)Math.round(this.mainSize.getHeight() * 30.0 / 900.0);
    }

    public OperationFutureHandler<CarparkInitEntry> getLocalConfigFuture() {
        return this.localConfigFuture;
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        int textWidth;
        int marginLeft;
        this.localConfigFuture = ServiceUtil.getServiceContext().createOperationFuture();
        this.setTitleInfo("\u7cfb\u7edf\u90e8\u7f72\u8bbe\u7f6e\u5411\u5bfc");
        body.setLayout(new XYLayout());
        int font13Size = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        int font12Size = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        String fontName = SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME);
        Font font13 = new Font(fontName, 0, font13Size);
        Font font12 = new Font(fontName, 0, font12Size);
        int tempX = marginLeft = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        int tempH = (int)Math.round(this.mainSize.getHeight() * 30.0 / 768.0);
        int tempY = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        int fontWidth = SwingUtil.getStringFontSize((String)"\u672c\u673a\u5c40\u57df\u7f51\u5730\uff1a", (Font)font13).width + 5;
        this.deployTypelabel = new JLabel("\u7cfb\u7edf\u90e8\u7f72\u7c7b\u578b\uff1a");
        this.deployTypelabel.setFont(font13);
        int tempW = fontWidth;
        body.add((Component)this.deployTypelabel, new XYConstraints(tempX, tempY, tempW, tempH));
        Vector<ComboBoxEntry<Integer>> sl = new Vector<ComboBoxEntry<Integer>>(3);
        sl.add(new ComboBoxEntry<Integer>(3, "\u5c97\u4ead\u5ba2\u6237\u7aef+\u8f66\u573a\u7ba1\u7406\u670d\u52a1\u5668"));
        sl.add(new ComboBoxEntry<Integer>(2, "\u8f66\u573a\u7ba1\u7406\u670d\u52a1\u5668(\u4e0d\u7ba1\u7406\u901a\u9053)"));
        sl.add(new ComboBoxEntry<Integer>(1, "\u5c97\u4ead\u5ba2\u6237\u7aef(\u901a\u9053\u76d1\u63a7\u4e0e\u7ba1\u7406)"));
        this.deployTypeSelect = new JComboBox(sl);
        this.deployTypeSelect.setFont(font13);
        this.deployTypeSelect.setBackground(Color.WHITE);
        this.deployTypeSelect.setSelectedIndex(0);
        this.deployTypeSelect.addActionListener(this);
        tempX += tempW;
        tempW = textWidth = panelSize.width - marginLeft - tempX;
        body.add(this.deployTypeSelect, new XYConstraints(tempX, tempY, tempW, tempH));
        tempY += tempH;
        tempX = marginLeft;
        tempW = panelSize.width - 2 * tempX;
        this.deployTypeDesLabel = new JLabel();
        this.deployTypeDesLabel.setFont(font12);
        this.deployTypeDesLabel.setForeground(Color.decode("#0000C0"));
        body.add((Component)this.deployTypeDesLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        this.setDeployTypeDes();
        int contentY = tempY + tempH;
        int marginBottom = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        int buttonH = (int)Math.round(this.mainSize.getHeight() * 25.0 / 768.0);
        int buttonY = panelSize.height - marginBottom - buttonH;
        int buttonW = (int)Math.round(this.mainSize.getHeight() * 80.0 / 768.0);
        int buttonX = (panelSize.width - 2 * buttonW) / 3;
        this.cancelButton = new JButton("\u53d6\u6d88");
        this.cancelButton.setFont(font12);
        this.cancelButton.setCursor(new Cursor(12));
        this.cancelButton.setToolTipText("\u5982\u679c\u53d6\u6d88\uff0c\u5c06\u9000\u51fa\u7cfb\u7edf");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setBackground(Color.decode("#FAFAFA"));
        this.okButton = new JButton("\u786e\u5b9a");
        this.okButton.setFont(font12);
        this.okButton.addActionListener(this);
        this.okButton.setCursor(new Cursor(12));
        this.okButton.setBackground(Color.decode("#38A0F4"));
        this.okButton.setForeground(Color.WHITE);
        body.add((Component)this.cancelButton, new XYConstraints(buttonX, buttonY, buttonW, buttonH));
        buttonX += buttonX + buttonW;
        body.add((Component)this.okButton, new XYConstraints(buttonX, buttonY, buttonW, buttonH));
        int marginBottom0 = (int)Math.round(this.mainSize.getHeight() * 10.0 / 768.0);
        this.msgLabel = new JLabel();
        this.msgLabel.setFont(font12);
        int msgH = (int)Math.round(this.mainSize.getHeight() * 25.0 / 768.0);
        int msgX = marginLeft;
        int msgW = panelSize.width - 2 * msgX;
        int msgY = buttonY - marginBottom0 - msgH;
        body.add((Component)this.msgLabel, new XYConstraints(msgX, msgY, msgW, msgH));
        this.redColor = Color.decode("#FF0000");
        this.msgLabel.setForeground(this.msgColor);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBackground(body.getBackground());
        int contentX = marginLeft;
        int contentW = panelSize.width - 2 * contentX;
        int contentH = msgY - contentY;
        body.add((Component)this.contentPanel, new XYConstraints(contentX, contentY, contentW, contentH));
        Dimension contentSize = new Dimension(contentW, contentH);
        this.initServerClientPanel(contentSize, fontWidth, font13, font12);
        this.contentPanel.add((Component)this.serverPanel, "Center");
        this.initClientPanel(contentSize, fontWidth, font13, font12);
    }

    private void initClientPanel(Dimension contentSize, int labelWidth, Font font13, Font font12) {
        if (this.clientPanel != null) {
            return;
        }
        this.clientPanel = new JPanel(new XYLayout());
        this.clientPanel.setBackground(this.contentPanel.getBackground());
        Color desColor = Color.decode("#3F7F5F");
        String des2 = "  \u672c\u673a\u63a5\u5165\u7f51\u662f\u5c40\u57df\u7f51\u8fd8\u662f\u5916\u7f51";
        int fontWidth = SwingUtil.getStringFontSize((String)des2, (Font)font12).width;
        int textWidth = contentSize.width - fontWidth - labelWidth;
        int h = (int)Math.round(this.mainSize.getHeight() * 30.0 / 768.0);
        int maginTop = (contentSize.height - 4 * h) / 5;
        int x = 0;
        int y = maginTop;
        int w = labelWidth;
        this.netModeHostLabel = new JLabel("\u8fde\u63a5\u7f51\u7edc\u6a21\u5f0f\uff1a");
        this.netModeHostLabel.setFont(font13);
        this.clientPanel.add((Component)this.netModeHostLabel, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<Integer>> netModes = new Vector<ComboBoxEntry<Integer>>();
        netModes.add(new ComboBoxEntry<Integer>(1, "\u5c40\u57df\u7f51\u6a21\u5f0f"));
        netModes.add(new ComboBoxEntry<Integer>(2, "\u4e92\u8054\u7f51\u6a21\u5f0f"));
        this.netModeSelect = new JComboBox(netModes);
        this.netModeSelect.setBackground(Color.WHITE);
        this.netModeSelect.setFont(font13);
        this.netModeSelect.setSelectedIndex(0);
        this.netModeSelect.addActionListener(this);
        x += w;
        w = textWidth;
        this.clientPanel.add(this.netModeSelect, new XYConstraints(x, y, w, h));
        this.netModeHostDes = new JLabel();
        this.netModeHostDes.setFont(font12);
        this.netModeHostDes.setForeground(desColor);
        this.netModeHostDes.setText("  \u672c\u673a\u63a5\u5165\u7f51\u662f\u5c40\u57df\u7f51\u8fd8\u662f\u5916\u7f51");
        x += w;
        w = fontWidth;
        this.clientPanel.add((Component)this.netModeHostDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.connectServerHostLabel = new JLabel("\u8f66\u573a\u670d\u52a1\u5668IP\uff1a");
        this.connectServerHostLabel.setFont(font13);
        this.clientPanel.add((Component)this.connectServerHostLabel, new XYConstraints(x, y += h + maginTop, w, h));
        this.connectServerHostText = new JTextField();
        this.connectServerHostText.setFont(font13);
        x += w;
        w = textWidth;
        this.clientPanel.add((Component)this.connectServerHostText, new XYConstraints(x, y, w, h));
        this.connectServerHostDes = new JLabel();
        this.connectServerHostDes.setFont(font12);
        this.connectServerHostDes.setForeground(desColor);
        this.connectServerHostDes.setText("  \u5c40\u57df\u7f51\u8f66\u573a\u670d\u52a1\u5668IP\u5730\u5740");
        x += w;
        w = fontWidth;
        this.clientPanel.add((Component)this.connectServerHostDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.connectServerPortLabel = new JLabel("\u670d\u52a1\u5668\u7aef\u53e3\u53f7\uff1a");
        this.connectServerPortLabel.setFont(font13);
        this.clientPanel.add((Component)this.connectServerPortLabel, new XYConstraints(x, y += h + maginTop, w, h));
        this.connectServerPortText = new JTextField("80");
        this.connectServerPortText.setFont(font13);
        x += w;
        w = textWidth;
        this.clientPanel.add((Component)this.connectServerPortText, new XYConstraints(x, y, w, h));
        this.connectServerPortDes = new JLabel();
        this.connectServerPortDes.setFont(font12);
        this.connectServerPortDes.setForeground(desColor);
        this.connectServerPortDes.setText("  \u5c40\u57df\u7f51\u8f66\u573a\u670d\u52a1\u5668\u7aef\u53e3\u53f7");
        x += w;
        w = fontWidth;
        this.clientPanel.add((Component)this.connectServerPortDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.clientHostLabel = new JLabel("\u672c\u673aIP\uff1a");
        this.clientHostLabel.setFont(font13);
        this.clientPanel.add((Component)this.clientHostLabel, new XYConstraints(x, y += h + maginTop, w, h));
        x += w;
        w = contentSize.width - x;
        Set<String> ipset = ServiceUtil.getServiceContext().getLocalIpv4(true);
        String ipV = ipset == null || ipset.isEmpty() ? "\u672a\u8bbe\u7f6e\u64cd\u4f5c\u7cfb\u7edfIP" : ipset.toString();
        this.clientHostText = new JLabel(ipV);
        this.clientHostText.setFont(font13);
        this.clientPanel.add((Component)this.clientHostText, new XYConstraints(x, y, w, h));
    }

    private void initServerClientPanel(Dimension contentSize, int labelWidth, Font font13, Font font12) {
        if (this.serverPanel != null) {
            return;
        }
        this.serverPanel = new JPanel(new XYLayout());
        this.serverPanel.setBackground(this.contentPanel.getBackground());
        Color desColor = Color.decode("#3F7F5F");
        String des2 = "  \u5c40\u57df\u7f51IP\u5fc5\u987b\u662f\u9759\u6001IP,\u4ee5\u540e\u4e0d\u8981\u968f\u4fbf\u66f4\u6539";
        int fontWidth = SwingUtil.getStringFontSize((String)des2, (Font)font12).width;
        int textWidth = contentSize.width - fontWidth - labelWidth;
        int h = (int)Math.round(this.mainSize.getHeight() * 30.0 / 768.0);
        int maginTop = (contentSize.height - 5 * h) / 6;
        int x = 0;
        int y = maginTop;
        int w = labelWidth;
        this.localIPLabel = new JLabel("\u672c\u673a\u5c40\u57df\u7f51IP\uff1a");
        this.localIPLabel.setFont(font13);
        this.serverPanel.add((Component)this.localIPLabel, new XYConstraints(x, y, w, h));
        Set<String> ipset = ServiceUtil.getServiceContext().getLocalIpv4(true);
        Vector<String> ips = new Vector<String>();
        if (ipset != null && !ipset.isEmpty()) {
            ips.addAll(ipset);
        }
        this.localIPBox = new JComboBox(ips);
        this.localIPBox.setBackground(Color.WHITE);
        this.localIPBox.setFont(font13);
        x += w;
        w = textWidth;
        this.serverPanel.add(this.localIPBox, new XYConstraints(x, y, w, h));
        this.localIPDes = new JLabel();
        this.localIPDes.setFont(font12);
        if (ipset != null && !ipset.isEmpty()) {
            this.localIPDes.setForeground(desColor);
            this.localIPDes.setText("  \u5fc5\u987b\u662f\u9759\u6001IP,\u4e14\u4ee5\u540e\u4e0d\u8981\u968f\u610f\u66f4\u6539");
        } else {
            this.localIPDes.setForeground(Color.RED);
            this.localIPDes.setText("  \u672c\u7535\u8111\u672a\u8bbeIP,\u8bf7\u5148\u8bbe\u7f6e\u7535\u8111IP");
        }
        x += w;
        w = fontWidth;
        this.serverPanel.add((Component)this.localIPDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.localPortLabel = new JLabel("\u670d\u52a1\u5668\u7aef\u53e3\u53f7\uff1a");
        this.localPortLabel.setFont(font13);
        this.serverPanel.add((Component)this.localPortLabel, new XYConstraints(x, y += h + maginTop, w, h));
        this.localPortText = new JTextField("80");
        this.localPortText.setFont(font13);
        x += w;
        w = textWidth;
        this.serverPanel.add((Component)this.localPortText, new XYConstraints(x, y, w, h));
        this.localPortDes = new JLabel();
        this.localPortDes.setFont(font12);
        this.localPortDes.setForeground(desColor);
        this.localPortDes.setText("  \u7528\u4e8e\u670d\u52a1\u5668\u901a\u4fe1\u670d\u52a1\u7aef\u53e3");
        x += w;
        w = fontWidth;
        this.serverPanel.add((Component)this.localPortDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.carparkNameLabel = new JLabel("\u505c\u8f66\u573a\u540d\u79f0\uff1a");
        this.carparkNameLabel.setFont(font13);
        this.serverPanel.add((Component)this.carparkNameLabel, new XYConstraints(x, y += h + maginTop, w, h));
        this.carparkNameText = new JTextField();
        this.carparkNameText.setFont(font13);
        x += w;
        w = textWidth;
        this.serverPanel.add((Component)this.carparkNameText, new XYConstraints(x, y, w, h));
        this.carparkNameDes = new JLabel();
        this.carparkNameDes.setFont(font12);
        this.carparkNameDes.setForeground(desColor);
        this.carparkNameDes.setText("  \u6bd4\u5982\u5e78\u798f\u5bb6\u56ed\uff0c\u5357\u5cad\u79d1\u6280\u56ed\u7b49");
        x += w;
        w = fontWidth;
        this.serverPanel.add((Component)this.carparkNameDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.serverNameLabel = new JLabel("\u5c97\u4ead\u670d\u52a1\u5668\u540d\uff1a");
        this.serverNameLabel.setFont(font13);
        this.serverPanel.add((Component)this.serverNameLabel, new XYConstraints(x, y += h + maginTop, w, h));
        this.serverNameText = new JTextField("\u5927\u95e8\u5c97\u670d\u52a1\u5668");
        this.serverNameText.setFont(font13);
        x += w;
        w = textWidth;
        this.serverPanel.add((Component)this.serverNameText, new XYConstraints(x, y, w, h));
        this.serverNameDes = new JLabel();
        this.serverNameDes.setFont(font12);
        this.serverNameDes.setForeground(desColor);
        this.serverNameDes.setText("  \u4e3a\u6b64\u7535\u8111\u4efb\u610f\u547d\u4e2a\u540d");
        x += w;
        w = fontWidth;
        this.serverPanel.add((Component)this.serverNameDes, new XYConstraints(x, y, w, h));
        w = labelWidth;
        x = 0;
        this.defaultEqLabel = new JLabel("\u9ed8\u8ba4\u8bbe\u5907\u7cfb\u5217\uff1a");
        this.defaultEqLabel.setFont(font13);
        this.serverPanel.add((Component)this.defaultEqLabel, new XYConstraints(x, y += h + maginTop, w, h));
        Map<String, ProductDrivers.DriverName[]> pvMap = ProductDrivers.getProductDriverMap();
        LinkedHashMap<String, ProductDrivers.DriverName[]> selectMap = new LinkedHashMap<String, ProductDrivers.DriverName[]>();
        String selectNames = ServiceUtil.getServiceContext().getConfig().getProperty("show.select.eqtypes");
        if (selectNames != null && selectNames.length() > 0) {
            String[] sxt;
            String[] stringArray = sxt = selectNames.split(",");
            int n = sxt.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).length() > 0 && pvMap.containsKey(s)) {
                    selectMap.put(s, pvMap.get(s));
                }
                ++n2;
            }
        }
        if (selectMap.isEmpty()) {
            selectMap.putAll(pvMap);
        } else {
            String defaultV = ProductDrivers.getDefaultProductName();
            if (defaultV != null && !selectMap.containsKey(defaultV) && pvMap.containsKey(defaultV)) {
                selectMap.put(defaultV, pvMap.get(defaultV));
            }
        }
        Vector<ComboBoxEntry<String>> defaultEqs = new Vector<ComboBoxEntry<String>>();
        defaultEqs.add(new ComboBoxEntry<String>("", ""));
        for (String a : selectMap.keySet()) {
            String t = ServiceUtil.getServiceContext().getConfig().getProperty(String.valueOf(a) + ".alias", a);
            String m = t != null && t.length() > 0 ? t : a;
            defaultEqs.add(new ComboBoxEntry<String>(a, String.valueOf(m) + " \u8bbe\u5907\u7cfb\u5217"));
        }
        int defaultSelectEqIndex = -1;
        String default_eq_driver = ServiceUtil.getServiceContext().getConfig().getProperty("default_eq_driver");
        if (default_eq_driver != null && default_eq_driver.length() > 0) {
            default_eq_driver = default_eq_driver.trim();
            int i = 0;
            while (i < defaultEqs.size()) {
                if (default_eq_driver.equals(((ComboBoxEntry)((Object)defaultEqs.get(i))).getKey())) {
                    defaultSelectEqIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.defaultEqelect = new JComboBox(defaultEqs);
        this.defaultEqelect.setBackground(Color.WHITE);
        this.defaultEqelect.setFont(font13);
        this.defaultEqelect.setToolTipText("\u65b0\u589e\u901a\u9053\u65f6\u5019\uff0c\u9ed8\u8ba4\u6dfb\u52a0\u7684\u8bbe\u5907\u7c7b\u578b\u4e0e\u9a71\u52a8\uff0c\u65b9\u4fbf\u914d\u7f6e\u4f7f\u7528");
        if (defaultSelectEqIndex != -1) {
            this.defaultEqelect.setSelectedIndex(defaultSelectEqIndex);
        }
        x += w;
        w = textWidth;
        this.serverPanel.add(this.defaultEqelect, new XYConstraints(x, y, w, h));
        this.defaultEqDes = new JLabel();
        this.defaultEqDes.setFont(font12);
        this.defaultEqDes.setForeground(desColor);
        this.defaultEqDes.setText("  \u9ed8\u8ba4\u65b0\u589e\u7684\u8bbe\u5907\u7cfb\u5217\u4e0e\u9a71\u52a8");
        this.defaultEqDes.setToolTipText("\u65b0\u589e\u901a\u9053\u65f6\u5019\uff0c\u9ed8\u8ba4\u6dfb\u52a0\u7684\u8bbe\u5907\u7c7b\u578b\u4e0e\u9a71\u52a8\uff0c\u65b9\u4fbf\u914d\u7f6e\u4f7f\u7528");
        x += w;
        w = fontWidth;
        this.serverPanel.add((Component)this.defaultEqDes, new XYConstraints(x, y, w, h));
    }

    private void setDeployTypeDes() {
        ComboBoxEntry e = (ComboBoxEntry)((Object)this.deployTypeSelect.getSelectedItem());
        int deployType = (Integer)e.getKey();
        String msg = deployType == 3 ? "\u672c\u673a\u5373\u505a\u4e3a\u7ba1\u7406\u670d\u52a1\u5668\uff0c\u540c\u65f6\u7ba1\u7406\u901a\u9053\uff0c\u4e00\u822c\u5b89\u88c5\u5728\u5c97\u4ead\u7535\u8111\u4e0a\u3002" : (deployType == 2 ? "\u672c\u673a\u505a\u4e3a\u7ba1\u7406\u670d\u52a1\u5668\uff0c\u4e00\u822c\u5b89\u88c5\u5728\u7ba1\u7406\u5904\u7535\u8111\u4e0a\uff0c\u4e3b\u8981\u7ed9\u7ba1\u7406\u5904\u4eba\u5458\u4f7f\u7528\u3002" : (deployType == 1 ? "\u672c\u673a\u505a\u4e3a\u5c97\u4ead\u5ba2\u6237\u7aef\uff0c\u4e00\u822c\u5b89\u88c5\u5728\u5c97\u4ead\u7535\u8111\u4e0a\uff0c\u4e3b\u8981\u7ed9\u5c97\u4ead\u503c\u73ed\u4eba\u5458\u4f7f\u7528\u3002" : ""));
        this.deployTypeDesLabel.setText(msg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.deployTypeSelect) {
            this.setDeployTypeDes();
            ComboBoxEntry entry = (ComboBoxEntry)((Object)this.deployTypeSelect.getSelectedItem());
            int deployType = (Integer)entry.getKey();
            Component ccn = this.contentPanel.getComponent(0);
            if (deployType == 3 || deployType == 2) {
                boolean nochaged;
                String v = this.serverNameText.getText();
                boolean bl = nochaged = "\u5927\u95e8\u5c97\u670d\u52a1\u5668".equals(v) || "\u7ba1\u7406\u5904\u670d\u52a1\u5668".equals(v);
                if (deployType == 3) {
                    this.serverNameLabel.setText("\u5c97\u4ead\u670d\u52a1\u5668\u540d\uff1a");
                    if (nochaged) {
                        this.serverNameText.setText("\u5927\u95e8\u5c97\u670d\u52a1\u5668");
                    }
                } else {
                    this.serverNameLabel.setText("\u8f66\u573a\u670d\u52a1\u5668\u540d\uff1a");
                    if (nochaged) {
                        this.serverNameText.setText("\u7ba1\u7406\u5904\u670d\u52a1\u5668");
                    }
                }
                if (ccn != this.serverPanel) {
                    this.contentPanel.remove(0);
                    this.contentPanel.add((Component)this.serverPanel, "Center");
                    this.contentPanel.updateUI();
                }
            } else {
                this.clientHostLabel.setText("\u672c\u673aIP\u5730\u5740\uff1a");
                Set<String> ipset = ServiceUtil.getServiceContext().getLocalIpv4(false);
                if (ipset == null || ipset.isEmpty()) {
                    this.clientHostText.setText("\u672c\u673a\u672a\u8bbe\u7f6eIP");
                } else {
                    this.clientHostText.setText(ipset.toString());
                }
                if (ccn != this.clientPanel) {
                    this.contentPanel.remove(0);
                    this.contentPanel.add((Component)this.clientPanel, "Center");
                    this.contentPanel.updateUI();
                }
            }
        } else if (this.netModeSelect != null && source == this.netModeSelect) {
            ComboBoxEntry en = (ComboBoxEntry)((Object)this.netModeSelect.getSelectedItem());
            int netMode = (Integer)en.getKey();
            if (netMode == 2) {
                String labelTxt1 = "\u4e91\u7aef\u4e3b\u673aID\uff1a";
                if (!labelTxt1.equals(this.connectServerHostLabel.getText())) {
                    this.connectServerHostLabel.setText(labelTxt1);
                    this.connectServerHostText.setText("");
                    this.connectServerHostDes.setText("  \u4e91\u7aef\u4e3a\u6b64\u4e3b\u673a\u5206\u914d\u7684ID");
                    this.connectServerPortLabel.setText("\u4e91\u7aef\u901a\u4fe1\u79d8\u94a5\uff1a");
                    this.connectServerPortText.setText("");
                    this.connectServerPortDes.setText(" \u4e91\u7aef\u5206\u914d\u7684\u505c\u8f66\u573a\u901a\u4fe1\u79d8\u94a5");
                }
            } else {
                String labelTxt1 = "\u8f66\u573a\u670d\u52a1\u5668IP\uff1a";
                if (!labelTxt1.equals(this.connectServerHostLabel.getText())) {
                    this.connectServerHostLabel.setText(labelTxt1);
                    this.connectServerHostText.setText("");
                    this.connectServerHostDes.setText("  \u5c40\u57df\u7f51\u8f66\u573a\u670d\u52a1\u5668IP\u5730\u5740");
                    this.connectServerPortLabel.setText("\u670d\u52a1\u5668\u7aef\u53e3\u53f7\uff1a");
                    this.connectServerPortText.setText("80");
                    this.connectServerPortDes.setText("  \u5c40\u57df\u7f51\u8f66\u573a\u670d\u52a1\u5668\u7aef\u53e3\u53f7");
                }
            }
        } else if (source == this.cancelButton) {
            MacOptionDialog.showConfirmDialog(this, "\u653e\u5f03\u5b89\u88c5", "\u60a8\u786e\u5b9a\u8981\u653e\u5f03\u672c\u6b21\u5b89\u88c5\u5417\uff1f", null, "\u53d6\u6d88", new Runnable(){

                @Override
                public void run() {
                    try {
                        DeploySetupDialog.this.dispose();
                    }
                    finally {
                        DeploySetupDialog.this.localConfigFuture.setResult(null);
                    }
                }
            }, "\u786e\u5b9a", Color.WHITE);
        } else if (source == this.okButton) {
            ComboBoxEntry entry = (ComboBoxEntry)((Object)this.deployTypeSelect.getSelectedItem());
            int deployType = (Integer)entry.getKey();
            if (!this.okButton.isEnabled()) {
                return;
            }
            if (deployType == 3 || deployType == 2) {
                int port;
                String ip = (String)this.localIPBox.getSelectedItem();
                if (ip == null || ip.length() == 0) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u8bf7\u5148\u8bbe\u5b9a\u7535\u8111\u7684\u9759\u6001IP,\u7136\u540e\u518d\u8fdb\u884c\u5b89\u88c5");
                    return;
                }
                String portStr = this.localPortText.getText();
                if (portStr == null || (portStr = portStr.trim()).length() == 0) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u8bf7\u8f93\u5165\u7aef\u53e3\u53f7");
                    return;
                }
                try {
                    port = Integer.parseInt(portStr);
                    if (port < 1 || port > 65535) {
                        this.msgLabel.setForeground(this.redColor);
                        this.msgLabel.setText("\u7aef\u53e3\u5fc5\u987b\u662f\u57281-65535\u4e4b\u95f4");
                        return;
                    }
                }
                catch (Exception ex) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u7aef\u53e3\u5fc5\u987b\u662f\u6570\u5b57");
                    return;
                }
                String carparkName = this.carparkNameText.getText();
                if (carparkName == null || (carparkName = carparkName.trim()).length() == 0) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u8bf7\u8f93\u5165\u8f66\u573a\u540d\u79f0");
                    return;
                }
                String serverName = this.serverNameText.getText();
                if (serverName == null || (serverName = serverName.trim()).length() == 0) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u8bf7\u8f93\u5165" + (deployType == 3 ? "\u5c97\u4ead\u670d\u52a1\u5668" : "\u8f66\u573a\u670d\u52a1\u5668") + "\u7684\u540d\u79f0");
                    return;
                }
                ComboBoxEntry deEQ = (ComboBoxEntry)((Object)this.defaultEqelect.getSelectedItem());
                String deEQName = (String)deEQ.getKey();
                if (deEQName == null || deEQName.length() == 0) {
                    this.msgLabel.setForeground(this.redColor);
                    this.msgLabel.setText("\u8bf7\u9009\u62e9\u9ed8\u8ba4\u8bbe\u5907\u7cfb\u5217\uff0c\u65b9\u4fbf\u521d\u59cb\u5316\u9ed8\u8ba4\u7684\u8bbe\u5907");
                    return;
                }
                if (OSUtil.isWindows()) {
                    this.msgLabel.setForeground(this.msgColor);
                    this.msgLabel.setText("\u6b63\u5728\u68c0\u6d4b\u7aef\u53e3" + portStr + "\u662f\u5426\u88ab\u5360\u7528\u3002");
                    try {
                        HashMap<Integer, Integer> portMap = WindowsPostgres.findPorts();
                        if (portMap.get(port) != null) {
                            int avport = -1;
                            int i = 8899;
                            while (i < 10000) {
                                if (portMap.get(i) == null) {
                                    avport = i;
                                    break;
                                }
                                ++i;
                            }
                            this.msgLabel.setForeground(this.redColor);
                            this.msgLabel.setText("\u7aef\u53e3" + port + "\u5df2\u88ab\u5176\u4ed6\u7a0b\u5e8f\u5360\u7528" + (avport != -1 ? "\uff0c\u53ef\u4ee5\u4f7f\u7528\uff1a" + avport : "") + " \u5efa\u8bae\u4e0d\u8981\u5927\u4e8e10000");
                            return;
                        }
                        this.msgLabel.setText("\u7aef\u53e3" + portStr + "\u53ef\u7528\u3002");
                    }
                    catch (Exception portMap) {
                        // empty catch block
                    }
                }
                StringBuilder sbr = new StringBuilder(128);
                sbr.append("\u60a8\u786e\u5b9a\u8981\u5c06\u7cfb\u7edf\u90e8\u7f72\u6210\u670d\u52a1\u5668\u5417\uff1f\n\u90e8\u7f72\u540e\u4e0d\u53ef\u518d\u66f4\u6539\u6210\u5c97\u4ead\u5ba2\u6237\u7aef\u3002\n");
                sbr.append("\u7528\u4e8e\u5c40\u57df\u7f51IP\uff1a").append(ip);
                MacOptionDialog.showConfirmDialog(this, "\u4fe1\u606f\u786e\u8ba4", sbr.toString(), null, "\u53d6\u6d88", new Runnable(){

                    @Override
                    public void run() {
                        DeploySetupDialog.this.doServerConfirm();
                    }
                }, "\u786e\u5b9a", Color.WHITE);
            } else {
                ComboBoxEntry en = (ComboBoxEntry)((Object)this.netModeSelect.getSelectedItem());
                int netMode = (Integer)en.getKey();
                if (netMode == 2) {
                    this.doWanClientInstall();
                } else {
                    this.doLanClientInstall();
                }
            }
        }
    }

    private void doWanClientInstall() {
        String cloudHostId = this.connectServerHostText.getText();
        if (cloudHostId == null || (cloudHostId = cloudHostId.trim()).length() == 0) {
            this.msgLabel.setForeground(this.redColor);
            this.msgLabel.setText("\u8bf7\u8f93\u5165\u4e91\u7aef\u4e3b\u673aID!");
            return;
        }
        String cloudSignKey = this.connectServerPortText.getText();
        if (cloudSignKey == null || (cloudSignKey = cloudSignKey.trim()).length() == 0) {
            this.msgLabel.setForeground(this.redColor);
            this.msgLabel.setText("\u8bf7\u8f93\u5165\u4e91\u7aef\u901a\u4fe1\u79d8\u94a5!");
            return;
        }
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668...");
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.netModeSelect.setEnabled(false);
        this.connectServerHostText.setEnabled(false);
        this.connectServerPortText.setEnabled(false);
        this.deployTypeSelect.setEnabled(false);
        final String cloudSignKey0 = cloudSignKey;
        final String cloudHostId0 = cloudHostId;
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block8: {
                    KeyValueEntry entry = null;
                    try {
                        try {
                            entry = DeploySetupDialog.validateCloudHostId0(cloudHostId0, cloudSignKey0, 20000L, DeploySetupDialog.this.msgLabel);
                        }
                        catch (Throwable ex) {
                            entry = new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u8fde\u63a5\u4e91\u7aef\u5f02\u5e38");
                            if (entry == null) {
                                entry = new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u8fde\u63a5\u4e91\u7aef\u5931\u8d25");
                            }
                            KeyValueEntry entry0 = entry;
                            SwingUtil.invokeLater(new Runnable(entry0, cloudHostId0, cloudSignKey0){
                                private final /* synthetic */ KeyValueEntry val$entry0;
                                private final /* synthetic */ String val$cloudHostId0;
                                private final /* synthetic */ String val$cloudSignKey0;
                                {
                                    this.val$entry0 = keyValueEntry;
                                    this.val$cloudHostId0 = string;
                                    this.val$cloudSignKey0 = string2;
                                }

                                @Override
                                public void run() {
                                    DeploySetupDialog.this.cancelButton.setEnabled(true);
                                    DeploySetupDialog.this.okButton.setEnabled(true);
                                    DeploySetupDialog.this.netModeSelect.setEnabled(true);
                                    DeploySetupDialog.this.connectServerHostText.setEnabled(true);
                                    DeploySetupDialog.this.connectServerPortText.setEnabled(true);
                                    DeploySetupDialog.this.deployTypeSelect.setEnabled(true);
                                    if ("SUCCESS".equals(this.val$entry0.getKey())) {
                                        DeploySetupDialog.this.msgLabel.setText("\u8f6f\u4ef6\u90e8\u7f72\u786e\u8ba4");
                                        final Map vmap = (Map)this.val$entry0.getValue();
                                        final String carparkName = (String)vmap.get("carparkName");
                                        final String hostName = (String)vmap.get("hostName");
                                        MacOptionDialog.showConfirmDialog(DeploySetupDialog.this, "\u8f6f\u4ef6\u90e8\u7f72\u786e\u8ba4", "\u60a8\u786e\u5b9a\u5c06\u672c\u673a\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a" + hostName + "\n\n\u6240\u5c5e\u8f66\u573a\uff1a" + carparkName, new Runnable(){

                                            @Override
                                            public void run() {
                                                DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.msgColor);
                                                DeploySetupDialog.this.msgLabel.setText("\u60a8\u653e\u5f03\u4e86\u5c06\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a" + hostName + "\u3010" + carparkName + "\u3011");
                                            }
                                        }, "\u53d6\u6d88", new Runnable(){

                                            @Override
                                            public void run() {
                                                String carparkDeployType = (String)vmap.get("carpark_deploy_type");
                                                if (carparkDeployType != null && String.valueOf(1).equals(carparkDeployType)) {
                                                    DeploySetupDialog.this.doWanClientInstall1(val$cloudHostId0, val$cloudSignKey0, vmap);
                                                } else {
                                                    DeploySetupDialog.this.doWanClientInstall0(val$cloudHostId0, val$cloudSignKey0, vmap);
                                                }
                                            }
                                        }, "\u786e\u8ba4", Color.WHITE);
                                    } else {
                                        DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                                        DeploySetupDialog.this.msgLabel.setText((String)this.val$entry0.getValue());
                                    }
                                }
                            });
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        if (entry == null) {
                            entry = new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u8fde\u63a5\u4e91\u7aef\u5931\u8d25");
                        }
                        KeyValueEntry entry0 = entry;
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    if (entry == null) {
                        entry = new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u8fde\u63a5\u4e91\u7aef\u5931\u8d25");
                    }
                    KeyValueEntry entry0 = entry;
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    private void doWanClientInstall1(final String cloudHostId, final String cloudSignKey, Map<String, Object> vmap) {
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u8fde\u63a5\u4e91\u7aef\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f...");
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.netModeSelect.setEnabled(false);
        this.connectServerHostText.setEnabled(false);
        this.connectServerPortText.setEnabled(false);
        this.deployTypeSelect.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                KeyValueEntry<String, Object> entry = DeploySetupDialog.getCloudDeployConfig(cloudHostId, cloudSignKey, 15000L);
                if (!"SUCCESS".equals(entry.getKey())) {
                    DeploySetupDialog.this.showErrorMsg9("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01" + entry.getValue());
                    return;
                }
                CarparkClientDeploy carparkClientDeploy = (CarparkClientDeploy)entry.getValue();
                if (carparkClientDeploy.getCarpark() == null || carparkClientDeploy.getHostList() == null || carparkClientDeploy.getHostList().isEmpty() || carparkClientDeploy.getHost_no() == null || carparkClientDeploy.getHost_no().length() == 0 || carparkClientDeploy.getCloud_carpark_sign_key() == null || carparkClientDeploy.getCloud_carpark_sign_key().length() == 0 || carparkClientDeploy.getCloud_host_id() == null || !carparkClientDeploy.getCloud_host_id().equals(cloudHostId) || carparkClientDeploy.getCarpark().getCloud_carpark_id() == null || carparkClientDeploy.getCarpark().getCloud_carpark_id().length() == 0 || carparkClientDeploy.getCarpark().getLan_sign_key() == null || carparkClientDeploy.getCarpark().getLan_sign_key().length() == 0 || carparkClientDeploy.getCarpark().getCloud_carpark_sign_key() == null || carparkClientDeploy.getCarpark().getCloud_carpark_sign_key().length() == 0) {
                    DeploySetupDialog.this.showErrorMsg9("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01\u7f3a\u5c11\u5173\u952e\u914d\u7f6e\u4fe1\u606f");
                    return;
                }
                if (carparkClientDeploy.getCarpark().getData_sign() == null || carparkClientDeploy.getCarpark().getData_sign().length() == 0) {
                    ProductLicense license = ProductLicense.read();
                    String signData = String.valueOf(license.getOrg_id()) + "@#$" + carparkClientDeploy.getCarpark().getLan_sign_key() + "!-_+" + license.getAuth_sign_key() + "!-_+" + license.getId();
                    carparkClientDeploy.getCarpark().setData_sign(CryptoUtil.MD5Encode((String)signData));
                }
                CarparkHost installHost = null;
                for (CarparkHost host : carparkClientDeploy.getHostList()) {
                    if (!host.getHost_no().equals(carparkClientDeploy.getHost_no())) continue;
                    installHost = host;
                    break;
                }
                if (installHost == null) {
                    DeploySetupDialog.this.showErrorMsg9("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01\u7f3a\u5c11\u5b89\u88c5\u4e3b\u673a\u914d\u7f6e");
                    return;
                }
                try {
                    Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                    String cloud_carpark_sign_key1 = CryptoUtil.encrypt((String)carparkClientDeploy.getCarpark().getCloud_carpark_sign_key(), (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                    carparkClientDeploy.getCarpark().setCloud_carpark_sign_key(cloud_carpark_sign_key1);
                }
                catch (Exception ex) {
                    DeploySetupDialog.this.showErrorMsg9("\u52a0\u5bc6\u9519\u8bef");
                    return;
                }
                DeploySetupDialog.this.doInstanllClient9(ServiceUtil.getCloudDomain(), 80, installHost, carparkClientDeploy, carparkClientDeploy.getCloud_host_id(), carparkClientDeploy.getCloud_carpark_sign_key(), carparkClientDeploy.getOrg_id(), carparkClientDeploy.getCarpark_deploy_type(), carparkClientDeploy.getHost_type());
            }
        });
    }

    private void doWanClientInstall0(final String cloudHostId, final String cloudSignKey, Map<String, Object> vmap) {
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u8fde\u63a5\u8fdc\u7a0b\u505c\u8f66\u573a\u670d\u52a1\u5668...");
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.netModeSelect.setEnabled(false);
        this.connectServerHostText.setEnabled(false);
        this.connectServerPortText.setEnabled(false);
        this.deployTypeSelect.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Throwable ex = null;
                CarparkUdpConnSession connsession = null;
                BasicConfigVo basicConfigVo = null;
                try {
                    CarparkUdpP2pConnector conn = new CarparkUdpP2pConnector(cloudHostId, cloudSignKey);
                    OperationFuture<CarparkUdpConnSession> f1 = conn.connect(15000L);
                    try {
                        connsession = (CarparkUdpConnSession)f1.get(16L, TimeUnit.SECONDS);
                    }
                    catch (Throwable ex3) {
                        if (f1.isDone() && f1.getException() != null) {
                            ex = f1.getException();
                        }
                        if (ex == null) {
                            ex = ex3;
                        }
                    }
                }
                catch (Exception ex1) {
                    ex = ex1;
                }
                if (ex == null && connsession == null) {
                    ex = new TimeoutException("\u8fde\u63a5\u8d85\u65f6");
                }
                if (connsession != null) {
                    block27: {
                        DeploySetupDialog.showMessage("\u6210\u529f\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\uff01\u6b63\u5728\u83b7\u53d6\u90e8\u7f72\u914d\u7f6e...", DeploySetupDialog.this.msgLabel, null);
                        OperationFuture<BasicConfigVo> fu = DeploySetupDialog.obtianSeverBasicConfigVoFromUdp(connsession, 10000L);
                        try {
                            basicConfigVo = (BasicConfigVo)fu.get(11L, TimeUnit.SECONDS);
                        }
                        catch (Exception ex7) {
                            if (fu.isDone() && fu.getException() != null) {
                                ex = fu.getException();
                            }
                            if (ex != null) break block27;
                            ex = ex7;
                        }
                    }
                    if (basicConfigVo == null) {
                        ex = new TimeoutException("\u83b7\u53d6\u90e8\u7f72\u914d\u7f6e\u4fe1\u606f\u8d85\u65f6");
                    }
                } else if (ex == null) {
                    ex = new TimeoutException("\u8fde\u63a5\u8d85\u65f6");
                }
                if (basicConfigVo != null && connsession != null) {
                    DeploySetupDialog.showMessage("\u83b7\u53d6\u90e8\u7f72\u914d\u7f6e\u6210\u529f\uff0c\u6b63\u5728\u5199\u5165\u914d\u7f6e", DeploySetupDialog.this.msgLabel, null);
                    CarparkHost serverHost = null;
                    CarparkHost installHost = null;
                    if (basicConfigVo.getHostList() != null && !basicConfigVo.getHostList().isEmpty()) {
                        for (CarparkHost host1 : basicConfigVo.getHostList()) {
                            if (connsession.getLocalHostNo().equals(host1.getHost_no())) {
                                installHost = host1;
                                continue;
                            }
                            if (!connsession.getCarparkSeverHostNo().equals(host1.getHost_no())) continue;
                            serverHost = host1;
                        }
                    }
                    if (installHost == null) {
                        DeploySetupDialog.this.showErrorMsg9("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01\u7f3a\u5c11\u5b89\u88c5\u4e3b\u673a\u914d\u7f6e");
                        return;
                    }
                    if (serverHost == null) {
                        DeploySetupDialog.this.showErrorMsg9("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01\u7f3a\u5c11\u670d\u52a1\u5668\u4e3b\u673a\u914d\u7f6e");
                        return;
                    }
                    String serverHostIp = serverHost.getHost_ip();
                    Integer serverHttpPort = serverHost.getHost_port();
                    if (serverHttpPort == null) {
                        serverHttpPort = 80;
                    }
                    if (serverHostIp == null) {
                        serverHostIp = "192.168.8.1";
                    }
                    DeploySetupDialog.this.successUdpConnSession = connsession;
                    DeploySetupDialog.this.successUdpMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    DeploySetupDialog.this.doInstanllClient9(serverHostIp, serverHttpPort, installHost, basicConfigVo, cloudHostId, cloudSignKey, 0, 0, 1);
                } else {
                    String dr;
                    String errMsg;
                    if (connsession == null) {
                        errMsg = "\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\u5931\u8d25\uff01";
                        if (ex != null && (dr = ex.getMessage()) != null && dr.length() > 0) {
                            errMsg = String.valueOf(errMsg) + dr;
                        }
                    } else {
                        errMsg = "\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01";
                        if (ex != null && (dr = ex.getMessage()) != null && dr.length() > 0) {
                            errMsg = String.valueOf(errMsg) + dr;
                        }
                    }
                    DeploySetupDialog.this.showErrorMsg9(errMsg);
                }
            }
        });
    }

    private void showErrorMsg9(final String errMsg) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeploySetupDialog.this.cancelButton.setEnabled(true);
                DeploySetupDialog.this.okButton.setEnabled(true);
                DeploySetupDialog.this.netModeSelect.setEnabled(true);
                DeploySetupDialog.this.connectServerHostText.setEnabled(true);
                DeploySetupDialog.this.connectServerPortText.setEnabled(true);
                DeploySetupDialog.this.deployTypeSelect.setEnabled(true);
                DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                DeploySetupDialog.this.msgLabel.setText(errMsg);
            }
        });
    }

    public static OperationFuture<BasicConfigVo> obtianSeverBasicConfigVoFromUdp(final CarparkUdpConnSession connSession, final long timeoutMills) {
        final OperationFutureHandler returnF = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RequestSender sender = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpRequestSender(connSession);
            sender.setRequestActionName("/CarparkUdpHeatBeatAction");
            sender.setHeader("op", "obtainInstallClientVo");
            sender.setHeader("srcHostNo", connSession.getLocalHostNo());
            sender.setHeader("destHostNo", connSession.getCarparkSeverHostNo());
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            ProductLicense productLicense = ProductLicense.read();
            String v_org = String.valueOf(productLicense.getOrg_id());
            String v_id = String.valueOf(productLicense.getId());
            String v_mills = String.valueOf(System.currentTimeMillis());
            String v_ver = ServiceUtil.getServiceContext().getVersion();
            paramMap.put("v_org", v_org);
            paramMap.put("v_id", v_id);
            paramMap.put("v_mills", v_mills);
            paramMap.put("v_ver", v_ver);
            paramMap.put("v_sign", CryptoUtil.MD5Encode((String)(String.valueOf(v_org) + "&" + v_id + "&" + v_mills + "&" + v_ver + "&" + productLicense.getAuth_sign_key())));
            sender.setSendData(GsonBuilder.create().toJson(paramMap).getBytes("UTF-8"));
            sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)connSession.getCarparkSignKey()));
            sender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    try {
                        ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u53d1\u9001\u63e1\u624b\u6570\u636e\u5931\u8d25! " + ex.getMessage()));
                    }
                    finally {
                        returnF.setException(ex);
                    }
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    try {
                        ServiceLog.getLog().warn((Object)("\u7b49\u5f85\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u54cd\u5e94\u83b7\u53d6\u5ba2\u6237\u7aef\u5b89\u88c5\u5fc5\u8981\u914d\u7f6e\u5931\u8d25! "));
                    }
                    finally {
                        returnF.setException((Throwable)new TimeoutException("\u505c\u8f66\u573a\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6"));
                    }
                }

                public long getWaitTimeoutMills() {
                    return timeoutMills;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String code = r.getHeaderValue("respCode");
                    String sign = r.getHeaderValue("sign");
                    if (sign == null || sign.length() == 0) {
                        try {
                            ServiceLog.getLog().warn((Object)"\u505c\u8f66\u573a\u670d\u52a1\u5668\u54cd\u5e94\u7684\u5ba2\u6237\u7aef\u90e8\u7f72\u914d\u7f6e\u6570\u636e\u7b7e\u540d");
                        }
                        finally {
                            returnF.setException((Throwable)new IOException("\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d\u6570\u636e"));
                        }
                        return;
                    }
                    String checkSign = HMPNetDataSignTool.getSign((Receiver)r, (String)connSession.getCarparkSignKey());
                    if (!sign.equals(checkSign)) {
                        try {
                            ServiceLog.getLog().warn((Object)"\u505c\u8f66\u573a\u670d\u52a1\u5668\u54cd\u5e94\u7684\u5ba2\u6237\u7aef\u90e8\u7f72\u914d\u7f6e\u6570\u636e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
                        }
                        finally {
                            returnF.setException((Throwable)new IOException("\u54cd\u5e94\u6570\u636e\u9a8c\u7b7e\u5931\u8d25"));
                        }
                        return;
                    }
                    if ("SUCCESS".equals(code)) {
                        if (r.getData() == null || r.getData().length == 0 || r.getDataLength() == 0) {
                            returnF.setException((Throwable)new IOException("\u8f66\u573a\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u6570\u636e"));
                        } else {
                            BasicConfigVo vbvo;
                            try {
                                String sjon = new String(r.getData(), r.getDataOffset(), r.getDataLength(), "UTF-8");
                                vbvo = (BasicConfigVo)GsonBuilder.create().fromJson(sjon, BasicConfigVo.class);
                            }
                            catch (Exception ex) {
                                returnF.setException((Throwable)new IOException("\u8f66\u573a\u670d\u52a1\u5668\u8fd4\u56de\u914d\u7f6e\u6570\u636e\u683c\u5f0f\u9519\u8bef"));
                                return;
                            }
                            returnF.setResult((Object)vbvo);
                        }
                    } else {
                        String msg = r.getHeaderValue("respMsg");
                        if (msg == null) {
                            msg = "\u64cd\u4f5c\u5931\u8d25";
                        }
                        try {
                            ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8bf7\u6c42\u5ba2\u6237\u7aef\u90e8\u7f72\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u4ee3\u7801\uff1a " + code + ", \u9519\u8bef\u539f\u56e0\uff1a" + msg));
                        }
                        finally {
                            returnF.setException((Throwable)new IOException("\u8bf7\u6c42\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + msg));
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            try {
                ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u8bf7\u6c42\u5b89\u88c5\u521d\u59cb\u5316\u4fe1\u606f\u5931\u8d25! " + ex.getMessage()));
            }
            finally {
                returnF.setException(ex);
            }
        }
        return returnF;
    }

    private void doLanClientInstall() {
        int port;
        String serverHostIp = this.connectServerHostText.getText();
        if (serverHostIp == null || (serverHostIp = serverHostIp.trim()).length() == 0) {
            this.msgLabel.setForeground(this.redColor);
            this.msgLabel.setText("\u8bf7\u8f93\u5165\u8f66\u573a\u670d\u52a1\u5668IP");
            return;
        }
        String serverHostPort = this.connectServerPortText.getText();
        if (serverHostPort == null || (serverHostPort = serverHostPort.trim()).length() == 0) {
            this.msgLabel.setForeground(this.redColor);
            this.msgLabel.setText("\u8bf7\u8f93\u5165\u8f66\u573a\u670d\u52a1\u5668\u7aef\u53e3\u53f7");
            return;
        }
        try {
            port = Integer.parseInt(serverHostPort);
            if (port < 1 || port > 65535) {
                this.msgLabel.setForeground(this.redColor);
                this.msgLabel.setText("\u7aef\u53e3\u5fc5\u987b\u662f\u57281-65535\u4e4b\u95f4");
                return;
            }
        }
        catch (Exception ex) {
            this.msgLabel.setForeground(this.redColor);
            this.msgLabel.setText("\u7aef\u53e3\u5fc5\u987b\u662f\u6570\u5b57");
            return;
        }
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u5c1d\u8bd5\u8fde\u63a5\u670d\u52a1\u5668...");
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        final String serverHost = serverHostIp;
        final int serverPort = port;
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                KeyValueEntry resultEntry = new KeyValueEntry();
                BasicConfigVo vo = null;
                CarparkHost marchHost = null;
                try {
                    KeyValueEntry kv = DeploySetupDialog.this.obtianSeverBasicConfigVo(serverHost, serverPort);
                    if (kv == null || kv.getValue() == null) {
                        if (kv == null || kv.getKey() == null || ((String)kv.getKey()).length() == 0) {
                            resultEntry.setKey((Object)1);
                            resultEntry.setValue((Object)("\u65e0\u6cd5\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c" + serverHost + ":" + serverPort));
                        } else {
                            resultEntry.setKey((Object)1);
                            resultEntry.setValue(kv.getKey());
                        }
                    } else {
                        vo = (BasicConfigVo)kv.getValue();
                        LinkedList<CarparkHost> allClientHosts = new LinkedList<CarparkHost>();
                        Set<String> ipSet = ServiceUtil.getServiceContext().getLocalIpv4(false);
                        if (vo.getHostList() != null && !vo.getHostList().isEmpty()) {
                            for (CarparkHost h : vo.getHostList()) {
                                if (h.getHost_use() != 1 || h.getNet_mode() != 1) continue;
                                allClientHosts.add(h);
                                if (!ipSet.contains(h.getHost_ip())) continue;
                                marchHost = h;
                            }
                        }
                        if (allClientHosts.isEmpty()) {
                            resultEntry.setKey((Object)2);
                            resultEntry.setValue((Object)"\u8f66\u573a\u7ba1\u7406\u7cfb\u7edf\u672a\u6dfb\u52a0\u4efb\u4f55\u5c97\u4ead\u5ba2\u6237\u7aef! \n\u60a8\u53ef\u70b9\u51fb\u3010\u53bb\u6ce8\u518c\u3011\u767b\u5f55\u670d\u52a1\u5668\uff0c\u5728\u3010\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e\u3011\u4e2d\u6dfb\u52a0\u4e00\u4e2a\u5c97\u4ead\u4e3b\u673a\u3002\u6ce8\u610f\u6dfb\u52a0\u7684\u4e3b\u673aIP\u4e0e\u672c\u673a\u64cd\u4f5c\u7cfb\u7edfIP\u4e00\u81f4\u5373\u53ef\u3002");
                        } else if (marchHost == null) {
                            resultEntry.setKey((Object)3);
                            StringBuilder sbr = new StringBuilder(128);
                            for (CarparkHost h : allClientHosts) {
                                if (sbr.length() > 0) {
                                    sbr.append('\u3001');
                                }
                                sbr.append(h.getHost_name()).append('(').append(h.getHost_ip()).append(')');
                            }
                            resultEntry.setValue((Object)("\u672a\u80fd\u5728\u8f66\u573a\u670d\u52a1\u5668\u914d\u7f6e\u4e2d\u627e\u5230\u672c\u673aIP\u5bf9\u5e94\u7684\u4e3b\u673a\uff01\n\u60a8\u53ef\u70b9\u51fb\u3010\u53bb\u6ce8\u518c\u3011\u767b\u5f55\u670d\u52a1\u5668\uff0c\u5728\u3010\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e\u3011\u4e2d\u6dfb\u52a0/\u4fee\u6539\u4e00\u4e2a\u5c97\u4ead\u4e3b\u673a\uff0c\u6ce8\u610f\u6dfb\u52a0/\u4fee\u6539\u7684\u4e3b\u673aIP\u4e0e\u672c\u673a\u64cd\u4f5c\u7cfb\u7edfIP\u4e00\u81f4\u5373\u53ef\u3002\n\u5f53\u7136\u4f60\u4e5f\u53ef\u4ee5\u5c06\u672c\u673a\u64cd\u4f5c\u7cfb\u7edfIP\u66f4\u6539\u6210\u4ee5\u4e0b\u4e3b\u673a\u4e2d\u7684\u4e00\u4e2a\u3002\u670d\u52a1\u5668\u5df2\u914d\u7f6e\u7684\u5c97\u4ead\u4e3b\u673a\uff1a" + sbr.toString()));
                        } else {
                            resultEntry.setKey((Object)0);
                            resultEntry.setValue((Object)("\u6210\u529f\u5728\u670d\u52a1\u5668\u914d\u7f6e\u4e2d\u627e\u5230\n\u4e0e\u672c\u673aIP\u914d\u7f6e\u4e00\u81f4\u7684\u5c97\u4ead\u4e3b\u673a\uff1a\n" + marchHost.getHost_name() + "(" + marchHost.getHost_ip() + ")\u3002\n\u60a8\u786e\u5b9a\u5c06\u672c\u673a\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a" + marchHost.getHost_name() + "\u5417\uff1f\n\u90e8\u7f72\u6210\u529f\u540e\u5c06\u4e0d\u53ef\u66f4\u6539\u3002"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    CarparkHost marchHost0 = marchHost;
                    BasicConfigVo configVo = vo;
                    SwingUtil.invokeLater(new Runnable(resultEntry, marchHost0, serverHost, serverPort, configVo){
                        private final /* synthetic */ KeyValueEntry val$resultEntry;
                        private final /* synthetic */ CarparkHost val$marchHost0;
                        private final /* synthetic */ String val$serverHost;
                        private final /* synthetic */ int val$serverPort;
                        private final /* synthetic */ BasicConfigVo val$configVo;
                        {
                            this.val$resultEntry = keyValueEntry;
                            this.val$marchHost0 = carparkHost;
                            this.val$serverHost = string;
                            this.val$serverPort = n;
                            this.val$configVo = basicConfigVo;
                        }

                        @Override
                        public void run() {
                            DeploySetupDialog.this.cancelButton.setEnabled(true);
                            DeploySetupDialog.this.okButton.setEnabled(true);
                            if (this.val$resultEntry.getKey() != null) {
                                if ((Integer)this.val$resultEntry.getKey() == 1) {
                                    DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                                    DeploySetupDialog.this.msgLabel.setText((String)this.val$resultEntry.getValue());
                                } else if ((Integer)this.val$resultEntry.getKey() == 2 || (Integer)this.val$resultEntry.getKey() == 3) {
                                    DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                                    DeploySetupDialog.this.msgLabel.setText("\u672c\u673aIP\u672a\u5728\u670d\u52a1\u5668\u4e2d\u6ce8\u518c\uff01");
                                    MacOptionDialog.showConfirmDialog(DeploySetupDialog.this, "\u672c\u673aIP\u672a\u6ce8\u518c", (String)this.val$resultEntry.getValue(), null, "\u53d6\u6d88", new Runnable(){

                                        protected String getUrl() {
                                            StringBuilder url = new StringBuilder(128).append("http://").append(val$serverHost);
                                            if (val$serverPort != 80) {
                                                url.append(':').append(val$serverPort);
                                            }
                                            url.append("/manage/showCarparkHost.action");
                                            return url.toString();
                                        }

                                        protected String getLogoutUrl() {
                                            StringBuilder url = new StringBuilder(128).append("http://").append(val$serverHost);
                                            if (val$serverPort != 80) {
                                                url.append(':').append(val$serverPort);
                                            }
                                            url.append("/manage/login/logout.action");
                                            return url.toString();
                                        }

                                        @Override
                                        public void run() {
                                            ServiceUtil.getServiceContext().getBrowserProcess().openUrl(this.getUrl(), this.getLogoutUrl());
                                            DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.msgColor);
                                            DeploySetupDialog.this.msgLabel.setText("\u5982\u679c\u5df2\u7ecf\u5728\u7ba1\u7406\u7cfb\u7edf\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u70b9\u51fb\u786e\u5b9a");
                                        }
                                    }, "\u53bb\u6ce8\u518c", Color.WHITE);
                                } else if ((Integer)this.val$resultEntry.getKey() == 0) {
                                    DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.msgColor);
                                    DeploySetupDialog.this.msgLabel.setText("\u8bf7\u786e\u8ba4\u60a8\u662f\u5426\u9700\u8981\u5c06\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a" + this.val$marchHost0.getHost_name());
                                    MacOptionDialog.showConfirmDialog(DeploySetupDialog.this, "\u8f6f\u4ef6\u90e8\u7f72\u786e\u8ba4", (String)this.val$resultEntry.getValue(), new Runnable(){

                                        @Override
                                        public void run() {
                                            DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.msgColor);
                                            DeploySetupDialog.this.msgLabel.setText("\u60a8\u653e\u5f03\u4e86\u5c06\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a" + val$marchHost0.getHost_name());
                                        }
                                    }, "\u53d6\u6d88", new Runnable(){

                                        @Override
                                        public void run() {
                                            DeploySetupDialog.this.doInstanllClient(val$serverHost, val$serverPort, val$marchHost0, val$configVo);
                                        }
                                    }, "\u786e\u8ba4", Color.WHITE);
                                }
                            }
                        }
                    });
                    throw throwable;
                }
                CarparkHost marchHost0 = marchHost;
                BasicConfigVo configVo = vo;
                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void doInstanllClient9(String serverHost, int serverPort, CarparkHost installHost, BasicConfigVo vo, String cloud_host_id, String cloud_carpark_sign_key, int orgId, int carparkDeployType, int host_type) {
        block21: {
            Throwable ex1 = null;
            CarparkInitEntry initEntry0 = null;
            try {
                try {
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    try (SqlSession session = commonDaoService.openSqlSession();){
                        try {
                            Calendar cl = Calendar.getInstance();
                            cl.set(14, 0);
                            Date now = cl.getTime();
                            cl.set(2019, 0, 1, 0, 0, 0);
                            int seq_prefix = Math.abs((int)((now.getTime() - cl.getTimeInMillis()) / 1000L));
                            commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(Carpark.class)));
                            commonDaoService.insert(session, (Object)vo.getCarpark());
                            CarparkLocalConfig localConfig = new CarparkLocalConfig();
                            localConfig.setAuth_info(null);
                            localConfig.setCarpark_id(installHost.getCarpark_id());
                            localConfig.setHost_no(installHost.getHost_no());
                            localConfig.setHost_use(installHost.getHost_use());
                            localConfig.setId(1);
                            localConfig.setNet_mode(installHost.getNet_mode());
                            localConfig.setProject_id(installHost.getProject_id());
                            localConfig.setSeq_prefix(seq_prefix);
                            localConfig.setServer_host_port(String.valueOf(serverHost) + ":" + serverPort);
                            localConfig.setCarpark_deploy_type(carparkDeployType);
                            localConfig.setHost_type(host_type);
                            localConfig.setOrg_id(orgId);
                            if (cloud_host_id != null && cloud_host_id.length() > 0) {
                                localConfig.setCloud_host_id(cloud_host_id);
                            }
                            if (cloud_carpark_sign_key != null && cloud_carpark_sign_key.length() > 0) {
                                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                                String cloud_carpark_sign_key1 = CryptoUtil.encrypt((String)cloud_carpark_sign_key, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                                localConfig.setCloud_carpark_sign_key(cloud_carpark_sign_key1);
                            }
                            commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkLocalConfig.class)));
                            commonDaoService.insert(session, (Object)localConfig);
                            commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkHost.class)));
                            for (CarparkHost h : vo.getHostList()) {
                                commonDaoService.insert(session, (Object)h);
                            }
                            if (vo.getRoleList() != null && !vo.getRoleList().isEmpty()) {
                                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkRole.class)));
                                for (CarparkRole r : vo.getRoleList()) {
                                    commonDaoService.insert(session, (Object)r);
                                }
                            }
                            if (vo.getUserList() != null && !vo.getUserList().isEmpty()) {
                                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkUser.class)));
                                for (CarparkUser u : vo.getUserList()) {
                                    commonDaoService.insert(session, (Object)u);
                                }
                            }
                            session.commit();
                            initEntry0 = new CarparkInitEntry(vo.getCarpark(), installHost, localConfig);
                        }
                        catch (Throwable ex) {
                            session.rollback();
                            throw ex;
                        }
                    }
                    String fileName = "syncData.conf";
                    File file = new File(PathFinder.findLocalRuntimeDir(), fileName);
                    if (file.exists() && file.isFile()) {
                        file.delete();
                    }
                    fileName = "cloudSync.conf";
                    file = new File(PathFinder.findLocalRuntimeDir(), "cloud/" + fileName);
                    if (file.exists() && file.isFile()) {
                        file.delete();
                    }
                    fileName = "cloudPicSync.conf";
                    file = new File(PathFinder.findLocalRuntimeDir(), "cloud/" + fileName);
                    if (file.exists() && file.isFile()) {
                        file.delete();
                    }
                }
                catch (Throwable ex) {
                    ex1 = ex;
                    ServiceLog.getLog().warn((Object)"", ex);
                    Throwable ex2 = ex1;
                    CarparkInitEntry initEntry = initEntry0;
                    SwingUtil.invokeLater(new Runnable(ex2, initEntry){
                        private final /* synthetic */ Throwable val$ex;
                        private final /* synthetic */ CarparkInitEntry val$initEntry;
                        {
                            this.val$ex = throwable;
                            this.val$initEntry = carparkInitEntry;
                        }

                        @Override
                        public void run() {
                            if (DeploySetupDialog.this.netModeSelect != null && !DeploySetupDialog.this.netModeSelect.isEnabled()) {
                                DeploySetupDialog.this.netModeSelect.setEnabled(true);
                            }
                            if (DeploySetupDialog.this.connectServerHostText != null && !DeploySetupDialog.this.connectServerHostText.isEnabled()) {
                                DeploySetupDialog.this.connectServerHostText.setEnabled(true);
                            }
                            if (DeploySetupDialog.this.connectServerPortText != null && !DeploySetupDialog.this.connectServerPortText.isEnabled()) {
                                DeploySetupDialog.this.connectServerPortText.setEnabled(true);
                            }
                            if (DeploySetupDialog.this.deployTypeSelect != null && !DeploySetupDialog.this.deployTypeSelect.isEnabled()) {
                                DeploySetupDialog.this.deployTypeSelect.setEnabled(true);
                            }
                            DeploySetupDialog.this.cancelButton.setEnabled(true);
                            DeploySetupDialog.this.okButton.setEnabled(true);
                            if (this.val$ex != null) {
                                DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                                DeploySetupDialog.this.msgLabel.setText("\u4fdd\u5b58\u8bbe\u7f6e\u5931\u8d25\uff01\u539f\u56e0:" + this.val$ex.getMessage());
                            } else {
                                DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.msgColor);
                                DeploySetupDialog.this.msgLabel.setText("\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01");
                                try {
                                    DeploySetupDialog.this.dispose();
                                }
                                finally {
                                    DeploySetupDialog.this.localConfigFuture.setResult((Object)this.val$initEntry);
                                }
                            }
                        }
                    });
                    break block21;
                }
            }
            catch (Throwable throwable) {
                Throwable ex = ex1;
                CarparkInitEntry initEntry = initEntry0;
                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Throwable ex = ex1;
            CarparkInitEntry initEntry = initEntry0;
            SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void doInstanllClient(final String serverHost, final int serverPort, final CarparkHost installHost, final BasicConfigVo vo) {
        if (vo.getCarpark() == null) {
            MacOptionDialog.showAlertDialog(this, "\u670d\u52a1\u5668\u672a\u914d\u7f6e\u505c\u8f66\u573a", "\u9519\u8bef\uff0c\u670d\u52a1\u5668\u7ba1\u7406\u7cfb\u7edf\u672a\u914d\u7f6e\u505c\u8f66\u573a\uff0c\u8bf7\u5148\u914d\u7f6e\u518d\u91cd\u65b0\u521d\u59cb\u5316", null, "\u5173\u95ed", Color.WHITE);
            return;
        }
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u4fdd\u5b58\u8bbe\u7f6e...");
        this.clientHostLabel.setText("\u8f6f\u4ef6\u90e8\u7f72\u6210\uff1a");
        this.clientHostText.setText(String.valueOf(installHost.getHost_name()) + " [" + installHost.getHost_ip() + "]");
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                DeploySetupDialog.this.doInstanllClient9(serverHost, serverPort, installHost, vo, null, null, 0, 0, 1);
            }
        });
    }

    private static void showMessage(final String text, final JLabel j, final Color c) {
        if (j == null) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Color c1;
                if (!(c == null || (c1 = j.getForeground()) != null && c1.equals(c))) {
                    j.setForeground(c);
                }
                j.setText(text);
            }
        });
    }

    private KeyValueEntry<String, BasicConfigVo> obtianSeverBasicConfigVo(String serverHost, int serverPort) {
        try {
            String url = "http://" + serverHost;
            if (serverPort != 80) {
                url = String.valueOf(url) + ":" + serverPort;
            }
            url = String.valueOf(url) + "/obtainInstallClientVo.action";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            ProductLicense productLicense = ProductLicense.read();
            String v_org = String.valueOf(productLicense.getOrg_id());
            String v_id = String.valueOf(productLicense.getId());
            String v_mills = String.valueOf(System.currentTimeMillis());
            String v_ver = ServiceUtil.getServiceContext().getVersion();
            paramMap.put("v_org", v_org);
            paramMap.put("v_id", v_id);
            paramMap.put("v_mills", v_mills);
            paramMap.put("v_ver", v_ver);
            paramMap.put("v_sign", CryptoUtil.MD5Encode((String)(String.valueOf(v_org) + "&" + v_id + "&" + v_mills + "&" + v_ver + "&" + productLicense.getAuth_sign_key())));
            KeyValueEntry<String, String> vToken = InstallInitAction.createOPTocken(paramMap);
            url = String.valueOf(url) + "?optocken=" + (String)vToken.getValue();
            String result = (String)HttpUtil.doRequest((String)url.toString(), null, null, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)5000, (int)8000);
            if (result == null || result.length() == 0) {
                return new KeyValueEntry((Object)"\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u7a7a\u6570\u636e", null);
            }
            if (result.startsWith("ERROR:")) {
                return new KeyValueEntry((Object)result.substring(6), null);
            }
            if (result.startsWith((String)vToken.getKey())) {
                String resultJsonHex = result.substring(((String)vToken.getKey()).length() + 1);
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                String resultJson = CryptoUtil.decrypt((String)resultJsonHex, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                BasicConfigVo vo = (BasicConfigVo)GsonBuilder.create().fromJson(resultJson, BasicConfigVo.class);
                return new KeyValueEntry((Object)"SUCCESS", (Object)vo);
            }
            return new KeyValueEntry((Object)"\u670d\u52a1\u5668\u8fd4\u56de\u672a\u77e5\u6570\u636e", null);
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)"", ex);
            return new KeyValueEntry((Object)("\u65e0\u6cd5\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c" + serverHost + ":" + serverPort), null);
        }
    }

    private void doServerConfirm() {
        if (!this.okButton.isEnabled()) {
            return;
        }
        ComboBoxEntry entry = (ComboBoxEntry)((Object)this.deployTypeSelect.getSelectedItem());
        final int deployType = (Integer)entry.getKey();
        final int port = Integer.parseInt(this.localPortText.getText().trim());
        final String ip = (String)this.localIPBox.getSelectedItem();
        final String carparkName = this.carparkNameText.getText().trim();
        final String serverName = this.serverNameText.getText().trim();
        ComboBoxEntry deEQ = (ComboBoxEntry)((Object)this.defaultEqelect.getSelectedItem());
        final String deEQName = (String)deEQ.getKey();
        this.msgLabel.setForeground(this.msgColor);
        this.msgLabel.setText("\u6b63\u5728\u751f\u6210\u521d\u59cb\u5316\u6570\u636e...");
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block26: {
                    Throwable ex1 = null;
                    CarparkInitEntry initEntry0 = null;
                    try {
                        try {
                            Date now;
                            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                            try (SqlSession session = commonDaoService.openSqlSession();){
                                Connection con = session.getConnection();
                                boolean autoCommit = con.getAutoCommit();
                                try {
                                    con.setAutoCommit(true);
                                    LinkedList<URL> sqlUrlList = new LinkedList<URL>();
                                    URL sqlurl = ServiceUtil.getServiceContext().getBundleContext().getBundle().getResource("com/wovoe/carpark/resource/InitData.sql");
                                    sqlUrlList.add(sqlurl);
                                    JdbcSqlExecutor.checkAndUpdateDatabaseStruct((ExecuteSqlCallback)new ExecuteSqlCallback(){

                                        public void logMessage(String message) {
                                            DeploySetupDialog.this.setprocessMessage(message);
                                        }

                                        public boolean isNeedExeSql(String sql, String type, int version) {
                                            return true;
                                        }

                                        public void logExeSql(int version, String sql) {
                                            if (ServiceUtil.getServiceContext().isDevEnvironment()) {
                                                ServiceLog.getLog().info((Object)("exe sql version:" + version + ",sql:" + sql));
                                            }
                                        }

                                        public boolean continueExeWhenException(String sql, String type, int version, Throwable ex) {
                                            ServiceLog.getLog().warn((Object)("\u6267\u884cSQL\u5f02\u5e38:" + sql), ex);
                                            boolean isDev = ServiceUtil.getServiceContext().isDevEnvironment();
                                            return !isDev;
                                        }

                                        public String beforeExeSql(String sql) {
                                            return sql;
                                        }
                                    }, (Connection)con, sqlUrlList, (String)"ck", (String)"UTF-8");
                                }
                                finally {
                                    con.setAutoCommit(autoCommit);
                                }
                            }
                            Integer project_id = 1;
                            Integer carpark_id = 1;
                            Calendar cl = Calendar.getInstance();
                            cl.set(14, 0);
                            Date created_time = now = cl.getTime();
                            Date last_updated_time = now;
                            Carpark carPark = new Carpark();
                            carPark.setCarpark_name(ServiceUtil.getString(carparkName, 45));
                            carPark.setCloud_carpark_id(null);
                            carPark.setCloud_carpark_sign_key(null);
                            carPark.setCreated_time(created_time);
                            carPark.setId(carpark_id);
                            carPark.setLan_sign_key(RandomStringGenerator.getDefaultInstance().getNewString(16));
                            carPark.setLast_updated_time(last_updated_time);
                            carPark.setProject_id(project_id);
                            carPark.setValid_date(null);
                            ProductLicense license = ProductLicense.read();
                            String signData = String.valueOf(license.getOrg_id()) + "@#$" + carPark.getLan_sign_key() + "!-_+" + license.getAuth_sign_key() + "!-_+" + license.getId();
                            carPark.setData_sign(CryptoUtil.MD5Encode((String)signData));
                            CarparkHost serverHost = new CarparkHost();
                            serverHost.setId(commonDaoService.getSequece("ck_common_seq"));
                            serverHost.setHost_no("C" + serverHost.getId());
                            serverHost.setCarpark_id(1);
                            serverHost.setCreated_time(created_time);
                            serverHost.setDisable(0);
                            serverHost.setHost_ip(ip);
                            serverHost.setHost_name(ServiceUtil.getString(serverName, 45));
                            serverHost.setHost_port(port);
                            serverHost.setHost_type(1);
                            serverHost.setHost_use(deployType);
                            serverHost.setLast_updated_time(last_updated_time);
                            serverHost.setNet_mode(1);
                            serverHost.setProject_id(project_id);
                            cl.set(2019, 0, 1, 0, 0, 0);
                            int seq_prefix = Math.abs((int)((now.getTime() - cl.getTimeInMillis()) / 1000L));
                            CarparkLocalConfig localConfig = new CarparkLocalConfig();
                            localConfig.setAuth_info(null);
                            localConfig.setCarpark_id(carpark_id);
                            localConfig.setHost_no(serverHost.getHost_no());
                            localConfig.setHost_use(serverHost.getHost_use());
                            localConfig.setId(1);
                            localConfig.setNet_mode(serverHost.getNet_mode());
                            localConfig.setProject_id(project_id);
                            localConfig.setSeq_prefix(seq_prefix);
                            localConfig.setServer_host_port(String.valueOf(serverHost.getHost_ip()) + ":" + serverHost.getHost_port());
                            localConfig.setOrg_id(0);
                            localConfig.setCarpark_deploy_type(0);
                            localConfig.setHost_type(1);
                            CarparkArea area = new CarparkArea();
                            area.setId(commonDaoService.getSequece("ck_common_seq"));
                            area.setArea_no("C" + area.getId());
                            area.setArea_level(1);
                            area.setArea_name("\u5916\u573a");
                            area.setArea_number(1);
                            area.setCarpark_id(carpark_id);
                            area.setChildren(null);
                            area.setCreated_time(created_time);
                            area.setLast_updated_time(last_updated_time);
                            area.setParent_area_no("");
                            area.setProject_id(project_id);
                            area.setSpace_quantities(100);
                            CarparkRolePermission permission = null;
                            if (serverHost.getHost_use() == 3) {
                                permission = new CarparkRolePermission();
                                permission.setCarpark_id(carpark_id);
                                permission.setId(commonDaoService.getSequece("ck_common_seq"));
                                permission.setLast_updated_time(now);
                                permission.setPermission_no("long_host_client_" + serverHost.getHost_no());
                                permission.setProject_id(project_id);
                                permission.setRole_no("2");
                            }
                            session = commonDaoService.openSqlSession();
                            try {
                                try {
                                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(carPark.getClass())).addEQ("id", (Object)carPark.getId()));
                                    commonDaoService.insert((Object)carPark);
                                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(serverHost.getClass())).addEQ("id", (Object)serverHost.getId()));
                                    commonDaoService.insert((Object)serverHost);
                                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(localConfig.getClass())).addEQ("id", (Object)localConfig.getId()));
                                    commonDaoService.insert((Object)localConfig);
                                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(area.getClass())).addEQ("id", (Object)area.getId()));
                                    commonDaoService.insert((Object)area);
                                    if (permission != null) {
                                        commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(permission.getClass())).addEQ("permission_no", (Object)permission.getPermission_no()).addEQ("role_no", (Object)permission.getRole_no()));
                                        commonDaoService.insert((Object)permission);
                                    }
                                    if (deployType == 3) {
                                        BasicSettingServiceImpl bac = new BasicSettingServiceImpl();
                                        int chanelNumber = 1;
                                        while (chanelNumber <= 2) {
                                            CarparkChannel channel = new CarparkChannel();
                                            channel.setId(commonDaoService.getSequece("ck_common_seq"));
                                            channel.setCarpark_id(carpark_id);
                                            channel.setChannel_mode(0);
                                            channel.setChannel_name(chanelNumber == 1 ? "\u5927\u95e8\u5165\u53e3" : "\u5927\u95e8\u51fa\u53e3");
                                            channel.setChannel_no("C" + channel.getId());
                                            channel.setChannel_number(chanelNumber);
                                            channel.setChannel_type(0);
                                            channel.setCreated_time(now);
                                            channel.setDisable(0);
                                            channel.setLast_updated_time(channel.getCreated_time());
                                            channel.setManaged_host_no(serverHost.getHost_no());
                                            channel.setProject_id(project_id);
                                            commonDaoService.insert(session, (Object)channel);
                                            CarparkChannelArea channelArea = new CarparkChannelArea();
                                            channelArea.setArea_no(area.getArea_no());
                                            channelArea.setCarpark_id(carpark_id);
                                            channelArea.setChannel_direction(chanelNumber == 1 ? 0 : 1);
                                            channelArea.setChannel_no(channel.getChannel_no());
                                            channelArea.setId(commonDaoService.getSequece("ck_common_seq"));
                                            channelArea.setLast_updated_time(last_updated_time);
                                            channelArea.setProject_id(project_id);
                                            commonDaoService.insert(session, (Object)channelArea);
                                            String productName = deEQName;
                                            if (productName == null || productName.length() == 0) {
                                                productName = ProductDrivers.getDefaultProductName();
                                            }
                                            bac.insertDefaultChannelEquipments(carpark_id, project_id, channel.getChannel_no(), commonDaoService, session, serverHost.getHost_ip(), productName);
                                            if (deEQName != null && deEQName.length() > 0) {
                                                CarparkStrategy strategy = (CarparkStrategy)commonDaoService.selectOne(session, new SearchParam().addEQ("strategy_name", (Object)"DEFAULT_DQ_TYPES").addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkStrategy.class);
                                                if (strategy != null) {
                                                    if (!deEQName.equals(strategy.getStrategy_value())) {
                                                        CommonParam updatep = new CommonParam(commonDaoService.getTableName(CarparkStrategy.class));
                                                        updatep.addEQ("id", (Object)strategy.getId());
                                                        updatep.addUpdate("strategy_value", (Object)deEQName);
                                                        commonDaoService.update(session, updatep);
                                                    }
                                                } else {
                                                    strategy = new CarparkStrategy();
                                                    strategy.setId(commonDaoService.getSequece("ck_common_seq"));
                                                    strategy.setStrategy_name("DEFAULT_DQ_TYPES");
                                                    strategy.setStrategy_value(deEQName);
                                                    strategy.setArea_no("");
                                                    strategy.setChannel_no("");
                                                    strategy.setPassport_type_no("");
                                                    strategy.setCar_type_no("");
                                                    strategy.setCreated_time(created_time);
                                                    strategy.setLast_updated_time(last_updated_time);
                                                    strategy.setCarpark_id(carpark_id);
                                                    strategy.setProject_id(project_id);
                                                    commonDaoService.insert(session, (Object)strategy);
                                                }
                                            }
                                            ++chanelNumber;
                                        }
                                    }
                                    session.commit();
                                    initEntry0 = new CarparkInitEntry(carPark, serverHost, localConfig);
                                }
                                catch (Exception ex) {
                                    session.rollback();
                                    throw ex;
                                }
                            }
                            finally {
                                session.close();
                            }
                        }
                        catch (Throwable ex) {
                            ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
                            Throwable ex2 = ex1 = ex;
                            CarparkInitEntry initEntry = initEntry0;
                            SwingUtil.invokeLater(new Runnable(ex2, initEntry){
                                private final /* synthetic */ Throwable val$ex;
                                private final /* synthetic */ CarparkInitEntry val$initEntry;
                                {
                                    this.val$ex = throwable;
                                    this.val$initEntry = carparkInitEntry;
                                }

                                @Override
                                public void run() {
                                    if (this.val$ex != null) {
                                        DeploySetupDialog.this.okButton.setEnabled(true);
                                        DeploySetupDialog.this.cancelButton.setEnabled(true);
                                        DeploySetupDialog.this.msgLabel.setForeground(DeploySetupDialog.this.redColor);
                                        DeploySetupDialog.this.msgLabel.setText("\u751f\u6210\u521d\u59cb\u5316\u6570\u636e\u9519\u8bef!" + this.val$ex.getMessage());
                                        return;
                                    }
                                    try {
                                        DeploySetupDialog.this.dispose();
                                    }
                                    finally {
                                        DeploySetupDialog.this.localConfigFuture.setResult((Object)this.val$initEntry);
                                    }
                                }
                            });
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable ex = ex1;
                        CarparkInitEntry initEntry = initEntry0;
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    Throwable ex = ex1;
                    CarparkInitEntry initEntry = initEntry0;
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    @Override
    public void setprocessMessage(String processMessage) {
        this.setprocessMessage(processMessage, null);
    }

    public void setprocessMessage(final String processMessage, final Color color) {
        if (this.msgLabel != null) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (color != null) {
                        DeploySetupDialog.this.msgLabel.setForeground(color);
                    }
                    DeploySetupDialog.this.msgLabel.setText(processMessage);
                }
            });
        }
    }

    public static KeyValueEntry<String, Object> getCloudDeployConfig(String cloudHostId, String cloudSignKey, long timeOutMills) {
        CarparkClientDeploy clientDeploy;
        Map responseMap;
        String responseJon;
        String resutTxt;
        CloudConnectTransferCrypto transferCrypto = new CloudConnectTransferCrypto();
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        requestMap.put("hostId", cloudHostId);
        String requstRand = RandomStringGenerator.getDefaultInstance().getNewString(32);
        requestMap.put("rand", requstRand);
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        HardWareInfo info = HardWareUtils.getHardWareInfo();
        infoMap.put("motherboardSn", info.getMotherboardSn());
        infoMap.put("cpuSn", info.getCpuSn());
        infoMap.put("hardDiskSn", info.getHardDiskSn());
        infoMap.put("mac", info.getMac());
        Gson gson = GsonBuilder.create();
        String va = gson.toJson(infoMap);
        requestMap.put("hardWare", va);
        requestMap.put("doCloudBind", "1");
        requestMap.put("sign", DeploySetupDialog.getSign(requestMap, cloudSignKey));
        String vw = transferCrypto.encrypt(gson.toJson(requestMap));
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("clientDeployx", vw);
        String requestHost = DeploySetupDialog.getObtainConnectDomain();
        long vMills = ServiceUtil.getServiceContext().currentTimeMillis();
        String url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
        try {
            if (timeOutMills < 8000L) {
                timeOutMills = 8000L;
            }
            Proxy proxy = WanNetHostSelector.getWanProxyHost(requestHost).getProxy();
            resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)6000, (int)((int)timeOutMills), (Proxy)proxy);
            long x1 = ServiceUtil.getServiceContext().currentTimeMillis() - vMills;
            timeOutMills = timeOutMills > x1 ? (timeOutMills -= x1) : 0L;
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
            return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
        }
        if (resutTxt == null || resutTxt.length() == 0) {
            ServiceLog.getLog().error((Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
        }
        try {
            responseJon = transferCrypto.decrypt(resutTxt);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
        }
        try {
            responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
        }
        String code = (String)responseMap.get("code");
        String msg = (String)responseMap.get("msg");
        if ("REQUEST_ERROR".equals(code) || "URLEXPIRE_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        if ("SIGN_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)"\u4e91\u7aef\u901a\u4fe1\u79d8\u94a5\u9519\u8bef");
        }
        String respSign = (String)responseMap.get("sign");
        if (respSign == null || respSign.length() == 0) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u7f3a\u5931\u7b7e\u540d");
        }
        String checkSign = DeploySetupDialog.getSign(responseMap, cloudSignKey);
        if (!respSign.equals(checkSign)) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u9a8c\u7b7e\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u5931\u8d25!");
        }
        if (!"SUCCESS".equals(code)) {
            if (code == null || code.length() == 0) {
                code = "ERROR";
            }
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        String deployConfig = (String)responseMap.get("deployConfig");
        if (deployConfig == null || deployConfig.length() == 0) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u914d\u7f6e\u6570\u636e");
        }
        try {
            clientDeploy = (CarparkClientDeploy)GsonBuilder.create().fromJson(deployConfig, CarparkClientDeploy.class);
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u914d\u7f6e\u6570\u636e\u683c\u5f0f\u9519\u8bef");
        }
        return new KeyValueEntry((Object)"SUCCESS", (Object)clientDeploy);
    }

    public static KeyValueEntry<String, Object> validateCloudHostId0(String cloudHostId, String cloudSignKey, long timeOutMills, JLabel logMsgLabel) {
        long serverMills;
        Map responseMap;
        String responseJon;
        String resutTxt;
        CloudConnectTransferCrypto transferCrypto = new CloudConnectTransferCrypto();
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        requestMap.put("hostId", cloudHostId);
        String requstRand = RandomStringGenerator.getDefaultInstance().getNewString(32);
        requestMap.put("rand", requstRand);
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        HardWareInfo info = HardWareUtils.getHardWareInfo();
        infoMap.put("motherboardSn", info.getMotherboardSn());
        infoMap.put("cpuSn", info.getCpuSn());
        infoMap.put("hardDiskSn", info.getHardDiskSn());
        infoMap.put("mac", info.getMac());
        Gson gson = GsonBuilder.create();
        String va = gson.toJson(infoMap);
        requestMap.put("hardWare", va);
        requestMap.put("sign", DeploySetupDialog.getSign(requestMap, cloudSignKey));
        String vw = transferCrypto.encrypt(gson.toJson(requestMap));
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("clientDeployx", vw);
        String requestHost = DeploySetupDialog.getObtainConnectDomain();
        long vMills = ServiceUtil.getServiceContext().currentTimeMillis();
        String url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
        try {
            long tout = 8000L;
            if (timeOutMills < tout) {
                tout = timeOutMills;
            }
            resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)6000, (int)((int)tout));
            long x1 = ServiceUtil.getServiceContext().currentTimeMillis() - vMills;
            timeOutMills = timeOutMills > x1 ? (timeOutMills -= x1) : 0L;
        }
        catch (Exception ex) {
            DeploySetupDialog.showMessage("\u76f4\u8fde\u4e91\u7aef\u5931\u8d25,\u6b63\u5728\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u4ee3\u7406\u7f51\u7edc...", logMsgLabel, null);
            WanNetConnectCheckJob.getInstance().enableProxySearcher(true);
            WanNetConnectCheckJob.getInstance().checkRun();
            if (!WanNetConnectCheckJob.getInstance().isWanNetOk()) {
                ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
                return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
            }
            try {
                long tout = 8000L;
                if (timeOutMills < tout) {
                    tout = timeOutMills;
                }
                Proxy proxy = WanNetHostSelector.getWanProxyHost(requestHost).getProxy();
                resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)6000, (int)((int)tout), (Proxy)proxy);
            }
            catch (Exception ex1) {
                ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex1.getMessage()));
                return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
            }
        }
        if (resutTxt == null || resutTxt.length() == 0) {
            ServiceLog.getLog().error((Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
        }
        try {
            responseJon = transferCrypto.decrypt(resutTxt);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
        }
        try {
            responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
        }
        String code = (String)responseMap.get("code");
        String msg = (String)responseMap.get("msg");
        if ("REQUEST_ERROR".equals(code) || "URLEXPIRE_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        if ("SIGN_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)"\u4e91\u7aef\u901a\u4fe1\u79d8\u94a5\u9519\u8bef");
        }
        String respSign = (String)responseMap.get("sign");
        if (respSign == null || respSign.length() == 0) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u7f3a\u5931\u7b7e\u540d");
        }
        String checkSign = DeploySetupDialog.getSign(responseMap, cloudSignKey);
        if (!respSign.equals(checkSign)) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u9a8c\u7b7e\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u5931\u8d25!");
        }
        if (!"SUCCESS".equals(code)) {
            if (code == null || code.length() == 0) {
                code = "ERROR";
            }
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        String carparkDeployType = (String)responseMap.get("carpark_deploy_type");
        if (carparkDeployType == null || carparkDeployType.length() == 0) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u8f66\u573a\u90e8\u7f72\u7c7b\u578b!");
        }
        try {
            serverMills = Long.parseLong((String)responseMap.get("sMills"));
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u670d\u52a1\u5668\u65f6\u95f4!");
        }
        if (Math.abs(serverMills - System.currentTimeMillis()) > 2000L) {
            ServiceUtil.setSystemTime(new Date(serverMills));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (String.valueOf(1).equals(carparkDeployType)) {
            return new KeyValueEntry((Object)"SUCCESS", (Object)responseMap);
        }
        WanNetConnectCheckJob.getInstance().enableProxySearcher(false);
        WanNetConnectCheckJob.getInstance().checkRun();
        if (!WanNetConnectCheckJob.getInstance().isDirectWanOk()) {
            WanNetConnectCheckJob.getInstance().enableProxySearcher(false);
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u7ed1\u5b9a\u8f66\u573a\u4e3a\u79bb\u7ebf\u90e8\u7f72\u7c7b\u578b!\u4f46\u5f53\u524d\u7535\u8111\u4e0d\u80fd\u76f4\u8fde\u5e73\u53f0,\u8bf7\u68c0\u6d4b\u7f51\u7edc\u73af\u5883");
        }
        DeploySetupDialog.showMessage("\u6b63\u5728\u68c0\u6d4b\u7f51\u7edc\u73af\u5883...", logMsgLabel, null);
        return DeploySetupDialog.validateCloudHostId(cloudHostId, cloudSignKey, timeOutMills, logMsgLabel);
    }

    public static KeyValueEntry<String, Object> validateCloudHostId(String cloudHostId, String cloudSignKey, long timeOutMills, JLabel logMsgLabel) {
        long serverMills;
        Map responseMap;
        String responseJon;
        String resutTxt;
        CloudConnectTransferCrypto transferCrypto = new CloudConnectTransferCrypto();
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        requestMap.put("hostId", cloudHostId);
        String requstRand = RandomStringGenerator.getDefaultInstance().getNewString(32);
        requestMap.put("rand", requstRand);
        String requestMills = String.valueOf(System.currentTimeMillis());
        requestMap.put("reqMills", requestMills);
        requestMap.put("sign", DeploySetupDialog.getSign(requestMap, cloudSignKey));
        Gson gson = GsonBuilder.create();
        String vw = transferCrypto.encrypt(gson.toJson(requestMap));
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("clientDeploy", vw);
        String requestHost = DeploySetupDialog.getObtainConnectDomain();
        long vMills = ServiceUtil.getServiceContext().currentTimeMillis();
        String url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
        try {
            long tout = 8000L;
            if (timeOutMills < tout) {
                tout = timeOutMills;
            }
            resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)((int)tout), (int)((int)tout));
            long x1 = ServiceUtil.getServiceContext().currentTimeMillis() - vMills;
            timeOutMills = timeOutMills > x1 ? (timeOutMills -= x1) : 0L;
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
            return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
        }
        if (resutTxt == null || resutTxt.length() == 0) {
            ServiceLog.getLog().error((Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
        }
        try {
            responseJon = transferCrypto.decrypt(resutTxt);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
        }
        try {
            responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
        }
        String code = (String)responseMap.get("code");
        if ("URLEXPIRE_ERROR".equals(code)) {
            try {
                serverMills = Long.parseLong((String)responseMap.get("sMills"));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u7cfb\u7edf\u65f6\u95f4\u4e0e\u4e91\u7aef\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927,\u88ab\u62d2\u7edd\u8fde\u63a5!");
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u7cfb\u7edf\u65f6\u95f4\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927\uff01\u8bf7\u4fee\u540c\u6b65\u64cd\u4f5c\u7cfb\u7edf\u65f6\u95f4\u4e3a\u5317\u4eac\u65f6\u95f4!");
            }
            DeploySetupDialog.showMessage("\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927\uff0c\u6b63\u5728\u91cd\u65b0\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4\uff0c\u5e76\u91cd\u65b0\u8fde\u63a5\u4e91\u7aef...", logMsgLabel, null);
            ServiceLog.getLog().warn((Object)("\u7cfb\u7edf\u65f6\u95f4\u4e0e\u4e91\u7aef\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927,\u88ab\u62d2\u7edd\u8fde\u63a5!\u8fd9\u5c06\u540c\u6b65\u7cfb\u7edf\u65f6\u95f4\u91cd\u65b0\u5c1d\u8bd5\uff0c\u4e91\u670d\u52a1\u5668\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(serverMills))));
            ServiceUtil.setSystemTime(new Date(serverMills));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            requestMap.put("reqMills", String.valueOf(serverMills));
            requestMap.put("sign", DeploySetupDialog.getSign(requestMap, cloudSignKey));
            vw = transferCrypto.encrypt(gson.toJson(requestMap));
            postParam.put("clientDeploy", vw);
            if (timeOutMills < 3000L) {
                timeOutMills = 3000L;
            }
            vMills = ServiceUtil.getServiceContext().currentTimeMillis();
            url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
            try {
                long tout = 8000L;
                if (timeOutMills < tout) {
                    tout = timeOutMills;
                }
                resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)((int)tout), (int)((int)tout));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
                return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
            }
            try {
                responseJon = transferCrypto.decrypt(resutTxt);
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
            }
            try {
                responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
            }
            code = (String)responseMap.get("code");
        } else {
            try {
                String sMills = (String)responseMap.get("sMills");
                if (sMills != null && sMills.length() > 0) {
                    serverMills = Long.parseLong((String)responseMap.get("sMills"));
                    long av = Math.abs(System.currentTimeMillis() - serverMills);
                    if (av > TimeUnit.SECONDS.toMillis(30L)) {
                        ServiceUtil.setSystemTime(new Date(serverMills));
                    }
                }
            }
            catch (Exception sMills) {
                // empty catch block
            }
        }
        String msg = (String)responseMap.get("msg");
        if ("REQUEST_ERROR".equals(code) || "URLEXPIRE_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        if ("SIGN_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)"\u4e91\u7aef\u901a\u4fe1\u79d8\u94a5\u9519\u8bef");
        }
        String respSign = (String)responseMap.get("sign");
        if (respSign == null || respSign.length() == 0) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u7f3a\u5931\u7b7e\u540d");
        }
        String checkSign = DeploySetupDialog.getSign(responseMap, cloudSignKey);
        if (!respSign.equals(checkSign)) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u9a8c\u7b7e\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u5931\u8d25!");
        }
        if (!"SUCCESS".equals(code)) {
            if (code == null || code.length() == 0) {
                code = "ERROR";
            }
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        String cloudParkId = (String)responseMap.get("cloudParkId");
        String carparkName = (String)responseMap.get("carparkName");
        String hostNo = (String)responseMap.get("hostNo");
        String hostName = (String)responseMap.get("hostName");
        String _cloudHostId = (String)responseMap.get("cloudHostId");
        if (cloudParkId == null || cloudParkId.length() == 0 || carparkName == null || carparkName.length() == 0 || hostNo == null || hostNo.length() == 0 || hostName == null || hostName.length() == 0 || _cloudHostId == null || _cloudHostId.length() == 0 || !cloudHostId.equals(_cloudHostId)) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u54cd\u5e94\u53c2\u6570\u9519\u8bef");
        }
        return new KeyValueEntry((Object)"SUCCESS", (Object)responseMap);
    }

    public static String getObtainConnectDomain() {
        return ServiceUtil.getCloudConnectDomain();
    }

    private static String getSign(Map<String, String> pMap, String signKey) {
        TreeMap<String, String> t;
        if (pMap instanceof TreeMap) {
            t = (TreeMap<String, String>)pMap;
        } else {
            t = new TreeMap<String, String>();
            t.putAll(pMap);
        }
        char a = '=';
        char b = '&';
        String sigK = "sign";
        StringBuilder sbr1 = new StringBuilder(128);
        for (Map.Entry v : t.entrySet()) {
            if (v.getKey() == null || ((String)v.getKey()).length() <= 0 || ((String)v.getKey()).equals(sigK) || v.getValue() == null) continue;
            if (sbr1.length() > 0) {
                sbr1.append(b);
            }
            sbr1.append((String)v.getKey()).append(a).append((String)v.getValue());
        }
        return CryptoUtil.MD5Encode((String)(String.valueOf(sbr1.toString()) + "," + signKey));
    }

    public CarparkUdpConnSession getSuccessUdpConnSession() {
        return this.successUdpConnSession;
    }

    public long getSuccessUdpMills() {
        return this.successUdpMills;
    }
}

