/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.install;

import com.wovoe.carpark.gui.install.FileOptionHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JLabel;

public class FileOptionUtil {
    public static boolean deleteFile(File delFile, FileOptionHandler handler) {
        return FileOptionUtil.deleteFile(delFile, false, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean deleteFile(File delFile, boolean isdeleteOnExit, FileOptionHandler handler) {
        boolean isok = false;
        if (!delFile.exists()) return true;
        if (delFile.isFile()) {
            isok = delFile.delete();
            if (handler != null) {
                handler.onSuccess(FileOptionHandler.FileOption.DELETE, delFile.getAbsolutePath());
            }
        } else {
            isok = false;
            throw new RuntimeException("can not delete file :" + delFile.getPath() + "! may be a directory!");
        }
        if (isok) return isok;
        if (!isdeleteOnExit) return isok;
        delFile.deleteOnExit();
        return isok;
    }

    public static void deleteFolder(Queue<File> unDelQueue, File dir, boolean isdeleteOnExit, FileOptionHandler handler) {
        File[] filelist = dir.listFiles();
        if (filelist == null) {
            return;
        }
        int listlen = filelist.length;
        int i = 0;
        while (i < listlen) {
            if (filelist[i].isDirectory()) {
                FileOptionUtil.deleteFolder(unDelQueue, filelist[i], isdeleteOnExit, handler);
            } else if (!FileOptionUtil.deleteFile(filelist[i], isdeleteOnExit, handler)) {
                unDelQueue.offer(filelist[i]);
            }
            ++i;
        }
        boolean isok = dir.delete();
        if (!isok) {
            unDelQueue.offer(dir);
            if (isdeleteOnExit) {
                dir.deleteOnExit();
            }
        }
    }

    public static Queue<File> deleteFolderOrFile(File dir, boolean isdeleteOnExit, FileOptionHandler handler) {
        LinkedList<File> unDelQueue = new LinkedList<File>();
        if (dir.exists()) {
            if (dir.isDirectory()) {
                FileOptionUtil.deleteFolder(unDelQueue, dir, isdeleteOnExit, handler);
            } else if (!FileOptionUtil.deleteFile(dir, isdeleteOnExit, handler)) {
                unDelQueue.offer(dir);
            }
        }
        return unDelQueue;
    }

    public static Queue<File> deleteFolder(String delDirName, FileOptionHandler handler) {
        return FileOptionUtil.deleteFolderOrFile(new File(delDirName), false, handler);
    }

    public static Queue<File> deleteFolder(File delDir, FileOptionHandler handler) {
        return FileOptionUtil.deleteFolderOrFile(delDir, false, handler);
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void copyDirectory(String srcDirName, String dstDirName, JLabel texComponent) throws IOException {
        FileOptionUtil.copyDirectory(new File(srcDirName), new File(dstDirName));
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                FileOptionUtil.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else {
            FileOptionUtil.copyFile(srcDir, dstDir);
        }
    }

    public static void copyNotExistFiles(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                FileOptionUtil.copyNotExistFiles(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else if (!dstDir.exists()) {
            FileOptionUtil.copyFile(srcDir, dstDir);
        }
    }

    public static void copyNotExistFiles(String srcDirName, String dstDirName) throws IOException {
        FileOptionUtil.copyNotExistFiles(new File(srcDirName), new File(dstDirName));
    }

    public static void buildZip(File dir, String savePath) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        FileOptionUtil.buildZip(files, savePath);
    }

    public static void buildZip(File[] files, String savePath) {
        try {
            File zipFile = new File(savePath);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream out = new ZipOutputStream(cos);
            String basedir = "";
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileOptionUtil.compress(file, out, basedir);
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            FileOptionUtil.compress(files[i], out, String.valueOf(basedir) + dir.getName() + "/");
            ++i;
        }
    }

    private static void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            int BUFFER = 8192;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(String.valueOf(basedir) + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[BUFFER];
            while ((count = bis.read(data, 0, BUFFER)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void compress(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            FileOptionUtil.compressDirectory(file, out, basedir);
        } else {
            FileOptionUtil.compressFile(file, out, basedir);
        }
    }

    public static int unPack(String unPackFileName, String destDirName, FileOptionHandler handler) throws IOException {
        File zipFile = new File(unPackFileName);
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(zipFile);
            ZipInputStream zin = new ZipInputStream(fileInputStream);
            int n = FileOptionUtil.unzip(zin, new File(destDirName), handler);
            return n;
        }
    }

    public static int unzip(ZipInputStream zin, File destDir, FileOptionHandler handler) throws Exception {
        ZipEntry ze;
        int numEntries = 0;
        while ((ze = zin.getNextEntry()) != null) {
            int len;
            ++numEntries;
            if (ze.isDirectory()) {
                zin.closeEntry();
                continue;
            }
            String fname = String.valueOf(destDir.getAbsolutePath()) + File.separator + ze.getName().replace('/', File.separatorChar);
            File f = new File(fname);
            String unpackingName = ze.getName();
            if (f.getParent() != null) {
                File parent = f.getParentFile();
                parent.mkdirs();
            }
            byte[] buf = new byte[2048];
            FileOutputStream fos = new FileOutputStream(f);
            while ((len = zin.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.close();
            zin.closeEntry();
            if (handler == null) continue;
            handler.onSuccess(FileOptionHandler.FileOption.UNPACK, unpackingName);
        }
        zin.close();
        return numEntries;
    }
}

