/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.sun.awt.AWTUtilities;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.cloud.trtc.TRTCCallCallback;
import com.wovoe.carpark.cloud.trtc.TRTCCallManager;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ImagePanel;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AcceptCallDialog
extends JDialog
implements ActionListener,
TRTCCallCallback {
    private static final long serialVersionUID = 7492090479969016124L;
    private boolean autoAnswer;
    private TRTCCallManager trtcCallManager;
    private Dimension screenSize;
    private boolean handleOpened;
    private JPanel rootPannel;
    private JPanel acceptPanel;
    private JPanel videoPanel;
    private JPanel voicePanel;
    private JLabel callingLabel;
    private int waitAccptCounter;
    private ScheduledFuture<?> waitScheduleJob;
    private boolean isAnswer = false;
    private JButton answerButton;
    private JLabel voiceTimeLabel;
    private JLabel videoTimeLabel;
    private volatile int callTime;
    private ScheduledFuture<?> callScheduleJob;
    private Canvas localVideoCanvas;
    private Canvas remoteVideoCanvas;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private JDialog remoteVideoDialog;
    private XYConstraints videoConstants;
    private XYConstraints voiceConstants;
    private int pannelSubVideoWidth;
    private Component parentComponent;
    private Runnable hangupCallback;

    public static AcceptCallDialog createDialog(Component parentComponent, XYConstraints videoConstants, XYConstraints voiceConstants, Dimension screenSize, boolean modal, boolean autoAnswer, TRTCCallManager trtcCallManager, Runnable hangupCallback) {
        Window window = SwingUtil.getWindowForComponent(parentComponent);
        AcceptCallDialog dialog = window instanceof Frame ? new AcceptCallDialog((Frame)window, "", modal) : new AcceptCallDialog((Dialog)window, "", modal);
        dialog.videoConstants = videoConstants;
        dialog.voiceConstants = voiceConstants;
        dialog.screenSize = screenSize;
        dialog.autoAnswer = autoAnswer;
        dialog.trtcCallManager = trtcCallManager;
        dialog.parentComponent = parentComponent;
        dialog.hangupCallback = hangupCallback;
        dialog.init();
        return dialog;
    }

    private AcceptCallDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    private AcceptCallDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    private JPanel createAcceptCallPanel() {
        int width = this.voiceConstants.getWidth();
        int height = this.voiceConstants.getHeight();
        BufferedImage bgimg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("acceptCallBg");
        ImageIcon bgicon = new ImageIcon(SwingUtil.resizeImage(bgimg, width, height));
        ImagePanel bgPanel = new ImagePanel(bgicon);
        bgPanel.setLayout(new XYLayout());
        int marginBottom = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int buttonHeight = (int)Math.round(this.screenSize.getHeight() * 40.0 / 768.0);
        this.answerButton = new JButton();
        BufferedImage buttonImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_dialing");
        ImageIcon buttonImgIcon = new ImageIcon(SwingUtil.resizeImage(buttonImg, buttonHeight, buttonHeight));
        BufferedImage pressedImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_dialing_pressed");
        ImageIcon pressedIcon = new ImageIcon(SwingUtil.resizeImage(pressedImg, buttonHeight, buttonHeight));
        this.setImageButton(buttonImgIcon, pressedIcon, this.answerButton);
        this.answerButton.setActionCommand("ANSWER_CALL");
        this.answerButton.setCursor(new Cursor(12));
        this.answerButton.setToolTipText("\u70b9\u51fb\u63a5\u542c");
        this.answerButton.addActionListener(this);
        int x = (width - buttonHeight) / 2;
        int y = height - buttonHeight - marginBottom;
        int w = buttonHeight;
        int h = buttonHeight;
        bgPanel.add((Component)this.answerButton, new XYConstraints(x, y, w, h));
        int marginButtonBottom = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        int fontSize = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        String v = this.trtcCallManager.getCallType() == 2 ? "\u6b63\u5728\u8bf7\u6c42\u89c6\u9891\u901a\u8bdd" : "\u6b63\u5728\u8bf7\u6c42\u8bed\u97f3\u901a\u8bdd";
        this.callingLabel = new JLabel(v);
        this.callingLabel.setHorizontalAlignment(0);
        this.callingLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        this.callingLabel.setForeground(Color.decode("#888888"));
        h = (int)Math.round(this.screenSize.getHeight() * 20.0 / 768.0);
        w = width - 10;
        x = 5;
        y = y - marginButtonBottom - h;
        bgPanel.add((Component)this.callingLabel, new XYConstraints(x, y, w, h));
        fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        JLabel channelLabel = new JLabel(this.getChannelName());
        int marginBottom1 = 0;
        fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        channelLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        channelLabel.setForeground(Color.BLACK);
        channelLabel.setHorizontalAlignment(0);
        y = y - marginBottom1 - h;
        bgPanel.add((Component)channelLabel, new XYConstraints(x, y, w, h));
        return bgPanel;
    }

    private void setImageButton(ImageIcon imageIcon, ImageIcon pressedIcon, JButton button) {
        if (imageIcon != null) {
            button.setIcon(imageIcon);
        }
        if (pressedIcon != null) {
            button.setPressedIcon(pressedIcon);
            button.setRolloverIcon(pressedIcon);
        }
        button.setContentAreaFilled(false);
    }

    private JPanel createVideoPanel() {
        int buttonHeight;
        int width = this.videoConstants.getWidth();
        int pannelToatlHeight = this.videoConstants.getHeight();
        int pannelVideoHeight = width * 1280 / 720;
        JPanel panel = new JPanel();
        panel.setBackground(Color.decode("#666666"));
        panel.setLayout(new XYLayout());
        int fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        VideoCanvasX remoteV = new VideoCanvasX();
        remoteV.setBackground(Color.BLACK);
        remoteV.setForeground(Color.WHITE);
        remoteV.setFont(font);
        remoteV.loadingMessage = "\u8fdc\u7a0b\u89c6\u9891\u52a0\u8f7d\u4e2d";
        this.remoteVideoCanvas = remoteV;
        int x = 0;
        int y = 0;
        int w = width;
        int h = pannelVideoHeight;
        panel.add((Component)this.remoteVideoCanvas, new XYConstraints(x, y, w, h));
        y += h;
        int remainHeight = pannelToatlHeight - pannelVideoHeight;
        int buttonWidth = buttonHeight = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int margin = (int)Math.round(this.screenSize.getHeight() * 10.0 / 1280.0);
        int msgWidth = (width - buttonWidth - 4 * margin) / 2;
        int msgHeight = (int)Math.round(this.screenSize.getHeight() * 20.0 / 768.0);
        int y0 = y;
        x = margin;
        w = msgWidth;
        h = msgHeight;
        y = y0 + (remainHeight - h) / 2;
        int fontSize0 = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        Font font0 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize0);
        JLabel channelLabel = new JLabel(this.getChannelName());
        channelLabel.setHorizontalAlignment(0);
        channelLabel.setFont(font0);
        channelLabel.setForeground(Color.WHITE);
        panel.add((Component)channelLabel, new XYConstraints(x, y, w, h));
        JButton button = new JButton();
        BufferedImage buttonImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_hangup");
        ImageIcon buttonImgIcon = new ImageIcon(SwingUtil.resizeImage(buttonImg, buttonWidth, buttonHeight));
        BufferedImage pressedImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_hangup_pressed");
        ImageIcon pressedIcon = new ImageIcon(SwingUtil.resizeImage(pressedImg, buttonWidth, buttonHeight));
        this.setImageButton(buttonImgIcon, pressedIcon, button);
        button.setActionCommand("HANGUP_VIDEO_CALL");
        button.setCursor(new Cursor(12));
        button.setToolTipText("\u70b9\u51fb\u6302\u65ad");
        button.addActionListener(this);
        x += w + margin;
        w = buttonWidth;
        h = buttonHeight;
        y = y0 + (remainHeight - h) / 2;
        panel.add((Component)button, new XYConstraints(x, y, w, h));
        this.videoTimeLabel = new JLabel();
        this.videoTimeLabel.setHorizontalAlignment(0);
        this.videoTimeLabel.setFont(font);
        this.videoTimeLabel.setForeground(Color.WHITE);
        x += w + margin;
        w = msgWidth;
        h = msgHeight;
        y = y0 + (remainHeight - h) / 2;
        panel.add((Component)this.videoTimeLabel, new XYConstraints(x, y, w, h));
        int pannelSubVideoHeight = pannelToatlHeight / 3;
        this.pannelSubVideoWidth = pannelSubVideoHeight * 720 / 1280;
        this.remoteVideoDialog = this.remoteVideoDialog(this.pannelSubVideoWidth, pannelSubVideoHeight);
        return panel;
    }

    private JDialog remoteVideoDialog(int pannelSubVideoWidth, int pannelSubVideoHeight) {
        int fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        VideoCanvasX localV = new VideoCanvasX();
        localV.setBackground(Color.BLACK);
        localV.setForeground(Color.WHITE);
        localV.setFont(font);
        localV.loadingMessage = "\u672c\u5730\u89c6\u9891";
        this.localVideoCanvas = localV;
        JDialog dialog = new JDialog(this, "", false);
        dialog.setSize(pannelSubVideoWidth, pannelSubVideoHeight);
        dialog.setUndecorated(true);
        dialog.getContentPane().add(this.localVideoCanvas);
        return dialog;
    }

    private JPanel createVoicePanel() {
        int width = this.voiceConstants.getWidth();
        int height = this.voiceConstants.getHeight();
        BufferedImage bgimg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("acceptCallBg");
        ImageIcon bgicon = new ImageIcon(SwingUtil.resizeImage(bgimg, width, height));
        ImagePanel bgPanel = new ImagePanel(bgicon);
        bgPanel.setLayout(new XYLayout());
        int marginBottom = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int buttonHeight = (int)Math.round(this.screenSize.getHeight() * 40.0 / 768.0);
        JButton button = new JButton();
        BufferedImage buttonImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_hangup");
        ImageIcon buttonImgIcon = new ImageIcon(SwingUtil.resizeImage(buttonImg, buttonHeight, buttonHeight));
        BufferedImage pressedImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("trtccalling_ic_hangup_pressed");
        ImageIcon pressedIcon = new ImageIcon(SwingUtil.resizeImage(pressedImg, buttonHeight, buttonHeight));
        this.setImageButton(buttonImgIcon, pressedIcon, button);
        button.setActionCommand("HANGUP_VOICE_CALL");
        button.setCursor(new Cursor(12));
        button.setToolTipText("\u70b9\u51fb\u6302\u65ad");
        button.addActionListener(this);
        JLabel topLabel = new JLabel("\u8bed\u97f3\u901a\u8bdd\u4e2d");
        int fontSize0 = (int)Math.round(this.screenSize.getHeight() * 14.0 / 768.0);
        int x = 5;
        int w = width - 10;
        int h = (int)Math.round(this.screenSize.getHeight() * 30.0 / 768.0);
        int y = (int)Math.round(this.screenSize.getHeight() * 15.0 / 768.0);
        topLabel.setHorizontalAlignment(0);
        topLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize0));
        topLabel.setForeground(Color.WHITE);
        bgPanel.add((Component)topLabel, new XYConstraints(x, y, w, h));
        x = (width - buttonHeight) / 2;
        y = height - buttonHeight - marginBottom;
        w = buttonHeight;
        h = buttonHeight;
        bgPanel.add((Component)button, new XYConstraints(x, y, w, h));
        int marginButtonBottom = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        int fontSize = (int)Math.round(this.screenSize.getHeight() * 11.0 / 768.0);
        String v = "";
        this.voiceTimeLabel = new JLabel(v);
        this.voiceTimeLabel.setHorizontalAlignment(0);
        this.voiceTimeLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        this.voiceTimeLabel.setForeground(Color.decode("#888888"));
        h = (int)Math.round(this.screenSize.getHeight() * 20.0 / 768.0);
        w = width - 10;
        x = 5;
        y = y - marginButtonBottom - h;
        bgPanel.add((Component)this.voiceTimeLabel, new XYConstraints(x, y, w, h));
        fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        JLabel channelLabel = new JLabel(this.getChannelName());
        int marginBottom1 = 0;
        fontSize = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        channelLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        channelLabel.setForeground(Color.BLACK);
        channelLabel.setHorizontalAlignment(0);
        y = y - marginBottom1 - h;
        bgPanel.add((Component)channelLabel, new XYConstraints(x, y, w, h));
        return bgPanel;
    }

    private String getChannelName() {
        String channelNo = this.trtcCallManager.getChannelNo();
        if (channelNo != null && channelNo.length() > 0) {
            PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (channel != null) {
                return channel.getChannel().getChannel_name();
            }
            CarparkChannel c = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(channelNo);
            if (c != null) {
                return c.getChannel_name();
            }
        }
        return "";
    }

    private void init() {
        if (this.rootPannel != null) {
            return;
        }
        this.setUndecorated(true);
        if (this.screenSize == null) {
            this.screenSize = SwingUtil.getScreenSize();
        }
        int roudSize = (int)Math.round(this.screenSize.getHeight() * 18.0 / 768.0);
        this.rootPannel = new JPanel();
        this.rootPannel.setLayout(new BorderLayout());
        if (!this.autoAnswer) {
            this.acceptPanel = this.createAcceptCallPanel();
            this.rootPannel.add((Component)this.acceptPanel, "Center");
            this.setSize(this.voiceConstants.getWidth(), this.voiceConstants.getHeight());
            this.setLocation(this.voiceConstants.getX(), this.voiceConstants.getY());
        } else if (this.trtcCallManager.getCallType() == 2) {
            this.videoPanel = this.createVideoPanel();
            this.rootPannel.add((Component)this.videoPanel, "Center");
            this.setSize(this.videoConstants.getWidth(), this.videoConstants.getHeight());
            this.setLocation(this.videoConstants.getX(), this.videoConstants.getY());
        } else {
            this.voicePanel = this.createVoicePanel();
            this.rootPannel.add((Component)this.voicePanel, "Center");
            this.setSize(this.voiceConstants.getWidth(), this.voiceConstants.getHeight());
            this.setLocation(this.voiceConstants.getX(), this.voiceConstants.getY());
        }
        this.getContentPane().add(this.rootPannel);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), roudSize, roudSize);
        AWTUtilities.setWindowShape((Window)this, (Shape)shape);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (!AcceptCallDialog.this.handleOpened) {
                    AcceptCallDialog.this.handleOpened = true;
                    AcceptCallDialog.this.handleOpened();
                }
            }
        });
    }

    private void handleOpened() {
        this.trtcCallManager.addTRTCCallCallback(this);
        if (this.isCurrentAcceptPanel()) {
            this.waitScheduleJob = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    SwingUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AcceptCallDialog acceptCallDialog = AcceptCallDialog.this;
                            acceptCallDialog.waitAccptCounter = acceptCallDialog.waitAccptCounter + 1;
                            if (AcceptCallDialog.this.callingLabel != null) {
                                int hx = AcceptCallDialog.this.waitAccptCounter % 4;
                                String v = hx == 3 ? "..." : (hx == 2 ? ".." : (hx == 1 ? "." : ""));
                                v = AcceptCallDialog.this.trtcCallManager.getCallType() == 2 ? "\u6b63\u5728\u8bf7\u6c42\u89c6\u9891\u901a\u8bdd " + v : "\u6b63\u5728\u8bf7\u6c42\u8bed\u97f3\u901a\u8bdd " + v;
                                AcceptCallDialog.this.callingLabel.setText(v);
                            }
                            if (AcceptCallDialog.this.waitAccptCounter >= 60) {
                                AcceptCallDialog.this.cancelWaitScheduleJob();
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(AcceptCallDialog.this.trtcCallManager, "\u901a\u8bdd\u5df2\u7ed3\u675f, \u8d85\u65f6\u672a\u63a5\u542c", 1));
                                AcceptCallDialog.this.hangUp();
                            }
                        }
                    });
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        } else {
            this.answer();
        }
    }

    private void cancelWaitScheduleJob() {
        ScheduledFuture<?> waitScheduleJob0 = this.waitScheduleJob;
        if (waitScheduleJob0 != null) {
            this.waitScheduleJob = null;
            waitScheduleJob0.cancel(true);
        }
    }

    private boolean isCurrentAcceptPanel() {
        if (this.acceptPanel == null) {
            return false;
        }
        int count = this.rootPannel.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.rootPannel.getComponent(i) == this.acceptPanel) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("ANSWER_CALL".equals(cmd)) {
            this.answer();
        } else if ("HANGUP_VOICE_CALL".equals(cmd) || "HANGUP_VIDEO_CALL".equals(cmd)) {
            try {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this.trtcCallManager, "\u901a\u8bdd\u5df2\u7ed3\u675f", 1));
            }
            finally {
                this.hangUp();
            }
        }
    }

    private void answer() {
        if (this.isAnswer) {
            return;
        }
        this.isAnswer = true;
        this.cancelWaitScheduleJob();
        if (this.isCurrentAcceptPanel()) {
            if (this.trtcCallManager.getCallType() == 2) {
                AcceptCallDialog dialog = AcceptCallDialog.createDialog(this.parentComponent, this.videoConstants, this.voiceConstants, this.screenSize, this.isModal(), true, this.trtcCallManager, this.hangupCallback);
                dialog.setVisible(true);
                this.closeDialog();
                return;
            }
            if (this.voicePanel == null) {
                this.voicePanel = this.createVoicePanel();
            }
            JPanel showPanel = this.voicePanel;
            if (this.answerButton != null) {
                this.answerButton.removeActionListener(this);
            }
            this.rootPannel.remove(this.acceptPanel);
            this.rootPannel.add((Component)showPanel, "Center");
            this.rootPannel.updateUI();
        }
        if (this.trtcCallManager.getCallType() == 2) {
            if (this.remoteVideoDialog == null) {
                this.doAnswer0();
            } else {
                this.remoteVideoDialog.addWindowListener(new WindowAdapter(){
                    private boolean handleX = false;

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (!this.handleX) {
                            this.handleX = true;
                            AcceptCallDialog.this.doAnswer1();
                        }
                    }
                });
                int magin = (int)Math.round(this.screenSize.getHeight() * 5.0 / 768.0);
                Point location = this.getLocation();
                int x = location.x + (this.getWidth() - this.pannelSubVideoWidth) - magin;
                int y = location.y + magin;
                this.remoteVideoDialog.setLocation(x, y);
                this.remoteVideoDialog.setResizable(false);
                this.remoteVideoDialog.setVisible(true);
            }
        } else {
            this.doAnswer0();
        }
    }

    private void doAnswer0() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AcceptCallDialog.this.doAnswer1();
            }
        });
    }

    private void doAnswer1() {
        if (this.trtcCallManager.getCallType() == 2) {
            if (this.videoTimeLabel != null) {
                this.videoTimeLabel.setText("\u8fde\u63a5\u4e2d...");
            }
        } else if (this.voiceTimeLabel != null) {
            this.voiceTimeLabel.setText("\u6b63\u5728\u5efa\u7acb\u901a\u8bdd, \u8fde\u63a5\u4e2d...");
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                AcceptCallDialog.this.doAnswner();
            }
        });
    }

    private void doAnswner() {
        KeyValueEntry<Integer, String> ex = this.trtcCallManager.queryAcceptRoomStatus();
        if ((Integer)ex.getKey() != 0) {
            try {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this.trtcCallManager, "\u901a\u8bdd\u5df2\u7ed3\u675f\uff0c" + (String)ex.getValue(), 4));
            }
            finally {
                this.hangUp();
            }
            return;
        }
        KeyValueEntry<Integer, String> entryv = this.trtcCallManager.enterRoom(this.localVideoCanvas, this.remoteVideoCanvas);
        if ((Integer)entryv.getKey() != 0) {
            try {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this.trtcCallManager, "\u901a\u8bdd\u5df2\u7ed3\u675f\uff0c" + (String)entryv.getValue(), 4));
            }
            finally {
                this.hangUp();
            }
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AcceptCallDialog.this.trtcCallManager.getCallType() == 2) {
                    if (AcceptCallDialog.this.videoTimeLabel != null) {
                        AcceptCallDialog.this.videoTimeLabel.setText("00:00");
                    }
                } else if (AcceptCallDialog.this.voiceTimeLabel != null) {
                    AcceptCallDialog.this.voiceTimeLabel.setText("00:00");
                }
            }
        });
        this.callScheduleJob = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SwingUtil.invokeLater(new Runnable(){
                    int timeoutSec = 1200;

                    @Override
                    public void run() {
                        AcceptCallDialog acceptCallDialog = AcceptCallDialog.this;
                        acceptCallDialog.callTime = acceptCallDialog.callTime + 1;
                        int mins = AcceptCallDialog.this.callTime / 60;
                        int secs = AcceptCallDialog.this.callTime % 60;
                        String timeStr = String.valueOf(mins < 10 ? "0" + mins : String.valueOf(mins)) + ":" + (secs < 10 ? "0" + secs : String.valueOf(secs));
                        if (AcceptCallDialog.this.trtcCallManager.getCallType() == 2) {
                            if (AcceptCallDialog.this.videoTimeLabel != null) {
                                AcceptCallDialog.this.videoTimeLabel.setText(timeStr);
                            }
                        } else if (AcceptCallDialog.this.voiceTimeLabel != null) {
                            AcceptCallDialog.this.voiceTimeLabel.setText(timeStr);
                        }
                        if (AcceptCallDialog.this.callTime >= this.timeoutSec) {
                            try {
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(AcceptCallDialog.this.trtcCallManager, "\u901a\u8bdd\u5df2\u7ed3\u675f, \u8d85\u65f6\u81ea\u52a8\u5173\u95ed", 1));
                            }
                            finally {
                                AcceptCallDialog.this.hangUp();
                            }
                        }
                    }
                });
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void hangUp() {
        this.hangUp0(false);
    }

    private void hangUp0(boolean isCallback) {
        if (this.disposed.compareAndSet(false, true)) {
            try {
                this.cancelWaitScheduleJob();
                if (this.callScheduleJob != null) {
                    this.callScheduleJob.cancel(true);
                    this.callScheduleJob = null;
                }
                this.trtcCallManager.removeTRTCCallCallback(this);
                if (!isCallback) {
                    try {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    try {
                                        AcceptCallDialog.this.trtcCallManager.hangUp();
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                                        AcceptCallDialog.this.closeDialog();
                                    }
                                }
                                finally {
                                    AcceptCallDialog.this.closeDialog();
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        this.closeDialog();
                    }
                } else {
                    this.closeDialog();
                }
            }
            finally {
                if (this.hangupCallback != null) {
                    this.hangupCallback.run();
                }
            }
        }
    }

    private void closeDialog() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AcceptCallDialog.this.remoteVideoDialog != null) {
                    AcceptCallDialog.this.remoteVideoDialog.dispose();
                }
                AcceptCallDialog.this.dispose();
            }
        });
    }

    @Override
    public void onHangup() {
        this.hangUp0(true);
    }

    private static class VideoCanvasX
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private String loadingMessage;

        private VideoCanvasX() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            String msg = this.loadingMessage;
            if (msg != null && msg.length() > 0) {
                Color color;
                Font font;
                Graphics2D g2 = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                if (width == 0 || height == 0) {
                    Dimension d = this.getPreferredSize();
                    if (d != null && d.width > 0 && d.height > 0) {
                        width = d.width;
                        height = d.height;
                    } else {
                        Container c = this.getParent();
                        if (c != null) {
                            width = c.getWidth();
                            height = c.getHeight();
                        }
                    }
                }
                if ((font = this.getFont()) == null) {
                    font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, 16);
                }
                if ((color = this.getForeground()) != null) {
                    g2.setColor(color);
                }
                Dimension dm = SwingUtil.getStringFontSize(msg, font);
                int x = (width - dm.width) / 2;
                int y = height / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y <= 0) {
                    y = 0;
                }
                g2.drawString(msg, x, y);
            }
        }
    }
}

