/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.BlackWhiteListCache;
import com.wovoe.carpark.BlackWhiteListTaskMonitor;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SampleScrollBarUI;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class BlackWhilteListTerminalDialog
extends MacDialog
implements BlackWhiteListTaskMonitor {
    private static final long serialVersionUID = -7661245766637239872L;
    private Dimension mainSize;
    private JTextArea console;
    private JScrollPane scrollPane;
    private int maxlength = 0xA00000;
    private volatile boolean disponsed;

    public static BlackWhilteListTerminalDialog createDialog(Component parentComponent, Dimension rootSize, Dimension dialogSize) {
        Window window;
        if (rootSize == null) {
            rootSize = SwingUtil.getScreenSize();
        }
        BlackWhilteListTerminalDialog instance = parentComponent == null ? new BlackWhilteListTerminalDialog() : ((window = SwingUtil.getWindowForComponent(parentComponent)) instanceof Frame ? new BlackWhilteListTerminalDialog((Frame)window, false) : (window instanceof Dialog ? new BlackWhilteListTerminalDialog((Dialog)window, false) : (window instanceof Window ? new BlackWhilteListTerminalDialog(window, false) : new BlackWhilteListTerminalDialog())));
        if (dialogSize == null) {
            int width = (int)Math.round(rootSize.getWidth() * 650.0 / 1024.0);
            int height = (int)Math.round(rootSize.getHeight() * 450.0 / 768.0);
            dialogSize = new Dimension(width, height);
        }
        instance.mainSize = rootSize;
        instance.init(dialogSize, parentComponent);
        instance.setTitleInfo("        \u540c\u6b65\u9ed1\u767d\u540d\u5355\u5230\u76f8\u673a\u7ec8\u7aef");
        instance.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                BlackWhiteListCache cahche = ServiceUtil.getServiceContext().getBlackWhiteListCache();
                if (cahche != null) {
                    cahche.addBlackWhiteListTaskMonitor((BlackWhilteListTerminalDialog)event.getWindow());
                    cahche.tryStartDownload();
                }
            }
        });
        return instance;
    }

    @Override
    protected void onDispose() {
        this.disponsed = true;
        BlackWhiteListCache cahche = ServiceUtil.getServiceContext().getBlackWhiteListCache();
        if (cahche != null) {
            cahche.removeBlackWhiteListTaskMonitor(this);
        }
    }

    public BlackWhilteListTerminalDialog() {
    }

    public BlackWhilteListTerminalDialog(Frame owner, boolean modal) {
        super(owner, null, modal);
    }

    public BlackWhilteListTerminalDialog(Window owner, boolean modal) {
        super(owner, null, modal);
    }

    public BlackWhilteListTerminalDialog(Dialog owner, boolean modal) {
        super(owner, null, modal);
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        this.showCloseButton(this.getTitileBarHeight());
        body.setLayout(new BorderLayout());
        this.console = new JTextArea();
        this.console.setBackground(Color.BLACK);
        this.console.setForeground(Color.WHITE);
        int font12Size = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        String fontName = SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME);
        Font font12 = new Font(fontName, 0, font12Size);
        this.console.setFont(font12);
        this.console.setLineWrap(true);
        this.console.setEditable(false);
        this.console.setCursor(new Cursor(0));
        this.scrollPane = new JScrollPane(this.console, 20, 31);
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        scrollBar.setUI(new SampleScrollBarUI(Color.decode("#FFFFFF"), Color.decode("#DBD9DB"), Color.decode("#FAFAFA"), this.mainSize));
        body.add((Component)this.scrollPane, "Center");
    }

    @Override
    public int getTitileBarHeight() {
        Dimension screenSize = SwingUtil.getScreenSize();
        int titileBarHeight = (int)Math.round(0.027777777777777776 * (double)screenSize.height);
        return titileBarHeight;
    }

    public void printMsg(String logMessage) {
        if (this.disponsed) {
            return;
        }
        String gv = "\u4fe1\u606f\uff1a";
        String v = logMessage != null ? logMessage.toString() : null;
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[yy/mm/dd HH:mm:ss]");
        final StringBuilder sbr = new StringBuilder(30 + gv.length() + (v == null ? 0 : v.length()));
        sbr.append(df.format(d));
        sbr.append(' ').append('>').append(' ');
        sbr.append(gv);
        if (v != null) {
            sbr.append(v);
        }
        sbr.append('\n');
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (BlackWhilteListTerminalDialog.this.disponsed) {
                        return;
                    }
                    try {
                        Document doc = BlackWhilteListTerminalDialog.this.console.getDocument();
                        int length = doc.getLength();
                        int g = BlackWhilteListTerminalDialog.this.maxlength;
                        if (length > g) {
                            doc.remove(0, g / 2);
                        }
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().error((Object)ex.getMessage());
                    }
                }
                finally {
                    BlackWhilteListTerminalDialog.this.console.append(sbr.toString());
                }
            }
        });
    }

    private String getCameraName(String cameraNo) {
        String ip;
        if (cameraNo == null || cameraNo.length() == 0) {
            return "";
        }
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(cameraNo);
        if (eq != null && (ip = eq.getIp()) != null && ip.length() > 0) {
            return "(" + ip + ")";
        }
        return "";
    }

    @Override
    public void onCheck(String cameraNo, boolean reCheck) {
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + (reCheck ? " \u6b63\u5728\u91cd\u65b0\u6821\u9a8c\u9ed1\u767d\u540d\u5355\u662f\u5426\u5df2\u540c\u6b65" : " \u5f00\u59cb\u6821\u9a8c\u9ed1\u767d\u540d\u5355\u662f\u5426\u9700\u8981\u540c\u6b65"));
    }

    @Override
    public void onQueryAll(String cameraNo) {
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u6b63\u5728\u52a0\u8f7d\u76f8\u673a\u6240\u6709\u9ed1\u767d\u540d\u5355");
    }

    @Override
    public void onQueryAllFinish(String cameraNo, int cameraWhiteCount, int cameraBlackCount, int chanalWhiteCount, int channelWhiteCout) {
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u5f53\u524d\u76f8\u673a\u767d\u540d\u5355\u603b\u6570: " + cameraWhiteCount + ", \u9ed1\u540d\u5355\u603b\u6570: " + cameraBlackCount + ", \u8be5\u901a\u9053\u7cfb\u7edf\u767d\u540d\u5355\u603b\u6570: " + chanalWhiteCount + " \u9ed1\u540d\u5355\u603b\u6570: " + channelWhiteCout);
    }

    @Override
    public void onCheckReusult(String cameraNo, int iWCount, int uWCount, int dWcount, int sWcount, int iBCount, int uBCount, int dBcount, int sBCount, boolean reCheck) {
        if (iWCount == 0 && uWCount == 0 && dWcount == 0 && iBCount == 0 && uBCount == 0 && dBcount == 0 && dBcount == 0) {
            if (sWcount == 0 && sBCount == 0) {
                this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u76f8\u673a\u4e2d\u6ca1\u6709\u4efb\u4f55\u9ed1\u767d\u540d\u5355\uff0c\u5c5e\u4e8e\u6e05\u7a7a\u72b6\u6001\u3002\n");
            } else {
                this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u9ed1\u767d\u540d\u5355\u5df2\u5b8c\u5168\u540c\u6b65, \u5df2\u540c\u6b65\u767d\u540d\u5355\u603b\u6570: " + sWcount + ", \u9ed1\u540d\u5355\u6570: " + sBCount + "\n");
            }
        } else {
            StringBuilder sbr = new StringBuilder(128);
            if (iWCount > 0) {
                sbr.append(" \u9700\u8981\u65b0\u589e\u767d\u540d\u5355\u6570\uff1a" + iWCount);
            }
            if (uWCount > 0) {
                sbr.append(" \u9700\u8981\u4fee\u6539\u767d\u540d\u5355\u6570\uff1a" + uWCount);
            }
            if (dWcount > 0) {
                sbr.append(" \u9700\u8981\u5220\u9664\u767d\u540d\u5355\u6570\uff1a" + dWcount);
            }
            if (iBCount > 0) {
                sbr.append(" \u9700\u8981\u65b0\u589e\u9ed1\u540d\u5355\u6570\uff1a" + iBCount);
            }
            if (uBCount > 0) {
                sbr.append(" \u9700\u8981\u4fee\u6539\u9ed1\u540d\u5355\u6570\uff1a" + uBCount);
            }
            if (dBcount > 0) {
                sbr.append(" \u9700\u8981\u5220\u9664\u9ed1\u540d\u5355\u6570\uff1a" + dBcount);
            }
            this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u53d1\u73b0\u9700\u8981\u540c\u6b65\u9ed1\u767d\u540d\u5355\u6570\u636e\uff1a" + sbr);
        }
    }

    @Override
    public void onStartDownlod(String cameraNo) {
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u6b63\u5728\u540c\u6b65\u9ed1\u767d\u540d\u5355...");
    }

    @Override
    public void onFinishDownlod(String cameraNo, Collection<PlateEntry> whiteTotal, Collection<PlateEntry> blackTotal, Collection<PlateEntry> whiteSuccess, Collection<PlateEntry> whiteFaild, Collection<PlateEntry> blackSuccess, Collection<PlateEntry> blackFaild) {
        StringBuilder sbr = new StringBuilder(128);
        if (whiteSuccess.size() + whiteFaild.size() > 0) {
            sbr.append(" \u672c\u6b21\u767d\u540d\u5355\u6210\u529f\u6570: ").append(whiteSuccess.size());
            sbr.append(", \u5931\u8d25\u6570: ").append(whiteFaild.size());
        }
        if (blackSuccess.size() + blackFaild.size() > 0) {
            sbr.append(" \u672c\u6b21\u9ed1\u540d\u5355\u6210\u529f\u6570: ").append(blackSuccess.size());
            sbr.append(", \u5931\u8d25\u6570: ").append(blackFaild.size());
        }
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u540c\u6b65\u5b8c\u6210," + sbr);
        if (!whiteFaild.isEmpty()) {
            this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u5b58\u5728\u540c\u6b65\u5931\u8d25\u7684\u767d\u540d\u5355: " + ServiceUtil.getFirstElement(whiteFaild) + (whiteFaild.size() > 1 ? " ..." : "") + "\n");
        }
        if (!blackFaild.isEmpty()) {
            this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u5b58\u5728\u540c\u6b65\u5931\u8d25\u7684\u9ed1\u540d\u5355: " + ServiceUtil.getFirstElement(blackFaild) + (blackFaild.size() > 1 ? " ..." : "") + "\n");
        }
    }

    @Override
    public void onDownlodException(String cameraNo, Exception ex) {
        String kh = ex != null ? "\uff0c\u539f\u56e0:" + ex.getMessage() : "";
        this.printMsg(String.valueOf(this.getCameraName(cameraNo)) + " \u540c\u6b65\u9ed1\u767d\u540d\u5355\u5931\u8d25 " + kh + "\n");
    }

    @Override
    public void onStartTask() {
    }

    @Override
    public void onEndTask() {
        this.printMsg("\u7a0d\u540e\u91cd\u65b0\u68c0\u6d4b....\n\n");
    }

    @Override
    public void onMessage(String msg) {
        this.printMsg(msg);
    }
}

