/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.ForceUpgradeEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.GuiListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.ImagePanel;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.OperationFutureHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class CarparkLoginFrame
extends JFrame
implements GuiListener,
CarparkEventListener {
    private static final long serialVersionUID = 1L;
    private ImagePanel rootPanel;
    private JLabel errMsgLabel;
    private JComboBox<ComboBoxEntry<CarparkUser>> userNameselect;
    private JPasswordField pwdFild;
    private JButton loginButton;
    private boolean realExitSystem = true;
    private JButton exitButton;
    private boolean disposed = false;
    private MacOptionDialog upgradeAlertDialog;

    public CarparkLoginFrame(Dimension size, List<CarparkUser> userList, String selectUserCode, boolean realExitSystem) {
        this.realExitSystem = realExitSystem;
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
        this.setIconImage(logo);
        this.setResizable(false);
        this.setTitle("\u505c\u8f66\u573a\u767b\u5f55\u7a97\u4f53");
        this.init(size, userList, selectUserCode);
        this.setSize(size);
        ServiceUtil.getServiceContext().getGuiActivator().addGuiListener(this);
    }

    public static void showWindow(final Dimension size, final WindowListener windowListener, final List<CarparkUser> userList, final String selectUserCode, final boolean realExitSystem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Dimension size1 = size;
                    if (size1 == null) {
                        size1 = SwingUtil.getScreenSize();
                        if (OSUtil.isMAC()) {
                            size1.setSize(size1.getWidth(), size1.getHeight() - 70.0);
                        }
                    }
                    CarparkLoginFrame f = new CarparkLoginFrame(size1, userList, selectUserCode, realExitSystem);
                    if (windowListener != null) {
                        f.addWindowListener(windowListener);
                    }
                    if (OSUtil.isMAC()) {
                        f.setLocation(0, 22);
                    }
                    f.toFront();
                    f.setVisible(true);
                    f.pwdFild.requestFocus();
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().registerParkingEventListener(f);
                }
                catch (Throwable ex) {
                    GuiLog.getLog().warn((Object)ex.getMessage(), ex);
                    MacOptionDialog.showAlertDialog(null, "\u7cfb\u7edf\u5f02\u5e38", "\u7cfb\u7edf\u542f\u52a8\u767b\u5f55\u7a97\u4f53\u5f02\u5e38\uff01\u539f\u56e0:" + ex.getMessage(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceUtil.getServiceContext().exitSystem(null);
                        }
                    }, null);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        try {
            ServiceUtil.getServiceContext().getGuiActivator().removeGuiListener(this);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().unRegisterParkingEventListener(this);
            if (this.upgradeAlertDialog != null && this.upgradeAlertDialog.isVisible()) {
                this.upgradeAlertDialog.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    private void init(Dimension size, List<CarparkUser> userList, String selectUserCode) {
        if (this.rootPanel == null) {
            BufferedImage bgimg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("login_bg");
            ImageIcon bgicon = new ImageIcon(SwingUtil.resizeImage(bgimg, size.width, size.height));
            this.rootPanel = new ImagePanel(bgicon);
            this.rootPanel.setLayout(new XYLayout());
            this.getContentPane().add(this.rootPanel);
            BufferedImage _loginBgimg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("login_panelbg");
            int loginPanelWidth = (int)Math.round(0.3359375 * size.getWidth());
            int loginPanelHeight = (int)Math.round(0.4296875 * size.getHeight());
            ImageIcon loginBgimg = new ImageIcon(SwingUtil.resizeImage(_loginBgimg, loginPanelWidth, loginPanelHeight));
            int _loginRight = (int)Math.round(0.1078125 * size.getWidth());
            int loginPanelX = size.width - _loginRight - loginPanelWidth;
            int loginPanelY = (int)Math.round(0.3203125 * size.getHeight());
            ImagePanel loginPanel = new ImagePanel(loginBgimg);
            loginPanel.setLayout(new XYLayout());
            loginPanel.setOpaque(false);
            loginPanel.setBackground(null);
            this.rootPanel.add((Component)loginPanel, new XYConstraints(loginPanelX, loginPanelY, loginPanelWidth, loginPanelHeight));
            this.initLoginPannel(loginPanel, loginPanelWidth, loginPanelHeight, userList, selectUserCode);
            JLabel logoTextLabel = new JLabel();
            int logoTextHeight1 = (int)Math.round(0.05859375 * size.getHeight());
            int logoTextFontSize = (int)Math.round(0.049479166666666664 * size.getHeight());
            int logoTopY = loginPanelY - logoTextHeight1 - logoTextFontSize;
            this.rootPanel.add((Component)logoTextLabel, new XYConstraints(loginPanelX - 100, logoTopY, loginPanelWidth + 200, logoTextFontSize + 15));
            logoTextLabel.setText(CarparkGuiSkinUtil.getCarparkGuiSkin().getSystemName());
            int x = (int)Math.round(0.12195121951219512 * (double)logoTextFontSize);
            logoTextLabel.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 1, logoTextFontSize - x));
            logoTextLabel.setForeground(new Color(196, 197, 202));
            logoTextLabel.setHorizontalAlignment(0);
            logoTextLabel.setVerticalTextPosition(3);
            BufferedImage _logoimg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("logo");
            int imgelogoWidth = _logoimg.getWidth();
            int imagelogHeight = _logoimg.getHeight();
            int reiszeWith = logoTextFontSize;
            int reiszehegiht = logoTextFontSize;
            if (imgelogoWidth != imagelogHeight) {
                reiszeWith = (int)((double)reiszehegiht / (double)imagelogHeight * (double)imgelogoWidth);
            }
            ImageIcon logoimg = new ImageIcon(SwingUtil.resizeImage(_logoimg, reiszeWith, reiszehegiht));
            logoTextLabel.setIcon(logoimg);
            JLabel footLabel = new JLabel();
            int footBottm = (int)Math.round(0.0390625 * size.getHeight());
            int footFontHeight = (int)Math.round(0.015625 * size.getHeight());
            int footHeight = (int)Math.round(0.018229166666666668 * size.getHeight());
            footLabel.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 1, footFontHeight));
            footLabel.setHorizontalAlignment(0);
            this.rootPanel.add((Component)footLabel, new XYConstraints(50, size.height - footBottm - footHeight, size.width - 100, footHeight));
            footLabel.setForeground(Color.WHITE);
            Calendar cl = Calendar.getInstance();
            String vx = ServiceUtil.getServiceContext() != null ? ServiceUtil.getServiceContext().getVersion() : "1.0.0";
            footLabel.setText("Copyright \u00a9 2018-" + cl.get(1) + " " + CarparkGuiSkinUtil.getCarparkGuiSkin().getCopyrightCompany() + "\u7248\u6743\u6240\u6709.  v" + vx);
            this.errMsgLabel = new JLabel();
            int errorMsgHeight = (int)Math.round(0.020833333333333332 * size.getHeight());
            this.errMsgLabel.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, errorMsgHeight));
            this.errMsgLabel.setHorizontalAlignment(0);
            this.errMsgLabel.setForeground(Color.RED);
            if (!ServiceUtil.isZvalid()) {
                this.errMsgLabel.setText("\u8f6f\u4ef6\u4f7f\u7528\u5df2\u5230\u671f,\u8bf7\u8054\u7cfb\u4e1a\u52a1\u6216\u552e\u540e\u4eba\u5458\u5904\u7406");
                if (this.loginButton != null) {
                    this.loginButton.setEnabled(false);
                }
            }
            this.rootPanel.add((Component)this.errMsgLabel, new XYConstraints(loginPanelX, loginPanelY - errorMsgHeight - 8, loginPanelWidth, errorMsgHeight));
        }
    }

    private void initLoginPannel(JPanel loginPanel, int loginPanelWidth, int loginPanelHeight, List<CarparkUser> userList, String selectUserCode) {
        BufferedImage _loginExitImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("login_exit");
        int exitWidth = (int)Math.round(0.06046511627906977 * (double)loginPanelWidth);
        int exitHeight = (int)Math.round(0.08484848484848485 * (double)loginPanelHeight);
        ImageIcon exitIcon = new ImageIcon(SwingUtil.resizeImage(_loginExitImg, exitWidth, exitHeight));
        int exitY = (int)Math.round(0.04242424242424243 * (double)loginPanelHeight);
        int exitX = loginPanelWidth - exitWidth - (int)Math.round(0.046511627906976744 * (double)loginPanelWidth);
        this.exitButton = SwingUtil.createImageButton(exitIcon, null);
        this.exitButton.setToolTipText(this.realExitSystem ? "\u70b9\u51fb\u9000\u51fa\u7cfb\u7edf" : "\u70b9\u51fb\u5173\u95ed\u7a97\u4f53");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacOptionDialog.showConfirmDialog(CarparkLoginFrame.this.rootPanel, CarparkLoginFrame.this.realExitSystem ? "\u9000\u51fa\u7cfb\u7edf\u786e\u8ba4" : "\u5173\u95ed\u7a97\u53e3\u786e\u8ba4", CarparkLoginFrame.this.realExitSystem ? "\u60a8\u786e\u5b9a\u8981\u9000\u51fa\u7cfb\u7edf\u5417\uff1f" : "\u60a8\u786e\u5b9a\u5173\u95ed\u7a97\u53e3\u5417\uff1f", null, null, new Runnable(){

                    @Override
                    public void run() {
                        if (CarparkLoginFrame.this.realExitSystem) {
                            CarparkLoginFrame.this.rootPanel.setCursor(new Cursor(3));
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    ServiceUtil.getServiceContext().exitSystem(null);
                                }
                            });
                            t.setDaemon(true);
                            t.start();
                        } else {
                            CarparkLoginFrame.this.dispose();
                        }
                    }
                }, null);
            }
        });
        loginPanel.add((Component)this.exitButton, new XYConstraints(exitX, exitY, exitWidth, exitHeight));
        JLabel titleLabel = new JLabel();
        titleLabel.setForeground(new Color(255, 255, 255));
        titleLabel.setHorizontalAlignment(0);
        int titleLabelWidth = (int)Math.round(0.627906976744186 * (double)loginPanelWidth);
        int titleLabelHeight = (int)Math.round(0.09090909090909091 * (double)loginPanelHeight);
        int leftx = (loginPanelWidth - titleLabelWidth) / 2;
        int top = (int)Math.round(0.09090909090909091 * (double)loginPanelHeight);
        loginPanel.add((Component)titleLabel, new XYConstraints(leftx, top, titleLabelWidth, titleLabelHeight));
        titleLabel.setText("\u7cfb\u7edf\u767b\u5f55");
        titleLabel.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 1, titleLabelHeight));
        JButton picUserLabel = new JButton();
        picUserLabel.setToolTipText("\u767b\u5f55\u7528\u6237");
        int picUserWidthHeight = (int)Math.round(0.13333333333333333 * (double)loginPanelHeight);
        BufferedImage _loginUserImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("login_user");
        int loginUserWidth = (int)Math.round(0.4090909090909091 * (double)picUserWidthHeight);
        int loginUserHeight = (int)Math.round(0.45454545454545453 * (double)picUserWidthHeight);
        ImageIcon userIcon = new ImageIcon(SwingUtil.resizeImage(_loginUserImg, loginUserWidth, loginUserHeight));
        picUserLabel.setIcon(userIcon);
        int topx = (int)Math.round(0.2909090909090909 * (double)loginPanelHeight);
        loginPanel.add((Component)picUserLabel, new XYConstraints(leftx, topx, picUserWidthHeight, picUserWidthHeight));
        picUserLabel.setBackground(new Color(244, 244, 244));
        picUserLabel.setRequestFocusEnabled(false);
        if (userList != null && !userList.isEmpty()) {
            LinkedList<CarparkUser> slist1 = new LinkedList<CarparkUser>();
            LinkedList<CarparkUser> slist2 = new LinkedList<CarparkUser>();
            for (CarparkUser e : userList) {
                if (e.getRole_no() != null && e.getRole_no().equals("1")) {
                    slist2.add(e);
                    continue;
                }
                slist1.add(e);
            }
            slist1.addAll(slist2);
            userList = slist1;
        }
        Vector<ComboBoxEntry<CarparkUser>> sels = new Vector<ComboBoxEntry<CarparkUser>>();
        int selectIndex = 0;
        if (userList != null && !userList.isEmpty()) {
            int i = 0;
            for (CarparkUser e : userList) {
                sels.add(new ComboBoxEntry<CarparkUser>(e, e.getUser_name()));
                if (selectUserCode != null && selectUserCode.length() > 0 && selectUserCode.equals(e.getUser_code())) {
                    selectIndex = i;
                }
                ++i;
            }
        }
        this.userNameselect = new JComboBox(sels);
        if (!sels.isEmpty()) {
            this.userNameselect.setSelectedIndex(selectIndex);
        }
        int userNameselectfonsize = (int)Math.round(0.36363636363636365 * (double)picUserWidthHeight);
        this.userNameselect.setForeground(Color.decode("#222222"));
        this.userNameselect.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, userNameselectfonsize));
        loginPanel.add(this.userNameselect, new XYConstraints(leftx + picUserWidthHeight, topx, titleLabelWidth - picUserWidthHeight, picUserWidthHeight));
        this.userNameselect.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CarparkLoginFrame.this.loginButton.doClick();
                }
            }
        });
        BufferedImage _loginLockImg = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("login_lock");
        ImageIcon lockIcon = new ImageIcon(SwingUtil.resizeImage(_loginLockImg, loginUserWidth, loginUserHeight));
        int topx1 = (int)Math.round(0.09090909090909091 * (double)loginPanelHeight);
        int lockTop = topx + picUserWidthHeight + topx1;
        JButton lockButon = new JButton();
        lockButon.setIcon(lockIcon);
        lockButon.setBackground(picUserLabel.getBackground());
        lockButon.setRequestFocusEnabled(false);
        loginPanel.add((Component)lockButon, new XYConstraints(leftx, lockTop, picUserWidthHeight, picUserWidthHeight));
        lockButon.setToolTipText("\u767b\u5f55\u5bc6\u7801");
        this.pwdFild = new JPasswordField();
        loginPanel.add((Component)this.pwdFild, new XYConstraints(leftx + picUserWidthHeight, lockTop, titleLabelWidth - picUserWidthHeight, picUserWidthHeight));
        this.pwdFild.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, userNameselectfonsize));
        this.pwdFild.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CarparkLoginFrame.this.loginButton.doClick();
                }
            }
        });
        this.loginButton = new JButton();
        this.loginButton.setCursor(new Cursor(12));
        this.loginButton.setText("\u767b  \u5f55");
        this.loginButton.setForeground(Color.WHITE);
        this.loginButton.setFont(new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 1, userNameselectfonsize));
        this.loginButton.setBackground(Color.decode("#38a0f4"));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CarparkLoginFrame.this.doLogin();
            }
        });
        this.loginButton.setBorder(null);
        int topx2 = (int)Math.round(0.09090909090909091 * (double)loginPanelHeight);
        loginPanel.add((Component)this.loginButton, new XYConstraints(leftx, lockTop + picUserWidthHeight + topx2, titleLabelWidth, picUserWidthHeight));
    }

    private void doLogin() {
        ComboBoxEntry userEntry = (ComboBoxEntry)((Object)this.userNameselect.getSelectedItem());
        if (userEntry == null) {
            this.errMsgLabel.setText("\u8bf7\u9009\u62e9\u767b\u5f55\u7528\u6237");
            return;
        }
        CarparkUser LoginUser = (CarparkUser)userEntry.getKey();
        char[] pwd = this.pwdFild.getPassword();
        if (pwd == null || pwd.length == 0) {
            this.errMsgLabel.setText("\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            this.pwdFild.requestFocus();
            return;
        }
        String password = new String(pwd);
        this.doLoginRun(LoginUser.getUser_code(), password);
    }

    public void setRealExitSystem(boolean exit) {
        this.realExitSystem = exit;
    }

    private void doLoginRun(final String userCode, final String password) {
        if (!this.loginButton.isEnabled()) {
            return;
        }
        this.loginButton.setEnabled(false);
        this.pwdFild.setEnabled(false);
        this.userNameselect.setEnabled(false);
        this.exitButton.setEnabled(false);
        this.errMsgLabel.setText("");
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> result = null;
                try {
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    result = appService.doGuiLogin(userCode, password);
                }
                catch (Throwable throwable) {
                    Map<String, Object> loginResult = result;
                    SwingUtil.invokeLater(new Runnable(loginResult){
                        private final /* synthetic */ Map val$loginResult;
                        {
                            this.val$loginResult = map;
                        }

                        @Override
                        public void run() {
                            CarparkLoginFrame.this.pwdFild.setEnabled(true);
                            CarparkLoginFrame.this.userNameselect.setEnabled(true);
                            CarparkLoginFrame.this.loginButton.setEnabled(true);
                            CarparkLoginFrame.this.exitButton.setEnabled(true);
                            if (this.val$loginResult == null) {
                                CarparkLoginFrame.this.errMsgLabel.setText("\u767b\u5f55\u5931\u8d25!");
                                return;
                            }
                            String result = (String)this.val$loginResult.get("returnValue");
                            if ("SUCCESS".equals(result)) {
                                String tipMsg = (String)this.val$loginResult.get("tipMsg");
                                if (tipMsg != null && tipMsg.length() > 0) {
                                    String tipTitle = (String)this.val$loginResult.get("tipTitle");
                                    if (tipTitle == null || tipTitle.length() == 0) {
                                        tipTitle = "\u63d0\u793a\u7a97\u4f53";
                                    }
                                    MacOptionDialog.showAlertDialog(CarparkLoginFrame.this.rootPanel, tipTitle, tipMsg, new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                CarparkMainFrame.showWindow(null, null, CarparkLoginFrame.this.realExitSystem);
                                            }
                                            finally {
                                                CarparkLoginFrame.this.dispose();
                                            }
                                        }
                                    }, "\u786e \u5b9a");
                                } else {
                                    try {
                                        CarparkMainFrame.showWindow(null, null, CarparkLoginFrame.this.realExitSystem);
                                    }
                                    finally {
                                        CarparkLoginFrame.this.dispose();
                                    }
                                }
                            } else {
                                if (result == null || result.length() == 0) {
                                    CarparkLoginFrame.this.errMsgLabel.setText("\u767b\u5f55\u5931\u8d25!");
                                    return;
                                }
                                CarparkLoginFrame.this.errMsgLabel.setText(result);
                                return;
                            }
                        }
                    });
                    throw throwable;
                }
                Map<String, Object> loginResult = result;
                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    @Override
    public void onSystemExit() {
        if (!this.disposed) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.dispose();
            } else {
                final CountDownLatch l = new CountDownLatch(1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!CarparkLoginFrame.this.disposed) {
                                CarparkLoginFrame.this.dispose();
                            }
                        }
                        finally {
                            l.countDown();
                        }
                    }
                });
                try {
                    l.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public int[] getIntestEventId() {
        return new int[]{5116, 6140};
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (event instanceof ForceUpgradeEvent) {
            ForceUpgradeEvent e = (ForceUpgradeEvent)event;
            final String msg = "\u7cfb\u7edf\u8f6f\u4ef6\u9700\u8981\u5347\u7ea7\u5230\u65b0\u7248\u672c\uff1a" + e.getUpgradeVersion() + "\n\uff0c\u8fd9\u5c06\u4f1a\u91cd\u542f\u8f6f\u4ef6\u3002\n\u7cfb\u7edf\u5c06\u5728" + e.getRemainAutoRunSec() + "\u79d2\u540e\u81ea\u52a8\u66f4\u65b0\u5e76\u91cd\u542f...";
            final OperationFutureHandler<Boolean> doRestart = e.getDoUpgradeHandler();
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (doRestart.getResult() == null) {
                        if (CarparkLoginFrame.this.upgradeAlertDialog == null || !CarparkLoginFrame.this.upgradeAlertDialog.isVisible()) {
                            CarparkLoginFrame.this.upgradeAlertDialog = MacOptionDialog.showAlertDialog(CarparkLoginFrame.this.rootPanel, "\u8f6f\u4ef6\u66f4\u65b0\u63d0\u9192", msg, new Runnable(){

                                @Override
                                public void run() {
                                    doRestart.setResult((Object)Boolean.TRUE);
                                }
                            }, "\u91cd\u542f\u66f4\u65b0", null, false);
                        } else {
                            CarparkLoginFrame.this.upgradeAlertDialog.getContentArea().setText(msg);
                        }
                    }
                }
            });
        } else if (event.getEventId() == 6140) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CarparkLoginFrame.this.isVisible()) {
                        String txt;
                        if (CarparkLoginFrame.this.errMsgLabel != null && !"\u8f6f\u4ef6\u4f7f\u7528\u5df2\u5230\u671f,\u8bf7\u8054\u7cfb\u4e1a\u52a1\u6216\u552e\u540e\u4eba\u5458\u5904\u7406".equals(txt = CarparkLoginFrame.this.errMsgLabel.getText())) {
                            CarparkLoginFrame.this.errMsgLabel.setText("\u8f6f\u4ef6\u4f7f\u7528\u5df2\u5230\u671f,\u8bf7\u8054\u7cfb\u4e1a\u52a1\u6216\u552e\u540e\u4eba\u5458\u5904\u7406");
                        }
                        if (CarparkLoginFrame.this.loginButton != null && CarparkLoginFrame.this.loginButton.isEnabled()) {
                            CarparkLoginFrame.this.loginButton.setEnabled(false);
                        }
                    }
                }
            });
        }
    }
}

