/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.AuthInfo;
import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.gui.GuiListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.install.LicenseDialog;
import com.wovoe.carpark.gui.login.CarparkLoginFrame;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.MainVersionDialog;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class CarparkMainServerFrame
extends JFrame
implements ActionListener,
GuiListener {
    private static final long serialVersionUID = 2348438998986680371L;
    private Dimension screenSize;
    private JMenuBar menuBar;
    private TrayIcon trayIcon;
    private JPanel rootPanel;
    private Map<String, ImageIcon> iconsMap;
    private List<JLabel> labelList;
    private volatile boolean dbOk = true;
    private ScheduledFuture<?> runHanlder;
    private Color errColor = Color.decode("#eb2521");
    private Color okColor = Color.decode("#128ef2");
    private Color wanColor = Color.decode("#f29000");
    private JButton linkUrlButton;
    private JPopupMenu openMenu;
    private Dimension itemSize;
    private MainVersionDialog mainVersionDialog;
    private JFileChooser fileChooser;
    private boolean disposed = false;

    public CarparkMainServerFrame(Dimension size, Dimension screenSize) {
        if (screenSize == null) {
            screenSize = SwingUtil.getScreenSize();
        }
        this.screenSize = screenSize;
        Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
        this.setIconImage(logo);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setTitle("\u505c\u8f66\u573a\u7cfb\u7edf\u670d\u52a1\u7ba1\u7406\u5668");
        if (size == null) {
            int w = (int)Math.round(screenSize.getHeight() * 500.0 / 768.0);
            int h = (int)Math.round(screenSize.getHeight() * 250.0 / 768.0);
            size = new Dimension(w, h);
        }
        this.setSize(size.width, size.height);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.initMenuBar();
        this.init();
        int x = (screenSize.width - size.width) / 2;
        int y = (screenSize.height - size.height) / 2;
        if (x < 0 || x > screenSize.width) {
            x = 0;
        }
        if (y < 0 || y > screenSize.height) {
            y = 0;
        }
        this.setLocation(x, y);
        ServiceUtil.getServiceContext().getGuiActivator().addGuiListener(this);
        ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                CarparkMainServerFrame.this.runState();
            }
        }, 5L, 6L, TimeUnit.SECONDS);
    }

    private void doDispose0() {
        ServiceUtil.getServiceContext().getGuiActivator().removeGuiListener(this);
        if (this.runHanlder != null) {
            this.runHanlder.cancel(true);
        }
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(this.trayIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mainVersionDialog != null && this.mainVersionDialog.isVisible()) {
            this.mainVersionDialog.dispose();
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        try {
            this.doDispose0();
        }
        finally {
            super.dispose();
        }
    }

    private void runState() {
        try {
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkLocalConfig.class)).addEQ("id", (Object)1));
            this.dbOk = true;
        }
        catch (Exception ex) {
            this.dbOk = false;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                CarparkMainServerFrame.this.setLabelState();
            }
        });
    }

    private void setLabelState() {
        Cursor cursor;
        Icon icon;
        Color color;
        String tipText;
        String text;
        boolean httpOk = ServiceUtil.getServiceContext().getHttpServiceServer().isStarted();
        boolean displayLinkButton = false;
        if (httpOk) {
            Set<String> ipSet = ServiceUtil.getServiceContext().getLocalIpv4(true);
            CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
            boolean wanning = false;
            if (localHost == null) {
                wanning = true;
                text = "\u4e3b\u673a\u914d\u7f6e\u4e22\u5931\uff0c\u8bf7\u91cd\u542f\u8f6f\u4ef6\uff01";
                tipText = "\u4e25\u91cd\u9519\u8bef\uff0c\u8bf7\u91cd\u542f\u8f6f\u4ef6\uff0c\u91cd\u65b0\u521d\u59cb\u5316";
            } else if (!ipSet.contains(localHost.getHost_ip())) {
                wanning = true;
                text = String.valueOf(localHost.getHost_name()) + "\u914d\u7f6eIP\uff1a" + localHost.getHost_ip() + ",\u4e0e\u64cd\u4f5c\u7cfb\u7edfIP:" + ipSet + " \u4e0d\u4e00\u81f4";
                tipText = "\u9700\u8981\u5728[\u9009\u9879]\u4e2d\u767b\u5f55\u7ba1\u7406\u7cfb\u7edf\uff0c\u91cd\u65b0\u8bbe\u7f6eIP\uff01\u6216\u8005\u91cd\u542f\u8f6f\u4ef6\uff01";
            } else {
                text = "HTTP\u670d\u52a1\u5df2\u542f\u52a8\u3002\u7ba1\u7406\u7cfb\u7edf\u8bbf\u95eeURL\uff1ahttp://" + localHost.getHost_ip();
                if (localHost.getHost_port() != null && localHost.getHost_port() != 80) {
                    text = String.valueOf(text) + ":" + localHost.getHost_port();
                }
                tipText = "\u53ef\u4ee5\u5728\u5c40\u57df\u7f51\u7edc\u4efb\u4f55\u4e00\u53f0\u7535\u8111\uff0c\u6253\u5f00\u6d4f\u89c8\u5668\u8f93\u5165URL\u8bbf\u95ee\u7ba1\u7406\u7cfb\u7edf";
                displayLinkButton = true;
            }
            color = wanning ? this.wanColor : this.okColor;
            icon = this.getIcon("http_server_ok");
        } else {
            color = this.errColor;
            icon = this.getIcon("http_sever_fail");
            text = "\u670d\u52a1\u5668HTTP\u670d\u52a1\u672a\u542f\u52a8! \u7aef\u53e3\uff1a" + ServiceUtil.getServiceContext().getHttpServiceServer().getPort();
            tipText = "\u8bf7\u68c0\u67e5\u7aef\u53e3\u662f\u5426\u65e0\u6743\u9650\u8bbf\u95ee\uff0c\u662f\u5426\u88ab\u5176\u4ed6\u7a0b\u5e8f\u5360\u7528\uff01";
        }
        this.setInfo(this.labelList.get(0), icon, text, tipText, color);
        if (displayLinkButton) {
            String t2;
            String t1;
            if (this.linkUrlButton.getIcon() == null) {
                this.linkUrlButton.setIcon(this.getIcon("ie"));
            }
            if (this.linkUrlButton.getPressedIcon() == null) {
                this.linkUrlButton.setPressedIcon(this.getIcon("ie1"));
            }
            if (!(t1 = "\u70b9\u51fb\u6253\u5f00\u8fde\u63a5\uff1a" + this.getShowOpenUrl()).equals(t2 = this.linkUrlButton.getToolTipText())) {
                this.linkUrlButton.setToolTipText(t1);
            }
            Cursor c = this.linkUrlButton.getCursor();
            cursor = new Cursor(12);
            if (c == null || !c.equals(cursor)) {
                this.linkUrlButton.setCursor(cursor);
            }
        } else {
            Cursor c;
            cursor = new Cursor(0);
            if (this.linkUrlButton.getIcon() != null) {
                this.linkUrlButton.setIcon(null);
            }
            if (this.linkUrlButton.getToolTipText() != null) {
                this.linkUrlButton.setToolTipText(null);
            }
            if (this.linkUrlButton.getPressedIcon() != null) {
                this.linkUrlButton.setPressedIcon(null);
            }
            if ((c = this.linkUrlButton.getCursor()) == null || !c.equals(cursor)) {
                this.linkUrlButton.setCursor(cursor);
            }
        }
        if (this.dbOk) {
            color = this.okColor;
            icon = this.getIcon("database_ok");
            text = "\u670d\u52a1\u5668\u6570\u636e\u5e93\u5df2\u542f\u52a8\uff0c\u8fd0\u884c\u826f\u597d\u3002";
            tipText = "\u5df2\u6210\u529f\u8fde\u63a5\u6570\u636e\u5e93\u3002";
        } else {
            color = this.errColor;
            icon = this.getIcon("database_fail");
            text = "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u5df2\u542f\u52a8";
            tipText = "\u81f4\u547d\u9519\u8bef\uff0c\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u53ef\u5c1d\u8bd5\u91cd\u542f\u8f6f\u4ef6\u4fee\u590d";
        }
        this.setInfo(this.labelList.get(1), icon, text, tipText, color);
        Map<String, CarparkHost> mapS = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        StringBuilder bsr = new StringBuilder();
        StringBuilder bsr1 = new StringBuilder();
        int clientCount = 0;
        boolean ok = true;
        if (mapS != null) {
            for (CarparkHost c : mapS.values()) {
                if (bsr.length() > 0) {
                    bsr.append("<br>");
                }
                boolean connected = ServiceUtil.getServiceContext().isConected(c.getHost_no());
                bsr.append("\u4e3b\u673a:").append(c.getHost_name());
                if (c.getNet_mode() == 1) {
                    bsr.append('[').append(c.getHost_ip()).append(']');
                } else {
                    InetSocketAddress address;
                    CarparkUdpClient client = CarparkUdpClientManager.getInstance().getCarparkUdpClient(c.getHost_no());
                    if (client != null && client.isConnected() && (address = client.getClientAddress()) != null) {
                        try {
                            bsr.append('[').append(address.getAddress().getHostAddress()).append(']');
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!connected) {
                    ok = false;
                    bsr.append("\u79bb\u7ebf");
                    if (bsr1.length() > 0) {
                        bsr1.append('\u3001');
                    }
                    bsr1.append(c.getHost_name()).append('[').append(c.getHost_ip()).append(']').append("\u79bb\u7ebf");
                } else {
                    bsr.append("\u5728\u7ebf");
                }
                if (c.getHost_use() != 1 && c.getHost_use() != 3) continue;
                ++clientCount;
            }
        }
        if (ok) {
            if (clientCount == 0) {
                color = this.wanColor;
                text = "\u672a\u8bbe\u7f6e\u901a\u9053\u7ba1\u7406\u4e3b\u673a(\u5c97\u4ead\u5ba2\u6237\u7aef)";
                tipText = "\u672a\u8bbe\u7f6e\u4efb\u4f55\u5c97\u4ead\u5ba2\u6237\u7aef";
            } else {
                color = this.okColor;
                text = "\u6240\u6709\u4e3b\u673a\u90fd\u5728\u7ebf";
                tipText = "<html>" + bsr.toString() + "</html>";
            }
            icon = this.getIcon("all_host_ok");
        } else {
            color = this.wanColor;
            text = "\u5b58\u5728\u79bb\u7ebf\u4e3b\u673a\uff01" + bsr1;
            tipText = "<html>" + bsr.toString() + "</html>";
            icon = this.getIcon("lost_host");
        }
        this.setInfo(this.labelList.get(2), icon, text, tipText, color);
        if (ServiceUtil.getServiceContext().isWanOk()) {
            color = this.okColor;
            text = "\u672c\u673a\u5df2\u6210\u529f\u63a5\u5165\u4e92\u8054\u7f51";
            tipText = "Internet\u8bbf\u95ee";
            icon = this.getIcon("wan_ok");
        } else {
            color = this.wanColor;
            text = "\u672a\u80fd\u8bbf\u95ee\u4e92\u8054\u7f51\uff0c\u5728\u7ebf\u652f\u4ed8\u7b49\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528";
            tipText = "\u65e0\u6cd5\u6253\u5f00Internet";
            icon = this.getIcon("wan_fail");
        }
        this.setInfo(this.labelList.get(3), icon, text, tipText, color);
        if (ServiceUtil.getServiceContext().isConnectedCloud()) {
            color = this.okColor;
            text = "\u6210\u529f\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\u3002";
            tipText = "\u5df2\u63a5\u5165\u4e91\u7aef";
            icon = this.getIcon("cloud_conected");
        } else {
            color = this.wanColor;
            text = "\u672a\u80fd\u63a5\u5165\u4e91\u7aef\uff0c";
            if (ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id() == null || ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id().length() == 0) {
                text = String.valueOf(text) + "\u672a\u8bbe\u7f6e\u8f66\u573a\u4e91ID\uff0c\u672a\u5f00\u901a";
                tipText = "\u5982\u679c\u9700\u8981\u5fae\u4fe1\u3001\u652f\u4ed8\u5b9d\u7b49\u5728\u7ebf\u652f\u4ed8\u3001\u65e0\u4eba\u503c\u5b88\u3001\u65e0\u611f\u652f\u4ed8\u3001\u4e91\u7ba1\u7406\u7b49\u529f\u80fd\uff0c\u5efa\u8bae\u5f00\u901a\u3002";
            } else {
                text = String.valueOf(text) + "\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01";
                text = ServiceUtil.getServiceContext().isWanOk() ? String.valueOf(text) + "\u8bf7\u68c0\u67e5\u63a5\u5165\u4e91\u7aef\u914d\u7f6e\u662f\u5426\u6b63\u786e" : String.valueOf(text) + "\u65e0\u6cd5\u8bbf\u95eeInternet";
                tipText = "\u4e0e\u4e91\u7aef\u670d\u52a1\u5668\u5931\u53bb\u8fde\u63a5\uff0c\u8fd9\u4f1a\u5f71\u54cd\u5728\u7ebf\u652f\u4ed8\u7b49\u4e91\u7aef\u529f\u80fd\uff01";
            }
            icon = this.getIcon("cloud_disconect");
        }
        this.setInfo(this.labelList.get(4), icon, text, tipText, color);
    }

    private void setInfo(JLabel label, Icon icon, String text, String tipText, Color color) {
        String oldText = label.getText();
        String oldTipText = label.getToolTipText();
        Icon oldIcon = label.getIcon();
        Color oldColr = label.getForeground();
        if (icon != oldIcon) {
            label.setIcon(icon);
        }
        if (color == null) {
            color = Color.BLACK;
        }
        if (oldColr == null) {
            oldColr = Color.BLACK;
        }
        if (!oldColr.equals(color)) {
            label.setForeground(color);
        }
        if (text == null && oldText != null) {
            label.setText(text);
        } else if (text != null && !text.equals(oldText)) {
            label.setText(text);
        }
        if (tipText == null && oldTipText != null) {
            label.setToolTipText(tipText);
        } else if (tipText != null && !tipText.equals(oldTipText)) {
            label.setToolTipText(tipText);
        }
    }

    private String getShowOpenUrl() {
        String hostIp;
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost == null) {
            hostIp = "127.0.0.1";
        } else {
            hostIp = localHost.getHost_ip();
            if (hostIp == null || hostIp.length() == 0) {
                hostIp = "127.0.0.1";
            }
        }
        int port = ServiceUtil.getServiceContext().getHttpServiceServer().getPort();
        String url = "http://" + hostIp;
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        return url;
    }

    private void init() {
        this.rootPanel = new JPanel(new XYLayout());
        this.rootPanel.setBackground(Color.WHITE);
        this.getContentPane().add(this.rootPanel);
        this.iconsMap = Collections.synchronizedMap(new HashMap());
        this.labelList = new ArrayList<JLabel>();
        int labelHeight = (int)Math.round(this.screenSize.getHeight() * 32.0 / 768.0);
        int labelCount = 5;
        int marginLR = (int)Math.round(this.screenSize.getHeight() * 20.0 / 768.0);
        int lableWidth = this.getWidth() - 2 * marginLR;
        int marginTB = (this.getHeight() - (labelCount + 2) * labelHeight) / labelCount;
        if (marginTB < 0) {
            marginTB = 0;
        }
        int font13Size = (int)Math.round(this.screenSize.getHeight() * 13.0 / 768.0);
        Font font13 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font13Size);
        int x = marginLR;
        int y = marginTB;
        int w = lableWidth;
        int h = labelHeight;
        int iconGrap = (int)Math.round(this.screenSize.getHeight() * 3.0 / 768.0);
        this.linkUrlButton = SwingUtil.createImageButton(null, null);
        this.linkUrlButton.setActionCommand("openURLM");
        this.linkUrlButton.addActionListener(this);
        int buttonWH = labelHeight;
        int i = 0;
        while (i < labelCount) {
            w = i == 0 ? lableWidth - buttonWH : lableWidth;
            JLabel label = new JLabel();
            label.setFont(font13);
            label.setIconTextGap(iconGrap);
            this.rootPanel.add((Component)label, new XYConstraints(x, y, w, h));
            this.labelList.add(label);
            if (i == 0) {
                int lax = x + w;
                this.rootPanel.add((Component)this.linkUrlButton, new XYConstraints(lax, y, buttonWH, buttonWH));
            }
            y += h + marginTB;
            ++i;
        }
        this.setLabelState();
        try {
            PopupMenu popup = new PopupMenu();
            MenuItem exitItem = new MenuItem("Open");
            exitItem.setFont(font13);
            exitItem.setActionCommand("showFrame1");
            exitItem.addActionListener(this);
            popup.add(exitItem);
            this.trayIcon = new TrayIcon(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("parking"), "\u505c\u8f66\u573a\u7cfb\u7edf\u670d\u52a1\u7ba1\u7406\u5668\uff0c\u53cc\u51fb\u6253\u5f00\u7a97\u4f53", popup);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.setActionCommand("showFrame");
            this.trayIcon.addActionListener(this);
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this.trayIcon);
        }
        catch (Exception e1) {
            GuiLog.getLog().warn((Object)("TrayIcon could not be added! " + e1.getMessage()));
            this.setDefaultCloseOperation(0);
        }
    }

    private Icon getIcon(String iconName) {
        ImageIcon icon = this.iconsMap.get(iconName);
        if (icon == null) {
            Image a = CarparkGuiSkinUtil.getCarparkGuiSkin().newImage(iconName);
            if (a == null) {
                return null;
            }
            int wh = (int)Math.round(this.screenSize.getHeight() * 22.0 / 768.0);
            icon = new ImageIcon(SwingUtil.resizeImage(a, wh, wh));
            this.iconsMap.put(iconName, icon);
        }
        return icon;
    }

    private void initMenuBar() {
        int font13Size = (int)Math.round(this.screenSize.getHeight() * 13.0 / 768.0);
        Font font13 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font13Size);
        this.menuBar.setFont(font13);
        JMenu menu = new JMenu("\u9009\u9879");
        menu.setFont(font13);
        this.menuBar.add(menu);
        JMenuItem item = new JMenuItem("\u6253\u5f00\u901a\u9053/\u89c6\u9891\u76d1\u63a7\u7a97\u53e3");
        item.setToolTipText("\u8fd9\u5c06\u6253\u5f00\u5ba2\u6237\u7aef\u76d1\u63a7\u7a97\u53e3");
        item.setFont(font13);
        item.setActionCommand("openChannelMonitor");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u6253\u5f00\u7ba1\u7406\u7cfb\u7edf\u767b\u5f55\u7a97\u53e3");
        item.setToolTipText("\u8fd9\u5c06\u6253\u5f00\u7ba1\u7406\u7cfb\u7edf\u9875\u9762");
        item.setFont(font13);
        item.setActionCommand("openManager");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u8f6f\u4ef6\u6388\u6743\u4fe1\u606f");
        item.setToolTipText("\u67e5\u770b\u8f6f\u4ef6\u6388\u6743\u4fe1\u606f");
        item.setFont(font13);
        item.setActionCommand("sys_auth_info");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u7cfb\u7edf\u8f6f\u4ef6\u7248\u672c/\u5728\u7ebf\u5347\u7ea7");
        item.setToolTipText("\u70b9\u51fb\u67e5\u770b\u5f53\u524d\u7cfb\u7edf\u8f6f\u4ef6\u7248\u672c\uff0c\u5e76\u68c0\u67e5\u662f\u5426\u6709\u65b0\u7248\u672c\u9700\u8981\u66f4\u65b0");
        item.setFont(font13);
        item.setActionCommand("openVersion");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u5173\u95ed/\u9000\u51fa\u7cfb\u7edf");
        item.setToolTipText("\u8fd9\u5c06\u9000\u51fa\u7cfb\u7edf");
        item.setFont(font13);
        item.setActionCommand("exitSystem");
        item.addActionListener(this);
        menu.add(item);
    }

    public static void showWindow(final Dimension size, final WindowListener windowListener) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CarparkMainServerFrame f = new CarparkMainServerFrame(size, null);
                    if (windowListener != null) {
                        f.addWindowListener(windowListener);
                    }
                    f.toFront();
                    f.setVisible(true);
                }
                catch (Throwable ex) {
                    GuiLog.getLog().warn((Object)ex.getMessage(), ex);
                    MacOptionDialog.showAlertDialog(null, "\u7cfb\u7edf\u5f02\u5e38", "\u7cfb\u7edf\u542f\u52a8\u7a97\u4f53\u5f02\u5e38\uff01\u539f\u56e0:" + ex.getMessage(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceUtil.getServiceContext().exitSystem(null);
                        }
                    }, null);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("showFrame".equals(cmd) || "showFrame1".equals(cmd)) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            if (this.getState() != 0) {
                this.setState(0);
            }
            this.toFront();
        } else if ("openURLM".equals(cmd)) {
            if (this.openMenu == null) {
                this.openMenu = new JPopupMenu();
                this.openMenu.setBorder(BorderFactory.createLineBorder(new Color(209, 217, 222)));
                int itemFontSize = (int)Math.round(this.screenSize.getHeight() * 13.0 / 768.0);
                Font itemFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
                String text = "   \u4f7f\u7528\u64cd\u4f5c\u7cfb\u7edf\u6d4f\u89c8\u5668\u6253\u5f00   ";
                int itemW = SwingUtil.getStringFontSize((String)text, (Font)itemFont).width;
                this.itemSize = new Dimension(itemW, 2 * itemFontSize + 3);
                text = " \u4f7f\u7528\u64cd\u4f5c\u7cfb\u7edf\u6d4f\u89c8\u5668\u6253\u5f00 ";
                JMenuItem item = new JMenuItem(text);
                item.setActionCommand("openwithSystemBrowser");
                item.addActionListener(this);
                item.setFont(itemFont);
                item.setToolTipText("\u652f\u6301IE\u3001Firefox\u3001Chrome\u3001Safari\u3001Opera\u7b49\u4e3b\u6d41\u6d4f\u89c8\u5668\uff0c\u5982\u679c\u662fIE\u5fc5\u987b\u662fIE9\u4ee5\u4e0a");
                item.setPreferredSize(this.itemSize);
                this.openMenu.add(item);
                this.openMenu.addSeparator();
                text = " \u4f7f\u7528\u7cfb\u7edf\u81ea\u5e26\u6d4f\u89c8\u5668\u6253\u5f00  ";
                item = new JMenuItem(text);
                item.setActionCommand("openwithCaparkBrowser");
                item.addActionListener(this);
                item.setFont(itemFont);
                item.setPreferredSize(this.itemSize);
                this.openMenu.add(item);
                this.openMenu.addSeparator();
                text = " \u4fdd\u5b58\u7ba1\u7406\u7cfb\u7edfURL\u5230\u6587\u4ef6 ";
                item = new JMenuItem(text);
                item.setToolTipText("\u5efa\u8bae\u4fdd\u5b58\u5230\u684c\u9762\uff0c\u65b9\u4fbf\u5feb\u6377\u6253\u5f00\u7ba1\u7406\u7cfb\u7edf");
                item.setActionCommand("saveUrlToFile");
                item.addActionListener(this);
                item.setFont(itemFont);
                item.setPreferredSize(this.itemSize);
                this.openMenu.add(item);
            }
            if (!this.openMenu.isVisible()) {
                this.openMenu.show(this.linkUrlButton, -this.itemSize.width, this.linkUrlButton.getHeight() / 2);
            }
        } else if ("openwithCaparkBrowser".equals(cmd) || "openManager".equals(cmd)) {
            if (this.mainVersionDialog != null && this.mainVersionDialog.isVisible()) {
                this.mainVersionDialog.dispose();
            }
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    int port = ServiceUtil.getServiceContext().getHttpServiceServer().getPort();
                    String url = "http://127.0.0.1";
                    if (port != 80) {
                        url = String.valueOf(url) + ":" + port;
                    }
                    ServiceUtil.getServiceContext().getBrowserProcess().openUrl(url, null);
                }
            });
        } else if ("openVersion".equals(cmd)) {
            if (this.mainVersionDialog != null && this.mainVersionDialog.isVisible()) {
                this.mainVersionDialog.toFront();
            } else {
                this.mainVersionDialog = MainVersionDialog.createDialog(this, null, null, true);
                this.mainVersionDialog.setVisible(true);
            }
        } else if ("sys_auth_info".equals(cmd)) {
            String bu;
            String msg;
            AuthInfo auth = ServiceUtil.getServiceContext().getAuthInfo();
            if (!auth.isOfficial()) {
                msg = "\u60a8\u6b63\u5728\u4f7f\u7528\u8bd5\u7528\u7248\u8f6f\u4ef6\n";
                if (!auth.isValid()) {
                    msg = String.valueOf(msg) + "\u8f6f\u4ef6\u5df2\u5230\u671f\uff01";
                } else {
                    msg = String.valueOf(msg) + "\u8f6f\u4ef6\u8fd8\u5269\uff1a" + auth.getRemainDays() + "\u5929\u5230\u671f\uff01\n";
                    msg = String.valueOf(msg) + "\u8bf7\u5c3d\u5feb\u8d2d\u4e70\u6b63\u5f0f\u7248\u3002";
                }
                bu = "\u5bfc\u5165\u6388\u6743\u6587\u4ef6";
            } else if (!auth.isValid()) {
                msg = "\u8f6f\u4ef6\u5df2\u5230\u671f\uff01\n \u8bf7\u5bfc\u5165\u65b0\u7684\u6388\u6743\u6587\u4ef6\u6216\u5e8f\u5217\u53f7";
                bu = "\u5bfc\u5165\u6388\u6743\u6587\u4ef6";
            } else {
                msg = "\u8f6f\u4ef6\u5df2\u6388\u6743\n";
                msg = String.valueOf(msg) + "\u6709\u6548\u671f\u81f3\uff1a" + auth.getValidDate();
                msg = String.valueOf(msg) + "\n\u6388\u6743\u5e8f\u5217\u53f7\uff1a" + auth.getSn();
                msg = String.valueOf(msg) + "\n\u6388\u6743\u8bc1\u4e66ID\uff1a" + auth.getG();
                msg = String.valueOf(msg) + "\n\u6388\u6743\u65b9\u5f0f\uff1a" + (auth.getKeyType() == 1 ? "USB\u8bc1\u4e66" : "\u5e8f\u5217\u53f7\u8bc1\u4e66");
                bu = "\u66f4\u6539\u6388\u6743\u6587\u4ef6";
            }
            MacOptionDialog.showConfirmDialog(this, "\u8f6f\u4ef6\u6388\u6743\u4fe1\u606f", msg, null, "\u5173\u95ed", new Runnable(){

                @Override
                public void run() {
                    try {
                        ((LicenseDialog)LicenseDialog.createDialog(CarparkMainServerFrame.this.rootPanel, false, ServiceUtil.getServiceContext().getCarparkLocalConfig()).get()).getUseTestButton().setText("\u53d6\u6d88");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, bu);
        } else if ("openChannelMonitor".equals(cmd)) {
            if (this.mainVersionDialog != null && this.mainVersionDialog.isVisible()) {
                this.mainVersionDialog.dispose();
            }
            for (GuiListener l : ServiceUtil.getServiceContext().getGuiActivator().getGuiListeners()) {
                if (l instanceof CarparkMainFrame) {
                    CarparkMainFrame f = (CarparkMainFrame)l;
                    if (f.getState() != 0) {
                        f.setState(0);
                    }
                    f.toFront();
                    return;
                }
                if (!(l instanceof CarparkLoginFrame)) continue;
                CarparkLoginFrame f = (CarparkLoginFrame)l;
                if (f.getState() != 0) {
                    f.setState(0);
                }
                f.toFront();
                return;
            }
            ServiceUtil.getServiceContext().getGuiActivator().doStart(ServiceUtil.getServiceContext(), null, false);
        } else if ("saveUrlToFile".equals(cmd)) {
            int reurnV;
            File desktopDir;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected JDialog createDialog(Component parent) throws HeadlessException {
                        JDialog d = super.createDialog(parent);
                        d.setIconImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("folder"));
                        d.setTitle("\u8bf7\u9009\u62e9\u6587\u4ef6\u3010\u8f66\u573a\u7ba1\u7406\u7cfb\u7edf\u767b\u5f55.html\u3011\u4fdd\u5b58\u76ee\u5f55");
                        return d;
                    }
                };
                this.fileChooser.setFileSelectionMode(1);
                this.fileChooser.setApproveButtonText("\u786e\u5b9a");
            }
            if ((desktopDir = FileSystemView.getFileSystemView().getHomeDirectory()).exists() && desktopDir.isDirectory()) {
                this.fileChooser.setCurrentDirectory(desktopDir);
            }
            if ((reurnV = this.fileChooser.showOpenDialog(this)) == 0) {
                boolean saveSuccess;
                File file1;
                block63: {
                    File saveDir = this.fileChooser.getSelectedFile();
                    if (saveDir.isFile()) {
                        return;
                    }
                    if (!saveDir.exists()) {
                        saveDir.mkdirs();
                    }
                    file1 = new File(saveDir, "\u8f66\u573a\u7ba1\u7406\u7cfb\u7edf\u767b\u5f55.html");
                    saveSuccess = true;
                    FileOutputStream out = null;
                    try {
                        try {
                            out = new FileOutputStream(file1);
                            out.write(this.getMagemtmal().getBytes("UTF-8"));
                        }
                        catch (Exception ex) {
                            saveSuccess = false;
                            GuiLog.getLog().warn((Object)("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38:" + file1), (Throwable)ex);
                            MacOptionDialog.showAlertDialog(this, "\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38", "\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6\u5230\u6307\u5b9a\u8def\u5f84: " + file1.getAbsolutePath() + "\uff0c\u539f\u56e0\uff1a" + ex.getMessage(), null, "\u5173\u95ed");
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block63;
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (saveSuccess) {
                    MacOptionDialog.showAlertDialog(this, "\u4fdd\u5b58\u6587\u4ef6\u6210\u529f", "\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230\u6307\u5b9a\u8def\u5f84: " + file1.getAbsolutePath(), null, "\u77e5\u9053\u4e86");
                }
            }
        } else if ("openwithSystemBrowser".equals(cmd)) {
            String url = this.getShowOpenUrl();
            boolean ok = false;
            if (Desktop.isDesktopSupported()) {
                try {
                    URI uri = URI.create(url);
                    Desktop dp = Desktop.getDesktop();
                    if (dp.isSupported(Desktop.Action.BROWSE)) {
                        dp.browse(uri);
                        ok = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!ok) {
                try {
                    if (OSUtil.isWindows()) {
                        Runtime.getRuntime().exec("cmd   /c   start   " + url);
                    }
                }
                catch (IOException iOException) {}
            }
        } else if ("exitSystem".equals(cmd)) {
            MacOptionDialog.showConfirmDialog(this.rootPanel, "\u9000\u51fa\u7cfb\u7edf\u786e\u8ba4", "\u60a8\u786e\u5b9a\u8981\u9000\u51fa\u7cfb\u7edf\u5417\uff1f", null, null, new Runnable(){

                @Override
                public void run() {
                    CarparkMainServerFrame.this.rootPanel.setCursor(new Cursor(3));
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ServiceUtil.getServiceContext().exitSystem(null);
                        }
                    });
                    t.setDaemon(true);
                    t.start();
                }
            }, null);
        }
    }

    private String getMagemtmal() {
        StringBuilder s = new StringBuilder(128);
        s.append("<!DOCTYPE html><html><head><script type=\"text/javascript\">");
        s.append("location.href='").append(this.getShowOpenUrl()).append("'");
        s.append("</script></head></html>");
        return s.toString();
    }

    @Override
    public void onSystemExit() {
        if (!this.disposed) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.dispose();
            } else {
                final CountDownLatch l = new CountDownLatch(1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!CarparkMainServerFrame.this.disposed) {
                                CarparkMainServerFrame.this.dispose();
                            }
                        }
                        finally {
                            l.countDown();
                        }
                    }
                });
                try {
                    l.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

