/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.DateTimePicker;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.MainTabPane;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class ChargeRecordSearchTabPane
extends JPanel
implements MainTabPane,
MouseListener,
ActionListener,
GotoPageHandler {
    private static final long serialVersionUID = -8106268433957394799L;
    private Dimension mainSize;
    private JTextField date1Field;
    private JTextField date2Field;
    private String queryDateFormat = "yy/MM/dd HH:mm:ss";
    private JComboBox<ComboBoxEntry<Integer>> chargeOrgSelect;
    private JComboBox<ComboBoxEntry<Integer>> chargeSceneSelect;
    private JComboBox<ComboBoxEntry<Integer>> tranServiceTotalSelect;
    private JComboBox<ComboBoxEntry<String>> userSelect;
    private JComboBox<ComboBoxEntry<String>> hostSelect;
    private JComboBox<ComboBoxEntry<Integer>> payMethodSelect;
    private JComboBox<ComboBoxEntry<String>> areaSelect;
    private JComboBox<ComboBoxEntry<String>> passportTypeSelect;
    private JComboBox<ComboBoxEntry<String>> carTypeSelect;
    private JTextField plateField;
    private JButton searchButton;
    private JTable eqTable;
    private JScrollPane resultTablePanel;
    private PaginationPanel pagePanel;
    private static int recordPageSize = 10;
    private volatile boolean loadFirst = false;
    private volatile boolean selected = false;
    private volatile BigDecimal totalMoney = Constants.MONEY_ZERO;
    private DateTimePicker datePicker1;
    private DateTimePicker datePicker2;

    @Override
    public void init(Dimension size, Dimension rootSize) {
        int label2Weidht;
        this.mainSize = rootSize;
        this.setLayout(new XYLayout());
        Color cl = Color.decode("#222222");
        int fontSize = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int searchTWidth = (int)Math.round(this.mainSize.getWidth() * 70.0 / 1280.0);
        int searchHeight = (int)Math.round(this.mainSize.getHeight() * 26.0 / 768.0);
        int searchMarginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int grap = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        int dateWidth = (int)Math.round(this.mainSize.getWidth() * 130.0 / 1024.0);
        int x = 0;
        int y = searchMarginTop;
        int w = searchTWidth;
        int h = searchHeight;
        JLabel lable = new JLabel("\u6536\u8d39\u65f6\u95f4");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.date1Field = new JTextField();
        this.date1Field.setFont(font);
        this.date1Field.setEditable(false);
        this.date1Field.addMouseListener(this);
        this.add((Component)this.date1Field, new XYConstraints(x, y, w, h));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.date1Field.setText(new SimpleDateFormat(this.queryDateFormat).format(calendar.getTime()));
        x += w;
        w = label2Weidht = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        JLabel labl2 = new JLabel("\u81f3");
        labl2.setHorizontalAlignment(0);
        labl2.setFont(font);
        labl2.setForeground(cl);
        this.add((Component)labl2, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        this.date2Field = new JTextField();
        this.date2Field.setFont(font);
        this.date2Field.setEditable(false);
        this.date2Field.addMouseListener(this);
        this.add((Component)this.date2Field, new XYConstraints(x, y, w, h));
        this.date2Field.setText(new SimpleDateFormat(this.queryDateFormat).format(now));
        int timeEndWidth = x += w;
        int remainWith = size.width - timeEndWidth - grap;
        int avgTextWidth = (remainWith - 2 * searchTWidth - grap) / 2;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u65b9");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x += grap, y, w, h));
        Vector<ComboBoxEntry<Object>> list = new Vector<ComboBoxEntry<Object>>();
        list.add(new ComboBoxEntry<Object>(null, "\u5168\u90e8"));
        Map<Integer, String> zmap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
        if (zmap != null) {
            for (Map.Entry<Integer, String> e : zmap.entrySet()) {
                list.add(new ComboBoxEntry<Integer>(e.getKey(), e.getValue()));
            }
        }
        this.chargeOrgSelect = new JComboBox(list);
        this.chargeOrgSelect.setBackground(Color.WHITE);
        this.chargeOrgSelect.setFont(font);
        this.chargeOrgSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.chargeOrgSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u652f\u4ed8\u573a\u666f");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        list = new Vector();
        list.add(new ComboBoxEntry<Object>(null, "\u5168\u90e8"));
        zmap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        if (zmap != null) {
            for (Map.Entry<Integer, String> e : zmap.entrySet()) {
                list.add(new ComboBoxEntry<Integer>(e.getKey(), e.getValue()));
            }
        }
        this.chargeSceneSelect = new JComboBox(list);
        this.chargeSceneSelect.setBackground(Color.WHITE);
        this.chargeSceneSelect.setFont(font);
        this.chargeSceneSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.chargeSceneSelect, new XYConstraints(x, y, w, h));
        int leftAvgWidth = (timeEndWidth - 2 * searchTWidth - grap) / 2;
        int maginTop = (int)Math.round(this.mainSize.getHeight() * 8.0 / 768.0);
        y += h + maginTop;
        x = 0;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u7c7b\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        UserSession session = appService.getUserSession();
        boolean isAdmin = "1".equals(session.getRole().getRole_no());
        boolean haveRechrodP = false;
        if (isAdmin) {
            haveRechrodP = true;
        } else {
            Set<String> set = session.getPermissions();
            if (set != null && !set.isEmpty() && set.contains("/manage/showPlateManage.action") && (set.contains("/manage/updatePassportRechageFee.action") || set.contains("/manage/updatePassportRechageDate.action") || set.contains("/manage/addCarparkPassport.action"))) {
                haveRechrodP = true;
            }
        }
        list = new Vector();
        if (haveRechrodP) {
            list.add(new ComboBoxEntry<Object>(null, "\u5168\u90e8"));
            list.add(new ComboBoxEntry<Integer>(0, "\u4e34\u505c\u8f66\u8d39"));
            list.add(new ComboBoxEntry<Integer>(1, "\u5145\u503c/\u5ef6\u671f"));
        } else {
            list.add(new ComboBoxEntry<Integer>(0, "\u4e34\u505c\u8f66\u8d39"));
        }
        this.tranServiceTotalSelect = new JComboBox(list);
        this.tranServiceTotalSelect.setBackground(Color.WHITE);
        this.tranServiceTotalSelect.setFont(font);
        this.tranServiceTotalSelect.addActionListener(this);
        x += w;
        w = leftAvgWidth;
        this.add(this.tranServiceTotalSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u4eba\u5458");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> vlist = new Vector<ComboBoxEntry<String>>();
        vlist.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        this.userSelect = new JComboBox(vlist);
        this.userSelect.setBackground(Color.WHITE);
        this.userSelect.setFont(font);
        this.userSelect.addActionListener(this);
        x += w;
        w = leftAvgWidth;
        this.add(this.userSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u7535\u8111");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        vlist = new Vector();
        vlist.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        if (hostMap != null) {
            for (CarparkHost carparkHost : hostMap.values()) {
                if (carparkHost.getHost_no().equals(localHostNo)) {
                    vlist.add(new ComboBoxEntry<String>(carparkHost.getHost_no(), String.valueOf(carparkHost.getHost_name()) + "(\u672c\u673a)"));
                    continue;
                }
                vlist.add(new ComboBoxEntry<String>(carparkHost.getHost_no(), carparkHost.getHost_name()));
            }
        }
        this.hostSelect = new JComboBox(vlist);
        this.hostSelect.setBackground(Color.WHITE);
        this.hostSelect.setFont(font);
        this.hostSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.hostSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u652f\u4ed8\u65b9\u5f0f");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        list = new Vector();
        list.add(new ComboBoxEntry<Object>(null, "\u5168\u90e8"));
        zmap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        if (zmap != null) {
            for (Map.Entry entry : zmap.entrySet()) {
                if (((Integer)entry.getKey() == 2 || (Integer)entry.getKey() == 3) && !haveRechrodP) continue;
                list.add(new ComboBoxEntry<Integer>((Integer)entry.getKey(), (String)entry.getValue()));
            }
        }
        this.payMethodSelect = new JComboBox(list);
        this.payMethodSelect.setBackground(Color.WHITE);
        this.payMethodSelect.setFont(font);
        this.payMethodSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.payMethodSelect, new XYConstraints(x, y, w, h));
        y += h + maginTop;
        x = 0;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u573a\u533a");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Map<String, CarparkArea> map = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        Vector<ComboBoxEntry<String>> areaList = new Vector<ComboBoxEntry<String>>();
        areaList.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        if (map != null) {
            for (CarparkArea area : map.values()) {
                if (area.getArea_level() != 1) continue;
                areaList.add(new ComboBoxEntry<String>(area.getArea_no(), area.getArea_name()));
            }
        }
        this.areaSelect = new JComboBox(areaList);
        this.areaSelect.setBackground(Color.WHITE);
        this.areaSelect.setFont(font);
        this.areaSelect.addActionListener(this);
        x += w;
        w = leftAvgWidth;
        this.add(this.areaSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u8f66\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> carTypeList = new Vector<ComboBoxEntry<String>>();
        carTypeList.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (carTypeMap != null) {
            for (CarparkCarType t : carTypeMap.values()) {
                carTypeList.add(new ComboBoxEntry<String>(t.getCar_type_no(), t.getCar_type_name()));
            }
        }
        this.carTypeSelect = new JComboBox(carTypeList);
        this.carTypeSelect.setBackground(Color.WHITE);
        this.carTypeSelect.setFont(font);
        this.carTypeSelect.addActionListener(this);
        x += w;
        w = leftAvgWidth;
        this.add(this.carTypeSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u8f66\u724c\u7c7b\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> passportTypeList = new Vector<ComboBoxEntry<String>>();
        passportTypeList.add(new ComboBoxEntry<String>("", "\u5168\u90e8\u7c7b\u578b"));
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (passportTypeMap != null) {
            for (CarparkPassportType t : passportTypeMap.values()) {
                passportTypeList.add(new ComboBoxEntry<String>(t.getPassport_type_no(), t.getPassport_type_name()));
            }
        }
        this.passportTypeSelect = new JComboBox(passportTypeList);
        this.passportTypeSelect.setBackground(Color.WHITE);
        this.passportTypeSelect.setFont(font);
        this.passportTypeSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.passportTypeSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u6536\u8d39\u8f66\u724c");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        int searchButtonWidth = 5 * fontSize;
        int plateWidth = avgTextWidth - searchButtonWidth - 5;
        this.plateField = new JTextField();
        this.plateField.setFont(font);
        x += w;
        w = plateWidth;
        this.add((Component)this.plateField, new XYConstraints(x, y, w, h));
        this.plateField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChargeRecordSearchTabPane.this.getPlate();
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        x += w + 5;
        this.searchButton = new JButton("\u67e5\u8be2");
        this.searchButton.addActionListener(this);
        this.searchButton.setFont(font);
        this.searchButton.setCursor(new Cursor(12));
        w = searchButtonWidth;
        this.add((Component)this.searchButton, new XYConstraints(x, y, w, h));
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(this.getBackground());
        int pagePanelHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        int apagePanelWidth = (int)Math.round(this.mainSize.getHeight() * 38.0 / 768.0);
        int apagePanelMarButtom = (int)Math.round(this.mainSize.getHeight() * 5.0 / 768.0);
        int pagePanelWidth = size.width;
        int pagePanelX = 0;
        int pagePanelY = size.height - pagePanelHeight - apagePanelMarButtom;
        this.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.setInitPagePanelWidth(apagePanelWidth);
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), this.mainSize, 7);
        this.pagePanel.getInfoLable().setFont(font);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.setBackground(this.getBackground());
        int dataMarginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int dataMarginBottom = (int)Math.round(this.mainSize.getHeight() * 8.0 / 768.0);
        int dataPanelX = 0;
        int dataPanelY = y + h + dataMarginTop;
        int dataPanelWidth = size.width;
        int dataPanelHeight = pagePanelY - dataMarginBottom - dataPanelY;
        this.add((Component)dataPanel, new XYConstraints(dataPanelX, dataPanelY, dataPanelWidth, dataPanelHeight));
        int rowHeight = (int)Math.round(this.mainSize.getHeight() * 31.0 / 768.0);
        this.eqTable = new JTable();
        this.eqTable.setRowHeight(rowHeight);
        this.eqTable.setShowGrid(true);
        this.eqTable.setModel(new SetTableModel(null));
        this.eqTable.setBackground(dataPanel.getBackground());
        this.eqTable.setGridColor(Color.decode("#D4D8DC"));
        int cellFontSize = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        Font cellFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, cellFontSize);
        this.eqTable.setFont(cellFont);
        this.eqTable.getTableHeader().setFont(font);
        this.resultTablePanel = new JScrollPane(this.eqTable);
        this.resultTablePanel.setBackground(dataPanel.getBackground());
        this.resultTablePanel.getViewport().setBackground(Color.decode("#F5F8FD"));
        dataPanel.add((Component)this.resultTablePanel, "Center");
        if (isAdmin) {
            this.loadUsers();
        } else {
            this.loadLocalUsers();
        }
    }

    private String getPlate() {
        String x = this.plateField.getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateField.setText(v2);
        }
        return v2;
    }

    private void loadLocalUsers() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                List ropList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"DISTINCT role_no AS role_no"}).addEQ("permission_no", (Object)("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
                HashSet<String> roleList = new HashSet<String>();
                if (ropList != null && !ropList.isEmpty()) {
                    for (CarparkRolePermission r : ropList) {
                        if (r.getRole_no() == null || r.getRole_no().length() <= 0) continue;
                        roleList.add(r.getRole_no());
                    }
                }
                roleList.add("1");
                final List canLoginUserList = commonDaoService.selectList(new SearchParam().addINList("role_no", roleList).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no,user_code"), CarparkUser.class, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (canLoginUserList != null && !canLoginUserList.isEmpty()) {
                            for (CarparkUser u : canLoginUserList) {
                                ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>(u.getUser_code(), u.getUser_name()));
                            }
                            ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>("USER_SELF", "\u81ea\u52a9\u7f34\u8d39"));
                            ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>("USER_CLOUD_CODE", "\u4e91\u7aef\u7528\u6237"));
                        }
                    }
                });
            }
        });
    }

    private void loadUsers() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                final List canLoginUserList = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no,user_code"), CarparkUser.class, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (canLoginUserList != null && !canLoginUserList.isEmpty()) {
                            for (CarparkUser u : canLoginUserList) {
                                ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>(u.getUser_code(), u.getUser_name()));
                            }
                        }
                        ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>("USER_SELF", "\u81ea\u52a9\u7f34\u8d39"));
                        ChargeRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>("USER_CLOUD_CODE", "\u4e91\u7aef\u7528\u6237"));
                    }
                });
            }
        });
    }

    @Override
    public void doDiselct() {
        this.selected = false;
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
    }

    @Override
    public void doSelect() {
        this.selected = true;
        if (!this.loadFirst) {
            this.loadFirst = true;
            this.gotoPage(1, recordPageSize, -1, 0, 0);
        }
    }

    @Override
    public void onWidnowDispose() {
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabName() {
        return "\u6536\u8d39/\u652f\u4ed8\u8bb0\u5f55";
    }

    @Override
    public void onPressEnter() {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    public SearchParam getSearchParam() {
        Object key;
        ComboBoxEntry box;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam p = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
        String beginDate = this.date1Field.getText();
        DateFormat df = null;
        Date _startDate = null;
        if (beginDate != null && beginDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _startDate = df.parse(beginDate);
                p.addGTE("tran_time", (Object)_startDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String endDate = this.date2Field.getText();
        Date _endDate = null;
        if (endDate != null && endDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _endDate = df.parse(endDate);
                p.addLTE("tran_time", (Object)_endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_startDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u7f34\u8d39/\u652f\u4ed8\u5f00\u59cb\u65f6\u95f4", 4));
            return null;
        }
        if (_endDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u7f34\u8d39/\u652f\u4ed8\u7ed3\u675f\u65f6\u95f4", 4));
            return null;
        }
        long ass = _endDate.getTime() - _startDate.getTime();
        if (ass < 0L) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u7f34\u8d39/\u652f\u4ed8\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        long mills = TimeUnit.DAYS.toMillis(62L);
        if (ass > mills) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u67e5\u8be2\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc762\u5929\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        String plate = this.getPlate();
        if (plate != null && plate.length() > 0) {
            p.addLike("plate_number", plate);
        }
        if ((box = (ComboBoxEntry)((Object)this.chargeOrgSelect.getSelectedItem())) != null && (key = (Integer)box.getKey()) != null) {
            p.addEQ("charge_org", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.chargeSceneSelect.getSelectedItem())) != null && (key = (Integer)box.getKey()) != null) {
            p.addEQ("pay_scene", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.tranServiceTotalSelect.getSelectedItem())) != null && (key = (Integer)box.getKey()) != null) {
            if ((Integer)key == 0) {
                p.addLTE("service_type", (Object)1);
            } else if ((Integer)key == 1) {
                p.addGT("service_type", (Object)1);
            }
        }
        if ((box = (ComboBoxEntry)((Object)this.payMethodSelect.getSelectedItem())) != null && (key = (Integer)box.getKey()) != null) {
            p.addEQ("pay_method", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.areaSelect.getSelectedItem())) != null && (key = (String)box.getKey()) != null && ((String)key).length() > 0) {
            p.addEQ("tran_area_no", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.passportTypeSelect.getSelectedItem())) != null && (key = (String)box.getKey()) != null && ((String)key).length() > 0) {
            p.addEQ("passport_type_no", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.carTypeSelect.getSelectedItem())) != null && (key = (String)box.getKey()) != null && ((String)key).length() > 0) {
            p.addEQ("car_type_no", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.userSelect.getSelectedItem())) != null && (key = (String)box.getKey()) != null && ((String)key).length() > 0) {
            p.addEQ("operate_user_code", key);
        }
        if ((box = (ComboBoxEntry)((Object)this.hostSelect.getSelectedItem())) != null && (key = (String)box.getKey()) != null && ((String)key).length() > 0) {
            p.addEQ("host_no", key);
        }
        p.setOrerbySql("tran_time DESC");
        return p;
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        if (!this.selected) {
            return;
        }
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        final Pagination pagination = new Pagination();
        if (recordsCount < 0) {
            pagination.setNeedQueryCount(true);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
        } else {
            pagination.setNeedQueryCount(false);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
            pagination.setRecordsCount((long)recordsCount);
        }
        final SearchParam p = this.getSearchParam();
        if (p == null) {
            return;
        }
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean neeQueryTotalMoney = pagination.isNeedQueryCount();
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    final List recordList = commonDaoService.selectList(p, CarparkTransaction.class, pagination);
                    if (neeQueryTotalMoney) {
                        if (pagination.getRecordsCount() == 0L) {
                            ChargeRecordSearchTabPane.this.totalMoney = Constants.MONEY_ZERO;
                        } else {
                            p.setQueryFields(new String[]{"SUM(tran_money) AS total_money"});
                            p.setTableName(commonDaoService.getTableName(CarparkTransaction.class));
                            p.setOrder_by(null);
                            Map pax = commonDaoService.selectOne(p);
                            if (pax == null || pax.isEmpty()) {
                                ChargeRecordSearchTabPane.this.totalMoney = Constants.MONEY_ZERO;
                            } else {
                                BigDecimal d = (BigDecimal)pax.get("total_money");
                                if (d == null) {
                                    ChargeRecordSearchTabPane.this.totalMoney = Constants.MONEY_ZERO;
                                } else {
                                    ChargeRecordSearchTabPane.this.totalMoney = d;
                                }
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                                ChargeRecordSearchTabPane.this.eqTable.setModel(new SetTableModel(recordList));
                                ChargeRecordSearchTabPane.this.pagePanel.setPagination(pagination, "\u603b\u91d1\u989d\uff1a" + sf.format(ChargeRecordSearchTabPane.this.totalMoney) + "\uff0c\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize());
                            }
                            finally {
                                ChargeRecordSearchTabPane.this.searchButton.setEnabled(true);
                                ChargeRecordSearchTabPane.this.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    ChargeRecordSearchTabPane.this.searchButton.setEnabled(true);
                    ChargeRecordSearchTabPane.this.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.selected) {
            return;
        }
        Object source = e.getSource();
        if (source == this.date1Field) {
            if (this.datePicker1 == null) {
                this.datePicker1 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        ChargeRecordSearchTabPane.this.date1Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        ChargeRecordSearchTabPane.this.date1Field.setText(dateTime);
                        ChargeRecordSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker2 != null && this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            }
            if (this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            } else {
                String t = this.date1Field.getText();
                this.datePicker1.setDateTime(t);
                this.datePicker1.showPicker(this.date1Field);
            }
        } else if (source == this.date2Field) {
            if (this.datePicker2 == null) {
                this.datePicker2 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        ChargeRecordSearchTabPane.this.date2Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        ChargeRecordSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker1 != null && this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            }
            if (this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            } else {
                String t = this.date2Field.getText();
                this.datePicker2.setDateTime(t);
                this.datePicker2.showPicker(this.date2Field);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class SetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5225431626950004306L;
        private String[] titleHeaders = new String[]{"\u6536\u8d39\u65f6\u95f4", "\u6536\u8d39\u91d1\u989d", "\u652f\u4ed8\u65b9\u5f0f/\u7c7b\u578b", "\u652f\u4ed8\u8f66\u724c", "\u8f66\u724c\u7c7b\u578b", "\u573a\u533a/\u5165\u573a\u65f6\u95f4", "\u6536\u8d39\u5458/\u7535\u8111", "\u6536\u8d39\u65b9/\u573a\u666f", "\u6536\u8d39\u63cf\u8ff0"};
        SimpleDateFormat df = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        private SimpleDateFormat df1;
        private NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
        private List<CarparkTransaction> dataList;

        private SetTableModel(List<CarparkTransaction> dataList) {
            this.dataList = dataList;
        }

        @Override
        public int getColumnCount() {
            return this.titleHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.dataList == null ? 0 : this.dataList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            String v = null;
            if (this.dataList == null || this.dataList.isEmpty()) {
                return "";
            }
            if (rowIndex >= this.dataList.size()) {
                return "";
            }
            CarparkTransaction t = this.dataList.get(rowIndex);
            switch (col) {
                case 0: {
                    v = t.getTran_time() == null ? null : this.df.format(t.getTran_time());
                    break;
                }
                case 1: {
                    v = t.getTran_money() == null ? null : this.sf.format(t.getTran_money());
                    break;
                }
                case 2: {
                    v = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(t.getPay_method());
                    if (v == null) {
                        v = "";
                    }
                    if (t.getService_type() == null) break;
                    v = String.valueOf(v) + "," + Constants.getTranServiceTypeMap().get(t.getService_type());
                    break;
                }
                case 3: {
                    v = t.getPlate_number();
                    break;
                }
                case 4: {
                    v = t.getPassport_type_name();
                    if (v != null && v.length() > 0) {
                        if (t.getCar_type_name() == null || t.getCar_type_name().length() <= 0) break;
                        v = String.valueOf(v) + "," + t.getCar_type_name();
                        break;
                    }
                    v = t.getCar_type_name();
                    break;
                }
                case 5: {
                    v = t.getTran_area_name();
                    if (t.getEnter_time() == null) break;
                    if (v != null && v.length() > 0) {
                        v = String.valueOf(v) + "," + this.df.format(t.getEnter_time());
                        break;
                    }
                    v = this.df.format(t.getEnter_time());
                    break;
                }
                case 6: {
                    v = t.getOperate_user_name();
                    if (t.getHost_name() == null || t.getHost_name().length() <= 0) break;
                    if (v != null && v.length() > 0) {
                        v = String.valueOf(v) + "," + t.getHost_name();
                        break;
                    }
                    v = t.getHost_name();
                    break;
                }
                case 7: {
                    v = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(t.getCharge_org());
                    String lai = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(t.getPay_scene());
                    if (lai == null || lai.length() <= 0) break;
                    if (v != null && v.length() > 0) {
                        v = String.valueOf(v) + "," + lai;
                        break;
                    }
                    v = lai;
                    break;
                }
                case 8: {
                    v = t.getTran_des();
                    if (t.getService_type() == null) break;
                    if (t.getService_type() == 0) {
                        v = "\u5e94\u6536:" + (t.getShould_charge() == null ? Constants.MONEY_ZERO : t.getShould_charge());
                        if (t.getDiscount_money() != null && t.getDiscount_money().doubleValue() > 0.0) {
                            v = String.valueOf(v) + ",\u6298\u6263:" + t.getDiscount_money();
                        }
                        if (t.getPeriod_multi_free() != null && t.getPeriod_multi_free().doubleValue() > 0.0) {
                            v = String.valueOf(v) + ",\u5468\u671f\u4f18\u60e0:" + t.getPeriod_multi_free();
                        }
                        if (t.getAlready_paid() == null || !(t.getAlready_paid().doubleValue() > 0.0)) break;
                        v = String.valueOf(v) + ",\u5176\u4ed6\u652f\u4ed8:" + t.getAlready_paid();
                        break;
                    }
                    if (t.getService_type() == 2 || t.getService_type() == 3) {
                        if (t.getStart_date() == null || t.getEnd_date() == null) break;
                        if (this.df1 == null) {
                            this.df1 = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5");
                        }
                        v = "\u5f00\u59cb:" + this.df1.format(t.getStart_date()) + ",\u7ed3\u675f:" + this.df1.format(t.getEnd_date());
                        break;
                    }
                    if (t.getService_type() != 2 && t.getService_type() != 3 || t.getRecharge_money() == null) break;
                    v = "\u5145\u503c\u505c\u8f66\u8d39:" + t.getRecharge_money() + "\u5143";
                }
            }
            if (v == null) {
                v = "";
            }
            return v;
        }

        @Override
        public String getColumnName(int column) {
            return this.titleHeaders[column];
        }
    }
}

