/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkDutyNumber;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.DateTimePicker;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.MainSearchDialog;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class DutyChargeSearchDialog
extends MainSearchDialog
implements GotoPageHandler,
ActionListener {
    private static final long serialVersionUID = -2257958785851757941L;
    private static DutyChargeSearchDialog instance;
    private List<JLabel> dutyLabelList;
    private JTextField date1Field;
    private JTextField date2Field;
    private JComboBox<ComboBoxEntry<Integer>> serviceTypeBox;
    private JButton searchButton;
    private PaginationPanel pagePanel;
    private JPanel dataPanel;
    private JTable eqTable;
    private JScrollPane resultTablePanel;
    private JTextField plateSearch;
    private JButton buttonRight;
    private JButton buttonLeft;
    private Icon upIcon;
    private Icon downIcon;
    private CarparkDutyNumber currentNumber;
    private CarparkDutyNumber upNumber;
    private CarparkDutyNumber downNumber;
    private int recordPageSize = 10;
    private Date queryMinDate;
    private Date queryMaxDate;
    private DateTimePicker datePicker1;
    private DateTimePicker datePicker2;

    public static boolean isDShowing() {
        DutyChargeSearchDialog instance0 = instance;
        return instance0 != null && instance0.isVisible();
    }

    public static DutyChargeSearchDialog getInstance() {
        return instance;
    }

    public static void showDialog(CarparkMainFrame frame) {
        if (instance != null && instance.isVisible()) {
            instance.toFront();
            return;
        }
        instance = new DutyChargeSearchDialog(frame);
        instance.setTitleInfo("\u5f53\u73ed\u6536\u8d39");
        instance.setVisible(true);
    }

    public static void colseIfShow() {
        if (instance != null && instance.isVisible()) {
            instance.dispose();
            instance = null;
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.datePicker1 != null && this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            }
            if (this.datePicker2 != null && this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    protected void doPressCloseButton() {
        super.doPressCloseButton();
        instance = null;
    }

    protected DutyChargeSearchDialog(CarparkMainFrame frame) {
        super(frame);
    }

    @Override
    protected void init(JPanel bodyPanel, Dimension bodySize, Dimension mainSize) {
        int textTitleWidth1;
        bodyPanel.setLayout(new XYLayout());
        Color cl = Color.decode("#222222");
        int titleFontSize = (int)Math.round(mainSize.getHeight() * 13.0 / 768.0);
        JLabel dutyTitleLabel = new JLabel("\u73ed\u6b21\u4fe1\u606f");
        int titleWidth = (int)((double)bodySize.width * 0.35);
        int titleHeight = (int)Math.round(mainSize.getHeight() * 35.0 / 768.0);
        int titleX = 0;
        int titleY = 0;
        Font titleFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 1, titleFontSize);
        dutyTitleLabel.setFont(titleFont);
        dutyTitleLabel.setForeground(cl);
        bodyPanel.add((Component)dutyTitleLabel, new XYConstraints(titleX, titleY, titleWidth, titleHeight));
        int imageWH = (int)Math.round(mainSize.getHeight() * 16.0 / 768.0);
        if (titleHeight < imageWH) {
            imageWH = titleHeight;
        }
        this.upIcon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("arrow_up_333"), imageWH, imageWH));
        this.downIcon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("arrow_down_344"), imageWH, imageWH));
        this.buttonRight = SwingUtil.createImageButton(null, null);
        this.buttonRight.addActionListener(this);
        this.buttonRight.setActionCommand("queryDutyNum_right");
        this.buttonLeft = SwingUtil.createImageButton(null, null);
        this.buttonLeft.addActionListener(this);
        this.buttonLeft.setActionCommand("queryDutyNum_left");
        int xbaX = bodySize.width - imageWH;
        int xbay = (titleHeight - imageWH) / 2;
        bodyPanel.add((Component)this.buttonRight, new XYConstraints(xbaX, xbay, imageWH, imageWH));
        bodyPanel.add((Component)this.buttonLeft, new XYConstraints(xbaX -= imageWH + imageWH, xbay, imageWH, imageWH));
        int textTitleWidth0 = (int)Math.round(mainSize.getWidth() * 90.0 / 1280.0);
        int textTitleWidth2 = textTitleWidth1 = (int)Math.round(mainSize.getWidth() * 100.0 / 1280.0);
        int textFiledWidth = (bodySize.width - textTitleWidth0 - textTitleWidth1 - textTitleWidth2) / 3;
        int textHegiht = (int)Math.round(mainSize.getHeight() * 30.0 / 768.0);
        String[] tlex = new String[]{"\u73ed\u6b21\u53f7", "\u4e0a\u73ed\u65f6\u95f4", "\u4ea4\u73ed\u65f6\u95f4", "\u6536\u8d39\u5458", "\u767b\u5f55\u8d26\u53f7", "\u6536\u8d39\u73b0\u91d1"};
        int dutyLabelCount = tlex.length;
        int dutyFontSize = (int)Math.round(mainSize.getHeight() * 13.0 / 768.0);
        Font dutyFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, dutyFontSize);
        this.dutyLabelList = new ArrayList<JLabel>(dutyLabelCount);
        Color tColor = Color.decode("#222222");
        Color ttColor = Color.decode("#666666");
        int x = 0;
        int y = titleY + titleHeight;
        int w = 0;
        int i = 0;
        while (i < dutyLabelCount) {
            if (i == 0 || i == 3) {
                w = textTitleWidth0;
            } else if (i == 1 || i == 4) {
                w = textTitleWidth1;
            } else if (i == 2 || i == 5) {
                w = textTitleWidth2;
            }
            if (i == 0 || i == 3) {
                x = 0;
                if (i == 3) {
                    y += textHegiht;
                }
            } else {
                x += textFiledWidth;
            }
            JLabel l1 = new JLabel(tlex[i]);
            l1.setForeground(ttColor);
            l1.setFont(dutyFont);
            bodyPanel.add((Component)l1, new XYConstraints(x, y, w, textHegiht));
            JLabel l2 = new JLabel();
            l2.setFont(dutyFont);
            l2.setForeground(tColor);
            bodyPanel.add((Component)l2, new XYConstraints(x += w, y, textFiledWidth, textHegiht));
            this.dutyLabelList.add(l2);
            ++i;
        }
        JPanel linePanel = new JPanel();
        linePanel.setBackground(Color.decode("#EDEDED"));
        int lineHeight = (int)Math.round(mainSize.getHeight() * 1.0 / 768.0);
        int lineMaginTop = (int)Math.round(mainSize.getHeight() * 8.0 / 768.0);
        bodyPanel.add((Component)linePanel, new XYConstraints(0, y += textHegiht + lineMaginTop, bodySize.width, lineHeight));
        JLabel dutyTitleLabel2 = new JLabel("\u6536\u8d39\u660e\u7ec6");
        dutyTitleLabel2.setFont(titleFont);
        dutyTitleLabel2.setForeground(cl);
        bodyPanel.add((Component)dutyTitleLabel2, new XYConstraints(titleX, y += lineHeight, titleWidth, titleHeight));
        int searchMarginTop = 0;
        int searchHeight = (int)Math.round(mainSize.getHeight() * 28.0 / 768.0);
        int searchTWidth = (int)Math.round(mainSize.getWidth() * 70.0 / 1280.0);
        JLabel label1 = new JLabel("\u6536\u8d39\u65f6\u95f4");
        label1.setFont(dutyFont);
        label1.setForeground(tColor);
        y = y + titleHeight + searchMarginTop;
        x = 0;
        bodyPanel.add((Component)label1, new XYConstraints(x, y, searchTWidth, searchHeight));
        this.date1Field = new JTextField();
        int dateWidth = (int)Math.round(mainSize.getWidth() * 146.0 / 1024.0);
        this.date1Field.setFont(dutyFont);
        this.date1Field.setEditable(false);
        bodyPanel.add((Component)this.date1Field, new XYConstraints(x += searchTWidth, y, dateWidth, searchHeight));
        this.date1Field.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DutyChargeSearchDialog.this.datePicker1 == null) {
                    DutyChargeSearchDialog.this.datePicker1 = DateTimePicker.createDateTimePicker(new DateTimePicker.DateTimePickerCallback(){

                        @Override
                        public void onPicking(String dateTime) {
                        }

                        @Override
                        public void onPickClear() {
                        }

                        @Override
                        public void doPick(String dateTime) {
                            try {
                                Date date = DutyChargeSearchDialog.this.datePicker1.getFormat().parse(dateTime);
                                if (DutyChargeSearchDialog.this.queryMinDate != null && date.getTime() < DutyChargeSearchDialog.this.queryMinDate.getTime()) {
                                    date = DutyChargeSearchDialog.this.queryMinDate;
                                    DutyChargeSearchDialog.this.date1Field.setText(DutyChargeSearchDialog.this.datePicker1.getFormat().format(date));
                                    return;
                                }
                                if (DutyChargeSearchDialog.this.queryMaxDate != null && date.getTime() > DutyChargeSearchDialog.this.queryMaxDate.getTime()) {
                                    date = DutyChargeSearchDialog.this.queryMaxDate;
                                    DutyChargeSearchDialog.this.date1Field.setText(DutyChargeSearchDialog.this.datePicker1.getFormat().format(date));
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DutyChargeSearchDialog.this.date1Field.setText(dateTime);
                        }
                    }, false);
                }
                if (DutyChargeSearchDialog.this.datePicker2 != null && DutyChargeSearchDialog.this.datePicker2.isShow()) {
                    DutyChargeSearchDialog.this.datePicker2.hidePanel();
                }
                if (DutyChargeSearchDialog.this.datePicker1.isShow()) {
                    DutyChargeSearchDialog.this.datePicker1.hidePanel();
                } else {
                    DutyChargeSearchDialog.this.datePicker1.setDateTime(DutyChargeSearchDialog.this.date1Field.getText());
                    DutyChargeSearchDialog.this.datePicker1.showPicker(DutyChargeSearchDialog.this.date1Field);
                }
            }
        });
        x += dateWidth;
        JLabel labl2 = new JLabel("\u81f3");
        labl2.setHorizontalAlignment(0);
        labl2.setFont(dutyFont);
        labl2.setForeground(tColor);
        int label2Weidht = (int)Math.round(mainSize.getWidth() * 25.0 / 1280.0);
        bodyPanel.add((Component)labl2, new XYConstraints(x, y, label2Weidht, searchHeight));
        this.date2Field = new JTextField();
        this.date2Field.setFont(dutyFont);
        this.date2Field.setEditable(false);
        this.date2Field.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DutyChargeSearchDialog.this.datePicker2 == null) {
                    DutyChargeSearchDialog.this.datePicker2 = DateTimePicker.createDateTimePicker(new DateTimePicker.DateTimePickerCallback(){

                        @Override
                        public void onPicking(String dateTime) {
                        }

                        @Override
                        public void onPickClear() {
                        }

                        @Override
                        public void doPick(String dateTime) {
                            try {
                                Date date = DutyChargeSearchDialog.this.datePicker2.getFormat().parse(dateTime);
                                if (DutyChargeSearchDialog.this.queryMinDate != null && date.getTime() < DutyChargeSearchDialog.this.queryMinDate.getTime()) {
                                    date = DutyChargeSearchDialog.this.queryMinDate;
                                    DutyChargeSearchDialog.this.date2Field.setText(DutyChargeSearchDialog.this.datePicker2.getFormat().format(date));
                                    return;
                                }
                                if (DutyChargeSearchDialog.this.queryMaxDate != null && date.getTime() > DutyChargeSearchDialog.this.queryMaxDate.getTime()) {
                                    date = DutyChargeSearchDialog.this.queryMaxDate;
                                    DutyChargeSearchDialog.this.date2Field.setText(DutyChargeSearchDialog.this.datePicker2.getFormat().format(date));
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DutyChargeSearchDialog.this.date2Field.setText(dateTime);
                        }
                    }, false);
                }
                if (DutyChargeSearchDialog.this.datePicker1 != null && DutyChargeSearchDialog.this.datePicker1.isShow()) {
                    DutyChargeSearchDialog.this.datePicker1.hidePanel();
                }
                if (DutyChargeSearchDialog.this.datePicker2.isShow()) {
                    DutyChargeSearchDialog.this.datePicker2.hidePanel();
                } else {
                    DutyChargeSearchDialog.this.datePicker2.setDateTime(DutyChargeSearchDialog.this.date2Field.getText());
                    DutyChargeSearchDialog.this.datePicker2.showPicker(DutyChargeSearchDialog.this.date2Field);
                }
            }
        });
        bodyPanel.add((Component)this.date2Field, new XYConstraints(x += label2Weidht, y, dateWidth, searchHeight));
        int smarg = (int)Math.round(mainSize.getWidth() * 13.0 / 1280.0);
        JLabel labl3 = new JLabel("\u6536\u8d39\u7c7b\u578b ");
        labl3.setFont(dutyFont);
        labl3.setHorizontalAlignment(4);
        labl3.setForeground(tColor);
        Vector<ComboBoxEntry<Integer>> serviceTypeList = new Vector<ComboBoxEntry<Integer>>();
        serviceTypeList.add(new ComboBoxEntry<Integer>(-1, "\u5168\u90e8\u7c7b\u578b"));
        serviceTypeList.add(new ComboBoxEntry<Integer>(0, "\u4e34\u505c\u8f66\u8d39"));
        serviceTypeList.add(new ComboBoxEntry<Integer>(1, "\u5145\u503c/\u5ef6\u671f"));
        this.serviceTypeBox = new JComboBox(serviceTypeList);
        this.serviceTypeBox.setSelectedIndex(0);
        this.serviceTypeBox.setFont(dutyFont);
        this.serviceTypeBox.setBackground(Color.WHITE);
        bodyPanel.add((Component)labl3, new XYConstraints(x += dateWidth + smarg, y, searchTWidth, searchHeight));
        int sTypwidht = (int)Math.round(mainSize.getWidth() * 100.0 / 1024.0);
        bodyPanel.add(this.serviceTypeBox, new XYConstraints(x += searchTWidth, y, sTypwidht, searchHeight));
        int btweiht = 5 * dutyFontSize;
        labl3 = new JLabel("\u6536\u8d39\u8f66\u724c ");
        labl3.setFont(dutyFont);
        labl3.setForeground(tColor);
        labl3.setHorizontalAlignment(4);
        bodyPanel.add((Component)labl3, new XYConstraints(x += sTypwidht + smarg, y, searchTWidth, searchHeight));
        int buttonX = bodySize.width - btweiht;
        this.plateSearch = new JTextField();
        this.plateSearch.setFont(dutyFont);
        this.plateSearch.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DutyChargeSearchDialog.this.getPlate();
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        int plateSeacrhWidth = buttonX - smarg * 2 - (x += searchTWidth);
        bodyPanel.add((Component)this.plateSearch, new XYConstraints(x, y, plateSeacrhWidth, searchHeight));
        this.searchButton = new JButton("\u67e5\u8be2");
        this.searchButton.setActionCommand("queryDetailTran");
        this.searchButton.addActionListener(this);
        this.searchButton.setFont(dutyFont);
        this.searchButton.setCursor(new Cursor(12));
        bodyPanel.add((Component)this.searchButton, new XYConstraints(x += plateSeacrhWidth + smarg * 2, y, btweiht, searchHeight));
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(bodyPanel.getBackground());
        int pagePanelHeight = (int)Math.round(mainSize.getHeight() * 28.0 / 768.0);
        int apagePanelWidth = (int)Math.round(mainSize.getHeight() * 38.0 / 768.0);
        int apagePanelMarButtom = (int)Math.round(mainSize.getHeight() * 6.0 / 768.0);
        int pagePanelWidth = bodySize.width;
        int pagePanelX = 0;
        int pagePanelY = bodySize.height - pagePanelHeight - apagePanelMarButtom;
        bodyPanel.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.setInitPagePanelWidth(apagePanelWidth);
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), mainSize, 7);
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setBackground(bodyPanel.getBackground());
        int dataMarginTop = (int)Math.round(mainSize.getHeight() * 15.0 / 768.0);
        int dataMarginBottom = (int)Math.round(mainSize.getHeight() * 8.0 / 768.0);
        int dataPanelX = 0;
        int dataPanelY = y + searchHeight + dataMarginTop;
        int dataPanelWidth = bodySize.width;
        int dataPanelHeight = pagePanelY - dataMarginBottom - dataPanelY;
        bodyPanel.add((Component)this.dataPanel, new XYConstraints(dataPanelX, dataPanelY, dataPanelWidth, dataPanelHeight));
        this.eqTable = new JTable();
        int rowHeight = (int)Math.round(mainSize.getHeight() * 30.0 / 768.0);
        this.eqTable.setRowHeight(rowHeight);
        this.eqTable.setShowGrid(true);
        this.eqTable.setModel(new SetTableModel(null));
        this.eqTable.setBackground(this.dataPanel.getBackground());
        this.eqTable.setGridColor(Color.decode("#D4D8DC"));
        int cellFontSize = (int)Math.round(mainSize.getHeight() * 12.0 / 768.0);
        Font cellFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, cellFontSize);
        this.eqTable.setFont(cellFont);
        this.eqTable.getTableHeader().setFont(dutyFont);
        this.resultTablePanel = new JScrollPane(this.eqTable);
        this.resultTablePanel.setBackground(this.dataPanel.getBackground());
        this.resultTablePanel.getViewport().setBackground(Color.decode("#F5F8FD"));
        this.dataPanel.add((Component)this.resultTablePanel, "Center");
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        UserSession userSession = appService.getUserSession();
        this.currentNumber = userSession.getDutyNumber();
        if (userSession != null && userSession.getUser() != null) {
            this.dutyLabelList.get(3).setText(userSession.getUser().getUser_name());
            this.dutyLabelList.get(4).setText(userSession.getUser().getUser_code());
        }
        this.doSeachDutyNumber(true);
    }

    private void doSeachDutyNumber(final boolean up) {
        if (this.currentNumber == null || this.currentNumber.getStart_time() == null) {
            return;
        }
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.bodyPanel.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    BigDecimal money;
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    SearchParam p = new SearchParam();
                    p.addEQ("login_duty_user_code", (Object)DutyChargeSearchDialog.this.currentNumber.getLogin_duty_user_code());
                    p.addEQ("login_host_no", (Object)DutyChargeSearchDialog.this.currentNumber.getLogin_host_no());
                    if (up) {
                        p.addLT("start_time", (Object)DutyChargeSearchDialog.this.currentNumber.getStart_time());
                        p.setOrerbySql("start_time DESC");
                    } else {
                        p.addGT("start_time", (Object)DutyChargeSearchDialog.this.currentNumber.getStart_time());
                        p.setOrerbySql("start_time ASC");
                    }
                    Pagination page = new Pagination();
                    page.setRecordsCount(1L);
                    page.setNeedQueryCount(false);
                    page.setGotoPage(1);
                    page.setPageSize(1);
                    final CarparkDutyNumber xNumber = (CarparkDutyNumber)commonDaoService.selectOne(p, CarparkDutyNumber.class, page);
                    p = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
                    p.addGTE("tran_time", (Object)DutyChargeSearchDialog.this.currentNumber.getStart_time());
                    final Date endTime = DutyChargeSearchDialog.this.currentNumber.getEnd_time() != null ? DutyChargeSearchDialog.this.currentNumber.getEnd_time() : ServiceUtil.getNow();
                    p.addLTE("tran_time", (Object)endTime);
                    p.addEQ("pay_method", (Object)0);
                    p.addEQ("duty_no", (Object)DutyChargeSearchDialog.this.currentNumber.getDuty_no());
                    DutyChargeSearchDialog.this.setHostNoSp(p, DutyChargeSearchDialog.this.currentNumber.getLogin_host_no());
                    p.addEQ("operate_user_code", (Object)DutyChargeSearchDialog.this.currentNumber.getLogin_duty_user_code());
                    p.addEQ("pay_scene", (Object)0);
                    p.addQueyField("SUM(tran_money) AS total_cash");
                    Map map = commonDaoService.selectOne(p);
                    if (map == null || map.isEmpty()) {
                        money = Constants.MONEY_ZERO;
                    } else {
                        money = (BigDecimal)map.get("total_cash");
                        if (money == null) {
                            money = Constants.MONEY_ZERO;
                        }
                    }
                    NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                    final String moneyDes = sf.format(money);
                    p = new SearchParam();
                    p.addEQ("pay_method", (Object)0);
                    p.addEQ("duty_no", (Object)DutyChargeSearchDialog.this.currentNumber.getDuty_no());
                    DutyChargeSearchDialog.this.setHostNoSp(p, DutyChargeSearchDialog.this.currentNumber.getLogin_host_no());
                    p.addEQ("operate_user_code", (Object)DutyChargeSearchDialog.this.currentNumber.getLogin_duty_user_code());
                    p.addEQ("pay_scene", (Object)0);
                    p.addGTE("tran_time", (Object)DutyChargeSearchDialog.this.currentNumber.getStart_time());
                    p.addLTE("tran_time", (Object)endTime);
                    p.setOrder_by("tran_time");
                    final Pagination pagination = new Pagination();
                    pagination.setNeedQueryCount(true);
                    pagination.setPageSize(DutyChargeSearchDialog.this.recordPageSize);
                    pagination.setGotoPage(1);
                    final List recordList = commonDaoService.selectList(p, CarparkTransaction.class, pagination);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((JLabel)DutyChargeSearchDialog.this.dutyLabelList.get(0)).setText(DutyChargeSearchDialog.this.currentNumber.getDuty_no());
                                SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
                                ((JLabel)DutyChargeSearchDialog.this.dutyLabelList.get(1)).setText(df.format(DutyChargeSearchDialog.this.currentNumber.getStart_time()));
                                if (DutyChargeSearchDialog.this.currentNumber.getEnd_time() == null) {
                                    ((JLabel)DutyChargeSearchDialog.this.dutyLabelList.get(2)).setText("\u672a\u4ea4\u73ed");
                                } else {
                                    ((JLabel)DutyChargeSearchDialog.this.dutyLabelList.get(2)).setText(df.format(DutyChargeSearchDialog.this.currentNumber.getEnd_time()));
                                }
                                ((JLabel)DutyChargeSearchDialog.this.dutyLabelList.get(5)).setText(moneyDes);
                                DutyChargeSearchDialog.this.serviceTypeBox.setSelectedIndex(0);
                                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                DutyChargeSearchDialog.this.date1Field.setText(df1.format(DutyChargeSearchDialog.this.currentNumber.getStart_time()));
                                DutyChargeSearchDialog.this.date2Field.setText(df1.format(endTime));
                                DutyChargeSearchDialog.this.plateSearch.setText("");
                                DutyChargeSearchDialog.this.queryMinDate = DutyChargeSearchDialog.this.currentNumber.getStart_time();
                                DutyChargeSearchDialog.this.queryMaxDate = endTime;
                                if (up) {
                                    DutyChargeSearchDialog.this.upNumber = xNumber;
                                } else {
                                    DutyChargeSearchDialog.this.downNumber = xNumber;
                                }
                                if (DutyChargeSearchDialog.this.downNumber != null && DutyChargeSearchDialog.this.upNumber != null) {
                                    DutyChargeSearchDialog.this.buttonLeft.setIcon(DutyChargeSearchDialog.this.downIcon);
                                    DutyChargeSearchDialog.this.buttonLeft.setCursor(new Cursor(12));
                                    DutyChargeSearchDialog.this.buttonLeft.setToolTipText("\u70b9\u51fb\u67e5\u770b\u4e0b\u4e00\u73ed\u6b21\u4fe1\u606f");
                                    DutyChargeSearchDialog.this.buttonRight.setIcon(DutyChargeSearchDialog.this.upIcon);
                                    DutyChargeSearchDialog.this.buttonRight.setCursor(new Cursor(12));
                                    DutyChargeSearchDialog.this.buttonRight.setToolTipText("\u70b9\u51fb\u67e5\u770b\u4e0a\u4e00\u73ed\u6b21\u4fe1\u606f");
                                } else if (DutyChargeSearchDialog.this.downNumber != null && DutyChargeSearchDialog.this.upNumber == null) {
                                    DutyChargeSearchDialog.this.buttonLeft.setToolTipText(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setIcon(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setCursor(new Cursor(0));
                                    DutyChargeSearchDialog.this.buttonRight.setIcon(DutyChargeSearchDialog.this.downIcon);
                                    DutyChargeSearchDialog.this.buttonRight.setCursor(new Cursor(12));
                                    DutyChargeSearchDialog.this.buttonRight.setToolTipText("\u70b9\u51fb\u67e5\u770b\u4e0b\u4e00\u73ed\u6b21\u4fe1\u606f");
                                } else if (DutyChargeSearchDialog.this.downNumber == null && DutyChargeSearchDialog.this.upNumber != null) {
                                    DutyChargeSearchDialog.this.buttonLeft.setToolTipText(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setIcon(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setCursor(new Cursor(0));
                                    DutyChargeSearchDialog.this.buttonRight.setIcon(DutyChargeSearchDialog.this.upIcon);
                                    DutyChargeSearchDialog.this.buttonRight.setCursor(new Cursor(12));
                                    DutyChargeSearchDialog.this.buttonRight.setToolTipText("\u70b9\u51fb\u67e5\u770b\u4e0a\u4e00\u73ed\u6b21\u4fe1\u606f");
                                } else {
                                    DutyChargeSearchDialog.this.buttonRight.setToolTipText(null);
                                    DutyChargeSearchDialog.this.buttonRight.setIcon(null);
                                    DutyChargeSearchDialog.this.buttonRight.setCursor(new Cursor(0));
                                    DutyChargeSearchDialog.this.buttonLeft.setToolTipText(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setIcon(null);
                                    DutyChargeSearchDialog.this.buttonLeft.setCursor(new Cursor(0));
                                }
                                DutyChargeSearchDialog.this.eqTable.setModel(new SetTableModel(recordList));
                                DutyChargeSearchDialog.this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
                            }
                            finally {
                                DutyChargeSearchDialog.this.searchButton.setEnabled(true);
                                (this).DutyChargeSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    DutyChargeSearchDialog.this.searchButton.setEnabled(true);
                    DutyChargeSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    private void setHostNoSp(SearchParam sp, String hostNo) {
        Enumeration<PassChannel> ens;
        if (hostNo == null || hostNo.length() == 0) {
            hostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        }
        HashSet<String> hostSet = new HashSet<String>();
        hostSet.add(hostNo);
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
            while (ens.hasMoreElements()) {
                PassChannel chanel = ens.nextElement();
                String slaveHostNo = chanel.getChannel().getSlave_managed_host_no();
                if (slaveHostNo == null || slaveHostNo.length() <= 0) continue;
                hostSet.add(slaveHostNo);
            }
        }
        if (hostSet.size() == 1) {
            sp.addEQ("host_no", (Object)hostNo);
        } else {
            sp.addINList("host_no", hostSet);
        }
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        String plate;
        Integer a;
        ComboBoxEntry entry;
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        final Pagination pagination = new Pagination();
        if (recordsCount < 0) {
            pagination.setNeedQueryCount(true);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
        } else {
            pagination.setNeedQueryCount(false);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
            pagination.setRecordsCount((long)recordsCount);
        }
        String date1str = this.date1Field.getText();
        Date beginDate = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date1str != null && date1str.length() > 0) {
            try {
                beginDate = df.parse(date1str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.queryMinDate != null && (beginDate == null || beginDate.getTime() < this.queryMinDate.getTime())) {
            beginDate = this.queryMinDate;
            this.date1Field.setText(df.format(beginDate));
        }
        String date2str = this.date2Field.getText();
        Date endDate = null;
        if (date2str != null && date2str.length() > 0) {
            try {
                endDate = df.parse(date2str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.queryMaxDate != null && (endDate == null || endDate.getTime() > this.queryMaxDate.getTime())) {
            endDate = this.queryMaxDate;
            this.date1Field.setText(df.format(endDate));
        }
        if (beginDate != null && endDate != null && beginDate.getTime() > endDate.getTime()) {
            pagination.setRecordsCount(0L);
            pagination.calculatePage();
            this.eqTable.setModel(new SetTableModel(null));
            this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
            return;
        }
        final SearchParam p = new SearchParam();
        p.addEQ("pay_method", (Object)0);
        p.addEQ("duty_no", (Object)this.currentNumber.getDuty_no());
        this.setHostNoSp(p, this.currentNumber.getLogin_host_no());
        p.addEQ("operate_user_code", (Object)this.currentNumber.getLogin_duty_user_code());
        p.addEQ("pay_scene", (Object)0);
        p.setOrder_by("tran_time");
        if (beginDate != null) {
            p.addGTE("tran_time", (Object)beginDate);
        }
        if (endDate != null) {
            p.addLTE("tran_time", (Object)endDate);
        }
        if ((entry = (ComboBoxEntry)((Object)this.serviceTypeBox.getSelectedItem())) != null && (a = (Integer)entry.getKey()) != null) {
            if (a == 0) {
                p.addLTE("service_type", (Object)1);
            } else if (a == 1) {
                p.addGT("service_type", (Object)1);
            }
        }
        if ((plate = this.getPlate()) != null && plate.length() > 0) {
            p.addLike("plate_number", plate);
        }
        p.setOrder_by("tran_time");
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.bodyPanel.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    final List recordList = commonDaoService.selectList(p, CarparkTransaction.class, pagination);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DutyChargeSearchDialog.this.eqTable.setModel(new SetTableModel(recordList));
                                DutyChargeSearchDialog.this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
                            }
                            finally {
                                DutyChargeSearchDialog.this.searchButton.setEnabled(true);
                                (this).DutyChargeSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    DutyChargeSearchDialog.this.searchButton.setEnabled(true);
                    DutyChargeSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    private String getPlate() {
        String x = this.plateSearch.getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateSearch.setText(v2);
        }
        return v2;
    }

    @Override
    protected void onPressEnter() {
        this.gotoPage(1, this.recordPageSize, -1, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.startsWith("queryDutyNum_")) {
            JButton b = (JButton)e.getSource();
            Icon icon = b.getIcon();
            if (icon == null) {
                return;
            }
            if (icon == this.upIcon) {
                if (this.upNumber != null) {
                    this.downNumber = this.currentNumber;
                    this.currentNumber = this.upNumber;
                    this.upNumber = null;
                    this.doSeachDutyNumber(true);
                }
            } else if (icon == this.downIcon && this.downNumber != null) {
                this.upNumber = this.currentNumber;
                this.currentNumber = this.downNumber;
                this.downNumber = null;
                this.doSeachDutyNumber(false);
            }
        } else if ("queryDetailTran".equals(cmd)) {
            this.gotoPage(1, this.recordPageSize, -1, 0, 0);
        }
    }

    private static class SetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5225431626950004306L;
        private String[] titleHeaders = new String[]{"\u6536\u8d39\u65f6\u95f4", "\u6536\u8d39\u73b0\u91d1", "\u6536\u8d39\u5458", "\u6536\u8d39\u901a\u9053", "\u6536\u8d39\u5c97\u4ead", "\u6536\u8d39\u8f66\u724c", "\u8f66\u724c\u7c7b\u578b", "\u5165\u573a\u65f6\u95f4", "\u6536\u8d39\u7c7b\u578b", "\u6536\u8d39\u63cf\u8ff0"};
        private List<CarparkTransaction> dataList;
        private SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        private SimpleDateFormat df1;
        private NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);

        private SetTableModel(List<CarparkTransaction> dataList) {
            this.dataList = dataList;
        }

        @Override
        public int getColumnCount() {
            return this.titleHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.dataList == null ? 0 : this.dataList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String v = null;
            if (this.dataList == null || this.dataList.isEmpty()) {
                return "";
            }
            if (row >= this.dataList.size()) {
                return "";
            }
            CarparkTransaction t = this.dataList.get(row);
            switch (col) {
                case 0: {
                    v = t.getTran_time() == null ? null : this.df.format(t.getTran_time());
                    break;
                }
                case 1: {
                    v = t.getTran_money() == null ? null : this.sf.format(t.getTran_money());
                    break;
                }
                case 2: {
                    v = t.getOperate_user_name();
                    break;
                }
                case 3: {
                    v = t.getTran_channel_name();
                    break;
                }
                case 4: {
                    v = t.getHost_name();
                    break;
                }
                case 5: {
                    v = t.getPlate_number();
                    break;
                }
                case 6: {
                    v = t.getPassport_type_name();
                    if (v == null || v.length() == 0) {
                        v = t.getCar_type_name();
                        break;
                    }
                    if (t.getCar_type_name() == null || t.getCar_type_name().length() <= 0) break;
                    v = String.valueOf(v) + "\u3001" + t.getCar_type_name();
                    break;
                }
                case 7: {
                    v = t.getEnter_time() == null ? null : this.df.format(t.getEnter_time());
                    break;
                }
                case 8: {
                    v = t.getService_type() == null ? null : Constants.getTranServiceTypeMap().get(t.getService_type());
                    break;
                }
                case 9: {
                    v = t.getTran_des();
                    if (t.getService_type() == null) break;
                    if (t.getService_type() == 0) {
                        v = "\u5e94\u6536:" + (t.getShould_charge() == null ? Constants.MONEY_ZERO : t.getShould_charge());
                        if (t.getDiscount_money() != null && t.getDiscount_money().doubleValue() > 0.0) {
                            v = String.valueOf(v) + ",\u6298\u6263:" + t.getDiscount_money();
                        }
                        if (t.getPeriod_multi_free() != null && t.getPeriod_multi_free().doubleValue() > 0.0) {
                            v = String.valueOf(v) + ",\u5468\u671f\u4f18\u60e0:" + t.getPeriod_multi_free();
                        }
                        if (t.getAlready_paid() == null || !(t.getAlready_paid().doubleValue() > 0.0)) break;
                        v = String.valueOf(v) + ",\u5176\u4ed6\u652f\u4ed8:" + t.getAlready_paid();
                        break;
                    }
                    if (t.getService_type() == 2 || t.getService_type() == 3) {
                        if (t.getStart_date() == null || t.getEnd_date() == null) break;
                        if (this.df1 == null) {
                            this.df1 = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5");
                        }
                        v = "\u5f00\u59cb:" + this.df1.format(t.getStart_date()) + ",\u7ed3\u675f:" + this.df1.format(t.getEnd_date());
                        break;
                    }
                    if (t.getService_type() != 2 && t.getService_type() != 3 || t.getRecharge_money() == null) break;
                    v = "\u5145\u503c\u505c\u8f66\u8d39:" + t.getRecharge_money() + "\u5143";
                }
            }
            if (v == null) {
                v = "";
            }
            return v;
        }

        @Override
        public String getColumnName(int column) {
            return this.titleHeaders[column];
        }
    }
}

