/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.PicLoadUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ExitRecordDetailDialog
extends MacDialog
implements ActionListener {
    private static final long serialVersionUID = 5944188282441526085L;
    private Dimension mainSize;
    private CarparkPassRecord record;
    private List<JLabel> picLabels;

    public static ExitRecordDetailDialog showDialog(CarparkPassRecord record, Component c, Dimension size, Dimension mainSize, boolean modal) {
        ExitRecordDetailDialog dilog;
        Window rootWidnow = null;
        if (c == null) {
            dilog = new ExitRecordDetailDialog();
        } else {
            Window w = SwingUtil.getWindowForComponent(c);
            dilog = w instanceof Frame ? new ExitRecordDetailDialog((Frame)w, "", modal) : (w instanceof Dialog ? new ExitRecordDetailDialog((Dialog)w, "", modal) : (w instanceof Window ? new ExitRecordDetailDialog(w, "", modal) : new ExitRecordDetailDialog()));
            rootWidnow = w;
        }
        dilog.mainSize = mainSize;
        dilog.record = record;
        dilog.init(size, rootWidnow);
        dilog.setVisible(true);
        return dilog;
    }

    public ExitRecordDetailDialog() {
    }

    public ExitRecordDetailDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public ExitRecordDetailDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public ExitRecordDetailDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    @Override
    public int getTitileBarHeight() {
        return (int)Math.round(this.mainSize.getHeight() * 30.0 / 900.0);
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        try {
            this.showCloseButton(this.getTitileBarHeight());
            this.rootPanel.registerKeyboardAction(this, "vk_esc", KeyStroke.getKeyStroke(27, 0), 2);
            this.init1(body, panelSize);
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)ex.getMessage(), ex);
        }
    }

    protected void init1(JPanel body, Dimension panelSize) {
        int avgWidth;
        body.setLayout(new XYLayout());
        int picSize = 2;
        if (this.record.getCertificate_pic() != null && this.record.getCertificate_pic().length() > 0) {
            ++picSize;
        }
        int marginTop = (int)Math.round(this.mainSize.getHeight() * 5.0 / 768.0);
        int picHeight = (int)Math.round(this.mainSize.getHeight() * 220.0 / 768.0);
        int marginLeft = marginTop;
        int picWidth = (panelSize.width - (picSize + 1) * marginLeft) / picSize;
        int fontSize = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int picInfoLabelHeight = (int)Math.round(this.mainSize.getHeight() * 20.0 / 768.0);
        this.picLabels = new ArrayList<JLabel>(picSize);
        int x = marginLeft;
        int y = marginTop;
        int w = picWidth;
        int h = picHeight;
        Dimension picSS = new Dimension(w, h);
        int i = 0;
        while (i < picSize) {
            JLabel picLabel = new JLabel();
            this.picLabels.add(picLabel);
            body.add((Component)picLabel, new XYConstraints(x, y, w, h));
            JLabel infoLabel = new JLabel();
            infoLabel.setFont(font);
            infoLabel.setHorizontalAlignment(0);
            body.add((Component)infoLabel, new XYConstraints(x, y + h, w, picInfoLabelHeight));
            if (i == 0) {
                infoLabel.setText("\u5165\u573a\u56fe\u7247");
            } else if (i == 1) {
                infoLabel.setText("\u51fa\u573a\u56fe\u7247");
            } else if (i == 2) {
                infoLabel.setText("\u8bc1\u4ef6\u6293\u62cd\u56fe\u7247");
            }
            x += marginLeft + w;
            ++i;
        }
        PicLoadUtil.loadPic(this.picLabels.get(0), this.record.getEnter_host_no(), this.record.getEnter_car_pic(), picSS, this.record.getEnter_plate_pic(), this.mainSize, false);
        PicLoadUtil.loadPic(this.picLabels.get(1), this.record.getExit_host_no(), this.record.getExit_car_pic(), picSS, this.record.getExit_plate_pic(), this.mainSize, false);
        if (picSize == 3) {
            PicLoadUtil.loadPic(this.picLabels.get(2), this.record.getExit_host_no(), this.record.getCertificate_pic(), picSS, null, this.mainSize, false);
        }
        y += h + picInfoLabelHeight;
        int linemarginTop = (int)Math.round(this.mainSize.getHeight() * 5.0 / 768.0);
        int lineHeight = (int)Math.round(this.mainSize.getHeight() * 1.0 / 768.0);
        JPanel linePanel = new JPanel();
        linePanel.setBackground(Color.decode("#C0C0C0"));
        x = marginLeft;
        w = panelSize.width - marginLeft - marginLeft;
        h = lineHeight;
        body.add((Component)linePanel, new XYConstraints(x, y += linemarginTop, w, h));
        int infoMarginTop = (int)Math.round(this.mainSize.getHeight() * 10.0 / 768.0);
        int infoMarginBottom = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int infoTotalHegiht = panelSize.height - (y += h) - infoMarginTop - infoMarginBottom;
        int infoMarginLeft = (int)Math.round(this.mainSize.getWidth() * 15.0 / 1024.0);
        int infoMarginRight = (int)Math.round(this.mainSize.getWidth() * 15.0 / 1024.0);
        int infoWidth = panelSize.width - infoMarginLeft - infoMarginRight;
        int infoCount = 7;
        if (this.record.getArea_level() != null && this.record.getArea_level() == 1) {
            if (this.record.getAlready_paid() != null && this.record.getAlready_paid().doubleValue() > 0.0) {
                ++infoCount;
            }
            if (this.record.getPeriod_multi_start() != null && this.record.getNext_period_multi_cur() != null) {
                ++infoCount;
            }
            if (this.record.getDiscount_times() != null && this.record.getDiscount_times() > 0) {
                ++infoCount;
            }
        }
        int avgHeight = infoTotalHegiht / infoCount;
        x = infoMarginLeft;
        y += infoMarginTop;
        w = infoWidth;
        h = avgHeight;
        w = avgWidth = infoWidth / 3;
        JLabel label = new JLabel("\u5165\u573a\u901a\u9053\uff1a" + (this.record.getEnter_channel_name() == null ? "" : this.record.getEnter_channel_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x, y, w, h));
        label = new JLabel("\u5165\u573a\u503c\u73ed\u5458\uff1a" + (this.record.getEnter_duty_user_name() == null ? "" : this.record.getEnter_duty_user_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        label = new JLabel("\u5165\u573a\u5c97\u4ead/\u7535\u8111\uff1a" + (this.record.getEnter_host_name() == null ? "" : this.record.getEnter_host_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        x = infoMarginLeft;
        JLabel enterPlateLabel = new JLabel("\u5165\u573a\u8f66\u724c\uff1a" + (this.record.getEnter_plate() == null ? "" : this.record.getEnter_plate()));
        enterPlateLabel.setFont(font);
        body.add((Component)enterPlateLabel, new XYConstraints(x, y += h, w, h));
        label = new JLabel("\u5165\u573a\u65f6\u95f4\uff1a" + (this.record.getEnter_time() == null ? "" : df.format(this.record.getEnter_time())));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        label = new JLabel(this.getEnterPassInfo(enterPlateLabel));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        x = infoMarginLeft;
        label = new JLabel("\u51fa\u573a\u901a\u9053\uff1a" + (this.record.getExit_channel_name() == null ? "" : this.record.getExit_channel_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x, y += h, w, h));
        label = new JLabel("\u51fa\u573a\u503c\u73ed\u5458\uff1a" + (this.record.getExit_duty_user_name() == null ? "" : this.record.getExit_duty_user_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        label = new JLabel("\u51fa\u573a\u5c97\u4ead/\u7535\u8111\uff1a" + (this.record.getExit_host_name() == null ? "" : this.record.getExit_host_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        x = infoMarginLeft;
        JLabel exitPlateLabel = new JLabel("\u51fa\u573a\u8f66\u724c\uff1a" + (this.record.getExit_plate() == null ? "" : this.record.getExit_plate()));
        exitPlateLabel.setFont(font);
        body.add((Component)exitPlateLabel, new XYConstraints(x, y += h, w, h));
        label = new JLabel("\u51fa\u573a\u65f6\u95f4\uff1a" + (this.record.getExit_time() == null ? "" : df.format(this.record.getExit_time())));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        label = new JLabel(this.getExitPassInfo(exitPlateLabel));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        x = infoMarginLeft;
        label = new JLabel("\u901a\u884c\u573a\u533a\uff1a" + (this.record.getArea_name() == null ? "" : this.record.getArea_name()));
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x, y += h, w, h));
        label = new JLabel("\u505c\u8f66\u65f6\u957f\uff1a" + this.getParkingTimeLen());
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        label = new JLabel(this.getExceptionInfo());
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x += w, y, w, h));
        x = infoMarginLeft;
        w = infoWidth;
        label = new JLabel(this.getCarInfo());
        label.setFont(font);
        body.add((Component)label, new XYConstraints(x, y += h, w, h));
        if (this.record.getArea_level() != null && this.record.getArea_level() == 1) {
            y += h;
            x = infoMarginLeft;
            w = infoWidth;
            label = new JLabel();
            label.setText(this.getChageInfo(label));
            label.setFont(font);
            body.add((Component)label, new XYConstraints(x, y, w, h));
            if (this.record.getPeriod_multi_start() != null && this.record.getNext_period_multi_cur() != null) {
                y += h;
                x = infoMarginLeft;
                w = infoWidth;
                label = new JLabel();
                label.setText(this.getPeriodChageInfo(label));
                label.setFont(font);
                body.add((Component)label, new XYConstraints(x, y, w, h));
            }
            JLabel setMutiDiscountLabel = null;
            JLabel setMutiSelfPayLabel = null;
            if (this.record.getDiscount_times() != null && this.record.getDiscount_times() > 0) {
                x = infoMarginLeft;
                w = infoWidth;
                label = new JLabel();
                label.setFont(font);
                body.add((Component)label, new XYConstraints(x, y += h, w, h));
                if (this.record.getDiscount_times() == 1) {
                    label.setText(this.getDicountInfo(label));
                } else {
                    setMutiDiscountLabel = label;
                }
            }
            if (this.record.getAlready_paid() != null && this.record.getAlready_paid().doubleValue() > 0.0) {
                x = infoMarginLeft;
                w = infoWidth;
                label = new JLabel();
                label.setFont(font);
                body.add((Component)label, new XYConstraints(x, y += h, w, h));
                if (this.record.getAlready_paid_times() != null && this.record.getAlready_paid_times() == 1) {
                    label.setText(this.getSelfPayInfo(label));
                } else {
                    setMutiSelfPayLabel = label;
                }
            }
            this.setMutiInfo(setMutiDiscountLabel, setMutiSelfPayLabel);
        }
    }

    private void setMutiInfo(final JLabel setMutiDiscountLabel, final JLabel setMutiSelfPayLabel) {
        if (setMutiDiscountLabel == null && setMutiSelfPayLabel == null) {
            return;
        }
        if (this.record.getEnter_time() == null || this.record.getPassport_number() == null || this.record.getPassport_number().length() == 0) {
            return;
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SearchParam sp;
                    List discouList0 = null;
                    List transactionList0 = null;
                    CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    Integer projectId = ServiceUtil.getServiceContext().getProjectId();
                    Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
                    if (setMutiDiscountLabel != null) {
                        Calendar cl = Calendar.getInstance();
                        cl.set(2018, 0, 1, 0, 0, 0);
                        cl.set(14, 0);
                        int minute = (int)TimeUnit.MILLISECONDS.toMinutes(ExitRecordDetailDialog.this.record.getEnter_time().getTime() - cl.getTimeInMillis());
                        sp = new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId).addEQ("passport_number", (Object)ExitRecordDetailDialog.this.record.getPassport_number()).addLT("enter_time", (Object)ExitRecordDetailDialog.this.record.getEnter_time()).addEQ("discount_method", (Object)3).addGT("discount_value", (Object)minute);
                        sp.setOrerbySql("discount_time");
                        if (ExitRecordDetailDialog.this.record.getMedium_type() != null) {
                            sp.addEQ("medium_type", (Object)ExitRecordDetailDialog.this.record.getMedium_type());
                        }
                        discouList0 = daoService.selectList(sp, CarparkDiscountRecord.class, null);
                        sp = new SearchParam();
                        sp.addEQ("passport_number", (Object)ExitRecordDetailDialog.this.record.getPassport_number());
                        if (ExitRecordDetailDialog.this.record.getMedium_type() != null) {
                            sp.addEQ("medium_type", (Object)ExitRecordDetailDialog.this.record.getMedium_type());
                        }
                        sp.addEQ("enter_time", (Object)ExitRecordDetailDialog.this.record.getEnter_time()).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
                        sp.setOrerbySql("discount_time");
                        List l = daoService.selectList(sp, CarparkDiscountRecord.class, null);
                        if (l != null && !l.isEmpty()) {
                            if (discouList0 == null || discouList0.isEmpty()) {
                                discouList0 = l;
                            } else {
                                discouList0.addAll(l);
                            }
                        }
                    }
                    if (setMutiSelfPayLabel != null) {
                        sp = new SearchParam();
                        sp.addEQ("passport_number", (Object)ExitRecordDetailDialog.this.record.getPassport_number());
                        if (ExitRecordDetailDialog.this.record.getMedium_type() != null) {
                            sp.addEQ("medium_type", (Object)ExitRecordDetailDialog.this.record.getMedium_type());
                        }
                        sp.addEQ("enter_time", (Object)ExitRecordDetailDialog.this.record.getEnter_time()).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
                        sp.addEQ("service_type", (Object)0);
                        sp.setOrerbySql("tran_time");
                        transactionList0 = daoService.selectList(sp, CarparkTransaction.class, null);
                    }
                    final List discouList = discouList0;
                    final List transactionList = transactionList0;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExitRecordDetailDialog.this.setDiscountList(setMutiDiscountLabel, discouList);
                            ExitRecordDetailDialog.this.setSelfPayList(setMutiSelfPayLabel, transactionList);
                        }
                    });
                }
                catch (Exception ex) {
                    GuiLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private void setDiscountList(JLabel label, List<CarparkDiscountRecord> discountList) {
        if (label == null || discountList == null || discountList.isEmpty()) {
            return;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        char x = '\u3001';
        for (CarparkDiscountRecord d : discountList) {
            if (sbr.length() > 0) {
                sbr.append(x);
            }
            sbr.append('[');
            sbr.append(d.getDiscount_project_name());
            if (d.getDiscount_method() != null && d.getDiscount_value() != null) {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                sbr.append('(').append(appService.getDiscountValueDes(d.getDiscount_method(), d.getDiscount_value())).append(')');
            }
            if (d.getDiscount_merchant_no() != null && d.getDiscount_merchant_no().length() > 0) {
                if ("0".equals(d.getDiscount_merchant_no()) && "\u8f66\u573a\u7ba1\u7406".equals(d.getDiscount_merchant_name())) {
                    if (d.getDiscount_source() != null) {
                        if (d.getDiscount_source() == 1) {
                            sbr.append(z).append("\u7ba1\u7406\u5904\u6253\u6298");
                            if (d.getDiscount_time() != null) {
                                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(d.getDiscount_time()));
                            }
                        } else if (d.getDiscount_source() == 0) {
                            sbr.append(z).append("\u79bb\u573a\u5c97\u4ead\u5904\u6253\u6298");
                        } else {
                            sbr.append(z).append("\u7ba1\u7406\u5458\u4e91\u7aef\u6253\u6298");
                            if (d.getDiscount_time() != null) {
                                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(d.getDiscount_time()));
                            }
                        }
                    } else {
                        sbr.append(z).append("\u8f66\u573a\u7ba1\u7406");
                    }
                } else {
                    sbr.append(z).append(d.getDiscount_merchant_name()).append("\u6253\u6298");
                    if (d.getDiscount_time() != null) {
                        sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(d.getDiscount_time()));
                    }
                }
            }
            sbr.append(']');
        }
        String v = sbr.toString();
        String tooTip = v.replaceAll(String.valueOf(x), "<br>");
        label.setToolTipText("<html>\u6298\u6263\u660e\u7ec6\uff1a<br>" + tooTip + "</html>");
        label.setText("\u6298\u6263\u660e\u7ec6\uff1a" + v);
    }

    private void setSelfPayList(JLabel label, List<CarparkTransaction> transactionList) {
        if (label == null || transactionList == null || transactionList.isEmpty()) {
            return;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        char x = '\u3001';
        for (CarparkTransaction t : transactionList) {
            if (t.getPay_method() == 0 && t.getPay_scene() == 0 || t.getPay_method() == 1 && t.getPay_scene() == 0) continue;
            if (sbr.length() > 0) {
                sbr.append(x);
            }
            sbr.append('[');
            String payMethod = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(t.getPay_method());
            String payScene = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(t.getPay_scene());
            String payOrg = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(t.getCharge_org());
            sbr.append(payMethod).append('\uff1a').append(t.getTran_money());
            if (payScene != null && payScene.length() > 0) {
                sbr.append(z).append(payScene);
            }
            if (payOrg != null && payOrg.length() > 0) {
                sbr.append(z).append(payOrg);
            }
            if (t.getTran_time() != null) {
                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(t.getTran_time()));
            }
            sbr.append(']');
        }
        String v = sbr.toString();
        String tooTip = v.replaceAll(String.valueOf(x), "<br>");
        label.setToolTipText("<html>\u573a\u5185\u5df2\u652f\u4ed8\u660e\u7ec6\uff1a<br>" + tooTip + "</html>");
        label.setText("\u573a\u5185\u5df2\u652f\u4ed8\u660e\u7ec6\uff1a" + v);
    }

    private String getSelfPayInfo(JLabel label) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        sbr.append("\u573a\u5185\u5df2\u652f\u4ed8\u660e\u7ec6\uff1a").append('[');
        String payMethod = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(this.record.getAlready_paid_method());
        String payScene = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(this.record.getAlready_paid_scene());
        String payOrg = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(this.record.getAlready_paid_charge_org());
        sbr.append(payMethod).append('\uff1a').append(this.record.getAlready_paid());
        if (payScene != null && payScene.length() > 0) {
            sbr.append(z).append(payScene);
        }
        if (payOrg != null && payOrg.length() > 0) {
            sbr.append(z).append(payOrg);
        }
        if (this.record.getAlready_paid_time() != null) {
            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(this.record.getAlready_paid_time()));
        }
        sbr.append(']');
        return sbr.toString();
    }

    private String getDicountInfo(JLabel label) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        sbr.append("\u6298\u6263\u660e\u7ec6\uff1a").append('[');
        sbr.append(this.record.getDiscount_project_name());
        if (this.record.getDiscount_method() != null && this.record.getDiscount_value() != null) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            sbr.append('(').append(appService.getDiscountValueDes(this.record.getDiscount_method(), this.record.getDiscount_value())).append(')');
        }
        if (this.record.getDiscount_merchant_no() != null && this.record.getDiscount_merchant_no().length() > 0) {
            if ("0".equals(this.record.getDiscount_merchant_no()) && "\u8f66\u573a\u7ba1\u7406".equals(this.record.getDiscount_merchant_name())) {
                if (this.record.getDiscount_source() != null) {
                    if (this.record.getDiscount_source() == 1) {
                        sbr.append(z).append("\u7ba1\u7406\u5904\u6253\u6298");
                        if (this.record.getDiscount_time() != null) {
                            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(this.record.getDiscount_time()));
                        }
                    } else if (this.record.getDiscount_source() == 0) {
                        sbr.append(z).append("\u79bb\u573a\u5c97\u4ead\u5904\u6253\u6298");
                    } else {
                        sbr.append(z).append("\u7ba1\u7406\u5458\u4e91\u7aef\u6253\u6298");
                        if (this.record.getDiscount_time() != null) {
                            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(this.record.getDiscount_time()));
                        }
                    }
                } else {
                    sbr.append(z).append("\u8f66\u573a\u7ba1\u7406");
                }
            } else {
                String vd = this.record.getDiscount_merchant_name();
                if (vd == null) {
                    vd = "";
                }
                sbr.append(z).append(vd).append("\u6253\u6298");
                if (this.record.getDiscount_time() != null) {
                    sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm").format(this.record.getDiscount_time()));
                }
            }
        }
        sbr.append(']');
        return sbr.toString();
    }

    private String getPeriodChageInfo(JLabel label) {
        if (this.record.getPeriod_multi_start() == null || this.record.getNext_period_multi_start() == null) {
            return null;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\u3001';
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm");
        sbr.append("\u5468\u671f\u5f00\u59cb\uff1a").append(df.format(this.record.getPeriod_multi_start()));
        sbr.append(z).append("\u4e4b\u524d\u5df2\u6536\uff1a").append(this.record.getPeriod_multi_received() == null ? Constants.MONEY_ZERO : this.record.getPeriod_multi_received());
        if (this.record.getPeriod_multi_start().getTime() != this.record.getNext_period_multi_start().getTime()) {
            sbr.append(z).append("\u672c\u6b21\u4f18\u60e0\uff1a").append(this.record.getPeriod_multi_free() == null ? Constants.MONEY_ZERO : this.record.getPeriod_multi_free());
            sbr.append(z).append("\u65b0\u5468\u671f\u5f00\u59cb\uff1a").append(df.format(this.record.getNext_period_multi_start()));
            sbr.append(z).append("\u65b0\u5468\u671f\u7d2f\u8ba1\uff1a").append(this.record.getNext_period_multi_cur() == null ? Constants.MONEY_ZERO : this.record.getNext_period_multi_cur());
        } else {
            sbr.append(z).append("\u672c\u6b21\u7d2f\u8ba1\uff1a").append(this.record.getNext_period_multi_cur() == null ? Constants.MONEY_ZERO : this.record.getNext_period_multi_cur());
            sbr.append(z).append("\u672c\u6b21\u4f18\u60e0\uff1a").append(this.record.getPeriod_multi_free() == null ? Constants.MONEY_ZERO : this.record.getPeriod_multi_free());
        }
        String v = sbr.toString();
        String tooTip = v.replaceAll(String.valueOf(z), "<br>");
        label.setToolTipText("<html>\u5468\u671f\u5185\u591a\u6b21\u51fa\u5165\u7d2f\u8ba1\u8ba1\u8d39\u660e\u7ec6\uff1a<br>" + tooTip + "</html>");
        return v;
    }

    private String getChageInfo(JLabel label) {
        if (ServiceUtil.isEnableGuiFee()) {
            StringBuilder sbr = new StringBuilder(128);
            char z = '\u3001';
            sbr.append("\u51fa\u573a\u5e94\u6536\uff1a");
            BigDecimal should = this.record.getExit_should_charge();
            if (should == null) {
                should = Constants.MONEY_ZERO;
            }
            sbr.append(should);
            BigDecimal f = this.record.getPeriod_multi_free();
            if (f != null && f.doubleValue() > 0.0) {
                sbr.append(z).append("\u5468\u671f\u4f18\u60e0\uff1a").append(f);
            } else if (this.record.getPeriod_multi_start() != null && this.record.getNext_period_multi_cur() != null) {
                sbr.append(z).append("\u5468\u671f\u4f18\u60e0\uff1a0.00");
            }
            if (this.record.getDiscount_money() != null && this.record.getDiscount_money().doubleValue() > 0.0) {
                sbr.append(z).append("\u6298\u6263\u51cf\u514d\uff1a").append(this.record.getDiscount_money());
            }
            boolean ax = false;
            if (this.record.getAlready_paid() != null && this.record.getAlready_paid().doubleValue() > 0.0) {
                sbr.append(z).append("\u573a\u5185\u5df2\u4ed8\uff1a").append(this.record.getAlready_paid());
                ax = true;
            }
            if (this.record.getCash_pay() != null && this.record.getCash_pay().doubleValue() > 0.0) {
                sbr.append(z).append("\u51fa\u53e3\u73b0\u91d1\uff1a").append(this.record.getCash_pay());
                ax = true;
            }
            if (this.record.getDeduct_money() != null && this.record.getDeduct_money().doubleValue() > 0.0) {
                sbr.append(z).append("\u51fa\u53e3\u6263\u8d39\uff1a").append(this.record.getDeduct_money());
                ax = true;
            }
            if (!ax) {
                sbr.append(z).append("\u5b9e\u6536\u91d1\u989d\uff1a0.00");
            }
            if (this.record.getEnter_time() != null) {
                if (this.record.getExit_fee_time_length() != null) {
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    sbr.append("\uff1b").append("\u8ba1\u8d39\u65f6\u957f\uff1a");
                    sbr.append(appService.getTimeLenDes(this.record.getExit_fee_time_length()));
                    if (this.record.getExit_fee_start_time() != null && this.record.getExit_fee_start_time().getTime() != this.record.getEnter_time().getTime()) {
                        sbr.append(z).append("\u8ba1\u8d39\u5f00\u59cb\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(this.record.getExit_fee_start_time()));
                        if (this.record.getTake_plate_number() != null && this.record.getTake_plate_number().length() > 0) {
                            sbr.append("(").append(this.record.getTake_plate_number()).append(")");
                        }
                    }
                }
                if (this.record.getTake_plate_number() != null && this.record.getTake_plate_number().length() > 0 && this.record.getTake_enter_time() != null) {
                    StringBuilder b1 = new StringBuilder(128);
                    b1.append("\u4ece\u8f66\u724c\u3010").append(this.record.getTake_plate_number());
                    b1.append("\u3011\u7684\u5165\u573a\u65f6\u95f4\u3010").append(new SimpleDateFormat("yy/MM/dd HH:mm").format(this.record.getTake_enter_time()));
                    b1.append("\u3011\u5f00\u59cb\u5360\u7528\u4e34\u505c\u8f66\u4f4d\uff0c\u5e76\u5f00\u59cb\u8ba1\u8d39\u3002");
                    label.setToolTipText(b1.toString());
                }
            }
            return sbr.toString();
        }
        label.setToolTipText(null);
        return "";
    }

    private String getCarInfo() {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\u3001';
        sbr.append("\u8f66\u8f86\u4fe1\u606f\uff1a");
        sbr.append(this.record.getPassport_type_name());
        if (this.record.getExit_car_type_name() != null && this.record.getExit_car_type_name().length() > 0) {
            sbr.append(z).append(this.record.getExit_car_type_name());
        }
        if (this.record.getPlate_color() != null && this.record.getPlate_color().length() > 0) {
            sbr.append(z).append(this.record.getPlate_color()).append("\u724c\u8f66");
        }
        if (this.record.getExit_valid_date() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            sbr.append(z).append("\u51fa\u573a\u6709\u6548\u671f\uff1a").append(df.format(this.record.getExit_valid_date()));
        }
        if (this.record.getPass_type() != null && this.record.getPass_type() == 1 && this.record.getExit_balance() != null) {
            sbr.append(z).append("\u51fa\u573a\u65f6\u4f59\u989d\uff1a").append(this.record.getExit_balance());
        }
        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("car_owner_name", this.record.getCar_owner_name());
        String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("address", this.record.getCar_owner_addr());
        String v = "";
        Integer pass_state_value = this.record.getPass_state_value();
        if (pass_state_value != null && pass_state_value > 0) {
            if (pass_state_value == 6) {
                v = "\u9ed1\u540d\u5355\u8f66";
            } else if (pass_state_value == 7) {
                v = "\u672a\u542f\u7528";
            } else if (pass_state_value == 8) {
                v = "\u5df2\u505c\u7528";
            } else if (pass_state_value == 4) {
                v = "\u5df2\u8fc7\u671f";
            } else if (pass_state_value == 1) {
                v = "\u65e0\u6743\u9650";
            } else if (pass_state_value == 9) {
                v = "\u5339\u914d\u4e0a\u4e00\u5165\u573a\u8bb0\u5f55";
            }
        }
        if (v != null && v.length() > 0) {
            sbr.append(z);
            sbr.append(v);
        }
        if (car_owner_name != null && car_owner_name.length() > 0) {
            sbr.append(z);
            sbr.append("\u8f66\u4e3b\uff1a").append(car_owner_name);
            if (car_owner_addr != null && car_owner_addr.length() > 0) {
                sbr.append('[').append(car_owner_addr).append(']');
            }
        }
        if (this.record.getCar_color() != null && this.record.getCar_color().length() > 0) {
            sbr.append(z);
            if (!this.record.getCar_color().endsWith("\u8272")) {
                sbr.append(String.valueOf(this.record.getCar_color()) + "\u8272");
            } else {
                sbr.append(this.record.getCar_color());
            }
        }
        if (this.record.getCar_logo() != null && this.record.getCar_logo().length() > 0) {
            if (this.record.getCar_color() == null || this.record.getCar_color().length() == 0) {
                sbr.append(z);
            }
            sbr.append(this.record.getCar_logo());
        }
        if (this.record.getExit_time() != null && this.record.getExit_remark() != null && this.record.getExit_remark().length() > 0) {
            sbr.append(z).append(this.record.getExit_remark());
        }
        return sbr.toString();
    }

    private String getExceptionInfo() {
        String exitPlate;
        String exitEqplate;
        Integer lanState = this.record.getExit_lan_state();
        if (lanState != null) {
            if (lanState == 1) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u8f66\u724c\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf";
            }
            if (lanState == 2) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5";
            }
            if (lanState == 3) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u5b58\u5728\u79bb\u7ebf\u5c97\u4ead\u4e3b\u673a";
            }
        }
        if ((exitEqplate = this.record.getExit_reg_plate()) == null || exitEqplate.length() == 0) {
            exitEqplate = this.record.getExit_obu_plate();
        }
        if ((exitPlate = this.record.getExit_plate()) == null) {
            exitPlate = "";
        }
        if (exitEqplate != null && exitEqplate.length() > 0 && !exitEqplate.equals(exitPlate)) {
            return "\u51fa\u53e3\u8bc6\u522b\uff1a" + exitEqplate + ",\u4e0e\u51fa\u573a\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        if (this.record.getEnter_time() == null) {
            return "\u8bb0\u5f55\u5f02\u5e38\uff1a\u65e0\u5165\u573a\u8bb0\u5f55";
        }
        String enterPlate = this.record.getEnter_plate();
        if (enterPlate == null) {
            enterPlate = "";
        }
        if (!enterPlate.equals(exitPlate)) {
            return "\u8bb0\u5f55\u5f02\u5e38\uff1a\u51fa\u5165\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        String enterEqplate = this.record.getEnter_reg_plate();
        if (enterEqplate == null || enterEqplate.length() == 0) {
            enterEqplate = this.record.getEnter_obu_plate();
        }
        if (enterEqplate != null && enterEqplate.length() > 0 && !enterEqplate.equals(enterPlate)) {
            return "\u5165\u53e3\u8bc6\u522b\uff1a" + enterEqplate + ",\u4e0e\u5165\u573a\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        lanState = this.record.getEnter_lan_state();
        if (lanState != null) {
            if (lanState == 1) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u8f66\u724c\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf";
            }
            if (lanState == 2) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5";
            }
            if (lanState == 3) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u5b58\u5728\u79bb\u7ebf\u5c97\u4ead\u4e3b\u673a";
            }
        }
        return "\u51fa\u5165\u7f51\u7edc\uff1a\u6b63\u5e38";
    }

    private String getParkingTimeLen() {
        if (this.record.getEnter_time() == null) {
            return "\u65e0\u5165\u573a\u8bb0\u5f55";
        }
        if (this.record.getExit_time() == null) {
            return "";
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(this.record.getExit_time().getTime() - this.record.getEnter_time().getTime());
        return appService.getTimeLenSecDes(sec);
    }

    private String getExitPassInfo(JLabel exitPlateLabel) {
        if (this.record.getExit_time() == null) {
            return null;
        }
        if (this.record.getExit_plate() == null || this.record.getExit_plate().length() == 0) {
            return "\u51fa\u573a\u653e\u884c\uff1a\u975e\u8f66\u724c\u653e\u884c";
        }
        Integer exit_plate_source = this.record.getExit_plate_source();
        if (exit_plate_source != null) {
            if (exit_plate_source == 0) {
                return "\u51fa\u573a\u653e\u884c\uff1a\u8f66\u724c\u8bc6\u522b";
            }
            if (exit_plate_source == 1) {
                return "\u51fa\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (exit_plate_source == 2) {
                String v = exitPlateLabel.getText();
                v = String.valueOf(v) + "[\u4eba\u5de5\u4fee\u6539]";
                exitPlateLabel.setText(v);
                String exit_reg_plate = this.record.getExit_reg_plate();
                if (exit_reg_plate != null && exit_reg_plate.length() > 0) {
                    return "\u51fa\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + exit_reg_plate;
                }
                String exit_obu_plate = this.record.getExit_obu_plate();
                if (exit_obu_plate != null && exit_obu_plate.length() > 0) {
                    return "\u51fa\u573aETC\u8bc6\u522b\uff1a" + exit_obu_plate;
                }
                return "\u51fa\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (exit_plate_source == 3) {
                return "\u51fa\u573a\u653e\u884c\uff1aETC\u8bc6\u522b";
            }
            if (exit_plate_source == 4) {
                String v = exitPlateLabel.getText();
                v = String.valueOf(v) + "[\u6a21\u7cca\u5339\u914d]";
                exitPlateLabel.setText(v);
                String exit_reg_plate = this.record.getExit_reg_plate();
                if (exit_reg_plate != null && exit_reg_plate.length() > 0) {
                    return "\u51fa\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + exit_reg_plate;
                }
                String exit_obu_plate = this.record.getExit_obu_plate();
                if (exit_obu_plate != null && exit_obu_plate.length() > 0) {
                    return "\u51fa\u573aETC\u8bc6\u522b\uff1a" + exit_obu_plate;
                }
            }
        }
        return null;
    }

    private String getEnterPassInfo(JLabel enterPlateLabel) {
        if (this.record.getEnter_time() == null) {
            return "\u5165\u573a\u653e\u884c\uff1a\u8f66\u672a\u5165\u573a";
        }
        if (this.record.getEnter_plate() == null || this.record.getEnter_plate().length() == 0) {
            return "\u5165\u573a\u653e\u884c\uff1a\u975e\u8f66\u724c\u653e\u884c";
        }
        Integer enter_plate_source = this.record.getEnter_plate_source();
        if (enter_plate_source != null) {
            if (enter_plate_source == 0) {
                return "\u5165\u573a\u653e\u884c\uff1a\u8f66\u724c\u8bc6\u522b";
            }
            if (enter_plate_source == 1) {
                return "\u5165\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (enter_plate_source == 2) {
                String v = enterPlateLabel.getText();
                v = this.record.getEnter_plate_modify_user_name() != null && this.record.getEnter_plate_modify_user_name().length() > 0 ? String.valueOf(v) + "[" + this.record.getEnter_plate_modify_user_name() + "\u4fee\u6539]" : String.valueOf(v) + "[\u4eba\u5de5\u4fee\u6539]";
                enterPlateLabel.setText(v);
                String enter_reg_plate = this.record.getEnter_reg_plate();
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    return "\u5165\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                }
                String enter_obu_plate = this.record.getEnter_obu_plate();
                if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                    return "\u5165\u573aETC\u8bc6\u522b\uff1a" + enter_obu_plate;
                }
                return "\u5165\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (enter_plate_source == 3) {
                return "\u5165\u573a\u653e\u884c\uff1aETC\u8bc6\u522b";
            }
            if (enter_plate_source == 4) {
                String v = enterPlateLabel.getText();
                v = String.valueOf(v) + "[\u6a21\u7cca\u5339\u914d]";
                enterPlateLabel.setText(v);
                String enter_reg_plate = this.record.getEnter_reg_plate();
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    return "\u5165\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                }
                String enter_obu_plate = this.record.getEnter_obu_plate();
                if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                    return "\u5165\u573aETC\u8bc6\u522b\uff1a" + enter_obu_plate;
                }
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("vk_esc".equals(cmd)) {
            this.dispose();
        }
    }
}

