/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.DateTimePicker;
import com.wovoe.carpark.gui.DialogDisponseListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.ExitRecordDetailDialog;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.MainTabPane;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class ExitRecordSearchTabPane
extends JPanel
implements MainTabPane,
MouseListener,
ActionListener,
GotoPageHandler {
    private static final long serialVersionUID = 2747072927833344044L;
    private Dimension mainSize;
    private JTextField date1Field;
    private JTextField date2Field;
    private String queryDateFormat = "yy/MM/dd HH:mm:ss";
    private JComboBox<ComboBoxEntry<Integer>> recordTypeSelect;
    private JComboBox<ComboBoxEntry<String>> arrSelect;
    private JTextField attrTextField;
    private JComboBox<ComboBoxEntry<String>> areaSelect;
    private JComboBox<ComboBoxEntry<String>> passportTypeSelect;
    private JComboBox<ComboBoxEntry<String>> carTypeSelect;
    private JComboBox<ComboBoxEntry<String>> exitChannelSelect;
    private JComboBox<ComboBoxEntry<String>> userSelect;
    private JComboBox<ComboBoxEntry<String>> moneyRangeSelect;
    private JComboBox<ComboBoxEntry<String>> discountSelect;
    private JTextField moneyRange1Field;
    private JTextField moneyRange2Field;
    private JButton searchButton;
    private JTable eqTable;
    private JScrollPane resultTablePanel;
    private PaginationPanel pagePanel;
    private JLabel totalInfoLabel;
    private static int recordPageSize = 10;
    private volatile boolean loadFirst = false;
    private volatile boolean selected = false;
    private volatile long tableRowDbClickMills;
    private DateTimePicker datePicker1;
    private DateTimePicker datePicker2;
    private ConcurrentHashMap<Object, JDialog> detailDialogMap = new ConcurrentHashMap();

    @Override
    public void init(Dimension size, Dimension rootSize) {
        String v;
        int label2Weidht;
        this.mainSize = rootSize;
        this.setLayout(new XYLayout());
        Color cl = Color.decode("#222222");
        int fontSize = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int searchTWidth = (int)Math.round(this.mainSize.getWidth() * 70.0 / 1280.0);
        int searchHeight = (int)Math.round(this.mainSize.getHeight() * 26.0 / 768.0);
        int searchMarginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int grap = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        int dateWidth = (int)Math.round(this.mainSize.getWidth() * 130.0 / 1024.0);
        int x = 0;
        int y = searchMarginTop;
        int w = searchTWidth;
        int h = searchHeight;
        JLabel lable = new JLabel("\u79bb\u573a\u65f6\u95f4");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.date1Field = new JTextField();
        this.date1Field.setFont(font);
        this.date1Field.setEditable(false);
        this.date1Field.addMouseListener(this);
        this.add((Component)this.date1Field, new XYConstraints(x, y, w, h));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.date1Field.setText(new SimpleDateFormat(this.queryDateFormat).format(calendar.getTime()));
        x += w;
        w = label2Weidht = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        JLabel labl2 = new JLabel("\u81f3");
        labl2.setHorizontalAlignment(0);
        labl2.setFont(font);
        labl2.setForeground(cl);
        this.add((Component)labl2, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        this.date2Field = new JTextField();
        this.date2Field.setFont(font);
        this.date2Field.setEditable(false);
        this.date2Field.addMouseListener(this);
        this.add((Component)this.date2Field, new XYConstraints(x, y, w, h));
        this.date2Field.setText(new SimpleDateFormat(this.queryDateFormat).format(now));
        int timeEndWidth = x += w;
        int remainWith = size.width - timeEndWidth - grap;
        int avgTextWidth = (remainWith - 2 * searchTWidth - grap) / 2;
        w = searchTWidth;
        lable = new JLabel("\u8bb0\u5f55\u7c7b\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x += grap, y, w, h));
        Vector<ComboBoxEntry<Object>> reacordstate = new Vector<ComboBoxEntry<Object>>();
        reacordstate.add(new ComboBoxEntry<Object>(null, "\u5168\u90e8\u7c7b\u578b"));
        reacordstate.add(new ComboBoxEntry<Integer>(1, "\u65e0\u5165\u573a\u8bb0\u5f55"));
        reacordstate.add(new ComboBoxEntry<Integer>(2, "\u51fa\u5165\u8f66\u724c\u4e0d\u4e00\u81f4 "));
        reacordstate.add(new ComboBoxEntry<Integer>(3, "\u5165\u573a\u4eba\u5de5\u653e\u884c"));
        reacordstate.add(new ComboBoxEntry<Integer>(4, "\u4fee\u6539\u5165\u573a\u8f66\u724c"));
        reacordstate.add(new ComboBoxEntry<Integer>(5, "\u5165\u573a\u6a21\u7cca\u5339\u914d"));
        reacordstate.add(new ComboBoxEntry<Integer>(6, "\u51fa\u573a\u4eba\u5de5\u653e\u884c"));
        reacordstate.add(new ComboBoxEntry<Integer>(7, "\u51fa\u573a\u4fee\u6539\u8f66\u724c"));
        reacordstate.add(new ComboBoxEntry<Integer>(8, "\u51fa\u573a\u6a21\u7cca\u5339\u914d"));
        reacordstate.add(new ComboBoxEntry<Integer>(9, "\u51fa\u53e3\u8bc1\u4ef6\u6293\u62cd"));
        this.recordTypeSelect = new JComboBox(reacordstate);
        this.recordTypeSelect.setBackground(Color.WHITE);
        this.recordTypeSelect.setFont(font);
        this.recordTypeSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.recordTypeSelect, new XYConstraints(x, y, w, h));
        int searchAttrWidth = (int)Math.round(this.mainSize.getWidth() * 110.0 / 1280.0);
        Vector<ComboBoxEntry<String>> arrt = new Vector<ComboBoxEntry<String>>();
        arrt.add(new ComboBoxEntry<String>("exit_plate", "\u79bb\u573a\u8f66\u724c"));
        arrt.add(new ComboBoxEntry<String>("car_owner_addr", "\u8f66\u4e3b\u4f4f\u5740"));
        arrt.add(new ComboBoxEntry<String>("car_owner_name", "\u8f66\u4e3b\u59d3\u540d"));
        this.arrSelect = new JComboBox(arrt);
        this.arrSelect.setBackground(Color.WHITE);
        this.arrSelect.setFont(font);
        this.arrSelect.addActionListener(this);
        x += w + grap;
        w = searchAttrWidth;
        this.add(this.arrSelect, new XYConstraints(x, y, w, h));
        this.attrTextField = new JTextField();
        this.attrTextField.setFont(font);
        this.attrTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (ExitRecordSearchTabPane.this.arrSelect.getSelectedIndex() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExitRecordSearchTabPane.this.getPlate();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        x += w;
        w = avgTextWidth - searchAttrWidth + searchTWidth;
        this.add((Component)this.attrTextField, new XYConstraints(x, y, w, h));
        int leftAvgWidth = (timeEndWidth - 2 * searchTWidth - grap) / 2;
        int maginTop = (int)Math.round(this.mainSize.getHeight() * 8.0 / 768.0);
        y += h + maginTop;
        x = 0;
        w = searchTWidth;
        lable = new JLabel("\u79bb\u573a\u573a\u533a");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        Vector<ComboBoxEntry<String>> areaList = new Vector<ComboBoxEntry<String>>();
        areaList.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        if (areaMap != null) {
            for (CarparkArea area : areaMap.values()) {
                areaList.add(new ComboBoxEntry<String>(area.getArea_no(), area.getArea_name()));
            }
        }
        this.areaSelect = new JComboBox(areaList);
        this.areaSelect.setBackground(Color.WHITE);
        this.areaSelect.setFont(font);
        this.areaSelect.addActionListener(this);
        x += w;
        w = leftAvgWidth;
        this.add(this.areaSelect, new XYConstraints(x, y, w, h));
        x += w + (int)Math.round(this.mainSize.getWidth() * 15.0 / 1024.0);
        w = searchTWidth / 2;
        lable = new JLabel("\u901a\u9053");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> channelList = new Vector<ComboBoxEntry<String>>();
        channelList.add(new ComboBoxEntry<String>("", "\u6240\u6709\u79bb\u573a\u901a\u9053"));
        Map<String, ChannelArea> channalAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        if (channelMap != null && !channelMap.isEmpty()) {
            for (CarparkChannel ch : channelMap.values()) {
                ChannelArea cha = channalAreaMap.get(ch.getChannel_no());
                if (cha == null || cha.getExitAreas() == null || cha.getExitAreas().isEmpty()) continue;
                channelList.add(new ComboBoxEntry<String>(ch.getChannel_no(), ch.getChannel_name()));
            }
        }
        this.exitChannelSelect = new JComboBox(channelList);
        this.exitChannelSelect.setBackground(Color.WHITE);
        this.exitChannelSelect.setFont(font);
        this.exitChannelSelect.addActionListener(this);
        x += w;
        w = timeEndWidth - x;
        this.add(this.exitChannelSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u8f66\u724c\u7c7b\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> passportTypeList = new Vector<ComboBoxEntry<String>>();
        passportTypeList.add(new ComboBoxEntry<String>("", "\u5168\u90e8\u7c7b\u578b"));
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (passportTypeMap != null) {
            for (CarparkPassportType t : passportTypeMap.values()) {
                passportTypeList.add(new ComboBoxEntry<String>(t.getPassport_type_no(), t.getPassport_type_name()));
            }
        }
        this.passportTypeSelect = new JComboBox(passportTypeList);
        this.passportTypeSelect.setBackground(Color.WHITE);
        this.passportTypeSelect.setFont(font);
        this.passportTypeSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.passportTypeSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchAttrWidth;
        lable = new JLabel("\u503c\u73ed/\u6536\u8d39\u5458");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> userlist = new Vector<ComboBoxEntry<String>>();
        userlist.add(new ComboBoxEntry<String>("", "\u6240\u6709\u503c\u73ed\u5458"));
        this.userSelect = new JComboBox(userlist);
        this.userSelect.setBackground(Color.WHITE);
        this.userSelect.setFont(font);
        this.userSelect.addActionListener(this);
        x += w;
        w = avgTextWidth - searchAttrWidth + searchTWidth;
        this.add(this.userSelect, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> vslit = new Vector<ComboBoxEntry<String>>();
        vslit.add(new ComboBoxEntry<String>("exit_should_charge", "\u5e94\u6536\u91d1\u989d\u8303\u56f4"));
        vslit.add(new ComboBoxEntry<String>("period_multi_free", "\u5468\u671f\u4f18\u60e0\u91d1\u989d"));
        vslit.add(new ComboBoxEntry<String>("discount_money", "\u6253\u6298\u4f18\u60e0\u91d1\u989d"));
        vslit.add(new ComboBoxEntry<String>("already_paid", "\u573a\u5185/\u81ea\u52a9\u7f34\u8d39"));
        vslit.add(new ComboBoxEntry<String>("cash_pay", "\u51fa\u53e3\u73b0\u91d1\u91d1\u989d"));
        vslit.add(new ComboBoxEntry<String>("deduct_money", "\u51fa\u53e3\u6263\u8d39\u91d1\u989d"));
        int momeyAttrWidth = (int)Math.round(this.mainSize.getWidth() * 147.0 / 1280.0);
        this.moneyRangeSelect = new JComboBox(vslit);
        this.moneyRangeSelect.setBackground(Color.WHITE);
        this.moneyRangeSelect.setFont(font);
        this.moneyRangeSelect.addActionListener(this);
        x = 0;
        w = momeyAttrWidth;
        this.add(this.moneyRangeSelect, new XYConstraints(x, y += h + maginTop, w, h));
        int z2Weidht = (int)Math.round(this.mainSize.getWidth() * 13.0 / 1024.0);
        int exWidth = (timeEndWidth - x - w - z2Weidht) / 2;
        x += w;
        w = exWidth;
        this.moneyRange1Field = new JTextField();
        this.moneyRange1Field.setFont(font);
        this.add((Component)this.moneyRange1Field, new XYConstraints(x, y, w, h));
        x += w;
        w = z2Weidht;
        labl2 = new JLabel("-");
        labl2.setHorizontalAlignment(0);
        labl2.setFont(font);
        labl2.setForeground(cl);
        this.add((Component)labl2, new XYConstraints(x, y, w, h));
        x += w;
        w = exWidth;
        this.moneyRange2Field = new JTextField();
        this.moneyRange2Field.setFont(font);
        this.add((Component)this.moneyRange2Field, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u8f66\u573a\u6253\u6298");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        vslit = new Vector();
        vslit.add(new ComboBoxEntry<String>("", ""));
        Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
        if (dmap != null && !dmap.isEmpty()) {
            for (CarparkDiscountProject dp : dmap.values()) {
                vslit.add(new ComboBoxEntry<String>(dp.getDiscount_project_no(), dp.getDiscount_project_name()));
            }
        }
        if ((v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("ZHENGJIAN_CAPTURE")) == null || v.length() == 0) {
            v = "0";
        }
        if ("0".equals(v)) {
            vslit.add(new ComboBoxEntry<String>("certificates_free", "\u8bc1\u4ef6\u6293\u62cd\u514d\u8d39"));
        }
        this.discountSelect = new JComboBox(vslit);
        this.discountSelect.setBackground(Color.WHITE);
        this.discountSelect.setFont(font);
        this.discountSelect.addActionListener(this);
        x += w;
        w = avgTextWidth;
        this.add(this.discountSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth / 2;
        lable = new JLabel("\u8f66\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        int searchButtonWidth = 5 * fontSize;
        int carTypeWidth = avgTextWidth - searchButtonWidth - 5 + w;
        Vector<ComboBoxEntry<String>> carTypeList = new Vector<ComboBoxEntry<String>>();
        carTypeList.add(new ComboBoxEntry<String>("", "\u5168\u90e8"));
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (carTypeMap != null) {
            for (CarparkCarType t : carTypeMap.values()) {
                carTypeList.add(new ComboBoxEntry<String>(t.getCar_type_no(), t.getCar_type_name()));
            }
        }
        this.carTypeSelect = new JComboBox(carTypeList);
        this.carTypeSelect.setBackground(Color.WHITE);
        this.carTypeSelect.setFont(font);
        this.carTypeSelect.addActionListener(this);
        x += w;
        w = carTypeWidth;
        this.add(this.carTypeSelect, new XYConstraints(x, y, w, h));
        x += w + 5;
        this.searchButton = new JButton("\u67e5\u8be2");
        this.searchButton.addActionListener(this);
        this.searchButton.setFont(font);
        this.searchButton.setCursor(new Cursor(12));
        w = searchButtonWidth;
        this.add((Component)this.searchButton, new XYConstraints(x, y, w, h));
        this.totalInfoLabel = new JLabel();
        this.totalInfoLabel.setFont(font);
        int totalInfoWidth = size.width;
        int totalInfoHegiht = (int)Math.round(this.mainSize.getHeight() * 30.0 / 768.0);
        int totalY = size.height - totalInfoHegiht;
        this.add((Component)this.totalInfoLabel, new XYConstraints(0, totalY, totalInfoWidth, totalInfoHegiht));
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(this.getBackground());
        int pagePanelHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        int apagePanelWidth = (int)Math.round(this.mainSize.getHeight() * 38.0 / 768.0);
        int apagePanelMarButtom = (int)Math.round(this.mainSize.getHeight() * 7.0 / 768.0);
        int pagePanelWidth = size.width;
        int pagePanelX = 0;
        int pagePanelY = totalY - pagePanelHeight - apagePanelMarButtom;
        this.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.setInitPagePanelWidth(apagePanelWidth);
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), this.mainSize, 7);
        this.pagePanel.getInfoLable().setFont(font);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.setBackground(this.getBackground());
        int dataMarginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int dataMarginBottom = (int)Math.round(this.mainSize.getHeight() * 8.0 / 768.0);
        int dataPanelX = 0;
        int dataPanelY = y + h + dataMarginTop;
        int dataPanelWidth = size.width;
        int dataPanelHeight = pagePanelY - dataMarginBottom - dataPanelY;
        this.add((Component)dataPanel, new XYConstraints(dataPanelX, dataPanelY, dataPanelWidth, dataPanelHeight));
        int rowHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        this.eqTable = new JTable();
        this.eqTable.setRowHeight(rowHeight);
        this.eqTable.setShowGrid(true);
        this.eqTable.setModel(new SetTableModel(null));
        this.eqTable.setBackground(dataPanel.getBackground());
        this.eqTable.setGridColor(Color.decode("#D4D8DC"));
        int cellFontSize = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        Font cellFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, cellFontSize);
        this.eqTable.setFont(cellFont);
        this.eqTable.getTableHeader().setFont(font);
        this.eqTable.addMouseListener(this);
        this.resultTablePanel = new JScrollPane(this.eqTable);
        this.resultTablePanel.setBackground(dataPanel.getBackground());
        this.resultTablePanel.getViewport().setBackground(Color.decode("#F5F8FD"));
        dataPanel.add((Component)this.resultTablePanel, "Center");
        this.loadUsers();
    }

    private void loadUsers() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                List ropList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"DISTINCT role_no AS role_no"}).addEQ("permission_no", (Object)("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
                HashSet<String> roleList = new HashSet<String>();
                if (ropList != null && !ropList.isEmpty()) {
                    for (CarparkRolePermission r : ropList) {
                        if (r.getRole_no() == null || r.getRole_no().length() <= 0) continue;
                        roleList.add(r.getRole_no());
                    }
                }
                roleList.add("1");
                final List canLoginUserList = commonDaoService.selectList(new SearchParam().addINList("role_no", roleList).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no,user_code"), CarparkUser.class, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (canLoginUserList != null && !canLoginUserList.isEmpty()) {
                            for (CarparkUser u : canLoginUserList) {
                                ExitRecordSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>(u.getUser_code(), u.getUser_name()));
                            }
                        }
                    }
                });
            }
        });
    }

    private String getPlate() {
        if (this.arrSelect.getSelectedIndex() == 0) {
            String x = this.attrTextField.getText();
            String v2 = x;
            v2 = v2 == null ? "" : v2.trim();
            v2 = v2.toUpperCase();
            v2 = v2.replaceAll("\u3000", "");
            v2 = v2.replaceAll(" ", "");
            if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
                this.attrTextField.setText(v2);
            }
            return v2;
        }
        return null;
    }

    @Override
    public void doDiselct() {
        this.selected = false;
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        if (this.detailDialogMap != null) {
            for (JDialog dialog : this.detailDialogMap.values()) {
                if (dialog == null || !dialog.isVisible()) continue;
                dialog.dispose();
            }
        }
    }

    @Override
    public void doSelect() {
        this.selected = true;
        if (!this.loadFirst) {
            this.loadFirst = true;
            this.gotoPage(1, recordPageSize, -1, 0, 0);
        }
    }

    @Override
    public void onWidnowDispose() {
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        if (this.detailDialogMap != null) {
            for (JDialog dialog : this.detailDialogMap.values()) {
                if (dialog == null || !dialog.isVisible()) continue;
                dialog.dispose();
            }
        }
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabName() {
        return "\u8f66\u8f86\u79bb\u573a\u8bb0\u5f55";
    }

    @Override
    public void onPressEnter() {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        if (!this.selected) {
            return;
        }
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        final Pagination pagination = new Pagination();
        if (recordsCount < 0) {
            pagination.setNeedQueryCount(true);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
        } else {
            pagination.setNeedQueryCount(false);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
            pagination.setRecordsCount((long)recordsCount);
        }
        final SearchParam p = this.getSearchParam();
        if (p == null) {
            return;
        }
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder totalMoneytxt;
                    boolean neeQueryTotalMoney = pagination.isNeedQueryCount();
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    final List recordList = commonDaoService.selectList(p, CarparkPassRecord.class, pagination);
                    Map totalMoneyMap0 = null;
                    if (neeQueryTotalMoney) {
                        if (pagination.getRecordsCount() == 0L) {
                            totalMoneyMap0 = new HashMap();
                        } else {
                            p.setQueryFields(new String[]{"SUM(exit_should_charge) AS exit_should_charge_total", "SUM(period_multi_free) AS period_multi_free_total", "SUM(discount_money) AS discount_money_total", "SUM(already_paid) AS already_paid_total", "SUM(cash_pay) AS cash_pay_total", "SUM(deduct_money) AS deduct_money"});
                            p.setTableName(commonDaoService.getTableName(CarparkPassRecord.class));
                            p.setOrder_by(null);
                            Map pax = commonDaoService.selectOne(p);
                            totalMoneyMap0 = pax == null ? new HashMap() : pax;
                        }
                    }
                    if (totalMoneyMap0 != null) {
                        NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                        totalMoneytxt = new StringBuilder(128);
                        BigDecimal d = (BigDecimal)totalMoneyMap0.get("exit_should_charge_total");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\u603b\u8ba1\u5e94\u6536:").append(sf.format(d));
                        d = (BigDecimal)totalMoneyMap0.get("period_multi_free_total");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\uff0c\u5468\u671f\u4f18\u60e0:").append(sf.format(d));
                        d = (BigDecimal)totalMoneyMap0.get("discount_money_total");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\uff0c\u6298\u6263:").append(sf.format(d));
                        d = (BigDecimal)totalMoneyMap0.get("already_paid_total");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\uff0c\u573a\u5185/\u81ea\u52a9\u7f34\u8d39:").append(sf.format(d));
                        d = (BigDecimal)totalMoneyMap0.get("cash_pay_total");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\uff0c\u51fa\u53e3\u73b0\u91d1:").append(sf.format(d));
                        d = (BigDecimal)totalMoneyMap0.get("deduct_money");
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        totalMoneytxt.append("\uff0c\u51fa\u53e3\u6263\u8d39:").append(sf.format(d));
                    } else {
                        totalMoneytxt = null;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ExitRecordSearchTabPane.this.eqTable.setModel(new SetTableModel(recordList));
                                ExitRecordSearchTabPane.this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
                                if (totalMoneytxt != null) {
                                    if (ServiceUtil.isEnableGuiFee()) {
                                        ExitRecordSearchTabPane.this.totalInfoLabel.setText(totalMoneytxt.toString());
                                    } else {
                                        ExitRecordSearchTabPane.this.totalInfoLabel.setText("");
                                    }
                                }
                            }
                            finally {
                                ExitRecordSearchTabPane.this.searchButton.setEnabled(true);
                                ExitRecordSearchTabPane.this.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    ExitRecordSearchTabPane.this.searchButton.setEnabled(true);
                    ExitRecordSearchTabPane.this.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    public SearchParam getSearchParam() {
        Object v;
        ComboBoxEntry box;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam p = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
        p.addNotEQ("exit_time", null);
        String beginDate = this.date1Field.getText();
        DateFormat df = null;
        Date _startDate = null;
        if (beginDate != null && beginDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _startDate = df.parse(beginDate);
                p.addGTE("pass_time", (Object)_startDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String endDate = this.date2Field.getText();
        Date _endDate = null;
        if (endDate != null && endDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _endDate = df.parse(endDate);
                p.addLTE("pass_time", (Object)_endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_startDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u79bb\u573a\u5f00\u59cb\u65f6\u95f4", 4));
            return null;
        }
        if (_endDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u79bb\u573a\u7ed3\u675f\u65f6\u95f4", 4));
            return null;
        }
        long ass = _endDate.getTime() - _startDate.getTime();
        if (ass < 0L) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u79bb\u573a\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        long mills = TimeUnit.DAYS.toMillis(62L);
        if (ass > mills) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u67e5\u8be2\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc762\u5929\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        if (this.arrSelect.getSelectedIndex() == 0) {
            String plate = this.getPlate();
            if (plate != null && plate.length() > 0) {
                p.addLike("exit_plate", plate);
            }
        } else {
            ComboBoxEntry sa;
            String addrValue = this.attrTextField.getText();
            if (addrValue != null && (addrValue = addrValue.trim()).length() > 0 && (sa = (ComboBoxEntry)((Object)this.arrSelect.getSelectedItem())) != null) {
                String key = (String)sa.getKey();
                p.addLike(key, addrValue);
            }
        }
        if ((box = (ComboBoxEntry)((Object)this.recordTypeSelect.getSelectedItem())) != null && (v = (Integer)box.getKey()) != null) {
            if ((Integer)v == 1) {
                p.addEQ("enter_time", null);
            } else if ((Integer)v == 2) {
                p.addEQ("record_state", (Object)2);
            } else if ((Integer)v == 3) {
                p.addEQ("enter_plate_source", (Object)1);
            } else if ((Integer)v == 4) {
                p.addEQ("enter_plate_source", (Object)2);
            } else if ((Integer)v == 5) {
                p.addEQ("enter_plate_source", (Object)4);
            } else if ((Integer)v == 6) {
                p.addEQ("exit_plate_source", (Object)1);
            } else if ((Integer)v == 7) {
                p.addEQ("exit_plate_source", (Object)2);
            } else if ((Integer)v == 8) {
                p.addEQ("exit_plate_source", (Object)4);
            } else if ((Integer)v == 9) {
                p.addNotEQ("certificate_pic", null);
            }
        }
        if ((box = (ComboBoxEntry)((Object)this.areaSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("area_no", v);
        }
        if ((box = (ComboBoxEntry)((Object)this.passportTypeSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("passport_type_no", v);
        }
        if ((box = (ComboBoxEntry)((Object)this.carTypeSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("exit_car_type_no", v);
        }
        if ((box = (ComboBoxEntry)((Object)this.exitChannelSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("exit_channel_no", v);
        }
        if ((box = (ComboBoxEntry)((Object)this.userSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("exit_duty_user_code", v);
        }
        if ((box = (ComboBoxEntry)((Object)this.discountSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && ((String)v).length() > 0) {
            p.addEQ("discount_merchant_no", (Object)"0");
            p.addEQ("discount_project_no", v);
        }
        BigDecimal d1 = null;
        String x1 = this.moneyRange1Field.getText();
        if (x1 != null && (x1 = x1.trim()).length() > 0) {
            try {
                d1 = new BigDecimal(x1);
            }
            catch (Exception ex) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u91d1\u989d\u67e5\u8be2\u8303\u56f4\u5fc5\u987b\u662f\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", 4));
                this.moneyRange1Field.requestFocus();
                return null;
            }
        }
        BigDecimal d2 = null;
        x1 = this.moneyRange2Field.getText();
        if (x1 != null && (x1 = x1.trim()).length() > 0) {
            try {
                d2 = new BigDecimal(x1);
            }
            catch (Exception ex) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u91d1\u989d\u67e5\u8be2\u8303\u56f4\u5fc5\u987b\u662f\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", 4));
                this.moneyRange2Field.requestFocus();
                return null;
            }
        }
        if (d1 != null || d2 != null) {
            String queyrk = (String)((ComboBoxEntry)((Object)this.moneyRangeSelect.getSelectedItem())).getKey();
            if (d1 != null && d2 != null) {
                if (d1.doubleValue() > d2.doubleValue()) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u91d1\u989d\u67e5\u8be2\u8303\u56f4\u5f00\u59cb\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u91d1\u989d", 4));
                    this.moneyRange2Field.requestFocus();
                    return null;
                }
                if (d1.doubleValue() == d2.doubleValue()) {
                    p.addEQ(queyrk, (Object)d1);
                } else {
                    p.addGTE(queyrk, (Object)d1);
                    p.addLTE(queyrk, (Object)d2);
                }
            } else if (d1 != null && d2 == null) {
                p.addGTE(queyrk, (Object)d1);
            } else if (d1 == null && d2 != null) {
                p.addLTE(queyrk, (Object)d2);
            }
        }
        p.setOrerbySql("pass_time DESC");
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.arrSelect) {
            String v = this.attrTextField.getText();
            if (v != null && v.length() > 0) {
                this.attrTextField.setText("");
                this.gotoPage(1, recordPageSize, -1, 0, 0);
            }
            this.attrTextField.requestFocus();
        } else {
            this.gotoPage(1, recordPageSize, -1, 0, 0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.selected) {
            return;
        }
        Object source = e.getSource();
        if (source == this.date1Field) {
            if (this.datePicker1 == null) {
                this.datePicker1 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        ExitRecordSearchTabPane.this.date1Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        ExitRecordSearchTabPane.this.date1Field.setText(dateTime);
                        ExitRecordSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker2 != null && this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            }
            if (this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            } else {
                String t = this.date1Field.getText();
                this.datePicker1.setDateTime(t);
                this.datePicker1.showPicker(this.date1Field);
            }
        } else if (source == this.date2Field) {
            if (this.datePicker2 == null) {
                this.datePicker2 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        ExitRecordSearchTabPane.this.date2Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        ExitRecordSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker1 != null && this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            }
            if (this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            } else {
                String t = this.date2Field.getText();
                this.datePicker2.setDateTime(t);
                this.datePicker2.showPicker(this.date2Field);
            }
        } else if (source == this.eqTable) {
            Long id;
            CarparkPassRecord record;
            SetTableModel dataModel;
            int rowIndex;
            long currentTime = ServiceUtil.getServiceContext().currentTimeMillis();
            boolean dbClick = currentTime - this.tableRowDbClickMills <= 350L;
            this.tableRowDbClickMills = currentTime;
            if (dbClick && (rowIndex = this.eqTable.getSelectedRow()) > -1 && (dataModel = (SetTableModel)this.eqTable.getModel()).dataList != null && rowIndex < dataModel.dataList.size() && (record = (CarparkPassRecord)dataModel.dataList.get(rowIndex)) != null && (id = record.getId()) != null) {
                JDialog d = this.detailDialogMap.get(id);
                if (d != null) {
                    d.toFront();
                } else {
                    MacDialog dialog = this.createDetailDialog(record);
                    if (dialog != null) {
                        dialog.addDialogDisponseListener(new DialogDisponseListener(){

                            @Override
                            public void onDispose(JDialog dialog) {
                                ExitRecordSearchTabPane.this.detailDialogMap.remove(id);
                                JDialog dialog1 = (JDialog)ServiceUtil.getFirstElement(ExitRecordSearchTabPane.this.detailDialogMap.values());
                                if (dialog1 != null) {
                                    dialog1.toFront();
                                    dialog1.requestFocus();
                                } else {
                                    ExitRecordSearchTabPane.this.requestFocusInWindow();
                                }
                            }
                        });
                        this.detailDialogMap.put(id, dialog);
                    }
                }
            }
        }
    }

    protected MacDialog createDetailDialog(CarparkPassRecord record) {
        int wx = this.mainSize.width <= 1024 ? 950 : (this.mainSize.width <= 1600 ? 900 : (this.mainSize.width <= 1920 ? 850 : 800));
        int dialogWidth = (int)Math.round(this.mainSize.getWidth() * (double)wx / 1280.0);
        int dialogHeight = (int)Math.round(this.mainSize.getHeight() * 550.0 / 768.0);
        ExitRecordDetailDialog dialog = ExitRecordDetailDialog.showDialog(record, this, new Dimension(dialogWidth, dialogHeight), this.mainSize, false);
        dialog.setTitleInfo(String.valueOf(record.getExit_plate()) + " \u79bb\u573a\u4fe1\u606f");
        return dialog;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class SetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5225431626950004306L;
        private String[] titleHeaders = new String[]{"\u8f66\u724c/\u7c7b\u578b", "\u5165\u573a\u901a\u9053/\u65f6\u95f4", "\u79bb\u573a\u65f6\u95f4", "\u79bb\u573a\u533a\u57df/\u901a\u9053", "\u5e94\u6536\u91d1\u989d", "\u4f18\u60e0/\u6298\u6263", "\u81ea\u52a9\u7f34\u8d39", "\u73b0\u91d1/\u6263\u8d39", "\u503c\u73ed\u5458"};
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        private List<CarparkPassRecord> dataList;

        private SetTableModel(List<CarparkPassRecord> dataList) {
            this.dataList = dataList;
        }

        @Override
        public int getColumnCount() {
            return this.titleHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.dataList == null ? 0 : this.dataList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            String v = null;
            if (this.dataList == null || this.dataList.isEmpty()) {
                return "";
            }
            if (rowIndex >= this.dataList.size()) {
                return "";
            }
            CarparkPassRecord r = this.dataList.get(rowIndex);
            switch (col) {
                case 0: {
                    v = String.valueOf(r.getExit_plate()) + "\uff0c" + r.getPassport_type_name() + "\uff0c" + r.getExit_car_type_name();
                    break;
                }
                case 1: {
                    if (r.getEnter_time() == null) break;
                    v = String.valueOf(r.getEnter_channel_name()) + "\uff0c" + this.df.format(r.getEnter_time());
                    break;
                }
                case 2: {
                    if (r.getExit_time() == null) break;
                    v = this.df.format(r.getExit_time());
                    break;
                }
                case 3: {
                    v = String.valueOf(r.getArea_name()) + "\uff0c" + r.getExit_channel_name();
                    break;
                }
                case 4: {
                    if (ServiceUtil.isEnableGuiFee()) {
                        v = r.getExit_should_charge() == null ? "0.00" : r.getExit_should_charge().toString();
                        break;
                    }
                    v = "";
                    break;
                }
                case 5: {
                    if (ServiceUtil.isEnableGuiFee()) {
                        BigDecimal d = r.getPeriod_multi_free();
                        if (d == null) {
                            d = Constants.MONEY_ZERO;
                        }
                        if (r.getDiscount_money() != null) {
                            d = d.add(r.getDiscount_money());
                        }
                        v = d.toString();
                        break;
                    }
                    v = "";
                    break;
                }
                case 6: {
                    if (ServiceUtil.isEnableGuiFee()) {
                        v = r.getAlready_paid() == null ? "0.00" : r.getAlready_paid().toString();
                        break;
                    }
                    v = "";
                    break;
                }
                case 7: {
                    if (ServiceUtil.isEnableGuiFee()) {
                        if (r.getDeduct_money() != null && r.getDeduct_money().doubleValue() > 0.0) {
                            v = String.valueOf(r.getDeduct_money().toString()) + " [\u6263\u8d39]";
                            break;
                        }
                        if (r.getCash_pay() != null && r.getCash_pay().doubleValue() > 0.0) {
                            v = String.valueOf(r.getCash_pay().toString()) + " [\u73b0\u91d1]";
                            break;
                        }
                        v = "0.00";
                        break;
                    }
                    v = "";
                    break;
                }
                case 8: {
                    v = String.valueOf(r.getExit_duty_user_name()) + "," + r.getExit_host_name();
                }
            }
            if (v == null) {
                v = "";
            }
            return v;
        }

        @Override
        public String getColumnName(int column) {
            return this.titleHeaders[column];
        }
    }
}

