/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.dto.CarparkIllegalPassRecord;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.PicLoadUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class IllegalPassDetailDialog
extends MacDialog
implements ActionListener {
    private static final long serialVersionUID = -2536454847101325560L;
    private Dimension mainSize;
    private CarparkIllegalPassRecord record;
    private JLabel picLabel;
    private Dimension picSize;
    private JLabel infoLabel;

    public static IllegalPassDetailDialog showDialog(CarparkIllegalPassRecord record, Component c, Dimension size, Dimension mainSize, boolean modal) {
        IllegalPassDetailDialog dilog;
        Window rootWidnow = null;
        if (c == null) {
            dilog = new IllegalPassDetailDialog();
        } else {
            Window w = SwingUtil.getWindowForComponent(c);
            dilog = w instanceof Frame ? new IllegalPassDetailDialog((Frame)w, "", modal) : (w instanceof Dialog ? new IllegalPassDetailDialog((Dialog)w, "", modal) : (w instanceof Window ? new IllegalPassDetailDialog(w, "", modal) : new IllegalPassDetailDialog()));
            rootWidnow = w;
        }
        dilog.mainSize = mainSize;
        dilog.record = record;
        dilog.init(size, rootWidnow);
        dilog.setVisible(true);
        return dilog;
    }

    public IllegalPassDetailDialog() {
    }

    public IllegalPassDetailDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public IllegalPassDetailDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public IllegalPassDetailDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    @Override
    public int getTitileBarHeight() {
        return (int)Math.round(this.mainSize.getHeight() * 30.0 / 900.0);
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        try {
            this.showCloseButton(this.getTitileBarHeight());
            this.rootPanel.registerKeyboardAction(this, "vk_esc", KeyStroke.getKeyStroke(27, 0), 2);
            this.init1(body, panelSize);
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)ex.getMessage(), ex);
        }
    }

    protected void init1(JPanel body, Dimension panelSize) {
        body.setLayout(new XYLayout());
        int x = 0;
        int w = panelSize.width;
        int h = (int)((double)panelSize.height * 0.8);
        int y = 0;
        this.picLabel = new JLabel();
        this.picSize = new Dimension(w, h);
        PicLoadUtil.loadPic(this.picLabel, this.record.getHost_no(), this.record.getPic_path(), this.picSize, null, this.mainSize, false);
        body.add((Component)this.picLabel, new XYConstraints(x, y, w, h));
        int marginTop = 0;
        int marginBottm = 0;
        int marginLeft = (int)Math.round(this.mainSize.getWidth() * 15.0 / 1024.0);
        int marginRight = (int)Math.round(this.mainSize.getWidth() * 15.0 / 1024.0);
        y = y + h + marginTop;
        int totalContentWidth = panelSize.width - marginLeft - marginRight;
        int totalContentHeight = panelSize.height - y - marginBottm;
        this.infoLabel = new JLabel();
        int fontSize = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        this.infoLabel.setFont(font);
        body.add((Component)this.infoLabel, new XYConstraints(marginLeft, y, totalContentWidth, totalContentHeight));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sbr = new StringBuilder(128);
        sbr.append("\u653e\u884c\u4fe1\u606f\uff1a");
        char z = '\u3001';
        if (this.record.getPass_time() != null) {
            sbr.append(df.format(this.record.getPass_time()));
        }
        sbr.append(z).append(this.record.getArea_name()).append(z).append(this.record.getChannel_name()).append(z).append(this.record.getDescription()).append(z).append(this.record.getOp_user_name()).append(z).append(this.record.getHost_name());
        if (this.record.getPass_plate() != null && this.record.getPass_plate().length() > 0) {
            sbr.append(z).append(this.record.getPass_plate());
        }
        this.infoLabel.setText(sbr.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("vk_esc".equals(cmd)) {
            this.dispose();
        }
    }
}

