/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.dto.CarparkIllegalPassRecord;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.DateTimePicker;
import com.wovoe.carpark.gui.DialogDisponseListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.IllegalPassDetailDialog;
import com.wovoe.carpark.gui.login.MainTabPane;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class IllegalPassSearchTabPane
extends JPanel
implements MainTabPane,
MouseListener,
ActionListener,
GotoPageHandler {
    private static final long serialVersionUID = 5190570686294726133L;
    private JTextField date1Field;
    private JTextField date2Field;
    private JComboBox<ComboBoxEntry<String>> reasonSelect;
    private JComboBox<ComboBoxEntry<String>> userSelect;
    private JButton searchButton;
    private JTable eqTable;
    private JScrollPane resultTablePanel;
    private PaginationPanel pagePanel;
    private static int recordPageSize = 15;
    private String queryDateFormat = "yy/MM/dd HH:mm:ss";
    private volatile boolean loadFirst = false;
    private volatile boolean selected = false;
    private volatile long tableRowDbClickMills;
    private DateTimePicker datePicker1;
    private DateTimePicker datePicker2;
    private ConcurrentHashMap<Object, JDialog> detailDialogMap = new ConcurrentHashMap();
    private Dimension mainSize;

    @Override
    public void init(Dimension size, Dimension rootSize) {
        int label2Weidht;
        this.mainSize = rootSize;
        this.setLayout(new XYLayout());
        Color cl = Color.decode("#222222");
        int fontSize = (int)Math.round(this.mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int searchTWidth = (int)Math.round(this.mainSize.getWidth() * 70.0 / 1280.0);
        int searchHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        int searchMarginTop = (int)Math.round(this.mainSize.getHeight() * 15.0 / 768.0);
        int grap = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        int searchButtonWidth = 5 * fontSize;
        int dateWidth = (int)Math.round(this.mainSize.getWidth() * 130.0 / 1024.0);
        int x = 0;
        int y = searchMarginTop;
        int w = searchTWidth;
        int h = searchHeight;
        JLabel lable = new JLabel("\u653e\u884c\u65f6\u95f4");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.date1Field = new JTextField();
        this.date1Field.setFont(font);
        this.date1Field.setEditable(false);
        this.date1Field.addMouseListener(this);
        this.add((Component)this.date1Field, new XYConstraints(x, y, w, h));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.date1Field.setText(new SimpleDateFormat(this.queryDateFormat).format(calendar.getTime()));
        x += w;
        w = label2Weidht = (int)Math.round(this.mainSize.getWidth() * 25.0 / 1280.0);
        JLabel labl2 = new JLabel("\u81f3");
        labl2.setHorizontalAlignment(0);
        labl2.setFont(font);
        labl2.setForeground(cl);
        this.add((Component)labl2, new XYConstraints(x, y, w, h));
        x += w;
        w = dateWidth;
        this.date2Field = new JTextField();
        this.date2Field.setFont(font);
        this.date2Field.setEditable(false);
        this.date2Field.addMouseListener(this);
        this.add((Component)this.date2Field, new XYConstraints(x, y, w, h));
        this.date2Field.setText(new SimpleDateFormat(this.queryDateFormat).format(now));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel(this.getReasonTitle());
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        int textWith = (size.width - x - w - searchButtonWidth - searchTWidth - 2 * grap) / 2;
        x += w;
        w = textWith + 5;
        this.reasonSelect = new JComboBox<ComboBoxEntry<String>>(this.getReasons());
        this.reasonSelect.setBackground(Color.WHITE);
        this.reasonSelect.setFont(font);
        this.reasonSelect.addActionListener(this);
        this.add(this.reasonSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u64cd\u4f5c\u4eba\u5458");
        lable.setFont(font);
        lable.setForeground(cl);
        this.add((Component)lable, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> userlist = new Vector<ComboBoxEntry<String>>();
        userlist.add(new ComboBoxEntry<String>("", "\u6240\u6709\u503c\u73ed\u5458"));
        this.userSelect = new JComboBox(userlist);
        this.userSelect.setBackground(Color.WHITE);
        this.userSelect.setFont(font);
        this.userSelect.addActionListener(this);
        x += w;
        w = textWith - 5;
        this.add(this.userSelect, new XYConstraints(x, y, w, h));
        this.searchButton = new JButton("\u67e5\u8be2");
        this.searchButton.addActionListener(this);
        this.searchButton.setFont(font);
        this.searchButton.setCursor(new Cursor(12));
        x += w + grap;
        w = searchButtonWidth;
        this.add((Component)this.searchButton, new XYConstraints(x, y, w, h));
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(this.getBackground());
        int pagePanelHeight = (int)Math.round(this.mainSize.getHeight() * 28.0 / 768.0);
        int apagePanelWidth = (int)Math.round(this.mainSize.getHeight() * 38.0 / 768.0);
        int apagePanelMarButtom = 0;
        int pagePanelWidth = size.width;
        int pagePanelX = 0;
        int pagePanelY = size.height - pagePanelHeight - apagePanelMarButtom;
        this.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.setInitPagePanelWidth(apagePanelWidth);
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), this.mainSize, 7);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.setBackground(this.getBackground());
        int dataMarginTop = (int)Math.round(this.mainSize.getHeight() * 10.0 / 768.0);
        int dataMarginBottom = (int)Math.round(this.mainSize.getHeight() * 6.0 / 768.0);
        int dataPanelX = 0;
        int dataPanelY = y + h + dataMarginTop;
        int dataPanelWidth = size.width;
        int dataPanelHeight = pagePanelY - dataMarginBottom - dataPanelY;
        this.add((Component)dataPanel, new XYConstraints(dataPanelX, dataPanelY, dataPanelWidth, dataPanelHeight));
        int rowHeight = (int)Math.round(this.mainSize.getHeight() * 26.0 / 768.0);
        this.eqTable = new JTable();
        this.eqTable.setRowHeight(rowHeight);
        this.eqTable.setShowGrid(true);
        this.eqTable.setModel(new SetTableModel(null));
        this.eqTable.setBackground(dataPanel.getBackground());
        this.eqTable.setGridColor(Color.decode("#D4D8DC"));
        int cellFontSize = (int)Math.round(this.mainSize.getHeight() * 12.0 / 768.0);
        Font cellFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, cellFontSize);
        this.eqTable.setFont(cellFont);
        this.eqTable.getTableHeader().setFont(font);
        this.eqTable.addMouseListener(this);
        this.resultTablePanel = new JScrollPane(this.eqTable);
        this.resultTablePanel.setBackground(dataPanel.getBackground());
        this.resultTablePanel.getViewport().setBackground(Color.decode("#F5F8FD"));
        dataPanel.add((Component)this.resultTablePanel, "Center");
        this.loadUsers();
    }

    private void loadUsers() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                List ropList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"DISTINCT role_no AS role_no"}).addEQ("permission_no", (Object)("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
                HashSet<String> roleList = new HashSet<String>();
                if (ropList != null && !ropList.isEmpty()) {
                    for (CarparkRolePermission r : ropList) {
                        if (r.getRole_no() == null || r.getRole_no().length() <= 0) continue;
                        roleList.add(r.getRole_no());
                    }
                }
                roleList.add("1");
                final List canLoginUserList = commonDaoService.selectList(new SearchParam().addINList("role_no", roleList).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no,user_code"), CarparkUser.class, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (canLoginUserList != null && !canLoginUserList.isEmpty()) {
                            for (CarparkUser u : canLoginUserList) {
                                IllegalPassSearchTabPane.this.userSelect.addItem(new ComboBoxEntry<String>(u.getUser_code(), u.getUser_name()));
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void doDiselct() {
        this.selected = false;
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        if (this.detailDialogMap != null) {
            for (JDialog dialog : this.detailDialogMap.values()) {
                if (dialog == null || !dialog.isVisible()) continue;
                dialog.dispose();
            }
        }
    }

    @Override
    public void doSelect() {
        this.selected = true;
        if (!this.loadFirst) {
            this.loadFirst = true;
            this.gotoPage(1, recordPageSize, -1, 0, 0);
        }
    }

    @Override
    public void onWidnowDispose() {
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        if (this.detailDialogMap != null) {
            for (JDialog dialog : this.detailDialogMap.values()) {
                if (dialog == null || !dialog.isVisible()) continue;
                dialog.dispose();
            }
        }
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabName() {
        return "\u4eba\u5de5\u8d77\u6746\u8bb0\u5f55";
    }

    @Override
    public void onPressEnter() {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    protected int getRecordType() {
        return 0;
    }

    protected String getReasonTitle() {
        return "\u5f00\u95f8\u65b9\u5f0f";
    }

    protected Vector<ComboBoxEntry<String>> getReasons() {
        Vector<ComboBoxEntry<String>> list = new Vector<ComboBoxEntry<String>>();
        list.add(new ComboBoxEntry<String>("", "\u6240\u6709\u65b9\u5f0f"));
        list.add(new ComboBoxEntry<String>("0", "\u8f6f\u4ef6\u754c\u9762\u6309\u952e"));
        list.add(new ComboBoxEntry<String>("1", "\u9053\u95f8\u9065\u63a7\u5668"));
        return list;
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        if (!this.selected) {
            return;
        }
        if (this.datePicker1 != null && this.datePicker1.isShow()) {
            this.datePicker1.hidePanel();
        }
        if (this.datePicker2 != null && this.datePicker2.isShow()) {
            this.datePicker2.hidePanel();
        }
        final Pagination pagination = new Pagination();
        if (recordsCount < 0) {
            pagination.setNeedQueryCount(true);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
        } else {
            pagination.setNeedQueryCount(false);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
            pagination.setRecordsCount((long)recordsCount);
        }
        final SearchParam p = this.getSearchParam();
        if (p == null) {
            return;
        }
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    final List recordList = commonDaoService.selectList(p, CarparkIllegalPassRecord.class, pagination);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IllegalPassSearchTabPane.this.eqTable.setModel(new SetTableModel(recordList));
                                IllegalPassSearchTabPane.this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
                            }
                            finally {
                                IllegalPassSearchTabPane.this.searchButton.setEnabled(true);
                                IllegalPassSearchTabPane.this.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    IllegalPassSearchTabPane.this.searchButton.setEnabled(true);
                    IllegalPassSearchTabPane.this.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    public SearchParam getSearchParam() {
        String v;
        SearchParam p = new SearchParam();
        p.addEQ("record_type", (Object)this.getRecordType());
        String beginDate = this.date1Field.getText();
        DateFormat df = null;
        Date _startDate = null;
        if (beginDate != null && beginDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _startDate = df.parse(beginDate);
                p.addGTE("pass_time", (Object)_startDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String endDate = this.date2Field.getText();
        Date _endDate = null;
        if (endDate != null && endDate.length() > 0) {
            try {
                if (df == null) {
                    df = new SimpleDateFormat(this.queryDateFormat);
                }
                _endDate = df.parse(endDate);
                p.addLTE("pass_time", (Object)_endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_startDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u653e\u884c\u5f00\u59cb\u65f6\u95f4", 4));
            return null;
        }
        if (_endDate == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8bf7\u9009\u62e9\u653e\u884c\u7ed3\u675f\u65f6\u95f4", 4));
            return null;
        }
        long ass = _endDate.getTime() - _startDate.getTime();
        if (ass < 0L) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u653e\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        long mills = TimeUnit.DAYS.toMillis(62L);
        if (ass > mills) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u67e5\u8be2\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc762\u5929\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", 4));
            return null;
        }
        ComboBoxEntry box = (ComboBoxEntry)((Object)this.userSelect.getSelectedItem());
        if (box != null && (v = (String)box.getKey()) != null && v.length() > 0) {
            p.addEQ("op_user_code", (Object)v);
        }
        if ((box = (ComboBoxEntry)((Object)this.reasonSelect.getSelectedItem())) != null && (v = (String)box.getKey()) != null && v.length() > 0) {
            p.addEQ("reason_code", (Object)v);
        }
        p.setOrerbySql("pass_time DESC");
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.selected) {
            return;
        }
        Object source = e.getSource();
        if (source == this.date1Field) {
            if (this.datePicker1 == null) {
                this.datePicker1 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        IllegalPassSearchTabPane.this.date1Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        IllegalPassSearchTabPane.this.date1Field.setText(dateTime);
                        IllegalPassSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker2 != null && this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            }
            if (this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            } else {
                String t = this.date1Field.getText();
                this.datePicker1.setDateTime(t);
                this.datePicker1.showPicker(this.date1Field);
            }
        } else if (source == this.date2Field) {
            if (this.datePicker2 == null) {
                this.datePicker2 = DateTimePicker.createDateTimePicker(null, this.queryDateFormat, new DateTimePicker.DateTimePickerCallback(){

                    @Override
                    public void onPicking(String dateTime) {
                        IllegalPassSearchTabPane.this.date2Field.setText(dateTime);
                    }

                    @Override
                    public void onPickClear() {
                    }

                    @Override
                    public void doPick(String dateTime) {
                        IllegalPassSearchTabPane.this.gotoPage(1, recordPageSize, -1, 0, 0);
                    }
                }, false);
            }
            if (this.datePicker1 != null && this.datePicker1.isShow()) {
                this.datePicker1.hidePanel();
            }
            if (this.datePicker2.isShow()) {
                this.datePicker2.hidePanel();
            } else {
                String t = this.date2Field.getText();
                this.datePicker2.setDateTime(t);
                this.datePicker2.showPicker(this.date2Field);
            }
        } else if (source == this.eqTable) {
            Long id;
            CarparkIllegalPassRecord record;
            SetTableModel dataModel;
            int rowIndex;
            long currentTime = ServiceUtil.getServiceContext().currentTimeMillis();
            boolean dbClick = currentTime - this.tableRowDbClickMills <= 350L;
            this.tableRowDbClickMills = currentTime;
            if (dbClick && (rowIndex = this.eqTable.getSelectedRow()) > -1 && (dataModel = (SetTableModel)this.eqTable.getModel()).dataList != null && rowIndex < dataModel.dataList.size() && (record = (CarparkIllegalPassRecord)dataModel.dataList.get(rowIndex)) != null && (id = record.getId()) != null) {
                JDialog d = this.detailDialogMap.get(id);
                if (d != null) {
                    d.toFront();
                } else {
                    MacDialog dialog = this.createDetailDialog(record);
                    if (dialog != null) {
                        dialog.addDialogDisponseListener(new DialogDisponseListener(){

                            @Override
                            public void onDispose(JDialog dialog) {
                                IllegalPassSearchTabPane.this.detailDialogMap.remove(id);
                                JDialog dialog1 = (JDialog)ServiceUtil.getFirstElement(IllegalPassSearchTabPane.this.detailDialogMap.values());
                                if (dialog1 != null) {
                                    dialog1.toFront();
                                    dialog1.requestFocus();
                                } else {
                                    IllegalPassSearchTabPane.this.requestFocusInWindow();
                                }
                            }
                        });
                        this.detailDialogMap.put(id, dialog);
                    }
                }
            }
        }
    }

    protected MacDialog createDetailDialog(CarparkIllegalPassRecord record) {
        int dialogWidth = this.mainSize.width <= 1280 ? (int)Math.round(this.mainSize.getWidth() * 800.0 / 1280.0) : (int)Math.round(this.mainSize.getWidth() * 700.0 / 1280.0);
        int dialogHeight = (int)Math.round(this.mainSize.getHeight() * 430.0 / 768.0);
        IllegalPassDetailDialog dialog = IllegalPassDetailDialog.showDialog(record, this, new Dimension(dialogWidth, dialogHeight), this.mainSize, false);
        dialog.setTitleInfo(String.valueOf(this.getTabName()) + "\u56fe\u7247/\u4fe1\u606f");
        return dialog;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class SetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5225431626950004306L;
        private String[] titleHeaders;
        SimpleDateFormat df1;
        private List<CarparkIllegalPassRecord> dataList;

        private SetTableModel(List<CarparkIllegalPassRecord> dataList) {
            this.titleHeaders = new String[]{"\u653e\u884c\u65f6\u95f4", "\u653e\u884c\u533a\u57df", "\u653e\u884c\u901a\u9053", IllegalPassSearchTabPane.this.getReasonTitle(), "\u64cd\u4f5c\u5458", "\u5c97\u4ead/\u7535\u8111"};
            this.df1 = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
            this.dataList = dataList;
        }

        @Override
        public int getColumnCount() {
            return this.titleHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.dataList == null ? 0 : this.dataList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            String v = null;
            if (this.dataList == null || this.dataList.isEmpty()) {
                return "";
            }
            if (rowIndex >= this.dataList.size()) {
                return "";
            }
            CarparkIllegalPassRecord r = this.dataList.get(rowIndex);
            switch (col) {
                case 0: {
                    v = r.getPass_time() == null ? null : this.df1.format(r.getPass_time());
                    break;
                }
                case 1: {
                    v = r.getArea_name();
                    break;
                }
                case 2: {
                    v = r.getChannel_name();
                    break;
                }
                case 3: {
                    v = r.getDescription();
                    break;
                }
                case 4: {
                    v = r.getOp_user_name();
                    break;
                }
                case 5: {
                    v = r.getHost_name();
                }
            }
            if (v == null) {
                v = "";
            }
            return v;
        }

        @Override
        public String getColumnName(int column) {
            return this.titleHeaders[column];
        }
    }
}

