/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.EquipmentLoader;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.CameraAction;
import com.wovoe.carpark.equipment.driver.ZSRGCameraAction;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.RefreshPresenceRecordEvent;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.CarparkMainLayerPanel;
import com.wovoe.carpark.gui.login.MainPassRecordPanel;
import com.wovoe.carpark.gui.login.MainPresenceRecordPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.gui.util.CarparkGuiUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MainCameraMontitorPanel
extends JPanel
implements CarparkMainLayerPanel,
CarparkEventListener,
ActionListener {
    private static final long serialVersionUID = -4815968701310553901L;
    private JPanel bodyPanel;
    private Dimension bodySize;
    private CarparkMainFrame mainFrame;
    private MainPassRecordPanel passRecordPanel;
    private MainPresenceRecordPanel presenceRecordPanel;
    private volatile boolean initedPassRecordPanelData = false;
    private JPanel cameraPanel;
    private Dimension cameraPanelSize;
    private JButton settingButton;
    private ImageIcon buttonicon;
    private static final String cameracofnigFileName = "displayCamera.conf";
    private Properties displayCameraConfig;
    private boolean loadedAllCameras = false;
    private List<VideoCanvas> videoList = new CopyOnWriteArrayList<VideoCanvas>();
    private static Color videoBgColor = Color.decode("#5D5D5D");
    private volatile boolean selected = false;
    private JPopupMenu selectCameraTypeMenu;
    private volatile boolean inited = false;
    private volatile ScheduledFuture<?> delayStopPlay;

    public MainPresenceRecordPanel getPresenceRecordPanel() {
        return this.presenceRecordPanel;
    }

    public MainPassRecordPanel getMainPassRecordPanel() {
        return this.passRecordPanel;
    }

    @Override
    public void init(Dimension size, CarparkMainFrame frame) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.mainFrame = frame;
        this.setLayout(new XYLayout());
        int x = 1;
        int y = 1;
        int width = size.width - 2 * x;
        int height = size.height - 2 * y;
        this.bodyPanel = frame.createRoundPanel();
        this.bodyPanel.setLayout(new XYLayout());
        this.bodyPanel.setBackground(Color.WHITE);
        this.add((Component)this.bodyPanel, new XYConstraints(x, y, width, height));
        this.bodySize = new Dimension(width, height);
        int marginLeft = (int)Math.round(frame.getRootSize().getWidth() * 10.0 / 1024.0);
        int lineY = (int)Math.round(this.bodySize.getHeight() * 347.0 / 609.0);
        int lineX = marginLeft;
        int lineWidth = this.bodySize.width - 2 * marginLeft;
        int lineHeight = (int)Math.round(this.bodySize.getHeight() * 1.0 / 609.0);
        if (lineHeight <= 0) {
            lineHeight = 1;
        }
        JPanel linePanel = new JPanel();
        linePanel.setBackground(Color.decode("#DBDBDB"));
        this.bodyPanel.add((Component)linePanel, new XYConstraints(lineX, lineY, lineWidth, lineHeight));
        int dHeight = size.height - lineY - lineHeight;
        int rplamarginTop = (int)Math.round(this.bodySize.getHeight() * 8.0 / 609.0);
        int xlineWidth = lineHeight;
        int xlineX = (this.bodySize.width - xlineWidth) / 2;
        int xlineHeight = dHeight - 2 * rplamarginTop;
        int xlineY = lineY + lineHeight + rplamarginTop;
        JPanel linePanel0 = new JPanel();
        linePanel0.setBackground(linePanel.getBackground());
        this.bodyPanel.add((Component)linePanel0, new XYConstraints(xlineX, xlineY, xlineWidth, xlineHeight));
        int bottomLeftWidth = xlineX - 2 * lineX;
        int bootemLeftHegiht = xlineHeight;
        Dimension bottomPanelHalfSize = new Dimension(bottomLeftWidth, bootemLeftHegiht);
        this.passRecordPanel = new MainPassRecordPanel();
        this.passRecordPanel.setBackground(this.bodyPanel.getBackground());
        int leftPx = lineX;
        int leftPy = xlineY;
        this.bodyPanel.add((Component)this.passRecordPanel, new XYConstraints(leftPx, leftPy, bottomLeftWidth, bootemLeftHegiht));
        this.passRecordPanel.init(bottomPanelHalfSize, frame);
        this.passRecordPanel.onDisSelect();
        this.presenceRecordPanel = new MainPresenceRecordPanel();
        this.presenceRecordPanel.setBackground(this.bodyPanel.getBackground());
        int rightPx = xlineX + xlineWidth + lineX;
        this.bodyPanel.add((Component)this.presenceRecordPanel, new XYConstraints(rightPx, leftPy, bottomLeftWidth, bootemLeftHegiht));
        this.presenceRecordPanel.init(bottomPanelHalfSize, frame);
        this.presenceRecordPanel.onDisSelect();
        this.presenceRecordPanel.reload();
        boolean clientServer = this.isClientServer();
        int cameraPanelLeft = marginLeft;
        int cameraPanelRight = marginLeft;
        int cameraPanelTop = rplamarginTop;
        if (clientServer) {
            cameraPanelTop = cameraPanelRight;
        }
        int cameraPanelBottom = rplamarginTop;
        int cameraPanelX = marginLeft;
        int cameraPanelY = cameraPanelTop;
        int cameraPanelW = width - cameraPanelLeft - cameraPanelRight;
        int cameraPanelH = lineY - cameraPanelTop - cameraPanelBottom;
        this.cameraPanel = new JPanel();
        this.bodyPanel.add((Component)this.cameraPanel, new XYConstraints(cameraPanelX, cameraPanelY, cameraPanelW, cameraPanelH));
        this.cameraPanel.setBackground(this.bodyPanel.getBackground());
        this.cameraPanelSize = new Dimension(cameraPanelW, cameraPanelH);
        if (clientServer) {
            int picY = 3;
            int maxPicHeight = cameraPanelTop - picY - 1;
            int picHeight = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
            if (picHeight > maxPicHeight) {
                picHeight = maxPicHeight;
            }
            int picWidth = picHeight;
            int xw = 3 + (int)Math.round(frame.getRootSize().getHeight() * 1.0 / 768.0);
            int picX = width - xw - picWidth;
            this.buttonicon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("settings"), picWidth, picHeight));
            this.settingButton = SwingUtil.createImageButton(this.buttonicon, null);
            this.settingButton.setRolloverEnabled(false);
            this.settingButton.setActionCommand("settingCameraTypeButton");
            this.bodyPanel.add((Component)this.settingButton, new XYConstraints(picX, xw, picWidth, picHeight));
            this.settingButton.addActionListener(this);
            this.displayCameraConfig = ServiceUtil.getServiceContext().readLocalRuntimeData("gui", cameracofnigFileName, cameracofnigFileName);
            this.settingButton.setToolTipText("<html>\u70b9\u51fb\u8bbe\u7f6e<br>\u64ad\u653e\u8f66\u573a\u6240\u6709\u901a\u9053\u76d1\u63a7\u89c6\u9891<br>\u8fd8\u662f\u672c\u673a\u7ba1\u7406\u901a\u9053\u89c6\u9891<html>");
            this.selectCameraTypeMenu = new JPopupMenu();
            this.selectCameraTypeMenu.setBorder(BorderFactory.createLineBorder(new Color(209, 217, 222)));
            int itemFontSize = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 13.0 / 768.0);
            Font itemFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
            char serl = '\u221a';
            String a = this.displayCameraConfig.getProperty("a");
            if (a == null || !Constants.YES_STR.equals(a) && !Constants.NO_STR.equals(a)) {
                a = Constants.NO_STR;
                this.displayCameraConfig.setProperty("a", a);
            }
            String v1 = "\u663e\u793a\u672c\u673a\u7ba1\u7406\u901a\u9053\u89c6\u9891";
            String v2 = "\u663e\u793a\u8f66\u573a\u6240\u6709\u901a\u9053\u89c6\u9891";
            String selectValue = Constants.YES_STR.equals(a) ? String.valueOf(serl) + " " + v2 : String.valueOf(serl) + " " + v1;
            int itemWidth = SwingUtil.getStringFontSize((String)selectValue, (Font)itemFont).width + 2 * itemFontSize;
            int itemHeight = (int)Math.round(frame.getRootSize().getHeight() * 25.0 / 768.0);
            JMenuItem item1 = new JMenuItem();
            if (!Constants.YES_STR.equals(a)) {
                item1.setText(String.valueOf(serl) + " " + v1);
            } else {
                item1.setText("\u3000" + v1);
            }
            item1.setActionCommand("localMangerCameras");
            item1.addActionListener(this);
            item1.setFont(itemFont);
            item1.setPreferredSize(new Dimension(itemWidth, itemHeight));
            this.selectCameraTypeMenu.add(item1);
            this.selectCameraTypeMenu.addSeparator();
            item1 = new JMenuItem();
            if (Constants.YES_STR.equals(a)) {
                item1.setText(String.valueOf(serl) + " " + v2);
            } else {
                item1.setText("\u3000" + v2);
            }
            item1.setActionCommand("parkAllCameras");
            item1.addActionListener(this);
            item1.setFont(itemFont);
            item1.setPreferredSize(new Dimension(itemWidth, itemHeight));
            this.selectCameraTypeMenu.add(item1);
        }
        boolean needLoadAllCamera = false;
        if (this.isOnlyServer()) {
            needLoadAllCamera = true;
        } else if (clientServer && this.displayCameraConfig != null && Constants.YES_STR.equals(this.displayCameraConfig.getProperty("a", Constants.NO_STR))) {
            needLoadAllCamera = true;
        }
        if (needLoadAllCamera) {
            this.loadedAllCameras = true;
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        EquipmentLoader.loadServerAllCamreaIfParkingServer(false);
                        ServiceUtil.getServiceContext().getDBConfigCache().setNeedTriggerServerCameraChage(true);
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().warn((Object)"", (Throwable)ex);
                    }
                }
            });
        }
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().registerParkingEventListener(this);
    }

    @Override
    public void disSelected() {
        try {
            this.selected = false;
            if (this.presenceRecordPanel != null) {
                this.presenceRecordPanel.onDisSelect();
            }
            if (this.passRecordPanel != null) {
                this.passRecordPanel.onDisSelect();
            }
            if (this.selectCameraTypeMenu != null && this.selectCameraTypeMenu.isVisible()) {
                this.selectCameraTypeMenu.setVisible(false);
            }
            if (this.settingButton != null) {
                this.settingButton.setIcon(null);
            }
        }
        catch (Throwable throwable) {
            ScheduledFuture<?> sh = ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainCameraMontitorPanel.this.delayStopPlay = null;
                            for (VideoCanvas c : MainCameraMontitorPanel.this.videoList) {
                                CameraAction action;
                                Long payingcid;
                                Object obj;
                                Equipment eq;
                                if (c.cameraNo == null || c.cameraNo.length() <= 0 || c.componentid == null || (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(c.cameraNo)) == null || (obj = eq.getEquipmentAction()) == null || !(obj instanceof CameraAction) || (payingcid = (action = (CameraAction)obj).getPlayingComponentID()) == null || payingcid.longValue() != c.componentid.longValue()) continue;
                                action.stopPlay(null);
                            }
                        }
                    });
                }
            }, 10L, TimeUnit.SECONDS);
            this.delayStopPlay = sh;
            throw throwable;
        }
        ScheduledFuture<?> sh = ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new /* invalid duplicate definition of identical inner class */, 10L, TimeUnit.SECONDS);
        this.delayStopPlay = sh;
    }

    @Override
    public void doSelect() {
        try {
            ScheduledFuture<?> sh;
            this.selected = true;
            if (this.settingButton != null) {
                this.settingButton.setIcon(this.buttonicon);
            }
            if (this.presenceRecordPanel != null) {
                this.presenceRecordPanel.onSelect();
            }
            if (this.passRecordPanel != null) {
                this.passRecordPanel.onSelect();
                this.checkIsInitData();
            }
            if ((sh = this.delayStopPlay) != null) {
                sh.cancel(true);
                this.delayStopPlay = null;
            }
        }
        finally {
            this.initVideoPanel();
        }
    }

    private void initVideoPanel() {
        boolean reset;
        int camreaCount;
        int[] rowCloCount;
        int videoCanvasCount;
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        boolean showRGCamera = "1".equals(ServiceUtil.getServiceContext().getConfig().getProperty("rg.camera.first", "0"));
        if (showRGCamera) {
            List<String> chs;
            HashSet<String> rgSet = new HashSet<String>();
            LinkedList<Equipment> zls = new LinkedList<Equipment>();
            for (Equipment eq : eqs) {
                if (!(eq.getEquipmentAction() instanceof ZSRGCameraAction)) continue;
                zls.add(eq);
                chs = eq.getChannelNos();
                if (chs == null || chs.isEmpty()) continue;
                rgSet.add(chs.get(0));
            }
            for (Equipment eq : eqs) {
                if (eq.getEquipmentAction() instanceof ZSRGCameraAction) continue;
                chs = eq.getChannelNos();
                if (chs != null && !chs.isEmpty()) {
                    if (rgSet.contains(chs.get(0))) continue;
                    zls.add(eq);
                    continue;
                }
                zls.add(eq);
            }
            eqs = zls;
        }
        if ((videoCanvasCount = (rowCloCount = this.getRowCloCount(camreaCount = eqs == null ? 0 : eqs.size()))[0] * rowCloCount[1]) != this.videoList.size()) {
            reset = true;
            this.resetCameraPanel(eqs, rowCloCount);
            if (eqs == null || eqs.isEmpty()) {
                return;
            }
        } else {
            OperationFuture<Integer> op;
            CameraAction action;
            Long payingcid;
            Object obj;
            Equipment eq;
            reset = false;
            if (eqs == null || eqs.isEmpty()) {
                VideoCanvas c = this.videoList.get(0);
                if (c.cameraNo != null && c.cameraNo.length() > 0) {
                    CameraAction action2;
                    Long payingcid2;
                    Object obj2;
                    Equipment eq2;
                    if (c.componentid != null && (eq2 = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(c.cameraNo)) != null && (obj2 = eq2.getEquipmentAction()) != null && obj2 instanceof CameraAction && (payingcid2 = (action2 = (CameraAction)obj2).getPlayingComponentID()) != null && payingcid2.longValue() == c.componentid.longValue()) {
                        OperationFuture<Integer> op2 = action2.stopPlay(null);
                        try {
                            if (action2.isWorkingProperly()) {
                                op2.get(1500L, TimeUnit.MILLISECONDS);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    c.cameraNo = null;
                }
                c.setMessage(this.getNoMangerString());
                return;
            }
            HashMap<String, VideoCanvas> cavlMap = new HashMap<String, VideoCanvas>();
            LinkedList<VideoCanvas> noVideloList = new LinkedList<VideoCanvas>();
            for (VideoCanvas v1 : this.videoList) {
                if (v1.cameraNo != null && v1.cameraNo.length() > 0) {
                    cavlMap.put(v1.cameraNo, v1);
                    continue;
                }
                noVideloList.add(v1);
            }
            LinkedList<Equipment> needRestList = new LinkedList<Equipment>();
            for (Equipment e : eqs) {
                VideoCanvas v = (VideoCanvas)cavlMap.remove(e.getEquipmentNo());
                if (v != null) continue;
                needRestList.add(e);
            }
            int remainsize = cavlMap.size() + noVideloList.size();
            if (remainsize > 0 && !needRestList.isEmpty()) {
                Equipment eq0;
                Collections.sort(needRestList, new Comparator<Equipment>(){

                    @Override
                    public int compare(Equipment o1, Equipment o2) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        if (name1 == null) {
                            name1 = "";
                        }
                        if (name2 == null) {
                            name2 = "";
                        }
                        return name1.compareTo(name2);
                    }
                });
                if (cavlMap.size() > 0) {
                    for (VideoCanvas c : cavlMap.values()) {
                        if (c.cameraNo != null && c.cameraNo.length() > 0) {
                            if (c.componentid != null && (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(c.cameraNo)) != null && (obj = eq.getEquipmentAction()) != null && obj instanceof CameraAction && (payingcid = (action = (CameraAction)obj).getPlayingComponentID()) != null && payingcid.longValue() == c.componentid.longValue()) {
                                op = action.stopPlay(null);
                                try {
                                    if (action.isWorkingProperly()) {
                                        op.get(1500L, TimeUnit.MILLISECONDS);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            c.cameraNo = null;
                        }
                        if ((eq0 = (Equipment)needRestList.poll()) == null) continue;
                        c.cameraNo = eq0.getEquipmentNo();
                    }
                }
                if (noVideloList.size() > 0 && !needRestList.isEmpty()) {
                    for (VideoCanvas c : noVideloList) {
                        eq0 = (Equipment)needRestList.poll();
                        if (eq0 == null) continue;
                        c.cameraNo = eq0.getEquipmentNo();
                    }
                }
            } else if (cavlMap.size() > 0 && needRestList.isEmpty()) {
                for (VideoCanvas c : cavlMap.values()) {
                    if (c.cameraNo == null || c.cameraNo.length() <= 0) continue;
                    if (c.componentid != null && (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(c.cameraNo)) != null && (obj = eq.getEquipmentAction()) != null && obj instanceof CameraAction && (payingcid = (action = (CameraAction)obj).getPlayingComponentID()) != null && payingcid.longValue() == c.componentid.longValue()) {
                        op = action.stopPlay(null);
                        try {
                            if (action.isWorkingProperly()) {
                                op.get(1500L, TimeUnit.MILLISECONDS);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    c.cameraNo = null;
                }
            }
        }
        if (!reset) {
            for (VideoCanvas v : this.videoList) {
                if (v.cameraNo != null && v.cameraNo.length() > 0) {
                    Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(v.cameraNo);
                    if (eq != null) {
                        CameraAction action;
                        Object obj = eq.getEquipmentAction();
                        if (obj == null || !(obj instanceof CameraAction) || (action = (CameraAction)obj).isWorkingProperly() && action.getPlayingComponentID() != null) continue;
                        v.setMessage("\u89c6\u9891\u52a0\u8f7d\u4e2d...");
                        continue;
                    }
                    v.setMessage("\u65e0\u89c6\u9891");
                    continue;
                }
                v.setMessage("\u65e0\u89c6\u9891");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!MainCameraMontitorPanel.this.selected) {
                    return;
                }
                for (VideoCanvas v : MainCameraMontitorPanel.this.videoList) {
                    Object obj;
                    Equipment eq;
                    if (v.componentid == null) {
                        v.componentid = CarparkGuiUtil.getComponentID(v);
                    }
                    if (v.cameraNo == null || v.cameraNo.length() <= 0 || v.componentid == null || (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(v.cameraNo)) == null || (obj = eq.getEquipmentAction()) == null || !(obj instanceof CameraAction)) continue;
                    CameraAction action = (CameraAction)obj;
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("componentID", v.componentid);
                    action.play(param);
                }
            }
        });
    }

    private void resetCameraPanel(Collection<Equipment> cameraList, int[] rowCloCount) {
        if (!this.videoList.isEmpty()) {
            LinkedList<OperationFuture<Integer>> needWaitOpList = null;
            for (VideoCanvas v : this.videoList) {
                CameraAction action;
                Long payingcid;
                Object obj;
                Equipment eq;
                if (v.componentid == null || v.cameraNo == null || v.cameraNo.length() <= 0 || (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(v.cameraNo)) == null || (obj = eq.getEquipmentAction()) == null || !(obj instanceof CameraAction) || (payingcid = (action = (CameraAction)obj).getPlayingComponentID()) == null || payingcid.longValue() != v.componentid.longValue()) continue;
                OperationFuture<Integer> operationFuture = action.stopPlay(null);
                if (!action.isWorkingProperly()) continue;
                if (needWaitOpList == null) {
                    needWaitOpList = new LinkedList<OperationFuture<Integer>>();
                }
                needWaitOpList.add(operationFuture);
            }
            if (needWaitOpList != null && !needWaitOpList.isEmpty()) {
                long v = 3000L;
                long maxWaitTimeMills = ServiceUtil.getServiceContext().currentTimeMillis() + v;
                for (OperationFuture operationFuture : needWaitOpList) {
                    long z = maxWaitTimeMills - ServiceUtil.getServiceContext().currentTimeMillis();
                    if (z <= 0L) break;
                    try {
                        operationFuture.get(z, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.videoList.clear();
        }
        this.cameraPanel.removeAll();
        if (cameraList == null || cameraList.isEmpty()) {
            this.cameraPanel.setLayout(new GridLayout(1, 1));
            int fontSize = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 16.0 / 768.0);
            Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
            VideoCanvas c = new VideoCanvas(font, videoBgColor, this.cameraPanelSize.width, this.cameraPanelSize.height);
            c.setMessage(this.getNoMangerString());
            c.disCont = 2;
            this.cameraPanel.add(c);
            this.videoList.add(c);
        } else {
            PriorityQueue<Equipment> qe = new PriorityQueue<Equipment>(cameraList.size(), new Comparator<Equipment>(){

                @Override
                public int compare(Equipment o1, Equipment o2) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    if (name1 == null) {
                        name1 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    return name1.compareTo(name2);
                }
            });
            for (Equipment e : cameraList) {
                qe.offer(e);
            }
            int videoCanvasCount = rowCloCount[0] * rowCloCount[1];
            int grap = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 1.0 / 768.0);
            this.cameraPanel.setLayout(new GridLayout(rowCloCount[0], rowCloCount[1], grap, grap));
            int avgW = (this.cameraPanelSize.width - grap * (rowCloCount[1] - 1)) / rowCloCount[1];
            int avgH = (this.cameraPanelSize.height - grap * (rowCloCount[0] - 1)) / rowCloCount[0];
            int base = videoCanvasCount <= 4 ? 16 : (videoCanvasCount <= 8 ? 14 : (videoCanvasCount <= 16 ? 12 : 11));
            int n = (int)Math.round(this.mainFrame.getRootSize().getHeight() * (double)base / 768.0);
            Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, n);
            int i = 0;
            while (i < videoCanvasCount) {
                Equipment camera = qe.poll();
                VideoCanvas c = new VideoCanvas(font, videoBgColor, avgW, avgH);
                this.cameraPanel.add(c);
                this.videoList.add(c);
                if (camera != null) {
                    c.cameraNo = camera.getEquipmentNo();
                    c.setMessage("\u89c6\u9891\u52a0\u8f7d\u4e2d...");
                } else {
                    c.setMessage("\u65e0\u89c6\u9891");
                }
                c.disCont = 2;
                ++i;
            }
        }
        this.cameraPanel.updateUI();
    }

    private String getNoMangerString() {
        boolean needLoadAllCamera = false;
        if (this.isOnlyServer()) {
            needLoadAllCamera = true;
        } else if (this.isClientServer() && this.displayCameraConfig != null && Constants.YES_STR.equals(this.displayCameraConfig.getProperty("a", Constants.NO_STR))) {
            needLoadAllCamera = true;
        }
        if (needLoadAllCamera) {
            return "\u8f66\u573a\u8fd8\u672a\u914d\u7f6e\u51fa\u5165\u53e3\u76d1\u63a7\u76f8\u673a";
        }
        return "\u672c\u673a\u8fd8\u672a\u914d\u7f6e\u51fa\u5165\u53e3\u76d1\u63a7\u76f8\u673a";
    }

    private int[] getRowCloCount(int size) {
        if (size <= 1) {
            return new int[]{1, 1};
        }
        if (size == 2) {
            return new int[]{1, 2};
        }
        if (size == 3 || size == 4) {
            return new int[]{2, 2};
        }
        if (size == 5 || size == 6) {
            return new int[]{2, 3};
        }
        if (size == 7 || size == 8) {
            return new int[]{2, 4};
        }
        if (size == 9) {
            return new int[]{3, 3};
        }
        if (size == 10) {
            return new int[]{2, 5};
        }
        if (size == 11 || size == 12) {
            return new int[]{3, 4};
        }
        if (size == 13 || size == 14 || size == 15) {
            return new int[]{3, 5};
        }
        if (size == 16) {
            return new int[]{4, 4};
        }
        if (size == 17 || size == 18) {
            return new int[]{3, 6};
        }
        if (size == 19 || size == 20) {
            return new int[]{4, 5};
        }
        return new int[]{4, 6};
    }

    private void checkIsInitData() {
        if (!this.initedPassRecordPanelData) {
            this.initedPassRecordPanelData = true;
            if (this.passRecordPanel.getLastDisplayRecord() == null) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SearchParam p = new SearchParam();
                            if (MainCameraMontitorPanel.this.isOnlyClient()) {
                                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                                    LinkedList<String> list = new LinkedList<String>();
                                    Enumeration<PassChannel> cx = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
                                    if (cx != null) {
                                        while (cx.hasMoreElements()) {
                                            PassChannel c = cx.nextElement();
                                            if (!c.isLocalHostChannel()) continue;
                                            list.add(c.getChannelNo());
                                        }
                                    }
                                    if (list.isEmpty()) {
                                        p.addEQ("pass_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                                    } else if (list.size() == 1) {
                                        p.addEQ("pass_channel_no", list.get(0));
                                    } else {
                                        p.addINList("pass_channel_no", list);
                                    }
                                } else {
                                    p.addEQ("pass_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                                }
                            }
                            Calendar cl = Calendar.getInstance();
                            cl.set(14, 0);
                            p.addLTE("pass_time", (Object)cl.getTime());
                            cl.add(2, -2);
                            p.addGTE("pass_time", (Object)cl.getTime());
                            p.setOrerbySql("pass_time DESC ,area_level ASC");
                            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                            Pagination p1 = new Pagination();
                            p1.setNeedQueryCount(false);
                            p1.setGotoPage(1);
                            p1.setPageSize(1);
                            p1.setRecordsCount(1L);
                            CarparkPassRecord record = (CarparkPassRecord)daoService.selectOne(p, CarparkPassRecord.class, p1);
                            if (record != null) {
                                MainCameraMontitorPanel.this.passRecordPanel.setPassRecord(record);
                            }
                        }
                        catch (Exception ex) {
                            GuiLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void onMainWindowDispose() {
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().unRegisterParkingEventListener(this);
        if (this.presenceRecordPanel != null) {
            this.presenceRecordPanel.onMainWindowDispose();
        }
        if (this.selectCameraTypeMenu != null && this.selectCameraTypeMenu.isVisible()) {
            this.selectCameraTypeMenu.setVisible(false);
        }
        if (this.loadedAllCameras) {
            this.loadedAllCameras = false;
            ServiceUtil.getServiceContext().getDBConfigCache().setNeedTriggerServerCameraChage(false);
            EquipmentLoader.unRegisterServerAllCamrea();
        }
    }

    @Override
    public Component getLayerComponent() {
        return this;
    }

    @Override
    public void onClick(String cmd, MouseEvent event) {
    }

    private boolean isClientServer() {
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        int hostUse = localHost == null ? ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use().intValue() : localHost.getHost_use().intValue();
        return hostUse == 3;
    }

    private boolean isOnlyServer() {
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        int hostUse = localHost == null ? ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use().intValue() : localHost.getHost_use().intValue();
        return hostUse == 2;
    }

    private boolean isOnlyClient() {
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        int hostUse = localHost == null ? ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use().intValue() : localHost.getHost_use().intValue();
        return hostUse == 1;
    }

    @Override
    public int[] getIntestEventId() {
        if (this.isOnlyClient()) {
            return new int[]{3324, 5628, 3836};
        }
        return new int[]{5628, 3836};
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (event instanceof LocalPassRecordEvent) {
            LocalPassRecordEvent e = (LocalPassRecordEvent)event;
            if (e.getLocalPassRecord() != null && this.passRecordPanel != null) {
                this.passRecordPanel.setPassRecord(e.getLocalPassRecord());
            }
        } else if (event instanceof PassRecordEvent) {
            PassRecordEvent e;
            if (this.presenceRecordPanel != null) {
                this.presenceRecordPanel.reload();
            }
            if (!this.isOnlyClient() && (e = (PassRecordEvent)event).getPassRecord() != null && this.passRecordPanel != null) {
                this.passRecordPanel.setPassRecord(e.getPassRecord());
            }
        } else if (event instanceof RefreshPresenceRecordEvent && this.presenceRecordPanel != null) {
            this.presenceRecordPanel.reload();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.selected) {
            return;
        }
        String cmd = e.getActionCommand();
        if ("settingCameraTypeButton".equals(cmd)) {
            if (this.selectCameraTypeMenu == null || this.selectCameraTypeMenu.isVisible()) return;
            Component c = (Component)e.getSource();
            this.selectCameraTypeMenu.show(c, c.getWidth(), c.getHeight());
            return;
        } else if ("localMangerCameras".equals(cmd)) {
            String a = this.displayCameraConfig.getProperty("a", Constants.NO_STR);
            if (!Constants.YES_STR.equals(a)) return;
            int count = this.selectCameraTypeMenu.getComponentCount();
            String serl = "\u221a ";
            String bl = "\u3000";
            int i = 0;
            while (i < count) {
                Component c = this.selectCameraTypeMenu.getComponent(i);
                if (c != null && c instanceof JMenuItem) {
                    JMenuItem t = (JMenuItem)c;
                    if (t == e.getSource()) {
                        t.setText(t.getText().replace(bl, serl));
                    } else {
                        t.setText(t.getText().replace(serl, bl));
                    }
                }
                ++i;
            }
            this.displayCameraConfig.setProperty("a", Constants.NO_STR);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile("gui", cameracofnigFileName, cameracofnigFileName, this.displayCameraConfig);
            if (!this.loadedAllCameras) return;
            this.loadedAllCameras = false;
            ServiceUtil.getServiceContext().getDBConfigCache().setNeedTriggerServerCameraChage(false);
            EquipmentLoader.unRegisterServerAllCamrea();
            this.initVideoPanel();
            return;
        } else {
            if (!"parkAllCameras".equals(cmd)) return;
            String a = this.displayCameraConfig.getProperty("a", Constants.NO_STR);
            if (Constants.YES_STR.equals(a)) {
                return;
            }
            int count = this.selectCameraTypeMenu.getComponentCount();
            String serl = "\u221a ";
            String bl = "\u3000";
            int i = 0;
            while (i < count) {
                Component c = this.selectCameraTypeMenu.getComponent(i);
                if (c != null && c instanceof JMenuItem) {
                    JMenuItem t = (JMenuItem)c;
                    if (t == e.getSource()) {
                        t.setText(t.getText().replace(bl, serl));
                    } else {
                        t.setText(t.getText().replace(serl, bl));
                    }
                }
                ++i;
            }
            this.displayCameraConfig.setProperty("a", Constants.YES_STR);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile("gui", cameracofnigFileName, cameracofnigFileName, this.displayCameraConfig);
            if (!this.loadedAllCameras) {
                this.loadedAllCameras = true;
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EquipmentLoader.loadServerAllCamreaIfParkingServer(false);
                            ServiceUtil.getServiceContext().getDBConfigCache().setNeedTriggerServerCameraChage(true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (MainCameraMontitorPanel.this.selected) {
                                        MainCameraMontitorPanel.this.initVideoPanel();
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            GuiLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                    }
                });
                return;
            } else {
                this.initVideoPanel();
            }
        }
    }

    private static class VideoCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private Long componentid;
        private String cameraNo;
        private String message;
        private int width;
        private int height;
        private Dimension messageSize;
        private int disCont = 0;

        private VideoCanvas(Font font, Color bgColor, int w, int h) {
            this.setFont(font);
            this.setBackground(bgColor);
            this.setForeground(Color.WHITE);
            this.width = w;
            this.height = h;
        }

        private void setMessage(String message) {
            if (message == null || message.length() == 0) {
                this.messageSize = new Dimension(0, 0);
                this.message = message;
                this.disCont = 0;
            } else {
                if (!message.equals(this.message)) {
                    this.messageSize = SwingUtil.getStringFontSize(message, this.getFont());
                    this.message = message;
                }
                this.disCont = 1;
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.disCont > 0 && this.message != null && this.message.length() > 0) {
                if (this.disCont == 2) {
                    --this.disCont;
                    return;
                }
                --this.disCont;
                if (this.messageSize == null) {
                    this.messageSize = SwingUtil.getStringFontSize(this.message, this.getFont());
                }
                Graphics2D g2 = (Graphics2D)g;
                int x = (this.width - this.messageSize.width) / 2;
                int y = (this.height - this.messageSize.height) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                g2.drawString(this.message, x, y);
            }
        }
    }
}

