/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.HostEquipmentSateManager;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.RoundBorder;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.CarparkMainLayerPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.KeyValueEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainEqStateMonitorPanel
extends JPanel
implements CarparkMainLayerPanel,
Runnable {
    private static final long serialVersionUID = -7758078947131382050L;
    private CarparkMainFrame mainFrame;
    private volatile boolean selected = false;
    private JPanel bodyPanel;
    private Dimension bodySize;
    private ScheduledFuture<?> refreshHandler;
    private Map<String, HostEntry> currentDisplayMap = new LinkedHashMap<String, HostEntry>();
    private Map<String, ImageIcon> imageIconMap = new Hashtable<String, ImageIcon>();
    private JPanel contentPanel;
    private Dimension contentPanelSize;
    private JScrollPane scrollPane;
    private XYConstraints defaultSateXYCons;
    private Font font13;
    private Font font12;
    private Color lineColor = Color.decode("#DBDBDB");
    private List<HostPanel> hostPanelList;
    private Color normalColor = Color.decode("#222222");
    private Color errColor = Color.decode("#e2175b");

    @Override
    public void init(Dimension size, CarparkMainFrame frame) {
        this.mainFrame = frame;
        this.setLayout(new XYLayout());
        int x = 1;
        int y = 1;
        int width = size.width - 2 * x;
        int height = size.height - 2 * y;
        this.bodyPanel = frame.createRoundPanel();
        this.bodyPanel.setBackground(Color.WHITE);
        this.bodyPanel.setLayout(new XYLayout());
        this.add((Component)this.bodyPanel, new XYConstraints(x, y, width, height));
        this.bodySize = new Dimension(width, height);
        int marginTop = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 25.0 / 768.0);
        int marginBottom = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 25.0 / 768.0);
        int marginLeft = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 25.0 / 768.0);
        int marginRight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 8.0 / 768.0);
        this.contentPanel = new JPanel(new XYLayout());
        this.contentPanel.setBackground(this.bodyPanel.getBackground());
        this.scrollPane = new JScrollPane(this.contentPanel, 20, 31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setBackground(this.contentPanel.getBackground());
        int contentWidth = this.bodySize.width - marginLeft - marginRight;
        int contentHeight = this.bodySize.height - marginTop - marginBottom;
        int satePanelY = 0;
        int satePanelX = 0;
        int sateMarginRight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 18.0 / 768.0);
        int satePanelWidth = contentWidth - sateMarginRight;
        int satePanelHeight = contentHeight;
        this.defaultSateXYCons = new XYConstraints(satePanelX, satePanelY, satePanelWidth, satePanelHeight);
        this.contentPanelSize = new Dimension(contentWidth, contentHeight);
        this.bodyPanel.add((Component)this.scrollPane, new XYConstraints(marginLeft, marginTop, contentWidth, contentHeight));
        this.scrollPane.setPreferredSize(this.contentPanelSize);
        this.contentPanel.setPreferredSize(this.contentPanelSize);
        if (this.refreshHandler == null) {
            this.refreshHandler = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(this, 10000L, 5000L, TimeUnit.MILLISECONDS);
        }
        int font13Size = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 13.0 / 768.0);
        int font12Size = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 12.0 / 768.0);
        this.font13 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font13Size);
        this.font12 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font12Size);
    }

    private void initSateMoniterPanel(Map<String, HostEntry> dataMap, JPanel stateMonitorPanel) {
        if (dataMap == null || dataMap.size() == 0) {
            this.hostPanelList = new ArrayList<HostPanel>(0);
            stateMonitorPanel.setPreferredSize(new Dimension(this.defaultSateXYCons.getWidth(), this.defaultSateXYCons.getHeight()));
            return;
        }
        this.hostPanelList = new ArrayList<HostPanel>(dataMap.size());
        int totalWidth = this.defaultSateXYCons.getWidth();
        int hostMarginTop = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 25.0 / 768.0);
        int hostY = 0;
        int hostX = 0;
        int hostIndex = 0;
        for (HostEntry entry : dataMap.values()) {
            if (hostIndex > 0) {
                hostY += hostMarginTop;
            }
            HostPanel hostPanel = new HostPanel(entry, totalWidth);
            this.hostPanelList.add(hostPanel);
            Dimension hostSize = hostPanel.hPanel.getPreferredSize();
            stateMonitorPanel.add((Component)hostPanel.hPanel, new XYConstraints(hostX, hostY, hostSize.width, hostSize.height));
            hostY += hostSize.height;
            ++hostIndex;
        }
        stateMonitorPanel.setPreferredSize(new Dimension(totalWidth, hostY));
    }

    private ImageIcon getHostIcon(boolean connected) {
        String name = connected ? "ic_computer" : "ic_computer_fault";
        return this.getImageIcon(name);
    }

    private ImageIcon getImageIcon(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ImageIcon icon = this.imageIconMap.get(name);
        if (icon != null) {
            return icon;
        }
        if (this.imageIconMap.containsKey(name)) {
            return null;
        }
        Image img = CarparkGuiSkinUtil.getCarparkGuiSkin().newImage(name);
        if (img == null) {
            this.imageIconMap.put(name, null);
            return null;
        }
        int iconWidthHeight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 20.0 / 768.0);
        icon = new ImageIcon(SwingUtil.resizeImage(img, iconWidthHeight, iconWidthHeight));
        this.imageIconMap.put(name, icon);
        return icon;
    }

    private void reInitPanel(Map<String, HostEntry> dataMap) {
        int y;
        this.contentPanel.removeAll();
        JPanel stateMonitorPanel = new JPanel(new XYLayout());
        stateMonitorPanel.setBackground(this.contentPanel.getBackground());
        this.initSateMoniterPanel(dataMap, stateMonitorPanel);
        Dimension d = stateMonitorPanel.getPreferredSize();
        int x = (this.defaultSateXYCons.getWidth() - d.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = (this.defaultSateXYCons.getHeight() - d.height) / 2) < 0) {
            y = 0;
        }
        this.contentPanel.add((Component)stateMonitorPanel, new XYConstraints(x, y, d.width, d.height));
        if (d.height > this.defaultSateXYCons.getHeight()) {
            this.contentPanel.setPreferredSize(new Dimension(this.contentPanelSize.width, d.height));
        } else {
            this.contentPanel.setPreferredSize(this.contentPanelSize);
        }
        this.setData(dataMap);
        this.contentPanel.updateUI();
    }

    private void setData(Map<String, HostEntry> dataMap) {
        List<HostPanel> hostPanelList = this.hostPanelList;
        if (hostPanelList != null && !hostPanelList.isEmpty()) {
            for (HostPanel p : hostPanelList) {
                HostEntry hostEntry = dataMap.get(p.hostNo);
                if (hostEntry == null) continue;
                ImageIcon hostIcon = this.getHostIcon(hostEntry.connected);
                Icon oldhostIcon = p.hostInfoLabel.getIcon();
                if (oldhostIcon != hostIcon) {
                    p.hostInfoLabel.setIcon(hostIcon);
                }
                char split = '\uff0c';
                StringBuilder hostInfo = new StringBuilder(128);
                if (hostEntry.host.getHost_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
                    hostInfo.append("\u672c\u673a");
                } else {
                    if (hostEntry.host.getHost_use() == 1) {
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
                            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 2) {
                                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
                                    hostInfo.append("\u3010\u670d\u52a1\u5668\u4ee3\u7406\u3011");
                                }
                                if (hostEntry.host.getNet_mode() != null && hostEntry.host.getNet_mode() == 2) {
                                    hostInfo.append("(\u4e92\u8054\u7f51)");
                                } else {
                                    hostInfo.append("(\u5c40\u57df\u7f51)");
                                }
                            } else if (hostEntry.host.getNet_mode() != null && hostEntry.host.getNet_mode() == 2) {
                                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
                                    hostInfo.append("\u3010\u670d\u52a1\u5668\u4ee3\u7406\u3011(\u4e92\u8054\u7f51)");
                                } else {
                                    hostInfo.append("(\u4e92\u8054\u7f51)");
                                }
                            } else {
                                hostInfo.append("\u3010\u5c40\u57df\u7f51\u3011");
                            }
                        } else if (hostEntry.host.getNet_mode() != null && hostEntry.host.getNet_mode() == 2) {
                            hostInfo.append("\u3010\u4e92\u8054\u7f51\u3011");
                        } else {
                            hostInfo.append("\u3010\u5c40\u57df\u7f51\u3011");
                        }
                    } else if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 2) {
                            hostInfo.append("\u3010\u4e92\u8054\u7f51\u3011");
                        } else {
                            hostInfo.append("\u3010\u5c40\u57df\u7f51\u3011");
                        }
                    }
                    hostInfo.append(hostEntry.connected ? "\u5df2\u8fde\u63a5" : "\u672a\u8fde\u63a5");
                }
                if (hostEntry.host.getHost_use() == 1) {
                    if (hostEntry.host.getNet_mode() != null && hostEntry.host.getNet_mode() == 2) {
                        InetSocketAddress address;
                        CarparkUdpClient client;
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1 && (client = CarparkUdpClientManager.getInstance().getCarparkUdpClient(hostEntry.host.getHost_no())) != null && client.isConnected() && (address = client.getClientAddress()) != null) {
                            try {
                                hostInfo.append(split).append('[').append(address).append(']');
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        hostInfo.append(split).append(hostEntry.host.getHost_ip()).append(':').append(hostEntry.host.getHost_port());
                    }
                } else {
                    hostInfo.append(split).append(hostEntry.host.getHost_ip()).append(':').append(hostEntry.host.getHost_port());
                }
                hostInfo.append(split).append(hostEntry.host.getHost_name());
                hostInfo.append(split);
                if (hostEntry.host.getHost_use() == 1) {
                    hostInfo.append("\u5c97\u4ead\u5ba2\u6237\u7aef");
                } else if (hostEntry.host.getHost_use() == 2) {
                    if (hostEntry.host.getHost_type() == 2) {
                        hostInfo.append("\u4e91\u670d\u52a1\u5668");
                    } else {
                        hostInfo.append("\u672c\u5730\u670d\u52a1\u5668");
                    }
                } else if (hostEntry.host.getHost_use() == 3) {
                    hostInfo.append("\u5c97\u4ead\u670d\u52a1\u5668");
                }
                String hostInfoStr = hostInfo.toString();
                if (!hostInfoStr.equals(p.hostInfoLabel.getText())) {
                    p.hostInfoLabel.setText(hostInfoStr);
                }
                Color hostcl = hostEntry.connected ? this.normalColor : this.errColor;
                Color oldhostcl = p.hostInfoLabel.getForeground();
                if (oldhostcl == null || !oldhostcl.equals(hostcl)) {
                    p.hostInfoLabel.setForeground(hostcl);
                }
                if (p.channelPanelList == null || p.channelPanelList.isEmpty() || hostEntry.channelMap == null || hostEntry.channelMap.isEmpty()) continue;
                for (ChannelPanel channelPanel : p.channelPanelList) {
                    String channelInfoStr;
                    Color channelOldColor;
                    ChannelEentry channelEntry = (ChannelEentry)hostEntry.channelMap.get(channelPanel.channelNo);
                    if (channelEntry == null) continue;
                    StringBuilder sba = new StringBuilder(64);
                    sba.append(channelEntry.channel.getChannel_name());
                    Color cs = hostcl;
                    if (channelEntry.proxyManagerHost != null) {
                        sba.append(split).append("\u6258\u7ba1\u4e3b\u673a\uff1a").append(channelEntry.proxyManagerHost.getHost_name()).append('[').append(channelEntry.proxyManagerHost.getHost_ip()).append(']');
                        cs = this.normalColor;
                    }
                    if ((channelOldColor = channelPanel.titleLabel.getForeground()) == null || !channelOldColor.equals(cs)) {
                        channelPanel.titleLabel.setForeground(cs);
                    }
                    if (!(channelInfoStr = sba.toString()).equals(channelPanel.titleLabel.getText())) {
                        channelPanel.titleLabel.setText(channelInfoStr);
                    }
                    if (channelPanel.eqLabelList == null || channelPanel.eqLabelList.isEmpty()) continue;
                    ArrayList eqList = channelEntry.eqList;
                    if (eqList == null) {
                        eqList = new ArrayList(0);
                    }
                    int i = 0;
                    while (i < channelPanel.eqLabelList.size()) {
                        KeyValueEntry enryLabel = (KeyValueEntry)channelPanel.eqLabelList.get(i);
                        if (i < eqList.size()) {
                            String eqName;
                            Icon oldEqIcon;
                            String iconName;
                            ImageIcon eqIcon;
                            EqEntry eqEntry = (EqEntry)eqList.get(i);
                            EquipmentState s = eqEntry.eqState;
                            if (s == null) {
                                s = EquipmentState.DISCONNECTED;
                            }
                            if ((eqIcon = this.getImageIcon(iconName = "eq_" + eqEntry.eqVo.getEquipment_type() + "_" + s.name())) != (oldEqIcon = ((JLabel)enryLabel.getKey()).getIcon())) {
                                ((JLabel)enryLabel.getKey()).setIcon(eqIcon);
                            }
                            Color eqFontc = s == EquipmentState.DISCONNECTED ? this.errColor : this.normalColor;
                            Color oldEqFontC = ((JLabel)enryLabel.getValue()).getForeground();
                            if (oldEqFontC == null || !oldEqFontC.equals(eqFontc)) {
                                ((JLabel)enryLabel.getValue()).setForeground(eqFontc);
                            }
                            if (((eqName = eqEntry.eqVo.getEquipment_ip()) == null || eqName.length() == 0) && (eqName = eqEntry.eqVo.getEquipment_name()) == null) {
                                eqName = "";
                            }
                            if (!eqName.equals(((JLabel)enryLabel.getValue()).getText())) {
                                ((JLabel)enryLabel.getValue()).setText(eqName);
                            }
                        } else {
                            ((JLabel)enryLabel.getKey()).setIcon(null);
                            ((JLabel)enryLabel.getValue()).setText(null);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void refresh(Map<String, HostEntry> dataMap) {
        try {
            if (!dataMap.equals(this.currentDisplayMap)) {
                this.reInitPanel(dataMap);
            } else {
                this.setData(dataMap);
            }
        }
        finally {
            this.currentDisplayMap = dataMap;
        }
    }

    @Override
    public void disSelected() {
        this.selected = false;
        this.contentPanel.removeAll();
        this.contentPanel.setPreferredSize(this.contentPanelSize);
        this.contentPanel.updateUI();
        this.currentDisplayMap = new LinkedHashMap<String, HostEntry>();
    }

    @Override
    public void doSelect() {
        this.selected = true;
        this.refresh(this.getDisplayDataMap());
    }

    @Override
    public void onMainWindowDispose() {
        if (this.refreshHandler != null) {
            this.refreshHandler.cancel(true);
            this.refreshHandler = null;
        }
    }

    @Override
    public Component getLayerComponent() {
        return this;
    }

    @Override
    public void onClick(String cmd, MouseEvent event) {
    }

    private Map<String, HostEntry> getDisplayDataMap() {
        LinkedHashMap<String, HostEntry> returnMap = new LinkedHashMap<String, HostEntry>();
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> chanelEqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        HostEquipmentSateManager hostStateManager = ServiceUtil.getServiceContext().getHostEquipmentSateManager();
        HashMap<String, CarparkHost> proxyChannelHostMap = null;
        if (chanelEqMap == null) {
            chanelEqMap = new HashMap<String, List<ChannelEquipmentVo>>();
        }
        if (channelMap == null) {
            channelMap = new HashMap<String, CarparkChannel>();
        }
        if (hostMap != null && !hostMap.isEmpty()) {
            Enumeration<PassChannel> ens;
            for (CarparkHost host : hostMap.values()) {
                List<String> proxyChNos;
                HostEquipmentSate hostEQSate = hostStateManager.getHostEquipmentSate(host.getHost_no());
                if (hostEQSate == null || (proxyChNos = hostEQSate.getProxyChNos()) == null) continue;
                for (String channelNo : proxyChNos) {
                    if (proxyChannelHostMap == null) {
                        proxyChannelHostMap = new HashMap<String, CarparkHost>();
                    }
                    proxyChannelHostMap.put(channelNo, host);
                }
            }
            HashSet<String> slaveHosts = null;
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1 && (ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
                while (ens.hasMoreElements()) {
                    String x;
                    PassChannel p = ens.nextElement();
                    if (!p.isLocalHostChannel() || (x = p.getChannel().getSlave_managed_host_no()) == null || x.length() <= 0) continue;
                    if (slaveHosts == null) {
                        slaveHosts = new HashSet<String>();
                    }
                    slaveHosts.add(x);
                }
            }
            for (CarparkHost host : hostMap.values()) {
                HostEntry hostEntry = new HostEntry();
                hostEntry.host_no = host.getHost_no();
                hostEntry.host = host;
                hostEntry.channelMap = new LinkedHashMap();
                if (slaveHosts != null && slaveHosts.contains(host.getHost_no())) {
                    hostEntry.connected = ServiceUtil.getServiceContext().isConected(hostEntry.host_no);
                } else {
                    hostEntry.connected = ServiceUtil.getServiceContext().isHostOnline(hostEntry.host_no);
                }
                returnMap.put(hostEntry.host_no, hostEntry);
                for (CarparkChannel ch : channelMap.values()) {
                    if (ch.getManaged_host_no() != null && ch.getManaged_host_no().equals(hostEntry.host_no)) {
                        this.setHostEntry(hostEntry, ch, proxyChannelHostMap, chanelEqMap);
                        continue;
                    }
                    if (ch.getSlave_managed_host_no() == null || !ch.getSlave_managed_host_no().equals(hostEntry.host_no)) continue;
                    this.setHostEntry(hostEntry, ch, proxyChannelHostMap, chanelEqMap);
                }
            }
        }
        return returnMap;
    }

    private void setHostEntry(HostEntry hostEntry, CarparkChannel ch, Map<String, CarparkHost> proxyChannelHostMap, Map<String, List<ChannelEquipmentVo>> chanelEqMap) {
        ChannelEentry channelEntry = new ChannelEentry();
        channelEntry.channel = ch;
        channelEntry.channel_no = ch.getChannel_no();
        if (proxyChannelHostMap != null) {
            channelEntry.proxyManagerHost = proxyChannelHostMap.get(channelEntry.channel_no);
        }
        hostEntry.channelMap.put(channelEntry.channel_no, channelEntry);
        List<ChannelEquipmentVo> eqList = chanelEqMap.get(channelEntry.channel_no);
        if (eqList == null || eqList.isEmpty()) {
            channelEntry.eqList = new ArrayList(0);
        } else {
            channelEntry.eqList = new ArrayList(eqList.size());
            for (ChannelEquipmentVo eq : eqList) {
                EqEntry eqEmtry = new EqEntry();
                eqEmtry.equipment_no = eq.getEquipment_no();
                eqEmtry.eqVo = eq;
                eqEmtry.eqState = ServiceUtil.getServiceContext().getEquipmentState(eqEmtry.equipment_no);
                channelEntry.eqList.add(eqEmtry);
            }
        }
    }

    @Override
    public void run() {
        if (!this.selected) {
            return;
        }
        try {
            final Map<String, HostEntry> data = this.getDisplayDataMap();
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainEqStateMonitorPanel.this.refresh(data);
                }
            });
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private static class ChannelEentry {
        private String channel_no;
        private CarparkChannel channel;
        private CarparkHost proxyManagerHost;
        private List<EqEntry> eqList;

        private ChannelEentry() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.channel_no == null ? 0 : this.channel_no.hashCode());
            result = 31 * result + (this.eqList == null ? 0 : this.eqList.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChannelEentry other = (ChannelEentry)obj;
            if (this.channel_no == null ? other.channel_no != null : !this.channel_no.equals(other.channel_no)) {
                return false;
            }
            return !(this.eqList == null ? other.eqList != null : !this.eqList.equals(other.eqList));
        }
    }

    private class ChannelPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String channelNo;
        private JLabel titleLabel;
        private List<KeyValueEntry<JLabel, JLabel>> eqLabelList;

        private ChannelPanel(ChannelEentry chanelEntry, int width) {
            this.channelNo = chanelEntry.channel_no;
            this.setBackground(MainEqStateMonitorPanel.this.contentPanel.getBackground());
            this.setLayout(new BorderLayout());
            this.titleLabel = new JLabel();
            int titleHegiht = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 30.0 / 768.0);
            int lineHeight = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 1.0 / 768.0);
            this.titleLabel.setPreferredSize(new Dimension(width, titleHegiht));
            this.titleLabel.setOpaque(true);
            this.titleLabel.setBackground(this.getBackground());
            this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, lineHeight, 0, MainEqStateMonitorPanel.this.lineColor));
            this.titleLabel.setHorizontalAlignment(0);
            this.titleLabel.setIcon(MainEqStateMonitorPanel.this.getImageIcon("ic_inlet"));
            this.titleLabel.setFont(MainEqStateMonitorPanel.this.font13);
            int grap = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 3.0 / 768.0);
            this.titleLabel.setIconTextGap(grap);
            this.add((Component)this.titleLabel, "North");
            JPanel eqPanel = new JPanel();
            this.add((Component)eqPanel, "Center");
            eqPanel.setBackground(this.getBackground());
            int eqSize = chanelEntry.eqList == null ? 0 : chanelEntry.eqList.size();
            this.eqLabelList = new ArrayList<KeyValueEntry<JLabel, JLabel>>(eqSize);
            if (eqSize > 0) {
                int titleHeight = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 21.0 / 768.0);
                int avgWidth = (width - 2 * lineHeight) / eqSize;
                Dimension ts = new Dimension(avgWidth, titleHeight);
                eqPanel.setLayout(new GridLayout(1, eqSize));
                int i = 0;
                while (i < eqSize) {
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(this.getBackground());
                    JLabel iconLabel = new JLabel();
                    iconLabel.setHorizontalAlignment(0);
                    iconLabel.setVerticalAlignment(3);
                    JLabel textLabel = new JLabel();
                    textLabel.setHorizontalAlignment(0);
                    textLabel.setVerticalAlignment(1);
                    textLabel.setFont(MainEqStateMonitorPanel.this.font12);
                    textLabel.setPreferredSize(ts);
                    p.add((Component)iconLabel, "Center");
                    p.add((Component)textLabel, "South");
                    this.eqLabelList.add((KeyValueEntry<JLabel, JLabel>)new KeyValueEntry((Object)iconLabel, (Object)textLabel));
                    eqPanel.add(p);
                    ++i;
                }
            }
        }
    }

    private static class EqEntry {
        private String equipment_no;
        private ChannelEquipmentVo eqVo;
        private EquipmentState eqState = EquipmentState.DISCONNECTED;

        private EqEntry() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.equipment_no == null ? 0 : this.equipment_no.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EqEntry other = (EqEntry)obj;
            return !(this.equipment_no == null ? other.equipment_no != null : !this.equipment_no.equals(other.equipment_no));
        }
    }

    private static class HostEntry {
        private CarparkHost host;
        private String host_no;
        private Map<String, ChannelEentry> channelMap;
        private boolean connected;

        private HostEntry() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.channelMap == null ? 0 : this.channelMap.hashCode());
            result = 31 * result + (this.host_no == null ? 0 : this.host_no.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostEntry other = (HostEntry)obj;
            if (this.host_no == null ? other.host_no != null : !this.host_no.equals(other.host_no)) {
                return false;
            }
            return !(this.channelMap == null ? other.channelMap != null : !this.channelMap.equals(other.channelMap));
        }
    }

    private class HostPanel {
        private String hostNo;
        private JPanel hPanel;
        private JLabel hostInfoLabel;
        private List<ChannelPanel> channelPanelList;

        private HostPanel(HostEntry entry, int hostWidth) {
            this.hostNo = entry.host_no;
            this.hPanel = new JPanel();
            final int roundSize = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 16.0 / 768.0);
            this.hPanel.setBorder(new RoundBorder(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(3, 3, 3, 3);
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Color old = g.getColor();
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    Color borderColor0 = new Color(216, 221, 225);
                    Color borderColor1 = new Color(235, 238, 242);
                    Color borderColor2 = new Color(253, 253, 253);
                    if (borderColor0 != null) {
                        g.setColor(borderColor0);
                        g.drawRoundRect(2, 2, c.getWidth() - 4, c.getHeight() - 4, roundSize - 2, roundSize - 2);
                    }
                    if (borderColor1 != null) {
                        g.setColor(borderColor1);
                        g.drawRoundRect(1, 1, c.getWidth() - 2, c.getHeight() - 2, roundSize - 1, roundSize - 1);
                    }
                    if (borderColor2 != null) {
                        g.setColor(borderColor2);
                        g.drawRoundRect(0, 0, c.getWidth(), c.getHeight(), roundSize, roundSize);
                    }
                    g.setColor(old);
                }
            });
            this.hPanel.setBackground(MainEqStateMonitorPanel.this.contentPanel.getBackground());
            this.hPanel.setLayout(new XYLayout());
            int y = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 3.0 / 768.0);
            int h = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 30.0 / 768.0);
            int w = (int)((double)(hostWidth -= 6) * 0.9);
            int x = (hostWidth - w) / 2;
            this.hostInfoLabel = new JLabel();
            this.hostInfoLabel.setFont(MainEqStateMonitorPanel.this.font13);
            this.hostInfoLabel.setHorizontalAlignment(0);
            this.hPanel.add((Component)this.hostInfoLabel, new XYConstraints(x, y, w, h));
            int textgrap = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 3.0 / 768.0);
            this.hostInfoLabel.setIconTextGap(textgrap);
            y += y + h;
            int chanelSize = entry.channelMap == null ? 0 : entry.channelMap.size();
            this.channelPanelList = new ArrayList<ChannelPanel>(chanelSize);
            if (chanelSize > 0) {
                int lineHeight = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 1.0 / 768.0);
                JPanel linePanel = new JPanel();
                linePanel.setBackground(MainEqStateMonitorPanel.this.lineColor);
                int linex = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 3.0 / 768.0);
                int liney = y;
                int linew = hostWidth - 2 * linex;
                int lineh = lineHeight;
                this.hPanel.add((Component)linePanel, new XYConstraints(linex, liney, linew, lineh));
                int marginBottom = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 10.0 / 768.0);
                int marginChannelLeft = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 10.0 / 768.0);
                int channelWidth = chanelSize == 1 ? hostWidth - 2 * marginChannelLeft : (hostWidth - 3 * marginChannelLeft) / 2;
                int channelHeight = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 80.0 / 768.0);
                int chanelIndex = 0;
                int channelx = marginChannelLeft;
                int channelMarginTop = (int)Math.round(MainEqStateMonitorPanel.this.mainFrame.getRootSize().getHeight() * 10.0 / 768.0);
                y += lineh + channelMarginTop;
                for (ChannelEentry chanelEntry : entry.channelMap.values()) {
                    if (chanelIndex == 0) {
                        channelx = marginChannelLeft;
                    } else if (chanelIndex > 0 && chanelIndex % 2 == 0) {
                        channelx = marginChannelLeft;
                        y += channelMarginTop + channelHeight;
                    }
                    ChannelPanel chanelPanel = new ChannelPanel(chanelEntry, channelWidth);
                    this.channelPanelList.add(chanelPanel);
                    chanelPanel.setBorder(BorderFactory.createLineBorder(MainEqStateMonitorPanel.this.lineColor, lineh));
                    this.hPanel.add((Component)chanelPanel, new XYConstraints(channelx, y, channelWidth, channelHeight));
                    channelx += marginChannelLeft + channelWidth;
                    ++chanelIndex;
                }
                y += channelMarginTop + channelHeight;
                y += marginBottom;
            }
            this.hPanel.setPreferredSize(new Dimension(hostWidth, y));
        }
    }
}

