/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.gui.GlobalAWTKeyEventListener;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.PassKeyListener;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.MainConfirmEvent;
import com.wovoe.carpark.gui.login.MainPassConfirmPanel;
import com.wovoe.carpark.gui.login.PassExitConfirmPanel;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class MainPassConfirmDialog
extends JDialog
implements ActionListener,
PassKeyListener,
ConfirmPassDialogCallback {
    private static final long serialVersionUID = -4308261183220972185L;
    private CarparkMainFrame mainFrame;
    private JPanel rootPanel;
    private JLayeredPane body;
    private Dimension bodySize;
    private Color bodyBgColor = Color.decode("#00BCD4");
    private Color selectButtonBgColor = Color.decode("#CCE5F9");
    private Color selectButtonFontColor = Color.decode("#7A7A7A");
    private volatile boolean disposed = false;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private Dimension scrollPaneSize;
    private volatile SelectButton selectedButton;
    private static LinkedHashMap<String, MainConfirmEvent> eventMap = new LinkedHashMap();
    private static final Object lock = new Object();
    private static volatile MainPassConfirmDialog instance;
    private static final String CARTYPEHOTKEY_CONFIG_FILE = "carTypeSelectHotKey.txt";
    private Map<String, String> carTypeSelectHotKeyCofig;
    private MouseAdapter monseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            if (source != null && source instanceof SelectButton) {
                MainPassConfirmDialog.this.setSelectButton0((SelectButton)source);
            }
        }
    };
    private volatile int seseindex = 0;

    public static MainPassConfirmDialog getMainPassConfirmDialog() {
        return instance;
    }

    static void closeAllDialog(boolean closePassSession) {
        if (closePassSession) {
            try {
                try {
                    LinkedHashMap<String, MainConfirmEvent> eventMap0 = eventMap;
                    eventMap = new LinkedHashMap();
                    if (eventMap0 != null && !eventMap0.isEmpty()) {
                        PassFilter saveFilter = ServiceUtil.getServiceContext().getPassFilterChain().getSavePassDataFilter();
                        if (saveFilter == null) {
                            GuiLog.getLog().warn((Object)"SavePassDataFilter \u4e22\u5931 \uff01\uff01\uff01");
                        }
                        for (MainConfirmEvent event : eventMap0.values()) {
                            try {
                                if (event.getAttachment() == null || !(event.getAttachment() instanceof PassSession)) continue;
                                PassSession passSession = (PassSession)event.getAttachment();
                                if (passSession.getReadPassportNumberEvent() != null && !passSession.getReadPassportNumberEvent().isManualTrigger()) {
                                    if (saveFilter != null) {
                                        if (passSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
                                        try {
                                            saveFilter.doFilter(passSession);
                                            passSession.setSessionState(PassSession.SessionState.CAR_LEFT);
                                        }
                                        catch (Exception ex) {
                                            GuiLog.getLog().warn((Object)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38! ", (Throwable)ex);
                                            passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                            passSession.setSessionState(PassSession.SessionState.CAR_LEFT);
                                        }
                                        continue;
                                    }
                                    if (passSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
                                    passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                    passSession.setSessionState(PassSession.SessionState.CAR_LEFT);
                                    continue;
                                }
                                if (passSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
                                passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                passSession.setSessionState(PassSession.SessionState.CAR_LEFT);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    MainPassConfirmDialog dialog = instance;
                    if (dialog != null && dialog.isVisible()) {
                        dialog.dispose();
                    }
                    instance = null;
                }
            }
            catch (Exception eventMap0) {}
        } else {
            MainPassConfirmDialog dialog = instance;
            if (dialog != null && dialog.isVisible()) {
                dialog.dispose();
            }
            instance = null;
        }
    }

    public CarparkMainFrame getCarparkMainFrame() {
        return this.mainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConfirmEventSize() {
        Object object = lock;
        synchronized (object) {
            return eventMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PassSession> getAllRegPassPassSession() {
        LinkedList<PassSession> slist = new LinkedList<PassSession>();
        Object object = lock;
        synchronized (object) {
            for (MainConfirmEvent e : eventMap.values()) {
                PassSession s;
                if (e.getAttachment() == null || !(e.getAttachment() instanceof PassSession) || (s = (PassSession)e.getAttachment()).getSessionState() != PassSession.SessionState.OPEN_DIALOG || s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().isManualTrigger()) continue;
                slist.add(s);
            }
        }
        return slist;
    }

    public static void addConfirmEvent(final MainConfirmEvent event0, final CarparkMainFrame frame) {
        if (event0 == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    MainConfirmEvent event = event0;
                    MainConfirmEvent old = (MainConfirmEvent)eventMap.get(event0.getEventId());
                    if (old == null) {
                        eventMap.put(event0.getEventId(), event0);
                        if (instance != null) {
                            instance.addSelectButton(event0);
                            instance.setSelectButton0(instance.selectedButton);
                        }
                    } else if (event != old) {
                        old.setShowNow(event0.isShowNow());
                        event = old;
                    }
                    if (instance != null) {
                        if (event.isShowNow()) {
                            instance.setSelectButton(event);
                        }
                    } else {
                        MainPassConfirmDialog dialog = new MainPassConfirmDialog(frame, null);
                        Dimension size = frame.getConfirmDialogSize();
                        dialog.setSize(size);
                        dialog.setLocation(frame.getConfirmDialogLocation());
                        dialog.init(size);
                        dialog.intLeftButton();
                        dialog.setSelectButton((MainConfirmEvent)ServiceUtil.getFirstElement(eventMap.values()));
                        dialog.setUndecorated(true);
                        dialog.toFront();
                        dialog.setVisible(true);
                        dialog.requestFocus();
                        ServiceUtil.getServiceContext().setConfirmPassDialogCallback(dialog);
                        instance = dialog;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainConfirmEvent getManualConfirmEent(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            for (MainConfirmEvent e : eventMap.values()) {
                PassSession s;
                if (e.getAttachment() == null || !(e.getAttachment() instanceof PassSession) || !channelNo.equals((s = (PassSession)e.getAttachment()).getPassChannel().getChannelNo()) || s.getReadPassportNumberEvent() == null || !s.getReadPassportNumberEvent().isManualTrigger()) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainConfirmEvent getConfirmEventByPassSession(PassSession passSession) {
        if (passSession == null) {
            return null;
        }
        String psid = String.valueOf(passSession.getSessionId());
        Object object = lock;
        synchronized (object) {
            for (MainConfirmEvent e : eventMap.values()) {
                PassSession s;
                if (e.getAttachment() == null || !(e.getAttachment() instanceof PassSession) || !(s = (PassSession)e.getAttachment()).equals(passSession) && !psid.equals(e.getEventId())) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainPassConfirmPanel findMainPassConfirmPanel(MainConfirmEvent event) {
        Object object = lock;
        synchronized (object) {
            int conut = this.buttonPanel.getComponentCount();
            SelectButton needSelectButton = null;
            int i = 0;
            while (i < conut) {
                SelectButton b;
                Component c = this.buttonPanel.getComponent(i);
                if (c != null && c instanceof SelectButton && (b = (SelectButton)c).event.getEventId().equals(event.getEventId())) {
                    needSelectButton = b;
                    break;
                }
                ++i;
            }
            if (needSelectButton != null) {
                return needSelectButton.panel;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        try {
            try {
                ServiceUtil.getServiceContext().setConfirmPassDialogCallback(null);
            }
            finally {
                GlobalAWTKeyEventListener.getInstance().removePassKeyListener(this);
            }
        }
        finally {
            super.dispose();
        }
    }

    public void setSelectMunuName(MainConfirmEvent event) {
        int conut = this.buttonPanel.getComponentCount();
        SelectButton findButton = null;
        int i = 0;
        while (i < conut) {
            SelectButton b;
            Component c = this.buttonPanel.getComponent(i);
            if (c != null && c instanceof SelectButton && (b = (SelectButton)c).event.getEventId().equals(event.getEventId())) {
                findButton = b;
                break;
            }
            ++i;
        }
        if (findButton != null) {
            String text = findButton.textLabel.getText();
            if (text == null) {
                text = "";
            }
            if (!text.equals(event.getTitleName())) {
                findButton.textLabel.setText(event.getTitleName());
            }
        }
    }

    public void showMainConfirmEvent(final MainConfirmEvent event) {
        if (event == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.showMainConfirmEvent0(event);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPassConfirmDialog.this.showMainConfirmEvent0(event);
                }
            });
        }
    }

    private void showMainConfirmEvent0(MainConfirmEvent event) {
        if (event == null) {
            return;
        }
        if (this.isVisible()) {
            this.setSelectButton(event);
        }
    }

    public boolean isSelectedPanel(MainPassConfirmPanel panel) {
        SelectButton selectedButton0 = this.selectedButton;
        return selectedButton0 != null && selectedButton0.panel != null && selectedButton0.panel == panel;
    }

    private void setSelectButton0(SelectButton needSelectButton) {
        if (needSelectButton == null) {
            return;
        }
        SelectButton old = this.selectedButton;
        if (old != null && old.event.getEventId().equals(needSelectButton.event.getEventId())) {
            this.body.moveToFront(needSelectButton.panel.getLayerComponent());
            return;
        }
        if (old != null) {
            old.setBackground(this.selectButtonBgColor);
            old.textLabel.setForeground(this.selectButtonFontColor);
            if (old.panel != null) {
                old.panel.disSelected();
            }
        }
        needSelectButton.setBackground(this.bodyBgColor);
        needSelectButton.textLabel.setForeground(Color.WHITE);
        this.selectedButton = needSelectButton;
        if (needSelectButton.panel == null) {
            try {
                needSelectButton.panel = needSelectButton.event.getComClass().newInstance();
            }
            catch (Exception e) {
                GuiLog.getLog().warn((Object)"\u521b\u5efa\u5f39\u51fa\u6846\u9762\u677f\u5931\u8d25\uff1a", (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            this.seseindex += 10;
            try {
                needSelectButton.panel.init(this.bodySize, this, needSelectButton.event, this.bodyBgColor);
            }
            catch (Exception ex) {
                GuiLog.getLog().warn((Object)"\u521d\u59cb\u5316\u5f39\u51fa\u6846\u7a97\u4f53\u5931\u8d25", (Throwable)ex);
            }
            needSelectButton.panel.getLayerComponent().setBounds(0, 0, this.bodySize.width, this.bodySize.height);
            this.body.add(needSelectButton.panel.getLayerComponent(), this.seseindex);
        }
        needSelectButton.panel.doSelect();
        this.body.moveToFront(needSelectButton.panel.getLayerComponent());
    }

    private void setSelectButton(MainConfirmEvent event) {
        int conut = this.buttonPanel.getComponentCount();
        SelectButton needSelectButton = null;
        int i = 0;
        while (i < conut) {
            SelectButton b;
            Component c = this.buttonPanel.getComponent(i);
            if (c != null && c instanceof SelectButton && (b = (SelectButton)c).event.getEventId().equals(event.getEventId())) {
                needSelectButton = b;
                break;
            }
            ++i;
        }
        if (needSelectButton != null) {
            this.setSelectButton0(needSelectButton);
        }
    }

    private void intLeftButton() {
        int buttonHeight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 40.0 / 768.0);
        int buttonCount = this.scrollPaneSize.height / buttonHeight;
        int count = eventMap.size();
        if (count <= buttonCount) {
            this.buttonPanel.setLayout(new GridLayout(buttonCount, 1, 0, 2));
            this.buttonPanel.setPreferredSize(new Dimension(this.scrollPaneSize.width, this.scrollPaneSize.height));
        } else {
            this.buttonPanel.setLayout(new GridLayout(count, 1, 0, 2));
            this.buttonPanel.setPreferredSize(new Dimension(this.scrollPaneSize.width, (buttonHeight + 2) * count));
        }
        for (MainConfirmEvent event : eventMap.values()) {
            SelectButton button = new SelectButton();
            button.event = event;
            button.textLabel.setText(event.getTitleName());
            button.textLabel.setForeground(this.selectButtonFontColor);
            int fontSize = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 24.0 / 768.0);
            button.textLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
            button.addMouseListener(this.monseListener);
            button.setBackground(this.selectButtonBgColor);
            this.buttonPanel.add(button);
        }
    }

    private SelectButton addSelectButton(MainConfirmEvent event) {
        int buttonHeight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 40.0 / 768.0);
        int buttonCount = this.scrollPaneSize.height / buttonHeight;
        int count = eventMap.size();
        if (count > buttonCount) {
            this.buttonPanel.setLayout(new GridLayout(count, 1, 0, 2));
            this.buttonPanel.setPreferredSize(new Dimension(this.scrollPaneSize.width, (buttonHeight + 2) * count));
        }
        SelectButton button = new SelectButton();
        button.event = event;
        button.textLabel.setText(event.getTitleName());
        button.textLabel.setForeground(this.selectButtonFontColor);
        int fontSize = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 24.0 / 768.0);
        button.textLabel.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize));
        button.addMouseListener(this.monseListener);
        button.setBackground(this.selectButtonBgColor);
        this.buttonPanel.add(button);
        this.buttonPanel.updateUI();
        return button;
    }

    private void refreshLeftButtons() {
        int buttonHeight = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 40.0 / 768.0);
        int buttonCount = this.scrollPaneSize.height / buttonHeight;
        int count = eventMap.size();
        if (count <= buttonCount) {
            Dimension sieze = this.buttonPanel.getPreferredSize();
            if (sieze == null || sieze.width != this.scrollPaneSize.width || sieze.height != this.scrollPaneSize.height) {
                this.buttonPanel.setLayout(new GridLayout(buttonCount, 1, 0, 2));
                this.buttonPanel.setPreferredSize(new Dimension(this.scrollPaneSize.width, this.scrollPaneSize.height));
            }
        } else {
            this.buttonPanel.setLayout(new GridLayout(count, 1, 0, 2));
            this.buttonPanel.setPreferredSize(new Dimension(this.scrollPaneSize.width, (buttonHeight + 2) * count));
        }
        this.buttonPanel.updateUI();
    }

    private void removeSelectButton(MainConfirmEvent event) {
        Component button = null;
        int conut = this.buttonPanel.getComponentCount();
        int i = 0;
        while (i < conut) {
            SelectButton b;
            Component c = this.buttonPanel.getComponent(i);
            if (c != null && c instanceof SelectButton && (b = (SelectButton)c).event.getEventId().equals(event.getEventId())) {
                button = b;
                break;
            }
            ++i;
        }
        if (button == null) {
            return;
        }
        button.removeMouseListener(this.monseListener);
        this.buttonPanel.remove(button);
        if (((SelectButton)button).panel != null) {
            ((SelectButton)button).panel.onRemove();
            this.body.remove(((SelectButton)button).panel.getLayerComponent());
        }
        if (this.selectedButton == button) {
            this.selectedButton = null;
        }
    }

    public void finishEvent(final MainConfirmEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    MainConfirmEvent event0 = (MainConfirmEvent)eventMap.remove(event.getEventId());
                    if (event0 != null) {
                        MainPassConfirmDialog.this.removeSelectButton(event);
                        if (eventMap.isEmpty()) {
                            if (!MainPassConfirmDialog.this.disposed) {
                                instance = null;
                                MainPassConfirmDialog.this.dispose();
                            }
                        } else {
                            MainPassConfirmDialog.this.refreshLeftButtons();
                            if (MainPassConfirmDialog.this.selectedButton == null || MainPassConfirmDialog.this.selectedButton.event == null) {
                                MainPassConfirmDialog.this.setSelectButton((MainConfirmEvent)ServiceUtil.getFirstElement(eventMap.values()));
                            } else {
                                MainPassConfirmDialog.this.setSelectButton(MainPassConfirmDialog.this.selectedButton.event);
                            }
                            MainPassConfirmDialog.this.scrollPane.getVerticalScrollBar().setValue(0);
                        }
                    }
                }
            }
        });
    }

    private MainPassConfirmDialog(CarparkMainFrame owner) {
        super(owner, "\u653e\u884c\u786e\u8ba4\u7a97\u4f53", false);
        this.mainFrame = owner;
    }

    protected void init(Dimension size) {
        this.rootPanel = new JPanel();
        this.rootPanel.setBackground(Color.decode("#ECF0F5"));
        this.rootPanel.setBorder(BorderFactory.createLineBorder(Color.decode("#D4D4D4")));
        this.rootPanel.setLayout(new XYLayout());
        GlobalAWTKeyEventListener.getInstance().addPassKeyListener(this);
        int linex = this.mainFrame.getCenterLeftPanelXYConstraints().getX() + this.mainFrame.getCenterLeftPanelXYConstraints().getWidth();
        int lineWidth = 0;
        linex = linex - this.getX() - lineWidth - 3;
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(Color.decode("#ECF0F5"));
        this.scrollPane = new JScrollPane(this.buttonPanel, 20, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.setBackground(this.buttonPanel.getBackground());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        int leftx = linex + lineWidth;
        int topx = 0;
        int widthx = size.width - linex - lineWidth - 2;
        int heighty = size.height - 2;
        this.rootPanel.add((Component)this.scrollPane, new XYConstraints(leftx, topx, widthx, heighty));
        this.scrollPaneSize = new Dimension(widthx, heighty);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.getContentPane().add(this.rootPanel);
        this.body = new JLayeredPane();
        this.body.setBackground(this.bodyBgColor);
        int bodyX = 1;
        int bodyY = 1;
        int bodyHegiht = size.height - 3 * bodyY;
        int bodyWidth = linex - 2 * bodyX;
        this.bodySize = new Dimension(bodyWidth, bodyHegiht);
        this.rootPanel.setPreferredSize(this.bodySize);
        this.rootPanel.add((Component)this.body, new XYConstraints(bodyX, bodyY, bodyWidth, bodyHegiht));
        JPanel xPanel = new JPanel();
        xPanel.setBounds(0, 0, this.bodySize.width, this.bodySize.height);
        this.body.add((Component)xPanel, this.seseindex++);
    }

    protected void onPressEnter0() {
        SelectButton selectedButton0 = this.selectedButton;
        if (selectedButton0 != null && selectedButton0.panel != null) {
            selectedButton0.panel.onPressEnter();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("vk_enter".equals(cmd)) {
            this.onPressEnter0();
        }
    }

    @Override
    public void onScanCodeFound(String scanCode) {
        SelectButton selectedButton0 = this.selectedButton;
        if (selectedButton0 != null && selectedButton0.panel != null) {
            selectedButton0.panel.onScanCodeFound(scanCode);
        }
    }

    @Override
    public void onPressEnter() {
        this.onPressEnter0();
    }

    @Override
    public void doClosePassDialog(final PassSession passSession) {
        if (passSession == null) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainConfirmEvent event = MainPassConfirmDialog.getConfirmEventByPassSession(passSession);
                if (event == null) {
                    return;
                }
                MainPassConfirmDialog dialog = MainPassConfirmDialog.getMainPassConfirmDialog();
                if (dialog != null) {
                    dialog.finishEvent(event);
                }
            }
        });
    }

    @Override
    public void doUpdateSession(final PassSession passSession) {
        if (passSession == null) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainPassConfirmPanel pannel;
                MainConfirmEvent event = MainPassConfirmDialog.getConfirmEventByPassSession(passSession);
                if (event != null && (pannel = MainPassConfirmDialog.this.findMainPassConfirmPanel(event)) != null) {
                    String passPlate = passSession.getPassPlate();
                    event.setTitleName(passPlate);
                    MainPassConfirmDialog.this.setSelectMunuName(event);
                    pannel.refreshPanel();
                }
            }
        });
    }

    @Override
    public void onKeyEvent(KeyEvent keyEvent) {
        SelectButton selectedButton0;
        if (keyEvent.getID() == 402 && (keyEvent.getKeyCode() >= 112 || keyEvent.getKeyCode() <= 123) && (selectedButton0 = this.selectedButton) != null && selectedButton0.panel != null && selectedButton0.panel instanceof PassExitConfirmPanel) {
            String carTypeName = this.getHotKeyCarTypeName(KeyEvent.getKeyText(keyEvent.getKeyCode()));
            ((PassExitConfirmPanel)selectedButton0.panel).doSelectCarType(carTypeName);
        }
    }

    private String getHotKeyCarTypeName(String keyText) {
        if (keyText == null || keyText.length() == 0) {
            return null;
        }
        Map<String, String> keyMap = this.getCarTypeHotKeyConfig();
        if (keyMap == null || keyMap.isEmpty()) {
            return null;
        }
        String carTypeName = keyMap.get(keyText);
        if (carTypeName == null || carTypeName.length() == 0) {
            return null;
        }
        return carTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getCarTypeHotKeyConfig() {
        if (this.carTypeSelectHotKeyCofig != null) return this.carTypeSelectHotKeyCofig;
        String string = CARTYPEHOTKEY_CONFIG_FILE;
        synchronized (CARTYPEHOTKEY_CONFIG_FILE) {
            HashMap<String, String> keyMap;
            block11: {
                if (this.carTypeSelectHotKeyCofig != null) return this.carTypeSelectHotKeyCofig;
                keyMap = new HashMap<String, String>();
                try {
                    BufferedReader reader;
                    File file = new File(PathFinder.findLocalDir(), "conf/carTypeSelectHotKey.txt");
                    if (!file.exists() || !file.isFile()) break block11;
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "GBK"));
                    }
                    catch (Exception ex) {
                        inputStream.close();
                        throw ex;
                    }
                    try {
                        String line;
                        String C = "#";
                        int a = 61;
                        while ((line = reader.readLine()) != null) {
                            int ind;
                            if ((line = line.trim()).length() == 0 || line.startsWith(C) || (ind = line.indexOf(a)) == -1) continue;
                            String key = line.substring(0, ind).trim();
                            String value = line.substring(ind + 1).trim();
                            if (key.length() <= 0 || value.length() <= 0) continue;
                            keyMap.put(key, value);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception ex) {
                    GuiLog.getLog().error((Object)"\u8bfb\u53d6\u914d\u7f6e: carTypeSelectHotKey.txt \u5931\u8d25");
                }
            }
            this.carTypeSelectHotKeyCofig = keyMap;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.carTypeSelectHotKeyCofig;
        }
    }

    /* synthetic */ MainPassConfirmDialog(CarparkMainFrame carparkMainFrame, MainPassConfirmDialog mainPassConfirmDialog) {
        this(carparkMainFrame);
    }

    private class SelectButton
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel textLabel = new JLabel();
        private MainConfirmEvent event;
        private MainPassConfirmPanel panel;

        SelectButton() {
            this.setLayout(new BorderLayout());
            this.textLabel.setHorizontalAlignment(0);
            this.add((Component)this.textLabel, "Center");
        }
    }
}

