/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassChannelManager;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CameraAction;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.app.RefreshPresenceRecordEvent;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.RoundBorder;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.VideoCanvas;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.CarparkMainLayerPanel;
import com.wovoe.carpark.gui.login.MainConfirmEvent;
import com.wovoe.carpark.gui.login.MainPassConfirmDialog;
import com.wovoe.carpark.gui.login.MainPassRecordPanel;
import com.wovoe.carpark.gui.login.MainPresenceRecordPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.gui.util.CarparkGuiUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MainPassMonitorPanel
extends JPanel
implements CarparkMainLayerPanel,
CarparkEventListener,
ActionListener {
    private static final long serialVersionUID = -3317277494094972513L;
    private Panex leftPane;
    private Panex rightPane;
    private Image noVideoImage;
    private MainPassRecordPanel passRecordPanel;
    private MainPresenceRecordPanel presenceRecordPanel;
    private static final String configName = "mainPassPane.conf";
    private Properties guiPassMainConfig;
    private Map<String, Object> eqSateIconMap = new ConcurrentHashMap<String, Object>();
    private ScheduledFuture<?> stateMoniterHandler;
    private CarparkMainFrame mainFrame;
    private JPopupMenu specialCarMenu;
    private int specialCarMenuFontSize;
    private Font specialCarMenuFont;
    private int specialCarMenuHeight;
    private volatile boolean isShowPanel = true;
    public volatile boolean lockPlay = false;
    private ActionListener actionListener = new ActionListener(){
        private String selctLC = "L:";
        private String selctRC = "R:";

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (cmd == null) {
                return;
            }
            if (cmd.startsWith(this.selctLC) || cmd.startsWith(this.selctRC)) {
                MainPassMonitorPanel.this.onSelectCamera(cmd, true);
            }
        }
    };

    public MainPresenceRecordPanel getPresenceRecordPanel() {
        return this.presenceRecordPanel;
    }

    public MainPassRecordPanel getMainPassRecordPanel() {
        return this.passRecordPanel;
    }

    public void setEqsState() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainPassMonitorPanel.this.isShowPanel) {
                    MainPassMonitorPanel.this.setEqsState0();
                }
            }
        });
    }

    private void setEqsState0() {
        this.setEqsState1(this.leftPane);
        this.setEqsState1(this.rightPane);
    }

    private void clearEqSate(JLabel l) {
        if (l != null) {
            String text = l.getToolTipText();
            if (text == null) {
                text = "";
            }
            if (!text.equals("")) {
                l.setToolTipText(null);
            }
            if (l.getIcon() != null) {
                l.setIcon(null);
            }
            if (l.getText() != null && l.getText().length() > 0) {
                l.setText(null);
            }
        }
    }

    private ImageIcon getImageIcon(String name, Dimension eqStateSize) {
        Object obj = this.eqSateIconMap.get(name);
        if (obj == null) {
            BufferedImage image = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage(name);
            if (image == null) {
                this.eqSateIconMap.put(name, Boolean.FALSE);
                return null;
            }
            ImageIcon icon = new ImageIcon(SwingUtil.resizeImage((Image)image, eqStateSize.width, eqStateSize.height));
            this.eqSateIconMap.put(name, icon);
            return icon;
        }
        if (obj instanceof ImageIcon) {
            return (ImageIcon)obj;
        }
        return null;
    }

    private void setEqsState1(Panex pane) {
        List<JLabel> eqStateLabelList0 = pane.eqStateLabelList;
        if (eqStateLabelList0 == null || eqStateLabelList0.isEmpty()) {
            return;
        }
        PassChannel channel = null;
        List<Equipment> eqList = null;
        if (pane.chanelNo != null && pane.chanelNo.length() > 0 && (channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(pane.chanelNo)) != null) {
            eqList = channel.getEquipmentList();
        }
        if (eqList != null && !eqList.isEmpty()) {
            PriorityQueue<Equipment> queue = new PriorityQueue<Equipment>(eqList.size(), new Comparator<Equipment>(){

                private int getType(Equipment eq) {
                    if (eq.getType() == 33) {
                        return -33;
                    }
                    if (eq.getType() == 9) {
                        return -32;
                    }
                    if (eq.getType() == 10) {
                        return -31;
                    }
                    return eq.getType();
                }

                @Override
                public int compare(Equipment eq1, Equipment eq2) {
                    int type2;
                    int type1 = this.getType(eq1);
                    if (type1 == (type2 = this.getType(eq2))) {
                        return eq1.getEquipmentNo().compareTo(eq2.getEquipmentNo());
                    }
                    return Integer.compare(type1, type2);
                }
            });
            for (Equipment eq : eqList) {
                queue.offer(eq);
            }
            for (JLabel l : eqStateLabelList0) {
                Equipment eq = queue.poll();
                if (eq == null) {
                    this.clearEqSate(l);
                    continue;
                }
                int eqType = eq.getType();
                EquipmentState state = eq.getEquipmentState();
                if (state == null) {
                    state = EquipmentState.DISCONNECTED;
                }
                String name = "eq_" + eqType + "_" + state.name();
                ImageIcon icon = this.getImageIcon(name, pane.eqStateSize);
                if (l.getIcon() != icon) {
                    l.setIcon(icon);
                }
                StringBuilder toolTip = new StringBuilder();
                toolTip.append(eq.getName());
                String ip = eq.getIp();
                if (ip != null && ip.length() > 0) {
                    toolTip.append('[').append(ip).append(']');
                }
                if (state == EquipmentState.DISCONNECTED) {
                    toolTip.append("\u672a\u8fde\u63a5");
                } else {
                    toolTip.append("\u8fde\u63a5\u6210\u529f");
                }
                String tooTipx = toolTip.toString();
                String x = l.getToolTipText();
                if (tooTipx.equals(x)) continue;
                l.setToolTipText(tooTipx);
            }
        } else {
            for (JLabel l : eqStateLabelList0) {
                this.clearEqSate(l);
            }
        }
    }

    @Override
    public void init(Dimension size, CarparkMainFrame frame) {
        this.mainFrame = frame;
        if (this.guiPassMainConfig == null) {
            this.guiPassMainConfig = ServiceUtil.getServiceContext().readLocalRuntimeData("gui", configName, configName);
        }
        this.setLayout(new XYLayout());
        this.leftPane = new Panex();
        int x = 1;
        int y = 1;
        int width = size.width - 2 * x;
        int height = size.height - 2 * y;
        int margx = (int)Math.round(frame.getRootSize().getWidth() * 14.0 / 1280.0);
        int paneX = x;
        int paneY = y;
        int paneWidth = (width - margx) / 2;
        int paneHeight = height;
        XYConstraints leftcons = new XYConstraints(paneX, paneY, paneWidth, paneHeight);
        this.leftPane.intPanex(frame, this, leftcons);
        this.rightPane = new Panex();
        XYConstraints rightcons = new XYConstraints(paneX += paneWidth + margx, paneY, paneWidth, paneHeight);
        this.rightPane.intPanex(frame, this, rightcons);
        this.passRecordPanel = new MainPassRecordPanel();
        int rplamarginTop = (int)Math.round((double)this.leftPane.panelXYConstraints.getHeight() * 8.0 / 608.0);
        Dimension passRecordSize = new Dimension(this.leftPane.lineCons.getWidth(), leftcons.getHeight() - this.leftPane.lineCons.getY() - this.leftPane.lineCons.getHeight() - 2 * rplamarginTop);
        this.leftPane.panel.add((Component)this.passRecordPanel, new XYConstraints(this.leftPane.lineCons.getX(), this.leftPane.lineCons.getY() + this.leftPane.lineCons.getHeight() + rplamarginTop, passRecordSize.width, passRecordSize.height));
        this.passRecordPanel.setBackground(this.leftPane.panel.getBackground());
        this.passRecordPanel.init(passRecordSize, frame);
        this.presenceRecordPanel = new MainPresenceRecordPanel();
        int rplamarginTop0 = (int)Math.round((double)this.rightPane.panelXYConstraints.getHeight() * 8.0 / 608.0);
        Dimension presenceRecordPanelSize = new Dimension(this.rightPane.lineCons.getWidth(), rightcons.getHeight() - this.rightPane.lineCons.getY() - this.rightPane.lineCons.getHeight() - 2 * rplamarginTop0);
        this.rightPane.panel.add((Component)this.presenceRecordPanel, new XYConstraints(this.rightPane.lineCons.getX(), this.rightPane.lineCons.getY() + this.rightPane.lineCons.getHeight() + rplamarginTop0, presenceRecordPanelSize.width, presenceRecordPanelSize.height));
        this.presenceRecordPanel.setBackground(this.rightPane.panel.getBackground());
        this.presenceRecordPanel.init(presenceRecordPanelSize, frame);
        frame.setConfirmDialogLineX(paneX + paneWidth);
        this.specialCarMenu = new JPopupMenu();
        this.specialCarMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#979797")));
        this.specialCarMenuFontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
        this.specialCarMenuFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, this.specialCarMenuFontSize);
        this.specialCarMenuHeight = (int)Math.round(frame.getRootSize().getHeight() * 25.0 / 768.0);
        KeyValueEntry<KeyValueEntry<PassChannel, Equipment>, KeyValueEntry<PassChannel, Equipment>> ents = this.getChanelEquipment(this.guiPassMainConfig);
        KeyValueEntry leftEntry = (KeyValueEntry)ents.getKey();
        KeyValueEntry rightEntry = (KeyValueEntry)ents.getValue();
        this.leftPane.setPanelChannel((PassChannel)leftEntry.getKey(), (Equipment)leftEntry.getValue(), false);
        this.rightPane.setPanelChannel((PassChannel)rightEntry.getKey(), (Equipment)rightEntry.getValue(), false);
        this.setEqsState0();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                MainPassMonitorPanel.this.onWindowOpened();
            }
        });
    }

    private void onWindowOpened() {
        if (this.stateMoniterHandler == null) {
            this.stateMoniterHandler = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    MainPassMonitorPanel.this.setEqsState();
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            this.leftPane.hwnd = CarparkGuiUtil.getComponentID(this.leftPane.videoCanvas);
            this.rightPane.hwnd = CarparkGuiUtil.getComponentID(this.rightPane.videoCanvas);
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        SearchParam p = new SearchParam();
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                            LinkedList<String> list = new LinkedList<String>();
                            Enumeration<PassChannel> cx = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
                            if (cx != null) {
                                while (cx.hasMoreElements()) {
                                    PassChannel c = cx.nextElement();
                                    if (!c.isLocalHostChannel()) continue;
                                    list.add(c.getChannelNo());
                                }
                            }
                            if (list.isEmpty()) {
                                p.addEQ("pass_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                            } else if (list.size() == 1) {
                                p.addEQ("pass_channel_no", list.get(0));
                            } else {
                                p.addINList("pass_channel_no", list);
                            }
                        } else {
                            p.addEQ("pass_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                        }
                        Calendar cl = Calendar.getInstance();
                        cl.set(14, 0);
                        p.addLTE("pass_time", (Object)cl.getTime());
                        cl.add(2, -2);
                        p.addGTE("pass_time", (Object)cl.getTime());
                        p.setOrerbySql("pass_time DESC ,area_level ASC");
                        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                        Pagination p1 = new Pagination();
                        p1.setNeedQueryCount(false);
                        p1.setGotoPage(1);
                        p1.setPageSize(1);
                        p1.setRecordsCount(1L);
                        CarparkPassRecord record = (CarparkPassRecord)daoService.selectOne(p, CarparkPassRecord.class, p1);
                        if (record != null) {
                            MainPassMonitorPanel.this.passRecordPanel.setPassRecord(record);
                        }
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().warn((Object)"", (Throwable)ex);
                    }
                }
            });
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().registerParkingEventListener(this);
            this.presenceRecordPanel.reload();
            this.playCamera(this.leftPane, true);
            this.playCamera(this.rightPane, true);
        }
    }

    private KeyValueEntry<KeyValueEntry<PassChannel, Equipment>, KeyValueEntry<PassChannel, Equipment>> getChanelEquipment(Properties config) {
        Equipment eq;
        Iterator<Equipment> it;
        String configeqNo;
        List<Equipment> chanelCameraList;
        PassChannel c;
        PassChannelManager channelManager = ServiceUtil.getServiceContext().getPassChannelManager();
        PassChannel leftChanel = null;
        PassChannel rightChannel = null;
        String leftChanelNo = config.getProperty("leftcno");
        String rightChanelNo = config.getProperty("rightcno");
        if (leftChanelNo != null && leftChanelNo.length() > 0 && (c = channelManager.getPassChannel(leftChanelNo)) != null && c.isLocalHostChannel()) {
            leftChanel = c;
        }
        if (rightChanelNo != null && rightChanelNo.length() > 0 && (c = channelManager.getPassChannel(rightChanelNo)) != null && c.isLocalHostChannel()) {
            rightChannel = c;
        }
        Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        if (leftChanel != null && rightChannel != null && leftChanel.getChannelNo().equals(rightChannel.getChannelNo()) && ((chanelCameraList = leftChanel.getEquipmentList(33)) == null || chanelCameraList.size() <= 1)) {
            ChannelArea ca;
            boolean isEnter = true;
            if (channelAreaMap != null && (ca = channelAreaMap.get(leftChanel.getChannelNo())) != null && ca.getExitAreas() != null && !ca.getExitAreas().isEmpty()) {
                isEnter = false;
            }
            if (isEnter) {
                rightChannel = null;
            } else {
                leftChanel = null;
            }
        }
        if (leftChanel == null || rightChannel == null) {
            Enumeration<PassChannel> channels = channelManager.getChannels();
            LinkedList<PassChannel> enterChanels = new LinkedList<PassChannel>();
            LinkedList<PassChannel> exitChanels = new LinkedList<PassChannel>();
            while (channels.hasMoreElements()) {
                ChannelArea ca;
                PassChannel c2 = channels.nextElement();
                if (!c2.isLocalHostChannel() || leftChanel != null && c2.getChannelNo().equals(leftChanel.getChannelNo()) || rightChannel != null && c2.getChannelNo().equals(rightChannel.getChannelNo())) continue;
                boolean isEnter = true;
                if (channelAreaMap != null && (ca = channelAreaMap.get(c2.getChannelNo())) != null && ca.getExitAreas() != null && !ca.getExitAreas().isEmpty()) {
                    isEnter = false;
                }
                if (isEnter) {
                    enterChanels.offer(c2);
                    continue;
                }
                exitChanels.offer(c2);
            }
            if (leftChanel == null) {
                leftChanel = (PassChannel)enterChanels.poll();
            }
            if (rightChannel == null) {
                rightChannel = (PassChannel)exitChanels.poll();
            }
            if (leftChanel == null) {
                leftChanel = (PassChannel)exitChanels.poll();
            }
            if (rightChannel == null) {
                rightChannel = (PassChannel)enterChanels.poll();
            }
        }
        Equipment leftCamera = null;
        Equipment rightCamera = null;
        List<Equipment> leftChanelCameraList = null;
        List<Equipment> rightChanelCameraList = null;
        if (leftChanel != null && rightChannel == null) {
            leftChanelCameraList = leftChanel.getEquipmentList(33);
            if (leftChanelCameraList != null && leftChanelCameraList.size() > 1) {
                rightChannel = leftChanel;
                rightChanelCameraList = leftChanelCameraList;
            }
        } else if (leftChanel == null && rightChannel != null) {
            rightChanelCameraList = rightChannel.getEquipmentList(33);
            if (rightChanelCameraList != null && rightChanelCameraList.size() > 1) {
                leftChanel = rightChannel;
                leftChanelCameraList = rightChanelCameraList;
            }
        } else if (leftChanel != null && rightChannel != null) {
            if (leftChanel.getChannelNo().equals(rightChannel.getChannelNo())) {
                rightChanelCameraList = leftChanelCameraList = leftChanel.getEquipmentList(33);
            } else {
                leftChanelCameraList = leftChanel.getEquipmentList(33);
                rightChanelCameraList = rightChannel.getEquipmentList(33);
            }
        }
        if (leftChanelCameraList != null && !leftChanelCameraList.isEmpty() && (configeqNo = config.getProperty("lefteno")) != null && configeqNo.length() > 0) {
            it = leftChanelCameraList.iterator();
            while (it.hasNext()) {
                eq = it.next();
                if (!configeqNo.equals(eq.getEquipmentNo())) continue;
                leftCamera = eq;
                it.remove();
                break;
            }
        }
        if (rightChanelCameraList != null && !rightChanelCameraList.isEmpty() && (configeqNo = config.getProperty("righteno")) != null && configeqNo.length() > 0) {
            it = rightChanelCameraList.iterator();
            while (it.hasNext()) {
                eq = it.next();
                if (!configeqNo.equals(eq.getEquipmentNo())) continue;
                rightCamera = eq;
                it.remove();
                break;
            }
        }
        if (leftCamera == null && leftChanelCameraList != null && !leftChanelCameraList.isEmpty()) {
            leftCamera = leftChanelCameraList.remove(0);
        }
        if (rightCamera == null && rightChanelCameraList != null && !rightChanelCameraList.isEmpty()) {
            rightCamera = rightChanelCameraList.remove(0);
        }
        if (leftCamera != null && rightCamera != null && rightCamera.getEquipmentNo().equals(leftCamera.getEquipmentNo())) {
            rightCamera = null;
        }
        KeyValueEntry leftEntry = new KeyValueEntry((Object)leftChanel, leftCamera);
        KeyValueEntry rightEntry = new KeyValueEntry((Object)rightChannel, (Object)rightCamera);
        return new KeyValueEntry((Object)leftEntry, (Object)rightEntry);
    }

    @Override
    public void disSelected() {
        this.isShowPanel = false;
        if (this.presenceRecordPanel != null) {
            this.presenceRecordPanel.onDisSelect();
        }
        if (this.passRecordPanel != null) {
            this.passRecordPanel.onDisSelect();
        }
        if (this.specialCarMenu != null && this.specialCarMenu.isVisible()) {
            this.specialCarMenu.setVisible(false);
        }
    }

    @Override
    public void doSelect() {
        this.isShowPanel = true;
        if (this.presenceRecordPanel != null) {
            this.presenceRecordPanel.onSelect();
        }
        if (this.passRecordPanel != null) {
            this.passRecordPanel.onSelect();
        }
        this.doPlayCalmera();
        this.setEqsState0();
    }

    public void doPlayCalmera() {
        if (this.lockPlay) {
            return;
        }
        if (!this.isShowPanel) {
            return;
        }
        this.playCamera(this.leftPane, false);
        this.playCamera(this.rightPane, false);
    }

    private void playCamera(Panex pex, boolean init) {
        try {
            if (this.lockPlay) {
                return;
            }
            if (!this.isShowPanel) {
                return;
            }
            if (pex != null && pex.videoCanvas != null && pex.hwnd != null) {
                if (pex.cameraNo != null && pex.cameraNo.length() > 0) {
                    Object onj;
                    Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(pex.cameraNo);
                    if (eq != null && (onj = eq.getEquipmentAction()) instanceof CameraAction) {
                        Long x;
                        CameraAction action = (CameraAction)onj;
                        if (!action.isWorkingProperly() && !init) {
                            pex.videoCanvas.resetCount();
                        }
                        if ((x = action.getPlayingComponentID()) == null || x.longValue() != pex.hwnd.longValue()) {
                            if (!init) {
                                pex.videoCanvas.resetCount();
                            }
                            HashMap<String, Object> param = new HashMap<String, Object>();
                            param.put("componentID", pex.hwnd);
                            action.play(param);
                        }
                    }
                } else if (!init) {
                    pex.videoCanvas.resetCount();
                }
            }
        }
        catch (Throwable e) {
            LogUtil.getLog().error((Object)"", e);
        }
    }

    @Override
    public void onMainWindowDispose() {
        try {
            if (this.stateMoniterHandler != null) {
                this.stateMoniterHandler.cancel(true);
            }
            if (this.presenceRecordPanel != null) {
                this.presenceRecordPanel.onMainWindowDispose();
            }
        }
        finally {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().unRegisterParkingEventListener(this);
        }
    }

    @Override
    public Component getLayerComponent() {
        return this;
    }

    private void onSelectCamera(String cmd, boolean storeConfig) {
        boolean s;
        String notEno;
        String notCno;
        Panex notSelectPanex;
        Panex selectpanex;
        String selctLC = "L:";
        String key = cmd.substring("L:".length(), cmd.length());
        int plu = key.lastIndexOf(43);
        if (plu == -1) {
            return;
        }
        String selectChannelNo = key.substring(0, plu);
        String selectCameraNo = key.substring(plu + 1, key.length());
        boolean isLeft = cmd.startsWith("L:");
        if (isLeft) {
            selectpanex = this.leftPane;
            notSelectPanex = this.rightPane;
        } else {
            selectpanex = this.rightPane;
            notSelectPanex = this.leftPane;
        }
        if (selectChannelNo.equals(selectpanex.chanelNo) && selectCameraNo.equals(selectpanex.cameraNo)) {
            return;
        }
        Properties newConfig = new Properties();
        if (isLeft) {
            newConfig.setProperty("leftcno", selectChannelNo);
            newConfig.setProperty("lefteno", selectCameraNo);
            notCno = "rightcno";
            notEno = "righteno";
        } else {
            newConfig.setProperty("rightcno", selectChannelNo);
            newConfig.setProperty("righteno", selectCameraNo);
            notCno = "leftcno";
            notEno = "lefteno";
        }
        if (selectChannelNo.equals(notSelectPanex.chanelNo)) {
            if (selectCameraNo.equals(notSelectPanex.cameraNo)) {
                newConfig.setProperty(notCno, selectpanex.chanelNo);
                newConfig.setProperty(notEno, selectpanex.cameraNo);
            } else {
                newConfig.setProperty(notCno, notSelectPanex.chanelNo);
                newConfig.setProperty(notEno, notSelectPanex.cameraNo);
            }
        } else {
            newConfig.setProperty(notCno, notSelectPanex.chanelNo);
            newConfig.setProperty(notEno, notSelectPanex.cameraNo);
        }
        KeyValueEntry<KeyValueEntry<PassChannel, Equipment>, KeyValueEntry<PassChannel, Equipment>> ents = this.getChanelEquipment(newConfig);
        KeyValueEntry leftEntry = (KeyValueEntry)ents.getKey();
        KeyValueEntry rightEntry = (KeyValueEntry)ents.getValue();
        Properties newConfig0 = new Properties();
        newConfig0.setProperty("leftcno", leftEntry.getKey() == null ? "" : ((PassChannel)leftEntry.getKey()).getChannelNo());
        newConfig0.setProperty("lefteno", leftEntry.getValue() == null ? "" : ((Equipment)leftEntry.getValue()).getEquipmentNo());
        newConfig0.setProperty("rightcno", rightEntry.getKey() == null ? "" : ((PassChannel)rightEntry.getKey()).getChannelNo());
        newConfig0.setProperty("righteno", rightEntry.getValue() == null ? "" : ((Equipment)rightEntry.getValue()).getEquipmentNo());
        if (storeConfig && !this.guiPassMainConfig.equals(newConfig0)) {
            this.guiPassMainConfig.putAll((Map<?, ?>)newConfig0);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile("gui", configName, configName, this.guiPassMainConfig);
        }
        boolean playLeft = false;
        boolean playRight = false;
        if (newConfig0.getProperty("leftcno").equals(this.leftPane.chanelNo)) {
            if (!newConfig0.getProperty("lefteno").equals(this.leftPane.cameraNo)) {
                this.stopPlayCamera0(this.leftPane.cameraNo);
                this.leftPane.cameraNo = newConfig0.getProperty("lefteno");
                playLeft = true;
            }
        } else {
            this.stopPlayCamera0(this.leftPane.cameraNo);
            this.leftPane.setPanelChannel((PassChannel)leftEntry.getKey(), (Equipment)leftEntry.getValue(), true);
            this.setEqsState1(this.leftPane);
            playLeft = true;
        }
        if (newConfig0.getProperty("rightcno").equals(this.rightPane.chanelNo)) {
            if (!newConfig0.getProperty("righteno").equals(this.rightPane.cameraNo)) {
                this.stopPlayCamera0(this.rightPane.cameraNo);
                this.rightPane.cameraNo = newConfig0.getProperty("righteno");
                playRight = true;
            }
        } else {
            this.stopPlayCamera0(this.rightPane.cameraNo);
            this.rightPane.setPanelChannel((PassChannel)rightEntry.getKey(), (Equipment)rightEntry.getValue(), true);
            this.setEqsState1(this.rightPane);
            playRight = true;
        }
        boolean bl = s = playLeft || playRight;
        if (s) {
            final boolean playLeft0 = playLeft;
            final boolean playRight0 = playRight;
            if (!this.lockPlay) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MainPassMonitorPanel.this.lockPlay) {
                            return;
                        }
                        if (!MainPassMonitorPanel.this.isShowPanel) {
                            return;
                        }
                        if (playLeft0) {
                            MainPassMonitorPanel.this.playCamera(MainPassMonitorPanel.this.leftPane, false);
                        }
                        if (playRight0) {
                            MainPassMonitorPanel.this.playCamera(MainPassMonitorPanel.this.rightPane, false);
                        }
                    }
                });
            }
        }
    }

    private void stopPlayCamera0(String cameraNo) {
        try {
            CameraAction action;
            Long x;
            Object onj;
            Equipment eq;
            if (cameraNo != null && cameraNo.length() > 0 && (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(cameraNo)) != null && (onj = eq.getEquipmentAction()) instanceof CameraAction && (x = (action = (CameraAction)onj).getPlayingComponentID()) != null) {
                OperationFuture<Integer> f = action.stopPlay(null);
                try {
                    f.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable e) {
            GuiLog.getLog().error((Object)"", e);
        }
    }

    private void popSelectchanelMenu(String cmd, MouseEvent event) {
        Panex panex = this.getPanex(event);
        if (panex == null) {
            return;
        }
        int count = panex.selectchanelMenu.getComponentCount();
        int i = 0;
        while (i < count) {
            Component c = panex.selectchanelMenu.getComponent(i);
            if (c != null && c instanceof JMenuItem) {
                ((JMenuItem)c).removeActionListener(this.actionListener);
            }
            ++i;
        }
        panex.selectchanelMenu.removeAll();
        int itemFontSize = (int)Math.round(this.mainFrame.getRootSize().getHeight() * 13.0 / 768.0);
        Font itemFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
        Enumeration<PassChannel> channels = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
        String tx = panex == this.leftPane ? "L:" : "R:";
        char serl = '\u221a';
        String selectkey = String.valueOf(tx) + panex.chanelNo + "+" + panex.cameraNo;
        if (channels != null) {
            while (channels.hasMoreElements()) {
                PassChannel pchanel = channels.nextElement();
                if (!pchanel.isLocalHostChannel()) continue;
                List<Equipment> eqlist = pchanel.getEquipmentList(33);
                if (eqlist != null && !eqlist.isEmpty()) {
                    for (Equipment eq : eqlist) {
                        JMenuItem item = new JMenuItem();
                        String key = String.valueOf(tx) + pchanel.getChannelNo() + "+" + eq.getEquipmentNo();
                        String c = key.equals(selectkey) ? String.valueOf(serl) + " " : "\u3000";
                        String textName = String.valueOf(c) + pchanel.getChannel().getChannel_name() + " [" + eq.getName() + "]";
                        item.setText(textName);
                        item.setActionCommand(key);
                        item.addActionListener(this.actionListener);
                        item.setFont(itemFont);
                        int w = SwingUtil.getStringFontSize((String)new StringBuilder((String)String.valueOf((Object)textName)).append((String)"\u7a7a\u683c\u7a7a\u683c").toString(), (Font)itemFont).width;
                        item.setPreferredSize(new Dimension(w, 2 * itemFontSize + 3));
                        panex.selectchanelMenu.add(item);
                    }
                    continue;
                }
                JMenuItem item = new JMenuItem();
                String key = String.valueOf(tx) + pchanel.getChannelNo() + "+";
                String c = key.equals(selectkey) ? String.valueOf(serl) + " " : "\u3000";
                String textName = String.valueOf(c) + pchanel.getChannel().getChannel_name();
                item.setText(textName);
                item.setActionCommand(key);
                item.addActionListener(this.actionListener);
                item.setFont(itemFont);
                int w = SwingUtil.getStringFontSize((String)new StringBuilder((String)String.valueOf((Object)textName)).append((String)"\u7a7a\u683c\u7a7a\u683c").toString(), (Font)itemFont).width;
                item.setPreferredSize(new Dimension(w, 2 * itemFontSize + 3));
                panex.selectchanelMenu.add(item);
            }
        }
        if (panex.selectchanelMenu.getComponentCount() == 0) {
            String textName = "\u672c\u673a\u672a\u914d\u7f6e\u7ba1\u7406\u901a\u9053";
            JMenuItem item = new JMenuItem(textName);
            item.setFont(itemFont);
            int wa = SwingUtil.getStringFontSize((String)new StringBuilder((String)"  ").append((String)textName).append((String)"  ").toString(), (Font)itemFont).width;
            item.setPreferredSize(new Dimension(wa, 2 * itemFontSize + 3));
            panex.selectchanelMenu.add(item);
        }
        Point p = event.getPoint();
        panex.selectchanelMenu.show((Component)event.getSource(), p.x, p.y);
    }

    KeyValueEntry<String, String> getCurrentSelectCamera(boolean right) {
        Panex pane;
        Panex panex = pane = right ? this.rightPane : this.leftPane;
        if (pane == null) {
            return null;
        }
        String channelNo = pane.chanelNo;
        if (channelNo == null || channelNo.length() == 0) {
            return null;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            return null;
        }
        String cameraNo = pane.cameraNo;
        if (cameraNo == null || cameraNo.length() == 0) {
            return null;
        }
        return new KeyValueEntry((Object)channelNo, (Object)cameraNo);
    }

    void resetMonitorPaneByConfig() {
        KeyValueEntry<KeyValueEntry<PassChannel, Equipment>, KeyValueEntry<PassChannel, Equipment>> ents = this.getChanelEquipment(this.guiPassMainConfig);
        if (ents != null) {
            KeyValueEntry leftEntry = (KeyValueEntry)ents.getKey();
            KeyValueEntry rightEntry = (KeyValueEntry)ents.getValue();
            if (leftEntry != null && leftEntry.getKey() != null && leftEntry.getValue() != null) {
                this.selectCamera(false, ((PassChannel)leftEntry.getKey()).getChannelNo(), ((Equipment)leftEntry.getValue()).getEquipmentNo());
            }
            if (rightEntry != null && rightEntry.getKey() != null && rightEntry.getValue() != null) {
                this.selectCamera(true, ((PassChannel)rightEntry.getKey()).getChannelNo(), ((Equipment)rightEntry.getValue()).getEquipmentNo());
            }
        }
    }

    void selectCamera(boolean right, String channelNo, String cameraNo) {
        if (!this.isShowPanel) {
            return;
        }
        if (channelNo == null || channelNo.length() == 0) {
            return;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            return;
        }
        if (cameraNo == null || cameraNo.length() == 0) {
            return;
        }
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(cameraNo);
        if (eq == null) {
            return;
        }
        if (eq.getDriver() == null) {
            return;
        }
        if (eq.getType() != 33) {
            return;
        }
        List<String> channelList = eq.getChannelNos();
        if (channelList == null || channelList.isEmpty()) {
            return;
        }
        if (!channelList.contains(channelNo)) {
            return;
        }
        if (eq.getEquipmentAction() instanceof CameraAction) {
            String tx = right ? "R:" : "L:";
            String cmd = String.valueOf(tx) + channelNo + "+" + eq.getEquipmentNo();
            this.onSelectCamera(cmd, false);
        }
    }

    private Panex getPanex(MouseEvent event) {
        CarparkMainFrame.RoundPanelButton rb = this.getRoundPanelButton(event);
        if (rb != null) {
            if (this.leftPane.selectChannelButton == rb) {
                return this.leftPane;
            }
            if (this.rightPane.selectChannelButton == rb) {
                return this.rightPane;
            }
            if (this.leftPane.roudButtonsList != null && this.leftPane.roudButtonsList.contains(rb)) {
                return this.leftPane;
            }
            if (this.rightPane.roudButtonsList != null && this.rightPane.roudButtonsList.contains(rb)) {
                return this.rightPane;
            }
        }
        return null;
    }

    private CarparkMainFrame.RoundPanelButton getRoundPanelButton(MouseEvent e) {
        Component c;
        Container p1;
        Object scs = e.getSource();
        if (scs instanceof CarparkMainFrame.RoundPanelButton) {
            return (CarparkMainFrame.RoundPanelButton)scs;
        }
        if (scs instanceof Component && (p1 = (c = (Component)scs).getParent()) != null) {
            if (p1 instanceof CarparkMainFrame.RoundPanelButton) {
                return (CarparkMainFrame.RoundPanelButton)p1;
            }
            Container p2 = p1.getParent();
            if (p2 != null && p2 instanceof CarparkMainFrame.RoundPanelButton) {
                return (CarparkMainFrame.RoundPanelButton)p2;
            }
        }
        return null;
    }

    @Override
    public void onClick(String cmd, MouseEvent event) {
        if (cmd != null) {
            if (cmd.startsWith("main_select_channel_")) {
                this.popSelectchanelMenu(cmd, event);
            } else if (cmd.startsWith("chanel_plate_pass_")) {
                Panex panex = this.getPanex(event);
                if (panex != null) {
                    if (panex.chanelNo != null && panex.chanelNo.length() > 0) {
                        String channelNo = panex.chanelNo;
                        MainConfirmEvent confirmEvent = MainPassConfirmDialog.getManualConfirmEent(channelNo);
                        if (confirmEvent != null) {
                            confirmEvent.setShowNow(true);
                            MainPassConfirmDialog.addConfirmEvent(confirmEvent, this.mainFrame);
                        } else {
                            PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                            if (passChannel == null) {
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u65e0\u6548\u901a\u9053\u8bbe\u7f6e", 4));
                            } else {
                                String palteName = "\u8bf7\u8f93\u5165\u8f66\u724c";
                                ReadPassportNumberEvent readp = new ReadPassportNumberEvent(passChannel, palteName, 6, channelNo);
                                readp.setPlateNumber(palteName);
                                readp.setManualTrigger(true);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(readp);
                            }
                        }
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                    }
                }
            } else if (cmd.startsWith("open_pole_")) {
                Panex panex = this.getPanex(event);
                if (panex == null || panex.chanelNo == null || panex.chanelNo.length() == 0) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5f00\u95f8\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                } else {
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(panex.chanelNo);
                    if (passChannel == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5f00\u95f8\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                    } else {
                        PassSession cancelSession = passChannel.getLastSession();
                        String plate = null;
                        if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                            plate = cancelSession.getPassPlate();
                        }
                        this.mainFrame.doExceptionPass(passChannel, true, 0, "0", "\u8f6f\u4ef6\u754c\u9762\u6309\u952e\u5f00\u95f8", plate, cancelSession);
                    }
                }
            } else if (cmd.startsWith("close_pole_")) {
                Panex panex = this.getPanex(event);
                if (panex == null || panex.chanelNo == null || panex.chanelNo.length() == 0) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5173\u95f8\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                } else {
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(panex.chanelNo);
                    if (passChannel == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5173\u95f8\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                    } else {
                        passChannel.downPole(true);
                    }
                }
            } else if (cmd.startsWith("hand_reg_plate_")) {
                Panex panex = this.getPanex(event);
                if (panex == null || panex.chanelNo == null || panex.chanelNo.length() == 0) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                } else {
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(panex.chanelNo);
                    if (passChannel == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                    } else {
                        passChannel.triggerRegPlate();
                    }
                }
            } else if (cmd.startsWith("special_pass_")) {
                Panex panex = this.getPanex(event);
                if (panex == null || panex.chanelNo == null || panex.chanelNo.length() == 0) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u653e\u884c\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                } else {
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(panex.chanelNo);
                    if (passChannel == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u653e\u884c\u5931\u8d25\uff0c\u6ca1\u6709\u8bbe\u7f6e\u901a\u9053", 4));
                    } else {
                        Map<String, CarparkAttribute> specialCarAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(4);
                        if (specialCarAttrMap == null || specialCarAttrMap.isEmpty()) {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u653e\u884c\u5931\u8d25\uff0c\u672a\u5b9a\u4e49\u7279\u6b8a\u8f66\u8f86\u7c7b\u578b\uff0c\u8bf7\u5230\u7ba1\u7406\u7cfb\u7edf-\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u4e1a\u52a1\u5c5e\u6027\u8bbe\u7f6e-\u7279\u6b8a\u8f66\u8f86\u8bbe\u7f6e\u4e2d\u8fdb\u884c\u8bbe\u7f6e\uff01", 4));
                        } else {
                            int count = this.specialCarMenu.getComponentCount();
                            ArrayList<SpecialCarMenuItem> itemList = new ArrayList<SpecialCarMenuItem>(count);
                            int i = 0;
                            while (i < count) {
                                Component c = this.specialCarMenu.getComponent(i);
                                if (c != null && c instanceof SpecialCarMenuItem) {
                                    itemList.add((SpecialCarMenuItem)c);
                                }
                                ++i;
                            }
                            int showItemCount = specialCarAttrMap.size();
                            if (itemList.size() != showItemCount) {
                                for (SpecialCarMenuItem item : itemList) {
                                    item.removeActionListener(this);
                                }
                                this.specialCarMenu.removeAll();
                                this.specialCarMenu.setVisible(false);
                                int maxFontSize = 4;
                                for (CarparkAttribute arr : specialCarAttrMap.values()) {
                                    if (arr.getAttribute_value() == null || arr.getAttribute_value().length() <= maxFontSize) continue;
                                    maxFontSize = arr.getAttribute_value().length();
                                }
                                if (++maxFontSize < 8) {
                                    maxFontSize = 8;
                                }
                                for (CarparkAttribute arr : specialCarAttrMap.values()) {
                                    SpecialCarMenuItem item = new SpecialCarMenuItem();
                                    item.setPreferredSize(new Dimension(maxFontSize * this.specialCarMenuFontSize, this.specialCarMenuHeight));
                                    item.setFont(this.specialCarMenuFont);
                                    item.channelNo = passChannel.getChannelNo();
                                    item.reason_code = arr.getAttribute_key();
                                    item.des = arr.getAttribute_value();
                                    item.addActionListener(this);
                                    item.setText(item.des);
                                    this.specialCarMenu.add(item);
                                }
                            } else {
                                int index = 0;
                                for (CarparkAttribute arr : specialCarAttrMap.values()) {
                                    SpecialCarMenuItem item = (SpecialCarMenuItem)itemList.get(index);
                                    item.channelNo = passChannel.getChannelNo();
                                    item.reason_code = arr.getAttribute_key();
                                    item.des = arr.getAttribute_value();
                                    String text = item.des;
                                    if (text == null) {
                                        text = "";
                                    }
                                    if (!text.equals(item.getText())) {
                                        item.setText(text);
                                    }
                                    ++index;
                                }
                            }
                            if (!this.specialCarMenu.isVisible()) {
                                this.specialCarMenu.show((Component)event.getSource(), event.getX(), event.getY());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public int[] getIntestEventId() {
        return new int[]{3324, 5628, 3836};
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (event instanceof LocalPassRecordEvent) {
            LocalPassRecordEvent e = (LocalPassRecordEvent)event;
            if (e.getLocalPassRecord() != null && this.passRecordPanel != null) {
                this.passRecordPanel.setPassRecord(e.getLocalPassRecord());
            }
        } else if ((event instanceof PassRecordEvent || event instanceof RefreshPresenceRecordEvent) && this.presenceRecordPanel != null) {
            this.presenceRecordPanel.reload();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof SpecialCarMenuItem) {
            SpecialCarMenuItem item = (SpecialCarMenuItem)source;
            PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(item.channelNo);
            if (passChannel != null) {
                PassSession cancelSession = passChannel.getLastSession();
                String plate = null;
                if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                    plate = cancelSession.getPassPlate();
                }
                this.mainFrame.doExceptionPass(passChannel, true, 1, item.reason_code, item.des, plate, cancelSession);
            }
        }
    }

    private class Panex {
        JPanel linelabel;
        JPanel panel;
        XYConstraints panelXYConstraints;
        JPanel topPanel;
        XYConstraints topPanelConstraints;
        String chanelNo = "";
        JPanel videoPanel;
        VideoCanvas videoCanvas;
        XYConstraints videoPanelConstraints;
        int maxTabFontCount = 8;
        int tabFontSize;
        int tabHeight;
        int maxTopButtonSize;
        int buttonMarginW = 0;
        String cameraNo = "";
        List<JLabel> eqStateLabelList;
        Dimension eqStateSize;
        Long hwnd = null;
        CarparkMainFrame.RoundPanelButton selectChannelButton;
        List<CarparkMainFrame.RoundPanelButton> roudButtonsList = new LinkedList<CarparkMainFrame.RoundPanelButton>();
        private JPopupMenu selectchanelMenu;
        private XYConstraints lineCons;

        private Panex() {
        }

        void resetCmd() {
            for (CarparkMainFrame.RoundPanelButton t : this.roudButtonsList) {
                int o;
                if (t.getCmd() == null || t.getCmd().length() <= 0 || (o = t.getCmd().lastIndexOf(95)) == -1) continue;
                String s = String.valueOf(t.getCmd().substring(0, o + 1)) + this.cameraNo;
                t.setCmd(s);
            }
        }

        void setPanelChannel(PassChannel channel, Equipment camera, boolean repaint) {
            this.cameraNo = camera == null ? "" : camera.getEquipmentNo();
            if (channel == null) {
                this.chanelNo = "";
                this.selectChannelButton.getTextLabel().setText("\u672a\u8bbe\u901a\u9053");
            } else {
                this.chanelNo = channel.getChannelNo();
                String sx = channel.getChannel().getChannel_name();
                if (sx == null || sx.length() == 0) {
                    sx = "\u672a\u77e5\u901a\u9053";
                }
                this.selectChannelButton.getTextLabel().setText(sx);
            }
            this.resetCmd();
            int rbwidth = (this.selectChannelButton.getTextLabel().getText().length() + 2) * this.tabFontSize + this.selectChannelButton.getTextLabel().getIconTextGap() + this.selectChannelButton.getTextLabel().getIcon().getIconWidth();
            int maxSize = this.maxTopButtonSize - 2;
            if (rbwidth > maxSize) {
                rbwidth = maxSize;
            }
            Container pareant = this.selectChannelButton.getParent();
            pareant.remove(this.selectChannelButton);
            pareant.add((Component)this.selectChannelButton, new XYConstraints(1, 1, rbwidth, this.tabHeight));
            if (repaint) {
                pareant.repaint();
            }
        }

        void intPanex(CarparkMainFrame frame, MainPassMonitorPanel mainpanel, XYConstraints cons) {
            this.panel = frame.createRoundPanel();
            this.panel.setLayout(new XYLayout());
            this.panel.setBackground(Color.WHITE);
            this.panelXYConstraints = cons;
            mainpanel.add((Component)this.panel, this.panelXYConstraints);
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new XYLayout());
            this.topPanel.setBackground(this.panel.getBackground());
            int mrginLeft = (int)Math.round((double)this.panelXYConstraints.getWidth() * 14.0 / 496.0);
            int mrginTop = (int)Math.round((double)this.panelXYConstraints.getHeight() * 14.0 / 608.0);
            int topPanelX = mrginLeft;
            int topPanelY = mrginTop;
            int topPanelWidth = this.panelXYConstraints.getWidth() - 2 * topPanelX;
            int topPanelHeight = (int)Math.round((double)this.panelXYConstraints.getHeight() * 25.0 / 608.0);
            this.topPanelConstraints = new XYConstraints(topPanelX - 2, topPanelY, topPanelWidth + 2, topPanelHeight);
            this.panel.add((Component)this.topPanel, this.topPanelConstraints);
            int videoFontSize = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
            this.videoPanel = new JPanel();
            this.videoPanel.setBackground(this.panel.getBackground());
            this.videoPanel.setLayout(new GridLayout(1, 1));
            this.videoCanvas = new VideoCanvas();
            this.videoCanvas.setBackground(Color.decode("#EEF3F7"));
            this.videoCanvas.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, videoFontSize));
            this.videoPanel.add(this.videoCanvas);
            int videoPanelWidth = this.panelXYConstraints.getWidth() - 2 * mrginLeft;
            int videoPanelHeight = (int)Math.round((double)this.panelXYConstraints.getHeight() * 260.0 / 608.0);
            int videoPanelX = mrginLeft;
            int videoPanelY = topPanelY + topPanelHeight;
            this.videoPanelConstraints = new XYConstraints(videoPanelX, videoPanelY, videoPanelWidth, videoPanelHeight);
            this.panel.add((Component)this.videoPanel, this.videoPanelConstraints);
            if (MainPassMonitorPanel.this.noVideoImage == null) {
                BufferedImage a = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("no_video");
                MainPassMonitorPanel.this.noVideoImage = SwingUtil.resizeImage((Image)a, videoPanelWidth, videoPanelHeight);
            }
            this.videoCanvas.setNoVideoImage(MainPassMonitorPanel.this.noVideoImage);
            this.videoPanel.setBorder(BorderFactory.createLineBorder(Color.decode("#BFBFBF"), 1));
            this.initMidleButton(frame);
            this.initTopPanel(frame);
            this.selectchanelMenu = new JPopupMenu();
            this.selectchanelMenu.setBorder(BorderFactory.createLineBorder(new Color(209, 217, 222)));
        }

        private void initTopPanel(CarparkMainFrame frame) {
            int labHeight;
            int arc = (int)Math.round(frame.getRootSize().getHeight() * 8.0 / 768.0);
            CarparkMainFrame.RoundPanelButton rb = new CarparkMainFrame.RoundPanelButton(arc, arc);
            rb.setCmd("main_select_channel_" + this.chanelNo);
            int rbFontSize = (int)Math.round(frame.getRootSize().getHeight() * 12.0 / 768.0);
            Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbFontSize);
            rb.getTextLabel().setToolTipText("\u70b9\u51fb\u66f4\u6539\u8f66\u9053");
            rb.getTextLabel().setFont(font);
            rb.getTextLabel().setForeground(Color.WHITE);
            rb.getTextLabel().setCursor(new Cursor(12));
            rb.setBorder(new RoundBorder(this.topPanel.getBackground(), arc));
            rb.setBackground(Color.decode("#4994F9"));
            rb.getTextLabel().addMouseListener(frame.roundButtonMouseListender);
            this.roudButtonsList.add(rb);
            this.selectChannelButton = rb;
            int picWith = rbFontSize * 3 / 4;
            int picHeight = (int)Math.round((double)picWith * 16.0 / 24.0);
            rb.getTextLabel().setHorizontalTextPosition(2);
            rb.getTextLabel().setHorizontalAlignment(0);
            rb.getTextLabel().setIconTextGap(5);
            int rbwidth = 6 * rbFontSize + rb.getTextLabel().getIconTextGap() + picWith;
            this.maxTopButtonSize = (this.maxTabFontCount + 2) * rbFontSize + rb.getTextLabel().getIconTextGap() + picWith;
            int mazz1 = (int)Math.round((double)this.topPanelConstraints.getHeight() * 6.0 / 59.0);
            int rbHeight = this.topPanelConstraints.getHeight() + mazz1;
            this.tabFontSize = rbFontSize;
            this.tabHeight = rbHeight;
            BufferedImage a = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("ic_down_white");
            ImageIcon icon = new ImageIcon(SwingUtil.resizeImage((Image)a, picWith, picHeight));
            rb.getTextLabel().setIcon(icon);
            JPanel p1 = new JPanel();
            p1.setBackground(this.topPanel.getBackground());
            p1.setLayout(new XYLayout());
            p1.add((Component)rb, new XYConstraints(1, 1, rbwidth, rbHeight));
            this.topPanel.add((Component)p1, new XYConstraints(0, 0, this.maxTopButtonSize, this.topPanelConstraints.getHeight()));
            int labWidth = labHeight = this.topPanelConstraints.getHeight();
            int marginSize = this.buttonMarginW;
            int reMainWidth = this.topPanelConstraints.getWidth() - this.maxTopButtonSize;
            int count = reMainWidth / (labWidth + marginSize);
            this.eqStateLabelList = count > 0 ? new ArrayList<JLabel>(count) : new LinkedList<JLabel>();
            int mazz = (int)Math.round((double)labHeight * 5.0 / 59.0);
            int y = (this.topPanelConstraints.getHeight() - labHeight) / 2 + mazz;
            int x = this.topPanelConstraints.getWidth() - labWidth;
            this.eqStateSize = new Dimension(labWidth, labHeight);
            int i = 0;
            while (i < count) {
                JPanel p = new JPanel();
                p.setBackground(this.topPanel.getBackground());
                p.setLayout(new GridLayout(1, 1));
                JLabel l = new JLabel();
                l.setHorizontalAlignment(0);
                p.add(l);
                this.topPanel.add((Component)p, new XYConstraints(x, y, labWidth, labHeight));
                x -= labWidth + marginSize;
                this.eqStateLabelList.add(l);
                ++i;
            }
        }

        private void initMidleButton(CarparkMainFrame frame) {
            LinkedHashMap<String, KeyValueEntry> buttons = new LinkedHashMap<String, KeyValueEntry>();
            buttons.put("hand_reg_plate_" + this.chanelNo, new KeyValueEntry((Object)"\u8bc6\u522b\u8f66\u724c", null));
            buttons.put("special_pass_" + this.chanelNo, new KeyValueEntry((Object)"\u7279\u6b8a\u8f66\u8f86", null));
            buttons.put("chanel_plate_pass_" + this.chanelNo, new KeyValueEntry((Object)"\u8f66\u724c\u653e\u884c", null));
            buttons.put("close_pole_" + this.chanelNo, new KeyValueEntry((Object)"\u843d\u6746", null));
            buttons.put("open_pole_" + this.chanelNo, new KeyValueEntry((Object)"\u8d77\u6746", null));
            int arc = (int)Math.round(frame.getRootSize().getHeight() * 8.0 / 768.0);
            RoundBorder border = new RoundBorder(this.panel.getBackground(), arc);
            Cursor handCursor = new Cursor(12);
            Color rbFontColor = Color.decode("#FFFFFF");
            int rbFontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
            Color rbMoveOutColor1 = Color.decode("#00b3ca");
            Color rbMoveOnColor1 = Color.decode("#0093a6");
            Color rbMoveOutColor2 = Color.decode("#38a0f4");
            Color rbMoveOnColor2 = Color.decode("#1690f3");
            Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbFontSize);
            int x = this.videoPanelConstraints.getX();
            int totalSize = this.videoPanelConstraints.getWidth();
            int marginTop = (int)Math.round((double)this.panelXYConstraints.getHeight() * 8.0 / 608.0);
            int y = marginTop + this.videoPanelConstraints.getY() + this.videoPanelConstraints.getHeight();
            int height = (int)Math.round((double)this.panelXYConstraints.getHeight() * 30.0 / 608.0);
            int totalx = 0;
            for (Map.Entry en : buttons.entrySet()) {
                int width = SwingUtil.getStringFontSize((String)new StringBuilder((String)String.valueOf((Object)((String)((KeyValueEntry)en.getValue()).getKey()))).append((String)"\u7ad9\u4f4d").toString(), (Font)font).width;
                ((KeyValueEntry)en.getValue()).setValue((Object)width);
                totalx += width;
            }
            int grap0 = (totalSize - totalx) / (buttons.size() - 1);
            if (grap0 < 0) {
                grap0 = 0;
            }
            int grap1 = 0;
            int grap = grap0;
            if (grap > 10) {
                grap = 10;
                grap1 = (grap0 - grap) * (buttons.size() - 1);
            }
            this.buttonMarginW = grap;
            int index = 0;
            for (Map.Entry en : buttons.entrySet()) {
                CarparkMainFrame.RoundPanelButton rb = new CarparkMainFrame.RoundPanelButton(arc, arc);
                rb.setCmd((String)en.getKey());
                rb.getTextLabel().setFont(font);
                rb.getTextLabel().setForeground(rbFontColor);
                rb.getTextLabel().setText((String)((KeyValueEntry)en.getValue()).getKey());
                rb.getTextLabel().setCursor(handCursor);
                rb.setBorder(border);
                if (index < 3) {
                    rb.setBackground(rbMoveOutColor1);
                    rb.setMoveOutBgColor(rbMoveOutColor1);
                    rb.setMoveOnBgColor(rbMoveOnColor1);
                } else {
                    rb.setBackground(rbMoveOutColor2);
                    rb.setMoveOutBgColor(rbMoveOutColor2);
                    rb.setMoveOnBgColor(rbMoveOnColor2);
                }
                rb.getTextLabel().addMouseListener(frame.roundButtonMouseListender);
                JPanel p1 = new JPanel();
                p1.setBackground(this.panel.getBackground());
                p1.setLayout(new XYLayout());
                p1.add((Component)rb, new XYConstraints(1, 1, (Integer)((KeyValueEntry)en.getValue()).getValue(), height));
                this.panel.add((Component)p1, new XYConstraints(x - 1, y - 1, (Integer)((KeyValueEntry)en.getValue()).getValue() + 2, height + 2));
                x += grap + (Integer)((KeyValueEntry)en.getValue()).getValue();
                if (index == 2 && grap1 > 0) {
                    x += grap1;
                }
                this.roudButtonsList.add(rb);
                ++index;
            }
            int marginTop1 = (int)Math.round((double)this.panelXYConstraints.getHeight() * 10.0 / 608.0);
            this.linelabel = new JPanel();
            this.linelabel.setOpaque(true);
            this.linelabel.setBackground(Color.decode("#DBDBDB"));
            int lineHeight = (int)Math.round((double)this.panelXYConstraints.getHeight() * 1.0 / 608.0);
            int lineWidth = this.videoPanelConstraints.getWidth();
            int lineX = this.videoPanelConstraints.getX();
            int lineY = y + height + marginTop1;
            frame.setConfirmDialogAbsY(lineY);
            frame.confrimDialogLineComponent = this.linelabel;
            this.lineCons = new XYConstraints(lineX, lineY, lineWidth, lineHeight);
            this.panel.add((Component)this.linelabel, this.lineCons);
        }
    }

    private static class SpecialCarMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private volatile String channelNo;
        private volatile String reason_code;
        private volatile String des;

        private SpecialCarMenuItem() {
        }
    }
}

