/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class MainPassRecordPanel
extends JPanel {
    private static final long serialVersionUID = -5340416092495993752L;
    private JLayeredPane picLayer;
    private JPanel onePicPanel;
    private PicLabel onePicLabel;
    private Dimension onePicSize;
    private JPanel halfPicPanel;
    private PicLabel topPicLabel;
    private PicLabel bottomPicLabel;
    private Dimension halfTopPicSize;
    private Dimension halfBottomPicSize;
    private List<JLabel> infoLabelList;
    private Dimension rootSize;
    private volatile Component picSelectP = null;
    private volatile boolean selected = true;
    private AtomicReference<CarparkPassRecord> needUpdateRef = new AtomicReference();
    private volatile CarparkPassRecord lastDisplayRecord;
    private final Object setRecordLock = new Object();

    public void init(Dimension size, CarparkMainFrame frame) {
        this.rootSize = frame.getRootSize();
        this.setLayout(new XYLayout());
        int halfWidth = size.width / 2;
        this.picLayer = new JLayeredPane();
        Dimension halfSize = new Dimension(halfWidth, size.height);
        this.picLayer.setPreferredSize(halfSize);
        JPanel blankPanel0 = new JPanel();
        blankPanel0.setBackground(this.getBackground());
        blankPanel0.setBounds(0, 0, halfSize.width, halfSize.height);
        this.picLayer.add((Component)blankPanel0, 0);
        this.onePicPanel = new JPanel();
        this.onePicPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.onePicPanel.setBackground(this.getBackground());
        this.onePicSize = halfSize;
        this.onePicLabel = new PicLabel();
        this.onePicPanel.add(this.onePicLabel);
        this.onePicPanel.setBounds(0, 0, halfSize.width, halfSize.height);
        this.picLayer.add((Component)this.onePicPanel, 1);
        this.halfPicPanel = new JPanel();
        this.halfPicPanel.setLayout(new XYLayout());
        this.halfPicPanel.setBackground(this.getBackground());
        this.halfPicPanel.setBounds(0, 0, halfSize.width, halfSize.height);
        this.picLayer.add((Component)this.halfPicPanel, 2);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1, 1, 0, 0));
        topPanel.setBackground(this.getBackground());
        this.topPicLabel = new PicLabel();
        topPanel.add(this.topPicLabel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.bottomPicLabel = new PicLabel();
        bottomPanel.setBackground(this.getBackground());
        bottomPanel.add(this.bottomPicLabel);
        int lineH = 1;
        int topx = 0;
        int topy = 0;
        int topW = halfSize.width;
        int topHeight = (halfSize.height - lineH) / 2;
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.decode("#DBDBDB")));
        this.halfTopPicSize = new Dimension(topW, topHeight);
        XYConstraints topPanelCons = new XYConstraints(topx, topy, topW, topHeight + lineH);
        this.halfPicPanel.add((Component)topPanel, topPanelCons);
        this.halfBottomPicSize = new Dimension(topW, size.height - (topy += topPanelCons.getHeight()));
        this.halfPicPanel.add((Component)bottomPanel, new XYConstraints(topx, topy, this.halfBottomPicSize.width, this.halfBottomPicSize.height));
        int x = 0;
        int y = 0;
        this.add((Component)this.picLayer, new XYConstraints(x, y, halfSize.width, halfSize.height));
        JPanel rightPanel = new JPanel();
        rightPanel.setBackground(this.getBackground());
        int marginLeft = (int)Math.round(frame.getRootSize().getWidth() * 8.0 / 1024.0);
        int infoWidth = size.width - (x += halfSize.width + marginLeft);
        this.add((Component)rightPanel, new XYConstraints(x, y, infoWidth, halfSize.height));
        int count = 8;
        rightPanel.setLayout(new GridLayout(count, 1, 0, 0));
        this.infoLabelList = new ArrayList<JLabel>(count);
        int fontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
        Font textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        Color color = Color.decode("#758697");
        int i = 0;
        while (i < count) {
            JLabel inoLabel = new JLabel();
            inoLabel.setFont(textFont);
            inoLabel.setForeground(color);
            this.infoLabelList.add(inoLabel);
            rightPanel.add(inoLabel);
            ++i;
        }
    }

    public CarparkPassRecord getLastDisplayRecord() {
        if (this.lastDisplayRecord != null) {
            return this.lastDisplayRecord;
        }
        return this.needUpdateRef.get();
    }

    public void refreshPic() {
        if (!this.selected) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!MainPassRecordPanel.this.selected) {
                    return;
                }
                Object object = MainPassRecordPanel.this.setRecordLock;
                synchronized (object) {
                    CarparkPassRecord passRecord = MainPassRecordPanel.this.lastDisplayRecord;
                    if (passRecord == null) {
                        return;
                    }
                    if (passRecord.getExit_time() != null) {
                        String enterCarPic = passRecord.getEnter_car_pic();
                        String enterPlatePic = passRecord.getEnter_plate_pic();
                        if (enterCarPic != null && enterCarPic.length() > 0 && !MainPassRecordPanel.this.topPicLabel.loadImageOk) {
                            MainPassRecordPanel.this.loadPic(enterCarPic, enterPlatePic, MainPassRecordPanel.this.topPicLabel, MainPassRecordPanel.this.halfTopPicSize, false);
                        }
                        String exitCarPic = passRecord.getExit_car_pic();
                        String exitPlatePic = passRecord.getExit_plate_pic();
                        if (exitCarPic != null && exitCarPic.length() > 0 && !MainPassRecordPanel.this.bottomPicLabel.loadImageOk) {
                            MainPassRecordPanel.this.loadPic(exitCarPic, exitPlatePic, MainPassRecordPanel.this.bottomPicLabel, MainPassRecordPanel.this.halfBottomPicSize, false);
                        }
                    } else if (passRecord.getEnter_time() != null) {
                        String enterCarPic = passRecord.getEnter_car_pic();
                        String enterPlatePic = passRecord.getEnter_plate_pic();
                        if (enterCarPic != null && enterCarPic.length() > 0 && !MainPassRecordPanel.this.onePicLabel.loadImageOk) {
                            MainPassRecordPanel.this.loadPic(enterCarPic, enterPlatePic, MainPassRecordPanel.this.onePicLabel, MainPassRecordPanel.this.onePicSize, false);
                        }
                    }
                }
            }
        });
    }

    public void setPassRecord(final CarparkPassRecord passRecord) {
        if (passRecord == null || passRecord.getPass_time() == null) {
            return;
        }
        if (!this.selected) {
            CarparkPassRecord old = this.needUpdateRef.get();
            if (old != null) {
                if (old.getPass_time().getTime() <= passRecord.getPass_time().getTime()) {
                    this.needUpdateRef.set(passRecord);
                }
            } else {
                CarparkPassRecord cur = this.lastDisplayRecord;
                if (cur == null || cur.getPass_time() == null) {
                    this.needUpdateRef.set(passRecord);
                } else if (cur.getPass_time().getTime() <= passRecord.getPass_time().getTime()) {
                    this.needUpdateRef.set(passRecord);
                }
            }
            return;
        }
        CarparkPassRecord cur = this.lastDisplayRecord;
        if (cur != null && cur.getPass_time().getTime() > passRecord.getPass_time().getTime()) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = MainPassRecordPanel.this.setRecordLock;
                    synchronized (object) {
                        MainPassRecordPanel.this.lastDisplayRecord = passRecord;
                        if (passRecord.getExit_time() != null) {
                            MainPassRecordPanel.this.setExitRecord(passRecord);
                        } else if (passRecord.getEnter_time() != null) {
                            MainPassRecordPanel.this.setEnterRecord(passRecord);
                        }
                    }
                }
                catch (Exception ex) {
                    GuiLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
        });
    }

    private void setPicSelectedComponent(Component c) {
        if (this.picSelectP != c) {
            this.picLayer.moveToFront(c);
            this.picSelectP = c;
        }
    }

    private void setExitRecord(CarparkPassRecord passRecord) {
        String enterCarPic = passRecord.getEnter_car_pic();
        String enterPlatePic = passRecord.getEnter_plate_pic();
        String exitCarPic = passRecord.getExit_car_pic();
        String exitPlatePic = passRecord.getExit_plate_pic();
        this.loadPic(enterCarPic, enterPlatePic, this.topPicLabel, this.halfTopPicSize, true);
        this.loadPic(exitCarPic, exitPlatePic, this.bottomPicLabel, this.halfBottomPicSize, true);
        this.setPicSelectedComponent(this.halfPicPanel);
        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("car_owner_name", passRecord.getCar_owner_name());
        int passStateValue = passRecord.getPass_state_value() == null ? 0 : passRecord.getPass_state_value();
        String t = null;
        if (passStateValue == 6) {
            t = "\u9ed1\u540d\u5355";
        } else if (passStateValue == 8) {
            t = "\u5df2\u505c\u7528";
        } else if (passStateValue == 7) {
            t = "\u672a\u542f\u7528";
        } else if (passStateValue == 4) {
            t = "\u5df2\u8fc7\u671f";
        } else if (passStateValue == 1) {
            t = "\u65e0\u6743\u9650";
        } else if (passStateValue == 9) {
            t = "\u5339\u914d\u4e0a\u4e00\u5165\u573a\u8bb0\u5f55";
        }
        String plate = passRecord.getExit_plate();
        if (plate != null && plate.length() > 0 && passRecord.getExit_plate_source() != null) {
            if (passRecord.getExit_plate_source() == 0) {
                plate = String.valueOf(plate) + " \u8f66\u724c\u8bc6\u522b";
            } else if (passRecord.getExit_plate_source() == 1) {
                plate = String.valueOf(plate) + " \u4eba\u5de5\u653e\u884c";
            } else if (passRecord.getExit_plate_source() == 2) {
                plate = String.valueOf(plate) + " \u4eba\u5de5\u4fee\u6539";
            } else if (passRecord.getExit_plate_source() == 3) {
                plate = String.valueOf(plate) + " OBU";
            } else if (passRecord.getExit_plate_source() == 4) {
                plate = String.valueOf(plate) + " \u6a21\u7cca\u5339\u914d";
            }
        }
        if (plate != null && plate.length() > 0) {
            this.infoLabelList.get(0).setText("\u8f66\u724c\uff1a" + plate);
        } else if (!(passRecord.getMedium_type() == null || passRecord.getMedium_type() != 0 && passRecord.getMedium_type() != 1 || passRecord.getPassport_number() == null || passRecord.getPassport_number().length() <= 0 || passRecord.getPassport_number().equals(plate))) {
            String name = passRecord.getPassport_number().startsWith("WX_") || passRecord.getPassport_number().startsWith("wx-") ? "\u5fae\u4fe1ID\uff1a" : (passRecord.getPassport_number().startsWith("AL_") || passRecord.getPassport_number().startsWith("al-") ? "\u652f\u4ed8\u5b9dID\uff1a" : "\u5361\u53f7\uff1a");
            this.infoLabelList.get(0).setText(String.valueOf(name) + passRecord.getPassport_number());
        } else {
            this.infoLabelList.get(0).setText("\u8f66\u724c\uff1a");
        }
        if (passRecord.getEnter_time() == null) {
            this.infoLabelList.get(1).setText("\u5165\u573a\uff1a\u65e0\u8bb0\u5f55");
            this.infoLabelList.get(2).setText("\u79bb\u573a\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(passRecord.getExit_time()));
            this.infoLabelList.get(3).setText("\u901a\u9053\uff1a" + passRecord.getExit_channel_name());
            this.infoLabelList.get(4).setText("\u7c7b\u578b\uff1a" + passRecord.getPassport_type_name() + "\u3001" + passRecord.getExit_car_type_name());
            this.infoLabelList.get(5).setText("\u573a\u533a\uff1a" + passRecord.getArea_name());
            if (car_owner_name != null && car_owner_name.length() > 0) {
                this.infoLabelList.get(6).setText("\u8f66\u4e3b\uff1a" + car_owner_name);
            } else {
                this.infoLabelList.get(6).setText(null);
            }
            if (passRecord.getPass_type() != null) {
                if (passRecord.getExit_valid_date() != null && passRecord.getPass_type() == 2) {
                    this.infoLabelList.get(7).setText("\u671f\u9650\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5").format(passRecord.getExit_valid_date()));
                } else if (passRecord.getExit_balance() != null && passRecord.getPass_type() == 1) {
                    this.infoLabelList.get(7).setText("\u4f59\u989d\uff1a" + passRecord.getExit_balance());
                } else {
                    this.infoLabelList.get(7).setText(null);
                }
            } else {
                this.infoLabelList.get(7).setText(null);
            }
            if (t != null) {
                if (this.infoLabelList.get(6).getText() == null) {
                    this.infoLabelList.get(6).setText("\u5f02\u5e38\uff1a" + t);
                } else if (this.infoLabelList.get(7).getText() == null) {
                    this.infoLabelList.get(7).setText("\u5f02\u5e38\uff1a" + t);
                } else {
                    String v = this.infoLabelList.get(7).getText();
                    this.infoLabelList.get(7).setText(String.valueOf(v) + " " + t);
                }
            }
        } else {
            this.infoLabelList.get(1).setText("\u5165\u573a\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(passRecord.getEnter_time()));
            this.infoLabelList.get(2).setText("\u79bb\u573a\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(passRecord.getExit_time()));
            int parkLenSec = (int)TimeUnit.MILLISECONDS.toSeconds(passRecord.getExit_time().getTime() - passRecord.getEnter_time().getTime());
            ApplicationService apps = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            this.infoLabelList.get(3).setText("\u505c\u8f66\uff1a" + apps.getTimeLenSecDes(parkLenSec));
            this.infoLabelList.get(4).setText("\u7c7b\u578b\uff1a" + passRecord.getPassport_type_name() + "\u3001" + passRecord.getExit_car_type_name());
            if (passRecord.getPass_type() != null) {
                if (passRecord.getExit_valid_date() != null && passRecord.getPass_type() == 2) {
                    this.infoLabelList.get(5).setText("\u671f\u9650\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5").format(passRecord.getExit_valid_date()));
                } else if (passRecord.getExit_balance() != null && passRecord.getPass_type() == 1) {
                    this.infoLabelList.get(5).setText("\u4f59\u989d\uff1a" + passRecord.getExit_balance());
                } else {
                    this.infoLabelList.get(5).setText(null);
                }
            } else {
                this.infoLabelList.get(5).setText(null);
            }
            if (t != null) {
                if (this.infoLabelList.get(5).getText() == null) {
                    this.infoLabelList.get(5).setText("\u5f02\u5e38\uff1a" + t);
                } else {
                    String v = this.infoLabelList.get(5).getText();
                    this.infoLabelList.get(5).setText(String.valueOf(v) + " " + t);
                }
            }
            if (passRecord.getArea_level() != null && passRecord.getArea_level() > 1) {
                if (this.infoLabelList.get(5).getText() == null) {
                    this.infoLabelList.get(5).setText("\u573a\u533a\uff1a" + passRecord.getArea_name());
                    if (car_owner_name != null && car_owner_name.length() > 0) {
                        this.infoLabelList.get(6).setText("\u8f66\u4e3b\uff1a" + car_owner_name);
                    } else {
                        this.infoLabelList.get(6).setText(null);
                    }
                    this.infoLabelList.get(7).setText(null);
                } else {
                    this.infoLabelList.get(6).setText("\u573a\u533a\uff1a" + passRecord.getArea_name());
                    if (car_owner_name != null && car_owner_name.length() > 0) {
                        this.infoLabelList.get(7).setText("\u8f66\u4e3b\uff1a" + car_owner_name);
                    } else {
                        this.infoLabelList.get(7).setText(null);
                    }
                }
            } else {
                if (this.infoLabelList.get(5).getText() == null) {
                    if (passRecord.getExit_fee_time_length() != null) {
                        this.infoLabelList.get(5).setText("\u8ba1\u8d39\uff1a" + apps.getTimeLenDes(passRecord.getExit_fee_time_length()));
                    } else {
                        this.infoLabelList.get(5).setText("\u8ba1\u8d39\uff1a" + apps.getTimeLenSecDes(parkLenSec));
                    }
                }
                StringBuilder sbr = new StringBuilder(32);
                sbr.append("\u5e94\u6536\uff1a").append(passRecord.getExit_should_charge() == null ? "0.00" : passRecord.getExit_should_charge());
                BigDecimal xa = Constants.MONEY_ZERO;
                if (passRecord.getPeriod_multi_free() != null && passRecord.getPeriod_multi_free().doubleValue() > 0.0) {
                    xa = xa.add(passRecord.getPeriod_multi_free());
                }
                if (passRecord.getDiscount_money() != null && passRecord.getDiscount_money().doubleValue() > 0.0) {
                    xa = xa.add(passRecord.getDiscount_money());
                }
                if (xa.doubleValue() > 0.0) {
                    sbr.append(" \u4f18\u60e0\uff1a").append(xa);
                }
                this.infoLabelList.get(6).setText(sbr.toString());
                sbr = new StringBuilder(32);
                if (passRecord.getDeduct_money() != null && passRecord.getDeduct_money().doubleValue() > 0.0) {
                    sbr.append("\u6263\u8d39\uff1a").append(passRecord.getDeduct_money());
                }
                if (passRecord.getCash_pay() != null && passRecord.getCash_pay().doubleValue() > 0.0) {
                    if (sbr.length() > 0) {
                        sbr.append(' ');
                    }
                    sbr.append("\u73b0\u91d1\uff1a").append(passRecord.getCash_pay());
                }
                if (passRecord.getAlready_paid() != null && passRecord.getAlready_paid().doubleValue() > 0.0) {
                    String m;
                    if (sbr.length() > 0) {
                        sbr.append(' ');
                    }
                    if ((m = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(passRecord.getAlready_paid_method())) == null || m.length() == 0) {
                        sbr.append("\u5df2\u6536\uff1a");
                    } else {
                        sbr.append(m).append(' ');
                    }
                    sbr.append(passRecord.getAlready_paid());
                }
                this.infoLabelList.get(7).setText(sbr.toString());
            }
        }
    }

    private void setEnterRecord(CarparkPassRecord passRecord) {
        String enterCarPic = passRecord.getEnter_car_pic();
        String enterPlatePic = passRecord.getEnter_plate_pic();
        this.loadPic(enterCarPic, enterPlatePic, this.onePicLabel, this.onePicSize, true);
        this.setPicSelectedComponent(this.onePicPanel);
        String plate = passRecord.getEnter_plate();
        if (plate != null && plate.length() > 0 && passRecord.getEnter_plate_source() != null) {
            if (passRecord.getEnter_plate_source() == 0) {
                plate = String.valueOf(plate) + " \u8f66\u724c\u8bc6\u522b";
            } else if (passRecord.getEnter_plate_source() == 1) {
                plate = String.valueOf(plate) + " \u4eba\u5de5\u653e\u884c";
            } else if (passRecord.getEnter_plate_source() == 2) {
                plate = String.valueOf(plate) + " \u4eba\u5de5\u4fee\u6539";
            } else if (passRecord.getEnter_plate_source() == 3) {
                plate = String.valueOf(plate) + " OBU";
            } else if (passRecord.getEnter_plate_source() == 4) {
                plate = String.valueOf(plate) + " \u6a21\u7cca\u5339\u914d";
            }
        }
        if (plate != null && plate.length() > 0) {
            this.infoLabelList.get(0).setText("\u8f66\u724c\uff1a" + plate);
        } else if (!(passRecord.getMedium_type() == null || passRecord.getMedium_type() != 0 && passRecord.getMedium_type() != 1 || passRecord.getPassport_number() == null || passRecord.getPassport_number().length() <= 0 || passRecord.getPassport_number().equals(plate))) {
            String name = passRecord.getPassport_number().startsWith("WX_") || passRecord.getPassport_number().startsWith("wx-") ? "\u5fae\u4fe1ID\uff1a" : (passRecord.getPassport_number().startsWith("AL_") || passRecord.getPassport_number().startsWith("al-") ? "\u652f\u4ed8\u5b9dID\uff1a" : "\u5361\u53f7\uff1a");
            this.infoLabelList.get(0).setText(String.valueOf(name) + passRecord.getPassport_number());
        } else {
            this.infoLabelList.get(0).setText("\u8f66\u724c\uff1a");
        }
        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("car_owner_name", passRecord.getCar_owner_name());
        this.infoLabelList.get(1).setText("\u5165\u573a\uff1a" + passRecord.getEnter_channel_name());
        this.infoLabelList.get(2).setText("\u573a\u533a\uff1a" + passRecord.getArea_name());
        this.infoLabelList.get(3).setText("\u65f6\u95f4\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(passRecord.getEnter_time()));
        this.infoLabelList.get(4).setText("\u7c7b\u578b\uff1a" + passRecord.getPassport_type_name());
        this.infoLabelList.get(5).setText("\u8f66\u578b\uff1a" + passRecord.getEnter_car_type_name());
        if (car_owner_name != null && car_owner_name.length() > 0) {
            this.infoLabelList.get(6).setText("\u8f66\u4e3b\uff1a" + car_owner_name);
        } else {
            this.infoLabelList.get(6).setText(null);
        }
        if (passRecord.getPass_type() != null) {
            if (passRecord.getEnter_valid_date() != null && passRecord.getPass_type() == 2) {
                this.infoLabelList.get(7).setText("\u671f\u9650\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5").format(passRecord.getEnter_valid_date()));
            } else if (passRecord.getEnter_balance() != null && passRecord.getPass_type() == 1) {
                this.infoLabelList.get(7).setText("\u4f59\u989d\uff1a" + passRecord.getEnter_balance());
            } else {
                this.infoLabelList.get(7).setText(null);
            }
        } else {
            this.infoLabelList.get(7).setText(null);
        }
        int passStateValue = passRecord.getPass_state_value() == null ? 0 : passRecord.getPass_state_value();
        String t = null;
        if (passStateValue == 6) {
            t = "\u9ed1\u540d\u5355";
        } else if (passStateValue == 8) {
            t = "\u5df2\u505c\u7528";
        } else if (passStateValue == 7) {
            t = "\u672a\u542f\u7528";
        } else if (passStateValue == 4) {
            t = "\u5df2\u8fc7\u671f";
        } else if (passStateValue == 1) {
            t = "\u65e0\u6743\u9650";
        }
        if (t != null) {
            if (this.infoLabelList.get(6).getText() == null) {
                this.infoLabelList.get(6).setText("\u5f02\u5e38\uff1a" + t);
            } else if (this.infoLabelList.get(7).getText() == null) {
                this.infoLabelList.get(7).setText("\u5f02\u5e38\uff1a" + t);
            } else {
                String v = this.infoLabelList.get(7).getText();
                this.infoLabelList.get(7).setText(String.valueOf(v) + " " + t);
            }
        }
    }

    private void loadPic(String bigPath, String smallPath, PicLabel picLabel, Dimension size, boolean newSet) {
        BufferedImage image;
        if (bigPath == null || bigPath.length() == 0) {
            if (newSet) {
                picLabel.setIcon(this.getNoPicImage(size));
                picLabel.setText(null);
                picLabel.loadImageOk = false;
            }
            return;
        }
        RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        String path = s.getLocalPicPath(bigPath);
        String localCarPath = null;
        String localPlatePath = null;
        File f1 = new File(path);
        if (f1.exists() && f1.isFile()) {
            localCarPath = f1.getAbsolutePath();
        }
        if (smallPath != null && smallPath.length() > 0 && (f1 = new File(path = s.getLocalPicPath(smallPath))).exists() && f1.isFile()) {
            localPlatePath = f1.getAbsolutePath();
        }
        if (localCarPath != null) {
            image = this.loadImage(localCarPath, localPlatePath, size);
            if (image == null) {
                if (newSet) {
                    picLabel.setIcon(this.getNoPicImage(size));
                    picLabel.setText(null);
                    picLabel.loadImageOk = false;
                }
                return;
            }
        } else {
            if (newSet) {
                picLabel.setIcon(this.getNoPicImage(size));
                picLabel.setText(null);
                picLabel.loadImageOk = false;
            }
            return;
        }
        picLabel.setIcon(new ImageIcon(image));
        picLabel.setText(null);
        picLabel.loadImageOk = true;
    }

    private BufferedImage loadImage(String path) {
        try {
            File f1;
            if (path != null && path.length() > 0 && (f1 = new File(path)).exists() && f1.isFile() && f1.canRead()) {
                return ImageIO.read(f1);
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247\u5f02\u5e38! \u8def\u5f84\uff1a" + path + ", \u539f\u56e0:" + ex.getMessage()));
            return null;
        }
        return null;
    }

    private BufferedImage loadImage(String bigPath, String smallPath, Dimension picSize) {
        BufferedImage bigImage = this.loadImage(bigPath);
        if (bigImage == null) {
            return null;
        }
        BufferedImage smallImage = this.loadImage(smallPath);
        return this.createImage(bigImage, smallImage, picSize);
    }

    private ImageIcon getNoPicImage(Dimension picSize) {
        Image image = this.getNoPicImage0(picSize);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    private Image getNoPicImage0(Dimension picSize) {
        Image image = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("no_pic");
        if (image != null) {
            if (picSize == null) {
                return image;
            }
            return SwingUtil.resizeImage(image, picSize.width, picSize.height);
        }
        return null;
    }

    private BufferedImage createImage(BufferedImage bigImage, BufferedImage smallImage, Dimension picSize) {
        BufferedImage newImage;
        if (bigImage == null) {
            return null;
        }
        if (picSize == null) {
            return bigImage;
        }
        int bigWith = picSize.width;
        int bigHeight = picSize.height;
        try {
            newImage = new BufferedImage(bigWith, bigHeight, bigImage.getType());
            Graphics g = newImage.getGraphics();
            try {
                Image image = bigImage.getScaledInstance(bigWith, bigHeight, 4);
                g.drawImage(image, 0, 0, null);
                if (smallImage != null) {
                    int smallImageHegiht;
                    int smallImageWidth = smallImage.getWidth();
                    if (smallImageWidth > 110) {
                        smallImageWidth = 110;
                    }
                    if ((smallImageHegiht = smallImage.getHeight()) > 45) {
                        smallImageHegiht = 45;
                    }
                    int smallWidth = (int)Math.round(this.rootSize.getWidth() * (double)smallImageWidth / 1280.0) - 10;
                    int smallHeight = (int)Math.round(this.rootSize.getHeight() * (double)smallImageHegiht / 768.0);
                    if (smallWidth > bigWith) {
                        smallWidth = bigWith;
                    }
                    if (smallHeight > bigHeight) {
                        smallHeight = bigHeight;
                    }
                    Image i = SwingUtil.resizeImage((Image)smallImage, smallWidth, smallHeight);
                    int marginLeft = 0;
                    int marginBottom = 3;
                    int x = marginLeft;
                    int y = bigHeight - marginBottom - smallHeight;
                    if (y < 0) {
                        y = 0;
                    }
                    g.drawImage(i, x, y, null);
                }
            }
            finally {
                g.dispose();
            }
        }
        catch (Throwable ex) {
            try {
                return SwingUtil.resizeImage(bigImage, bigWith, bigHeight);
            }
            catch (Throwable ex1) {
                return bigImage;
            }
        }
        return newImage;
    }

    public void onSelect() {
        this.selected = true;
        CarparkPassRecord r = this.needUpdateRef.get();
        if (r != null) {
            this.needUpdateRef.set(null);
            this.setPassRecord(r);
        }
    }

    public void onDisSelect() {
        this.selected = false;
    }

    private static class PicLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private volatile boolean loadImageOk = false;

        private PicLabel() {
        }
    }
}

