/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.RoundBorder;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.gui.login.PlateInputPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MainPresenceRecordPanel
extends JPanel
implements GotoPageHandler,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 7678660479349421499L;
    private JTextField plateField;
    private Color searchFontColor0 = Color.decode("#A0A3A3");
    private Color searchLine0 = Color.decode("#E0E4E9");
    private Color searchLine1 = Color.decode("#42A5F5");
    private Color searchFontColor1 = Color.decode("#616874");
    private Border searchBorder0;
    private Border searchBorder1;
    private Font searchFont0;
    private Font searchFont1;
    private CarparkMainFrame mainFrame;
    private PaginationPanel pagePanel;
    private List<RowPanel> rowPanelList;
    private ImageIcon editPenIcon;
    private Color platecolor = Color.decode("#337AB7");
    private Color timeColor = Color.decode("#2b425b");
    private Color exitColor = Color.decode("#C288CC");
    private Color cellFontColor = Color.decode("#758697");
    private Color rowBorderColor = Color.decode("#E9E9E9");
    private int rowBorderSize;
    private int cellPlatePicWidth;
    private int cellPlatePicHeight;
    private JPopupMenu selectPlateChanelPopupMenu;
    private Dimension popupMenuItemSize;
    private Font popupMenuItemFont;
    private boolean canPaint = true;
    private volatile boolean needReload = false;
    private volatile long relodTimeMills;
    private AtomicBoolean delayReloading = new AtomicBoolean(false);
    private Popup modifyPlatePop;
    private ModifyPlatePanel modifyPlatePanel;
    private ConcurrentLinkedQueue<KeyValueEntry<String, Integer>> queryQueue0 = new ConcurrentLinkedQueue();
    private AtomicBoolean querying0 = new AtomicBoolean(false);
    private String emptyPlateTip = "\u8f93\u5165\u4efb\u610f\u8f66\u724c\u5b57\u7b26\u67e5\u8be2";
    private final Object setTableLock = new Object();

    public JTextField getPlateField() {
        return this.plateField;
    }

    public void init(Dimension size, CarparkMainFrame frame) {
        this.mainFrame = frame;
        this.setLayout(new XYLayout());
        int searchHeight = (int)Math.round(frame.getRootSize().getHeight() * 30.0 / 768.0);
        JLabel titleLabel = new JLabel("\u5728\u573a\u8f66\u8f86");
        int titleFontSize = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
        Font titleFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, titleFontSize);
        titleLabel.setFont(titleFont);
        titleLabel.setForeground(Color.decode("#758697"));
        int titleWidth = (titleLabel.getText().length() + 3) * titleFontSize;
        int titleHeight = searchHeight;
        int titleX = 0;
        int tilleY = 0;
        this.add((Component)titleLabel, new XYConstraints(titleX, tilleY, titleWidth, titleHeight));
        int margLeft = (int)Math.round(frame.getRootSize().getWidth() * 6.0 / 1024.0);
        final JPanel searchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
                if (MainPresenceRecordPanel.this.canPaint) {
                    super.repaint(tm, x, y, width, height);
                }
            }
        };
        searchPanel.setBackground(this.getBackground());
        searchPanel.setLayout(new BorderLayout());
        int searchFontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
        this.searchFont0 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, searchFontSize);
        int searchFontSize1 = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
        this.searchFont1 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, searchFontSize1);
        int searchWidth = searchFontSize * 13;
        int searchX = size.width - searchWidth;
        int searchY = 0;
        this.add((Component)searchPanel, new XYConstraints(searchX, searchY, searchWidth, searchHeight));
        this.plateField = new JTextField(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
                if (MainPresenceRecordPanel.this.canPaint) {
                    super.repaint(tm, x, y, width, height);
                }
            }
        };
        this.plateField.setBorder(BorderFactory.createEmptyBorder(0, margLeft, 0, 0));
        this.plateField.setFont(this.searchFont0);
        searchPanel.add((Component)this.plateField, "Center");
        SearchIconLabel searchIconLabel = new SearchIconLabel();
        searchIconLabel.addMouseListener(this);
        searchIconLabel.setCursor(new Cursor(12));
        Image simg = CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("search32");
        if (simg != null) {
            searchIconLabel.setIcon(new ImageIcon(SwingUtil.resizeImage(simg, searchFontSize1, searchFontSize1)));
        }
        searchPanel.add((Component)searchIconLabel, "East");
        int b1 = (int)Math.round(frame.getRootSize().getHeight() * 1.0 / 768.0);
        int b2 = (int)Math.round(frame.getRootSize().getHeight() * 2.0 / 768.0);
        this.searchBorder0 = BorderFactory.createMatteBorder(0, 0, b1, 0, this.searchLine0);
        searchPanel.setBorder(this.searchBorder0);
        this.searchBorder1 = BorderFactory.createMatteBorder(0, 0, b2, 0, this.searchLine1);
        this.plateField.setBackground(searchPanel.getBackground());
        this.plateField.setForeground(this.searchFontColor0);
        this.plateField.setText(this.emptyPlateTip);
        this.plateField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!MainPresenceRecordPanel.this.canPaint) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainPresenceRecordPanel.this.gotoPage(1);
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.plateField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if ("".equals(MainPresenceRecordPanel.this.plateField.getText())) {
                    searchPanel.setBorder(MainPresenceRecordPanel.this.searchBorder0);
                    MainPresenceRecordPanel.this.plateField.setText(MainPresenceRecordPanel.this.emptyPlateTip);
                    MainPresenceRecordPanel.this.plateField.setForeground(MainPresenceRecordPanel.this.searchFontColor0);
                    MainPresenceRecordPanel.this.plateField.setFont(MainPresenceRecordPanel.this.searchFont0);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (MainPresenceRecordPanel.this.selectPlateChanelPopupMenu != null && MainPresenceRecordPanel.this.selectPlateChanelPopupMenu.isVisible()) {
                    MainPresenceRecordPanel.this.selectPlateChanelPopupMenu.setVisible(false);
                }
                searchPanel.setBorder(MainPresenceRecordPanel.this.searchBorder1);
                if (MainPresenceRecordPanel.this.emptyPlateTip.equals(MainPresenceRecordPanel.this.plateField.getText())) {
                    MainPresenceRecordPanel.this.plateField.setText("");
                    MainPresenceRecordPanel.this.plateField.setForeground(MainPresenceRecordPanel.this.searchFontColor1);
                    MainPresenceRecordPanel.this.plateField.setFont(MainPresenceRecordPanel.this.searchFont1);
                }
                if (MainPresenceRecordPanel.this.modifyPlatePanel != null) {
                    MainPresenceRecordPanel.this.modifyPlatePanel.inputPanel.distory0();
                }
                if (MainPresenceRecordPanel.this.modifyPlatePop != null) {
                    MainPresenceRecordPanel.this.modifyPlatePop.hide();
                    MainPresenceRecordPanel.this.modifyPlatePop = null;
                }
            }
        });
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(this.getBackground());
        int pagePanelHeight = (int)Math.round(frame.getRootSize().getHeight() * 28.0 / 768.0);
        int pagePanelWidth = size.width;
        int pagePanelX = 0;
        int pagePanelY = size.height - pagePanelHeight;
        this.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), frame.getRootSize(), 4);
        int marginTop = (int)Math.round(frame.getRootSize().getHeight() * 8.0 / 768.0);
        int marginBottom = (int)Math.round(frame.getRootSize().getHeight() * 5.0 / 768.0);
        int tableWidth = size.width;
        int tableX = 0;
        int tableY = searchY + searchHeight + marginTop;
        int tableHeight = pagePanelY - tableY - marginBottom;
        JPanel tablePanel = new JPanel();
        tablePanel.setBackground(this.getBackground());
        this.add((Component)tablePanel, new XYConstraints(tableX, tableY, tableWidth, tableHeight));
        int rowHeight0 = (int)Math.round(frame.getRootSize().getHeight() * 28.0 / 768.0);
        int rowCount = tableHeight / rowHeight0;
        int rowHeight = rowHeight0 == 0 ? 0 : tableHeight / rowCount;
        this.rowPanelList = new ArrayList<RowPanel>(rowCount);
        tablePanel.setLayout(new GridLayout(rowCount, 1));
        this.rowBorderSize = (int)Math.round(frame.getRootSize().getHeight() * 1.0 / 768.0);
        int cellFontSize = (int)Math.round(frame.getRootSize().getHeight() * 13.0 / 768.0);
        int endiPenWidth = (int)Math.round(frame.getRootSize().getHeight() * 9.0 / 768.0);
        this.editPenIcon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("highlighter"), endiPenWidth, endiPenWidth));
        Font cellFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, cellFontSize);
        int i = 0;
        while (i < rowCount) {
            RowPanel p = new RowPanel();
            p.setBackground(tablePanel.getBackground());
            this.rowPanelList.add(p);
            tablePanel.add(p);
            p.init(tableWidth, rowHeight - this.rowBorderSize, cellFont, cellFontSize);
            ++i;
        }
        this.selectPlateChanelPopupMenu = new JPopupMenu();
        this.selectPlateChanelPopupMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#979797")));
        int itemFontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
        this.popupMenuItemFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
        int itemWeight = itemFontSize * 8;
        int itemHeight = (int)Math.round(frame.getRootSize().getHeight() * 25.0 / 768.0);
        this.popupMenuItemSize = new Dimension(itemWeight, itemHeight);
        this.modifyPlatePanel = new ModifyPlatePanel();
        int modifyPlateWidth = (int)Math.round(frame.getRootSize().getWidth() * 300.0 / 1024.0);
        int modifyPlateHieght = (int)Math.round(frame.getRootSize().getHeight() * 200.0 / 768.0);
        this.modifyPlatePanel.init(new Dimension(modifyPlateWidth, modifyPlateHieght), frame.getRootSize());
    }

    public void onSelect() {
        this.canPaint = true;
        if (this.plateField != null) {
            this.plateField.setEnabled(true);
        }
        if (this.pagePanel != null) {
            this.pagePanel.setCanHandleAction(true);
        }
        if (this.needReload) {
            this.needReload = false;
            this.gotoPage(this.pagePanel == null ? 1 : this.pagePanel.getCurrentPage());
        }
    }

    public void onDisSelect() {
        this.canPaint = false;
        if (this.plateField != null) {
            this.plateField.setEnabled(false);
        }
        if (this.pagePanel != null) {
            this.pagePanel.setCanHandleAction(false);
        }
        if (this.selectPlateChanelPopupMenu != null && this.selectPlateChanelPopupMenu.isVisible()) {
            this.selectPlateChanelPopupMenu.setVisible(false);
        }
        if (this.modifyPlatePanel != null) {
            this.modifyPlatePanel.inputPanel.distory0();
        }
        if (this.modifyPlatePop != null) {
            this.modifyPlatePop.hide();
            this.modifyPlatePop = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPic() {
        if (!this.canPaint) {
            return;
        }
        if (this.querying0.get()) {
            return;
        }
        LinkedList<String> reloadPicList = null;
        Object object = this.setTableLock;
        synchronized (object) {
            for (RowPanel rowPanel : this.rowPanelList) {
                String picPath = rowPanel.enter_plate_pic;
                if (picPath == null || picPath.length() <= 0 || rowPanel.picSuccess) continue;
                if (reloadPicList == null) {
                    reloadPicList = new LinkedList<String>();
                }
                reloadPicList.add(picPath);
            }
        }
        if (reloadPicList == null || reloadPicList.isEmpty()) {
            return;
        }
        final LinkedList<String> reloadPicList0 = reloadPicList;
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                final HashMap<String, Image> picVmap = new HashMap<String, Image>();
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                for (String path : reloadPicList0) {
                    try {
                        BufferedImage image1 = appService.loadLocalPic(path);
                        if (image1 == null) continue;
                        Image image = SwingUtil.resizeImage((Image)image1, MainPresenceRecordPanel.this.cellPlatePicWidth, MainPresenceRecordPanel.this.cellPlatePicHeight);
                        picVmap.put(path, image);
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247" + path + "\u5f02\u5e38!" + ex.getMessage()));
                    }
                }
                if (!picVmap.isEmpty()) {
                    if (!MainPresenceRecordPanel.this.canPaint) {
                        return;
                    }
                    if (MainPresenceRecordPanel.this.querying0.get()) {
                        return;
                    }
                    SwingUtil.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (!MainPresenceRecordPanel.this.canPaint) {
                                return;
                            }
                            if (MainPresenceRecordPanel.this.querying0.get()) {
                                return;
                            }
                            Object object = MainPresenceRecordPanel.this.setTableLock;
                            synchronized (object) {
                                for (RowPanel rowPanel : MainPresenceRecordPanel.this.rowPanelList) {
                                    Image image;
                                    String picPath = rowPanel.enter_plate_pic;
                                    if (picPath == null || picPath.length() <= 0 || rowPanel.picSuccess || (image = (Image)picVmap.get(picPath)) == null) continue;
                                    ((CellLabel)rowPanel.cellList.get(0)).setText(null);
                                    ((CellLabel)rowPanel.cellList.get(0)).setIcon(new ImageIcon(image));
                                    rowPanel.picSuccess = true;
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void reload() {
        if (!this.canPaint) {
            this.needReload = true;
            return;
        }
        if (this.querying0.get()) {
            return;
        }
        long cc = ServiceUtil.getServiceContext().currentTimeMillis();
        long v = cc - this.relodTimeMills;
        if (v >= 3000L) {
            this.relodTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.reload0();
        } else if (this.delayReloading.compareAndSet(false, true)) {
            ServiceUtil.getServiceContext().delay(new JobTask(){

                protected void doRun() throws Exception {
                    MainPresenceRecordPanel.this.relodTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    MainPresenceRecordPanel.this.delayReloading.set(false);
                    MainPresenceRecordPanel.this.reload0();
                }
            }, 3000L, TimeUnit.MILLISECONDS);
        }
    }

    private void reload0() {
        if (!this.canPaint) {
            this.needReload = true;
            return;
        }
        if (this.querying0.get()) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainPresenceRecordPanel.this.querying0.get()) {
                    return;
                }
                MainPresenceRecordPanel.this.gotoPage(MainPresenceRecordPanel.this.pagePanel == null ? 1 : MainPresenceRecordPanel.this.pagePanel.getCurrentPage());
            }
        });
    }

    private String getInputPlate() {
        String x = this.plateField.getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateField.setText(v2);
            x = v2;
        }
        if (this.emptyPlateTip.equals(x)) {
            x = "";
        }
        return x;
    }

    private void gotoPage(int goPage) {
        this.relodTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        String qpate = this.getInputPlate();
        this.queryQueue0.offer((KeyValueEntry<String, Integer>)new KeyValueEntry((Object)qpate, (Object)goPage));
        this.queryResult0();
    }

    private void queryResult0() {
        if (this.querying0.compareAndSet(false, true)) {
            try {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        block15: {
                            List queryList0 = null;
                            Pagination pagination0 = null;
                            try {
                                try {
                                    KeyValueEntry p;
                                    KeyValueEntry lastP = null;
                                    while ((p = (KeyValueEntry)MainPresenceRecordPanel.this.queryQueue0.poll()) != null) {
                                        lastP = p;
                                    }
                                    if (lastP != null) {
                                        String qplate = (String)lastP.getKey();
                                        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                        SearchParam qpram = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
                                        qpram.setOrerbySql("enter_time DESC");
                                        qpram.addNotEQ("enter_time", null);
                                        qpram.addEQ("exit_time", null);
                                        if (qplate != null && qplate.length() > 0) {
                                            qpram.addLike("enter_plate", qplate);
                                        }
                                        qpram.setQueryFields(new String[]{"id", "enter_time", "enter_plate", "medium_type", "area_no", "area_name", "enter_plate_pic", "passport_number"});
                                        pagination0 = new Pagination();
                                        pagination0.setPageSize(MainPresenceRecordPanel.this.rowPanelList == null ? 6 : MainPresenceRecordPanel.this.rowPanelList.size());
                                        pagination0.setNeedQueryCount(true);
                                        pagination0.setGotoPage(lastP.getValue() == null ? 1 : (Integer)lastP.getValue());
                                        queryList0 = daoService.selectList(qpram, pagination0);
                                        if (queryList0 != null && !queryList0.isEmpty()) {
                                            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                            for (Map pmap : queryList0) {
                                                String enter_plate_pic = (String)pmap.get("enter_plate_pic");
                                                if (enter_plate_pic == null || enter_plate_pic.length() <= 0) continue;
                                                BufferedImage image1 = null;
                                                try {
                                                    image1 = appService.loadLocalPic(enter_plate_pic);
                                                    if (image1 == null) continue;
                                                    Image image = SwingUtil.resizeImage((Image)image1, MainPresenceRecordPanel.this.cellPlatePicWidth, MainPresenceRecordPanel.this.cellPlatePicHeight);
                                                    pmap.put("plateImage", image);
                                                }
                                                catch (Throwable ex) {
                                                    image1 = null;
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (Throwable ex) {
                                    queryList0 = null;
                                    pagination0 = new Pagination();
                                    GuiLog.getLog().warn((Object)"", ex);
                                    if (queryList0 == null) {
                                        queryList0 = new ArrayList(0);
                                    }
                                    Pagination pagination = pagination0;
                                    ArrayList queryList = queryList0;
                                    SwingUtil.invokeLater(new Runnable(queryList, pagination){
                                        private final /* synthetic */ List val$queryList;
                                        private final /* synthetic */ Pagination val$pagination;
                                        {
                                            this.val$queryList = list;
                                            this.val$pagination = pagination;
                                        }

                                        @Override
                                        public void run() {
                                            MainPresenceRecordPanel.this.querying0.set(false);
                                            if (MainPresenceRecordPanel.this.queryQueue0.peek() != null) {
                                                MainPresenceRecordPanel.this.queryResult0();
                                            } else {
                                                MainPresenceRecordPanel.this.setRecordList(this.val$queryList, this.val$pagination);
                                            }
                                        }
                                    });
                                    break block15;
                                }
                            }
                            catch (Throwable throwable) {
                                if (queryList0 == null) {
                                    queryList0 = new ArrayList(0);
                                }
                                Pagination pagination = pagination0;
                                ArrayList queryList = queryList0;
                                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            if (queryList0 == null) {
                                queryList0 = new ArrayList(0);
                            }
                            Pagination pagination = pagination0;
                            ArrayList queryList = queryList0;
                            SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                });
            }
            catch (Throwable ex) {
                this.querying0.set(false);
                GuiLog.getLog().warn((Object)"", ex);
            }
        }
    }

    private List<PassChannel> getExitChannelList(String areaNo) {
        LinkedList<PassChannel> passList = new LinkedList<PassChannel>();
        Enumeration<PassChannel> chs = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
        if (chs != null) {
            block0: while (chs.hasMoreElements()) {
                List<CarparkArea> exitAreaList;
                ChannelArea ca;
                PassChannel ch = chs.nextElement();
                Map<String, ChannelArea> chareaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
                if (chareaMap == null || (ca = chareaMap.get(ch.getChannelNo())) == null || (exitAreaList = ca.getExitAreas()) == null || exitAreaList.isEmpty()) continue;
                if (areaNo == null) {
                    passList.add(ch);
                    continue;
                }
                for (CarparkArea a : exitAreaList) {
                    if (!areaNo.equals(a.getArea_no())) continue;
                    passList.add(ch);
                    continue block0;
                }
            }
        }
        return passList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecordList(List<Map<String, Object>> resultList, Pagination pagination) {
        Object object = this.setTableLock;
        synchronized (object) {
            int resultCount = resultList == null ? 0 : resultList.size();
            SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm");
            Cursor defaultCursor = new Cursor(0);
            Cursor handCursor = new Cursor(12);
            int i = 0;
            while (i < this.rowPanelList.size()) {
                RowPanel tr = this.rowPanelList.get(i);
                if (i < resultCount) {
                    List<PassChannel> exitchlist;
                    String area_no;
                    Map<String, Object> row = resultList.get(i);
                    Integer medium_type = (Integer)row.get("medium_type");
                    Image plateImage = (Image)row.get("plateImage");
                    String passport_number = (String)row.get("passport_number");
                    String enter_plate_pic = (String)row.get("enter_plate_pic");
                    String scanName = null;
                    if (medium_type != null && medium_type == 1) {
                        scanName = Constants.getScanName(passport_number);
                        if (scanName == null || scanName.length() == 0) {
                            if (passport_number != null && passport_number.startsWith("WX_")) {
                                scanName = "\u5fae\u4fe1";
                            } else if (passport_number != null && passport_number.startsWith("AL_")) {
                                scanName = "\u652f\u4ed8\u5b9d";
                            }
                        }
                        if (scanName != null && scanName.length() == 0) {
                            scanName = null;
                        }
                    }
                    tr.enter_plate_pic = enter_plate_pic;
                    if (plateImage == null) {
                        ((CellLabel)tr.cellList.get(0)).setIcon(null);
                        ((CellLabel)tr.cellList.get(0)).setText("\u65e0\u8f66\u724c\u56fe\u7247");
                        tr.picSuccess = false;
                    } else {
                        ((CellLabel)tr.cellList.get(0)).setText(null);
                        ((CellLabel)tr.cellList.get(0)).setIcon(new ImageIcon(plateImage));
                        tr.picSuccess = true;
                    }
                    String pate1 = (String)row.get("enter_plate");
                    if (pate1 != null && pate1.length() > 0) {
                        ((CellLabel)tr.cellList.get(1)).setText(pate1);
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                            ((CellLabel)tr.cellList.get(1)).setIcon(null);
                            ((CellLabel)tr.cellList.get(1)).setCursor(defaultCursor);
                            ((CellLabel)tr.cellList.get(1)).setToolTipText(null);
                        } else {
                            ((CellLabel)tr.cellList.get(1)).setIcon(this.editPenIcon);
                            ((CellLabel)tr.cellList.get(1)).setCursor(handCursor);
                            ((CellLabel)tr.cellList.get(1)).setToolTipText("\u5982\u679c\u8bc6\u522b\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u8f66\u724c");
                        }
                        ((CellLabel)tr.cellList.get(1)).dataMap = row;
                    } else {
                        ((CellLabel)tr.cellList.get(1)).setText(passport_number == null ? null : passport_number);
                        ((CellLabel)tr.cellList.get(1)).setIcon(null);
                        ((CellLabel)tr.cellList.get(1)).setCursor(defaultCursor);
                        ((CellLabel)tr.cellList.get(1)).setToolTipText(null);
                        ((CellLabel)tr.cellList.get(1)).dataMap = null;
                    }
                    Date enter_time = (Date)row.get("enter_time");
                    if (enter_time != null) {
                        ((CellLabel)tr.cellList.get(2)).setText(df.format(enter_time));
                        ((CellLabel)tr.cellList.get(2)).setIcon(null);
                        ((CellLabel)tr.cellList.get(2)).setToolTipText("\u5165\u573a\u65f6\u95f4");
                    } else {
                        ((CellLabel)tr.cellList.get(2)).setText(null);
                        ((CellLabel)tr.cellList.get(2)).setIcon(null);
                        ((CellLabel)tr.cellList.get(2)).setToolTipText(null);
                    }
                    ((CellLabel)tr.cellList.get(3)).setText((String)row.get("area_name"));
                    boolean canExit = false;
                    if (medium_type != null && medium_type == 6 && (area_no = (String)row.get("area_no")) != null && area_no.length() > 0 && (exitchlist = this.getExitChannelList(area_no)) != null && !exitchlist.isEmpty()) {
                        canExit = true;
                    }
                    if (canExit) {
                        ((CellLabel)tr.cellList.get(4)).setText("\u79bb\u573a");
                        ((CellLabel)tr.cellList.get(4)).setCursor(handCursor);
                        ((CellLabel)tr.cellList.get(4)).setToolTipText("\u70b9\u51fb\u8fdb\u884c\u4eba\u5de5\u653e\u884c\u79bb\u573a");
                        ((CellLabel)tr.cellList.get(4)).dataMap = row;
                    } else if (scanName != null && scanName.length() > 0) {
                        ((CellLabel)tr.cellList.get(4)).setText(scanName);
                        ((CellLabel)tr.cellList.get(4)).setCursor(defaultCursor);
                        if (passport_number != null && (passport_number.startsWith("WX_") || passport_number.startsWith("AL_"))) {
                            ((CellLabel)tr.cellList.get(4)).setToolTipText(String.valueOf(scanName) + "\u540d\u7247\u626b\u7801\u5165\u573a");
                        } else {
                            ((CellLabel)tr.cellList.get(4)).setToolTipText(String.valueOf(scanName) + "\u626b\u4e00\u626b\u5165\u573a");
                        }
                        ((CellLabel)tr.cellList.get(4)).dataMap = null;
                    } else {
                        ((CellLabel)tr.cellList.get(4)).setText(null);
                        ((CellLabel)tr.cellList.get(4)).setCursor(defaultCursor);
                        ((CellLabel)tr.cellList.get(4)).setToolTipText(null);
                        ((CellLabel)tr.cellList.get(4)).dataMap = null;
                    }
                    tr.setBorder(BorderFactory.createMatteBorder(0, 0, i < resultCount - 1 ? this.rowBorderSize : 0, 0, this.rowBorderColor));
                } else {
                    tr.picSuccess = false;
                    tr.enter_plate_pic = null;
                    for (CellLabel td : tr.cellList) {
                        td.setText(null);
                        td.setIcon(null);
                        td.setToolTipText(null);
                        td.setCursor(defaultCursor);
                        td.dataMap = null;
                    }
                    tr.setBorder(BorderFactory.createEmptyBorder(0, 0, this.rowBorderSize, 0));
                }
                ++i;
            }
            this.pagePanel.setPagination(pagination);
        }
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        if (this.selectPlateChanelPopupMenu != null && this.selectPlateChanelPopupMenu.isVisible()) {
            this.selectPlateChanelPopupMenu.setVisible(false);
        }
        if (this.modifyPlatePanel != null) {
            this.modifyPlatePanel.inputPanel.distory0();
        }
        if (this.modifyPlatePop != null) {
            this.modifyPlatePop.hide();
            this.modifyPlatePop = null;
        }
        this.gotoPage(goPage);
    }

    private void doExitPass(CellLabel cell, int x, int y) {
        List<PassChannel> channelList;
        Map row = cell.dataMap;
        if (row == null) {
            return;
        }
        String area_no = (String)row.get("area_no");
        String plateNumber = (String)row.get("enter_plate");
        if (plateNumber != null && plateNumber.length() > 0 && (channelList = this.getExitChannelList(area_no)) != null && !channelList.isEmpty()) {
            if (channelList.size() == 1) {
                this.doPassExit(channelList.get(0).getChannelNo(), plateNumber);
            } else {
                int showItemCount = channelList.size() + 1;
                int count = this.selectPlateChanelPopupMenu.getComponentCount();
                ArrayList<SelectChannelMenuItem> itemList = new ArrayList<SelectChannelMenuItem>(count);
                int i = 0;
                while (i < count) {
                    Component c = this.selectPlateChanelPopupMenu.getComponent(i);
                    if (c != null && c instanceof SelectChannelMenuItem) {
                        itemList.add((SelectChannelMenuItem)c);
                    }
                    ++i;
                }
                if (itemList.size() != showItemCount) {
                    for (SelectChannelMenuItem item : itemList) {
                        if (item.isTitle) continue;
                        item.removeActionListener(this);
                    }
                    this.selectPlateChanelPopupMenu.removeAll();
                    this.selectPlateChanelPopupMenu.setVisible(false);
                    SelectChannelMenuItem titleItem = new SelectChannelMenuItem();
                    titleItem.isTitle = true;
                    titleItem.setText(plateNumber);
                    titleItem.setFont(this.popupMenuItemFont);
                    this.selectPlateChanelPopupMenu.add(titleItem);
                    this.selectPlateChanelPopupMenu.addSeparator();
                    for (PassChannel ch : channelList) {
                        SelectChannelMenuItem item = new SelectChannelMenuItem();
                        item.setPreferredSize(this.popupMenuItemSize);
                        item.setFont(this.popupMenuItemFont);
                        item.channelNo = ch.getChannelNo();
                        item.plateNumber = plateNumber;
                        item.addActionListener(this);
                        item.setText(ch.getChannel().getChannel_name());
                        this.selectPlateChanelPopupMenu.add(item);
                    }
                } else {
                    SelectChannelMenuItem titleItem;
                    int index = 0;
                    if (!(titleItem = (SelectChannelMenuItem)itemList.get(index++)).isTitle) {
                        titleItem.isTitle = true;
                        titleItem.channelNo = null;
                        titleItem.plateNumber = null;
                    }
                    titleItem.setText(plateNumber);
                    for (PassChannel ch : channelList) {
                        SelectChannelMenuItem item = (SelectChannelMenuItem)itemList.get(index);
                        if (item.isTitle) {
                            item.isTitle = false;
                        }
                        item.channelNo = ch.getChannelNo();
                        item.plateNumber = plateNumber;
                        String text = ch.getChannel().getChannel_name();
                        if (text == null) {
                            text = "";
                        }
                        if (!text.equals(item.getText())) {
                            item.setText(text);
                        }
                        ++index;
                    }
                }
                if (!this.selectPlateChanelPopupMenu.isVisible()) {
                    this.selectPlateChanelPopupMenu.show(cell, x, y);
                }
            }
        }
    }

    private void doPassExit(String channelNo, String plateNumber) {
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            return;
        }
        if (plateNumber == null || plateNumber.length() == 0) {
            return;
        }
        ReadPassportNumberEvent readp = new ReadPassportNumberEvent(passChannel, plateNumber, 6, channelNo);
        readp.setPlateNumber(plateNumber);
        readp.setManualTrigger(true);
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(readp);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.canPaint) {
            Object source = e.getSource();
            if (source instanceof SearchIconLabel) {
                this.gotoPage(1);
            } else if (source instanceof CellLabel) {
                CellLabel cell = (CellLabel)source;
                if ("exitPass".equals(cell.cmd)) {
                    if (this.modifyPlatePanel != null) {
                        this.modifyPlatePanel.inputPanel.distory0();
                    }
                    if (this.modifyPlatePop != null) {
                        this.modifyPlatePop.hide();
                        this.modifyPlatePop = null;
                    }
                    this.doExitPass(cell, e.getX(), e.getY());
                } else if ("modifyPlate".equals(cell.cmd)) {
                    if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                        return;
                    }
                    Map row = cell.dataMap;
                    if (row == null) {
                        return;
                    }
                    String pate1 = (String)row.get("enter_plate");
                    if (pate1 == null || pate1.length() == 0) {
                        return;
                    }
                    Image plateImage = (Image)row.get("plateImage");
                    this.modifyPlatePanel.inputPanel.setPlate(pate1);
                    this.modifyPlatePanel.plateNumberLabel.setText(pate1);
                    if (plateImage != null) {
                        this.modifyPlatePanel.paltePicLabel.setText(null);
                        this.modifyPlatePanel.paltePicLabel.setIcon(new ImageIcon(plateImage));
                    } else {
                        this.modifyPlatePanel.paltePicLabel.setText("\u65e0\u8f66\u724c\u56fe\u7247");
                        this.modifyPlatePanel.paltePicLabel.setIcon(null);
                    }
                    this.modifyPlatePanel.recordData = row;
                    this.modifyPlatePanel.inputPanel.distory0();
                    if (this.modifyPlatePop != null) {
                        this.modifyPlatePop.hide();
                        this.modifyPlatePop = null;
                    }
                    int w = this.modifyPlatePanel.getPreferredSize().width;
                    int h = this.modifyPlatePanel.getPreferredSize().height;
                    int x = (this.getWidth() - w) / 2;
                    int y = (this.getHeight() - h) / 2;
                    Point p = this.getLocationOnScreen();
                    this.modifyPlatePop = PopupFactory.getSharedInstance().getPopup(this, this.modifyPlatePanel, x += p.x, y += p.y);
                    this.modifyPlatePop.show();
                    this.modifyPlatePanel.inputPanel.getTextField().requestFocus();
                }
            }
        }
    }

    public void onMainWindowDispose() {
        if (this.modifyPlatePanel != null) {
            this.modifyPlatePanel.inputPanel.distory0();
        }
        if (this.modifyPlatePop != null) {
            this.modifyPlatePop.hide();
            this.modifyPlatePop = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.canPaint) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof SelectChannelMenuItem) {
            SelectChannelMenuItem item = (SelectChannelMenuItem)source;
            if (!item.isTitle) {
                this.doPassExit(item.channelNo, item.plateNumber);
            }
        } else {
            String cmd = e.getActionCommand();
            if ("plate_right".equals(cmd)) {
                if (this.modifyPlatePop != null && this.modifyPlatePanel != null) {
                    this.modifyPlatePanel.inputPanel.popDialog(false);
                }
            } else if ("plate_left".equals(cmd) && this.modifyPlatePop != null && this.modifyPlatePanel != null) {
                this.modifyPlatePanel.inputPanel.popDialog(true);
            }
        }
    }

    private class CellLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private String cmd;
        private volatile Map<String, Object> dataMap;

        private CellLabel() {
        }
    }

    private class ModifyPlatePanel
    extends JPanel
    implements KeyListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        private PlateInputPanel inputPanel;
        private JLabel paltePicLabel;
        private JLabel plateNumberLabel;
        private volatile Map<String, Object> recordData;

        private ModifyPlatePanel() {
        }

        private void init(Dimension size, Dimension rootSize) {
            this.setPreferredSize(size);
            this.setLayout(new XYLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.decode("#EBEDF0"), 1));
            this.setBackground(Color.decode("#ECF0F5"));
            int fontSize = (int)Math.round(rootSize.getHeight() * 14.0 / 768.0);
            Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
            int height = (int)Math.round(rootSize.getHeight() * 30.0 / 768.0);
            int marginTop = (int)Math.round(rootSize.getHeight() * 8.0 / 768.0);
            int y = (size.height - (4 * height + 3 * marginTop)) / 2;
            Color ckl = Color.decode("#758697");
            JLabel label1 = new JLabel("\u8f66\u724c\u56fe\u7247\uff1a");
            label1.setForeground(ckl);
            label1.setHorizontalAlignment(4);
            label1.setFont(font);
            int x = 0;
            int width = fontSize * 7;
            this.add((Component)label1, new XYConstraints(x, y, width, height));
            int totalWidth = (int)((double)(size.width - 2 - (x += width)) * 0.85);
            this.paltePicLabel = new JLabel();
            this.paltePicLabel.setFont(font);
            this.add((Component)this.paltePicLabel, new XYConstraints(x, y, totalWidth, height));
            x = 0;
            label1 = new JLabel("\u5165\u573a\u8f66\u724c\uff1a");
            label1.setForeground(ckl);
            label1.setHorizontalAlignment(4);
            label1.setFont(font);
            this.add((Component)label1, new XYConstraints(x, y += marginTop + height, width, height));
            this.plateNumberLabel = new JLabel();
            this.plateNumberLabel.setFont(font);
            this.add((Component)this.plateNumberLabel, new XYConstraints(x += width, y, totalWidth, height));
            x = 0;
            label1 = new JLabel("\u4fee\u6539\u4e3a\uff1a");
            label1.setForeground(ckl);
            label1.setHorizontalAlignment(4);
            label1.setFont(font);
            this.add((Component)label1, new XYConstraints(x, y += marginTop + height, width, height));
            x += width;
            int blockborderSize = (int)Math.floor(rootSize.getHeight() * 1.0 / 800.0);
            if (blockborderSize <= 0) {
                blockborderSize = 1;
            }
            int leftRightsize = (int)Math.round(rootSize.getHeight() * 44.0 / 768.0);
            Dimension d1 = new Dimension(leftRightsize, height);
            Dimension d2 = new Dimension(totalWidth - 2 * leftRightsize, height);
            this.inputPanel = new PlateInputPanel(d1, d2, font, null, null, blockborderSize, null);
            this.inputPanel.getRightButton().setActionCommand("plate_right");
            this.inputPanel.getRightButton().addActionListener(MainPresenceRecordPanel.this);
            this.inputPanel.getLeftButton().setActionCommand("plate_left");
            this.inputPanel.getLeftButton().addActionListener(MainPresenceRecordPanel.this);
            this.inputPanel.getTextField().addKeyListener(this);
            this.add((Component)this.inputPanel, new XYConstraints(x, y, totalWidth, height));
            x = 0;
            y += marginTop + height;
            int buttonWidth = fontSize * 4;
            int grap = (size.width - 2 * buttonWidth - 2) / 3;
            int arc = (int)Math.round(MainPresenceRecordPanel.this.mainFrame.getRootSize().getHeight() * 14.0 / 768.0);
            Color btFontColor = Color.WHITE;
            RoundBorder border = new RoundBorder(this.getBackground(), arc);
            int bh = (int)Math.round(rootSize.getHeight() * 25.0 / 768.0);
            Color moveOutBgColor = Color.decode("#eb3774");
            Color moveOnBgColor = Color.decode("#e7175d");
            CarparkMainFrame.RoundPanelButton rb1 = new CarparkMainFrame.RoundPanelButton(arc, arc);
            rb1.setBorder(border);
            rb1.setCmd("cancelModifyPlate");
            rb1.setBackground(moveOutBgColor);
            rb1.getTextLabel().setFont(font);
            rb1.getTextLabel().setForeground(btFontColor);
            rb1.getTextLabel().setText("\u53d6\u6d88");
            rb1.getTextLabel().setCursor(new Cursor(12));
            rb1.setMoveOutBgColor(moveOutBgColor);
            rb1.setMoveOnBgColor(moveOnBgColor);
            rb1.getTextLabel().addMouseListener(this);
            JPanel p1 = new JPanel();
            p1.setBackground(this.getBackground());
            p1.setLayout(new XYLayout());
            p1.add((Component)rb1, new XYConstraints(1, 1, buttonWidth, bh));
            x = grap;
            this.add((Component)p1, new XYConstraints(x, y + height - bh, buttonWidth + 2, bh + 2));
            x += grap + buttonWidth + 2;
            moveOutBgColor = Color.decode("#38a0f4");
            moveOnBgColor = Color.decode("#1690f3");
            rb1 = new CarparkMainFrame.RoundPanelButton(arc, arc);
            rb1.setBorder(border);
            rb1.setCmd("okModifyPlate");
            rb1.setBackground(moveOutBgColor);
            rb1.getTextLabel().setFont(font);
            rb1.getTextLabel().setForeground(btFontColor);
            rb1.getTextLabel().setText("\u786e\u5b9a");
            rb1.getTextLabel().setCursor(new Cursor(12));
            rb1.setMoveOutBgColor(moveOutBgColor);
            rb1.setMoveOnBgColor(moveOnBgColor);
            rb1.getTextLabel().addMouseListener(this);
            p1 = new JPanel();
            p1.setBackground(this.getBackground());
            p1.setLayout(new XYLayout());
            p1.add((Component)rb1, new XYConstraints(1, 1, buttonWidth, bh));
            this.add((Component)p1, new XYConstraints(x, y + height - bh, buttonWidth + 2, bh + 2));
        }

        @Override
        public void keyTyped(KeyEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String x = ModifyPlatePanel.this.inputPanel.getTextField().getText();
                    String v2 = x;
                    v2 = v2 == null ? "" : v2.trim();
                    v2 = v2.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
                        ModifyPlatePanel.this.inputPanel.getTextField().setText(v2);
                    }
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            CarparkMainFrame.RoundPanelButton b = this.getRoundPanelButton(e);
            if (b != null) {
                if ("cancelModifyPlate".equals(b.getCmd())) {
                    if (MainPresenceRecordPanel.this.modifyPlatePanel != null) {
                        ((MainPresenceRecordPanel)MainPresenceRecordPanel.this).modifyPlatePanel.inputPanel.distory0();
                    }
                    if (MainPresenceRecordPanel.this.modifyPlatePop != null) {
                        MainPresenceRecordPanel.this.modifyPlatePop.hide();
                        MainPresenceRecordPanel.this.modifyPlatePop = null;
                    }
                } else if ("okModifyPlate".equals(b.getCmd())) {
                    Map<String, Object> data = this.recordData;
                    final String newPlate = this.inputPanel.getPlate();
                    if (newPlate != null && (newPlate.length() == 7 || newPlate.length() == 8)) {
                        if (MainPresenceRecordPanel.this.modifyPlatePanel != null) {
                            ((MainPresenceRecordPanel)MainPresenceRecordPanel.this).modifyPlatePanel.inputPanel.distory0();
                        }
                        if (MainPresenceRecordPanel.this.modifyPlatePop != null) {
                            MainPresenceRecordPanel.this.modifyPlatePop.hide();
                            MainPresenceRecordPanel.this.modifyPlatePop = null;
                        }
                        if (data != null && !this.recordData.isEmpty()) {
                            final String oldPlate = (String)this.recordData.get("enter_plate");
                            final Long recordId = (Long)this.recordData.get("id");
                            if (oldPlate != null && oldPlate.length() > 0 && !oldPlate.equals(newPlate)) {
                                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                            appService.modifyEnterPlate(recordId, oldPlate, newPlate, ServiceUtil.getNow(), null, null);
                                            MainPresenceRecordPanel.this.reload();
                                        }
                                        catch (Exception ex) {
                                            GuiLog.getLog().warn((Object)"", (Throwable)ex);
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(new Object(), "\u4fee\u6539\u8f66\u724c:" + oldPlate + "\u4e3a:" + newPlate + ",\u5f02\u5e38!", 4));
                                        }
                                    }
                                });
                            }
                        }
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(new Object(), "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5165\u573a\u8f66\u724c!", 4));
                        return;
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CarparkMainFrame.RoundPanelButton b = this.getRoundPanelButton(e);
            if (b != null) {
                b.onMoveOn();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CarparkMainFrame.RoundPanelButton b = this.getRoundPanelButton(e);
            if (b != null) {
                b.onMoveOut();
            }
        }

        private CarparkMainFrame.RoundPanelButton getRoundPanelButton(MouseEvent e) {
            Component c;
            Container p1;
            Object scs = e.getSource();
            if (scs instanceof CarparkMainFrame.RoundPanelButton) {
                return (CarparkMainFrame.RoundPanelButton)scs;
            }
            if (scs instanceof Component && (p1 = (c = (Component)scs).getParent()) != null) {
                if (p1 instanceof CarparkMainFrame.RoundPanelButton) {
                    return (CarparkMainFrame.RoundPanelButton)p1;
                }
                Container p2 = p1.getParent();
                if (p2 != null && p2 instanceof CarparkMainFrame.RoundPanelButton) {
                    return (CarparkMainFrame.RoundPanelButton)p2;
                }
            }
            return null;
        }
    }

    private class RowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private List<CellLabel> cellList;
        private volatile String enter_plate_pic;
        private volatile boolean picSuccess;

        private RowPanel() {
        }

        private void init(int rowWidth, int rowHeight, Font font, int fontSize) {
            this.setLayout(new XYLayout());
            int cellHeight = rowHeight;
            this.cellList = new ArrayList<CellLabel>(5);
            int x = 0;
            int y = 0;
            int width = (int)Math.round(MainPresenceRecordPanel.this.mainFrame.getRootSize().getHeight() * 80.0 / 768.0);
            CellLabel cell = new CellLabel();
            cell.setFont(font);
            cell.setForeground(MainPresenceRecordPanel.this.cellFontColor);
            this.add((Component)cell, new XYConstraints(x, y, width, cellHeight));
            this.cellList.add(cell);
            MainPresenceRecordPanel.this.cellPlatePicWidth = width;
            MainPresenceRecordPanel.this.cellPlatePicHeight = cellHeight - 4;
            x += width;
            cell = new CellLabel();
            cell.setIconTextGap(0);
            width = (int)Math.round(MainPresenceRecordPanel.this.mainFrame.getRootSize().getWidth() * 95.0 / 1024.0);
            cell.setHorizontalAlignment(0);
            cell.setFont(font);
            cell.setHorizontalTextPosition(2);
            cell.setForeground(MainPresenceRecordPanel.this.platecolor);
            cell.cmd = "modifyPlate";
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
                cell.addMouseListener(MainPresenceRecordPanel.this);
            }
            this.add((Component)cell, new XYConstraints(x, y, width, cellHeight));
            this.cellList.add(cell);
            x += width;
            cell = new CellLabel();
            width = (int)Math.round(MainPresenceRecordPanel.this.mainFrame.getRootSize().getWidth() * 110.0 / 1024.0);
            cell.setHorizontalAlignment(0);
            cell.setFont(font);
            cell.setForeground(MainPresenceRecordPanel.this.timeColor);
            this.add((Component)cell, new XYConstraints(x, y, width, cellHeight));
            this.cellList.add(cell);
            int rightWidth = 3 * fontSize + 5;
            int rightX = rowWidth - rightWidth;
            x += width;
            width = rightX - x;
            cell = new CellLabel();
            cell.setHorizontalAlignment(0);
            cell.setFont(font);
            cell.setForeground(MainPresenceRecordPanel.this.cellFontColor);
            this.add((Component)cell, new XYConstraints(x, y, width, cellHeight));
            this.cellList.add(cell);
            x += width;
            width = rowWidth - x;
            cell = new CellLabel();
            cell.setHorizontalAlignment(4);
            cell.setFont(font);
            cell.setForeground(MainPresenceRecordPanel.this.exitColor);
            cell.cmd = "exitPass";
            cell.addMouseListener(MainPresenceRecordPanel.this);
            this.add((Component)cell, new XYConstraints(x, y, width, cellHeight));
            this.cellList.add(cell);
        }
    }

    private class SearchIconLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        private SearchIconLabel() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            if (MainPresenceRecordPanel.this.canPaint) {
                super.repaint(tm, x, y, width, height);
            }
        }
    }

    private static class SelectChannelMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private boolean isTitle;
        private volatile String channelNo;
        private volatile String plateNumber;

        private SelectChannelMenuItem() {
        }
    }
}

