/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.ChargeRecordSearchTabPane;
import com.wovoe.carpark.gui.login.EnterRecordSearchTabPane;
import com.wovoe.carpark.gui.login.ExitRecordSearchTabPane;
import com.wovoe.carpark.gui.login.IllegalPassSearchTabPane;
import com.wovoe.carpark.gui.login.MainSearchDialog;
import com.wovoe.carpark.gui.login.MainTabPane;
import com.wovoe.carpark.gui.login.PresenceRecordSearchTabPane;
import com.wovoe.carpark.gui.login.SecialPassRecordSearchTabPane;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainRecordSearchDialog
extends MainSearchDialog
implements ChangeListener,
WindowListener {
    private static final long serialVersionUID = -8795244938685120001L;
    private static MainRecordSearchDialog instance;
    private JTabbedPane tabPane;
    private List<KeyValueEntry<MainTabPane, Boolean>> tabList;
    private int selectedIndex = 0;
    private Dimension mainSize;
    private Dimension contentSize;

    public static boolean isDShowing() {
        MainRecordSearchDialog instance0 = instance;
        return instance0 != null && instance0.isVisible();
    }

    public static MainRecordSearchDialog getInstance() {
        return instance;
    }

    public static void showDialog(CarparkMainFrame frame) {
        if (instance != null && instance.isVisible()) {
            instance.toFront();
            return;
        }
        instance = new MainRecordSearchDialog(frame);
        instance.setTitleInfo("\u8bb0\u5f55\u67e5\u8be2");
        instance.setVisible(true);
    }

    public static void colseIfShow() {
        if (instance != null && instance.isVisible()) {
            instance.dispose();
            instance = null;
        }
    }

    @Override
    public void dispose() {
        try {
            for (KeyValueEntry<MainTabPane, Boolean> t : this.tabList) {
                if (!((Boolean)t.getValue()).booleanValue()) continue;
                ((MainTabPane)t.getKey()).onWidnowDispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    protected void doPressCloseButton() {
        super.doPressCloseButton();
        instance = null;
    }

    protected MainRecordSearchDialog(CarparkMainFrame frame) {
        super(frame);
    }

    @Override
    protected void init(JPanel bodyPanel, Dimension bodySize, Dimension mainSize) {
        this.mainSize = mainSize;
        bodyPanel.setLayout(new XYLayout());
        this.tabList = new ArrayList<KeyValueEntry<MainTabPane, Boolean>>();
        this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new PresenceRecordSearchTabPane(), (Object)Boolean.FALSE));
        this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new EnterRecordSearchTabPane(), (Object)Boolean.FALSE));
        this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new ExitRecordSearchTabPane(), (Object)Boolean.FALSE));
        this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new SecialPassRecordSearchTabPane(), (Object)Boolean.FALSE));
        this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new IllegalPassSearchTabPane(), (Object)Boolean.FALSE));
        if (ServiceUtil.isEnableGuiFee()) {
            this.tabList.add((KeyValueEntry<MainTabPane, Boolean>)new KeyValueEntry((Object)new ChargeRecordSearchTabPane(), (Object)Boolean.FALSE));
        }
        int fontSize = (int)Math.round(mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int marginTop = (int)Math.round(mainSize.getHeight() * 15.0 / 768.0);
        int x = 0;
        int y = marginTop;
        int w = bodySize.width;
        int h = bodySize.height - y;
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(font);
        this.tabPane.setCursor(new Cursor(12));
        this.tabPane.setBackground(bodyPanel.getBackground());
        for (KeyValueEntry<MainTabPane, Boolean> en : this.tabList) {
            ((MainTabPane)en.getKey()).getTabComponent().setBackground(bodyPanel.getBackground());
            ((MainTabPane)en.getKey()).getTabComponent().setCursor(new Cursor(0));
            this.tabPane.addTab(((MainTabPane)en.getKey()).getTabName(), ((MainTabPane)en.getKey()).getTabIcon(), ((MainTabPane)en.getKey()).getTabComponent());
        }
        this.tabPane.setSelectedIndex(this.selectedIndex);
        this.tabPane.addChangeListener(this);
        bodyPanel.add((Component)this.tabPane, new XYConstraints(x, y, w, h));
        this.addWindowListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index;
        Object souce = e.getSource();
        if (souce == this.tabPane && this.selectedIndex != (index = this.tabPane.getSelectedIndex())) {
            KeyValueEntry<MainTabPane, Boolean> en;
            int xsize = this.tabList.size();
            if (this.selectedIndex >= 0 && this.selectedIndex < xsize && ((Boolean)(en = this.tabList.get(this.selectedIndex)).getValue()).booleanValue()) {
                ((MainTabPane)en.getKey()).doDiselct();
            }
            this.selectedIndex = index;
            this.doSelectTab();
        }
    }

    private void doSelectTab() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.tabList.size()) {
            KeyValueEntry<MainTabPane, Boolean> en = this.tabList.get(this.selectedIndex);
            if (!((Boolean)en.getValue()).booleanValue()) {
                en.setValue((Object)Boolean.TRUE);
                ((MainTabPane)en.getKey()).init(this.contentSize, this.mainSize);
                ((MainTabPane)en.getKey()).getTabComponent().validate();
                if (((MainTabPane)en.getKey()).getTabComponent() instanceof JComponent) {
                    ((JComponent)((MainTabPane)en.getKey()).getTabComponent()).updateUI();
                }
            }
            ((MainTabPane)en.getKey()).doSelect();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.contentSize == null) {
            int w = this.tabPane.getSelectedComponent().getWidth();
            int h = this.tabPane.getSelectedComponent().getHeight();
            this.contentSize = new Dimension(w, h);
            this.doSelectTab();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    protected void onPressEnter() {
        KeyValueEntry<MainTabPane, Boolean> e = this.tabList.get(this.selectedIndex);
        if (((Boolean)e.getValue()).booleanValue()) {
            ((MainTabPane)e.getKey()).onPressEnter();
        }
    }
}

