/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.sun.awt.AWTUtilities;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class MainSearchDialog
extends JDialog {
    private static final long serialVersionUID = 3488763675977765642L;
    protected CarparkMainFrame mainFrame;
    private JPanel rootPanel;
    protected JPanel bodyPanel;
    private static ImageIcon closeIcon;
    private JLabel titileLabel;
    private ActionListener windowAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("vk_esc".equals(cmd)) {
                MainSearchDialog.this.doPressCloseButton();
            } else if ("closeButton".equals(cmd)) {
                MainSearchDialog.this.doPressCloseButton();
            } else if ("vk_enter".equals(cmd)) {
                MainSearchDialog.this.onPressEnter();
            }
        }
    };

    protected void onPressEnter() {
    }

    protected MainSearchDialog(CarparkMainFrame frame) {
        super(frame, "", false);
        this.mainFrame = frame;
        this.setUndecorated(true);
        this.setResizable(false);
        int roundSize = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
        this.rootPanel = frame.createRoundPanel();
        this.rootPanel.setLayout(new XYLayout());
        this.rootPanel.setBackground(Color.WHITE);
        this.rootPanel.registerKeyboardAction(this.windowAction, "vk_enter", KeyStroke.getKeyStroke(10, 0), 2);
        this.rootPanel.registerKeyboardAction(this.windowAction, "vk_esc", KeyStroke.getKeyStroke(27, 0), 2);
        this.getContentPane().add(this.rootPanel);
        int width = frame.getCenterLeftPanel().getWidth();
        int height = frame.getCenterLeftPanel().getHeight();
        this.setSize(width, height);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, 0.0, width, height, roundSize, roundSize);
        AWTUtilities.setWindowShape((Window)this, (Shape)shape);
        Point lo = frame.getCenterLeftPanel().getLocationOnScreen();
        this.setLocation(lo);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new XYLayout());
        topPanel.setBackground(this.rootPanel.getBackground());
        JButton closeButton = new JButton();
        closeButton.setContentAreaFilled(false);
        int imageWH = (int)Math.round(frame.getRootSize().getHeight() * 16.0 / 768.0);
        if (closeIcon == null) {
            closeIcon = new ImageIcon(SwingUtil.resizeImage(CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("cross_866"), imageWH, imageWH));
        }
        closeButton.setIcon(closeIcon);
        closeButton.setToolTipText("\u70b9\u51fb\u5173\u95ed");
        closeButton.setCursor(new Cursor(12));
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this.windowAction);
        int marginTop = 3;
        int marginLeft = (int)Math.round(frame.getRootSize().getWidth() * 14.0 / 1280.0);
        int topHeight = (int)Math.round(frame.getRootSize().getHeight() * 34.0 / 768.0);
        int topPanelWidth = width - 2 * marginLeft;
        int lineHeight = (int)Math.round(frame.getRootSize().getWidth() * 1.0 / 1280.0);
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, lineHeight, 0, Color.decode("#E5E5E5")));
        this.rootPanel.add((Component)topPanel, new XYConstraints(marginLeft, marginTop, topPanelWidth, topHeight));
        int btY = (topHeight - lineHeight - imageWH) / 2;
        if (btY < 0) {
            btY = 0;
        }
        int btX = topPanelWidth - imageWH;
        topPanel.add((Component)closeButton, new XYConstraints(btX, btY, imageWH, imageWH));
        this.titileLabel = new JLabel();
        int titileHeight = topHeight - lineHeight;
        int titleWidth = topPanelWidth - imageWH - 5;
        topPanel.add((Component)this.titileLabel, new XYConstraints(0, 0, titleWidth, titileHeight));
        int titleFontSize = (int)Math.round(frame.getRootSize().getHeight() * 14.0 / 768.0);
        Font titleFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 1, titleFontSize);
        this.titileLabel.setFont(titleFont);
        this.titileLabel.setForeground(Color.decode("#2b425b"));
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(this.rootPanel.getBackground());
        int bodyWidth = topPanelWidth;
        int bodyY = marginTop + topHeight;
        int marginBottom = (int)Math.round(frame.getRootSize().getHeight() * 20.0 / 768.0);
        int bodyHegiht = height - bodyY - marginBottom;
        Dimension bodySize = new Dimension(bodyWidth, bodyHegiht);
        this.rootPanel.add((Component)this.bodyPanel, new XYConstraints(marginLeft, bodyY, bodyWidth, bodyHegiht));
        try {
            this.init(this.bodyPanel, bodySize, frame.getRootSize());
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    public void setTitleInfo(String title) {
        this.titileLabel.setText(title);
    }

    protected void doPressCloseButton() {
        this.dispose();
    }

    protected abstract void init(JPanel var1, Dimension var2, Dimension var3);
}

