/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.DownloadUpgradeFileCallback;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.UpgradeService;
import com.wovoe.carpark.vo.DownloadUpgradeVo;
import com.wovoe.framework.KeyValueEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainVersionDialog
extends MacDialog
implements MouseListener,
DownloadUpgradeFileCallback {
    private static final long serialVersionUID = 1381096850198479685L;
    private Dimension rootSize;
    private boolean checkOnlineUpgrade;
    private JLabel titleLabel;
    private JLabel currentVersionLabel;
    private JLabel msgLabel;
    private String onclickCmd;
    private KeyValueEntry<String, String> canDownLoadVersion;
    private ImageIcon downloadIcon;
    private ImageIcon loadingIcon;
    private JLabel downloadLabel;

    public static MainVersionDialog createDialog(Component parentComponent, Dimension rootSize, Dimension dialogSize, boolean checkOnlineUpgrade) {
        Window window;
        if (rootSize == null) {
            rootSize = SwingUtil.getScreenSize();
        }
        MainVersionDialog instance = parentComponent == null ? new MainVersionDialog() : ((window = SwingUtil.getWindowForComponent(parentComponent)) instanceof Frame ? new MainVersionDialog((Frame)window, false) : (window instanceof Dialog ? new MainVersionDialog((Dialog)window, false) : (window instanceof Window ? new MainVersionDialog(window, false) : new MainVersionDialog())));
        if (dialogSize == null) {
            int width = (int)Math.round(rootSize.getHeight() * 380.0 / 768.0);
            int height = (int)Math.round(rootSize.getHeight() * 200.0 / 768.0);
            dialogSize = new Dimension(width, height);
        }
        instance.checkOnlineUpgrade = checkOnlineUpgrade;
        instance.rootSize = rootSize;
        instance.init(dialogSize, parentComponent);
        int deployType = ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use();
        String tit = deployType == 3 ? "\u5c97\u4ead\u5ba2\u6237\u7aef+\u7ba1\u7406\u670d\u52a1\u5668" : (deployType == 2 ? "\u7ba1\u7406\u670d\u52a1\u5668" : "\u5c97\u4ead\u5ba2\u6237\u7aef");
        instance.setTitleInfo("        " + tit);
        return instance;
    }

    public MainVersionDialog() {
    }

    public MainVersionDialog(Frame owner, boolean modal) {
        super(owner, null, modal);
    }

    public MainVersionDialog(Window owner, boolean modal) {
        super(owner, null, modal);
    }

    public MainVersionDialog(Dialog owner, boolean modal) {
        super(owner, null, modal);
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        this.showCloseButton(this.getTitileBarHeight());
        body.setLayout(new XYLayout());
        int font12Size = (int)Math.round(0.015789473684210527 * (double)this.rootSize.height);
        int font13Size = (int)Math.round(0.017105263157894738 * (double)this.rootSize.height);
        int font14Size = (int)Math.round(0.018421052631578946 * (double)this.rootSize.height);
        int font16Size = (int)Math.round(0.021052631578947368 * (double)this.rootSize.height);
        String fontName = SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53");
        Font font12 = new Font(fontName, 0, font12Size);
        Font font13 = new Font(fontName, 0, font13Size);
        Font font14 = new Font(fontName, 0, font14Size);
        Font font16 = new Font(fontName, 1, font16Size);
        int margin = (int)Math.round(0.02631578947368421 * (double)this.rootSize.height);
        int labelHeight = (int)Math.round(0.039473684210526314 * (double)this.rootSize.height);
        int buttonHeight = (int)Math.round(0.03289473684210526 * (double)this.rootSize.height);
        int buttonY = panelSize.height - margin - buttonHeight;
        int marginTop = (buttonY - 3 * labelHeight) / 3;
        int w = panelSize.width - 2 * margin;
        int y = marginTop;
        if (!this.checkOnlineUpgrade) {
            y += labelHeight;
        }
        int h = labelHeight;
        int x = margin;
        this.titleLabel = new JLabel("\u5f53\u524d\u7248\u672c\u4e3a:");
        this.titleLabel.setFont(font14);
        this.titleLabel.setHorizontalAlignment(0);
        body.add((Component)this.titleLabel, new XYConstraints(x, y, w, h));
        this.currentVersionLabel = new JLabel(ServiceUtil.getServiceContext().getVersion());
        this.currentVersionLabel.setFont(font16);
        this.currentVersionLabel.setHorizontalAlignment(0);
        body.add((Component)this.currentVersionLabel, new XYConstraints(x, y += h + marginTop, w, h));
        this.msgLabel = new JLabel();
        this.msgLabel.setFont(font13);
        this.msgLabel.setHorizontalAlignment(0);
        this.msgLabel.addMouseListener(this);
        body.add((Component)this.msgLabel, new XYConstraints(x, y += h + marginTop, w, h));
        if (!this.checkOnlineUpgrade) {
            return;
        }
        this.downloadLabel = new JLabel();
        this.downloadLabel.setFont(font12);
        this.downloadLabel.setForeground(Color.decode("#2b425b"));
        this.downloadLabel.setHorizontalAlignment(0);
        body.add((Component)this.downloadLabel, new XYConstraints(x, y += h, w, h));
        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
        String canInstallVersion = upgradeService.getCanInstallVersion();
        if (!ServiceUtil.getServiceContext().isWanOk()) {
            if (canInstallVersion != null && canInstallVersion.length() > 0 && upgradeService.isNeedUpGrade(canInstallVersion)) {
                this.msgLabel.setForeground(new Color(20, 138, 224));
                this.onclickCmd = "installversion=" + canInstallVersion;
                this.msgLabel.setText("\u65b0\u7248\u672c\uff1a" + canInstallVersion + " \u5df2\u4e0b\u8f7d\uff0c\u70b9\u6b64\u8fdb\u884c\u5b89\u88c5\u5347\u7ea7");
                this.msgLabel.setToolTipText("\u70b9\u51fb\u6b64\u5904\u8fdb\u884c\u8f6f\u4ef6\u5347\u7ea7\uff0c\u8fd9\u5c06\u4f1a\u91cd\u542f\u8f6f\u4ef6\u3002");
                this.msgLabel.setCursor(new Cursor(12));
            } else {
                this.msgLabel.setForeground(new Color(237, 120, 118));
                this.msgLabel.setText("\u65e0\u6cd5\u8fde\u63a5\u4e92\u8054\u7f51\uff0c\u65e0\u6cd5\u68c0\u6d4b\u8f6f\u4ef6\u662f\u5426\u6709\u66f4\u65b0!");
            }
        } else if (upgradeService.isDownloadingWanUpgradeFile()) {
            boolean success = upgradeService.addDownloadingWanUpgradeFileCallback(this);
            if (!success) {
                this.checkLaestVersion(canInstallVersion);
            }
        } else {
            this.checkLaestVersion(canInstallVersion);
        }
    }

    private void checkLaestVersion(final String canInstallVersion) {
        this.msgLabel.setForeground(new Color(20, 138, 224));
        this.msgLabel.setIcon(this.getLoadingIcon());
        this.msgLabel.addMouseListener(this);
        this.msgLabel.setText("\u6b63\u5728\u68c0\u6d4b\u8f6f\u4ef6\u662f\u5426\u6709\u66f4\u65b0...");
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block5: {
                    KeyValueEntry<String, String> newVersion = null;
                    try {
                        try {
                            UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                            newVersion = upgradeService.obtainWanLatestVerion();
                        }
                        catch (Exception ex) {
                            GuiLog.getLog().warn((Object)"", (Throwable)ex);
                            KeyValueEntry<String, String> latetVersionEntry = newVersion;
                            SwingUtil.invokeLater(new Runnable(latetVersionEntry, canInstallVersion){
                                private final /* synthetic */ KeyValueEntry val$latetVersionEntry;
                                private final /* synthetic */ String val$canInstallVersion;
                                {
                                    this.val$latetVersionEntry = keyValueEntry;
                                    this.val$canInstallVersion = string;
                                }

                                @Override
                                public void run() {
                                    if (this.val$latetVersionEntry != null) {
                                        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                                        if (upgradeService.isNeedUpGrade((String)this.val$latetVersionEntry.getKey())) {
                                            if (this.val$canInstallVersion != null && this.val$canInstallVersion.length() > 0 && this.val$canInstallVersion.equals(this.val$latetVersionEntry.getKey())) {
                                                MainVersionDialog.this.msgLabel.setIcon(null);
                                                MainVersionDialog.this.onclickCmd = "installversion=" + this.val$canInstallVersion;
                                                MainVersionDialog.this.msgLabel.setText("\u65b0\u7248\u672c\uff1a" + this.val$canInstallVersion + " \u5df2\u4e0b\u8f7d\uff0c\u70b9\u6b64\u8fdb\u884c\u5b89\u88c5\u5347\u7ea7");
                                                MainVersionDialog.this.msgLabel.setToolTipText("\u70b9\u51fb\u6b64\u5904\u8fdb\u884c\u8f6f\u4ef6\u5347\u7ea7\uff0c\u8fd9\u5c06\u4f1a\u91cd\u542f\u8f6f\u4ef6\u3002");
                                                MainVersionDialog.this.msgLabel.setCursor(new Cursor(12));
                                            } else {
                                                MainVersionDialog.this.msgLabel.setIcon(null);
                                                MainVersionDialog.this.canDownLoadVersion = this.val$latetVersionEntry;
                                                MainVersionDialog.this.onclickCmd = "dowloadversion";
                                                MainVersionDialog.this.msgLabel.setText("\u68c0\u6d4b\u5230\u65b0\u7248\u672c\uff1a" + (String)this.val$latetVersionEntry.getKey() + " \u53ef\u5347\u7ea7\uff0c\u70b9\u6b64\u8fdb\u884c\u4e0b\u8f7d\u65b0\u7248\u672c");
                                                MainVersionDialog.this.msgLabel.setCursor(new Cursor(12));
                                                MainVersionDialog.this.msgLabel.setToolTipText("\u70b9\u51fb\u6b64\u5904\u8fdb\u884c\u4e0b\u8f7d\u65b0\u7248\u672c\u5347\u7ea7\u6587\u4ef6\u3002");
                                            }
                                        } else {
                                            MainVersionDialog.this.msgLabel.setIcon(null);
                                            MainVersionDialog.this.msgLabel.setText("\u60a8\u5f53\u524d\u7248\u672c\uff1a" + ServiceUtil.getServiceContext().getVersion() + " \u5df2\u7ecf\u662f\u6700\u65b0\u3002");
                                        }
                                    } else {
                                        MainVersionDialog.this.msgLabel.setForeground(new Color(237, 120, 118));
                                        MainVersionDialog.this.msgLabel.setIcon(null);
                                        MainVersionDialog.this.msgLabel.setText("\u65e0\u6cd5\u83b7\u53d6\u8f6f\u4ef6\u6700\u65b0\u7248\u672c\u4fe1\u606f");
                                    }
                                }
                            });
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        KeyValueEntry<String, String> latetVersionEntry = newVersion;
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    KeyValueEntry<String, String> latetVersionEntry = newVersion;
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    private ImageIcon getLoadingIcon() {
        if (this.loadingIcon == null) {
            this.loadingIcon = new ImageIcon(CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("loading1"));
        }
        return this.loadingIcon;
    }

    private ImageIcon getDownloadIcon() {
        if (this.downloadIcon == null) {
            Image img = CarparkGuiSkinUtil.getCarparkGuiSkin().newImage("downloading_349");
            int wh = (int)Math.round(0.017105263157894738 * (double)this.rootSize.height);
            this.downloadIcon = new ImageIcon(SwingUtil.resizeImage(img, wh, wh));
        }
        return this.downloadIcon;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String cmd = this.onclickCmd;
        if (cmd != null) {
            if ("dowloadversion".equals(cmd) && this.canDownLoadVersion != null) {
                KeyValueEntry<String, String> dv = this.canDownLoadVersion;
                this.onclickCmd = null;
                this.canDownLoadVersion = null;
                this.msgLabel.setIcon(this.getLoadingIcon());
                this.msgLabel.setText("\u6b63\u5728\u4e0b\u8f7d\u65b0\u7248\u672c: " + (String)dv.getKey() + " \u7684\u5347\u7ea7\u6587\u4ef6...");
                UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                upgradeService.downloadWanUpgradeFile(dv, this);
            } else if (cmd.startsWith("installversion=")) {
                this.onclickCmd = null;
                final String ve = cmd.substring("installversion=".length());
                this.msgLabel.setText("\u6b63\u5728\u4fdd\u5b58\u6570\u636e\uff0c\u91cd\u542f\u8f6f\u4ef6...");
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                        upgradeService.doUpGrade(ve);
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void onDownloading(final DownloadUpgradeVo vo) {
        if (vo == null) {
            return;
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Icon ti;
                ImageIcon r;
                if (MainVersionDialog.this.msgLabel != null) {
                    r = MainVersionDialog.this.getLoadingIcon();
                    if (r != (ti = MainVersionDialog.this.msgLabel.getIcon())) {
                        MainVersionDialog.this.msgLabel.setIcon(r);
                    }
                    if (vo.getTotalBytes() > 0L) {
                        MainVersionDialog.this.msgLabel.setText("\u6b63\u5728\u4e0b\u8f7d " + vo.getVersion() + " \u5347\u7ea7\u6587\u4ef6, \u6587\u4ef6\u5927\u5c0f\uff1a" + vo.getToalBytesDes());
                    } else {
                        MainVersionDialog.this.msgLabel.setText("\u6b63\u5728\u4e0b\u8f7d\u65b0\u7248\u672c: " + vo.getVersion() + " \u7684\u5347\u7ea7\u6587\u4ef6...");
                    }
                }
                if (MainVersionDialog.this.downloadLabel != null) {
                    r = MainVersionDialog.this.getDownloadIcon();
                    if (r != (ti = MainVersionDialog.this.downloadLabel.getIcon())) {
                        MainVersionDialog.this.downloadLabel.setIcon(r);
                    }
                    MainVersionDialog.this.downloadLabel.setText("\u5df2\u4e0b\u8f7d:" + vo.getFinishBytesDes() + "\uff0c\u4e0b\u8f7d\u901f\u5ea6:" + vo.getDonwlondRateDes() + "\uff0c\u5269\u4f59\u65f6\u95f4:" + vo.getRemainTimeDes());
                }
            }
        });
    }

    @Override
    public void onDownloadFinishAndCheckUpgrateFile(File file, String version) {
        this.displayMsg("\u5347\u7ea7\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0c\u6b63\u5728\u6821\u9a8c\u6587\u4ef6...", null);
    }

    @Override
    public void onPrepareUpgrateFile(File file, String version) {
        this.displayMsg("\u6b63\u5728\u521d\u59cb\u5316\u5347\u7ea7\u6587\u4ef6...", null);
    }

    @Override
    public void canUpreateFile(File file, final String version) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainVersionDialog.this.msgLabel != null) {
                    MainVersionDialog.this.msgLabel.setIcon(null);
                    MainVersionDialog.this.msgLabel.setForeground(new Color(20, 138, 224));
                    MainVersionDialog.this.onclickCmd = "installversion=" + version;
                    MainVersionDialog.this.msgLabel.setText("\u65b0\u7248\u672c\uff1a" + version + " \u5df2\u4e0b\u8f7d\uff0c\u70b9\u6b64\u8fdb\u884c\u5b89\u88c5\u5347\u7ea7");
                    MainVersionDialog.this.msgLabel.setToolTipText("\u70b9\u51fb\u6b64\u5904\u8fdb\u884c\u8f6f\u4ef6\u5347\u7ea7\uff0c\u8fd9\u5c06\u4f1a\u91cd\u542f\u8f6f\u4ef6\u3002");
                    MainVersionDialog.this.msgLabel.setCursor(new Cursor(12));
                }
                if (MainVersionDialog.this.downloadLabel != null) {
                    if (MainVersionDialog.this.downloadLabel.getText() != null) {
                        MainVersionDialog.this.downloadLabel.setText(null);
                    }
                    if (MainVersionDialog.this.downloadLabel.getIcon() != null) {
                        MainVersionDialog.this.downloadLabel.setIcon(null);
                    }
                }
            }
        });
    }

    private void displayMsg(final String msg, final Color cl) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainVersionDialog.this.msgLabel != null) {
                    MainVersionDialog.this.msgLabel.setIcon(null);
                    if (cl != null) {
                        MainVersionDialog.this.msgLabel.setForeground(cl);
                    }
                    MainVersionDialog.this.msgLabel.setText(msg);
                    MainVersionDialog.this.msgLabel.setToolTipText(null);
                    MainVersionDialog.this.msgLabel.setCursor(new Cursor(0));
                }
                if (MainVersionDialog.this.downloadLabel != null) {
                    if (MainVersionDialog.this.downloadLabel.getText() != null) {
                        MainVersionDialog.this.downloadLabel.setText(null);
                    }
                    if (MainVersionDialog.this.downloadLabel.getIcon() != null) {
                        MainVersionDialog.this.downloadLabel.setIcon(null);
                    }
                }
            }
        });
    }

    @Override
    public void onError(String msg) {
        this.displayMsg(msg, new Color(237, 120, 118));
    }
}

