/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.MainConfirmEvent;
import com.wovoe.carpark.gui.login.MainPassConfirmDialog;
import com.wovoe.carpark.gui.login.MainPassConfirmPanel;
import com.wovoe.carpark.gui.login.PlateInputPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.MainHostPassFilter;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.OperationFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PassEnterConfrmPanel
extends JPanel
implements MainPassConfirmPanel,
ActionListener {
    private static final long serialVersionUID = -5508197188970861968L;
    private JLabel enterPicLabel1;
    private JLabel enterPicLabel2;
    private JPanel picPanel;
    private XYConstraints picCons;
    private Dimension picSize;
    private MainPassConfirmDialog confirmDialog;
    private JLabel titileLabel;
    private JLabel channelLabel;
    private JLabel channelTextLabel;
    private JLabel enterTimeLabel;
    private JLabel enterTimeTextLabel;
    private PlateInputPanel plateTextLabel;
    private JLabel carTypeLabel;
    private JComboBox<ComboBoxEntry<CarparkCarType>> carTypeSelect;
    private volatile boolean canactionCartype = true;
    private JLabel passTypeLabel;
    private JLabel passTypeTextLabel;
    private JLabel attrLabel;
    private JLabel attrTextLabel;
    private JLabel carOwnerInfoLabel;
    private JLabel carOwnerInfoTextLabel;
    private JLabel errMsgLabel;
    private JLabel errMsgTextLabel;
    private JButton okButton;
    private JButton cancelButton;
    private PassSession passSession;
    private MainConfirmEvent mainConfirmEvent;
    private JPopupMenu selectplatePopupMenu;
    private Dimension popupMenuItemSize;
    private int maxPlateLikeLen = 10;
    private Font plateLikeFont;
    private ConcurrentLinkedQueue<String> plateQueryQueue0 = new ConcurrentLinkedQueue();
    private AtomicBoolean querying0 = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<String> plateReloadQueue1 = new ConcurrentLinkedQueue();
    private AtomicBoolean plateReloading1 = new AtomicBoolean(false);
    private AtomicBoolean doOkFinish = new AtomicBoolean(false);
    private volatile boolean doSelectRsetInfo = false;
    private Font textLevelVFont;
    private Font textLevelVSmallFont;
    private String defaultInputPlate;
    private int minPlateCharLength;

    @Override
    public Component getLayerComponent() {
        return this;
    }

    @Override
    public void disSelected() {
        if (this.plateTextLabel != null) {
            this.plateTextLabel.closeAllDialog();
        }
        if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
    }

    @Override
    public void doSelect() {
        String plate;
        if (this.doSelectRsetInfo) {
            this.doSelectRsetInfo = false;
            if (this.passSession != null) {
                this.setInfo(this.passSession);
            }
        }
        if (this.plateTextLabel != null && !this.isValidPlateLength(plate = this.plateTextLabel.getPlate())) {
            this.plateTextLabel.getTextField().requestFocus();
        }
    }

    @Override
    public void init(Dimension size, MainPassConfirmDialog dialog, MainConfirmEvent event, Color bodyBgColor) {
        int mglex;
        Font textFont;
        List<CaptureEvent> list;
        if (this.picPanel != null) {
            return;
        }
        this.mainConfirmEvent = event;
        if (event != null && event.getAttachment() != null && event.getAttachment() instanceof PassSession) {
            this.passSession = (PassSession)event.getAttachment();
        }
        boolean hasOtherPic = false;
        if (this.passSession.getReadPassportNumberEvent() != null && (list = this.passSession.getReadPassportNumberEvent().getCaptures()) != null && !list.isEmpty()) {
            for (CaptureEvent e : list) {
                if (e.getPicture_use() == 1) continue;
                hasOtherPic = true;
                break;
            }
        }
        this.confirmDialog = dialog;
        this.setBackground(bodyBgColor);
        this.setLayout(new XYLayout());
        this.picPanel = new JPanel();
        this.picPanel.setBackground(Color.WHITE);
        if (hasOtherPic) {
            this.picPanel.setLayout(new GridLayout(1, 2));
            this.enterPicLabel1 = new JLabel();
            this.enterPicLabel2 = new JLabel();
            this.picPanel.add(this.enterPicLabel1);
            this.picPanel.add(this.enterPicLabel2);
        } else {
            this.picPanel.setLayout(new GridLayout(1, 1));
            this.enterPicLabel1 = new JLabel();
            this.picPanel.add(this.enterPicLabel1);
        }
        int margx = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getWidth() * 14.0 / 1280.0);
        int picX = 0;
        int picY = 0;
        int picW = (size.width - margx) / 2;
        int picH = size.height;
        this.picCons = new XYConstraints(picX, picY, picW, picH);
        this.add((Component)this.picPanel, this.picCons);
        this.picSize = new Dimension(this.picCons.getWidth() - 2, this.picCons.getHeight() - 2);
        boolean isManed = this.passSession != null && this.passSession.getReadPassportNumberEvent() != null && this.passSession.getReadPassportNumberEvent().isManualTrigger();
        Color titleColor = Color.decode("#F6F6F6");
        Color titleColor1 = Color.decode("#c8fffc");
        int titleFontSize = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 20.0 / 768.0);
        this.titileLabel = new JLabel(isManed ? "\u5165\u573a\u4eba\u5de5\u653e\u884c" : "\u5165\u573a\u786e\u8ba4");
        Font titleFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, titleFontSize);
        int titleX = picX + picW + 5;
        int titleY = 0;
        int titleH = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 40.0 / 768.0);
        int titleW = size.width - titleX - 5;
        this.titileLabel.setHorizontalAlignment(0);
        this.titileLabel.setForeground(titleColor1);
        this.titileLabel.setFont(titleFont);
        this.add((Component)this.titileLabel, new XYConstraints(titleX, titleY, titleW, titleH));
        int marginBottom = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 15.0 / 768.0);
        int marginTop = 0;
        int line1Y = marginTop + titleY + titleH;
        int totoalHeight = size.height - marginBottom - line1Y;
        int avgHeight = totoalHeight / 6;
        int marginLeft = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getWidth() * 15.0 / 1024.0);
        int marginRight = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getWidth() * 15.0 / 1024.0);
        int linex = picX + picW + marginLeft;
        int lineWidth = size.width - linex - marginRight;
        JPanel p = new JPanel();
        XYConstraints pxywh = new XYConstraints(linex, line1Y, lineWidth + marginRight - 2, totoalHeight - avgHeight);
        this.add((Component)p, pxywh);
        p.setBackground(this.getBackground());
        p.setLayout(new XYLayout());
        int fontSize = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
        this.textLevelVFont = textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        this.textLevelVSmallFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 12.0 / 768.0));
        int lWidth = fontSize * 5;
        int contentWidth = lineWidth / 2 - lWidth;
        int leftx = mglex = 0;
        int ty = 0;
        int tH = avgHeight;
        int plateInputHeight = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 30.0 / 768.0);
        if (plateInputHeight > tH) {
            plateInputHeight = tH;
        }
        int plateInputWidth = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 44.0 / 768.0);
        int ty0 = (tH - plateInputHeight) / 2;
        Dimension leftRightsize = new Dimension(plateInputWidth, plateInputHeight);
        int platePanelWidth = contentWidth + lWidth - fontSize;
        Dimension plateTextRightsize = new Dimension(platePanelWidth - 2 * leftRightsize.width, plateInputHeight);
        Point dialogPoint = dialog.getLocation();
        Point platepanelPonit = new Point(dialogPoint.x + leftx + pxywh.getX() + 3, dialogPoint.y + ty + ty0 + pxywh.getY() + 3);
        int blockborderSize = (int)Math.floor(dialog.getCarparkMainFrame().getRootSize().getHeight() * 1.0 / 800.0);
        if (blockborderSize <= 0) {
            blockborderSize = 1;
        }
        this.plateTextLabel = new PlateInputPanel(leftRightsize, plateTextRightsize, textFont, platepanelPonit, platepanelPonit, blockborderSize, new Runnable(){

            @Override
            public void run() {
                PassEnterConfrmPanel.this.setPlateResult();
            }
        });
        this.plateTextLabel.getLeftButton().setActionCommand("plate_left");
        this.plateTextLabel.getLeftButton().addActionListener(this);
        this.plateTextLabel.getRightButton().setActionCommand("plate_right");
        this.plateTextLabel.getRightButton().addActionListener(this);
        XYConstraints plateInputXy = new XYConstraints(leftx, ty + ty0, platePanelWidth, plateInputHeight);
        p.add((Component)this.plateTextLabel, plateInputXy);
        this.selectplatePopupMenu = new JPopupMenu();
        this.selectplatePopupMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#979797")));
        int itemFontSize = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
        this.plateLikeFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
        int itemHeight = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 25.0 / 768.0);
        this.popupMenuItemSize = new Dimension(plateTextRightsize.width, itemHeight);
        this.maxPlateLikeLen = (pxywh.getHeight() - plateInputXy.getY() - plateInputXy.getHeight()) / this.popupMenuItemSize.height;
        if (this.maxPlateLikeLen < 3) {
            this.maxPlateLikeLen = 3;
        }
        this.plateTextLabel.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PassEnterConfrmPanel.this.confirmDialog.isSelectedPanel(PassEnterConfrmPanel.this)) {
                    PassEnterConfrmPanel.this.setPlateResult();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.plateTextLabel.getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
                    if (PassEnterConfrmPanel.this.selectplatePopupMenu != null && PassEnterConfrmPanel.this.selectplatePopupMenu.isVisible()) {
                        PassEnterConfrmPanel.this.selectplatePopupMenu.setVisible(false);
                    }
                } else if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && PassEnterConfrmPanel.this.confirmDialog.isSelectedPanel(PassEnterConfrmPanel.this)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PassEnterConfrmPanel.this.doLikeSelect();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.carTypeLabel = new JLabel("\u8f66\u8f86\u7c7b\u578b:");
        this.carTypeLabel.setFont(textFont);
        this.carTypeLabel.setForeground(titleColor);
        p.add((Component)this.carTypeLabel, new XYConstraints(leftx += platePanelWidth + fontSize, ty, lWidth, tH));
        leftx += lWidth;
        Vector<ComboBoxEntry<CarparkCarType>> items = new Vector<ComboBoxEntry<CarparkCarType>>();
        Map<String, CarparkCarType> typeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (typeMap != null) {
            for (CarparkCarType t : typeMap.values()) {
                items.add(new ComboBoxEntry<CarparkCarType>(t, t.getCar_type_name()));
            }
        }
        this.carTypeSelect = new JComboBox(items);
        if (!items.isEmpty()) {
            this.carTypeSelect.setSelectedIndex(0);
        }
        this.carTypeSelect.setFont(textFont);
        this.carTypeSelect.setBackground(Color.WHITE);
        p.add(this.carTypeSelect, new XYConstraints(leftx, ty + ty0, contentWidth, plateInputHeight));
        this.carTypeSelect.setActionCommand("cartypeselect");
        this.carTypeSelect.addActionListener(this);
        leftx = mglex;
        this.channelLabel = new JLabel(isManed ? "\u653e\u884c\u901a\u9053" : "\u5165\u573a\u901a\u9053:");
        this.channelLabel.setFont(textFont);
        this.channelLabel.setForeground(titleColor);
        p.add((Component)this.channelLabel, new XYConstraints(leftx, ty += tH, lWidth, tH));
        this.channelTextLabel = new JLabel();
        this.channelTextLabel.setFont(textFont);
        this.channelTextLabel.setForeground(Color.WHITE);
        p.add((Component)this.channelTextLabel, new XYConstraints(leftx += lWidth, ty, contentWidth, tH));
        this.enterTimeLabel = new JLabel("\u5165\u573a\u65f6\u95f4:");
        this.enterTimeLabel.setFont(textFont);
        this.enterTimeLabel.setForeground(titleColor);
        p.add((Component)this.enterTimeLabel, new XYConstraints(leftx += contentWidth, ty, lWidth, tH));
        this.enterTimeTextLabel = new JLabel();
        this.enterTimeTextLabel.setFont(textFont);
        this.enterTimeTextLabel.setForeground(Color.WHITE);
        p.add((Component)this.enterTimeTextLabel, new XYConstraints(leftx += lWidth, ty, contentWidth + marginRight - 2, tH));
        leftx = mglex;
        this.passTypeLabel = new JLabel("\u8f66\u724c\u7c7b\u578b:");
        this.passTypeLabel.setFont(textFont);
        this.passTypeLabel.setForeground(titleColor);
        p.add((Component)this.passTypeLabel, new XYConstraints(leftx, ty += tH, lWidth, tH));
        this.passTypeTextLabel = new JLabel();
        this.passTypeTextLabel.setFont(textFont);
        this.passTypeTextLabel.setForeground(Color.WHITE);
        p.add((Component)this.passTypeTextLabel, new XYConstraints(leftx += lWidth, ty, contentWidth, tH));
        this.attrLabel = new JLabel();
        this.attrLabel.setFont(textFont);
        this.attrLabel.setForeground(titleColor);
        p.add((Component)this.attrLabel, new XYConstraints(leftx += contentWidth, ty, lWidth, tH));
        this.attrTextLabel = new JLabel();
        this.attrTextLabel.setFont(textFont);
        this.attrTextLabel.setForeground(Color.WHITE);
        p.add((Component)this.attrTextLabel, new XYConstraints(leftx += lWidth, ty, contentWidth, tH));
        leftx = mglex;
        this.carOwnerInfoLabel = new JLabel("\u8f66\u4e3b\u4fe1\u606f:");
        this.carOwnerInfoLabel.setFont(textFont);
        this.carOwnerInfoLabel.setForeground(titleColor);
        p.add((Component)this.carOwnerInfoLabel, new XYConstraints(leftx, ty += tH, lWidth, tH));
        this.carOwnerInfoTextLabel = new JLabel();
        this.carOwnerInfoTextLabel.setFont(textFont);
        this.carOwnerInfoTextLabel.setForeground(Color.WHITE);
        p.add((Component)this.carOwnerInfoTextLabel, new XYConstraints(leftx += lWidth, ty, lineWidth - leftx, tH));
        leftx = mglex;
        this.errMsgLabel = new JLabel("\u5f02\u5e38\u4fe1\u606f:");
        this.errMsgLabel.setFont(textFont);
        this.errMsgLabel.setForeground(titleColor);
        p.add((Component)this.errMsgLabel, new XYConstraints(leftx, ty += tH, lWidth, tH));
        this.errMsgTextLabel = new JLabel();
        this.errMsgTextLabel.setFont(textFont);
        this.errMsgTextLabel.setForeground(Color.decode("#FFD8E2"));
        p.add((Component)this.errMsgTextLabel, new XYConstraints(leftx += lWidth, ty, lineWidth - leftx, tH));
        int rbfontSize = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 14.0 / 768.0);
        Font rbFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbfontSize);
        int rbheight = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 28.0 / 768.0);
        int rbWidth = rbfontSize * 6;
        int rbgrap = (size.width - picX - picW - 2 * rbWidth) / 3;
        int buttonH = size.height - pxywh.getY() - pxywh.getHeight();
        int rbtop = (buttonH - rbheight) / 2;
        int rbY = rbtop + pxywh.getY() + pxywh.getHeight();
        int rbX = rbgrap + picX + picW;
        this.cancelButton = new JButton("\u53d6\u6d88\u653e\u884c");
        this.cancelButton.setFont(rbFont);
        this.cancelButton.setCursor(new Cursor(12));
        this.cancelButton.setForeground(Color.decode("#D01A00"));
        this.cancelButton.setActionCommand("cancelpass");
        this.cancelButton.addActionListener(this);
        this.add((Component)this.cancelButton, new XYConstraints(rbX, rbY, rbWidth, rbheight));
        this.okButton = new JButton("\u786e\u8ba4\u653e\u884c");
        this.okButton.setFont(rbFont);
        this.okButton.setCursor(new Cursor(12));
        this.add((Component)this.okButton, new XYConstraints(rbX += rbgrap + rbWidth, rbY, rbWidth, rbheight));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("okpass");
        this.okButton.addActionListener(this);
        this.loadPic(event == null ? null : event.getAttachment(), this.enterPicLabel1);
        this.loadPic(event == null ? null : event.getAttachment(), this.enterPicLabel2);
        this.setInfo(event == null ? null : event.getAttachment());
    }

    private void closeDialog() {
        this.confirmDialog.finishEvent(this.mainConfirmEvent);
    }

    public void doCancel() {
        try {
            try {
                if (this.passSession != null && this.passSession.getOpenDialogCacnelRecord() != null) {
                    this.passSession.doSaveCancelPassRecrodIfExist(true, true);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u53d6\u6d88\u6570\u636e\u5f02\u5e38\uff01", (Throwable)ex);
            }
            this.doCancel0();
        }
        finally {
            this.closeDialog();
        }
    }

    private void doCancel0() {
        if (this.passSession != null) {
            this.passSession.setAttribute("GUI_MAN_CANCEL", Boolean.TRUE);
            this.passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
            this.passSession.setSessionState(PassSession.SessionState.CANCELED);
        }
    }

    public void doOK() {
        String plate = this.plateTextLabel.getPlate();
        if (plate != null && plate.equals(this.getDefaultInputPlate())) {
            plate = null;
        }
        if (!this.passSession.isReadCard()) {
            if (plate == null || plate.length() < this.getMinPlateCharLength() || plate.length() > this.getMaxPlateCharLength()) {
                this.errMsgTextLabel.setText("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8f66\u724c");
                return;
            }
            if (!this.okButton.isEnabled()) {
                return;
            }
            String passPlate = this.passSession.getPassPlate();
            if (!plate.equals(passPlate)) {
                this.setPlateResult();
                return;
            }
        } else if (plate != null && plate.length() > 0 && (plate.length() < this.getMinPlateCharLength() || plate.length() > this.getMaxPlateCharLength())) {
            this.errMsgTextLabel.setText("\u8865\u5f55\u7684\u8f66\u724c\u53f7\u9519\u8bef");
            return;
        }
        if (this.doOkFinish.compareAndSet(false, true)) {
            try {
                this.doOK0();
            }
            finally {
                this.closeDialog();
            }
        }
    }

    public String getDefaultInputPlate() {
        if (this.defaultInputPlate == null) {
            this.defaultInputPlate = ServiceUtil.getServiceContext().getDBConfigCache().getDefaultInputPlate();
            if (this.defaultInputPlate == null) {
                this.defaultInputPlate = "";
            }
        }
        return this.defaultInputPlate;
    }

    public int getMinPlateCharLength() {
        if (this.minPlateCharLength <= 0) {
            this.minPlateCharLength = ServiceUtil.getServiceContext().getDBConfigCache().getMinPlateCharLength();
            if (this.minPlateCharLength <= 0) {
                this.minPlateCharLength = 3;
            }
        }
        return this.minPlateCharLength;
    }

    public int getMaxPlateCharLength() {
        return 15;
    }

    public boolean isValidPlateLength(String plate) {
        if (plate != null && plate.equals(this.getDefaultInputPlate())) {
            plate = null;
        }
        return plate != null && plate.length() >= this.getMinPlateCharLength() && plate.length() <= this.getMaxPlateCharLength();
    }

    private void doOK0() {
        if (this.passSession != null && this.passSession.isReadCard()) {
            String plate = this.plateTextLabel.getPlate();
            if (this.isValidPlateLength(plate)) {
                this.passSession.setAttribute("GUI_INPUT_PLATE", plate);
            } else {
                this.passSession.removeAttribute("GUI_INPUT_PLATE");
            }
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        Object object = PassEnterConfrmPanel.this.passSession.getExeFilterLock();
                        synchronized (object) {
                            if (PassEnterConfrmPanel.this.passSession.getAttribute("SavePassDataFilter.SAVEPASSDATASUCCESS") == null) {
                                PassEnterConfrmPanel.this.passSession.setAttribute("GUI_OK", Boolean.TRUE);
                                ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(PassEnterConfrmPanel.this.passSession, PassEnterConfrmPanel.this.passSession.getConfirmPassFilter());
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (PassEnterConfrmPanel.this.passSession != null) {
                            PassEnterConfrmPanel.this.passSession.setAttribute("GUI_MAN_CANCEL", Boolean.TRUE);
                            PassEnterConfrmPanel.this.passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                            PassEnterConfrmPanel.this.passSession.setSessionState(PassSession.SessionState.CANCELED);
                        }
                        GuiLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", ex);
                        if (PassEnterConfrmPanel.this.passSession == null) break block7;
                        String msg = PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent().getPassportNumber() : "";
                        String message = String.valueOf(PassEnterConfrmPanel.this.passSession.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(PassEnterConfrmPanel.this.passSession, message, 4));
                    }
                }
            }
        });
    }

    private void setCarType() {
        try {
            this.canactionCartype = false;
            CarparkCarType carType = this.passSession.getCarType();
            if (carType != null) {
                int selectIndex = this.carTypeSelect.getSelectedIndex();
                int count = this.carTypeSelect.getItemCount();
                int needSelectIndex = selectIndex;
                int i = 0;
                while (i < count) {
                    ComboBoxEntry<CarparkCarType> t = this.carTypeSelect.getItemAt(i);
                    if (((CarparkCarType)t.getKey()).getCar_type_no().equals(carType.getCar_type_no())) {
                        needSelectIndex = i;
                        break;
                    }
                    ++i;
                }
                if (needSelectIndex != selectIndex) {
                    this.carTypeSelect.setSelectedIndex(needSelectIndex);
                }
            }
        }
        finally {
            this.canactionCartype = true;
        }
    }

    private void setInfo(Object attach) {
        try {
            String v;
            String guiDisplayMonthDuration;
            String platex;
            PassSession session = (PassSession)attach;
            boolean pleaseEnterPlate = false;
            String plate = session.getPassPlate();
            if (plate == null) {
                plate = "";
            }
            if (plate.startsWith("\u8bf7\u8f93\u5165\u8f66\u724c")) {
                pleaseEnterPlate = true;
                this.plateTextLabel.setPlate(this.getDefaultInputPlate());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PassEnterConfrmPanel.this.plateTextLabel.getTextField().requestFocus();
                    }
                });
            } else {
                String plate1 = this.plateTextLabel.getPlate();
                if (!plate.equals(plate1)) {
                    this.plateTextLabel.setPlate(plate);
                }
            }
            this.setCarType();
            this.channelTextLabel.setText(session.getPassChannel().getChannel().getChannel_name());
            Date passTime = (Date)session.getAttribute("passTime");
            if (passTime != null) {
                this.enterTimeTextLabel.setText(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(passTime));
            } else {
                this.enterTimeTextLabel.setText("");
            }
            if (session.getPassportType() != null) {
                this.passTypeTextLabel.setText(session.getPassportType().getPassport_type_name());
            } else {
                this.passTypeTextLabel.setText("");
            }
            StringBuilder exceptionsbr = new StringBuilder();
            HashSet<Integer> exceptionSet = new HashSet<Integer>();
            if (session.getAllowPassExcetpions() != null) {
                exceptionSet.addAll(session.getAllowPassExcetpions());
            }
            if (session.getConfirmPassExceptions() != null) {
                exceptionSet.addAll(session.getConfirmPassExceptions());
            }
            if (session.getForbidPassExceptions() != null) {
                exceptionSet.addAll(session.getForbidPassExceptions());
            }
            CarparkPassportType bindPassType = session.getDatabasePassportType();
            String xtop = this.attrTextLabel.getToolTipText();
            if (xtop != null && !"".equals(xtop)) {
                this.attrTextLabel.setToolTipText("");
            }
            if (exceptionSet.contains(7)) {
                this.attrLabel.setText("\u672a\u542f\u7528:");
                this.attrTextLabel.setText(bindPassType == null ? "" : bindPassType.getPassport_type_name());
                if (session.getPassport() != null && session.getPassport().getStart_date() != null) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u542f\u7528\u65e5\u671f:").append(new SimpleDateFormat("yyyy-MM-dd").format(session.getPassport().getStart_date()));
                }
            } else if (exceptionSet.contains(8)) {
                this.attrLabel.setText("\u5df2\u505c\u7528:");
                this.attrTextLabel.setText(bindPassType == null ? "" : bindPassType.getPassport_type_name());
                if (session.getPassport() != null && session.getPassport().getStop_date() != null) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u505c\u7528\u65e5\u671f:").append(new SimpleDateFormat("yyyy-MM-dd").format(session.getPassport().getStop_date()));
                }
            } else if (session.getPassportType().getPass_type() == 2) {
                this.attrLabel.setText("\u6709\u6548\u671f\u81f3:");
                if (session.getPassport().getDeadline() != null) {
                    this.attrTextLabel.setText(new SimpleDateFormat("yyyy-MM-dd").format(session.getPassport().getDeadline()));
                } else {
                    this.attrTextLabel.setText("");
                }
            } else if (session.getPassportType().getPass_type() == 1) {
                this.attrLabel.setText("\u8d26\u6237\u4f59\u989d:");
                if (session.getPassport().getBalance() == null) {
                    this.attrTextLabel.setText("");
                } else {
                    NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                    this.attrTextLabel.setText(sf.format(session.getPassport().getBalance()));
                }
            } else if (session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 1) {
                List existMutiCarEnterRecords;
                LinkedList<CarparkPresenceRecord> exitplateList = null;
                StringBuilder toolTipBuilder = null;
                if (session.getPassport().getRegister_plate() != null && session.getPassport().getRegister_plate().length() > 0 && (existMutiCarEnterRecords = (List)session.getAttribute("existMutiCarEnterRecords")) != null && !existMutiCarEnterRecords.isEmpty()) {
                    SimpleDateFormat df = null;
                    for (CarparkPresenceRecord r : existMutiCarEnterRecords) {
                        if (r.getEnter_plate() == null || r.getEnter_plate().length() <= 0 || r.getExit_time() != null || r.getEnter_time() == null || r.getEnter_plate().equals(session.getPassport().getRegister_plate())) continue;
                        if (exitplateList == null) {
                            exitplateList = new LinkedList<CarparkPresenceRecord>();
                        }
                        exitplateList.add(r);
                        if (toolTipBuilder == null) {
                            toolTipBuilder = new StringBuilder();
                        }
                        if (df == null) {
                            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                        if (toolTipBuilder.length() > 0) {
                            toolTipBuilder.append("<br>");
                        }
                        toolTipBuilder.append(r.getEnter_plate()).append('\uff1a');
                        toolTipBuilder.append(df.format(r.getEnter_time()));
                    }
                }
                if (exitplateList != null && !exitplateList.isEmpty()) {
                    this.attrLabel.setText("\u5728\u573a\u8f66\u8f86:");
                    this.attrTextLabel.setText(((CarparkPresenceRecord)exitplateList.get(0)).getEnter_plate());
                    if (toolTipBuilder != null && toolTipBuilder.length() > 0) {
                        this.attrTextLabel.setToolTipText("<html>" + toolTipBuilder + "</html>");
                    }
                } else {
                    this.attrLabel.setText("");
                    this.attrTextLabel.setText("");
                }
            } else {
                this.attrLabel.setText("");
                this.attrTextLabel.setText("");
            }
            if (session.getCarOwner() != null) {
                String v1 = session.getCarOwner().getCar_owner_name();
                v1 = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("car_owner_name", v1);
                if (session.getCarOwner().getAddress() != null && session.getCarOwner().getAddress().length() > 0) {
                    v1 = String.valueOf(v1) + "\u3001" + ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("address", session.getCarOwner().getAddress());
                }
                this.carOwnerInfoTextLabel.setText(v1);
            } else {
                this.carOwnerInfoTextLabel.setText("");
            }
            boolean usesmallTextV = false;
            String key_MonthlyFreeDurationInfo = "MonthlyFreeDurationInfo";
            Map infoMap = (Map)this.passSession.getAttribute(key_MonthlyFreeDurationInfo);
            if (infoMap != null && (platex = (String)infoMap.get("monthlyFreeDurationPlateNo")) != null && platex.length() > 0 && platex.equals(this.passSession.getPassPlate()) && (guiDisplayMonthDuration = (String)infoMap.get("guiDisplayMonthDuration")) != null && guiDisplayMonthDuration.length() > 0) {
                v = this.carOwnerInfoTextLabel.getText();
                if (v == null || v.length() == 0) {
                    this.carOwnerInfoTextLabel.setText(guiDisplayMonthDuration);
                } else {
                    this.carOwnerInfoTextLabel.setText(String.valueOf(guiDisplayMonthDuration) + ", " + v);
                }
                usesmallTextV = true;
            }
            if (usesmallTextV) {
                if (!this.carOwnerInfoTextLabel.getFont().equals(this.textLevelVSmallFont)) {
                    this.carOwnerInfoTextLabel.setFont(this.textLevelVSmallFont);
                }
            } else if (!this.carOwnerInfoTextLabel.getFont().equals(this.textLevelVFont)) {
                this.carOwnerInfoTextLabel.setFont(this.textLevelVFont);
            }
            if (pleaseEnterPlate) {
                if (exceptionsbr.length() > 0) {
                    exceptionsbr.append('\u3001');
                }
                exceptionsbr.append("\u8bf7\u8f93\u5165\u653e\u884c\u8f66\u724c\u53f7");
            } else {
                String msg;
                if (exceptionSet.contains(1)) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u65e0\u6743\u9650\u8fdb\u5165");
                }
                if (exceptionSet.contains(2)) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u91cd\u590d\u5165\u573a");
                }
                if (exceptionSet.contains(4)) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u5df2\u8fc7\u671f");
                }
                if (exceptionSet.contains(5)) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u8f66\u4f4d\u4e0d\u8db3");
                }
                if (exceptionSet.contains(6)) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append("\u9ed1\u540d\u5355\u8f66");
                }
                if (exceptionSet.contains(100) && (msg = (String)session.getAttribute("PASS_EXCEPTION_NO_PERMISSSION100_MSG")) != null && msg.length() > 0) {
                    if (exceptionsbr.length() > 0) {
                        exceptionsbr.append('\u3001');
                    }
                    exceptionsbr.append(msg);
                }
            }
            this.errMsgTextLabel.setText(exceptionsbr.toString());
            if (this.passSession.isReadCard()) {
                String mediaNumber = this.passSession.getReadPassportNumberEvent().getDetectedPassEvent().getMediaNumber();
                String enx = mediaNumber.startsWith("WX_") ? "\u5fae\u4fe1ID:" : (mediaNumber.startsWith("AL_") ? "\u652f\u4ed8\u5b9dID:" : "\u901a\u884c\u5361\u53f7:");
                v = this.carOwnerInfoTextLabel.getText();
                if (v == null || v.length() == 0) {
                    this.carOwnerInfoTextLabel.setText(String.valueOf(enx) + mediaNumber);
                } else {
                    this.carOwnerInfoTextLabel.setText(String.valueOf(v) + " " + enx + mediaNumber);
                }
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)"", ex);
        }
    }

    private void loadPic(Object attach, final JLabel picLabel) {
        if (picLabel == null) {
            return;
        }
        Image image = null;
        try {
            List<CaptureEvent> list;
            boolean loadNoPic = true;
            PassSession session = (PassSession)attach;
            if (picLabel == this.enterPicLabel1 && session.getPlateRecognizedEvent() != null) {
                image = this.loadImage(session.getPlateRecognizedEvent().getPicPath(), session.getPlateRecognizedEvent().getPlateSmallPath());
            }
            final Dimension picSize1 = this.enterPicLabel2 != null ? new Dimension(this.picSize.width / 2 - 1, this.picSize.height) : this.picSize;
            if (image == null && session.getReadPassportNumberEvent() != null && (list = session.getReadPassportNumberEvent().getCaptures()) != null && !list.isEmpty()) {
                CaptureEvent ce0 = null;
                for (CaptureEvent c : list) {
                    if (c == null) continue;
                    if (this.enterPicLabel1 == picLabel) {
                        if (c.getPicture_use() != 1) continue;
                        ce0 = c;
                        break;
                    }
                    if (c.getPicture_use() == 1) continue;
                    ce0 = c;
                    break;
                }
                final CaptureEvent ce = ce0;
                if (ce != null && ce.getCaptureHandle() != null) {
                    if (ce.getCaptureHandle().isDone()) {
                        BufferedImage cap;
                        Integer a;
                        if (ce.getCaptureHandle().getException() == null && (a = (Integer)ce.getCaptureHandle().getResult()) != null && a == 0 && (cap = this.loadImage(ce.getImgLocalPath())) != null) {
                            image = picSize1 != null ? SwingUtil.resizeImage((Image)cap, picSize1.width, picSize1.height) : cap;
                        }
                    } else {
                        loadNoPic = false;
                        this.setLoading(picLabel);
                        ce.getCaptureHandle().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void operationComplete(OperationFuture<Integer> f) {
                                BufferedImage cap;
                                Integer a;
                                Image image = null;
                                if (!f.isCancelled() && f.getException() == null && (a = (Integer)f.getResult()) != null && a == 0 && (cap = PassEnterConfrmPanel.this.loadImage(ce.getImgLocalPath())) != null) {
                                    image = picSize1 != null ? SwingUtil.resizeImage((Image)cap, picSize1.width, picSize1.height) : cap;
                                }
                                this.displayPic(image);
                            }

                            private void displayPic(Image image) {
                                if (image == null) {
                                    image = PassEnterConfrmPanel.this.getNoPicImage(picSize1);
                                }
                                if (image != null) {
                                    final Image image0 = image;
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ImageIcon icon = new ImageIcon(image0);
                                            picLabel.setIcon(icon);
                                            picLabel.setText(null);
                                        }
                                    });
                                }
                            }

                            public void waitCompleteTimeout() {
                                this.displayPic(null);
                            }
                        });
                    }
                }
            }
            if (image == null && loadNoPic) {
                image = this.getNoPicImage(picSize1);
            }
            if (image != null) {
                ImageIcon icon = new ImageIcon(image);
                picLabel.setIcon(icon);
                picLabel.setText(null);
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private void setLoading(JLabel imageLabel) {
        Image load;
        int h1 = imageLabel.getHorizontalTextPosition();
        if (h1 != 11) {
            imageLabel.setHorizontalTextPosition(11);
        }
        if ((h1 = imageLabel.getVerticalTextPosition()) != 0) {
            imageLabel.setVerticalTextPosition(0);
        }
        if ((h1 = imageLabel.getHorizontalAlignment()) != 0) {
            imageLabel.setHorizontalAlignment(0);
        }
        if ((load = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("loading1")) == null) {
            imageLabel.setIcon(null);
        } else {
            imageLabel.setIcon(new ImageIcon(load));
        }
        imageLabel.setText("\u6293\u62cd\u56fe\u7247\u4e2d...");
    }

    private Image getNoPicImage(Dimension picSize) {
        Image image = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("no_pic2");
        if (image != null) {
            if (picSize == null) {
                return image;
            }
            return SwingUtil.resizeImage(image, picSize.width, picSize.height);
        }
        return null;
    }

    private BufferedImage loadImage(String bigPath, String smallPath) {
        BufferedImage bigImage = this.loadImage(bigPath);
        if (bigImage == null) {
            return null;
        }
        BufferedImage smallImage = this.loadImage(smallPath);
        return this.createImage(bigImage, smallImage);
    }

    private BufferedImage createImage(BufferedImage bigImage, BufferedImage smallImage) {
        BufferedImage newImage;
        if (bigImage == null) {
            return null;
        }
        if (this.picSize == null) {
            return bigImage;
        }
        int bigWith = this.picSize.width;
        int bigHeight = this.picSize.height;
        try {
            newImage = new BufferedImage(bigWith, bigHeight, bigImage.getType());
            Graphics g = newImage.getGraphics();
            try {
                Image image = bigImage.getScaledInstance(bigWith, bigHeight, 4);
                g.drawImage(image, 0, 0, null);
                if (smallImage != null) {
                    int smallImageHegiht;
                    int smallImageWidth = smallImage.getWidth();
                    if (smallImageWidth > 110) {
                        smallImageWidth = 110;
                    }
                    if ((smallImageHegiht = smallImage.getHeight()) > 45) {
                        smallImageHegiht = 45;
                    }
                    int smallWidth = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * (double)smallImageWidth / 1280.0);
                    int smallHeight = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * (double)smallImageHegiht / 768.0);
                    Image i = SwingUtil.resizeImage((Image)smallImage, smallWidth, smallHeight);
                    int marginLeft = 0;
                    int marginBottom = 3;
                    int x = marginLeft;
                    int y = bigHeight - marginBottom - smallHeight;
                    if (y < 0) {
                        y = 0;
                    }
                    g.drawImage(i, x, y, null);
                }
            }
            finally {
                g.dispose();
            }
        }
        catch (Throwable ex) {
            try {
                return SwingUtil.resizeImage(bigImage, bigWith, bigHeight);
            }
            catch (Throwable ex1) {
                return bigImage;
            }
        }
        return newImage;
    }

    private BufferedImage loadImage(String path) {
        try {
            File f1;
            if (path != null && path.length() > 0 && (f1 = new File(path)).exists() && f1.isFile()) {
                return ImageIO.read(f1);
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247\u5f02\u5e38! \u8def\u5f84\uff1a" + path + ", \u539f\u56e0:" + ex.getMessage()));
            return null;
        }
        return null;
    }

    @Override
    public void onRemove() {
        this.plateTextLabel.distory0();
        this.plateTextLabel.getLeftButton().removeActionListener(this);
        this.plateTextLabel.getRightButton().removeActionListener(this);
        if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (this.confirmDialog.isSelectedPanel(this)) {
            if (cmd == null) {
                return;
            }
            if (cmd.equals("plate_left")) {
                this.plateTextLabel.popDialog(true);
            } else if (cmd.equals("plate_right")) {
                this.plateTextLabel.popDialog(false);
            } else if (cmd.equals("cancelpass")) {
                this.doCancel();
            } else if (cmd.equals("okpass")) {
                this.doOK();
            } else if (cmd.startsWith("likePlate_")) {
                String plate = cmd.substring("likePlate_".length());
                if (this.plateTextLabel != null) {
                    this.plateTextLabel.setPlate(plate);
                }
                this.setPlateResult();
            } else if (cmd.equals("cartypeselect")) {
                if (!this.canactionCartype) {
                    return;
                }
                ComboBoxEntry cb = (ComboBoxEntry)((Object)this.carTypeSelect.getSelectedItem());
                CarparkCarType t = (CarparkCarType)cb.getKey();
                if (t != null) {
                    this.passSession.setCarType(t);
                    MainHostPassFilter.doLanRemoteModify(this.passSession, "carTypeNo", t.getCar_type_no());
                }
            }
        } else if (cmd != null && cmd.equals("cartypeselect")) {
            this.setCarType();
        }
    }

    private void doLikeSelect() {
        String x = this.plateTextLabel.getTextField().getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateTextLabel.getTextField().setText(v2);
            x = v2;
        }
        if (x != null && x.length() > 1) {
            this.plateQueryQueue0.offer(x);
            this.queryPlateResult0();
            if (x.length() >= 5) {
                this.setPlateResult();
            }
        } else if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
    }

    private void queryPlateResult0() {
        if (this.querying0.compareAndSet(false, true)) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block11: {
                        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                        List<String> likePlate = null;
                        try {
                            try {
                                String p;
                                String lastPlate = null;
                                while ((p = (String)PassEnterConfrmPanel.this.plateQueryQueue0.poll()) != null) {
                                    lastPlate = p;
                                }
                                if (lastPlate != null && lastPlate.length() > 0) {
                                    ChannelArea channelArea = (ChannelArea)PassEnterConfrmPanel.this.passSession.getAttribute("channelArea");
                                    boolean useOut = true;
                                    if (channelArea != null) {
                                        CarparkArea area;
                                        if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                                            useOut = false;
                                        } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty() && (area = channelArea.getEnterAreas().get(0)) != null && area.getArea_level() > 1) {
                                            useOut = false;
                                        }
                                    }
                                    likePlate = useOut ? recordSaveService.getEnterOutPlateList(lastPlate, PassEnterConfrmPanel.this.maxPlateLikeLen) : recordSaveService.getEnterInOrExitPalteList(lastPlate, PassEnterConfrmPanel.this.maxPlateLikeLen);
                                }
                            }
                            catch (Exception ex) {
                                GuiLog.getLog().error((Object)"", (Throwable)ex);
                                List<String> likePlate0 = likePlate;
                                SwingUtil.invokeLater(new Runnable(likePlate0){
                                    private final /* synthetic */ Collection val$likePlate0;
                                    {
                                        this.val$likePlate0 = collection;
                                    }

                                    @Override
                                    public void run() {
                                        PassEnterConfrmPanel.this.querying0.set(false);
                                        if (PassEnterConfrmPanel.this.plateQueryQueue0.peek() != null) {
                                            PassEnterConfrmPanel.this.queryPlateResult0();
                                        } else if (this.val$likePlate0 == null || this.val$likePlate0.isEmpty()) {
                                            if (PassEnterConfrmPanel.this.selectplatePopupMenu != null && PassEnterConfrmPanel.this.selectplatePopupMenu.isVisible()) {
                                                PassEnterConfrmPanel.this.selectplatePopupMenu.setVisible(false);
                                            }
                                        } else {
                                            int count = PassEnterConfrmPanel.this.selectplatePopupMenu.getComponentCount();
                                            int i = 0;
                                            while (i < count) {
                                                Component c = PassEnterConfrmPanel.this.selectplatePopupMenu.getComponent(i);
                                                if (c != null && c instanceof JMenuItem) {
                                                    ((JMenuItem)c).removeActionListener(PassEnterConfrmPanel.this);
                                                }
                                                ++i;
                                            }
                                            PassEnterConfrmPanel.this.selectplatePopupMenu.removeAll();
                                            PassEnterConfrmPanel.this.selectplatePopupMenu.setVisible(false);
                                            for (String s : this.val$likePlate0) {
                                                JMenuItem item = new JMenuItem(s);
                                                item.setPreferredSize(PassEnterConfrmPanel.this.popupMenuItemSize);
                                                item.setFont(PassEnterConfrmPanel.this.plateLikeFont);
                                                item.setActionCommand("likePlate_" + s);
                                                item.addActionListener(PassEnterConfrmPanel.this);
                                                PassEnterConfrmPanel.this.selectplatePopupMenu.add(item);
                                            }
                                            if (!PassEnterConfrmPanel.this.selectplatePopupMenu.isVisible()) {
                                                PassEnterConfrmPanel.this.selectplatePopupMenu.show(PassEnterConfrmPanel.this.plateTextLabel.getTextField(), 0, PassEnterConfrmPanel.this.plateTextLabel.getHeight() - 4);
                                                PassEnterConfrmPanel.this.plateTextLabel.getTextField().requestFocus();
                                            }
                                        }
                                    }
                                });
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            List<String> likePlate0 = likePlate;
                            SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        List<String> likePlate0 = likePlate;
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            });
        }
    }

    private void setPlateResult() {
        if (!this.confirmDialog.isSelectedPanel(this)) {
            return;
        }
        if (!this.passSession.isReadCard()) {
            String inputPlate = this.plateTextLabel.getPlate();
            if (inputPlate == null) {
                return;
            }
            if (inputPlate.length() >= 6 && inputPlate.length() <= 9) {
                this.reloadSessionByPlate(inputPlate);
            }
        }
    }

    private void reloadSessionByPlate(String plate) {
        if (plate == null || plate.length() == 0) {
            return;
        }
        String passPlate = this.passSession.getPassPlate();
        if (!plate.equals(passPlate)) {
            this.plateReloadQueue1.offer(plate);
            this.reloadSessionByPlate0();
        }
    }

    private void reloadSessionByPlate0() {
        if (this.plateReloading1.compareAndSet(false, true)) {
            this.okButton.setEnabled(false);
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block9: {
                        block8: {
                            try {
                                try {
                                    String passPlate;
                                    String p;
                                    String lastPlate = null;
                                    while ((p = (String)PassEnterConfrmPanel.this.plateReloadQueue1.poll()) != null) {
                                        lastPlate = p;
                                    }
                                    if (lastPlate == null || lastPlate.length() <= 0 || lastPlate.equals(passPlate = PassEnterConfrmPanel.this.passSession.getPassPlate())) break block8;
                                    PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent().setPlateNumber(lastPlate);
                                    PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent().setPassportMediumType(6);
                                    PassEnterConfrmPanel.this.passSession.getReadPassportNumberEvent().setPassportNumber(lastPlate);
                                    PassEnterConfrmPanel.this.passSession.setAttribute("GUI_CONFIRM", Boolean.TRUE);
                                    try {
                                        PassEnterConfrmPanel.this.passSession.getPassChannel().doStartSession(PassEnterConfrmPanel.this.passSession);
                                    }
                                    finally {
                                        PassEnterConfrmPanel.this.passSession.removeAttribute("GUI_CONFIRM");
                                    }
                                }
                                catch (Throwable ex) {
                                    GuiLog.getLog().error((Object)"", ex);
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            PassEnterConfrmPanel.this.plateReloading1.set(false);
                                            if (PassEnterConfrmPanel.this.plateReloadQueue1.peek() != null) {
                                                PassEnterConfrmPanel.this.reloadSessionByPlate0();
                                            } else {
                                                PassEnterConfrmPanel.this.okButton.setEnabled(true);
                                                PassEnterConfrmPanel.this.setInfo(PassEnterConfrmPanel.this.passSession);
                                                String passPlate = PassEnterConfrmPanel.this.passSession.getPassPlate();
                                                PassEnterConfrmPanel.this.mainConfirmEvent.setTitleName(passPlate);
                                                PassEnterConfrmPanel.this.confirmDialog.setSelectMunuName(PassEnterConfrmPanel.this.mainConfirmEvent);
                                            }
                                        }
                                    });
                                    break block9;
                                }
                            }
                            catch (Throwable throwable) {
                                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            });
        }
    }

    @Override
    public void onPressEnter() {
        this.doOK();
    }

    @Override
    public void onScanCodeFound(String scanCode) {
    }

    @Override
    public void refreshPanel() {
        if (this.confirmDialog.isSelectedPanel(this)) {
            this.setInfo(this.passSession);
        } else {
            this.doSelectRsetInfo = true;
        }
    }
}

