/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.RoundBorder;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.MainConfirmEvent;
import com.wovoe.carpark.gui.login.MainPassConfirmDialog;
import com.wovoe.carpark.gui.login.MainPassConfirmPanel;
import com.wovoe.carpark.gui.login.PlateInputPanel;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.MainHostPassFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.javacv.CaptureCallback;
import com.wovoe.javacv.OpencvFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PassExitConfirmPanel
extends JPanel
implements MainPassConfirmPanel,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 4029055115801832228L;
    private boolean inited = false;
    private PassSession passSession;
    private MainConfirmEvent mainConfirmEvent;
    private MainPassConfirmDialog confirmDialog;
    private JPanel panel1;
    private XYConstraints panel1Cons;
    private JLayeredPane panel1TopLayer;
    private JPanel enterPicPanel;
    private JLabel enterPicLabel;
    private Dimension enterPicSize;
    private JScrollPane enterPicSelectScrPane;
    private JPanel enterPicSelectPanel;
    private JLayeredPane panel1BottomLayer;
    private JPanel enterInfoPanel;
    private JLabel enterPlateLabel;
    private JLabel enterPlateLabelText;
    private JLabel enterChannelLabel;
    private JLabel enterChannelLabelText;
    private JLabel enterTimeLabel;
    private JLabel enterTimeLabelText;
    private JPanel certificatesPanel;
    private JLabel certificatesPicLabel;
    private Dimension certificatesPicSize;
    private volatile Component panel1TopSelectP = null;
    private volatile Component panel1BottomSelectP = null;
    private JPanel panel2;
    private XYConstraints panel2Cons;
    private JLabel exitPicLabel;
    private Dimension exitPicSize;
    private PlateInputPanel plateTextPanel;
    private JLabel exitChannelLabel;
    private JLabel exitChannelLabelText;
    private JLabel exitTimeLabel;
    private JLabel exitTimeLabelText;
    private JPanel panel3;
    private XYConstraints panel3Cons;
    private JLabel titleLabel;
    private JPanel panel4;
    private XYConstraints panel4Cons;
    private JLabel passportTypeLabel;
    private JLabel passportTypeText;
    private JLabel carTypeLabel;
    private JComboBox<ComboBoxEntry<CarparkCarType>> carTypeSelect;
    private volatile boolean canactionCartype = true;
    private JLabel discountLabel;
    private JPanel discountPanel;
    private Dimension discountPanelSize;
    private JLabel discountInfoLabel;
    private JComboBox<ComboBoxEntry<CarparkDiscountProject>> dicountPojSelect;
    private volatile boolean canactionDiscountpoj = true;
    private JLabel parkTimeLabel;
    private JLabel parkTimeText;
    private JLabel infoLabel1;
    private JLabel infoLabel2;
    private JLabel shouldChargeLabel;
    private JLabel shouldChargeText;
    private JLabel periodFreeLabel;
    private JLabel periodFreeText;
    private JLabel discontFreeLabel;
    private JLabel discontFreeText;
    private JLabel alreadyPayLabel;
    private JLabel alreadyPayText;
    private JLabel actualChargeLabel;
    private JLabel actualChargeText;
    private JLabel scanLabel;
    private JTextField scanTexts;
    private JPanel panel5;
    private XYConstraints panel5Cons;
    private JButton cancelButton;
    private JButton certCaptureButton;
    private JButton okButton;
    private ConcurrentLinkedQueue<String> plateQueryQueue0 = new ConcurrentLinkedQueue();
    private AtomicBoolean querying0 = new AtomicBoolean(false);
    private JPopupMenu selectplatePopupMenu;
    private Dimension popupMenuItemSize;
    private int maxPlateLikeLen = 5;
    private Font plateLikeFont;
    private ConcurrentLinkedQueue<String> plateReloadQueue1 = new ConcurrentLinkedQueue();
    private AtomicBoolean plateReloading1 = new AtomicBoolean(false);
    private AtomicBoolean doOkFinish = new AtomicBoolean(false);
    private WaitPayingDialog waitPayingDialog;
    private AtomicBoolean refreshingPaysuccess = new AtomicBoolean(false);
    private volatile boolean removed = false;
    private volatile boolean doSelectRsetInfo = false;
    private boolean curentShowingOtherPic = false;
    private Font fontCash;
    private Font fontCash1;
    private String defaultInputPlate;
    private int minPlateCharLength;

    @Override
    public Component getLayerComponent() {
        return this;
    }

    public String getDefaultInputPlate() {
        if (this.defaultInputPlate == null) {
            this.defaultInputPlate = ServiceUtil.getServiceContext().getDBConfigCache().getDefaultInputPlate();
            if (this.defaultInputPlate == null) {
                this.defaultInputPlate = "";
            }
        }
        return this.defaultInputPlate;
    }

    public int getMinPlateCharLength() {
        if (this.minPlateCharLength <= 0) {
            this.minPlateCharLength = ServiceUtil.getServiceContext().getDBConfigCache().getMinPlateCharLength();
            if (this.minPlateCharLength <= 0) {
                this.minPlateCharLength = 3;
            }
        }
        return this.minPlateCharLength;
    }

    public int getMaxPlateCharLength() {
        return 15;
    }

    public boolean isValidPlateLength(String plate) {
        if (plate != null && plate.equals(this.getDefaultInputPlate())) {
            plate = null;
        }
        return plate != null && plate.length() >= this.getMinPlateCharLength() && plate.length() <= this.getMaxPlateCharLength();
    }

    @Override
    public void disSelected() {
        OpencvFrame defaultInstance;
        if (this.plateTextPanel != null) {
            this.plateTextPanel.closeAllDialog();
        }
        if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
        if ((defaultInstance = OpencvFrame.getDefaultInstance((boolean)false)) != null && defaultInstance.getAttach() == this && defaultInstance.isVisible()) {
            defaultInstance.setVisible(false);
        }
    }

    @Override
    public void doSelect() {
        Cost cost;
        if (this.doSelectRsetInfo) {
            this.doSelectRsetInfo = false;
            if (this.passSession != null) {
                this.reSetInfo();
            }
        }
        boolean x1 = false;
        if (this.passSession != null && (cost = (Cost)this.passSession.getAttribute("pass_cost")) != null && cost.getCash().doubleValue() > 0.0 && this.scanTexts != null) {
            x1 = true;
        }
        if (!x1 && this.passSession != null && this.getEnterRecord() == null && this.plateTextPanel != null && this.plateTextPanel.getTextField() != null) {
            this.plateTextPanel.getTextField().requestFocus();
        }
    }

    @Override
    public void init(Dimension size, MainPassConfirmDialog dialog, MainConfirmEvent event, Color bodyBgColor) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.mainConfirmEvent = event;
        if (event != null && event.getAttachment() != null && event.getAttachment() instanceof PassSession) {
            this.passSession = (PassSession)event.getAttachment();
        }
        this.confirmDialog = dialog;
        this.setBackground(bodyBgColor);
        this.setLayout(new XYLayout());
        int borderWithx = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 1.0 / 768.0);
        int borderWith = 1;
        int margx = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getWidth() * 14.0 / 1280.0);
        int x = 0;
        int y = 0;
        int w = (size.width - margx) / 2;
        w = (w + margx + 2 * borderWithx) / 2;
        int h = size.height;
        this.panel1 = new JPanel();
        this.panel1.setBackground(this.getBackground());
        this.panel1.setLayout(new XYLayout());
        this.panel1.setBorder(BorderFactory.createMatteBorder(0, 0, 0, borderWith, Color.decode("#ECF0F5")));
        this.panel1Cons = new XYConstraints(x, y, w, h);
        this.add((Component)this.panel1, this.panel1Cons);
        this.initPanel1(new Dimension(this.panel1Cons.getWidth() - borderWith, this.panel1Cons.getHeight()));
        this.panel2 = new JPanel();
        this.panel2.setLayout(new XYLayout());
        this.panel2.setBackground(this.getBackground());
        this.panel2.setBorder(BorderFactory.createMatteBorder(0, 0, 0, borderWith, Color.decode("#ECF0F5")));
        this.panel2Cons = new XYConstraints(x += w, y, w, h);
        this.add((Component)this.panel2, this.panel2Cons);
        this.initPanel2(new Dimension(this.panel1Cons.getWidth() - borderWith, this.panel1Cons.getHeight()));
        this.panel3 = new JPanel();
        this.panel3.setLayout(new BorderLayout());
        this.panel3.setBackground(this.getBackground());
        int titleFontSize = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 20.0 / 768.0);
        Font titleFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, titleFontSize);
        boolean isManed = this.passSession != null && this.passSession.getReadPassportNumberEvent() != null && this.passSession.getReadPassportNumberEvent().isManualTrigger();
        Color titleColor1 = Color.decode("#c8fffc");
        this.titleLabel = new JLabel(isManed ? "\u51fa\u573a\u4eba\u5de5\u653e\u884c" : "\u51fa\u573a\u786e\u8ba4");
        this.titleLabel.setFont(titleFont);
        this.titleLabel.setForeground(titleColor1);
        this.titleLabel.setHorizontalAlignment(0);
        this.panel3.add((Component)this.titleLabel, "Center");
        x += w;
        int titileY = y = 2;
        h = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 40.0 / 768.0);
        w = size.width - (x += 5) - 5;
        int titleHeight = h;
        this.panel3Cons = new XYConstraints(x, y, w, h);
        this.add((Component)this.panel3, this.panel3Cons);
        this.panel5 = new JPanel();
        this.panel5.setBackground(this.getBackground());
        this.panel5.setLayout(new XYLayout());
        int rbheight = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 28.0 / 768.0);
        int rbmarginBottom = (int)Math.round(dialog.getCarparkMainFrame().getRootSize().getHeight() * 8.0 / 768.0);
        int panel5H = rbheight + 2 * rbmarginBottom;
        int panel5Y = size.height - panel5H - 1;
        int panel5X = x;
        int panel5W = w;
        this.panel5Cons = new XYConstraints(panel5X, panel5Y, panel5W, panel5H);
        this.add((Component)this.panel5, this.panel5Cons);
        this.initPanel5(new Dimension(panel5W, panel5H), rbheight);
        this.panel4 = new JPanel();
        this.panel4.setBackground(this.getBackground());
        this.panel4.setLayout(new XYLayout());
        int panel4X = x;
        int panel4Y = titileY + titleHeight;
        int panel4W = w;
        int panel4H = panel5Y - panel4Y;
        this.panel4Cons = new XYConstraints(panel4X, panel4Y, panel4W, panel4H);
        this.add((Component)this.panel4, this.panel4Cons);
        this.intPanel4(new Dimension(panel4W, panel4H));
        this.loadExitPic();
        this.reSetInfo();
    }

    private void reSetInfo() {
        this.setExitInfo();
        this.setEnterInfo();
        this.setCostInfo();
        this.setPassportInfo();
        this.setDiscountInfo();
        this.loadEnterPic();
        if (this.getEnterRecord() != null) {
            this.setPanel1TopSelectedComponent(this.enterPicPanel);
        } else {
            String plate = this.plateTextPanel.getPlate();
            if (this.isValidPlateLength(plate)) {
                this.loadSimilarPresenceRecord(plate);
            } else {
                this.setPanel1TopSelectedComponent(this.enterPicPanel);
            }
        }
    }

    private void setExitInfo() {
        try {
            PassSession session = this.passSession;
            String plate = session.getPassPlate();
            if (plate == null) {
                plate = "";
            }
            if (plate.startsWith("\u8bf7\u8f93\u5165\u8f66\u724c")) {
                this.plateTextPanel.setPlate(this.getDefaultInputPlate());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PassExitConfirmPanel.this.plateTextPanel.getTextField().requestFocus();
                    }
                });
            } else {
                String plate1 = this.plateTextPanel.getPlate();
                if (!plate.equals(plate1)) {
                    this.plateTextPanel.setPlate(plate);
                }
            }
            this.exitChannelLabelText.setText(session.getPassChannel().getChannel().getChannel_name());
            Date passTime = (Date)this.passSession.getAttribute("passTime");
            this.exitTimeLabelText.setText(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm:ss").format(passTime));
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private void intPanel4(Dimension size) {
        int costLeft;
        int halfWidth = size.width / 2;
        int fontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
        Font textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        int fontSize1f = (int)this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 11 / 768;
        Font textFont1 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize1f);
        Font textFont2 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0));
        Color titleColor = Color.decode("#F6F6F6");
        int rowSize = 6;
        int avgHeight = size.height / rowSize;
        int leftTileW = 3 * fontSize;
        int rightTitleW = 5 * fontSize;
        int marginLeft = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * 14.0 / 1280.0) - 5;
        int marginRight = 5;
        int x = marginLeft;
        int topY = 0;
        int topHeight = avgHeight;
        int leftTextWith = halfWidth - marginLeft - marginRight - leftTileW;
        int rightTextWidth = halfWidth - rightTitleW;
        this.shouldChargeLabel = new JLabel("\u5e94\u6536\u91d1\u989d:");
        this.shouldChargeText = new JLabel();
        this.periodFreeLabel = new JLabel("\u5468\u671f\u4f18\u60e0:");
        this.periodFreeText = new JLabel();
        this.discontFreeLabel = new JLabel("\u6298\u6263\u4f18\u60e0:");
        this.discontFreeText = new JLabel();
        this.alreadyPayLabel = new JLabel("\u5df2\u6536\u91d1\u989d:");
        this.alreadyPayText = new JLabel();
        this.actualChargeLabel = new JLabel("\u5b9e\u6536\u91d1\u989d:");
        this.actualChargeText = new JLabel();
        this.scanLabel = new JLabel("\u626b\u7801\u652f\u4ed8:");
        this.scanTexts = new JTextField();
        ArrayList<KeyValueEntry> list = new ArrayList<KeyValueEntry>(rowSize);
        list.add(new KeyValueEntry((Object)this.shouldChargeLabel, (Object)this.shouldChargeText));
        list.add(new KeyValueEntry((Object)this.periodFreeLabel, (Object)this.periodFreeText));
        list.add(new KeyValueEntry((Object)this.discontFreeLabel, (Object)this.discontFreeText));
        list.add(new KeyValueEntry((Object)this.alreadyPayLabel, (Object)this.alreadyPayText));
        list.add(new KeyValueEntry((Object)this.actualChargeLabel, (Object)this.actualChargeText));
        list.add(new KeyValueEntry((Object)this.scanLabel, (Object)this.scanTexts));
        int x1 = costLeft = halfWidth;
        int y1 = 0;
        int w1 = rightTitleW;
        int w2 = rightTextWidth;
        int h1 = avgHeight;
        for (KeyValueEntry e : list) {
            x1 = costLeft;
            ((JLabel)e.getKey()).setFont(textFont);
            ((JLabel)e.getKey()).setForeground(titleColor);
            this.panel4.add((Component)e.getKey(), new XYConstraints(x1, y1, w1, h1));
            x1 += w1;
            ((Component)e.getValue()).setFont(textFont);
            if (e.getValue() instanceof JLabel) {
                if (e.getValue() == this.actualChargeText) {
                    int arc = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 8.0 / 768.0);
                    Color rbBgColor = Color.decode("#fafafa");
                    Color moveOnBgColor = Color.decode("#e8e8e8");
                    RoundBorder border = new RoundBorder(this.panel4.getBackground(), arc);
                    CarparkMainFrame.RoundPanelButton rb1 = new CarparkMainFrame.RoundPanelButton(arc, arc);
                    rb1.setBorder(border);
                    rb1.setCmd("playCharge");
                    rb1.setBackground(rbBgColor);
                    Color rbfColor = Color.decode("#222222");
                    int rbFontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
                    rb1.getTextLabel().setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbFontSize));
                    rb1.getTextLabel().setForeground(rbfColor);
                    rb1.getTextLabel().setText("\u64ad\u62a5");
                    rb1.getTextLabel().setToolTipText("\u70b9\u51fb\u64ad\u62a5\u7f34\u8d39\u91d1\u989d");
                    rb1.getTextLabel().setCursor(new Cursor(12));
                    rb1.setMoveOutBgColor(rbBgColor);
                    rb1.setMoveOutFontColor(rbfColor);
                    rb1.setMoveOnBgColor(moveOnBgColor);
                    rb1.setMoveOnFontColor(Color.decode("#002550"));
                    rb1.getTextLabel().addMouseListener(this);
                    int rb1Width = (rb1.getTextLabel().getText().length() + 1) * rbFontSize;
                    int rb1Height = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 22.0 / 768.0);
                    if (rb1Height > h1 - 2) {
                        rb1Height = h1 - 2;
                    }
                    JPanel p1 = new JPanel();
                    p1.setBackground(this.panel4.getBackground());
                    p1.setLayout(new XYLayout());
                    p1.add((Component)rb1, new XYConstraints(1, 1, rb1Width, rb1Height));
                    int p1w = rb1Width + 2;
                    int p1h = rb1Height + 2;
                    int y11 = (h1 - p1h) / 2;
                    int p1y = y1 + y11;
                    int p1x = x1 + w2 - p1w;
                    this.panel4.add((Component)p1, new XYConstraints(p1x, p1y, p1w, p1h));
                    ((Component)e.getValue()).setForeground(Color.WHITE);
                    int xwt = p1x - x1 - 1;
                    this.panel4.add((Component)e.getValue(), new XYConstraints(x1, y1, xwt, h1));
                } else {
                    ((Component)e.getValue()).setForeground(Color.WHITE);
                    this.panel4.add((Component)e.getValue(), new XYConstraints(x1, y1, w2, h1));
                }
            } else {
                int vl = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 25.0 / 768.0);
                if (vl > h1) {
                    vl = h1;
                }
                int y11 = (h1 - vl) / 2;
                this.panel4.add((Component)e.getValue(), new XYConstraints(x1, y1 + y11, w2, vl));
            }
            y1 += h1;
        }
        int fontSize1 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 20.0 / 768.0);
        this.actualChargeText.setForeground(Color.decode("#C0FF80"));
        this.fontCash = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 1, fontSize1);
        int fontSize10 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
        this.fontCash1 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize10);
        this.actualChargeText.setFont(this.fontCash);
        this.passportTypeLabel = new JLabel("\u7c7b\u578b:");
        this.passportTypeLabel.setFont(textFont);
        this.passportTypeLabel.setForeground(titleColor);
        this.panel4.add((Component)this.passportTypeLabel, new XYConstraints(x, topY, leftTileW, topHeight));
        this.passportTypeText = new JLabel();
        this.passportTypeText.setFont(textFont);
        this.passportTypeText.setForeground(Color.WHITE);
        this.panel4.add((Component)this.passportTypeText, new XYConstraints(x += leftTileW, topY, leftTextWith, topHeight));
        x = marginLeft;
        this.carTypeLabel = new JLabel("\u8f66\u578b:");
        this.carTypeLabel.setFont(textFont);
        this.carTypeLabel.setForeground(titleColor);
        this.panel4.add((Component)this.carTypeLabel, new XYConstraints(x, topY += avgHeight, leftTileW, topHeight));
        x += leftTileW;
        Vector<ComboBoxEntry<CarparkCarType>> items = new Vector<ComboBoxEntry<CarparkCarType>>();
        Map<String, CarparkCarType> typeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (typeMap != null) {
            for (CarparkCarType t : typeMap.values()) {
                items.add(new ComboBoxEntry<CarparkCarType>(t, t.getCar_type_name()));
            }
        }
        this.carTypeSelect = new JComboBox(items);
        if (!items.isEmpty()) {
            this.carTypeSelect.setSelectedIndex(0);
        }
        this.carTypeSelect.setFont(textFont);
        this.carTypeSelect.setBackground(Color.WHITE);
        int vl = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 25.0 / 768.0);
        if (vl > topHeight) {
            vl = topHeight;
        }
        int y11 = (topHeight - vl) / 2;
        this.panel4.add(this.carTypeSelect, new XYConstraints(x, topY + y11, (int)((double)leftTextWith * 0.8), vl));
        this.carTypeSelect.setActionCommand("cartypeselect");
        this.carTypeSelect.addActionListener(this);
        x = marginLeft;
        this.parkTimeLabel = new JLabel("\u505c\u8f66:");
        this.parkTimeLabel.setFont(textFont);
        this.parkTimeLabel.setForeground(titleColor);
        this.panel4.add((Component)this.parkTimeLabel, new XYConstraints(x, topY += avgHeight, leftTileW, topHeight));
        this.parkTimeText = new JLabel();
        this.parkTimeText.setFont(textFont2);
        this.parkTimeText.setForeground(Color.WHITE);
        this.panel4.add((Component)this.parkTimeText, new XYConstraints(x += leftTileW, topY, leftTextWith, topHeight));
        x = marginLeft;
        this.discountLabel = new JLabel("\u6298\u6263:");
        this.discountLabel.setFont(textFont);
        this.discountLabel.setForeground(titleColor);
        this.panel4.add((Component)this.discountLabel, new XYConstraints(x, topY += avgHeight, leftTileW, topHeight));
        this.discountPanel = new JPanel();
        this.discountPanel.setLayout(new XYLayout());
        this.discountPanelSize = new Dimension(leftTextWith, vl);
        this.discountPanel.setBackground(this.panel4.getBackground());
        this.panel4.add((Component)this.discountPanel, new XYConstraints(x += leftTileW, topY + y11, this.discountPanelSize.width, this.discountPanelSize.height));
        x = marginLeft;
        int widx = halfWidth - marginLeft - marginRight;
        this.infoLabel1 = new JLabel();
        this.infoLabel1.setFont(textFont);
        this.infoLabel1.setForeground(Color.WHITE);
        this.panel4.add((Component)this.infoLabel1, new XYConstraints(x, topY += avgHeight, widx, topHeight));
        x = marginLeft;
        this.infoLabel2 = new JLabel();
        this.infoLabel2.setFont(textFont1);
        this.infoLabel2.setForeground(Color.decode("#FFD8E2"));
        this.panel4.add((Component)this.infoLabel2, new XYConstraints(x, topY += avgHeight, widx, topHeight));
        if (this.scanTexts != null) {
            int fontSize11 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 12.0 / 768.0);
            this.scanTexts.setFont(new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize11));
        }
    }

    private void initPanel5(Dimension size, int buttonHeight) {
        int rbgrap;
        int rbfontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 14.0 / 768.0);
        Font rbFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbfontSize);
        int rbWidth = rbfontSize * 6;
        int rbheight = buttonHeight;
        int rbY = (size.height - buttonHeight) / 2;
        int rbCount = 3;
        int rbX = rbgrap = (size.width - rbCount * rbWidth) / (rbCount + 1);
        this.cancelButton = new JButton("\u53d6\u6d88\u653e\u884c");
        this.cancelButton.setFont(rbFont);
        this.cancelButton.setCursor(new Cursor(12));
        this.cancelButton.setForeground(Color.decode("#D01A00"));
        this.cancelButton.setActionCommand("cancelpass");
        this.cancelButton.addActionListener(this);
        this.panel5.add((Component)this.cancelButton, new XYConstraints(rbX, rbY, rbWidth, rbheight));
        rbX += rbWidth + rbgrap;
        this.certCaptureButton = new JButton("\u8bc1\u4ef6\u6293\u62cd");
        this.certCaptureButton.setFont(rbFont);
        this.certCaptureButton.setCursor(new Cursor(12));
        this.certCaptureButton.setForeground(Color.decode("#002550"));
        this.certCaptureButton.setActionCommand("capturecet");
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == null || ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
            this.certCaptureButton.addActionListener(this);
            this.panel5.add((Component)this.certCaptureButton, new XYConstraints(rbX, rbY, rbWidth, rbheight));
        }
        rbX += rbgrap + rbWidth;
        this.okButton = new JButton("\u786e\u8ba4\u653e\u884c");
        this.okButton.setFont(rbFont);
        this.okButton.setCursor(new Cursor(12));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("okpass");
        this.okButton.addActionListener(this);
        this.panel5.add((Component)this.okButton, new XYConstraints(rbX, rbY, rbWidth, rbheight));
    }

    private void initPanel2(Dimension size) {
        JPanel exitInfoPanel = new JPanel();
        exitInfoPanel.setLayout(new XYLayout());
        exitInfoPanel.setBackground(this.panel2.getBackground());
        int fontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
        Font textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        int borderWith = 1;
        int w = size.width;
        int avgHeight = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 30.0 / 768.0);
        int marginLeft = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * 5.0 / 1280.0);
        int marginTopBottom = (avgHeight - fontSize) / 2;
        int textCount = 3;
        int infoHeight = avgHeight * textCount + marginTopBottom * 2;
        int y = size.height - infoHeight;
        int x = 0;
        XYConstraints exitInfoPanelCons = new XYConstraints(x, y, w, infoHeight);
        this.panel2.add((Component)exitInfoPanel, exitInfoPanelCons);
        Color titleColor = Color.decode("#F6F6F6");
        int lWidth = fontSize * 5;
        int lx = marginLeft;
        int ly = marginTopBottom;
        int lw = lWidth;
        int lh = avgHeight;
        int blockborderSize = (int)Math.floor(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 1.0 / 800.0);
        if (blockborderSize <= 0) {
            blockborderSize = 1;
        }
        Point dialogPoint = this.confirmDialog.getLocation();
        int plateInputWidth = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 44.0 / 768.0);
        Point platepanelPonit = new Point(dialogPoint.x + this.panel1Cons.getX() + this.panel1Cons.getWidth() + lx + 3, dialogPoint.y + (size.height - infoHeight - lh - plateInputWidth - 3));
        Point platepanelRightPonit = new Point(dialogPoint.x + this.panel1Cons.getX() + this.panel1Cons.getWidth() + lx + 3, dialogPoint.y + (size.height - infoHeight + ly + 3));
        int plateInputHeight = avgHeight;
        int platePanelWidth = size.width - 2 * lx;
        Dimension leftRightsize = new Dimension(plateInputWidth, plateInputHeight);
        Dimension plateTextsize = new Dimension(platePanelWidth - 2 * plateInputWidth, plateInputHeight);
        this.plateTextPanel = new PlateInputPanel(leftRightsize, plateTextsize, textFont, platepanelPonit, platepanelRightPonit, blockborderSize, new Runnable(){

            @Override
            public void run() {
                PassExitConfirmPanel.this.setPlateResult();
            }
        });
        exitInfoPanel.add((Component)this.plateTextPanel, new XYConstraints(lx, ly, platePanelWidth, lh));
        this.plateTextPanel.getLeftButton().setActionCommand("plate_left");
        this.plateTextPanel.getLeftButton().addActionListener(this);
        this.plateTextPanel.getRightButton().setActionCommand("plate_right");
        this.plateTextPanel.getRightButton().addActionListener(this);
        this.selectplatePopupMenu = new JPopupMenu();
        this.selectplatePopupMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#979797")));
        int itemFontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
        this.plateLikeFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, itemFontSize);
        int itemHeight = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 25.0 / 768.0);
        this.popupMenuItemSize = new Dimension(plateTextsize.width, itemHeight);
        this.plateTextPanel.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PassExitConfirmPanel.this.confirmDialog.isSelectedPanel(PassExitConfirmPanel.this)) {
                    PassExitConfirmPanel.this.setPlateResult();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.plateTextPanel.getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
                    if (PassExitConfirmPanel.this.selectplatePopupMenu != null && PassExitConfirmPanel.this.selectplatePopupMenu.isVisible()) {
                        PassExitConfirmPanel.this.selectplatePopupMenu.setVisible(false);
                    }
                } else if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && PassExitConfirmPanel.this.confirmDialog.isSelectedPanel(PassExitConfirmPanel.this)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PassExitConfirmPanel.this.doLikeSelect();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        lx = marginLeft;
        ly += avgHeight;
        lw = lWidth;
        this.exitChannelLabel = new JLabel();
        this.exitChannelLabel.setText("\u51fa\u573a\u901a\u9053:");
        this.exitChannelLabel.setForeground(titleColor);
        this.exitChannelLabel.setFont(textFont);
        exitInfoPanel.add((Component)this.exitChannelLabel, new XYConstraints(lx, ly, lw, lh));
        this.exitChannelLabelText = new JLabel("\u5357\u95e8\u5c97\u51fa\u53e3");
        this.exitChannelLabelText.setForeground(Color.WHITE);
        this.exitChannelLabelText.setFont(textFont);
        lx += lw;
        lw = exitInfoPanelCons.getWidth() - lx - marginLeft;
        exitInfoPanel.add((Component)this.exitChannelLabelText, new XYConstraints(lx, ly, lw, lh));
        lx = marginLeft;
        ly += avgHeight;
        lw = lWidth;
        this.exitTimeLabel = new JLabel();
        this.exitTimeLabel.setText("\u51fa\u573a\u65f6\u95f4:");
        this.exitTimeLabel.setForeground(titleColor);
        this.exitTimeLabel.setFont(textFont);
        exitInfoPanel.add((Component)this.exitTimeLabel, new XYConstraints(lx, ly, lw, lh));
        Font textFont2 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 14.0 / 768.0));
        this.exitTimeLabelText = new JLabel();
        this.exitTimeLabelText.setForeground(Color.WHITE);
        this.exitTimeLabelText.setFont(textFont2);
        lx += lw;
        lw = exitInfoPanelCons.getWidth() - lx - marginLeft;
        exitInfoPanel.add((Component)this.exitTimeLabelText, new XYConstraints(lx, ly, lw, lh));
        x = 0;
        y = 0;
        int h = size.height - infoHeight;
        JPanel exitPicPanel = new JPanel();
        exitPicPanel.setBorder(BorderFactory.createMatteBorder(0, 0, borderWith, 0, Color.decode("#ECF0F5")));
        exitPicPanel.setBackground(Color.WHITE);
        exitPicPanel.setLayout(new BorderLayout());
        this.exitPicLabel = new JLabel();
        exitPicPanel.add((Component)this.exitPicLabel, "Center");
        XYConstraints exitPicLabelCons = new XYConstraints(x, y, w, h);
        this.panel2.add((Component)exitPicPanel, exitPicLabelCons);
        this.exitPicSize = new Dimension(w, h - borderWith);
    }

    private boolean isReadCard() {
        return this.passSession != null && this.passSession.isReadCard();
    }

    private void initPanel1(Dimension size) {
        Font textFont000;
        String enx;
        int borderWith = 1;
        this.enterInfoPanel = new JPanel();
        this.enterInfoPanel.setLayout(new XYLayout());
        this.enterInfoPanel.setBackground(this.panel1.getBackground());
        int fontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
        Font textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        Font textFont2 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 14.0 / 768.0));
        int w = size.width;
        int avgHeight = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 30.0 / 768.0);
        int marginLeft = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * 5.0 / 1280.0);
        int marginTopBottom = (avgHeight - fontSize) / 2;
        int textCount = 3;
        int infoHeight = avgHeight * textCount + marginTopBottom * 2;
        int y = size.height - infoHeight;
        int x = 0;
        XYConstraints enterInfoPanelCons = new XYConstraints(x, y, w, infoHeight);
        this.enterInfoPanel.setBounds(0, 0, w, infoHeight);
        this.certificatesPanel = new JPanel();
        this.certificatesPanel.setBackground(Color.WHITE);
        this.certificatesPanel.setLayout(new BorderLayout());
        this.certificatesPicLabel = new JLabel();
        this.certificatesPanel.add((Component)this.certificatesPicLabel, "Center");
        this.certificatesPanel.setBounds(0, 0, w, infoHeight);
        this.certificatesPicSize = new Dimension(w, infoHeight);
        this.panel1BottomLayer = new JLayeredPane();
        this.panel1BottomLayer.setPreferredSize(new Dimension(w, infoHeight));
        JPanel blankPanel0 = new JPanel();
        blankPanel0.setBackground(Color.WHITE);
        blankPanel0.setBounds(0, 0, w, infoHeight);
        this.panel1BottomLayer.add((Component)blankPanel0, 0);
        this.panel1BottomLayer.add((Component)this.enterInfoPanel, 1);
        this.panel1BottomLayer.add((Component)this.certificatesPanel, 2);
        this.panel1.add((Component)this.panel1BottomLayer, enterInfoPanelCons);
        Color titleColor = Color.decode("#F6F6F6");
        int lWidth = fontSize * 5;
        int lx = marginLeft;
        int ly = marginTopBottom;
        int lw = lWidth;
        int lh = avgHeight;
        this.enterPlateLabel = new JLabel();
        Font textFont001 = textFont;
        if (this.isReadCard()) {
            int fontSize00;
            int z;
            String mediaNumber = this.passSession.getReadPassportNumberEvent().getDetectedPassEvent().getMediaNumber();
            if (mediaNumber.startsWith("WX_")) {
                enx = "\u5fae\u4fe1\u540d\u7247:";
                z = 10;
            } else if (mediaNumber.startsWith("AL_")) {
                enx = "\u652f\u4ed8\u5b9d\u540d\u7247:";
                z = 10;
                fontSize00 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 14.0 / 768.0);
                textFont001 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize00);
            } else {
                enx = "\u901a\u884c\u5361\u53f7:";
                z = 12;
            }
            fontSize00 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * (double)z / 768.0);
            textFont000 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize00);
        } else {
            enx = "\u5165\u573a\u8f66\u724c:";
            textFont000 = textFont;
        }
        this.enterPlateLabel.setText(enx);
        this.enterPlateLabel.setForeground(titleColor);
        this.enterPlateLabel.setFont(textFont001);
        this.enterInfoPanel.add((Component)this.enterPlateLabel, new XYConstraints(lx, ly, lw, lh));
        this.enterPlateLabelText = new JLabel();
        this.enterPlateLabelText.setForeground(Color.WHITE);
        this.enterPlateLabelText.setFont(textFont000);
        lx += lw;
        lw = enterInfoPanelCons.getWidth() - lx - marginLeft;
        this.enterInfoPanel.add((Component)this.enterPlateLabelText, new XYConstraints(lx, ly, lw, lh));
        lx = marginLeft;
        ly += avgHeight;
        lw = lWidth;
        this.enterChannelLabel = new JLabel();
        this.enterChannelLabel.setText("\u5165\u573a\u901a\u9053:");
        this.enterChannelLabel.setForeground(titleColor);
        this.enterChannelLabel.setFont(textFont);
        this.enterInfoPanel.add((Component)this.enterChannelLabel, new XYConstraints(lx, ly, lw, lh));
        this.enterChannelLabelText = new JLabel();
        this.enterChannelLabelText.setForeground(Color.WHITE);
        this.enterChannelLabelText.setFont(textFont);
        lx += lw;
        lw = enterInfoPanelCons.getWidth() - lx - marginLeft;
        this.enterInfoPanel.add((Component)this.enterChannelLabelText, new XYConstraints(lx, ly, lw, lh));
        lx = marginLeft;
        ly += avgHeight;
        lw = lWidth;
        this.enterTimeLabel = new JLabel();
        this.enterTimeLabel.setText("\u5165\u573a\u65f6\u95f4:");
        this.enterTimeLabel.setForeground(titleColor);
        this.enterTimeLabel.setFont(textFont);
        this.enterInfoPanel.add((Component)this.enterTimeLabel, new XYConstraints(lx, ly, lw, lh));
        this.enterTimeLabelText = new JLabel();
        this.enterTimeLabelText.setForeground(Color.WHITE);
        this.enterTimeLabelText.setFont(textFont2);
        lx += lw;
        lw = enterInfoPanelCons.getWidth() - lx - marginLeft;
        this.enterInfoPanel.add((Component)this.enterTimeLabelText, new XYConstraints(lx, ly, lw, lh));
        x = 0;
        y = 0;
        int h = size.height - infoHeight;
        this.enterPicPanel = new JPanel();
        this.enterPicPanel.setBorder(BorderFactory.createMatteBorder(0, 0, borderWith, 0, Color.decode("#ECF0F5")));
        this.enterPicPanel.setBackground(Color.WHITE);
        this.enterPicPanel.setLayout(new BorderLayout());
        this.enterPicLabel = new JLabel();
        this.enterPicPanel.add((Component)this.enterPicLabel, "Center");
        XYConstraints enterPicLabelCons = new XYConstraints(x, y, w, h);
        this.enterPicSize = new Dimension(w, h - borderWith);
        this.enterPicPanel.setBounds(0, 0, w, h);
        this.enterPicSelectPanel = new JPanel();
        this.enterPicSelectPanel.setLayout(new XYLayout());
        this.enterPicSelectScrPane = new JScrollPane(this.enterPicSelectPanel, 20, 31);
        this.enterPicSelectScrPane.getVerticalScrollBar().setUnitIncrement(40);
        this.enterPicSelectScrPane.setBackground(this.enterPicSelectPanel.getBackground());
        this.enterPicSelectScrPane.setBorder(BorderFactory.createMatteBorder(0, 0, borderWith, 0, Color.decode("#ECF0F5")));
        this.enterPicSelectScrPane.setBounds(0, 0, w, h);
        this.panel1TopLayer = new JLayeredPane();
        this.panel1TopLayer.setPreferredSize(new Dimension(w, h));
        blankPanel0 = new JPanel();
        blankPanel0.setBackground(Color.WHITE);
        blankPanel0.setBounds(0, 0, w, h);
        this.panel1TopLayer.add((Component)blankPanel0, 0);
        this.panel1TopLayer.add((Component)this.enterPicPanel, 1);
        this.panel1TopLayer.add((Component)this.enterPicSelectScrPane, 2);
        this.panel1.add((Component)this.panel1TopLayer, enterPicLabelCons);
        if (this.hasOtherPic()) {
            this.showOtherPic();
        } else {
            this.setPanel1BottomSelectedComponent(this.enterInfoPanel);
        }
        this.setPanel1TopSelectedComponent(this.enterPicPanel);
    }

    private void setPanel1TopSelectedComponent(Component c) {
        if (this.panel1TopSelectP != c) {
            if (this.panel1TopSelectP == this.enterPicSelectScrPane) {
                this.enterPicSelectPanel.removeAll();
                this.enterPicSelectPanel.setPreferredSize(new Dimension(this.enterPicSize.width, this.enterPicSize.height));
                this.enterPicSelectPanel.updateUI();
            }
            this.panel1TopLayer.moveToFront(c);
            this.panel1TopSelectP = c;
        }
    }

    private void setPanel1BottomSelectedComponent(Component c) {
        if (this.panel1BottomSelectP != c) {
            this.panel1BottomLayer.moveToFront(c);
            this.panel1BottomSelectP = c;
        }
    }

    private Image getNoPicImage0(Dimension picSize) {
        Image image = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("no_pic2");
        if (image != null) {
            if (picSize == null) {
                return image;
            }
            return SwingUtil.resizeImage(image, picSize.width, picSize.height);
        }
        return null;
    }

    private ImageIcon getNoPicImage(Dimension picSize) {
        Image image = this.getNoPicImage0(picSize);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    private void setEnterInfo() {
        if (this.hasOtherPic()) {
            this.showOtherPic();
        } else {
            CarparkPresenceRecord r = this.getEnterRecord();
            String enterPlate = null;
            String channelName = null;
            String enterTime = null;
            if (r != null) {
                enterPlate = r.getEnter_plate();
                channelName = r.getEnter_channel_name();
                if (r.getEnter_time() != null) {
                    enterTime = new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm:ss").format(r.getEnter_time());
                }
            }
            if (this.isReadCard()) {
                this.enterPlateLabelText.setText(this.passSession.getReadPassportNumberEvent().getDetectedPassEvent().getMediaNumber());
            } else {
                this.enterPlateLabelText.setText(enterPlate);
            }
            this.enterChannelLabelText.setText(channelName);
            this.enterTimeLabelText.setText(enterTime);
            this.setPanel1BottomSelectedComponent(this.enterInfoPanel);
        }
    }

    private void setCarTypeInfo() {
        try {
            this.canactionCartype = false;
            CarparkCarType carType = this.passSession.getCarType();
            if (carType != null) {
                int selectIndex = this.carTypeSelect.getSelectedIndex();
                int count = this.carTypeSelect.getItemCount();
                int needSelectIndex = selectIndex;
                int i = 0;
                while (i < count) {
                    ComboBoxEntry<CarparkCarType> t = this.carTypeSelect.getItemAt(i);
                    if (((CarparkCarType)t.getKey()).getCar_type_no().equals(carType.getCar_type_no())) {
                        needSelectIndex = i;
                        break;
                    }
                    ++i;
                }
                if (needSelectIndex != selectIndex) {
                    this.carTypeSelect.setSelectedIndex(needSelectIndex);
                }
            }
        }
        finally {
            this.canactionCartype = true;
        }
    }

    private void setPassportInfo() {
        try {
            if (this.passSession.getPassportType() != null) {
                this.passportTypeText.setText(this.passSession.getPassportType().getPassport_type_name());
            } else {
                this.passportTypeText.setText("");
            }
            this.setCarTypeInfo();
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            CarparkPresenceRecord enterRecord = this.getEnterRecord();
            Date passTime = (Date)this.passSession.getAttribute("passTime");
            Integer parkTimeLenSec = null;
            if (enterRecord != null && enterRecord.getEnter_time() != null) {
                parkTimeLenSec = (int)TimeUnit.MILLISECONDS.toSeconds(passTime.getTime() - enterRecord.getEnter_time().getTime());
            }
            if (parkTimeLenSec != null) {
                this.parkTimeText.setText(appService.getTimeLenSecDes(parkTimeLenSec));
            } else {
                this.parkTimeText.setText(null);
            }
            String plate = this.passSession.getPassPlate();
            if (plate == null) {
                plate = "";
            }
            Color clor = Color.decode("#FFD8E2");
            this.infoLabel2.setForeground(clor);
            if (plate.startsWith("\u8bf7\u8f93\u5165\u8f66\u724c")) {
                this.infoLabel1.setText(null);
                this.infoLabel2.setText("\u8bf7\u8f93\u5165\u653e\u884c\u8f66\u724c!");
                this.infoLabel1.setToolTipText(null);
                this.infoLabel2.setToolTipText(null);
            } else {
                String platex;
                String key_MonthlyFreeDurationInfo;
                Map infoMap;
                CarparkPresenceRecord takeChargeRecord;
                CarparkArea exitArea;
                String v1;
                CarparkPassRecord lastEntryRecord;
                String msg;
                HashSet<Integer> exceptionSet = new HashSet<Integer>();
                if (this.passSession.getAllowPassExcetpions() != null) {
                    exceptionSet.addAll(this.passSession.getAllowPassExcetpions());
                }
                if (this.passSession.getConfirmPassExceptions() != null) {
                    exceptionSet.addAll(this.passSession.getConfirmPassExceptions());
                }
                if (this.passSession.getForbidPassExceptions() != null) {
                    exceptionSet.addAll(this.passSession.getForbidPassExceptions());
                }
                String text1 = null;
                Object totip1 = null;
                String text2 = null;
                Object totip2 = null;
                if (enterRecord == null) {
                    text2 = "\u8f66\u672a\u5165\u573a";
                }
                if (exceptionSet.contains(1)) {
                    text2 = text2 != null && text2.length() > 0 ? String.valueOf(text2) + "\u3001\u7981\u6b62\u79bb\u573a" : "\u7981\u6b62\u79bb\u573a";
                }
                if (exceptionSet.contains(6)) {
                    text2 = text2 != null && text2.length() > 0 ? String.valueOf(text2) + "\u3001\u9ed1\u540d\u5355\u8f66" : "\u9ed1\u540d\u5355\u8f66";
                }
                if (exceptionSet.contains(100) && (msg = (String)this.passSession.getAttribute("PASS_EXCEPTION_NO_PERMISSSION100_MSG")) != null && msg.length() > 0) {
                    text2 = text2 != null && text2.length() > 0 ? String.valueOf(text2) + "\u3001" + msg : msg;
                }
                if (exceptionSet.contains(9) && (lastEntryRecord = (CarparkPassRecord)this.passSession.getAttribute("NO_ENTRY_MARCH_RECORD")) != null && lastEntryRecord.getExit_time() != null) {
                    if (text2 != null && text2.length() > 0) {
                        text2 = String.valueOf(text2) + "\u3001";
                    }
                    text2 = "\u5df2\u5728" + new SimpleDateFormat("M\u6708d H:m").format(lastEntryRecord.getExit_time()) + "\u79bb\u573a";
                    BigDecimal lastPaid = Constants.MONEY_ZERO;
                    if (lastEntryRecord.getAlready_paid() != null && lastEntryRecord.getAlready_paid().doubleValue() > 0.0) {
                        lastPaid = lastPaid.add(lastEntryRecord.getAlready_paid());
                    }
                    if (lastEntryRecord.getCash_pay() != null && lastEntryRecord.getCash_pay().doubleValue() > 0.0) {
                        lastPaid = lastPaid.add(lastEntryRecord.getCash_pay());
                    }
                    if (lastEntryRecord.getDeduct_money() != null && lastEntryRecord.getDeduct_money().doubleValue() > 0.0) {
                        lastPaid = lastPaid.add(lastEntryRecord.getDeduct_money());
                    }
                    lastPaid.setScale(2, 4);
                    if (lastPaid.doubleValue() > 0.0) {
                        String m = (double)lastPaid.intValue() == lastPaid.doubleValue() ? String.valueOf(lastPaid.intValue()) : lastPaid.toString();
                        text2 = String.valueOf(text2) + "\u5df2\u4ed8" + m + "\u5143";
                    }
                }
                CarparkPassportType bindPassType = this.passSession.getDatabasePassportType();
                if (exceptionSet.contains(7)) {
                    if (bindPassType != null) {
                        text1 = String.valueOf(bindPassType.getPassport_type_name()) + " \u672a\u542f\u7528!";
                        if (this.passSession.getPassport() != null && this.passSession.getPassport().getStart_date() != null) {
                            v1 = "\u542f\u7528\u65e5\u671f:" + new SimpleDateFormat("yyyy-MM-dd").format(this.passSession.getPassport().getStart_date());
                            if (text2 == null) {
                                text2 = v1;
                            } else {
                                totip1 = v1;
                            }
                        }
                    }
                } else if (exceptionSet.contains(8)) {
                    if (bindPassType != null) {
                        text1 = String.valueOf(bindPassType.getPassport_type_name()) + " \u5df2\u505c\u7528!";
                        if (this.passSession.getPassport() != null && this.passSession.getPassport().getStop_date() != null) {
                            v1 = "\u505c\u7528\u65e5\u671f:" + new SimpleDateFormat("yyyy-MM-dd").format(this.passSession.getPassport().getStop_date());
                            if (text2 == null) {
                                text2 = v1;
                            } else {
                                totip1 = v1;
                            }
                        }
                    }
                } else if (this.passSession.getPassportType().getPass_type() == 2) {
                    if (this.passSession.getPassport().getDeadline() != null) {
                        text1 = "\u671f\u9650\uff1a" + new SimpleDateFormat("yyyy-MM-dd").format(this.passSession.getPassport().getDeadline());
                        if (exceptionSet.contains(4)) {
                            text1 = String.valueOf(text1) + " \u5df2\u8fc7\u671f";
                        }
                    }
                } else if (this.passSession.getPassportType().getPass_type() == 1 && this.passSession.getPassport().getBalance() != null) {
                    NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                    text1 = "\u4f59\u989d\uff1a" + sf.format(this.passSession.getPassport().getBalance());
                    Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
                    if (cost != null && cost.getCash().doubleValue() > 0.0) {
                        text1 = String.valueOf(text1) + " \u4e0d\u8db3\u6263\u8d39";
                    }
                }
                if ((text1 == null || text2 == null) && (exitArea = (CarparkArea)this.passSession.getAttribute("PASS_EXIT_AREA")) != null && exitArea.getArea_level() == 1 && (takeChargeRecord = (CarparkPresenceRecord)this.passSession.getAttribute("takeChargeRecord")) != null && takeChargeRecord.getEnter_time() != null) {
                    Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
                    int tp = cost.getChargeTimeMinutes() > 0 ? cost.getChargeTimeMinutes() : ServiceUtil.getMins(takeChargeRecord.getEnter_time(), passTime);
                    if (text1 == null && text2 == null) {
                        text1 = "\u5360\u7528\u4e34\u505c\u8f66\u4f4d:" + appService.getTimeLenDes(tp);
                        totip1 = "\u5f53\u8f66\u724c:" + takeChargeRecord.getEnter_plate() + "\u5165\u573a\u65f6\u5f00\u59cb\u5360\u7528\u4e34\u505c\u8f66\u4f4d!\u5e76\u4e14\u5f00\u59cb\u8ba1\u4e34\u505c\u8d39\u3002";
                        text2 = "\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:" + new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm:ss").format(takeChargeRecord.getEnter_time());
                        totip2 = "\u8be5\u65f6\u95f4\u4e3a" + takeChargeRecord.getEnter_plate() + "\u5165\u573a\u65f6\u95f4\uff0c\u5f00\u59cb\u5360\u7528\u4e34\u505c\u8f66\u4f4d\u65f6\u95f4";
                    } else {
                        String v12 = "\u5360\u7528\u4e34\u505c\u8f66\u4f4d:" + appService.getTimeLenDes(tp);
                        String t1 = "\u5f53\u8f66\u724c:" + takeChargeRecord.getEnter_plate() + "\u5165\u573a\u65f6\u5f00\u59cb\u5360\u7528\u4e34\u505c\u8f66\u4f4d!<br>\u5e76\u4e14\u5f00\u59cb\u8ba1\u4e34\u505c\u8d39\u3002\u8ba1\u8d39\u5f00\u59cb\u65f6\u95f4:" + new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm:ss").format(takeChargeRecord.getEnter_time());
                        if (text1 == null) {
                            text1 = v12;
                            totip1 = t1;
                        } else if (text2 == null) {
                            text2 = v12;
                            totip2 = t1;
                        }
                    }
                }
                if ((text1 == null || text2 == null) && this.passSession.getCarOwner() != null) {
                    CarparkPassportType t;
                    if (enterRecord != null && enterRecord.getOccupy_plate() != null && enterRecord.getOccupy_plate().length() > 0 && enterRecord.getOccupy_passport_type_no() != null && enterRecord.getOccupy_passport_type_no().length() > 0 && !enterRecord.getOccupy_passport_type_no().equals(this.passSession.getPassportType().getPassport_type_no()) && enterRecord.getOccupy_end_time() != null && (t = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(enterRecord.getOccupy_passport_type_no())) != null) {
                        int tp = (int)TimeUnit.MILLISECONDS.toSeconds(enterRecord.getOccupy_end_time().getTime() - enterRecord.getEnter_time().getTime());
                        String dsc = appService.getTimeLenSecDes(tp);
                        text2 = t.getPass_type() == 0 ? "\u5360\u7528\u4e34\u505c\u8f66\u4f4d: " + dsc : String.valueOf(t.getPassport_type_name()) + ": " + dsc;
                        totip2 = "";
                        if (!enterRecord.getOccupy_plate().equals(this.passSession.getPassPlate())) {
                            totip2 = String.valueOf(totip2) + "\u672c\u8f66\u5165\u573a\u65f6\u5df2\u5360\u7528\u8f66\u4f4d\u8f66\u724c: " + enterRecord.getOccupy_plate() + "<br>";
                        }
                        totip2 = String.valueOf(totip2) + (t.getPass_type() == 0 ? "\u672c\u8f66\u5360\u7528\u4e34\u505c\u8f66\u4f4d\u5f00\u59cb: " : "\u672c\u8f66\u4e3a" + t.getPassport_type_name() + "\u5f00\u59cb\uff1a") + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(enterRecord.getEnter_time()) + "<br>";
                        totip2 = String.valueOf(totip2) + (t.getPass_type() == 0 ? "\u672c\u8f66\u5360\u7528\u4e34\u505c\u8f66\u4f4d\u7ed3\u675f: " : "\u672c\u8f66\u4e3a" + t.getPassport_type_name() + "\u7ed3\u675f\uff1a") + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(enterRecord.getOccupy_end_time().getTime()) + "<br>";
                        totip2 = String.valueOf(totip2) + (t.getPass_type() == 0 ? "\u672c\u8f66\u5360\u7528\u4e34\u505c\u8f66\u4f4d\u65f6\u957f: " : "\u672c\u8f66\u4e3a" + t.getPassport_type_name() + "\u65f6\u957f\uff1a") + dsc;
                    }
                    if (text2 == null) {
                        v1 = this.passSession.getCarOwner().getCar_owner_name();
                        v1 = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue("car_owner_name", v1);
                        if (text1 == null) {
                            text1 = "\u8f66\u4e3b\uff1a" + v1;
                        } else if (text2 == null) {
                            text2 = "\u8f66\u4e3b\uff1a" + v1;
                            this.infoLabel2.setForeground(Color.WHITE);
                        }
                    }
                }
                this.infoLabel1.setText(text1);
                if (totip1 != null && ((String)totip1).length() > 0) {
                    this.infoLabel1.setToolTipText("<html>" + (String)totip1 + "</html>");
                } else {
                    this.infoLabel1.setToolTipText(null);
                }
                Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
                if (cost != null && cost.getAreaChargeLenList() != null && !cost.getAreaChargeLenList().isEmpty() && ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().size() > 1) {
                    String bx1 = "";
                    String bx2 = "";
                    for (Map<String, String> m : cost.getAreaChargeLenList()) {
                        String areaName = m.get("areaName");
                        try {
                            String bx = String.valueOf(areaName) + ": " + appService.getTimeLenDes(Integer.parseInt(m.get("parkLen")));
                            if (bx1.length() > 0) {
                                bx1 = String.valueOf(bx1) + ", ";
                            }
                            bx1 = String.valueOf(bx1) + bx;
                            if (bx2.length() > 0) {
                                bx2 = String.valueOf(bx2) + "<br>";
                            }
                            bx2 = String.valueOf(bx2) + bx;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bx2.length() > 0) {
                        if (cost.getCharge_start_time() != null) {
                            bx2 = "\u8ba1\u8d39\u5f00\u59cb\uff1a" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(cost.getCharge_start_time()) + "<br>" + bx2;
                        }
                        totip2 = totip2 == null || ((String)totip2).length() == 0 ? bx2 : String.valueOf(totip2) + "<br>" + bx2;
                    }
                    if (bx1.length() > 0) {
                        text2 = text2 == null || text2.length() == 0 ? bx1 : String.valueOf(text2) + ", " + bx1;
                    }
                }
                if ((infoMap = (Map)this.passSession.getAttribute(key_MonthlyFreeDurationInfo = "MonthlyFreeDurationInfo")) != null && (platex = (String)infoMap.get("monthlyFreeDurationPlateNo")) != null && platex.length() > 0 && platex.equals(this.passSession.getPassPlate())) {
                    String guiDisplayMonthDuration = (String)infoMap.get("guiDisplayMonthDuration");
                    String guiTipMonthDuration = (String)infoMap.get("guiTipMonthDuration");
                    if (guiDisplayMonthDuration != null && guiDisplayMonthDuration.length() > 0) {
                        text2 = text2 == null || text2.length() == 0 ? guiDisplayMonthDuration : String.valueOf(guiDisplayMonthDuration) + ", " + text2;
                    }
                    if (guiTipMonthDuration != null && guiTipMonthDuration.length() > 0) {
                        String[] ax;
                        String[] stringArray = ax = guiTipMonthDuration.split(";");
                        int n = ax.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String a = stringArray[n2];
                            if (a != null && a.length() > 0) {
                                totip2 = totip2 != null && ((String)totip2).length() > 0 ? String.valueOf(totip2) + "<br>" + a : a;
                            }
                            ++n2;
                        }
                    }
                }
                this.infoLabel2.setText(text2);
                if (totip2 != null && ((String)totip2).length() > 0) {
                    this.infoLabel2.setToolTipText("<html>" + (String)totip2 + "</html>");
                } else {
                    this.infoLabel2.setToolTipText(null);
                }
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setDiscountInfo() {
        try {
            try {
                Object textFont;
                List<CarparkPassDiscount> discountList;
                this.canactionDiscountpoj = false;
                LinkedList enterDicountList = null;
                CarparkPassDiscount selectDiscount = null;
                Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
                if (cost != null && (discountList = cost.getDiscountList()) != null && !discountList.isEmpty()) {
                    for (CarparkPassDiscount d : discountList) {
                        if (d.getId() == null) {
                            selectDiscount = d;
                            continue;
                        }
                        if (enterDicountList != null) continue;
                        enterDicountList = new LinkedList();
                    }
                }
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                String textValue = null;
                StringBuilder textTooltip = new StringBuilder();
                CarparkDiscountProject selectedProject = null;
                Vector<ComboBoxEntry<CarparkDiscountProject>> projectSelectList = null;
                if (enterDicountList != null && !enterDicountList.isEmpty()) {
                    int size = enterDicountList.size();
                    if (selectDiscount != null && "certificates_free".equals(selectDiscount.getDiscount_project_no())) {
                        textValue = selectDiscount.getDiscount_project_name();
                        textTooltip.append(selectDiscount.getDiscount_project_name());
                        if (selectDiscount.getDiscount_method() != null && selectDiscount.getDiscount_value() != null) {
                            textTooltip.append(':').append(appService.getDiscountValueDes(selectDiscount.getDiscount_method(), selectDiscount.getDiscount_value()));
                        }
                        ++size;
                    } else {
                        textValue = ((CarparkPassDiscount)enterDicountList.get(0)).getDiscount_project_name();
                    }
                    if (size > 1 && textValue != null) {
                        textValue = String.valueOf(textValue) + " ...";
                    }
                    for (CarparkPassDiscount d : enterDicountList) {
                        if (selectDiscount.getDiscount_method() == null || selectDiscount.getDiscount_value() == null) continue;
                        if (textTooltip.length() > 0) {
                            textTooltip.append("<br>");
                        }
                        textTooltip.append(d.getDiscount_project_name());
                        textTooltip.append(':').append(appService.getDiscountValueDes(d.getDiscount_method(), d.getDiscount_value()));
                    }
                } else {
                    projectSelectList = new Vector<ComboBoxEntry<CarparkDiscountProject>>();
                    CarparkDiscountProject p = new CarparkDiscountProject();
                    p.setId(-1L);
                    p.setDiscount_method(0);
                    p.setDiscount_project_name("\u4e0d\u6253\u6298");
                    p.setDiscount_value(0);
                    p.setDiscount_project_no("");
                    projectSelectList.add(new ComboBoxEntry<CarparkDiscountProject>(p, p.getDiscount_project_name()));
                    selectedProject = p;
                    Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
                    if (dmap != null && !dmap.isEmpty()) {
                        for (CarparkDiscountProject dp : dmap.values()) {
                            if (dp.getDiscount_method() == 3 || dp.getUse_type() == 2) continue;
                            projectSelectList.add(new ComboBoxEntry<CarparkDiscountProject>(dp, dp.getDiscount_project_name()));
                            if (selectDiscount == null || selectDiscount.getDiscount_project_no() == null || !selectDiscount.getDiscount_project_no().equals(dp.getDiscount_project_no())) continue;
                            selectedProject = dp;
                        }
                    }
                    if (selectDiscount != null && "certificates_free".equals(selectDiscount.getDiscount_project_no())) {
                        p = new CarparkDiscountProject();
                        p.setId(0L);
                        p.setDiscount_method(2);
                        p.setDiscount_project_name("\u8bc1\u4ef6\u6293\u62cd\u514d\u8d39");
                        p.setDiscount_value(100);
                        p.setDiscount_project_no("certificates_free");
                        p.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                        p.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                        p.setCreated_time(new Date());
                        p.setLast_updated_time(p.getCreated_time());
                        projectSelectList.add(new ComboBoxEntry<CarparkDiscountProject>(p, p.getDiscount_project_name()));
                        selectedProject = p;
                    }
                }
                boolean showSelectList = false;
                boolean showLabelString = false;
                int count = this.discountPanel.getComponentCount();
                if (count > 0) {
                    void var12_19;
                    boolean bl = false;
                    while (var12_19 < count) {
                        Component c = this.discountPanel.getComponent((int)var12_19);
                        if (c != null) {
                            if (this.discountInfoLabel != null && c == this.discountInfoLabel) {
                                showLabelString = true;
                            }
                            if (this.dicountPojSelect != null && c == this.dicountPojSelect) {
                                showSelectList = true;
                            }
                        }
                        ++var12_19;
                    }
                }
                if (projectSelectList != null && selectedProject != null) {
                    if (this.dicountPojSelect == null) {
                        this.dicountPojSelect = new JComboBox(projectSelectList);
                        this.dicountPojSelect.setActionCommand("selectDiscountPoject");
                        this.dicountPojSelect.addActionListener(this);
                        int n = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
                        textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, n);
                        this.dicountPojSelect.setFont((Font)textFont);
                        this.dicountPojSelect.setBackground(Color.WHITE);
                        if (projectSelectList != null && !projectSelectList.isEmpty()) {
                            this.dicountPojSelect.setSelectedIndex(0);
                        }
                    } else {
                        this.dicountPojSelect.removeAllItems();
                        for (ComboBoxEntry comboBoxEntry : projectSelectList) {
                            this.dicountPojSelect.addItem(comboBoxEntry);
                        }
                        if (projectSelectList != null && !projectSelectList.isEmpty()) {
                            this.dicountPojSelect.setSelectedIndex(0);
                        }
                    }
                    int n = this.dicountPojSelect.getSelectedIndex();
                    count = this.dicountPojSelect.getItemCount();
                    int needSelectIndex = n;
                    int i = 0;
                    while (i < count) {
                        ComboBoxEntry<CarparkDiscountProject> t = this.dicountPojSelect.getItemAt(i);
                        if (((CarparkDiscountProject)t.getKey()).getDiscount_project_no().equals(selectedProject.getDiscount_project_no())) {
                            needSelectIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (needSelectIndex != n) {
                        this.dicountPojSelect.setSelectedIndex(needSelectIndex);
                    }
                    if (!showSelectList) {
                        this.discountPanel.removeAll();
                        this.discountPanel.add(this.dicountPojSelect, new XYConstraints(0, 0, (int)((double)this.discountPanelSize.width * 0.8), this.discountPanelSize.height));
                        if (showLabelString) {
                            this.discountPanel.updateUI();
                        }
                    }
                } else {
                    if (this.discountInfoLabel == null) {
                        this.discountInfoLabel = new JLabel();
                        int n = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 16.0 / 768.0);
                        textFont = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, n);
                        this.discountInfoLabel.setFont((Font)textFont);
                        this.discountInfoLabel.setForeground(Color.WHITE);
                    }
                    this.discountInfoLabel.setText(textValue);
                    this.discountInfoLabel.setToolTipText(textTooltip.toString());
                    if (!showLabelString) {
                        this.discountPanel.removeAll();
                        this.discountPanel.add((Component)this.discountInfoLabel, new XYConstraints(0, 0, this.discountPanelSize.width, this.discountPanelSize.height));
                        if (showSelectList) {
                            this.discountPanel.updateUI();
                        }
                    }
                }
            }
            catch (Exception ex) {
                GuiLog.getLog().warn((Object)"", (Throwable)ex);
                this.canactionDiscountpoj = true;
            }
        }
        finally {
            this.canactionDiscountpoj = true;
        }
    }

    private CarparkPresenceRecord getEnterRecord() {
        CarparkArea exitArea = (CarparkArea)this.passSession.getAttribute("PASS_EXIT_AREA");
        Map areaPresenceRecordMap = (Map)this.passSession.getAttribute("areaPresenceRecordMap");
        CarparkPresenceRecord enterRecord = null;
        if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && exitArea != null) {
            enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
        }
        return enterRecord;
    }

    private void setCostInfo() {
        try {
            Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
            if (cost == null) {
                cost = new Cost();
            }
            this.shouldChargeText.setText(cost.getShouldCharged().toString());
            this.discontFreeText.setText("-" + cost.getDiscountMoney());
            BigDecimal d = cost.getAlready_paid();
            String vd = "-" + d.toString();
            String totip = "";
            if (d.doubleValue() > 0.0 && cost.getAlready_paid_method() != null) {
                String va;
                String v1 = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(cost.getAlready_paid_method());
                if (v1 != null && v1.length() > 0) {
                    vd = String.valueOf(vd) + " " + v1;
                }
                if (cost.getAlready_paid_scene() != null && (va = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(cost.getAlready_paid_scene())) != null && va.length() > 0) {
                    totip = String.valueOf(totip) + va;
                }
                if (cost.getAlready_paid_time() != null) {
                    if (totip.length() > 0) {
                        totip = String.valueOf(totip) + " ";
                    }
                    totip = String.valueOf(totip) + "\u652f\u4ed8\u65f6\u95f4:" + new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm").format(cost.getAlready_paid_time());
                }
            }
            this.alreadyPayText.setText(vd);
            if (totip.length() == 0) {
                totip = null;
            }
            this.alreadyPayText.setToolTipText(totip);
            if (cost.getDeduct_money().doubleValue() > 0.0) {
                this.actualChargeLabel.setText("\u6263\u8d39\u91d1\u989d:");
                this.actualChargeText.setText(cost.getDeduct_money().toString());
            } else {
                this.actualChargeLabel.setText("\u5b9e\u6536\u91d1\u989d:");
                if (cost.getArrears().doubleValue() > 0.0) {
                    if (this.fontCash1 != null && this.fontCash1 != this.actualChargeText.getFont()) {
                        this.actualChargeText.setFont(this.fontCash1);
                    }
                    this.actualChargeText.setText(String.valueOf(this.getDiplsyMoney(cost.getCash())) + ",\u6b20\u8d39:" + this.getDiplsyMoney(cost.getArrears()));
                } else {
                    if (this.fontCash != null && this.fontCash != this.actualChargeText.getFont()) {
                        this.actualChargeText.setFont(this.fontCash);
                    }
                    this.actualChargeText.setText(cost.getCash().toString());
                }
            }
            if (cost.getPeriod_multi_start() != null) {
                BigDecimal v = cost.getPeriod_multi_free();
                String x = "-";
                x = v.doubleValue() == (double)v.intValue() ? String.valueOf(x) + v.intValue() : String.valueOf(x) + v;
                x = String.valueOf(x) + " \u5df2\u6536:";
                v = cost.getPeriod_multi_received();
                x = v.doubleValue() == (double)v.intValue() ? String.valueOf(x) + v.intValue() : String.valueOf(x) + v;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                StringBuilder toolTipBuilder = new StringBuilder(64);
                toolTipBuilder.append("<html>");
                toolTipBuilder.append("\u5468\u671f\u5f00\u59cb:").append(df.format(cost.getPeriod_multi_start()));
                toolTipBuilder.append("<br>").append("\u5468\u671f\u5df2\u6536:").append(cost.getPeriod_multi_received());
                if (cost.getNext_period_multi_start() != null && cost.getNext_period_multi_start().getTime() != cost.getPeriod_multi_start().getTime() && cost.getNext_period_multi_cur() != null && cost.getNext_period_multi_cur().doubleValue() > 0.0) {
                    toolTipBuilder.append("<br>").append("\u672c\u6b21\u505c\u8f66\u8de8\u5468\u671f");
                    toolTipBuilder.append("<br>").append("\u65b0\u5468\u671f\u5f00\u59cb:").append(df.format(cost.getPeriod_multi_start()));
                    toolTipBuilder.append("<br>").append("\u672c\u6b21\u7f34\u8d39\u540e\u65b0\u5468\u671f\u7d2f\u8ba1").append(cost.getNext_period_multi_cur());
                }
                toolTipBuilder.append("</html>");
                this.periodFreeText.setText(x);
                this.periodFreeText.setToolTipText(toolTipBuilder.toString());
            } else {
                String guiMutiTip = null;
                if (cost.getChargeDetail() != null && (guiMutiTip = cost.getChargeDetail().get("guiMutiTip")) != null && guiMutiTip.length() > 0) {
                    this.periodFreeText.setText(guiMutiTip);
                    String guiMutiToolTip = cost.getChargeDetail().get("guiMutiToolTip");
                    if (guiMutiToolTip != null && guiMutiToolTip.length() > 0) {
                        this.periodFreeText.setToolTipText("<html>" + guiMutiToolTip + "</html>");
                    } else {
                        this.periodFreeText.setToolTipText(null);
                    }
                }
                if (guiMutiTip == null || guiMutiTip.length() == 0) {
                    this.periodFreeText.setText("-0.00");
                    this.periodFreeText.setToolTipText(null);
                }
            }
            if (cost != null && cost.getCash().doubleValue() > 0.0 && this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
                this.selectplatePopupMenu.setVisible(false);
            }
            if (cost.getActualCharge().doubleValue() > 0.0 && this.plateTextPanel != null && this.plateTextPanel.getTextField().isFocusOwner()) {
                final String plateT = this.plateTextPanel.getPlate();
                if (!this.removed) {
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject(new Object(), (Object)plateT, new TimeoutObjectPool.TimeoutCallback(){

                        public void onTimeout(Object key, Object value) throws Exception {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String plateT1;
                                    if (!PassExitConfirmPanel.this.removed && (plateT1 = PassExitConfirmPanel.this.plateTextPanel.getPlate()) != null && plateT1.length() > 0 && plateT1.equals(plateT) && PassExitConfirmPanel.this.plateTextPanel.getTextField().isFocusOwner()) {
                                        PassExitConfirmPanel.this.okButton.requestFocus();
                                    }
                                }
                            });
                        }
                    }, 2L, TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private String getDiplsyMoney(BigDecimal d) {
        if (d == null) {
            d = Constants.MONEY_ZERO;
        }
        String m = (double)d.intValue() == d.doubleValue() ? String.valueOf(d.intValue()) : d.toString();
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (this.confirmDialog.isSelectedPanel(this)) {
            if (cmd == null) {
                return;
            }
            if (cmd.equals("plate_left")) {
                this.plateTextPanel.popDialog(true);
            } else if (cmd.equals("plate_right")) {
                this.plateTextPanel.popDialog(false);
            } else if (cmd.equals("cancelpass")) {
                this.doCancel();
            } else if (cmd.equals("okpass")) {
                this.doOK();
            } else if (cmd.startsWith("likePlate_")) {
                String plate = cmd.substring("likePlate_".length());
                if (this.plateTextPanel != null) {
                    this.plateTextPanel.setPlate(plate);
                }
                this.setPlateResult();
            } else if (cmd.equals("cartypeselect")) {
                CarparkCarType t1;
                if (!this.canactionCartype) {
                    return;
                }
                ComboBoxEntry cb = (ComboBoxEntry)((Object)this.carTypeSelect.getSelectedItem());
                CarparkCarType t = (CarparkCarType)cb.getKey();
                if (!(t == null || (t1 = this.passSession.getCarType()) != null && t.getCar_type_no().equals(t1.getCar_type_no()))) {
                    this.passSession.setCarType(t);
                    this.recharge0(null, "carTypeNo", t.getCar_type_no());
                }
            } else if (cmd.startsWith("selectplate_")) {
                Component cx = (Component)e.getSource();
                this.onClickSelectPicPnaelx((SelectPicPnaelx)cx.getParent());
            } else if (cmd.equals("selectDiscountPoject")) {
                if (!this.canactionDiscountpoj) {
                    return;
                }
                if (this.dicountPojSelect == null) {
                    return;
                }
                ComboBoxEntry cb = (ComboBoxEntry)((Object)this.dicountPojSelect.getSelectedItem());
                if (cb == null) {
                    return;
                }
                CarparkDiscountProject p = (CarparkDiscountProject)cb.getKey();
                CarparkDiscountProject sp = (CarparkDiscountProject)this.passSession.getAttribute("GUI_SELECT_DISCOUNT");
                boolean needRechrage = false;
                String updateV = null;
                if ("".equals(p.getDiscount_project_no())) {
                    if (sp != null) {
                        needRechrage = true;
                        this.passSession.removeAttribute("GUI_SELECT_DISCOUNT");
                        updateV = "noDiscount";
                    }
                } else if (sp == null || !p.getDiscount_project_no().equals(sp.getDiscount_project_no())) {
                    needRechrage = true;
                    this.passSession.setAttribute("GUI_SELECT_DISCOUNT", p);
                    updateV = p.getDiscount_project_no();
                }
                if (needRechrage) {
                    this.recharge0(null, "discount", updateV);
                }
            } else if (cmd.equals("capturecet")) {
                final OpencvFrame defaultInstance = OpencvFrame.getDefaultInstance((boolean)true);
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                File dateFile = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
                File xfile = new File(dateFile, "cet");
                if (!xfile.exists()) {
                    xfile.mkdirs();
                }
                String fileName = "snapshot_" + System.currentTimeMillis() + "_" + RandomStringGenerator.getDefaultInstance().getNewString(6) + ".jpg";
                File picFile = new File(xfile, fileName);
                final String savePath = picFile.getAbsolutePath();
                defaultInstance.setAttach((Object)this);
                defaultInstance.setCallback(new CaptureCallback(){

                    public void onCaptureSuccess(String picPath) {
                        try {
                            defaultInstance.setVisible(false);
                        }
                        finally {
                            PassExitConfirmPanel.this.onCapturecet(picPath);
                        }
                    }

                    public String getPicPath() {
                        return savePath;
                    }
                });
                if (defaultInstance.isVisible()) {
                    defaultInstance.toFront();
                    defaultInstance.setAlwaysOnTop(true);
                    defaultInstance.setState(0);
                } else {
                    Image a;
                    int width = defaultInstance.getWidth();
                    int height = defaultInstance.getHeight();
                    if (width == 0 || height == 0) {
                        width = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * 700.0 / 1280.0);
                        height = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 500.0 / 768.0);
                        defaultInstance.setSize(width, height);
                    }
                    int x = defaultInstance.getX();
                    int y = defaultInstance.getY();
                    if (x == 0 || y == 0) {
                        x = (this.confirmDialog.getCarparkMainFrame().getRootSize().width - width) / 2;
                        if (x < 0) {
                            x = 0;
                        }
                        x += this.confirmDialog.getCarparkMainFrame().getX();
                        y = (this.confirmDialog.getCarparkMainFrame().getRootSize().height - height) / 2;
                        if (y < 0) {
                            y = 0;
                        }
                        defaultInstance.setLocation(x, y += this.confirmDialog.getCarparkMainFrame().getY());
                    }
                    if (defaultInstance.getIconImage() == null && (a = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo")) != null) {
                        defaultInstance.setIconImage(a);
                    }
                    defaultInstance.setTitle("\u8bc1\u4ef6\u6293\u62cd");
                    defaultInstance.setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            defaultInstance.toFront();
                            defaultInstance.setAlwaysOnTop(true);
                            defaultInstance.setState(0);
                        }
                    });
                }
            }
        } else if (cmd != null) {
            if (cmd.equals("cartypeselect")) {
                this.setCarTypeInfo();
            } else if (cmd.equals("selectDiscountPoject")) {
                CarparkDiscountProject sp = (CarparkDiscountProject)this.passSession.getAttribute("GUI_SELECT_DISCOUNT");
                String selectProjecNo = sp == null ? "" : sp.getDiscount_project_no();
                int selectIndex = this.dicountPojSelect.getSelectedIndex();
                int count = this.dicountPojSelect.getItemCount();
                int needSelectIndex = selectIndex;
                int i = 0;
                while (i < count) {
                    ComboBoxEntry<CarparkDiscountProject> t = this.dicountPojSelect.getItemAt(i);
                    if (selectProjecNo.equals(((CarparkDiscountProject)t.getKey()).getDiscount_project_no())) {
                        needSelectIndex = i;
                        break;
                    }
                    ++i;
                }
                if (needSelectIndex != selectIndex) {
                    this.dicountPojSelect.setSelectedIndex(needSelectIndex);
                }
            }
        }
    }

    private void showOtherPic() {
        if (!this.curentShowingOtherPic) {
            this.loadOtherPic(this.certificatesPicLabel, this.certificatesPicSize);
            this.curentShowingOtherPic = true;
        }
        this.setPanel1BottomSelectedComponent(this.certificatesPanel);
    }

    private boolean hasOtherPic() {
        List<CaptureEvent> list;
        boolean haPic = false;
        PassSession session = this.passSession;
        if (session != null && session.getReadPassportNumberEvent() != null && (list = session.getReadPassportNumberEvent().getCaptures()) != null && !list.isEmpty()) {
            for (CaptureEvent c : list) {
                if (c == null || c.getPicture_use() == 1) continue;
                haPic = true;
                break;
            }
        }
        return haPic;
    }

    private void loadOtherPic(final JLabel picLabel, final Dimension picSize1) {
        if (picLabel == null) {
            return;
        }
        Image image = null;
        try {
            ImageIcon imageicon;
            List<CaptureEvent> list;
            boolean loadNoPic = true;
            PassSession session = this.passSession;
            if (session.getReadPassportNumberEvent() != null && (list = session.getReadPassportNumberEvent().getCaptures()) != null && !list.isEmpty()) {
                CaptureEvent ce0 = null;
                for (CaptureEvent c : list) {
                    if (c == null || c.getPicture_use() == 1) continue;
                    ce0 = c;
                    break;
                }
                final CaptureEvent ce = ce0;
                if (ce != null && ce.getCaptureHandle() != null) {
                    if (ce.getCaptureHandle().isDone()) {
                        BufferedImage cap;
                        Integer a;
                        if (ce.getCaptureHandle().getException() == null && (a = (Integer)ce.getCaptureHandle().getResult()) != null && a == 0 && (cap = this.loadImage(ce.getImgLocalPath())) != null) {
                            image = picSize1 != null ? SwingUtil.resizeImage((Image)cap, picSize1.width, picSize1.height) : cap;
                        }
                    } else {
                        loadNoPic = false;
                        this.setLoading(picLabel, "\u56fe\u7247\u52a0\u8f7d\u4e2d...");
                        ce.getCaptureHandle().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void operationComplete(OperationFuture<Integer> f) {
                                BufferedImage cap;
                                Integer a;
                                Image image = null;
                                if (!f.isCancelled() && f.getException() == null && (a = (Integer)f.getResult()) != null && a == 0 && (cap = PassExitConfirmPanel.this.loadImage(ce.getImgLocalPath())) != null) {
                                    image = picSize1 != null ? SwingUtil.resizeImage((Image)cap, picSize1.width, picSize1.height) : cap;
                                }
                                this.displayPic(image);
                            }

                            private void displayPic(Image image) {
                                ImageIcon imageicon;
                                if (image == null && (imageicon = PassExitConfirmPanel.this.getNoPicImage(picSize1)) != null) {
                                    image = imageicon.getImage();
                                }
                                if (image != null) {
                                    final Image image0 = image;
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ImageIcon icon = new ImageIcon(image0);
                                            picLabel.setIcon(icon);
                                            picLabel.setText(null);
                                        }
                                    });
                                }
                            }

                            public void waitCompleteTimeout() {
                                this.displayPic(null);
                            }
                        });
                    }
                }
            }
            if (image == null && loadNoPic && (imageicon = this.getNoPicImage(picSize1)) != null) {
                image = imageicon.getImage();
            }
            if (image != null) {
                ImageIcon icon = new ImageIcon(image);
                picLabel.setIcon(icon);
                picLabel.setText(null);
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private void onCapturecet(String path) {
        Image img;
        this.curentShowingOtherPic = false;
        try {
            img = ImageIO.read(new File(path));
        }
        catch (Throwable ex) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u6293\u62cd\u8bc1\u4ef6\u56fe\u7247\u5931\u8d25\uff01", 4));
            return;
        }
        if (this.certificatesPicSize != null) {
            img = SwingUtil.resizeImage(img, this.certificatesPicSize.width, this.certificatesPicSize.height);
        }
        this.certificatesPicLabel.setText(null);
        this.certificatesPicLabel.setIcon(new ImageIcon(img));
        this.setPanel1BottomSelectedComponent(this.certificatesPanel);
        CaptureEvent certCapture = null;
        List<CaptureEvent> clist = this.passSession.getReadPassportNumberEvent().getCaptures();
        if (clist != null && !clist.isEmpty()) {
            for (CaptureEvent e : clist) {
                if (e.getPicture_use() != 8) continue;
                certCapture = e;
                break;
            }
        }
        if (certCapture == null) {
            OperationFutureHandler captureHandle = ServiceUtil.getServiceContext().createOperationFuture();
            captureHandle.setResult((Object)0);
            certCapture = new CaptureEvent(null, path, 8, 8, (OperationFuture<Integer>)captureHandle, System.currentTimeMillis(), this.passSession.getPassChannel().getChannelNo());
            this.passSession.getReadPassportNumberEvent().addCaptureEvent(certCapture);
        } else {
            certCapture.setImgLocalPath(path);
            certCapture.setCaptureTimeMills(System.currentTimeMillis());
        }
        Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
        if (cost != null && cost.getCash().doubleValue() > 0.0) {
            String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("ZHENGJIAN_CAPTURE");
            if (v == null || v.length() == 0) {
                v = "0";
            }
            if ("0".equals(v)) {
                CarparkDiscountProject p = new CarparkDiscountProject();
                p.setId(0L);
                p.setDiscount_method(2);
                p.setDiscount_project_name("\u8bc1\u4ef6\u6293\u62cd\u514d\u8d39");
                p.setDiscount_value(100);
                p.setDiscount_project_no("certificates_free");
                p.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                p.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                p.setCreated_time(new Date());
                p.setLast_updated_time(p.getCreated_time());
                this.passSession.setAttribute("GUI_SELECT_DISCOUNT", p);
                this.recharge0(new Runnable(){

                    @Override
                    public void run() {
                        PassExitConfirmPanel.this.setDiscountInfo();
                    }
                }, "discount", "certificates_free");
            }
        }
    }

    private void onClickSelectPicPnaelx(final SelectPicPnaelx p) {
        if (this.panel1TopSelectP != this.enterPicSelectScrPane) {
            return;
        }
        if (p.selected) {
            return;
        }
        if (!this.okButton.isEnabled()) {
            return;
        }
        this.plateTextPanel.disable0();
        if (this.carTypeSelect != null) {
            this.carTypeSelect.setEnabled(false);
        }
        if (this.dicountPojSelect != null) {
            this.dicountPojSelect.setEnabled(false);
        }
        this.okButton.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        try {
                            PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPlateNumber(p.reloadPlate);
                            PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPassportMediumType(6);
                            PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPassportNumber(p.reloadPlate);
                            PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setQueryPreseceRecordPassportNumber(p.querypassportNumber);
                            PassExitConfirmPanel.this.passSession.setAttribute("GUI_CONFIRM", Boolean.TRUE);
                            PassExitConfirmPanel.this.passSession.removeAttribute("GUI_SELECT_DISCOUNT");
                            try {
                                CaptureEvent certCapture = null;
                                List<CaptureEvent> clist = PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().getCaptures();
                                if (clist != null && !clist.isEmpty()) {
                                    for (CaptureEvent e : clist) {
                                        if (e.getPicture_use() != 8) continue;
                                        certCapture = e;
                                        break;
                                    }
                                }
                                if (certCapture != null && clist != null) {
                                    clist.remove(certCapture);
                                }
                                PassExitConfirmPanel.this.passSession.getPassChannel().doStartSession(PassExitConfirmPanel.this.passSession);
                            }
                            finally {
                                PassExitConfirmPanel.this.passSession.removeAttribute("GUI_CONFIRM");
                            }
                        }
                        catch (Throwable ex) {
                            GuiLog.getLog().warn((Object)"", ex);
                            SwingUtil.invokeLater(new Runnable(p){
                                private final /* synthetic */ SelectPicPnaelx val$p;
                                {
                                    this.val$p = selectPicPnaelx;
                                }

                                @Override
                                public void run() {
                                    try {
                                        PassExitConfirmPanel.this.setExitInfo();
                                        PassExitConfirmPanel.this.setEnterInfo();
                                        PassExitConfirmPanel.this.setCostInfo();
                                        PassExitConfirmPanel.this.setPassportInfo();
                                        PassExitConfirmPanel.this.setDiscountInfo();
                                        int count = PassExitConfirmPanel.this.enterPicSelectPanel.getComponentCount();
                                        int i = 0;
                                        while (i < count) {
                                            SelectPicPnaelx pan;
                                            Component c = PassExitConfirmPanel.this.enterPicSelectPanel.getComponent(i);
                                            if (c != null && c instanceof SelectPicPnaelx && (pan = (SelectPicPnaelx)c).selected) {
                                                pan.selected = false;
                                                pan.setBorder(BorderFactory.createEmptyBorder());
                                            }
                                            ++i;
                                        }
                                        int borderSize = (int)Math.round(PassExitConfirmPanel.this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 2.0 / 768.0);
                                        this.val$p.setBorder(BorderFactory.createLineBorder(Color.decode("#FC8E22"), borderSize));
                                        this.val$p.selected = true;
                                        PassExitConfirmPanel.this.setPanel1TopSelectedComponent(PassExitConfirmPanel.this.enterPicSelectScrPane);
                                    }
                                    finally {
                                        PassExitConfirmPanel.this.plateTextPanel.enable0();
                                        if (PassExitConfirmPanel.this.carTypeSelect != null) {
                                            PassExitConfirmPanel.this.carTypeSelect.setEnabled(true);
                                        }
                                        if (PassExitConfirmPanel.this.dicountPojSelect != null) {
                                            PassExitConfirmPanel.this.dicountPojSelect.setEnabled(true);
                                        }
                                        PassExitConfirmPanel.this.okButton.setEnabled(true);
                                    }
                                }
                            });
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    @Override
    public void onRemove() {
        OpencvFrame defaultInstance;
        this.removed = true;
        this.plateTextPanel.distory0();
        this.plateTextPanel.getLeftButton().removeActionListener(this);
        this.plateTextPanel.getRightButton().removeActionListener(this);
        if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
        if ((defaultInstance = OpencvFrame.getDefaultInstance((boolean)false)) != null && defaultInstance.getAttach() == this && defaultInstance.isVisible()) {
            defaultInstance.setVisible(false);
        }
        if (this.waitPayingDialog != null) {
            if (this.waitPayingDialog.isVisible()) {
                this.waitPayingDialog.dispose();
            }
            if (this.waitPayingDialog.sc != null && !this.waitPayingDialog.sc.isCancelled()) {
                this.waitPayingDialog.sc.cancel(true);
            }
        }
    }

    @Override
    public void onPressEnter() {
        this.doOK();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String cmd;
        CarparkMainFrame.RoundPanelButton b;
        if (this.confirmDialog.isSelectedPanel(this) && (b = this.getRoundPanelButton(e)) != null && "playCharge".equals(cmd = b.getCmd())) {
            this.playCharge();
        }
    }

    private void playCharge() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.playMoney(PassExitConfirmPanel.this.passSession);
                sp.playMoneyLanHost(PassExitConfirmPanel.this.passSession);
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private CarparkMainFrame.RoundPanelButton getRoundPanelButton(MouseEvent e) {
        Component c;
        Container p1;
        Object scs = e.getSource();
        if (scs instanceof CarparkMainFrame.RoundPanelButton) {
            return (CarparkMainFrame.RoundPanelButton)scs;
        }
        if (scs instanceof Component && (p1 = (c = (Component)scs).getParent()) != null) {
            if (p1 instanceof CarparkMainFrame.RoundPanelButton) {
                return (CarparkMainFrame.RoundPanelButton)p1;
            }
            Container p2 = p1.getParent();
            if (p2 != null && p2 instanceof CarparkMainFrame.RoundPanelButton) {
                return (CarparkMainFrame.RoundPanelButton)p2;
            }
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        CarparkMainFrame.RoundPanelButton b = this.getRoundPanelButton(e);
        if (b != null) {
            b.onMoveOn();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        CarparkMainFrame.RoundPanelButton b = this.getRoundPanelButton(e);
        if (b != null) {
            b.onMoveOut();
        }
    }

    private BufferedImage loadImage(String path) {
        try {
            File f1;
            if (path != null && path.length() > 0 && (f1 = new File(path)).exists() && f1.isFile()) {
                return ImageIO.read(f1);
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247\u5f02\u5e38! \u8def\u5f84\uff1a" + path + ", \u539f\u56e0:" + ex.getMessage()));
            return null;
        }
        return null;
    }

    private BufferedImage loadImage(String bigPath, String smallPath, Dimension picSize) {
        BufferedImage bigImage = this.loadImage(bigPath);
        if (bigImage == null) {
            return null;
        }
        BufferedImage smallImage = this.loadImage(smallPath);
        return this.createImage(bigImage, smallImage, picSize);
    }

    private BufferedImage createImage(BufferedImage bigImage, BufferedImage smallImage, Dimension picSize) {
        BufferedImage newImage;
        if (bigImage == null) {
            return null;
        }
        if (picSize == null) {
            return bigImage;
        }
        int bigWith = picSize.width;
        int bigHeight = picSize.height;
        try {
            newImage = new BufferedImage(bigWith, bigHeight, bigImage.getType());
            Graphics g = newImage.getGraphics();
            try {
                Image image = bigImage.getScaledInstance(bigWith, bigHeight, 4);
                g.drawImage(image, 0, 0, null);
                if (smallImage != null) {
                    int smallImageHegiht;
                    int smallImageWidth = smallImage.getWidth();
                    if (smallImageWidth > 110) {
                        smallImageWidth = 110;
                    }
                    if ((smallImageHegiht = smallImage.getHeight()) > 45) {
                        smallImageHegiht = 45;
                    }
                    int smallWidth = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getWidth() * (double)smallImageWidth / 1280.0) - 10;
                    int smallHeight = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * (double)smallImageHegiht / 768.0);
                    if (smallWidth > bigWith) {
                        smallWidth = bigWith;
                    }
                    if (smallHeight > bigHeight) {
                        smallHeight = bigHeight;
                    }
                    Image i = SwingUtil.resizeImage((Image)smallImage, smallWidth, smallHeight);
                    int marginLeft = 0;
                    int marginBottom = 3;
                    int x = marginLeft;
                    int y = bigHeight - marginBottom - smallHeight;
                    if (y < 0) {
                        y = 0;
                    }
                    g.drawImage(i, x, y, null);
                }
            }
            finally {
                g.dispose();
            }
        }
        catch (Throwable ex) {
            try {
                return SwingUtil.resizeImage(bigImage, bigWith, bigHeight);
            }
            catch (Throwable ex1) {
                return bigImage;
            }
        }
        return newImage;
    }

    private void loadExitPic() {
        Image image = null;
        try {
            List<CaptureEvent> list;
            boolean loadNoPic = true;
            PassSession session = this.passSession;
            if (session.getPlateRecognizedEvent() != null) {
                image = this.loadImage(session.getPlateRecognizedEvent().getPicPath(), session.getPlateRecognizedEvent().getPlateSmallPath(), this.exitPicSize);
            }
            if (image == null && session.getReadPassportNumberEvent() != null && (list = session.getReadPassportNumberEvent().getCaptures()) != null && !list.isEmpty()) {
                CaptureEvent ce0 = null;
                for (CaptureEvent e : list) {
                    if (e == null || e.getPicture_use() != 1) continue;
                    ce0 = e;
                    break;
                }
                final CaptureEvent ce = ce0;
                if (ce != null && ce.getCaptureHandle() != null) {
                    if (ce.getCaptureHandle().isDone()) {
                        BufferedImage cap;
                        Integer a;
                        if (ce.getCaptureHandle().getException() == null && (a = (Integer)ce.getCaptureHandle().getResult()) != null && a == 0 && (cap = this.loadImage(ce.getImgLocalPath())) != null) {
                            image = this.exitPicSize != null ? SwingUtil.resizeImage((Image)cap, this.exitPicSize.width, this.exitPicSize.height) : cap;
                        }
                    } else {
                        loadNoPic = false;
                        this.setLoading(this.exitPicLabel, "\u6293\u62cd\u56fe\u7247\u4e2d...");
                        ce.getCaptureHandle().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void operationComplete(OperationFuture<Integer> f) {
                                BufferedImage cap;
                                Integer a;
                                Image image = null;
                                if (!f.isCancelled() && f.getException() == null && (a = (Integer)f.getResult()) != null && a == 0 && (cap = PassExitConfirmPanel.this.loadImage(ce.getImgLocalPath())) != null) {
                                    image = PassExitConfirmPanel.this.exitPicSize != null ? SwingUtil.resizeImage((Image)cap, ((PassExitConfirmPanel)PassExitConfirmPanel.this).exitPicSize.width, ((PassExitConfirmPanel)PassExitConfirmPanel.this).exitPicSize.height) : cap;
                                }
                                this.displayPic(image);
                            }

                            private void displayPic(Image image) {
                                if (image == null) {
                                    image = PassExitConfirmPanel.this.getNoPicImage0(PassExitConfirmPanel.this.exitPicSize);
                                }
                                if (image != null) {
                                    final Image image0 = image;
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ImageIcon icon = new ImageIcon(image0);
                                            PassExitConfirmPanel.this.exitPicLabel.setIcon(icon);
                                            PassExitConfirmPanel.this.exitPicLabel.setText(null);
                                        }
                                    });
                                }
                            }

                            public void waitCompleteTimeout() {
                                this.displayPic(null);
                            }
                        });
                    }
                }
            }
            if (image == null && loadNoPic) {
                image = this.getNoPicImage0(this.exitPicSize);
            }
            if (image != null) {
                ImageIcon icon = new ImageIcon(image);
                this.exitPicLabel.setIcon(icon);
                this.exitPicLabel.setText(null);
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private void setLoading(JLabel imageLabel, String msg) {
        Image load;
        int h1 = imageLabel.getHorizontalTextPosition();
        if (h1 != 11) {
            imageLabel.setHorizontalTextPosition(11);
        }
        if ((h1 = imageLabel.getVerticalTextPosition()) != 0) {
            imageLabel.setVerticalTextPosition(0);
        }
        if ((h1 = imageLabel.getHorizontalAlignment()) != 0) {
            imageLabel.setHorizontalAlignment(0);
        }
        if ((load = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("loading1")) == null) {
            imageLabel.setIcon(null);
        } else {
            imageLabel.setIcon(new ImageIcon(load));
        }
        imageLabel.setText(msg);
    }

    private void loadEnterPic() {
        try {
            CarparkPresenceRecord r = this.getEnterRecord();
            if (r == null) {
                this.enterPicLabel.setIcon(this.getNoPicImage(this.enterPicSize));
                this.enterPicLabel.setText(null);
                return;
            }
            final String enterCarPic = r.getEnter_car_pic();
            final String enterPlatePic = r.getEnter_plate_pic();
            if (enterCarPic == null || enterCarPic.length() == 0) {
                this.enterPicLabel.setIcon(this.getNoPicImage(this.enterPicSize));
                this.enterPicLabel.setText(null);
                return;
            }
            RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            String path = s.getLocalPicPath(enterCarPic);
            String localCarPath = null;
            String localPlatePath = null;
            File f1 = new File(path);
            if (f1.exists() && f1.isFile()) {
                localCarPath = f1.getAbsolutePath();
            } else {
                f1 = new File(enterCarPic);
                if (f1.exists() && f1.isFile()) {
                    localCarPath = f1.getAbsolutePath();
                }
            }
            if (enterPlatePic != null && enterPlatePic.length() > 0) {
                path = s.getLocalPicPath(enterPlatePic);
                f1 = new File(path);
                if (f1.exists() && f1.isFile()) {
                    localPlatePath = f1.getAbsolutePath();
                } else {
                    f1 = new File(enterPlatePic);
                    if (f1.exists() && f1.isFile()) {
                        localPlatePath = f1.getAbsolutePath();
                    }
                }
            }
            if (localCarPath != null) {
                BufferedImage image = this.loadImage(localCarPath, localPlatePath, this.enterPicSize);
                if (image == null) {
                    this.enterPicLabel.setIcon(this.getNoPicImage(this.enterPicSize));
                    this.enterPicLabel.setText(null);
                    return;
                }
                this.enterPicLabel.setIcon(new ImageIcon(image));
                this.enterPicLabel.setText(null);
            } else {
                ApplicationService appservice = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                ArrayList<String> s1 = new ArrayList<String>(2);
                s1.add(enterCarPic);
                if (enterPlatePic != null && enterPlatePic.length() > 0) {
                    s1.add(enterPlatePic);
                }
                final String plate = this.plateTextPanel.getPlate();
                this.setLoading(this.enterPicLabel, "\u6b63\u5728\u52a0\u8f7d\u56fe\u7247...");
                OperationFuture<Map<String, BufferedImage>> op = appservice.asynLoadRemotePic(r.getEnter_host_no(), s1.toArray(new String[s1.size()]));
                op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Map<String, BufferedImage>>(){

                    public void operationComplete(OperationFuture<Map<String, BufferedImage>> xf) {
                        if (xf.isCancelled() || xf.getException() != null) {
                            this.setNopic();
                        } else {
                            Map mv = (Map)xf.getResult();
                            if (mv == null) {
                                this.setNopic();
                            } else {
                                final BufferedImage b1 = (BufferedImage)mv.get(enterCarPic);
                                if (b1 == null) {
                                    this.setNopic();
                                } else {
                                    final BufferedImage b2 = enterPlatePic != null && enterPlatePic.length() > 0 ? (BufferedImage)mv.get(enterPlatePic) : null;
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            String plate1 = PassExitConfirmPanel.this.plateTextPanel.getPlate();
                                            if (plate1 == null) {
                                                plate1 = "";
                                            }
                                            if (plate1.equals(plate)) {
                                                BufferedImage imsx = PassExitConfirmPanel.this.createImage(b1, b2, PassExitConfirmPanel.this.enterPicSize);
                                                if (imsx == null) {
                                                    PassExitConfirmPanel.this.enterPicLabel.setIcon(PassExitConfirmPanel.this.getNoPicImage(PassExitConfirmPanel.this.enterPicSize));
                                                    PassExitConfirmPanel.this.enterPicLabel.setText(null);
                                                } else {
                                                    PassExitConfirmPanel.this.enterPicLabel.setIcon(new ImageIcon(imsx));
                                                    PassExitConfirmPanel.this.enterPicLabel.setText(null);
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    }

                    public void waitCompleteTimeout() {
                        this.setNopic();
                    }

                    private void setNopic() {
                        SwingUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String plate1 = PassExitConfirmPanel.this.plateTextPanel.getPlate();
                                if (plate1 == null) {
                                    plate1 = "";
                                }
                                if (plate1.equals(plate)) {
                                    PassExitConfirmPanel.this.enterPicLabel.setIcon(PassExitConfirmPanel.this.getNoPicImage(PassExitConfirmPanel.this.enterPicSize));
                                    PassExitConfirmPanel.this.enterPicLabel.setText(null);
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
            try {
                this.enterPicLabel.setIcon(this.getNoPicImage(this.enterPicSize));
                this.enterPicLabel.setText(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doLikeSelect() {
        String x = this.plateTextPanel.getTextField().getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateTextPanel.getTextField().setText(v2);
            x = v2;
        }
        if (x != null && x.length() > 1) {
            this.plateQueryQueue0.offer(x);
            this.queryPlateResult0();
            if (x.length() >= 5) {
                this.setPlateResult();
            }
        } else if (this.selectplatePopupMenu != null && this.selectplatePopupMenu.isVisible()) {
            this.selectplatePopupMenu.setVisible(false);
        }
    }

    private void queryPlateResult0() {
        if (this.querying0.compareAndSet(false, true)) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                        List<String> likePlate = null;
                        try {
                            try {
                                String p;
                                String lastPlate = null;
                                while ((p = (String)PassExitConfirmPanel.this.plateQueryQueue0.poll()) != null) {
                                    lastPlate = p;
                                }
                                if (lastPlate != null && lastPlate.length() > 0) {
                                    likePlate = recordSaveService.getEnterInOrExitPalteList(lastPlate, PassExitConfirmPanel.this.maxPlateLikeLen);
                                }
                            }
                            catch (Exception ex) {
                                GuiLog.getLog().error((Object)"", (Throwable)ex);
                                List<String> likePlate0 = likePlate;
                                SwingUtil.invokeLater(new Runnable(likePlate0){
                                    private final /* synthetic */ Collection val$likePlate0;
                                    {
                                        this.val$likePlate0 = collection;
                                    }

                                    @Override
                                    public void run() {
                                        PassExitConfirmPanel.this.querying0.set(false);
                                        if (PassExitConfirmPanel.this.plateQueryQueue0.peek() != null) {
                                            PassExitConfirmPanel.this.queryPlateResult0();
                                        } else if (this.val$likePlate0 == null || this.val$likePlate0.isEmpty()) {
                                            if (PassExitConfirmPanel.this.selectplatePopupMenu != null && PassExitConfirmPanel.this.selectplatePopupMenu.isVisible()) {
                                                PassExitConfirmPanel.this.selectplatePopupMenu.setVisible(false);
                                            }
                                        } else {
                                            int count = PassExitConfirmPanel.this.selectplatePopupMenu.getComponentCount();
                                            int i = 0;
                                            while (i < count) {
                                                Component c = PassExitConfirmPanel.this.selectplatePopupMenu.getComponent(i);
                                                if (c != null && c instanceof JMenuItem) {
                                                    ((JMenuItem)c).removeActionListener(PassExitConfirmPanel.this);
                                                }
                                                ++i;
                                            }
                                            PassExitConfirmPanel.this.selectplatePopupMenu.removeAll();
                                            PassExitConfirmPanel.this.selectplatePopupMenu.setVisible(false);
                                            for (String s : this.val$likePlate0) {
                                                JMenuItem item = new JMenuItem(s);
                                                item.setPreferredSize(PassExitConfirmPanel.this.popupMenuItemSize);
                                                item.setFont(PassExitConfirmPanel.this.plateLikeFont);
                                                item.setActionCommand("likePlate_" + s);
                                                item.addActionListener(PassExitConfirmPanel.this);
                                                PassExitConfirmPanel.this.selectplatePopupMenu.add(item);
                                            }
                                            if (!PassExitConfirmPanel.this.selectplatePopupMenu.isVisible()) {
                                                PassExitConfirmPanel.this.selectplatePopupMenu.show(PassExitConfirmPanel.this.plateTextPanel.getTextField(), 0, PassExitConfirmPanel.this.plateTextPanel.getHeight() - 4);
                                                PassExitConfirmPanel.this.plateTextPanel.getTextField().requestFocus();
                                            }
                                        }
                                    }
                                });
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            List<String> likePlate0 = likePlate;
                            SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        List<String> likePlate0 = likePlate;
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            });
        }
    }

    private void setPlateResult() {
        if (!this.confirmDialog.isSelectedPanel(this)) {
            return;
        }
        String inputPlate = this.plateTextPanel.getPlate();
        if (inputPlate == null) {
            return;
        }
        if (inputPlate.length() >= 6 && inputPlate.length() <= 9) {
            this.reloadSessionByPlate(inputPlate);
        }
    }

    private void reloadSessionByPlate(String plate) {
        String passPlate;
        if (plate == null || plate.length() == 0) {
            return;
        }
        if (!this.isReadCard() && !plate.equals(passPlate = this.passSession.getPassPlate())) {
            this.plateReloadQueue1.offer(plate);
            this.reloadSessionByPlate0();
        }
    }

    private void reloadSessionByPlate0() {
        if (this.plateReloading1.compareAndSet(false, true)) {
            this.okButton.setEnabled(false);
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block12: {
                        block11: {
                            try {
                                try {
                                    String passPlate;
                                    String p;
                                    String lastPlate = null;
                                    while ((p = (String)PassExitConfirmPanel.this.plateReloadQueue1.poll()) != null) {
                                        lastPlate = p;
                                    }
                                    if (lastPlate == null || lastPlate.length() <= 0 || lastPlate.equals(passPlate = PassExitConfirmPanel.this.passSession.getPassPlate())) break block11;
                                    PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPlateNumber(lastPlate);
                                    PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPassportMediumType(6);
                                    PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setPassportNumber(lastPlate);
                                    PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().setQueryPreseceRecordPassportNumber(null);
                                    PassExitConfirmPanel.this.passSession.setAttribute("GUI_CONFIRM", Boolean.TRUE);
                                    PassExitConfirmPanel.this.passSession.removeAttribute("GUI_SELECT_DISCOUNT");
                                    try {
                                        CaptureEvent certCapture = null;
                                        List<CaptureEvent> clist = PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().getCaptures();
                                        if (clist != null && !clist.isEmpty()) {
                                            for (CaptureEvent e : clist) {
                                                if (e.getPicture_use() != 8) continue;
                                                certCapture = e;
                                                break;
                                            }
                                        }
                                        if (certCapture != null && clist != null) {
                                            clist.remove(certCapture);
                                        }
                                        PassExitConfirmPanel.this.passSession.getPassChannel().doStartSession(PassExitConfirmPanel.this.passSession);
                                    }
                                    finally {
                                        PassExitConfirmPanel.this.passSession.removeAttribute("GUI_CONFIRM");
                                    }
                                }
                                catch (Throwable ex) {
                                    GuiLog.getLog().error((Object)"", ex);
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            PassExitConfirmPanel.this.plateReloading1.set(false);
                                            if (PassExitConfirmPanel.this.plateReloadQueue1.peek() != null) {
                                                PassExitConfirmPanel.this.reloadSessionByPlate0();
                                            } else {
                                                PassExitConfirmPanel.this.okButton.setEnabled(true);
                                                PassExitConfirmPanel.this.reSetInfo();
                                                String passPlate = PassExitConfirmPanel.this.passSession.getPassPlate();
                                                PassExitConfirmPanel.this.mainConfirmEvent.setTitleName(passPlate);
                                                PassExitConfirmPanel.this.confirmDialog.setSelectMunuName(PassExitConfirmPanel.this.mainConfirmEvent);
                                            }
                                        }
                                    });
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            });
        }
    }

    private void loadSimilarPresenceRecord(final String plate) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                CarparkArea exitArea = (CarparkArea)PassExitConfirmPanel.this.passSession.getAttribute("PASS_EXIT_AREA");
                final List<Map<String, Object>> slit = appService.querySimilarPresenceRecord(new String[]{"passport_number", "enter_car_pic", "enter_plate_pic", "enter_host_no"}, plate, exitArea.getArea_no(), 2);
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String inputPlate = PassExitConfirmPanel.this.plateTextPanel.getPlate();
                        if (plate.equals(inputPlate)) {
                            if (slit == null || slit.isEmpty()) {
                                PassExitConfirmPanel.this.setPanel1TopSelectedComponent(PassExitConfirmPanel.this.enterPicPanel);
                            } else {
                                PassExitConfirmPanel.this.setLeftTopButtonSelect(slit, plate);
                            }
                        }
                    }
                });
            }
        });
    }

    private void setLeftTopButtonSelect(final List<Map<String, Object>> slit, final String plate) {
        int cols;
        int rows;
        int totoalCount = slit.size() + 1;
        int n = rows = totoalCount % (cols = 2) == 0 ? totoalCount / cols : totoalCount / cols + 1;
        if (rows < 2) {
            rows = 2;
        }
        this.enterPicSelectPanel.removeAll();
        int h = this.enterPicSize.height / 2;
        int pwidht = this.enterPicSize.width;
        if (rows > 2) {
            pwidht -= 15;
        }
        this.enterPicSelectPanel.setPreferredSize(new Dimension(pwidht, h * rows));
        int grap = 1;
        int picWidth = (pwidht - (cols + 1) * grap) / cols;
        int picHeight = (h * rows - (rows + 1) * grap) / rows;
        int x = grap;
        int y = grap;
        int indx = 0;
        Color selectedPColor = Color.decode("#FC8E22");
        int fontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize);
        int fontSize0 = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 11.0 / 768.0);
        Font font0 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, fontSize0);
        int borderSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 2.0 / 768.0);
        SelectPicPnaelx panel = new SelectPicPnaelx(plate, font0, plate);
        this.enterPicSelectPanel.add((Component)panel, new XYConstraints(x, y, picWidth, picHeight));
        panel.selected = true;
        panel.setBorder(BorderFactory.createLineBorder(selectedPColor, borderSize));
        panel.button.setText("\u65e0\u573a\u5185\u8bb0\u5f55");
        Cursor s = new Cursor(12);
        panel.button.setActionCommand("selectplate_" + plate);
        panel.button.setCursor(s);
        panel.button.addActionListener(this);
        ++indx;
        final Dimension dpicSize = new Dimension(picWidth - 2 * borderSize, picHeight - 2 * borderSize);
        for (Map<String, Object> m : slit) {
            if (indx % cols == 0) {
                x = grap;
                y += picHeight + grap;
            } else {
                x += picWidth + grap;
            }
            String passport_number = (String)m.get("passport_number");
            panel = new SelectPicPnaelx(passport_number, font, plate);
            this.enterPicSelectPanel.add((Component)panel, new XYConstraints(x, y, picWidth, picHeight));
            this.enterPicSelectPanel.setBorder(BorderFactory.createEmptyBorder());
            panel.button.setActionCommand("selectplate_" + passport_number);
            panel.button.setCursor(s);
            panel.button.addActionListener(this);
            m.put("swingbutton", panel.button);
            ++indx;
        }
        this.enterPicSelectPanel.updateUI();
        this.setPanel1TopSelectedComponent(this.enterPicSelectScrPane);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            private void setImage(final JButton swingbutton, final BufferedImage xb) {
                if (xb != null && swingbutton != null) {
                    SwingUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String inputPlate;
                            if (PassExitConfirmPanel.this.panel1TopSelectP == PassExitConfirmPanel.this.enterPicSelectScrPane && (inputPlate = PassExitConfirmPanel.this.plateTextPanel.getPlate()) != null && inputPlate.equals(plate)) {
                                ImageIcon ic = new ImageIcon(xb);
                                swingbutton.setText(null);
                                swingbutton.setIcon(ic);
                            }
                        }
                    });
                }
            }

            private BufferedImage loadRemoteImage(String picHost, String dbpath, ApplicationService appService, CarparkHost serverHost, CarparkHost localHost) {
                try {
                    return appService.loadPic(picHost, dbpath);
                }
                catch (Exception ex) {
                    return null;
                }
            }

            @Override
            public void run() {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                LinkedList<Map> remotePicList = null;
                for (Map m : slit) {
                    if (PassExitConfirmPanel.this.panel1TopSelectP != PassExitConfirmPanel.this.enterPicSelectScrPane) {
                        return;
                    }
                    String enter_car_pic = (String)m.get("enter_car_pic");
                    String enter_plate_pic = (String)m.get("enter_plate_pic");
                    JButton swingbutton = (JButton)m.get("swingbutton");
                    if (enter_car_pic == null || enter_car_pic.length() <= 0 || swingbutton == null) continue;
                    BufferedImage b = appService.loadLocalPic(enter_car_pic);
                    if (b != null) {
                        BufferedImage b1 = null;
                        if (enter_plate_pic != null && enter_plate_pic.length() > 0) {
                            b1 = appService.loadLocalPic(enter_plate_pic);
                        }
                        BufferedImage xb = PassExitConfirmPanel.this.createImage(b, b1, dpicSize);
                        this.setImage(swingbutton, xb);
                        continue;
                    }
                    if (remotePicList == null) {
                        remotePicList = new LinkedList<Map>();
                    }
                    remotePicList.add(m);
                }
                if (remotePicList != null && !remotePicList.isEmpty()) {
                    CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                    CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
                    if (localHost != null) {
                        for (Map m : remotePicList) {
                            BufferedImage b;
                            if (PassExitConfirmPanel.this.panel1TopSelectP != PassExitConfirmPanel.this.enterPicSelectScrPane) {
                                return;
                            }
                            String enter_car_pic = (String)m.get("enter_car_pic");
                            String enter_plate_pic = (String)m.get("enter_plate_pic");
                            JButton swingbutton = (JButton)m.get("swingbutton");
                            String picHost = (String)m.get("enter_host_no");
                            if (enter_car_pic == null || enter_car_pic.length() <= 0 || swingbutton == null || (b = this.loadRemoteImage(picHost, enter_car_pic, appService, serverHost, localHost)) == null) continue;
                            BufferedImage b1 = null;
                            if (enter_plate_pic != null && enter_plate_pic.length() > 0) {
                                b1 = this.loadRemoteImage(picHost, enter_plate_pic, appService, serverHost, localHost);
                            }
                            BufferedImage xb = PassExitConfirmPanel.this.createImage(b, b1, dpicSize);
                            this.setImage(swingbutton, xb);
                        }
                    }
                }
            }
        });
    }

    private void recharge0(final Runnable chargeFinish, final String modifyItem, final String modifyValue) {
        if (!this.okButton.isEnabled()) {
            return;
        }
        this.plateTextPanel.disable0();
        if (this.carTypeSelect != null) {
            this.carTypeSelect.setEnabled(false);
        }
        if (this.dicountPojSelect != null) {
            this.dicountPojSelect.setEnabled(false);
        }
        this.okButton.setEnabled(false);
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        try {
                            if (!MainHostPassFilter.doLanRemoteModify(PassExitConfirmPanel.this.passSession, modifyItem, modifyValue) && PassExitConfirmPanel.this.passSession.getChargeFilter() != null) {
                                PassExitConfirmPanel.this.passSession.getChargeFilter().doFilter(PassExitConfirmPanel.this.passSession);
                            }
                        }
                        catch (Throwable ex) {
                            GuiLog.getLog().warn((Object)"", ex);
                            SwingUtil.invokeLater(new Runnable(chargeFinish){
                                private final /* synthetic */ Runnable val$chargeFinish;
                                {
                                    this.val$chargeFinish = runnable;
                                }

                                @Override
                                public void run() {
                                    try {
                                        try {
                                            PassExitConfirmPanel.this.setCostInfo();
                                            PassExitConfirmPanel.this.setPassportInfo();
                                        }
                                        catch (Throwable ex) {
                                            GuiLog.getLog().warn((Object)"", ex);
                                            try {
                                                PassExitConfirmPanel.this.okButton.setEnabled(true);
                                                PassExitConfirmPanel.this.plateTextPanel.enable0();
                                                if (PassExitConfirmPanel.this.carTypeSelect != null) {
                                                    PassExitConfirmPanel.this.carTypeSelect.setEnabled(true);
                                                }
                                                if (PassExitConfirmPanel.this.dicountPojSelect != null) {
                                                    PassExitConfirmPanel.this.dicountPojSelect.setEnabled(true);
                                                }
                                            }
                                            finally {
                                                if (this.val$chargeFinish != null) {
                                                    this.val$chargeFinish.run();
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        try {
                                            PassExitConfirmPanel.this.okButton.setEnabled(true);
                                            PassExitConfirmPanel.this.plateTextPanel.enable0();
                                            if (PassExitConfirmPanel.this.carTypeSelect != null) {
                                                PassExitConfirmPanel.this.carTypeSelect.setEnabled(true);
                                            }
                                            if (PassExitConfirmPanel.this.dicountPojSelect != null) {
                                                PassExitConfirmPanel.this.dicountPojSelect.setEnabled(true);
                                            }
                                        }
                                        finally {
                                            if (this.val$chargeFinish != null) {
                                                this.val$chargeFinish.run();
                                            }
                                        }
                                    }
                                }
                            });
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    public void reDisplayRechargeWhenPaySuccess(final boolean needOkPass) {
        if (this.refreshingPaysuccess.compareAndSet(false, true)) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            PassExitConfirmPanel.this.setCostInfo();
                            PassExitConfirmPanel.this.setPassportInfo();
                        }
                        catch (Throwable ex) {
                            GuiLog.getLog().warn((Object)"", ex);
                            try {
                                if (PassExitConfirmPanel.this.waitPayingDialog != null && PassExitConfirmPanel.this.waitPayingDialog.isVisible()) {
                                    PassExitConfirmPanel.this.waitPayingDialog.state = "SUCCESS";
                                    PassExitConfirmPanel.this.waitPayingDialog.dispose();
                                    PassExitConfirmPanel.this.unlockOp();
                                }
                                if (!PassExitConfirmPanel.this.okButton.isEnabled()) {
                                    PassExitConfirmPanel.this.okButton.setEnabled(true);
                                }
                                PassExitConfirmPanel.this.plateTextPanel.enable0();
                                if (PassExitConfirmPanel.this.carTypeSelect != null && !PassExitConfirmPanel.this.carTypeSelect.isEnabled()) {
                                    PassExitConfirmPanel.this.carTypeSelect.setEnabled(true);
                                }
                                if (PassExitConfirmPanel.this.dicountPojSelect != null && !PassExitConfirmPanel.this.dicountPojSelect.isEnabled()) {
                                    PassExitConfirmPanel.this.dicountPojSelect.setEnabled(true);
                                }
                            }
                            finally {
                                try {
                                    if (needOkPass) {
                                        PassExitConfirmPanel.this.doOK1();
                                    }
                                }
                                finally {
                                    PassExitConfirmPanel.this.refreshingPaysuccess.set(false);
                                }
                            }
                        }
                    }
                    finally {
                        try {
                            if (PassExitConfirmPanel.this.waitPayingDialog != null && PassExitConfirmPanel.this.waitPayingDialog.isVisible()) {
                                PassExitConfirmPanel.this.waitPayingDialog.state = "SUCCESS";
                                PassExitConfirmPanel.this.waitPayingDialog.dispose();
                                PassExitConfirmPanel.this.unlockOp();
                            }
                            if (!PassExitConfirmPanel.this.okButton.isEnabled()) {
                                PassExitConfirmPanel.this.okButton.setEnabled(true);
                            }
                            PassExitConfirmPanel.this.plateTextPanel.enable0();
                            if (PassExitConfirmPanel.this.carTypeSelect != null && !PassExitConfirmPanel.this.carTypeSelect.isEnabled()) {
                                PassExitConfirmPanel.this.carTypeSelect.setEnabled(true);
                            }
                            if (PassExitConfirmPanel.this.dicountPojSelect != null && !PassExitConfirmPanel.this.dicountPojSelect.isEnabled()) {
                                PassExitConfirmPanel.this.dicountPojSelect.setEnabled(true);
                            }
                        }
                        finally {
                            try {
                                if (needOkPass) {
                                    PassExitConfirmPanel.this.doOK1();
                                }
                            }
                            finally {
                                PassExitConfirmPanel.this.refreshingPaysuccess.set(false);
                            }
                        }
                    }
                }
            });
        }
    }

    private void closeDialog() {
        this.confirmDialog.finishEvent(this.mainConfirmEvent);
    }

    private void lockAllOp() {
        if (this.plateTextPanel != null) {
            this.plateTextPanel.disable0();
        }
        this.okButton.setEnabled(false);
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
        if (this.certCaptureButton != null) {
            this.certCaptureButton.setEnabled(false);
        }
        if (this.carTypeSelect != null) {
            this.carTypeSelect.setEnabled(false);
        }
        if (this.dicountPojSelect != null) {
            this.dicountPojSelect.setEnabled(false);
        }
        if (this.scanTexts != null) {
            this.scanTexts.setEditable(false);
        }
    }

    private void unlockOp() {
        if (this.plateTextPanel != null) {
            this.plateTextPanel.enable0();
        }
        this.okButton.setEnabled(true);
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(true);
        }
        if (this.certCaptureButton != null) {
            this.certCaptureButton.setEnabled(true);
        }
        if (this.carTypeSelect != null) {
            this.carTypeSelect.setEnabled(true);
        }
        if (this.dicountPojSelect != null) {
            this.dicountPojSelect.setEnabled(true);
        }
        if (this.scanTexts != null) {
            this.scanTexts.setEditable(true);
        }
    }

    public void doOK() {
        Cost cost;
        String scancode;
        String plate = this.plateTextPanel.getPlate();
        if (plate != null && plate.equals(this.getDefaultInputPlate())) {
            plate = null;
        }
        if (!this.isReadCard()) {
            if (plate == null || plate.length() < this.getMinPlateCharLength() || plate.length() > this.getMaxPlateCharLength()) {
                this.infoLabel2.setForeground(Color.decode("#FFD8E2"));
                this.infoLabel2.setText("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8f66\u724c");
                return;
            }
            if (!this.okButton.isEnabled()) {
                return;
            }
            String passPlate = this.passSession.getPassPlate();
            if (!plate.equals(passPlate)) {
                this.setPlateResult();
                return;
            }
        } else if (plate != null && plate.length() > 0 && (plate.length() < this.getMinPlateCharLength() || plate.length() > this.getMaxPlateCharLength())) {
            this.infoLabel2.setForeground(Color.decode("#FFD8E2"));
            this.infoLabel2.setText("\u8865\u5f55\u7684\u8f66\u724c\u53f7\u9519\u8bef");
            return;
        }
        if (this.scanTexts != null && (scancode = this.scanTexts.getText()) != null && (scancode = scancode.trim()).length() > 0 && (cost = (Cost)this.passSession.getAttribute("pass_cost")) != null && cost.getCash().doubleValue() > 0.0) {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            String msg = null;
            if (applicationService.isAlipayScanCode(scancode)) {
                if (!applicationService.isEnableAliPayCode()) {
                    this.scanTexts.setText("");
                    if (applicationService.isEnableWeixinPayCode()) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5931\u8d25!  \u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u53ef\u4f7f\u7528\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(this.passSession, "\u8bf7\u4f7f\u7528\u5fae\u4fe1\u4ed8\u6b3e\u7801\uff0c\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5931\u8d25!  \u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u5982\u679c\u9700\u8981\u5f00\u901a\u8bf7\u8054\u7cfb\u670d\u52a1\u5546", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    }
                    return;
                }
                msg = "\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else if (applicationService.isWeixinPayScanCode(scancode)) {
                if (!applicationService.isEnableWeixinPayCode()) {
                    this.scanTexts.setText("");
                    if (applicationService.isEnableAliPayCode()) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5931\u8d25!  \u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u53ef\u4f7f\u7528\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(this.passSession, "\u8bf7\u4f7f\u7528\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\uff0c\u5fae\u4fe1\u4ed8\u6b3e\u7801\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5931\u8d25!  \u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u5982\u679c\u9700\u8981\u5f00\u901a\u8bf7\u8054\u7cfb\u670d\u52a1\u5546", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(this.passSession, "\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    }
                    return;
                }
                msg = "\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else if (scancode.length() > 15 && scancode.length() < 27) {
                msg = "\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else {
                this.scanTexts.setText("");
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5931\u8d25! \u65e0\u6cd5\u8bc6\u522b\u7684\u4ed8\u6b3e\u7801: " + scancode + ", \u53ea\u652f\u6301\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u7684\u4ed8\u6b3e\u7801\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\u6216\u8f93\u5165", 4));
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.displayScanPayMsg(this.passSession, "\u672a\u80fd\u8bc6\u522b\u7684\u4ed8\u6b3e\u7801", "\u652f\u4ed8\u5931\u8d25", 8);
                return;
            }
            if (!ServiceUtil.getServiceContext().isConnectedCloud()) {
                this.scanTexts.setText("");
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, String.valueOf(msg) + "\u5931\u8d25! \u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc", 4));
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u5931\u8d25\uff0c\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "\u652f\u4ed8\u5931\u8d25", 8);
                return;
            }
            DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            sp.displayScanPayMsg(this.passSession, String.valueOf(msg) + "\u4e2d...", String.valueOf(msg) + "\u4e2d", 8);
            this.lockAllOp();
            this.waitPayingDialog = this.createWaitPayingDialog(msg, scancode);
            this.waitPayingDialog.setVisible(true);
            return;
        }
        if (this.doOkFinish.compareAndSet(false, true)) {
            try {
                this.doOK0();
            }
            finally {
                this.closeDialog();
            }
        }
    }

    public void doOK1() {
        String plate = this.plateTextPanel.getPlate();
        if (!this.isReadCard()) {
            if (plate == null || plate.length() < 6 || plate.length() > 9) {
                this.infoLabel2.setForeground(Color.decode("#FFD8E2"));
                this.infoLabel2.setText("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8f66\u724c");
                return;
            }
            if (!this.okButton.isEnabled()) {
                return;
            }
            String passPlate = this.passSession.getPassPlate();
            if (!plate.equals(passPlate)) {
                this.setPlateResult();
                return;
            }
        } else if (plate != null && plate.length() > 0) {
            if (plate.length() <= 3) {
                plate = null;
            }
            if (plate != null && plate.length() != 7 && plate.length() != 8) {
                this.infoLabel2.setForeground(Color.decode("#FFD8E2"));
                this.infoLabel2.setText("\u8865\u5f55\u7684\u8f66\u724c\u53f7\u9519\u8bef");
                return;
            }
        }
        if (this.doOkFinish.compareAndSet(false, true)) {
            try {
                this.doOK0();
            }
            finally {
                this.closeDialog();
            }
        }
    }

    private void doOK0() {
        if (this.isReadCard()) {
            String plate = this.plateTextPanel.getPlate();
            if (this.isValidPlateLength(plate)) {
                this.passSession.setAttribute("GUI_INPUT_PLATE", plate);
            } else {
                this.passSession.removeAttribute("GUI_INPUT_PLATE");
            }
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        Object object = PassExitConfirmPanel.this.passSession.getExeFilterLock();
                        synchronized (object) {
                            if (PassExitConfirmPanel.this.passSession.getAttribute("SavePassDataFilter.SAVEPASSDATASUCCESS") == null) {
                                PassExitConfirmPanel.this.passSession.setAttribute("GUI_OK", Boolean.TRUE);
                                ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(PassExitConfirmPanel.this.passSession, PassExitConfirmPanel.this.passSession.getConfirmPassFilter());
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (PassExitConfirmPanel.this.passSession != null) {
                            PassExitConfirmPanel.this.passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                            PassExitConfirmPanel.this.passSession.setAttribute("GUI_MAN_CANCEL", Boolean.TRUE);
                            PassExitConfirmPanel.this.passSession.setSessionState(PassSession.SessionState.CANCELED);
                        }
                        GuiLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", ex);
                        if (PassExitConfirmPanel.this.passSession == null) break block7;
                        String msg = PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + PassExitConfirmPanel.this.passSession.getReadPassportNumberEvent().getPassportNumber() : "";
                        String message = String.valueOf(PassExitConfirmPanel.this.passSession.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(PassExitConfirmPanel.this.passSession, message, 4));
                    }
                }
            }
        });
    }

    public void doCancel() {
        String adr;
        if (this.passSession != null && this.passSession.getReadPassportNumberEvent() != null && !this.passSession.getReadPassportNumberEvent().isManualTrigger() && (adr = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CARPARK_DIALOG_EXIT_CANCEL_STRATEGY")) != null && Constants.NO_STR.equals(adr)) {
            MacOptionDialog.showAlertDialog(this, "\u7981\u6b62\u653e\u884c\u53d6\u6d88", "\u62b1\u6b49\uff0c\u7ba1\u7406\u5458\u7981\u6b62\u4e86\u60a8\u53d6\u6d88\u653e\u884c\u64cd\u4f5c\u6743\u9650", null, "\u77e5\u9053\u4e86", null);
            return;
        }
        try {
            try {
                if (this.passSession.getOpenDialogCacnelRecord() != null) {
                    this.passSession.doSaveCancelPassRecrodIfExist(true, true);
                }
            }
            finally {
                this.doCancel0();
            }
        }
        finally {
            this.closeDialog();
        }
    }

    private void doCancel0() {
        if (this.passSession != null) {
            this.passSession.setAttribute("GUI_MAN_CANCEL", Boolean.TRUE);
            this.passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
            this.passSession.setSessionState(PassSession.SessionState.CANCELED);
        }
    }

    @Override
    public void onScanCodeFound(String scanCode) {
        if (this.scanTexts != null && this.scanTexts.isEditable()) {
            this.scanTexts.setText(scanCode);
        }
    }

    private WaitPayingDialog createWaitPayingDialog(String title, String scanCode) {
        WaitPayingDialog dialog = new WaitPayingDialog(this.confirmDialog, "\u7b49\u5f85" + title, false, this, scanCode);
        SwingUtil.setTransparent(dialog, 0.95f);
        int width = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 400.0 / 768.0);
        int hegiht = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 180.0 / 768.0);
        Dimension dialogSieze = new Dimension(width, hegiht);
        dialog.init(dialogSieze, this);
        Image logo = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("logo");
        dialog.setIconImage(logo);
        dialog.setTitleInfo("\u7b49\u5f85" + title);
        return dialog;
    }

    public void doSelectCarType(String carTypeName) {
        if (carTypeName == null || carTypeName.length() == 0) {
            return;
        }
        if (!this.confirmDialog.isSelectedPanel(this)) {
            return;
        }
        JComboBox<ComboBoxEntry<CarparkCarType>> carTypeSelect = this.carTypeSelect;
        if (carTypeSelect == null) {
            return;
        }
        if (!carTypeSelect.isEnabled()) {
            return;
        }
        if (!this.canactionCartype) {
            return;
        }
        ComboBoxEntry selectedCarTypeT = (ComboBoxEntry)((Object)carTypeSelect.getSelectedItem());
        if (selectedCarTypeT != null && carTypeName.equals(((CarparkCarType)selectedCarTypeT.getKey()).getCar_type_name())) {
            Cost cost = (Cost)this.passSession.getAttribute("pass_cost");
            if (cost != null && cost.getCash() != null && cost.getCash().doubleValue() > 0.0) {
                this.playCharge();
            }
            return;
        }
        int size = carTypeSelect.getItemCount();
        if (size == 0) {
            return;
        }
        CarparkCarType carType0 = null;
        int selectIndex = -1;
        int i = 0;
        while (i < size) {
            ComboBoxEntry<CarparkCarType> t = carTypeSelect.getItemAt(i);
            if (carTypeName.equals(((CarparkCarType)t.getKey()).getCar_type_name())) {
                selectIndex = i;
                carType0 = (CarparkCarType)t.getKey();
                break;
            }
            ++i;
        }
        if (carType0 != null && selectIndex != -1) {
            try {
                this.canactionCartype = false;
                carTypeSelect.setSelectedIndex(selectIndex);
            }
            finally {
                this.canactionCartype = false;
            }
            CarparkCarType t1 = this.passSession.getCarType();
            if (t1 == null || !carType0.getCar_type_no().equals(t1.getCar_type_no())) {
                this.passSession.setCarType(carType0);
                this.recharge0(new Runnable(){

                    @Override
                    public void run() {
                        Cost cost = (Cost)PassExitConfirmPanel.this.passSession.getAttribute("pass_cost");
                        if (cost != null && cost.getCash() != null && cost.getCash().doubleValue() > 0.0) {
                            PassExitConfirmPanel.this.playCharge();
                        }
                    }
                }, "carTypeNo", carType0.getCar_type_no());
            }
        }
    }

    @Override
    public void refreshPanel() {
        if (this.confirmDialog.isSelectedPanel(this)) {
            this.reSetInfo();
        } else {
            this.doSelectRsetInfo = true;
        }
    }

    private class SelectPicPnaelx
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton button = new JButton();
        private String querypassportNumber;
        private String reloadPlate;
        private boolean selected;

        SelectPicPnaelx(String passportNumber, Font font, String reloadPalte0) {
            this.setBackground(Color.decode("#ECF0F5"));
            this.button.setText(passportNumber);
            this.button.setFont(font);
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setRolloverEnabled(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.button, "Center");
            this.querypassportNumber = passportNumber;
            this.reloadPlate = reloadPalte0;
        }
    }

    private static class WaitPayingDialog
    extends MacDialog
    implements ActionListener,
    WindowListener,
    Runnable {
        private static final long serialVersionUID = 1L;
        private MainPassConfirmDialog confirmDialog;
        private JLabel watiPayResultLabel;
        private JLabel watiPayTimeLabel;
        private JButton cancelButton;
        private volatile int sec = 0;
        private ScheduledFuture<?> sc;
        private String orderNo;
        private String token;
        private volatile String state;
        private PassSession passSession;
        private String scanCode;
        private ApplicationService applicationService;
        private PassExitConfirmPanel confiremPanel;
        private long nextexequeryMill;
        private int maxTimeout = 40;
        private volatile boolean querying = false;

        public WaitPayingDialog(MainPassConfirmDialog confirmDialog, String title, boolean modal, PassExitConfirmPanel confiremPanel, String scanCode) {
            super(confirmDialog, title, modal);
            this.confirmDialog = confirmDialog;
            this.passSession = confiremPanel.passSession;
            this.scanCode = scanCode;
            this.applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            this.confiremPanel = confiremPanel;
        }

        @Override
        public int getTitileBarHeight() {
            return (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 30.0 / 900.0);
        }

        @Override
        protected int getTitleFontSize(int titleHeight) {
            return (int)Math.round(0.43333333333333335 * (double)titleHeight);
        }

        @Override
        protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
            body.setLayout(new XYLayout());
            this.watiPayResultLabel = new JLabel("\u652f\u4ed8\u8bf7\u6c42\u4e2d... ");
            int rbFontSize = (int)Math.round(this.confirmDialog.getCarparkMainFrame().getRootSize().getHeight() * 13.0 / 768.0);
            Font font13 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 0, rbFontSize);
            this.watiPayResultLabel.setHorizontalAlignment(0);
            this.watiPayResultLabel.setFont(font13);
            this.watiPayResultLabel.setForeground(Color.decode("#440800"));
            Font font16 = new Font(SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53"), 1, rbFontSize);
            this.watiPayTimeLabel = new JLabel(String.valueOf(this.sec));
            this.watiPayTimeLabel.setHorizontalAlignment(0);
            this.watiPayTimeLabel.setFont(font16);
            int rbWidth = (int)Math.round(panelSize.getWidth() * 70.0 / 300.0);
            this.cancelButton = new JButton("\u53d6\u6d88");
            this.cancelButton.setFont(font13);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setCursor(new Cursor(12));
            this.cancelButton.setToolTipText("\u70b9\u51fb\u53d6\u6d88\u4ed8\u6b3e\u7801\u652f\u4ed8");
            this.cancelButton.setEnabled(false);
            int h1 = (int)Math.round(panelSize.getHeight() * 35.0 / 200.0);
            int h2 = (int)Math.round(panelSize.getHeight() * 30.0 / 200.0);
            int margx = (int)Math.round(panelSize.getWidth() * 10.0 / 300.0);
            int margY = (panelSize.height - 2 * h1 - h2) / 3;
            int x = margx;
            int y = margY;
            int w = panelSize.width - 2 * margx;
            body.add((Component)this.watiPayResultLabel, new XYConstraints(x, y, w, h1));
            body.add((Component)this.watiPayTimeLabel, new XYConstraints(x, y += h1, w, h1));
            w = rbWidth;
            x = (panelSize.width - rbWidth) / 2;
            body.add((Component)this.cancelButton, new XYConstraints(x, y += h1 + margY, rbWidth, h2));
            this.addWindowListener(this);
        }

        @Override
        protected void onDispose() {
            try {
                if (this.sc != null && !this.sc.isCancelled()) {
                    this.sc.cancel(true);
                }
            }
            finally {
                this.passSession.removeAttribute("SCANCODE_PLAYING");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                try {
                    this.confiremPanel.scanTexts.setText("");
                    this.confiremPanel.unlockOp();
                    this.dispose();
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u5df2\u88ab\u53d6\u6d88,\u6b63\u5728\u5c1d\u8bd5\u64a4\u9500\u8ba2\u5355...", 4));
                }
                finally {
                    this.cancelPay();
                }
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.sc = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    Map<Object, Object> resultMap;
                    try {
                        passSession.setAttribute("SCANCODE_PLAYING", Boolean.TRUE);
                        resultMap = applicationService.doScanCodePay(scanCode, passSession, true);
                    }
                    catch (Exception ex) {
                        GuiLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                        resultMap = new HashMap<String, String>();
                        resultMap.put("RETURN_CODE", "ERROR");
                        resultMap.put("RETURN_VALUE", "\u5185\u90e8\u9519\u8bef");
                    }
                    final String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    final String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                    final String returnorderNo = (String)resultMap.get("orderNo");
                    state = RETURN_CODE;
                    SwingUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if ("SUCCESS".equals(RETURN_CODE)) {
                                if (this.isVisible()) {
                                    watiPayResultLabel.setText("\u652f\u4ed8\u6210\u529f\uff0c\u7b49\u5f85\u670d\u52a1\u5668\u901a\u77e5..");
                                }
                            } else if ("NEEDQUERY".equals(RETURN_CODE)) {
                                nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 7500L;
                                token = RETURN_VALUE;
                                orderNo = returnorderNo;
                                watiPayResultLabel.setText("\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c..");
                                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                sp.displayScanPayMsg(passSession, "\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e", "\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e", 8);
                            } else if ("USERPAYPWD".equals(RETURN_CODE)) {
                                nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 7500L;
                                token = RETURN_VALUE;
                                orderNo = returnorderNo;
                                watiPayResultLabel.setText("\u7b49\u5f85\u7528\u6237\u8f93\u5165\u5bc6\u7801..");
                                maxTimeout = 60;
                                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                sp.displayScanPayMsg(passSession, "\u8bf7\u5728\u624b\u673a\u4e2d\u8f93\u5165\u652f\u4ed8\u5bc6\u7801", "\u8bf7\u8f93\u5165\u652f\u4ed8\u5bc6\u7801", 8);
                            } else {
                                try {
                                    String errMsg = RETURN_VALUE;
                                    if (errMsg == null || errMsg.length() == 0) {
                                        errMsg = "\u652f\u4ed8\u5931\u8d25";
                                    }
                                    GuiLog.getLog().warn((Object)("\u4ed8\u6b3e\u7801\u652f\u4ed8\u5931\u8d25!\u539f\u56e0: " + errMsg));
                                    if (errMsg.indexOf("\u652f\u4ed8\u5931\u8d25") == -1) {
                                        errMsg = "\u652f\u4ed8\u5931\u8d25! " + errMsg;
                                    }
                                    confiremPanel.scanTexts.setText("");
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, errMsg, 4));
                                    DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                    sp.displayScanPayMsg(passSession, "\u652f\u4ed8\u5931\u8d25", "\u652f\u4ed8\u5931\u8d25", 8);
                                }
                                finally {
                                    confiremPanel.unlockOp();
                                    this.dispose();
                                }
                            }
                        }
                    });
                }
            });
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        private void cancelPay() {
            if (("NEEDQUERY".equals(this.state) || "USERPAYPWD".equals(this.state)) && this.token != null && this.token.length() > 0 && this.orderNo != null && this.orderNo.length() > 0) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, Object> resultMap = applicationService.doCancelScanPay(token, orderNo);
                        String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                        String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                        if ("SUCCESS".equals(RETURN_CODE)) {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u8ba2\u5355" + orderNo + "\u5df2\u88ab\u6210\u529f\u64a4\u9500", 2));
                        } else {
                            if (RETURN_VALUE == null || RETURN_VALUE.length() == 0) {
                                RETURN_VALUE = "\u8ba2\u5355\u64a4\u9500\u5931\u8d25!";
                            }
                            GuiLog.getLog().warn((Object)("\u64a4\u9500\u8ba2\u5355:" + orderNo + "\u5931\u8d25\uff01\u539f\u56e0\uff1a" + RETURN_VALUE));
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u64a4\u9500\u8ba2\u5355:" + orderNo + "\u5931\u8d25\uff01\u539f\u56e0\uff1a" + RETURN_VALUE, 4));
                        }
                    }
                });
            }
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitPayingDialog waitPayingDialog = this;
                    waitPayingDialog.sec = waitPayingDialog.sec + 1;
                    if (sec > maxTimeout) {
                        try {
                            confiremPanel.scanTexts.setText("");
                            confiremPanel.unlockOp();
                            this.dispose();
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u8d85\u65f6,\u6b63\u5728\u5c1d\u8bd5\u64a4\u9500\u8ba2\u5355...", 4));
                        }
                        finally {
                            this.cancelPay();
                        }
                    } else {
                        long sa;
                        if (sec >= 15 && !cancelButton.isEnabled()) {
                            cancelButton.setEnabled(true);
                        }
                        watiPayTimeLabel.setText(String.valueOf(sec));
                        if (("NEEDQUERY".equals(state) || "USERPAYPWD".equals(state)) && token != null && token.length() > 0 && orderNo != null && orderNo.length() > 0 && nextexequeryMill > 0L && !querying && (sa = ServiceUtil.getServiceContext().currentTimeMillis()) >= nextexequeryMill) {
                            querying = true;
                            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Map<String, Object> resultMap = applicationService.doQueryScanPayState(token, orderNo);
                                        final String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                                        final String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                                        state = RETURN_CODE;
                                        SwingUtil.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                if ("SUCCESS".equals(RETURN_CODE)) {
                                                    if (this.isVisible()) {
                                                        watiPayResultLabel.setText("\u652f\u4ed8\u6210\u529f\uff0c\u7b49\u5f85\u670d\u52a1\u5668\u901a\u77e5..");
                                                    }
                                                } else if ("NEEDQUERY".equals(RETURN_CODE)) {
                                                    GuiLog.getLog().info((Object)("\u6b63\u5728\u7b49\u5f85\u8ba2\u5355" + orderNo + "\u652f\u4ed8\u7ed3\u679c:  " + RETURN_VALUE));
                                                } else {
                                                    try {
                                                        String errMsg = RETURN_VALUE;
                                                        if (errMsg == null || errMsg.length() == 0) {
                                                            errMsg = "\u652f\u4ed8\u5931\u8d25";
                                                        }
                                                        GuiLog.getLog().warn((Object)("\u4ed8\u6b3e\u7801\u652f\u4ed8\u5931\u8d25!\u539f\u56e0: " + errMsg));
                                                        if (errMsg.indexOf("\u652f\u4ed8\u5931\u8d25") == -1) {
                                                            errMsg = "\u652f\u4ed8\u5931\u8d25! " + errMsg;
                                                        }
                                                        confiremPanel.scanTexts.setText("");
                                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, errMsg, 4));
                                                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                                        sp.displayScanPayMsg(passSession, "\u652f\u4ed8\u5931\u8d25", "\u652f\u4ed8\u5931\u8d25", 8);
                                                    }
                                                    finally {
                                                        confiremPanel.unlockOp();
                                                        this.dispose();
                                                    }
                                                }
                                            }
                                        });
                                    }
                                    finally {
                                        nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 5000L;
                                        querying = false;
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }
}

