/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.OperationFuture;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PicLoadUtil {
    public static void loadPic(final JLabel label, String picHost, String bigPic, final Dimension picSize, String smallPic, final Dimension rootSize, boolean onlyLocal) {
        try {
            final String enterCarPic = bigPic;
            final String enterPlatePic = smallPic;
            if (enterCarPic == null || enterCarPic.length() == 0) {
                label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                label.setText(null);
                return;
            }
            RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            String path = s.getLocalPicPath(enterCarPic);
            String localCarPath = null;
            String localPlatePath = null;
            File f1 = new File(path);
            if (f1.exists() && f1.isFile()) {
                localCarPath = f1.getAbsolutePath();
            } else {
                f1 = new File(enterCarPic);
                if (f1.exists() && f1.isFile()) {
                    localCarPath = f1.getAbsolutePath();
                }
            }
            if (enterPlatePic != null && enterPlatePic.length() > 0) {
                path = s.getLocalPicPath(enterPlatePic);
                f1 = new File(path);
                if (f1.exists() && f1.isFile()) {
                    localPlatePath = f1.getAbsolutePath();
                } else {
                    f1 = new File(enterPlatePic);
                    if (f1.exists() && f1.isFile()) {
                        localPlatePath = f1.getAbsolutePath();
                    }
                }
            }
            if (localCarPath != null) {
                BufferedImage image = PicLoadUtil.loadImage(localCarPath, localPlatePath, picSize, rootSize);
                if (image == null) {
                    label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                    label.setText(null);
                    return;
                }
                label.setIcon(new ImageIcon(image));
                label.setText(null);
            } else {
                if (onlyLocal || picHost == null || picHost.length() == 0) {
                    label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                    label.setText(null);
                    return;
                }
                ApplicationService appservice = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                ArrayList<String> s1 = new ArrayList<String>(2);
                s1.add(enterCarPic);
                if (enterPlatePic != null && enterPlatePic.length() > 0) {
                    s1.add(enterPlatePic);
                }
                PicLoadUtil.setLoading(label, "\u6b63\u5728\u52a0\u8f7d\u56fe\u7247...");
                OperationFuture<Map<String, BufferedImage>> op = appservice.asynLoadRemotePic(picHost, s1.toArray(new String[s1.size()]));
                op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Map<String, BufferedImage>>(){

                    public void operationComplete(OperationFuture<Map<String, BufferedImage>> xf) {
                        if (xf.isCancelled() || xf.getException() != null) {
                            this.setNopic();
                        } else {
                            Map mv = (Map)xf.getResult();
                            if (mv == null) {
                                this.setNopic();
                            } else {
                                final BufferedImage b1 = (BufferedImage)mv.get(enterCarPic);
                                if (b1 == null) {
                                    this.setNopic();
                                } else {
                                    final BufferedImage b2 = enterPlatePic != null && enterPlatePic.length() > 0 ? (BufferedImage)mv.get(enterPlatePic) : null;
                                    SwingUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            BufferedImage imsx = PicLoadUtil.createImage(b1, b2, picSize, rootSize);
                                            if (imsx == null) {
                                                label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                                                label.setText(null);
                                            } else {
                                                label.setIcon(new ImageIcon(imsx));
                                                label.setText(null);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    }

                    public void waitCompleteTimeout() {
                        this.setNopic();
                    }

                    private void setNopic() {
                        SwingUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                                label.setText(null);
                            }
                        });
                    }
                });
            }
        }
        catch (Exception ex) {
            GuiLog.getLog().warn((Object)"", (Throwable)ex);
            try {
                label.setIcon(PicLoadUtil.getNoPicImage(picSize));
                label.setText(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static BufferedImage loadImage(String path) {
        try {
            File f1;
            if (path != null && path.length() > 0 && (f1 = new File(path)).exists() && f1.isFile()) {
                return ImageIO.read(f1);
            }
        }
        catch (Throwable ex) {
            GuiLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247\u5f02\u5e38! \u8def\u5f84\uff1a" + path + ", \u539f\u56e0:" + ex.getMessage()));
            return null;
        }
        return null;
    }

    public static BufferedImage loadImage(String bigPath, String smallPath, Dimension picSize, Dimension rootSize) {
        BufferedImage bigImage = PicLoadUtil.loadImage(bigPath);
        if (bigImage == null) {
            return null;
        }
        BufferedImage smallImage = PicLoadUtil.loadImage(smallPath);
        return PicLoadUtil.createImage(bigImage, smallImage, picSize, rootSize);
    }

    public static BufferedImage createImage(BufferedImage bigImage, BufferedImage smallImage, Dimension picSize, Dimension rootSize) {
        BufferedImage newImage;
        if (bigImage == null) {
            return null;
        }
        if (picSize == null) {
            return bigImage;
        }
        int bigWith = picSize.width;
        int bigHeight = picSize.height;
        try {
            newImage = new BufferedImage(bigWith, bigHeight, bigImage.getType());
            Graphics g = newImage.getGraphics();
            try {
                Image image = bigImage.getScaledInstance(bigWith, bigHeight, 4);
                g.drawImage(image, 0, 0, null);
                if (smallImage != null) {
                    int smallHeight;
                    int smallWidth;
                    if (rootSize != null) {
                        int smallImageHegiht;
                        int smallImageWidth = smallImage.getWidth();
                        if (smallImageWidth > 110) {
                            smallImageWidth = 110;
                        }
                        if ((smallImageHegiht = smallImage.getHeight()) > 45) {
                            smallImageHegiht = 45;
                        }
                        smallWidth = (int)Math.round(rootSize.getWidth() * (double)smallImageWidth / 1280.0) - 10;
                        smallHeight = (int)Math.round(rootSize.getHeight() * (double)smallImageHegiht / 768.0);
                    } else {
                        smallWidth = 110;
                        smallHeight = 44;
                    }
                    if (smallWidth > bigWith) {
                        smallWidth = bigWith;
                    }
                    if (smallHeight > bigHeight) {
                        smallHeight = bigHeight;
                    }
                    Image i = SwingUtil.resizeImage((Image)smallImage, smallWidth, smallHeight);
                    int marginLeft = 0;
                    int marginBottom = 3;
                    int x = marginLeft;
                    int y = bigHeight - marginBottom - smallHeight;
                    if (y < 0) {
                        y = 0;
                    }
                    g.drawImage(i, x, y, null);
                }
            }
            finally {
                g.dispose();
            }
        }
        catch (Throwable ex) {
            try {
                return SwingUtil.resizeImage(bigImage, bigWith, bigHeight);
            }
            catch (Throwable ex1) {
                return bigImage;
            }
        }
        return newImage;
    }

    public static void setLoading(JLabel imageLabel, String msg) {
        Image load;
        int h1 = imageLabel.getHorizontalTextPosition();
        if (h1 != 11) {
            imageLabel.setHorizontalTextPosition(11);
        }
        if ((h1 = imageLabel.getVerticalTextPosition()) != 0) {
            imageLabel.setVerticalTextPosition(0);
        }
        if ((h1 = imageLabel.getHorizontalAlignment()) != 0) {
            imageLabel.setHorizontalAlignment(0);
        }
        if ((load = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("loading1")) == null) {
            imageLabel.setIcon(null);
        } else {
            imageLabel.setIcon(new ImageIcon(load));
        }
        imageLabel.setText(msg);
    }

    public static Image getNoPicImage0(Dimension picSize) {
        Image image = CarparkGuiSkinUtil.getCarparkGuiSkin().getImage("no_pic");
        if (image != null) {
            if (picSize == null) {
                return image;
            }
            return SwingUtil.resizeImage(image, picSize.width, picSize.height);
        }
        return null;
    }

    public static ImageIcon getNoPicImage(Dimension picSize) {
        Image image = PicLoadUtil.getNoPicImage0(picSize);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }
}

