/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PlateInputPanel
extends JPanel {
    private static final long serialVersionUID = 2357506792361993783L;
    private static LinkedHashSet<String> platesHeadSet;
    private static LinkedHashSet<String> platesTailSet;
    private JButton leftButton;
    private XYConstraints leftXYConstraints;
    private JTextField textField;
    private JButton rightButton;
    private XYConstraints rightXYConstraints;
    private JDialog leftDialog = null;
    private JDialog rightDialog = null;
    private Point panelLeftPonit;
    private Point panelRightPonit;
    private Dimension aBlockSize;
    private Font blockFont;
    private int borderSize;
    private Runnable onSelectRun;
    private static Dimension rootSize;

    static {
        String[] tail;
        String[] plates;
        platesHeadSet = new LinkedHashSet();
        platesTailSet = new LinkedHashSet();
        String[] stringArray = plates = new String[]{"\u4eac", "\u6d25", "\u6caa", "\u6e1d", "\u8499", "\u65b0", "\u85cf", "\u5b81", "\u6842", "\u8d35", "\u4e91", "\u9ed1", "\u5409", "\u8fbd", "\u664b", "\u5180", "\u9752", "\u9c81", "\u8c6b", "\u82cf", "\u7696", "\u6d59", "\u95fd", "\u8d63", "\u6e58", "\u9102", "\u7ca4", "\u743c", "\u7518", "\u9655", "\u5ddd", "\u6e2f", "\u6fb3", "\u4f7f", ""};
        int n = plates.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            platesHeadSet.add(s);
            ++n2;
        }
        String[] stringArray2 = tail = new String[]{"\u6302", "\u5b66", "\u8b66", "\u6e2f", "\u6fb3", "\u4f7f", "\u9886", ""};
        int n3 = tail.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            platesTailSet.add(s);
            ++n;
        }
    }

    public static Dimension getRootSize() {
        if (rootSize == null) {
            rootSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return rootSize;
    }

    public static void setRootSize(Dimension d) {
        rootSize = d;
    }

    public PlateInputPanel(Dimension leftRightsize, Dimension textSize, Font font, Point panelLeftPonit, Point panelRightPonit, int borderSize, Runnable onSelectRun) {
        this.aBlockSize = leftRightsize;
        this.blockFont = font;
        this.panelLeftPonit = panelLeftPonit;
        this.panelRightPonit = panelRightPonit;
        this.borderSize = borderSize;
        this.onSelectRun = onSelectRun;
        this.setLayout(new XYLayout());
        this.setBackground(Color.decode("#F0F0F0"));
        Color borderColor = Color.decode("#959B9E");
        this.setBorder(BorderFactory.createLineBorder(borderColor, 1));
        this.leftButton = new JButton("");
        this.leftButton.setFont(font);
        this.leftButton.setBorderPainted(false);
        this.leftButton.setContentAreaFilled(false);
        this.leftButton.setCursor(new Cursor(12));
        this.textField = new JTextField();
        this.textField.setBackground(Color.WHITE);
        this.textField.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.WHITE));
        this.textField.setFont(font);
        this.rightButton = new JButton("");
        this.rightButton.setCursor(new Cursor(12));
        this.rightButton.setBorderPainted(false);
        this.rightButton.setContentAreaFilled(false);
        this.rightButton.setFont(font);
        int x = 0;
        int y = 0;
        int w = leftRightsize.width;
        int h = leftRightsize.height;
        this.leftXYConstraints = new XYConstraints(x, y, w, h);
        this.add((Component)this.leftButton, this.leftXYConstraints);
        x += w;
        w = textSize.width;
        this.add((Component)this.textField, new XYConstraints(x, y + 3, w, h - 6));
        x += w;
        w = leftRightsize.width;
        this.rightXYConstraints = new XYConstraints(x, y, w, h);
        this.add((Component)this.rightButton, this.rightXYConstraints);
    }

    public JButton getLeftButton() {
        return this.leftButton;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getRightButton() {
        return this.rightButton;
    }

    public void distory0() {
        this.closeAllDialog();
    }

    public void closeAllDialog() {
        if (this.leftDialog != null && this.leftDialog.isVisible()) {
            this.leftDialog.dispose();
        }
        if (this.rightDialog != null && this.rightDialog.isVisible()) {
            this.rightDialog.dispose();
        }
    }

    public void popDialog(final boolean left) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (left) {
                    PlateInputPanel.this.showLeftDialog();
                } else {
                    PlateInputPanel.this.showRightDialog();
                }
            }
        });
    }

    private void showLeftDialog() {
        if (this.rightDialog != null && this.rightDialog.isVisible()) {
            this.rightDialog.dispose();
        }
        if (this.leftDialog == null || !this.leftDialog.isVisible()) {
            JDialog j = this.createDialog(this.leftButton, platesHeadSet, this.leftButton.getText(), this.blockFont, 7, this.aBlockSize, this.onSelectRun);
            if (this.panelLeftPonit != null) {
                j.setLocation(new Point(this.panelLeftPonit.x + this.leftXYConstraints.getX(), this.panelLeftPonit.y + this.leftXYConstraints.getY() + this.leftXYConstraints.getHeight()));
            } else {
                Point leftButtonP = this.leftButton.getLocationOnScreen();
                int x = leftButtonP.x;
                int y = leftButtonP.y + this.leftXYConstraints.getHeight();
                int tw = x + j.getWidth() + 5;
                int th = y + j.getHeight() + 5;
                Dimension maxSize = PlateInputPanel.getRootSize();
                if (tw > maxSize.width) {
                    x -= tw - maxSize.width;
                }
                if (th > maxSize.height) {
                    y -= th - maxSize.height;
                }
                j.setLocation(x, y);
            }
            this.leftDialog = j;
            j.setVisible(true);
        } else {
            this.leftDialog.dispose();
        }
    }

    private void showRightDialog() {
        if (this.leftDialog != null && this.leftDialog.isVisible()) {
            this.leftDialog.dispose();
        }
        if (this.rightDialog == null || !this.rightDialog.isVisible()) {
            int cos = 8;
            JDialog j = this.createDialog(this.rightButton, platesTailSet, this.rightButton.getText(), this.blockFont, cos, this.aBlockSize, this.onSelectRun);
            if (this.panelRightPonit != null) {
                int y = this.panelRightPonit.y + this.rightXYConstraints.getY() + this.rightXYConstraints.getHeight();
                int x = this.panelRightPonit.x + this.rightXYConstraints.getX() + this.rightXYConstraints.getWidth() - j.getWidth() - 2;
                j.setLocation(new Point(x, y));
            } else {
                Point rightButtonP = this.rightButton.getLocationOnScreen();
                int x = rightButtonP.x + this.rightXYConstraints.getWidth() - j.getWidth();
                int y = rightButtonP.y + this.rightXYConstraints.getHeight();
                j.setLocation(new Point(x, y));
            }
            this.rightDialog = j;
            j.setVisible(true);
        } else {
            this.rightDialog.dispose();
        }
    }

    private JDialog createDialog(final Component textconpent, Set<String> labels, String defaultValue, Font font, int cols, Dimension blcokSize, final Runnable onselect) {
        Window window;
        if (defaultValue == null) {
            defaultValue = "";
        }
        final JDialog dialog = (window = SwingUtil.getWindowForComponent(textconpent)) instanceof Frame ? new JDialog((Frame)window, "", false) : new JDialog((Dialog)window, "", false);
        dialog.setUndecorated(true);
        if (cols <= 0) {
            cols = 1;
        }
        int rows = labels.size() % cols == 0 ? labels.size() / cols : labels.size() / cols + 1;
        int magin = 5;
        GridLayout gridLayOut = new GridLayout(rows, cols, magin, magin);
        if (blcokSize == null) {
            blcokSize = new Dimension(30, 30);
        }
        int width = (blcokSize.width + 2 * this.borderSize) * cols + (cols + 1) * magin;
        int height = blcokSize.height * rows + (rows + 1) * magin;
        dialog.setSize(new Dimension(width, height));
        JPanel Panel0 = new JPanel();
        Panel0.setBackground(Color.WHITE);
        Panel0.setLayout(new XYLayout());
        JPanel panel = new JPanel();
        Panel0.add((Component)panel, new XYConstraints(magin, magin, width - 2 * magin, height - 2 * magin));
        panel.setBackground(Panel0.getBackground());
        panel.setLayout(gridLayOut);
        Color bgColor = Color.decode("#FAFAFA");
        Border lineBorder = BorderFactory.createLineBorder(Color.decode("#D1D9DE"), this.borderSize);
        Color fontColor = Color.decode("#758697");
        ActionListener bux = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = e.getActionCommand();
                if (s != null) {
                    if (textconpent instanceof JButton) {
                        ((JButton)textconpent).setText(s);
                    } else if (textconpent instanceof JLabel) {
                        ((JLabel)textconpent).setText(s);
                    }
                }
                dialog.dispose();
                if (onselect != null) {
                    onselect.run();
                }
            }
        };
        Cursor cs = new Cursor(12);
        for (String s : labels) {
            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(1, 1));
            p1.setBorder(lineBorder);
            JButton b = new JButton(s);
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            b.setFont(font);
            b.setActionCommand(s);
            b.addActionListener(bux);
            b.setCursor(cs);
            if (s.equals(defaultValue)) {
                b.setForeground(Color.WHITE);
                p1.setBackground(Color.decode("#38A0F4"));
            } else {
                b.setForeground(fontColor);
                p1.setBackground(bgColor);
            }
            p1.add(b);
            panel.add(p1);
        }
        dialog.getContentPane().add(Panel0);
        return dialog;
    }

    public String getPlate() {
        String v2;
        String v3;
        String v1 = this.leftButton.getText();
        if (v1 == null) {
            v1 = "";
        }
        if ((v3 = this.rightButton.getText()) == null) {
            v3 = "";
        }
        v2 = (v2 = this.textField.getText()) == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(this.textField.getText())) {
            this.textField.setText(v2);
        }
        return String.valueOf(v1) + v2 + v3;
    }

    public void setPlate(final String carplate) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                String plate = carplate.trim();
                if (plate == null || plate.length() == 0) {
                    PlateInputPanel.this.leftButton.setText("");
                    PlateInputPanel.this.textField.setText("");
                    PlateInputPanel.this.rightButton.setText("");
                } else if (plate.length() == 1) {
                    if (platesHeadSet.contains(plate)) {
                        PlateInputPanel.this.leftButton.setText(plate);
                        PlateInputPanel.this.textField.setText("");
                        PlateInputPanel.this.rightButton.setText("");
                    } else {
                        PlateInputPanel.this.leftButton.setText("");
                        PlateInputPanel.this.textField.setText(plate);
                        PlateInputPanel.this.rightButton.setText("");
                    }
                } else {
                    String head = plate.substring(0, 1);
                    if (platesHeadSet.contains(head)) {
                        plate = plate.substring(1, plate.length());
                        PlateInputPanel.this.leftButton.setText(head);
                    } else {
                        PlateInputPanel.this.leftButton.setText("");
                    }
                    String last = plate.substring(plate.length() - 1, plate.length());
                    if (platesTailSet.contains(last)) {
                        plate = plate.substring(0, plate.length() - 1);
                        PlateInputPanel.this.rightButton.setText(last);
                    } else {
                        PlateInputPanel.this.rightButton.setText("");
                    }
                    PlateInputPanel.this.textField.setText(plate);
                }
            }
        });
    }

    public void disable0() {
        this.leftButton.setEnabled(false);
        this.textField.setEnabled(false);
        this.rightButton.setEnabled(false);
    }

    public void enable0() {
        this.leftButton.setEnabled(true);
        this.textField.setEnabled(true);
        this.rightButton.setEnabled(true);
    }
}

