/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.gui.login.CarparkMainFrame;
import com.wovoe.carpark.gui.login.GotoPageHandler;
import com.wovoe.carpark.gui.login.MainSearchDialog;
import com.wovoe.carpark.gui.login.PaginationPanel;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class RegisterPassportSearchDialog
extends MainSearchDialog
implements GotoPageHandler,
ActionListener {
    private static final long serialVersionUID = 1611902195748503281L;
    private static RegisterPassportSearchDialog instance;
    private PaginationPanel pagePanel;
    private JComboBox<ComboBoxEntry<String>> passportTypeSelect;
    private JTextField plateSeach;
    private JComboBox<ComboBoxEntry<String>> arrSelect;
    private JTextField attrTextField;
    private JButton searchButton;
    private JTable eqTable;
    private JScrollPane resultTablePanel;
    private static int recordPageSize;

    static {
        recordPageSize = 15;
    }

    public static boolean isDShowing() {
        RegisterPassportSearchDialog instance0 = instance;
        return instance0 != null && instance0.isVisible();
    }

    public static RegisterPassportSearchDialog getInstance() {
        return instance;
    }

    public static void showDialog(CarparkMainFrame frame) {
        if (instance != null && instance.isVisible()) {
            instance.toFront();
            return;
        }
        instance = new RegisterPassportSearchDialog(frame);
        instance.setTitleInfo("\u6708\u5361\u67e5\u8be2");
        instance.setVisible(true);
        instance.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    public static void colseIfShow() {
        if (instance != null && instance.isVisible()) {
            instance.dispose();
            instance = null;
        }
    }

    @Override
    protected void doPressCloseButton() {
        super.doPressCloseButton();
        instance = null;
    }

    protected RegisterPassportSearchDialog(CarparkMainFrame frame) {
        super(frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null) {
            return;
        }
        if ("passportTypeSelect".equals(cmd) || "querybutton".equals(cmd)) {
            this.gotoPage(1, recordPageSize, -1, 0, 0);
        }
    }

    @Override
    protected void onPressEnter() {
        this.gotoPage(1, recordPageSize, -1, 0, 0);
    }

    private String getPlate() {
        String x = this.plateSeach.getText();
        String v2 = x;
        v2 = v2 == null ? "" : v2.trim();
        v2 = v2.toUpperCase();
        v2 = v2.replaceAll("\u3000", "");
        v2 = v2.replaceAll(" ", "");
        if (!(v2 = v2.replaceAll("I", "1")).equals(x)) {
            this.plateSeach.setText(v2);
        }
        return v2;
    }

    @Override
    public void gotoPage(int goPage, int pageSize, int recordsCount, int currentPage, int totalPages) {
        String v;
        String atrrValue;
        final Pagination pagination = new Pagination();
        if (recordsCount < 0) {
            pagination.setNeedQueryCount(true);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
        } else {
            pagination.setNeedQueryCount(false);
            pagination.setPageSize(pageSize);
            pagination.setGotoPage(goPage);
            pagination.setRecordsCount((long)recordsCount);
        }
        final String plate = this.getPlate();
        String passport_type_no = null;
        ComboBoxEntry entry = (ComboBoxEntry)((Object)this.passportTypeSelect.getSelectedItem());
        if (entry != null) {
            passport_type_no = (String)entry.getKey();
        }
        if ((atrrValue = this.attrTextField.getText()) != null && !(v = atrrValue.trim()).equals(atrrValue)) {
            this.attrTextField.setText(v);
            atrrValue = v;
        }
        KeyValueEntry likeEntry = null;
        String ref_plate = null;
        if (atrrValue != null && atrrValue.length() > 0 && (entry = (ComboBoxEntry)((Object)this.arrSelect.getSelectedItem())) != null) {
            if ("ref_plate".equals(entry.getKey())) {
                ref_plate = atrrValue.trim();
                ref_plate = ref_plate.toUpperCase();
                ref_plate = ref_plate.replaceAll("\u3000", "");
                ref_plate = ref_plate.replaceAll(" ", "");
                ref_plate = ref_plate.replaceAll("I", "1");
            } else {
                likeEntry = new KeyValueEntry((Object)((String)entry.getKey()), (Object)atrrValue);
            }
        }
        String q_passport_type_no = passport_type_no;
        final SearchParam queryParam = this.getSearchParam(plate, q_passport_type_no, likeEntry);
        final String refPlate = ref_plate;
        if (!this.searchButton.isEnabled()) {
            return;
        }
        this.searchButton.setEnabled(false);
        this.bodyPanel.setCursor(new Cursor(3));
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList recordList;
                    ArrayList rList = null;
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    if (refPlate != null && refPlate.length() > 0) {
                        SearchParam p = new SearchParam(commonDaoService.getTableName(CarparkPassport.class));
                        p.addLike("register_plate", refPlate);
                        p.setQueryFields(new String[]{"id", "car_owner_no"});
                        p.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                        List list = commonDaoService.selectList(p, null);
                        if (list == null || list.isEmpty()) {
                            rList = new ArrayList(0);
                            pagination.setRecordsCount(0L);
                            pagination.calculatePage();
                        } else {
                            HashSet<String> cownerNos = new HashSet<String>();
                            for (Map m : list) {
                                String car_owner_no = (String)m.get("car_owner_no");
                                if (car_owner_no == null || car_owner_no.length() <= 0) continue;
                                cownerNos.add(car_owner_no);
                            }
                            if (cownerNos.isEmpty()) {
                                if (plate == null || plate.length() == 0) {
                                    queryParam.addLike("a.register_plate", refPlate);
                                }
                            } else if (cownerNos.size() == 1) {
                                queryParam.addEQ("a.car_owner_no", ServiceUtil.getFirstElement(cownerNos));
                            } else {
                                queryParam.addINList("a.car_owner_no", cownerNos);
                            }
                        }
                    }
                    if (rList == null) {
                        rList = commonDaoService.selectList(queryParam, pagination);
                    }
                    if ((recordList = rList) != null && !recordList.isEmpty()) {
                        SearchParam sp1;
                        HashSet<String> cownerNos = new HashSet<String>();
                        HashSet<String> plateNos = new HashSet<String>();
                        for (Map map : recordList) {
                            String register_plate = (String)map.get("register_plate");
                            String car_owner_no = (String)map.get("car_owner_no");
                            if (register_plate != null && register_plate.length() > 0) {
                                cownerNos.add(register_plate);
                            }
                            if (car_owner_no != null && car_owner_no.length() > 0) {
                                cownerNos.add(car_owner_no);
                            }
                            if (register_plate == null || register_plate.length() <= 0) continue;
                            plateNos.add(register_plate);
                        }
                        HashMap<String, Number> takeSpacesMap = new HashMap<String, Number>();
                        HashMap<String, String> enterInfo = new HashMap<String, String>();
                        if (!plateNos.isEmpty()) {
                            sp1 = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                            sp1.setQueryFields(new String[]{"id", "enter_time", "area_name", "enter_plate", "enter_channel_name"});
                            if (plateNos.size() == 1) {
                                sp1.addEQ("enter_plate", ServiceUtil.getFirstElement(plateNos));
                            } else {
                                sp1.addINList("enter_plate", plateNos);
                            }
                            sp1.addEQ("area_level", (Object)1);
                            sp1.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            List list1 = commonDaoService.selectList(sp1, null);
                            if (list1 != null && !list1.isEmpty()) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                for (Map en : list1) {
                                    String enter_plate = (String)en.get("enter_plate");
                                    Date enter_time = (Date)en.get("enter_time");
                                    String enter_channel_name = (String)en.get("enter_channel_name");
                                    if (enter_plate == null || enter_plate.length() <= 0 || enter_time == null) continue;
                                    enterInfo.put(enter_plate, String.valueOf(df.format(enter_time)) + ", " + enter_channel_name);
                                }
                            }
                        }
                        if (!cownerNos.isEmpty()) {
                            HashMap<String, Integer> zmap;
                            CarparkPassportType t;
                            sp1 = new SearchParam(commonDaoService.getTableName(CarparkPassport.class));
                            sp1.setQueryFields(new String[]{"car_owner_no", "register_plate", "passport_type_no"});
                            if (cownerNos.size() == 1) {
                                sp1.addEQ("car_owner_no", ServiceUtil.getFirstElement(cownerNos));
                            } else {
                                sp1.addINList("car_owner_no", cownerNos);
                            }
                            sp1.addEQ("medium_type", (Object)6);
                            sp1.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            List pateList = commonDaoService.selectList(sp1, null);
                            HashSet<String> passportTypeNos = new HashSet<String>();
                            HashMap<String, LinkedList<String>> plateListMap = new HashMap<String, LinkedList<String>>();
                            HashSet<String> queryPlates = new HashSet<String>();
                            for (Map map : pateList) {
                                String passport_type_no;
                                String car_owner_no = (String)map.get("car_owner_no");
                                String register_plate = (String)map.get("register_plate");
                                if (car_owner_no != null && car_owner_no.length() > 0 && register_plate != null && register_plate.length() > 0) {
                                    LinkedList<String> list = (LinkedList<String>)plateListMap.get(car_owner_no);
                                    if (list == null) {
                                        list = new LinkedList<String>();
                                        plateListMap.put(car_owner_no, list);
                                    }
                                    list.add(register_plate);
                                }
                                if ((passport_type_no = (String)map.get("passport_type_no")) == null || passport_type_no.length() <= 0) continue;
                                passportTypeNos.add(passport_type_no);
                                t = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport_type_no);
                                if (t == null || t.getUse_muti_car() != 1 || t.getPass_type() != 2 && t.getPass_type() != 4 && t.getPass_type() != 0 || register_plate == null || register_plate.length() <= 0) continue;
                                queryPlates.add(register_plate);
                            }
                            if (queryPlates != null && !queryPlates.isEmpty()) {
                                sp1 = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                                sp1.setQueryFields(new String[]{"COUNT(id) AS count", "car_owner_no"});
                                if (queryPlates.size() == 1) {
                                    sp1.addEQ("enter_plate", ServiceUtil.getFirstElement(queryPlates));
                                } else {
                                    sp1.addINList("enter_plate", queryPlates);
                                }
                                sp1.addEQ("area_level", (Object)1);
                                sp1.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                sp1.setGoupbySql("car_owner_no");
                                List list1 = commonDaoService.selectList(sp1, null);
                                if (list1 != null && !list1.isEmpty()) {
                                    for (Map entr : list1) {
                                        String owner = (String)entr.get("car_owner_no");
                                        Number count = (Number)entr.get("count");
                                        if (owner == null || owner.length() <= 0 || count == null) continue;
                                        takeSpacesMap.put(owner, count);
                                    }
                                }
                            }
                            HashMap carOwnerSpaceMap = new HashMap();
                            HashMap<String, Integer> passSpaceTypeNumMap = new HashMap<String, Integer>();
                            HashMap<String, CarparkPassportType> passSpaceTypeMap = new HashMap<String, CarparkPassportType>();
                            if (passportTypeNos != null && !passportTypeNos.isEmpty()) {
                                for (String passportTypeNo : passportTypeNos) {
                                    t = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passportTypeNo);
                                    if (t == null || t.getUse_muti_car() != 1 || t.getPass_type() != 2 && t.getPass_type() != 4) continue;
                                    passSpaceTypeMap.put(t.getPassport_type_no(), t);
                                    String strategy_value = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSPORTTYPE_SPACE_NUM");
                                    int num = 1;
                                    if (strategy_value != null && strategy_value.length() > 0) {
                                        try {
                                            num = Integer.parseInt(strategy_value);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (num < 1) {
                                            num = 1;
                                        } else if (num > 1000) {
                                            num = 1000;
                                        }
                                    }
                                    passSpaceTypeNumMap.put(t.getPassport_type_no(), num);
                                }
                            }
                            for (Map map : pateList) {
                                Integer x;
                                String car_owner_no = (String)map.get("car_owner_no");
                                String passport_type_no = (String)map.get("passport_type_no");
                                if (car_owner_no == null || car_owner_no.length() <= 0 || passport_type_no == null || passport_type_no.length() <= 0 || !passSpaceTypeNumMap.containsKey(passport_type_no)) continue;
                                Integer nun = (Integer)passSpaceTypeNumMap.get(passport_type_no);
                                zmap = (HashMap<String, Integer>)carOwnerSpaceMap.get(car_owner_no);
                                if (zmap == null) {
                                    zmap = new HashMap<String, Integer>();
                                    carOwnerSpaceMap.put(car_owner_no, zmap);
                                }
                                if ((x = (Integer)zmap.get(passport_type_no)) == null) {
                                    zmap.put(passport_type_no, nun);
                                    continue;
                                }
                                zmap.put(passport_type_no, nun + x);
                            }
                            for (Map map : recordList) {
                                String enterV;
                                String register_plate = (String)map.get("register_plate");
                                String car_owner_no = (String)map.get("car_owner_no");
                                if (car_owner_no != null && car_owner_no.length() > 0) {
                                    Number taked = (Number)takeSpacesMap.get(car_owner_no);
                                    map.put("take_space_count", taked == null ? "0" : taked.toString());
                                    zmap = (Map)carOwnerSpaceMap.get(car_owner_no);
                                    int total = 0;
                                    if (zmap != null && !zmap.isEmpty()) {
                                        for (Integer a : zmap.values()) {
                                            total += a.intValue();
                                        }
                                    }
                                    map.put("space_count", String.valueOf(total));
                                }
                                if ((enterV = (String)enterInfo.get(register_plate)) != null) {
                                    map.put("enter_info", enterV);
                                    continue;
                                }
                                map.put("enter_info", "\u4e0d\u5728\u573a");
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RegisterPassportSearchDialog.this.eqTable.setModel(new SetTableModel(recordList));
                                RegisterPassportSearchDialog.this.pagePanel.setPagination(pagination, "\u603b\u8bb0\u5f55\u6570:" + pagination.getRecordsCount() + "\uff0c\u6bcf\u9875\u663e\u793a:" + pagination.getPageSize() + "\uff0c\u5f53\u524d/\u603b\u9875:" + pagination.getCurrentPage() + "/" + pagination.getTotalPages());
                            }
                            finally {
                                RegisterPassportSearchDialog.this.searchButton.setEnabled(true);
                                (this).RegisterPassportSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    RegisterPassportSearchDialog.this.searchButton.setEnabled(true);
                    RegisterPassportSearchDialog.this.bodyPanel.setCursor(new Cursor(0));
                    GuiLog.getLog().warn((Object)"", ex);
                }
            }
        });
    }

    private SearchParam getSearchParam(String plate, String passport_type_no, KeyValueEntry ... serchParmLikes) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String qStr = String.valueOf(commonDaoService.getTableName(CarparkPassport.class)) + " a LEFT JOIN " + commonDaoService.getTableName(CarparkCarOwner.class) + " b ON a.car_owner_no=b.car_owner_no AND a.carpark_id=b.carpark_id AND a.project_id=b.project_id ";
        SearchParam p = new SearchParam(qStr);
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("a.*");
        selectFields.add("b.remark AS remark1");
        String[] clientNames = commonDaoService.getColumnNames(commonDaoService.getTableName(CarparkCarOwner.class));
        Set<String> notX = ServiceUtil.toSet("id", "car_owner_no", "remark", "created_time", "last_updated_time", "project_id", "carpark_id");
        String[] stringArray = clientNames;
        int n = clientNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!notX.contains(s)) {
                selectFields.add("b." + s);
            }
            ++n2;
        }
        if (plate != null && plate.length() > 0) {
            p.addLike("a.register_plate", plate);
        }
        if (passport_type_no != null && passport_type_no.length() > 0) {
            p.addEQ("a.passport_type_no", (Object)passport_type_no);
        }
        if (serchParmLikes != null && serchParmLikes.length > 0) {
            stringArray = serchParmLikes;
            n = serchParmLikes.length;
            n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (e != null && e.getKey() != null && e.getValue() != null && e.getValue() instanceof String && ((String)e.getValue()).length() > 0) {
                    p.addLike((String)e.getKey(), (String)e.getValue());
                }
                ++n2;
            }
        }
        p.setOrerbySql("a.car_owner_no DESC, a.id DESC");
        return p;
    }

    @Override
    protected void init(JPanel bodyPanel, Dimension bodySize, Dimension mainSize) {
        bodyPanel.setLayout(new XYLayout());
        Color cl = Color.decode("#222222");
        int fontSize = (int)Math.round(mainSize.getHeight() * 13.0 / 768.0);
        Font font = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, fontSize);
        int searchTWidth = (int)Math.round(mainSize.getWidth() * 70.0 / 1280.0);
        int searchHeight = (int)Math.round(mainSize.getHeight() * 28.0 / 768.0);
        int searchAttrWidth = (int)Math.round(mainSize.getWidth() * 110.0 / 1280.0);
        int searchMarginTop = (int)Math.round(mainSize.getHeight() * 15.0 / 768.0);
        int grap = (int)Math.round(mainSize.getWidth() * 30.0 / 1280.0);
        int searchButtonWidth = 5 * fontSize;
        int textWidth = (bodySize.width - searchButtonWidth - 2 * searchTWidth - searchAttrWidth - 3 * grap) / 3;
        int x = 0;
        int y = searchMarginTop;
        int w = searchTWidth;
        int h = searchHeight;
        JLabel lable = new JLabel("\u8f66\u724c\u7c7b\u578b");
        lable.setFont(font);
        lable.setForeground(cl);
        bodyPanel.add((Component)lable, new XYConstraints(x, y, w, h));
        Map<String, CarparkPassportType> allTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        Vector<ComboBoxEntry<String>> allPassType = new Vector<ComboBoxEntry<String>>();
        allPassType.add(new ComboBoxEntry<String>("", "\u6240\u6709\u7c7b\u578b"));
        if (allTypeMap != null) {
            for (CarparkPassportType t : allTypeMap.values()) {
                allPassType.add(new ComboBoxEntry<String>(t.getPassport_type_no(), t.getPassport_type_name()));
            }
        }
        this.passportTypeSelect = new JComboBox(allPassType);
        this.passportTypeSelect.setBackground(Color.WHITE);
        this.passportTypeSelect.setFont(font);
        this.passportTypeSelect.setActionCommand("passportTypeSelect");
        this.passportTypeSelect.addActionListener(this);
        x += w;
        w = textWidth;
        bodyPanel.add(this.passportTypeSelect, new XYConstraints(x, y, w, h));
        x += w + grap;
        w = searchTWidth;
        lable = new JLabel("\u6ce8\u518c\u8f66\u724c");
        lable.setFont(font);
        lable.setForeground(cl);
        bodyPanel.add((Component)lable, new XYConstraints(x, y, w, h));
        this.plateSeach = new JTextField();
        this.plateSeach.setFont(font);
        this.plateSeach.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RegisterPassportSearchDialog.this.getPlate();
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        x += w;
        w = textWidth;
        bodyPanel.add((Component)this.plateSeach, new XYConstraints(x, y, w, h));
        Vector<ComboBoxEntry<String>> arrt = new Vector<ComboBoxEntry<String>>();
        arrt.add(new ComboBoxEntry<String>("ref_plate", "\u5173\u8054\u8f66\u724c"));
        arrt.add(new ComboBoxEntry<String>("b.address", "\u8f66\u4e3b\u4f4f\u5740"));
        arrt.add(new ComboBoxEntry<String>("b.car_owner_name", "\u8f66\u4e3b\u59d3\u540d"));
        Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
        if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
            for (CarparkAttribute t : carOwnerAttrMap.values()) {
                arrt.add(new ComboBoxEntry<String>("b." + t.getAttribute_key(), t.getAttribute_value()));
            }
        }
        this.arrSelect = new JComboBox(arrt);
        this.arrSelect.setBackground(Color.WHITE);
        this.arrSelect.setFont(font);
        x += w + grap;
        w = searchAttrWidth;
        bodyPanel.add(this.arrSelect, new XYConstraints(x, y, w, h));
        this.attrTextField = new JTextField();
        this.attrTextField.setFont(font);
        x += w;
        w = textWidth;
        bodyPanel.add((Component)this.attrTextField, new XYConstraints(x, y, w, h));
        this.searchButton = new JButton("\u67e5\u8be2");
        this.searchButton.setActionCommand("querybutton");
        this.searchButton.addActionListener(this);
        this.searchButton.setFont(font);
        this.searchButton.setCursor(new Cursor(12));
        x += w + grap;
        w = searchButtonWidth;
        bodyPanel.add((Component)this.searchButton, new XYConstraints(x, y, w, h));
        this.pagePanel = new PaginationPanel();
        this.pagePanel.setGotoPageHandler(this);
        this.pagePanel.setBackground(bodyPanel.getBackground());
        int pagePanelHeight = (int)Math.round(mainSize.getHeight() * 28.0 / 768.0);
        int apagePanelWidth = (int)Math.round(mainSize.getHeight() * 38.0 / 768.0);
        int apagePanelMarButtom = (int)Math.round(mainSize.getHeight() * 8.0 / 768.0);
        int pagePanelWidth = bodySize.width;
        int pagePanelX = 0;
        int pagePanelY = bodySize.height - pagePanelHeight - apagePanelMarButtom;
        bodyPanel.add((Component)this.pagePanel, new XYConstraints(pagePanelX, pagePanelY, pagePanelWidth, pagePanelHeight));
        this.pagePanel.setInitPagePanelWidth(apagePanelWidth);
        this.pagePanel.init(new Dimension(pagePanelWidth, pagePanelHeight), mainSize, 7);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.setBackground(bodyPanel.getBackground());
        int dataMarginTop = (int)Math.round(mainSize.getHeight() * 16.0 / 768.0);
        int dataMarginBottom = (int)Math.round(mainSize.getHeight() * 9.0 / 768.0);
        int dataPanelX = 0;
        int dataPanelY = y + h + dataMarginTop;
        int dataPanelWidth = bodySize.width;
        int dataPanelHeight = pagePanelY - dataMarginBottom - dataPanelY;
        bodyPanel.add((Component)dataPanel, new XYConstraints(dataPanelX, dataPanelY, dataPanelWidth, dataPanelHeight));
        int rowHeight = (int)Math.round(mainSize.getHeight() * 28.0 / 768.0);
        this.eqTable = new JTable();
        this.eqTable.setRowHeight(rowHeight);
        this.eqTable.setShowGrid(true);
        this.eqTable.setModel(new SetTableModel(null));
        this.eqTable.setBackground(dataPanel.getBackground());
        this.eqTable.setGridColor(Color.decode("#D4D8DC"));
        int cellFontSize = (int)Math.round(mainSize.getHeight() * 12.0 / 768.0);
        Font cellFont = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, cellFontSize);
        this.eqTable.setFont(cellFont);
        this.eqTable.getTableHeader().setFont(font);
        this.resultTablePanel = new JScrollPane(this.eqTable);
        this.resultTablePanel.setBackground(dataPanel.getBackground());
        this.resultTablePanel.getViewport().setBackground(Color.decode("#F5F8FD"));
        dataPanel.add((Component)this.resultTablePanel, "Center");
    }

    private static class SetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5225431626950004306L;
        private String[] titleHeaders;
        private String[] attrNameHeaders;
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        private List<Map<String, Object>> dataList;

        private SetTableModel(List<Map<String, Object>> dataList) {
            LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
            queryMap.put("register_plate", "\u6ce8\u518c\u8f66\u724c");
            queryMap.put("passport_type_no", "\u8f66\u724c\u7c7b\u578b");
            queryMap.put("balance", "\u8d26\u6237\u4f59\u989d");
            queryMap.put("deadline", "\u6709\u6548\u671f\u9650");
            queryMap.put("passport_state", "\u8f66\u724c\u72b6\u6001");
            queryMap.put("car_owner_name", "\u8f66\u4e3b\u59d3\u540d");
            queryMap.put("space_count", "\u8f66\u4f4d\u6570");
            queryMap.put("take_space_count", "\u5728\u573a\u8f66\u8f86\u6570");
            queryMap.put("enter_info", "\u5165\u573a\u4fe1\u606f");
            queryMap.put("phone_number", "\u624b\u673a\u53f7\u7801");
            queryMap.put("address", "\u8f66\u4e3b\u4f4f\u5740");
            Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
            if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
                for (CarparkAttribute t : carOwnerAttrMap.values()) {
                    queryMap.put(t.getAttribute_key(), t.getAttribute_value());
                }
            }
            this.titleHeaders = new String[queryMap.size()];
            this.attrNameHeaders = new String[queryMap.size()];
            int index = 0;
            for (Map.Entry e : queryMap.entrySet()) {
                this.titleHeaders[index] = (String)e.getValue();
                this.attrNameHeaders[index] = (String)e.getKey();
                ++index;
            }
            this.dataList = dataList;
        }

        @Override
        public int getColumnCount() {
            return this.titleHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.dataList == null ? 0 : this.dataList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String v = null;
            if (this.dataList == null || this.dataList.isEmpty()) {
                return "";
            }
            if (row >= this.dataList.size()) {
                return "";
            }
            Map<String, Object> data = this.dataList.get(row);
            String attrNmae = this.attrNameHeaders[col];
            if (col == 1) {
                CarparkCarType carN;
                Map<String, CarparkCarType> vmap;
                Map<String, CarparkPassportType> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                CarparkPassportType t = null;
                if (tMap != null) {
                    t = tMap.get(data.get("passport_type_no"));
                }
                if (t != null) {
                    v = t.getPassport_type_name();
                }
                if ((vmap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null && (carN = vmap.get(data.get("car_type_no"))) != null) {
                    v = v == null || v.length() == 0 ? carN.getCar_type_name() : String.valueOf(v) + "\u3001" + carN.getCar_type_name();
                }
            } else if (col == 2) {
                Map<String, CarparkPassportType> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                CarparkPassportType t = null;
                if (tMap != null) {
                    t = tMap.get(data.get("passport_type_no"));
                }
                if (t != null && t.getPass_type() == 1) {
                    Object obj = "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(t.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT")) ? data.get("account_balance") : data.get(attrNmae);
                    if (obj != null) {
                        v = obj.toString();
                    }
                } else {
                    v = "0.00";
                }
            } else if (col == 3) {
                Date deadline;
                Map<String, CarparkPassportType> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                CarparkPassportType t = null;
                if (tMap != null) {
                    t = tMap.get(data.get("passport_type_no"));
                }
                if (t != null && t.getPass_type() == 2 && (deadline = (Date)data.get("deadline")) != null) {
                    v = this.df1.format(deadline);
                }
            } else if (col == 4) {
                v = "\u6b63\u5e38";
                Integer state = (Integer)data.get("passport_state");
                if (state != null) {
                    Map<String, CarparkPassportType> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                    CarparkPassportType t = null;
                    if (tMap != null) {
                        t = tMap.get(data.get("passport_type_no"));
                    }
                    if (state == 1) {
                        v = "\u5df2\u5217\u5165\u9ed1\u540d\u5355";
                    } else if (state == 2) {
                        Calendar today1 = Calendar.getInstance();
                        today1.set(14, 0);
                        today1.set(13, 0);
                        today1.set(12, 0);
                        today1.set(11, 0);
                        Date today = today1.getTime();
                        Date stop_date = (Date)data.get("stop_date");
                        v = "\u5df2\u505c\u7528";
                        if (stop_date != null) {
                            v = stop_date.after(today) ? "\u5df2\u529e\u7406\u505c\u7528,\u505c\u7528\u751f\u6548\u65e5\u671f:" + this.df1.format(stop_date) : String.valueOf(v) + ",\u505c\u7528\u65e5\u671f:" + this.df1.format(stop_date);
                        }
                    } else if (t != null && t.getPass_type() == 2) {
                        Calendar today1 = Calendar.getInstance();
                        today1.set(14, 0);
                        today1.set(13, 0);
                        today1.set(12, 0);
                        today1.set(11, 0);
                        Date today = today1.getTime();
                        Date start_date = (Date)data.get("start_date");
                        if (start_date != null && start_date.after(today)) {
                            v = "\u672a\u542f\u7528,\u542f\u7528\u65e5\u671f:" + this.df1.format(start_date);
                        } else {
                            Date deadline = (Date)data.get("deadline");
                            if (deadline != null && deadline.before(today)) {
                                v = "\u5df2\u8fc7\u671f";
                            }
                        }
                    }
                }
            } else {
                Object obj = data.get(attrNmae);
                if (obj != null) {
                    v = obj.toString();
                }
            }
            if (v == null) {
                v = "";
            }
            v = ServiceUtil.getServiceContext().getHideSensitiveInfo().getGuiSensitiveValue(attrNmae, v);
            return v;
        }

        @Override
        public String getColumnName(int column) {
            return this.titleHeaders[column];
        }
    }
}

