/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.login;

import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.gui.ComboBoxEntry;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.gui.MacDialog;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.XYConstraints;
import com.wovoe.carpark.gui.XYLayout;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.ParingSpaceVo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetRemainSpaceDialog
extends MacDialog
implements ActionListener {
    private static final long serialVersionUID = 17549881308466552L;
    private Dimension rootSize;
    private static SetRemainSpaceDialog instance;
    private JComboBox<ComboBoxEntry<String>> areaSelect;
    private JLabel currentSpaceLabel;
    private JTextField setLabel;
    private JLabel msgLabel;
    private JButton cancelButton;
    private JButton okButton;
    private Color infoColor = Color.BLUE;
    private Color errColor = Color.RED;

    public static SetRemainSpaceDialog showDialog(Component parentComponent, Dimension rootSize, Dimension dialogSize) {
        if (instance == null || !instance.isVisible()) {
            instance = SetRemainSpaceDialog.createDialog(parentComponent, rootSize, dialogSize);
            instance.setVisible(true);
        } else {
            instance.toFront();
        }
        return instance;
    }

    public static void closeIfShow() {
        if (instance != null && instance.isVisible()) {
            instance.dispose();
        }
    }

    public static SetRemainSpaceDialog createDialog(Component parentComponent, Dimension rootSize, Dimension dialogSize) {
        Window window;
        if (rootSize == null) {
            rootSize = SwingUtil.getScreenSize();
        }
        SetRemainSpaceDialog instance = parentComponent == null ? new SetRemainSpaceDialog() : ((window = SwingUtil.getWindowForComponent(parentComponent)) instanceof Frame ? new SetRemainSpaceDialog((Frame)window, false) : (window instanceof Dialog ? new SetRemainSpaceDialog((Dialog)window, false) : (window instanceof Window ? new SetRemainSpaceDialog(window, false) : new SetRemainSpaceDialog())));
        if (dialogSize == null) {
            int width = (int)Math.round(rootSize.getHeight() * 400.0 / 768.0);
            int height = (int)Math.round(rootSize.getHeight() * 260.0 / 768.0);
            dialogSize = new Dimension(width, height);
        }
        instance.rootSize = rootSize;
        instance.init(dialogSize, parentComponent);
        instance.setTitleInfo("\u8bbe\u7f6e\u573a\u533a\u5269\u4f59\u8f66\u4f4d");
        return instance;
    }

    public SetRemainSpaceDialog() {
    }

    public SetRemainSpaceDialog(Frame owner, boolean modal) {
        super(owner, null, modal);
    }

    public SetRemainSpaceDialog(Window owner, boolean modal) {
        super(owner, null, modal);
    }

    public SetRemainSpaceDialog(Dialog owner, boolean modal) {
        super(owner, null, modal);
    }

    @Override
    public int getTitileBarHeight() {
        return (int)Math.round(this.rootSize.getHeight() * 30.0 / 900.0);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (instance == this) {
            instance = null;
        }
    }

    private void setValueTxt() {
        this.setLabel.setText("");
        ComboBoxEntry cb = (ComboBoxEntry)((Object)this.areaSelect.getSelectedItem());
        String areaNo = (String)cb.getKey();
        if (areaNo != null) {
            ParingSpaceVo av = ParkingSpace.getInstance().getRemainSpaceInfo("r-as_" + areaNo);
            this.currentSpaceLabel.setText(String.valueOf(av.getRemain()) + " / " + av.getTotal());
        } else {
            this.currentSpaceLabel.setText("0 / 0");
        }
        this.msgLabel.setText("");
    }

    @Override
    protected void init0(JPanel body, Dimension panelSize, Component parentComponent) {
        int butGrap;
        body.setLayout(new XYLayout());
        int font13Size = (int)Math.round(this.rootSize.getHeight() * 13.0 / 768.0);
        Font font13 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font13Size);
        Font font14 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 1, (int)Math.round(this.rootSize.getHeight() * 14.0 / 768.0));
        int font12Size = (int)Math.round(this.rootSize.getHeight() * 12.0 / 768.0);
        Font font12 = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, font12Size);
        int marg = (int)Math.round(this.rootSize.getHeight() * 3.0 / 768.0);
        Vector<ComboBoxEntry<String>> items = new Vector<ComboBoxEntry<String>>();
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        for (CarparkArea area : areaMap.values()) {
            items.add(new ComboBoxEntry<String>(area.getArea_no(), area.getArea_name()));
        }
        this.areaSelect = new JComboBox(items);
        if (!items.isEmpty()) {
            this.areaSelect.setSelectedIndex(0);
        }
        this.areaSelect.setFont(font13);
        this.areaSelect.setBackground(Color.WHITE);
        this.areaSelect.setActionCommand("areaselect");
        this.areaSelect.addActionListener(this);
        this.currentSpaceLabel = new JLabel();
        this.currentSpaceLabel.setFont(font14);
        this.setLabel = new JTextField();
        this.setLabel.setFont(font13);
        this.setLabel.setMargin(new Insets(0, marg, 0, marg));
        this.msgLabel = new JLabel();
        this.msgLabel.setFont(font12);
        int margTop = (int)Math.round(this.rootSize.getHeight() * 30.0 / 768.0);
        JLabel bl1 = new JLabel("\u505c\u8f66\u573a\u533a\uff1a");
        bl1.setHorizontalAlignment(4);
        bl1.setFont(font13);
        JLabel bl2 = new JLabel("\u5f53\u524d\u4f59\u4f4d/\u603b\u6570\uff1a");
        bl2.setHorizontalAlignment(4);
        bl2.setFont(font13);
        JLabel bl3 = new JLabel("\u4f59\u4f4d\u4fee\u6539\u4e3a\uff1a");
        bl3.setHorizontalAlignment(4);
        bl3.setFont(font13);
        int textWidth = SwingUtil.getStringFontSize((String)new StringBuilder((String)"\u4f60\u4f60").append((String)bl2.getText()).toString(), (Font)font13).width;
        int marginRL = (int)Math.round(this.rootSize.getHeight() * 20.0 / 768.0);
        int margint = (int)Math.round(this.rootSize.getHeight() * 10.0 / 768.0);
        int gh = (int)Math.round(this.rootSize.getHeight() * 28.0 / 768.0);
        int x = marginRL;
        int y = margTop;
        int w = textWidth;
        int h = gh;
        int pw = panelSize.width - marginRL - margTop - textWidth;
        body.add((Component)bl1, new XYConstraints(x, y, w, h));
        x += w;
        w = pw;
        body.add(this.areaSelect, new XYConstraints(x, y, w, h));
        x = marginRL;
        w = textWidth;
        body.add((Component)bl2, new XYConstraints(x, y += h + margint, w, h));
        x += w;
        w = pw;
        body.add((Component)this.currentSpaceLabel, new XYConstraints(x, y, w, h));
        x = marginRL;
        w = textWidth;
        body.add((Component)bl3, new XYConstraints(x, y += h + margint, w, h));
        x += w;
        w = pw;
        body.add((Component)this.setLabel, new XYConstraints(x, y, w, h));
        int marg1 = (int)Math.round(this.rootSize.getHeight() * 8.0 / 768.0);
        w = panelSize.width - marginRL - margTop;
        x = margTop;
        body.add((Component)this.msgLabel, new XYConstraints(x, y += h + marg1, w, h));
        int buttonW = (int)Math.round(this.rootSize.getHeight() * 80.0 / 768.0);
        int buttonH = (int)Math.round(this.rootSize.getHeight() * 25.0 / 768.0);
        this.cancelButton = new JButton("\u5173\u95ed");
        this.cancelButton.setCursor(new Cursor(12));
        this.cancelButton.setFont(font13);
        this.cancelButton.setForeground(new Color(38, 38, 38));
        this.cancelButton.setBackground(new Color(239, 239, 239));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setBackground(Color.decode("#FAFAFA"));
        this.cancelButton.setRolloverEnabled(false);
        this.okButton = new JButton("\u786e\u5b9a");
        this.okButton.setCursor(new Cursor(12));
        this.okButton.setFont(font13);
        this.okButton.setForeground(new Color(255, 255, 255));
        this.okButton.setBackground(new Color(20, 138, 224));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.okButton.setBackground(Color.decode("#38A0F4"));
        this.okButton.setForeground(Color.WHITE);
        this.okButton.setRolloverEnabled(false);
        x = butGrap = (panelSize.width - 2 * buttonW) / 3;
        w = buttonW;
        y += h + marg1;
        h = buttonH;
        body.add((Component)this.cancelButton, new XYConstraints(x, y, w, h));
        body.add((Component)this.okButton, new XYConstraints(x += w + butGrap, y, w, h));
        this.setValueTxt();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("cancel".equals(cmd)) {
            this.dispose();
        } else if ("areaselect".equals(cmd)) {
            this.setValueTxt();
        } else if ("ok".equals(cmd)) {
            ParingSpaceVo av;
            ComboBoxEntry cb = (ComboBoxEntry)((Object)this.areaSelect.getSelectedItem());
            String areaNo = (String)cb.getKey();
            if (areaNo != null && areaNo.length() > 0) {
                av = ParkingSpace.getInstance().getRemainSpaceInfo("r-as_" + areaNo);
                this.currentSpaceLabel.setText(String.valueOf(av.getRemain()) + " / " + av.getTotal());
            } else {
                av = new ParingSpaceVo();
            }
            if (av.getTotal() <= 0) {
                this.msgLabel.setForeground(this.errColor);
                this.msgLabel.setText("\u573a\u533a\u603b\u8f66\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e0");
                return;
            }
            String setV = this.setLabel.getText();
            setV = setV != null ? setV.trim() : "";
            if (setV.length() == 0) {
                this.msgLabel.setForeground(this.errColor);
                this.msgLabel.setText("\u8bf7\u8f93\u5165\u8981\u8bbe\u7f6e\u7684\u4f59\u4f4d\u6570\u91cf");
                this.setLabel.requestFocus();
                return;
            }
            int enditNum = 0;
            try {
                enditNum = Integer.parseInt(setV);
            }
            catch (Exception ex) {
                this.msgLabel.setForeground(this.errColor);
                this.msgLabel.setText("\u8981\u8bbe\u7f6e\u7684\u4f59\u4f4d\u5fc5\u987b\u662f\u6574\u6570");
                this.setLabel.requestFocus();
                return;
            }
            if (enditNum == av.getRemain()) {
                this.msgLabel.setForeground(this.errColor);
                this.msgLabel.setText("\u8981\u8bbe\u7f6e\u7684\u4f59\u4f4d\u6570\u65e0\u53d8\u5316");
                this.setLabel.requestFocus();
                return;
            }
            if (!this.okButton.isEnabled()) {
                return;
            }
            this.msgLabel.setForeground(this.infoColor);
            this.msgLabel.setText("\u8bbe\u7f6e\u4e2d...");
            this.areaSelect.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.doMpdify(areaNo, enditNum);
        }
    }

    private void doMpdify(final String areaNo, final int enditNum) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block5: {
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    try {
                        try {
                            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                            UserSession userSession = appService.getUserSession();
                            recordSaveService.adjustParkingSpace(areaNo, "", enditNum, userSession.getUser().getUser_code(), userSession.getUser().getUser_name(), ServiceUtil.getNow(), true);
                            returnMap.put("returnCode", "0");
                        }
                        catch (Exception ex) {
                            GuiLog.getLog().warn((Object)"\u8bbe\u7f6e\u4f59\u4f4d\u5f02\u5e38: ", (Throwable)ex);
                            returnMap.put("returnCode", "4");
                            SwingUtil.invokeLater(new Runnable(returnMap){
                                private final /* synthetic */ Map val$returnMap;
                                {
                                    this.val$returnMap = map;
                                }

                                @Override
                                public void run() {
                                    SetRemainSpaceDialog.this.areaSelect.setEnabled(true);
                                    SetRemainSpaceDialog.this.cancelButton.setEnabled(true);
                                    SetRemainSpaceDialog.this.okButton.setEnabled(true);
                                    if ("0".equals(this.val$returnMap.get("returnCode"))) {
                                        SetRemainSpaceDialog.this.setValueTxt();
                                        SetRemainSpaceDialog.this.msgLabel.setForeground(SetRemainSpaceDialog.this.infoColor);
                                        SetRemainSpaceDialog.this.msgLabel.setText("\u64cd\u4f5c\u6210\u529f\uff0c\u4f59\u4f4d\u5df2\u4fee\u6539\u3002");
                                    } else {
                                        SetRemainSpaceDialog.this.msgLabel.setForeground(SetRemainSpaceDialog.this.errColor);
                                        SetRemainSpaceDialog.this.msgLabel.setText("\u64cd\u4f5c\u5931\u8d25");
                                    }
                                }
                            });
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }
}

