/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.skin;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.framework.BytesTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class CarparkDefineSkinLoader {
    public static void readFeatureSkin(Map<String, Object> loadInfoMap) throws Exception {
        File skinDir = new File(PathFinder.findHomeDir(), "skin");
        if (!skinDir.exists() || !skinDir.isDirectory()) {
            return;
        }
        File feature = new File(skinDir, "feature.skin");
        if (!feature.exists() || !feature.isFile()) {
            return;
        }
        CarparkDefineSkinLoader.readDefineSkin(feature, loadInfoMap);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readDefineSkin(File skinFile, Map<String, Object> loadInfoMap) throws Exception {
        int dataIndex = 0;
        byte[] data = null;
        byte[] buf = new byte[0x100000];
        boolean state = false;
        byte[] dataLenBytes = new byte[4];
        int dataLenIndexx = 0;
        FileInputStream in = new FileInputStream(skinFile);
        int maxLen = 0xF00000;
        boolean run = true;
        try {
            block15: {
                int len;
                block14: {
                    if (!true) break block14;
                    if (!run) return;
                    if ((len = in.read(buf, 0, buf.length)) == -1) break block15;
                }
                do {
                    int i = 0;
                    while (i < len) {
                        if (!state) {
                            dataLenBytes[dataLenIndexx++] = buf[i];
                            if (dataLenIndexx == dataLenBytes.length) {
                                int x = BytesTool.bytesToInt((byte[])dataLenBytes);
                                if (x <= 0) throw new IOException("\u6587\u4ef6:feature.skin\u5df2\u635f\u574f!");
                                if (x > maxLen) {
                                    throw new IOException("\u6587\u4ef6:feature.skin\u5df2\u635f\u574f!");
                                }
                                state = true;
                                data = new byte[x];
                                dataIndex = 0;
                            }
                        } else if (state) {
                            data[dataIndex++] = buf[i];
                            if (dataIndex == data.length) {
                                boolean success = CarparkDefineSkinLoader.parseImage(data = CarparkDefineSkinLoader.decodeData(dataLenBytes, data), loadInfoMap);
                                if (!success) {
                                    throw new IOException("\u6587\u4ef6:feature.skin\u5df2\u635f\u574f!");
                                }
                                data = null;
                                dataIndex = 0;
                                dataLenIndexx = 0;
                                state = false;
                            }
                        }
                        ++i;
                    }
                    if (!run) return;
                } while ((len = in.read(buf, 0, buf.length)) != -1);
            }
            return;
        }
        finally {
            in.close();
        }
    }

    private static byte[] decodeData(byte[] dataLenBytes, byte[] data) {
        byte c = dataLenBytes[0];
        int i = 1;
        while (i < dataLenBytes.length) {
            c = (byte)(c ^ dataLenBytes[i]);
            ++i;
        }
        i = 0;
        while (i < data.length) {
            data[i] = (byte)(c ^ data[i]);
            ++i;
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseImage(byte[] data, Map<String, Object> dataMap) {
        String contentValue;
        String name;
        int nameLen;
        byte flag;
        if (data.length == 0) {
            return false;
        }
        int index = 0;
        if ((flag = data[index++]) != 1 && flag != 0) {
            return false;
        }
        if ((nameLen = data[index++] & 0xFF) + index > data.length) {
            return false;
        }
        try {
            name = new String(data, index, nameLen, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            name = new String(data, index, nameLen);
        }
        if ((index += nameLen) + 4 > data.length) {
            return false;
        }
        int valueLen = BytesTool.bytesToInt((byte[])data, (int)index);
        index += 4;
        if (valueLen <= 0) {
            return false;
        }
        if (index + valueLen != data.length) {
            return false;
        }
        if (flag == 1) {
            try {
                byte[] picB = new byte[valueLen];
                System.arraycopy(data, index, picB, 0, valueLen);
                dataMap.put(name, picB);
                int do1 = name.lastIndexOf(46);
                if (do1 <= 0) return true;
                dataMap.put(name.substring(0, do1), name);
                return true;
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u52a0\u8f7d\u56fe\u7247,\u6587\u4ef6\u53ef\u80fd\u5df2\u635f\u574f!");
                return false;
            }
        }
        try {
            contentValue = new String(data, index, valueLen, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ServiceLog.getLog().warn((Object)"\u4e0d\u652f\u6301UTF-8\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5");
            contentValue = new String(data, index, valueLen);
        }
        dataMap.put(name, contentValue);
        return true;
    }
}

