/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.skin;

import com.wovoe.carpark.gui.skin.CarparkGuiSkin;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class DefaultCarparkGuiSkin
implements CarparkGuiSkin {
    protected static final String[] imgz = new String[]{".png", ".gif", ".jpg", ".bmp", "jpeg"};
    protected static final String IMAGEPATH = "images/";
    protected Map<String, BufferedImage> cache = new ConcurrentHashMap<String, BufferedImage>();
    protected Map<String, Object> defineSkinInfo;

    @Override
    public BufferedImage getBufferedImage(String imgName) {
        BufferedImage c;
        if (imgName == null || imgName.length() == 0) {
            return null;
        }
        BufferedImage image = this.cache.get(imgName);
        if (image == null && (image = this.newBufferedImage(imgName)) != null && (c = this.cache.putIfAbsent(imgName, image)) != null) {
            image = c;
        }
        return image;
    }

    @Override
    public Image getImage(String imgName) {
        return this.getBufferedImage(imgName);
    }

    @Override
    public Image newImage(String imgName) {
        return this.newBufferedImage(imgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromDefineSkinIfNot() {
        if (this.defineSkinInfo == null) {
            DefaultCarparkGuiSkin defaultCarparkGuiSkin = this;
            synchronized (defaultCarparkGuiSkin) {
                block10: {
                    if (this.defineSkinInfo == null) {
                        HashMap<String, Object> defineSkinInfo1 = new HashMap<String, Object>();
                        try {
                            try {
                                Class<?> cl = Class.forName("com.wovoe.carpark.gui.skin.CarparkDefineSkinLoader");
                                cl.getMethod("readFeatureSkin", Map.class).invoke(cl, defineSkinInfo1);
                            }
                            catch (Throwable ex) {
                                System.err.println("\u65e0\u6cd5\u52a0\u8f7d feature.skin, \u539f\u56e0\uff1a" + ex.getMessage());
                                this.defineSkinInfo = defineSkinInfo1;
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            this.defineSkinInfo = defineSkinInfo1;
                            throw throwable;
                        }
                        this.defineSkinInfo = defineSkinInfo1;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream readFromDefineSkin(String imgName, StringBuilder ext) {
        Map<String, Object> dfMap = this.getDefineSkinInfo();
        if (dfMap == null) {
            return null;
        }
        Object obj = dfMap.get(imgName);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof byte[])) {
            if (!(obj instanceof String)) return null;
            String v = (String)obj;
            if (v.lastIndexOf(46) == -1) {
                return null;
            }
            obj = dfMap.get(v);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof byte[])) {
                return null;
            }
            if (ext == null) return new ByteArrayInputStream((byte[])obj);
            ext.append(v.substring(v.lastIndexOf(46) + 1));
            return new ByteArrayInputStream((byte[])obj);
        } else {
            int z;
            if (ext == null || (z = imgName.lastIndexOf(46)) == -1) return new ByteArrayInputStream((byte[])obj);
            ext.append(imgName.substring(z + 1));
        }
        return new ByteArrayInputStream((byte[])obj);
    }

    @Override
    public BufferedImage newImageFromClassPath(String imgName) {
        URL imageUrl = this.getImgURL(imgName);
        if (imageUrl != null) {
            try {
                return ImageIO.read(imageUrl);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public BufferedImage newBufferedImage(String imgName) {
        BufferedImage image = null;
        try {
            InputStream is = this.readFromDefineSkin(imgName, null);
            if (is != null) {
                image = ImageIO.read(is);
            }
        }
        catch (Exception ex) {
            image = null;
        }
        if (image != null) {
            return image;
        }
        return this.newImageFromClassPath(imgName);
    }

    @Override
    public URL getImgURL(String imgName) {
        return this.getImageUrl(imgName, IMAGEPATH);
    }

    protected String getImageRealName(String imageName) {
        return imageName;
    }

    @Override
    public InputStream obtainImageInput(String imgName, StringBuilder ext) {
        InputStream is = null;
        try {
            is = this.readFromDefineSkin(imgName, ext);
            if (is != null) {
                return is;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL url = this.getImgURL(imgName);
        if (url == null) {
            return null;
        }
        try {
            String path;
            int a;
            if (ext != null && (a = (path = url.getPath()).lastIndexOf(46)) != -1) {
                ext.append(path.substring(a + 1));
            }
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getImageUrlFromClassPath(String imageName, String sourceBasePath) {
        if (imageName == null || imageName.length() == 0) {
            return null;
        }
        if (sourceBasePath == null) {
            sourceBasePath = IMAGEPATH;
        }
        if (imageName.lastIndexOf(46) != -1) {
            String path = String.valueOf(sourceBasePath) + imageName;
            URL imageUrl = DefaultCarparkGuiSkin.class.getResource(path);
            if (imageUrl == null && (imageUrl = DefaultCarparkGuiSkin.class.getClassLoader().getResource(path)) == null) {
                imageUrl = Thread.currentThread().getContextClassLoader().getResource(path);
            }
            if (imageUrl != null) {
                return imageUrl;
            }
        } else {
            String[] stringArray = imgz;
            int n = imgz.length;
            int n2 = 0;
            while (n2 < n) {
                String iz = stringArray[n2];
                String path = String.valueOf(sourceBasePath) + imageName + iz;
                URL imageUrl = DefaultCarparkGuiSkin.class.getResource(path);
                if (imageUrl == null && (imageUrl = DefaultCarparkGuiSkin.class.getClassLoader().getResource(path)) == null) {
                    imageUrl = Thread.currentThread().getContextClassLoader().getResource(path);
                }
                if (imageUrl != null) {
                    return imageUrl;
                }
                ++n2;
            }
        }
        return null;
    }

    protected URL getImageUrl(String imageName, String sourceBasePath) {
        if ((imageName = this.getImageRealName(imageName)) == null || imageName.length() == 0) {
            return null;
        }
        if (imageName.lastIndexOf(46) != -1) {
            String path = String.valueOf(sourceBasePath) + imageName;
            URL imageUrl = DefaultCarparkGuiSkin.class.getResource(path);
            if (imageUrl == null && (imageUrl = DefaultCarparkGuiSkin.class.getClassLoader().getResource(path)) == null) {
                imageUrl = Thread.currentThread().getContextClassLoader().getResource(path);
            }
            if (imageUrl != null) {
                return imageUrl;
            }
        } else {
            String[] stringArray = imgz;
            int n = imgz.length;
            int n2 = 0;
            while (n2 < n) {
                String iz = stringArray[n2];
                String path = String.valueOf(sourceBasePath) + imageName + iz;
                URL imageUrl = DefaultCarparkGuiSkin.class.getResource(path);
                if (imageUrl == null && (imageUrl = DefaultCarparkGuiSkin.class.getClassLoader().getResource(path)) == null) {
                    imageUrl = Thread.currentThread().getContextClassLoader().getResource(path);
                }
                if (imageUrl != null) {
                    return imageUrl;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getSystemName() {
        Object v;
        Map<String, Object> dfMap = this.getDefineSkinInfo();
        if (dfMap != null && (v = dfMap.get("systemName")) != null && v instanceof String) {
            return (String)v;
        }
        return "\u4e07\u8054\u4e91\u63a7\u00b7\u667a\u80fd\u505c\u8f66\u7cfb\u7edf";
    }

    @Override
    public String getCopyrightCompany() {
        Object v;
        Map<String, Object> dfMap = this.getDefineSkinInfo();
        if (dfMap != null && (v = dfMap.get("copyrightCompany")) != null && v instanceof String) {
            return (String)v;
        }
        return "\u6df1\u5733\u5e02\u4e07\u8054\u4e91\u63a7\u8f6f\u4ef6\u6280\u672f\u5f00\u53d1\u6709\u9650\u516c\u53f8";
    }

    @Override
    public String getManageBrandtext() {
        Object v;
        Map<String, Object> dfMap = this.getDefineSkinInfo();
        if (dfMap != null && (v = dfMap.get("manageBrandtext")) != null && v instanceof String) {
            return (String)v;
        }
        return "\u505c\u8f66\u7ba1\u7406\u7cfb\u7edf";
    }

    @Override
    public Map<String, Object> getDefineSkinInfo() {
        this.loadFromDefineSkinIfNot();
        return this.defineSkinInfo;
    }
}

