/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui.util;

import com.wovoe.carpark.gui.skin.CarparkGuiSkin;
import com.wovoe.carpark.gui.skin.DefaultCarparkGuiSkin;
import com.wovoe.carpark.gui.skin.NoLogoGuiSkin;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class CarparkGuiSkinUtil
implements InvocationHandler {
    private static CarparkGuiSkin skin;
    private static CarparkGuiSkin defaultSkin;
    private static CarparkGuiSkin instance;

    static {
        String vlli = System.getProperty("no_logo", "0");
        defaultSkin = "1".equals(vlli) ? new NoLogoGuiSkin() : new DefaultCarparkGuiSkin();
        instance = (CarparkGuiSkin)Proxy.newProxyInstance(CarparkGuiSkin.class.getClassLoader(), new Class[]{CarparkGuiSkin.class}, (InvocationHandler)new CarparkGuiSkinUtil());
    }

    private CarparkGuiSkinUtil() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object obj = null;
        if (skin != null) {
            obj = method.invoke((Object)skin, args);
        }
        if (obj == null) {
            obj = method.invoke((Object)defaultSkin, args);
        }
        return obj;
    }

    public static CarparkGuiSkin getCarparkGuiSkin() {
        return instance;
    }

    public static void installSkin(CarparkGuiSkin newSkin) {
        skin = newSkin;
    }

    public static Image resizeImage(Image originalImage, int width, int height) {
        return originalImage.getScaledInstance(width, height, 4);
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        if (originalImage == null) {
            return null;
        }
        if (originalImage.getWidth() == width && originalImage.getHeight() == height) {
            return originalImage;
        }
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        try {
            Image image = originalImage.getScaledInstance(width, height, 4);
            g.drawImage(image, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return newImage;
    }
}

