/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.CarparkDbTableTrigger;
import com.wovoe.framework.FrameworkContextUtil;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.dao.DbTableTrigger;
import com.wovoe.framework.dao.DbTableTriggerManager;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class CarparkDbTriggerInterceptor
implements Interceptor {
    private static final String OP_INSERT = "insert";
    private static final String OP_UPDATE = "update";
    private static final String OP_DELETE = "delete";
    private static final String SQL_INTO = "INTO";
    private static final String SQL_FROM = "FROM";
    private static final char SQL_X0 = '(';
    private static final char SQL_X1 = ';';
    private Method commonParamDeepCloneMethod = null;

    public Object intercept(Invocation invocation) throws Throwable {
        int c;
        Object[] args = invocation.getArgs();
        List dbTriggerlist = null;
        Integer opT = null;
        String tableName = null;
        Object parameterObject = null;
        if (args != null && args.length == 2 && invocation.getTarget() instanceof Executor) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object parameter = invocation.getArgs()[1];
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            String originalSql = boundSql.getSql();
            parameterObject = boundSql.getParameterObject();
            if (boundSql != null && boundSql.getSql() != null && boundSql.getSql().length() > 0) {
                StringTokenizer sba = new StringTokenizer(originalSql, " \n\r\t");
                String op = null;
                if (sba.hasMoreTokens()) {
                    op = sba.nextToken();
                }
                if (OP_INSERT.equalsIgnoreCase(op)) {
                    opT = 1;
                } else if (OP_UPDATE.equalsIgnoreCase(op)) {
                    opT = 2;
                } else if (OP_DELETE.equalsIgnoreCase(op)) {
                    opT = 4;
                }
                if (opT != null && (tableName = CarparkDbTriggerInterceptor.getModifyOPTableName(sba, op)) != null && tableName.length() > 0) {
                    dbTriggerlist = DbTableTriggerManager.getInstance().getDbTableTrigger(tableName, opT.intValue());
                }
            }
        }
        LinkedList<DbTableTrigger> asynRunTriggerList = null;
        LinkedList<DbTableTrigger> synRunTriggerList = null;
        if (dbTriggerlist != null && !dbTriggerlist.isEmpty() && tableName != null && tableName.length() > 0 && opT != null) {
            for (DbTableTrigger t : dbTriggerlist) {
                if (t instanceof CarparkDbTableTrigger) {
                    CarparkDbTableTrigger t1 = (CarparkDbTableTrigger)t;
                    if (t1.isAsyncCallbackOnUpdate()) {
                        if (asynRunTriggerList == null) {
                            asynRunTriggerList = new LinkedList();
                        }
                        asynRunTriggerList.add(t);
                    } else {
                        if (synRunTriggerList == null) {
                            synRunTriggerList = new LinkedList<DbTableTrigger>();
                        }
                        synRunTriggerList.add(t);
                    }
                    try {
                        t1.onUpdateBefore(opT, tableName, parameterObject);
                    }
                    catch (Throwable ex) {
                        LogUtil.getLog().warn((Object)"", ex);
                    }
                    continue;
                }
                if (asynRunTriggerList == null) {
                    asynRunTriggerList = new LinkedList<DbTableTrigger>();
                }
                asynRunTriggerList.add(t);
            }
        }
        Object result = invocation.proceed();
        if (dbTriggerlist != null && !dbTriggerlist.isEmpty() && tableName != null && tableName.length() > 0 && opT != null && result instanceof Integer && (c = ((Integer)result).intValue()) > 0) {
            final LinkedList<DbTableTrigger> ayncTriggerlist0 = asynRunTriggerList;
            LinkedHashMap copyObj = null;
            try {
                if (parameterObject != null) {
                    if (parameterObject.getClass().getName().endsWith(".CommonParam")) {
                        if (this.commonParamDeepCloneMethod == null) {
                            this.commonParamDeepCloneMethod = parameterObject.getClass().getMethod("deepClone", new Class[0]);
                        }
                        copyObj = this.commonParamDeepCloneMethod.invoke(parameterObject, new Object[0]);
                    } else {
                        JavaBeanMap x = new JavaBeanMap(parameterObject);
                        copyObj = parameterObject instanceof Map ? new LinkedHashMap() : parameterObject.getClass().newInstance();
                        JavaBeanMap x1 = new JavaBeanMap(copyObj);
                        for (Map.Entry e : x.entrySet()) {
                            x1.put((String)e.getKey(), e.getValue());
                        }
                    }
                }
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)"", (Throwable)ex);
            }
            final LinkedHashMap copyObj0 = copyObj;
            final int opT0 = opT;
            final String tableName0 = tableName;
            if (synRunTriggerList != null && !synRunTriggerList.isEmpty()) {
                for (DbTableTrigger t : synRunTriggerList) {
                    try {
                        t.onUpdate(opT0, tableName0, copyObj0, c);
                    }
                    catch (Throwable ex) {
                        LogUtil.getLog().warn((Object)"", ex);
                    }
                }
            }
            if (ayncTriggerlist0 != null && !ayncTriggerlist0.isEmpty() && FrameworkContextUtil.getFrameworkContext() != null) {
                FrameworkContextUtil.getFrameworkContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        for (DbTableTrigger t : ayncTriggerlist0) {
                            try {
                                t.onUpdate(opT0, tableName0, copyObj0, c);
                            }
                            catch (Throwable ex) {
                                LogUtil.getLog().warn((Object)"", ex);
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }

    private static String getModifyOPTableName(StringTokenizer st, String op) {
        int z;
        String tableName;
        String n;
        if (st == null || op == null) {
            return null;
        }
        if (OP_INSERT.equalsIgnoreCase(op)) {
            int z2;
            String tableName2;
            String n2;
            if (st.hasMoreTokens() && (n2 = st.nextToken()) != null && SQL_INTO.equalsIgnoreCase(n2.trim()) && st.hasMoreTokens() && (n2 = st.nextToken()) != null && (n2 = n2.trim()).length() > 0 && (tableName2 = (z2 = n2.indexOf(40)) >= 0 ? n2.substring(0, z2).trim() : n2).length() > 0) {
                return tableName2;
            }
        } else if (OP_UPDATE.equalsIgnoreCase(op)) {
            String n3;
            if (st.hasMoreTokens() && (n3 = st.nextToken()) != null && (n3 = n3.trim()).length() > 0) {
                return n3;
            }
        } else if (OP_DELETE.equalsIgnoreCase(op) && st.hasMoreTokens() && (n = st.nextToken()) != null && SQL_FROM.equalsIgnoreCase(n.trim()) && st.hasMoreTokens() && (n = st.nextToken()) != null && (n = n.trim()).length() > 0 && (tableName = (z = n.indexOf(59)) >= 0 ? n.substring(0, z).trim() : n).length() > 0) {
            return tableName;
        }
        return null;
    }
}

