/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.dto.CarparkFeeReport;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;

public class CarparkTranFeeReportJob
extends JobTask {
    private static CarparkTranFeeReportJob instance = new CarparkTranFeeReportJob();

    public static CarparkTranFeeReportJob getInstance() {
        return instance;
    }

    private CarparkTranFeeReportJob() {
    }

    protected void doRun() throws Exception {
        Calendar cl = Calendar.getInstance();
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        cl.add(6, 1);
        Date endTime = cl.getTime();
        cl.add(6, -31);
        Date startDate = cl.getTime();
        this.runCarparkFeeReport(startDate, endTime);
    }

    public synchronized void runCarparkFeeReport(Date beginTime, Date endTime) {
        String groupby = "charge_org,service_type,pay_scene,pay_method,host_no,operate_user_code,pass_type,passport_type_no,car_type_no";
        String groupby1 = "to_char(tran_time,'yyyy-MM-dd')";
        String select1 = "to_char(tran_time,'yyyy-MM-dd') AS report_date";
        String select2 = "SUM(tran_money) AS tran_money";
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String tableName = commonDaoService.getTableName(CarparkTransaction.class);
        SearchParam sp = new SearchParam(tableName);
        sp.setQueryFields(new String[]{select1, groupby, select2});
        sp.addGTE("tran_time", (Object)beginTime);
        sp.addLT("tran_time", (Object)endTime);
        sp.setGoupbySql(String.valueOf(groupby1) + "," + groupby);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        List list = commonDaoService.selectList(sp, null);
        HashMap ListMap = new HashMap();
        if (list != null && !list.isEmpty()) {
            for (Map dataMap : list) {
                java.sql.Date report_date;
                String d1 = (String)dataMap.get("report_date");
                try {
                    report_date = new java.sql.Date(df.parse(d1).getTime());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                LinkedList<Map> dlist = (LinkedList<Map>)ListMap.get(report_date);
                if (dlist == null) {
                    dlist = new LinkedList<Map>();
                    ListMap.put(report_date, dlist);
                }
                String[] lh = d1.split("-");
                int year = Integer.parseInt(lh[0]);
                int month = Integer.parseInt(lh[1]);
                int quarter = 1;
                if (month >= 1 && month <= 3) {
                    quarter = 1;
                } else if (month >= 4 && month <= 6) {
                    quarter = 2;
                } else if (month >= 7 && month <= 9) {
                    quarter = 3;
                } else if (month >= 10 && month <= 12) {
                    quarter = 4;
                }
                int day = Integer.parseInt(lh[2]);
                dataMap.put("id", commonDaoService.getSequece("ck_common_seq"));
                dataMap.put("year", year);
                dataMap.put("quarter", quarter);
                dataMap.put("month", month);
                dataMap.put("day", day);
                dataMap.put("day", day);
                dataMap.put("report_date", report_date);
                dataMap.put("carpark_id", carpark_id);
                dataMap.put("project_id", project_id);
                dlist.add(dataMap);
            }
        }
        if (ListMap != null && !ListMap.isEmpty()) {
            String rtableName = commonDaoService.getTableName(CarparkFeeReport.class);
            for (Map.Entry en : ListMap.entrySet()) {
                try (SqlSession session = commonDaoService.openSqlSession();){
                    try {
                        commonDaoService.delete(session, new SearchParam(rtableName).addEQ("report_date", en.getKey()));
                        for (Map data : (List)en.getValue()) {
                            commonDaoService.insert(session, (Object)data, rtableName);
                        }
                        session.commit();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
            }
        }
    }
}

