/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.google.gson.Gson;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkLocalPassDataCache;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.SavePassData;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.LinkedList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

public class CheckLocalPassDataCacheTask {
    public static void handleAll() {
        try {
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List cacheList = commonDaoService.selectList(new SearchParam().setOrerbySql("id"), CarparkLocalPassDataCache.class, null);
            CheckLocalPassDataCacheTask.handleList(cacheList);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }

    private static void handleList(List<CarparkLocalPassDataCache> cacheList) {
        block26: {
            try {
                if (cacheList == null || cacheList.isEmpty()) break block26;
                LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                String tableName = commonDaoService.getTableName(CarparkLocalPassDataCache.class);
                Gson gson = GsonBuilder.create();
                String msg = "\u7cfb\u7edf\u5f02\u5e38\u9000\u51fa\u6216\u65ad\u7535";
                for (CarparkLocalPassDataCache c : cacheList) {
                    try {
                        SavePassData saveData;
                        try {
                            saveData = (SavePassData)gson.fromJson(c.getPass_save_data(), SavePassData.class);
                            if (saveData == null) {
                                throw new NullPointerException();
                            }
                        }
                        catch (Exception ex1) {
                            ServiceLog.getLog().warn((Object)("\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + c.getPass_save_data()));
                            commonDaoService.delete(new SearchParam(tableName).addEQ("id", (Object)c.getId()));
                            continue;
                        }
                        List<CarparkPassRecord> passRecordList = saveData.getPassRecordList();
                        CarparkTransaction deductTansaction = saveData.getDeductTansaction();
                        List<CarparkTransaction> trasactionList = saveData.getTrasactionList();
                        List<CarparkDiscountRecord> dicountRecordList = saveData.getDicountRecordList();
                        LinkedList<CarparkDispatchTask> dispatchTaskList = saveData.getDispatchTaskList();
                        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                        SqlSession sqlsession = commonDaoService.openSqlSession();
                        try {
                            try {
                                if (passRecordList != null && !passRecordList.isEmpty()) {
                                    for (CarparkPassRecord carparkPassRecord : passRecordList) {
                                        String exit_remark0 = carparkPassRecord.getExit_remark();
                                        if (exit_remark0 != null && exit_remark0.length() > 0) {
                                            carparkPassRecord.setExit_remark(ServiceUtil.getDBString(String.valueOf(exit_remark0) + "," + msg, 100));
                                        } else {
                                            carparkPassRecord.setExit_remark(msg);
                                        }
                                        commonDaoService.insert(sqlsession, (Object)carparkPassRecord);
                                        recordSaveService.handlePresenceRecord(sqlsession, carparkPassRecord);
                                        recordSaveService.onAddPassRecord(sqlsession, carparkPassRecord, false);
                                    }
                                }
                                if (deductTansaction != null) {
                                    recordSaveService.deductMoney(sqlsession, deductTansaction);
                                }
                                if (trasactionList != null && !trasactionList.isEmpty()) {
                                    for (CarparkTransaction carparkTransaction : trasactionList) {
                                        String res = carparkTransaction.getTran_des();
                                        if (res == null || res.length() == 0) {
                                            carparkTransaction.setTran_des(msg);
                                        } else {
                                            carparkTransaction.setTran_des(ServiceUtil.getString(String.valueOf(res) + "," + msg, 200));
                                        }
                                        commonDaoService.insert(sqlsession, (Object)carparkTransaction);
                                    }
                                }
                                if (dicountRecordList != null && !dicountRecordList.isEmpty()) {
                                    for (CarparkDiscountRecord carparkDiscountRecord : dicountRecordList) {
                                        commonDaoService.insert(sqlsession, (Object)carparkDiscountRecord);
                                    }
                                }
                                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                                    for (CarparkDispatchTask carparkDispatchTask : dispatchTaskList) {
                                        commonDaoService.insert(sqlsession, (Object)carparkDispatchTask);
                                    }
                                }
                                commonDaoService.delete(sqlsession, new SearchParam(commonDaoService.getTableName(CarparkLocalPassDataCache.class)).addEQ("id", (Object)c.getId()));
                                sqlsession.commit();
                            }
                            catch (Exception exception) {
                                sqlsession.rollback();
                                ServiceLog.getLog().warn((Object)"", (Throwable)exception);
                                sqlsession.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            sqlsession.close();
                            throw throwable;
                        }
                        sqlsession.close();
                        if (dispatchTaskList == null || dispatchTaskList.isEmpty()) continue;
                        taskList.addAll(dispatchTaskList);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                    }
                }
                if (taskList != null && !taskList.isEmpty()) {
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    appService.asynTryRunDispatchTask(taskList);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            }
        }
    }
}

