/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.internel.DataWebSocketConnection;
import com.wovoe.framework.LogUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public class DataWebSocketApplication
extends WebSocketApplication {
    private ConcurrentHashMap<WebSocket, DataWebSocketConnection> socketsMap = new ConcurrentHashMap();

    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        DataWebSocketConnection conn = new DataWebSocketConnection(socket);
        DataWebSocketConnection old = this.socketsMap.put(socket, conn);
        if (old != null && old.getWebSocket() != null && !old.getWebSocket().equals(socket)) {
            old.getWebSocket().close();
        }
        conn.doHandshake();
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        try {
            super.onClose(socket, frame);
        }
        finally {
            this.socketsMap.remove(socket);
        }
    }

    public void onMessage(WebSocket socket, String data) {
        DataWebSocketConnection conn = this.socketsMap.get(socket);
        if (conn == null) {
            try {
                LogUtil.getLog().warn((Object)(socket + "not exist! can not handle data:" + data));
            }
            finally {
                socket.close();
            }
        } else {
            conn.hanldeMessage(data);
        }
    }
}

