/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ConnectedNetHostInfo;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.transfer.DataConnection;
import com.wovoe.framework.transfer.DataProtocol;
import com.wovoe.framework.transfer.DataRequest;
import com.wovoe.framework.transfer.DataResponse;
import com.wovoe.framework.transfer.DataResponseCallback;
import com.wovoe.framework.transfer.DefaultDataConnection;
import com.wovoe.framework.transfer.ReceiveClassManager;
import com.wovoe.framework.transfer.ResultResponse;
import com.wovoe.framework.transfer.SendCallback;
import com.wovoe.framework.transfer.ServiceIOResponse;
import com.wovoe.framework.transfer.TransferCrypto;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.WebSocket;

public class DataWebSocketConnection
extends DefaultDataConnection {
    private WebSocket websocket;
    private volatile boolean handshakeSuccess;
    private ConnectedNetHostInfo connectedNetHostInfo;
    private static AtomicLong MsgIdSEQ = new AtomicLong(0L);
    private String sessionId;

    static {
        ReceiveClassManager.getInstance().addDataClass("handshakeResult", ConnectedNetHostInfo.class);
    }

    public DataWebSocketConnection(WebSocket websocket) {
        this.websocket = websocket;
        this.sessionId = String.valueOf(RandomStringGenerator.getDefaultInstance().getNewString(16)) + "_" + MsgIdSEQ.incrementAndGet();
    }

    public void directSend(String paramString, final SendCallback paramSendCallback) throws IOException {
        GrizzlyFuture future = this.websocket.send(paramString);
        future.addCompletionHandler((CompletionHandler)new CompletionHandler<DataFrame>(){

            public void cancelled() {
                if (paramSendCallback != null) {
                    paramSendCallback.onSendException((Throwable)new CancellationException());
                }
            }

            public void failed(Throwable paramThrowable) {
                try {
                    if (paramSendCallback != null) {
                        paramSendCallback.onSendException(paramThrowable);
                    } else {
                        LogUtil.getLog().warn((Object)("send message error! cause send exception :" + (paramThrowable == null ? "" : paramThrowable.getMessage())));
                    }
                }
                finally {
                    DataWebSocketConnection.this.websocket.close();
                }
            }

            public void completed(DataFrame paramE) {
                if (paramSendCallback != null) {
                    paramSendCallback.onSendComplete();
                }
            }

            public void updated(DataFrame paramE) {
            }
        });
    }

    public String getSignKey() {
        return ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
    }

    public TransferCrypto getCrypto() {
        return ServiceUtil.getServiceContext().getTransferCrypto();
    }

    public TimeoutObjectPool getTimeoutObjectPool() {
        return ServiceUtil.getServiceContext().getTimeoutObjectPool();
    }

    protected Object createWaitResponseKey(DataRequest request) {
        return new WaitResponseKey(request.getMsgId(), String.valueOf(request.getCmd()) + "Result", "", this.sessionId);
    }

    protected Object getWaitResponseKey(DataResponse response) {
        return new WaitResponseKey(response.getMsgId(), response.getCmd(), "", this.sessionId);
    }

    protected ExecutorService getWorkThreadPool() {
        return ServiceUtil.getServiceContext().getWorkThreadPool();
    }

    protected OperationFutureHandler<DataResponse> createDefaultOperationFuture() {
        return ServiceUtil.getServiceContext().createOperationFuture();
    }

    protected void exceptionCaught(Throwable ex) {
        LogUtil.getLog().error((Object)ex.getMessage(), ex);
    }

    protected String createMsgId(String paramString, Object paramObject) {
        return this.createMsgId();
    }

    protected String createMsgId() {
        long id1 = MsgIdSEQ.incrementAndGet();
        return "l" + System.currentTimeMillis() + "_" + id1;
    }

    public void hanldeMessage(String message) {
        try {
            if (this.handshakeSuccess) {
                super.hanldeMessage(message);
            } else {
                DataProtocol p = this.parseReceiveData(message);
                this.setContext(p);
                if ("handshakeResult".equals(p.getCmd())) {
                    super.hanldeReceiveData(p);
                } else if (!p.getCmd().endsWith("Result")) {
                    ResultResponse res = new ResultResponse();
                    res.setResponseCode("501");
                    res.setResponseMsg("\u672a\u80fd\u6210\u529f\u8ba4\u8bc1\u8fde\u63a5, \u9700\u7b49\u5f85\u6210\u529f\u8ba4\u8bc1\u540e\u518d\u8fdb\u884c\u64cd\u4f5c");
                    ServiceIOResponse re = new ServiceIOResponse((DataConnection)this, p.getMsgId());
                    re.doResponse(String.valueOf(p.getCmd()) + "Result", (Object)res);
                }
            }
        }
        catch (Throwable ex) {
            try {
                LogUtil.getLog().warn((Object)("\u65e0\u6cd5\u5904\u7406\u6d88\u606f:" + message), ex);
            }
            finally {
                this.websocket.close();
            }
        }
    }

    public void doHandshake() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("op", "handshake");
        DataRequest dataRequest = this.createDataRequest("handshake", this.createMsgId(), dataMap);
        try {
            this.send(dataRequest, new DataResponseCallback(){

                public void onWaitTimeout() {
                    this.onException(new TimeoutException("\u7b49\u5f85\u63e1\u624b\u4fe1\u606f\u54cd\u5e94\u8d85\u65f6!"));
                }

                public void onResponse(DataResponse response) throws Exception {
                    block6: {
                        try {
                            DataWebSocketConnection.this.connectedNetHostInfo = (ConnectedNetHostInfo)response.getData();
                            String pcNo = DataWebSocketConnection.this.connectedNetHostInfo.getPcId();
                            if (pcNo != null && ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().containsKey(pcNo)) {
                                DataWebSocketConnection.this.handshakeSuccess = true;
                                HashMap<String, String> dataMap0 = new HashMap<String, String>();
                                dataMap0.put("op", "handshakeSuccess");
                                DataRequest dataRequest0 = DataWebSocketConnection.this.createDataRequest("handshakeSuccess", DataWebSocketConnection.this.createMsgId(), dataMap0);
                                DataWebSocketConnection.this.send(dataRequest0, null);
                                break block6;
                            }
                            try {
                                LogUtil.getLog().warn((Object)("\u62d2\u7edd\u8fde\u63a5! pcid:" + (pcNo == null ? "NULL" : pcNo.toString())));
                            }
                            finally {
                                DataWebSocketConnection.this.websocket.close();
                            }
                        }
                        catch (Throwable ex) {
                            this.onException(ex);
                        }
                    }
                }

                public void onException(Throwable ex) {
                    try {
                        LogUtil.getLog().warn((Object)ex.getMessage(), ex);
                    }
                    finally {
                        DataWebSocketConnection.this.websocket.close();
                    }
                }
            }, 5000L);
        }
        catch (IOException e) {
            try {
                LogUtil.getLog().warn((Object)"\u53d1\u9001\u5f02\u5e38!", (Throwable)e);
            }
            finally {
                this.websocket.close();
            }
        }
    }

    public WebSocket getWebSocket() {
        return this.websocket;
    }

    public ConnectedNetHostInfo getConnectedNetHostInfo() {
        return this.connectedNetHostInfo;
    }

    public boolean isConnected() {
        WebSocket socket = this.websocket;
        return socket != null && socket.isConnected() && this.handshakeSuccess;
    }

    private static class WaitResponseKey {
        private String msgId;
        private String cmd;
        private String parkId;
        private String sessionId;

        private WaitResponseKey(String msgId, String cmd, String parkId, String sessionId) {
            this.msgId = msgId;
            this.cmd = cmd;
            this.parkId = parkId;
            this.sessionId = sessionId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.msgId == null ? 0 : this.msgId.hashCode());
            result = 31 * result + (this.parkId == null ? 0 : this.parkId.hashCode());
            result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitResponseKey other = (WaitResponseKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.msgId == null ? other.msgId != null : !this.msgId.equals(other.msgId)) {
                return false;
            }
            if (this.parkId == null ? other.parkId != null : !this.parkId.equals(other.parkId)) {
                return false;
            }
            return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
        }
    }
}

