/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.BlackWhiteListCache;
import com.wovoe.carpark.BlackWhiteListTaskMonitor;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.DbTableTrigger;
import com.wovoe.framework.dao.SearchParam;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class DefaultBlackWhiteListCache
extends JobTask
implements DbTableTrigger,
BlackWhiteListCache {
    private volatile Map<String, Map<String, PlateEntry>> cacheMap;
    private final Object lock = new Object();
    private final String BLACKLISTKEY = "blacklist";
    private final CopyOnWriteArraySet<BlackWhiteListTaskMonitor> monitorList = new CopyOnWriteArraySet();
    private volatile String downloadingEqNo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, PlateEntry>> loadPlateCache() {
        Object object = this.lock;
        synchronized (object) {
            Date maxDatex;
            HashMap<String, Map<String, PlateEntry>> cacheMap0 = new HashMap<String, Map<String, PlateEntry>>();
            LinkedList<String> backListPassportTypeNo = null;
            LinkedList<String> whiltListPassportTypeNo = null;
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (passportTypeMap != null && !passportTypeMap.isEmpty()) {
                for (CarparkPassportType t : passportTypeMap.values()) {
                    if (t.getPassport_type_name() != null && t.getPassport_type_name().startsWith("\u9ed1\u540d\u5355")) {
                        if (backListPassportTypeNo == null) {
                            backListPassportTypeNo = new LinkedList<String>();
                        }
                        backListPassportTypeNo.add(t.getPassport_type_no());
                        continue;
                    }
                    if (t.getPass_type() != 4 && t.getPass_type() != 2) continue;
                    if (whiltListPassportTypeNo == null) {
                        whiltListPassportTypeNo = new LinkedList<String>();
                    }
                    whiltListPassportTypeNo.add(t.getPassport_type_no());
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String maxDate = "2035-01-01";
            try {
                maxDatex = df.parse(maxDate);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            String minDate = "2000-01-01";
            SearchParam sp1 = new SearchParam(daoService.getTableName(CarparkPassport.class)).setQueryFields(new String[]{"passport_number", "register_plate"}).setOrerbySql("passport_number");
            StringBuilder spw = new StringBuilder(128);
            spw.append(" passport_state = ").append(1);
            if (backListPassportTypeNo != null && !backListPassportTypeNo.isEmpty()) {
                if (backListPassportTypeNo.size() == 1) {
                    spw.append(" OR passport_type_no = '").append((String)backListPassportTypeNo.get(0)).append("'");
                } else {
                    spw.append(" OR passport_type_no IN (");
                    int index = 0;
                    for (String s : backListPassportTypeNo) {
                        if (index > 0) {
                            spw.append(',');
                        }
                        spw.append("'").append(s).append("'");
                        ++index;
                    }
                    spw.append(") ");
                    sp1.addINList("passport_type_no", backListPassportTypeNo);
                }
            }
            sp1.setWhereString(spw.toString());
            List list1 = daoService.selectList(sp1, CarparkPassport.class, null);
            if (list1 != null && !list1.isEmpty()) {
                for (CarparkPassport p : list1) {
                    if (p.getRegister_plate() == null || p.getRegister_plate().length() != 7 && p.getRegister_plate().length() != 8) continue;
                    LinkedHashMap<String, PlateEntry> blackListMap = (LinkedHashMap<String, PlateEntry>)cacheMap0.get("blacklist");
                    if (blackListMap == null) {
                        blackListMap = new LinkedHashMap<String, PlateEntry>();
                        cacheMap0.put("blacklist", blackListMap);
                    }
                    blackListMap.put(p.getRegister_plate(), new PlateEntry(p.getRegister_plate(), minDate, maxDate));
                }
            }
            if (whiltListPassportTypeNo != null && !whiltListPassportTypeNo.isEmpty()) {
                SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassport.class)).setQueryFields(new String[]{"passport_number", "register_plate", "deadline", "start_date", "stop_date", "valid_date", "passport_state", "passport_type_no"}).addNotEQ("passport_state", (Object)1).setOrerbySql("passport_number");
                if (whiltListPassportTypeNo.size() == 1) {
                    sp.addEQ("passport_type_no", whiltListPassportTypeNo.get(0));
                } else {
                    sp.addINList("passport_type_no", whiltListPassportTypeNo);
                }
                List list = daoService.selectList(sp, CarparkPassport.class, null);
                if (list != null && !list.isEmpty()) {
                    for (CarparkPassport p : list) {
                        if (p.getRegister_plate() == null || p.getRegister_plate().length() != 7 && p.getRegister_plate().length() != 8) continue;
                        String startDate = p.getStart_date() != null ? df.format(p.getStart_date()) : minDate;
                        String endDate = p.getPassport_state() == 2 && p.getStop_date() != null ? (p.getStop_date().after(maxDatex) ? maxDate : df.format(p.getStop_date())) : (p.getDeadline() != null ? (p.getDeadline().after(maxDatex) ? maxDate : df.format(p.getDeadline())) : maxDate);
                        LinkedHashMap<String, PlateEntry> whiteListMap = (LinkedHashMap<String, PlateEntry>)cacheMap0.get(p.getPassport_type_no());
                        if (whiteListMap == null) {
                            whiteListMap = new LinkedHashMap<String, PlateEntry>();
                            cacheMap0.put(p.getPassport_type_no(), whiteListMap);
                        }
                        if (startDate.compareTo(endDate) > 0) {
                            startDate = minDate;
                        }
                        whiteListMap.put(p.getRegister_plate(), new PlateEntry(p.getRegister_plate(), startDate, endDate));
                    }
                }
            }
            this.cacheMap = cacheMap0;
            return cacheMap0;
        }
    }

    public int getInterestedOps() {
        return 7;
    }

    public String[] getInterestedTableNames() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        return new String[]{daoService.getTableName(CarparkPassport.class)};
    }

    public void onUpdate(int op, String physicalTableName, Object paramData, int updateCount) throws Exception {
        if (this.cacheMap == null) {
            return;
        }
        ServiceUtil.getServiceContext().delay(new JobTask(){

            protected void doRun() throws Exception {
                DefaultBlackWhiteListCache.this.loadPlateCache();
                DefaultBlackWhiteListCache.this.run();
            }
        }, 3L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PlateEntry> newWhiteListMapFromCache(String channelNo) {
        Map<String, Map<String, PlateEntry>> cacheMap0 = this.cacheMap;
        if (cacheMap0 == null) {
            Object object = this.lock;
            synchronized (object) {
                cacheMap0 = this.cacheMap;
                if (cacheMap0 == null) {
                    cacheMap0 = this.loadPlateCache();
                }
            }
        }
        LinkedHashMap<String, PlateEntry> xmap = new LinkedHashMap<String, PlateEntry>();
        for (Map.Entry<String, Map<String, PlateEntry>> entry : cacheMap0.entrySet()) {
            String v1;
            if ("blacklist".equals(entry.getKey()) || (v1 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channelNo, entry.getKey(), "CHANNEL_PASSTYPE_WHITELIST")) != null && v1.equals(Constants.NO_STR) || entry.getValue() == null) continue;
            xmap.putAll(entry.getValue());
        }
        return xmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PlateEntry> newBlackListMapFromCache(String channelNo) {
        Map<String, Map<String, PlateEntry>> cacheMap0 = this.cacheMap;
        if (cacheMap0 == null) {
            Object object = this.lock;
            synchronized (object) {
                cacheMap0 = this.cacheMap;
                if (cacheMap0 == null) {
                    cacheMap0 = this.loadPlateCache();
                }
            }
        }
        LinkedHashMap<String, PlateEntry> xmap = new LinkedHashMap<String, PlateEntry>();
        Map<String, PlateEntry> x1 = cacheMap0.get("blacklist");
        if (x1 != null && !x1.isEmpty()) {
            xmap.putAll(x1);
        }
        return xmap;
    }

    protected void doRun() throws Exception {
        block26: {
            BlackWhiteListTaskMonitor moniter = this.newBlackWhiteListTaskMonitor();
            moniter.onStartTask();
            try {
                Enumeration<PassChannel> ens;
                boolean enableBlackWhiteList;
                String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CARPARK_BLACKWHITELIST_FUN");
                boolean bl = enableBlackWhiteList = v != null && "1".equals(v);
                if (!enableBlackWhiteList) {
                    if (!this.monitorList.isEmpty()) {
                        moniter.onMessage("\u3010\u8f66\u573a\u7b56\u7565\u3011\u672a\u5f00\u542f\u9ed1\u767d\u540d\u5355\u4e0b\u8f7d\u529f\u80fd! \u4e0d\u518d\u81ea\u52a8\u540c\u6b65\u9ed1\u767d\u540d\u5355\u6570\u636e\u3002");
                    }
                    return;
                }
                if (ServiceUtil.getServiceContext().getPassChannelManager().getChannelSize() == 0 && !this.monitorList.isEmpty()) {
                    moniter.onMessage("\u672c\u673a\u6ca1\u914d\u7f6e\u7ba1\u7406\u901a\u9053! \u4e0d\u518d\u81ea\u52a8\u540c\u6b65\u9ed1\u767d\u540d\u5355\u6570\u636e");
                }
                if ((ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) == null) break block26;
                while (ens.hasMoreElements()) {
                    List<Equipment> list;
                    boolean isDownloadBlackWhiteList;
                    PassChannel channelP = ens.nextElement();
                    String whiv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelP.getChannelNo(), "CHANNEL_BLACKWHITELIST_CAMERA");
                    boolean bl2 = isDownloadBlackWhiteList = whiv == null || "1".equals(whiv) || "2".equals(whiv);
                    if (!isDownloadBlackWhiteList) {
                        if (this.monitorList.isEmpty()) continue;
                        moniter.onMessage("\u901a\u9053\uff1a" + channelP.getChannel().getChannel_name() + " \u5728\u3010\u901a\u9053\u7b56\u7565\u3011\u4e2d\u5173\u95ed\u4e86\u81ea\u52a8\u540c\u6b65\u529f\u80fd\uff0c\u4e0d\u518d\u540c\u6b65\u8be5\u901a\u9053\u4e0b\u7684\u9ed1\u767d\u540d\u5355\u5230\u76f8\u673a!\n");
                        continue;
                    }
                    if ("2".equals(whiv)) {
                        if (!this.monitorList.isEmpty()) {
                            moniter.onMessage("\u901a\u9053\uff1a" + channelP.getChannel().getChannel_name() + " \u5728\u3010\u901a\u9053\u7b56\u7565\u3011\u542f\u7528\u4e86\u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u529f\u80fd\uff0c\u8fd9\u5c06\u68c0\u6d4b\u76f8\u673a\u662f\u5426\u5b58\u5728\u9ed1\u767d\u540d\u5355\uff0c\u5982\u679c\u5b58\u5728\u5c06\u6e05\u9664");
                        }
                    } else if (!this.monitorList.isEmpty()) {
                        moniter.onMessage("\u901a\u9053\uff1a" + channelP.getChannel().getChannel_name() + " \u51c6\u5907\u68c0\u6d4b\u662f\u5426\u6709\u9ed1\u767d\u540d\u5355\u9700\u8981\u540c\u6b65");
                    }
                    if ((list = channelP.getPlateRegCameras()) != null && !list.isEmpty()) {
                        Map<String, PlateEntry> whiteList = null;
                        Map<Object, Object> blackList = null;
                        for (Equipment eq : list) {
                            PlateRegCameraAction action = (PlateRegCameraAction)eq.getEquipmentAction();
                            if (!action.isSupportWhiteList()) {
                                moniter.onMessage("\u901a\u9053\uff1a" + channelP.getChannel().getChannel_name() + " \u8f66\u724c\u8bc6\u522b\u76f8\u673a(" + eq.getIp() + ")\u4e0d\u652f\u6301\u767d\u540d\u5355\u4e0b\u8f7d\uff0c\u5ffd\u7565\u6b64\u76f8\u673a");
                                continue;
                            }
                            if (whiteList == null || blackList == null) {
                                if (whiv != null && "2".equals(whiv)) {
                                    whiteList = new HashMap<String, PlateEntry>();
                                    blackList = new HashMap();
                                } else {
                                    try {
                                        whiteList = this.newWhiteListMapFromCache(channelP.getChannelNo());
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)(String.valueOf(action.getEquipment().getIp()) + ": \u83b7\u53d6\u6570\u636e\u5e93\u767d\u540d\u5355\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                                        moniter.onDownlodException(eq.getEquipmentNo(), ex);
                                        continue;
                                    }
                                    try {
                                        blackList = this.newBlackListMapFromCache(channelP.getChannelNo());
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)(String.valueOf(action.getEquipment().getIp()) + ": \u83b7\u53d6\u6570\u636e\u5e93\u9ed1\u540d\u5355\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                                        moniter.onDownlodException(eq.getEquipmentNo(), ex);
                                        continue;
                                    }
                                }
                            }
                            try {
                                Collection<PlateEntry> blackList0 = blackList.values();
                                if (blackList != null && !blackList.isEmpty() && !action.isSupportBlackList()) {
                                    moniter.onMessage("(" + eq.getIp() + ") \u8b66\u544a: \u8be5\u76f8\u673a\u4e0d\u652f\u6301\u9ed1\u540d\u5355\u4e0b\u8f7d\uff0c\u5ffd\u7565\u9ed1\u540d\u5355\u603b\u6570: " + blackList.size());
                                    blackList0 = Collections.emptyList();
                                }
                                action.downlodAllWhiteBlackList(whiteList.values(), blackList0, moniter);
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)(String.valueOf(action.getEquipment().getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u5f02\u5e38: " + ex.getMessage()));
                            }
                        }
                        continue;
                    }
                    if (this.monitorList.isEmpty()) continue;
                    moniter.onMessage("\u901a\u9053\uff1a" + channelP.getChannel().getChannel_name() + " \u672a\u914d\u7f6e\u4efb\u4f55\u8f66\u724c\u8bc6\u522b\u76f8\u673a\uff0c\u4e0d\u518d\u540c\u6b65\u8be5\u901a\u9053\u4e0b\u7684\u9ed1\u767d\u540d\u5355\u5230\u76f8\u673a!");
                }
            }
            finally {
                moniter.onEndTask();
            }
        }
    }

    @Override
    public void addBlackWhiteListTaskMonitor(BlackWhiteListTaskMonitor monitor) {
        if (monitor != null) {
            String ad = this.downloadingEqNo;
            if (ad != null) {
                monitor.onStartDownlod(ad);
            }
            this.monitorList.add(monitor);
        }
    }

    @Override
    public void removeBlackWhiteListTaskMonitor(BlackWhiteListTaskMonitor monitor) {
        if (monitor != null) {
            this.monitorList.remove(monitor);
        }
    }

    @Override
    public void tryStartDownload() {
        this.run();
    }

    private BlackWhiteListTaskMonitor newBlackWhiteListTaskMonitor() {
        return new BlackWhiteListTaskMonitor(){

            @Override
            public void onCheck(String cameraNo, boolean reCheck) {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onCheck(cameraNo, reCheck);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onQueryAll(String cameraNo) {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onQueryAll(cameraNo);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onQueryAllFinish(String cameraNo, int cameraWhiteCount, int cameraBlackCount, int chanalWhiteCount, int channelWhiteCout) {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onQueryAllFinish(cameraNo, cameraWhiteCount, cameraBlackCount, chanalWhiteCount, channelWhiteCout);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onCheckReusult(String cameraNo, int iWCount, int uWCount, int dWcount, int sWcount, int iBCount, int uBCount, int dBcount, int sBCount, boolean reCheck) {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onCheckReusult(cameraNo, iWCount, uWCount, dWcount, sWcount, iBCount, uBCount, dBcount, sBCount, reCheck);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onStartDownlod(String cameraNo) {
                DefaultBlackWhiteListCache.this.downloadingEqNo = cameraNo;
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onStartDownlod(cameraNo);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onFinishDownlod(String cameraNo, Collection<PlateEntry> whiteTotal, Collection<PlateEntry> blackTotal, Collection<PlateEntry> whiteSuccess, Collection<PlateEntry> whiteFaild, Collection<PlateEntry> blackSuccess, Collection<PlateEntry> blackFaild) {
                DefaultBlackWhiteListCache.this.downloadingEqNo = null;
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onFinishDownlod(cameraNo, whiteTotal, blackTotal, whiteSuccess, whiteFaild, blackSuccess, blackFaild);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onDownlodException(String cameraNo, Exception ex1) {
                DefaultBlackWhiteListCache.this.downloadingEqNo = null;
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onDownlodException(cameraNo, ex1);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onStartTask() {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onStartTask();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onEndTask() {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onEndTask();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            @Override
            public void onMessage(String msg) {
                for (BlackWhiteListTaskMonitor m : DefaultBlackWhiteListCache.this.monitorList) {
                    try {
                        if (m == this) continue;
                        m.onMessage(msg);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        };
    }
}

